package com.thebeastshop.pegasus.channelservice.adapter.product;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.*;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pcs.sservice.SPrdcJobService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsBrandVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.product.PreSellVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SpvVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;
import com.thebeastshop.support.vo.product.SpvVO.FlashSaleVO;
import com.thebeastshop.support.vo.product.SpvVO.Quota;
import com.thebeastshop.wms.vo.WhRecipeInvVO;

/**
 * spv适配器（价格计算服务接入用）
 * 
 * @author Wang Yawei
 *
 */
@Component
public class SpvPriceAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private SpvCommonAdapter spvCommonAdapter;

	@Autowired
	private SPrdcJobService sPrdcJobService;

	public Map<PsSpvVO, SpvVO> getSpvMapWithSpvPrice(Collection<PsSpvVO> spvs, Map<String, PsProductVO> productsMap,
			MemberVO member, OpChannelVO opChannel, Map<String, Date> spvPresaleDateMap) {
		Date start = new Date();
		Map<PsSpvVO, SpvVO> map = Maps.newLinkedHashMap();

		if (CollectionUtils.isNotEmpty(spvs)) {
			if (spvPresaleDateMap == null) {
				spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);
			}

			Map<Long, PrsSpvPriceStepVO> spvPriceMap = new HashMap();
			// if(CollectionUtils.isNotEmpty(spvPriceList)){
			// for (PrsSpvPriceStepVO prsSpvPriceStepVO : spvPriceList) {
			// spvPriceMap.put(prsSpvPriceStepVO.getSpvId(),prsSpvPriceStepVO);
			// }
			// }

			for (PsSpvVO spv : spvs) {
				PsProductVO product = productsMap.get(spv.getProductId().toString());
				List<PsSkuVO> skuList = new ArrayList<>();
				SpvVO spvVo = new SpvVO();
				// 设置组合搭配展示信息
				if(BooleanUtils.toBoolean(product.getDisplayInCombinedArea())){
					spvVo.setCombinedSingleSpvs(this.getSpvCombinedSingleList(spv));
					spvVo.setCombination(Boolean.TRUE);
				}
				spvVo.setId(spv.getSpvId());
				// featureImage
				String featureImage = product.getPicList();
				if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
					featureImage = FileConstant.BASE_URL + featureImage;
				}
				spvVo.setImage(featureImage);
				// brand
				List<PsBrandVO> brands = product.getBrands();
				if (CollectionUtils.isNotEmpty(brands)) {
					PsBrandVO brand = brands.get(0);
					if (brand != null) {
						BrandVO brandVO = new BrandVO();
						brandVO.setId(brand.getBrandId());
						brandVO.setName(brand.getBrandNameCN());
						spvVo.setBrand(brandVO);
					}
				}
				// name
				spvVo.setName(product.getNameCn());
				// description
				StringBuilder sb = new StringBuilder();
				List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
				if (CollectionUtils.isNotEmpty(attrList)) {
					for (PsAttributeValuePairVO attr : attrList) {
						if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
								&& StringUtils.isNotBlank(attr.getValue()))
							sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
					}
				}
				spvVo.setSpvDesc(sb.toString());

				if (product.getCombined()) {

					// logger.info("prod:"+product.getCode());
					//
					// logger.info("spv.getOriginalPrice():"+spv.getOriginalPrice());

					// price
					spvVo.setRawPrice(spv.getOriginalPrice());
				} else {
					// price
					spvVo.setRawPrice(spv.getSalesPrice());
				}

				// PrsSpvPriceStepVO spvPriceStepVO =
				// spvPriceMap.get(spv.getSpvId());
				// if(spvPriceStepVO != null){
				// spvVo.setPrice(spvPriceMap.get(spv.getSpvId()).getSpvPrice());
				// spvVo.setPoint(spvPriceMap.get(spv.getSpvId()).getPoints());
				// }else{
				// spvVo.setPrice(spv.getSalesPrice()));
				// spvVo.setPoint(0);
				// }

				// product code
				spvVo.setProductCode(spv.getProductCode());
				// skuCodes
				List<String> skuCodes = Lists.newArrayList();
				if (spv.getCombined()) {
					for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
						skuCodes.add(sku.getSubSkuCode());
						skuList.add(sku.getSubSkuVO());
					}
				} else {
					skuCodes.add(spv.getSkuCode());
					skuList.add(spv.getSkuVO());
				}
				spvVo.setSkuCodes(skuCodes);
				// 是否组合
				spvVo.setCombined(spv.getCombined());
				// spv库存数量
				spvVo.setLeft(spv.getCanUseQuantity());
				// 最小起售数
				Integer minAmount = spv.getMinAmount();
				if (minAmount != null) {
					spvVo.setMinAmount(minAmount);
				} else {
					spvVo.setMinAmount(1);
				}

				// XXX:预售信息(海淘商品或者组合商品不显示预售信息)
				PreSellVO presell = spvCommonAdapter.getPresell(product, skuList, spvPresaleDateMap, spv, opChannel);
				if (null != presell) {
					spvVo.setPresell(presell);
				} else {
					spvVo.setPresell(null);
				}
				// discount
				DiscVO disc = new DiscVO();
				// 默认为初始等级
				Integer memL = -1;
				if (member != null) {
					memL = member.getMemberLevel();
				}

				MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(memL);
				if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
						&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
						&& product.getAllowVipDiscount() == 1) {
					disc.setVipLevel(memberLevel.getCode().toString());
				}
				disc.setBirthday(false);
				if (member.isInBdayDiscountTime()) {
					if (null != product.getAllowBdDiscount() && product.getAllowBdDiscount() == 1) {
						disc.setBirthday(true);
						disc.setVipLevel(null);
					}
				}

				// 抢购
				FlashSaleVO flashSale = new FlashSaleVO();
				List<PsCampaignVO> campList = spv.getCampaignList();
				if (null != campList && campList.size() > 0) {
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId() == 6) {

							Date expire = camp.getExpireTime();
							if (null != expire) {
								String dateExp = DateUtil.format(expire, DateUtil.DEFAULT_DATETIME_FORMAT);
								Timestamp ts = new Timestamp(System.currentTimeMillis());
								try {
									ts = Timestamp.valueOf(dateExp);
									flashSale.setExpiresAt(ts);
									disc.setVipLevel(null);
									disc.setBirthday(false);
								} catch (Exception e) {
									e.printStackTrace();
								}
							} else {
								flashSale.setExpiresAt(null);
							}
							flashSale.setSoldOut(true);
							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(camp.getCode());
							campaignStreamVO.setSkuCode(spv.getSkuCode());
							campaignStreamVO.setMemberCode(member.getCode());
							ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
							Integer stock = resp.getBean();

							if (stock == null) {
								stock = 0;
							}

							// 库存为-1时表示不限量，去查询原有库存
							if (stock.compareTo(-1) == 0) {
								if (spv.getCanUseQuantity() != null && spv.getCanUseQuantity() > 0) {
									flashSale.setSoldOut(false);
								}
							} else {

								if (spvVo.getLeft() > stock) {
									spvVo.setLeft(stock);
								}

								if (spvVo.getLeft().compareTo(0) > 0) {
									flashSale.setSoldOut(false);
								}
							}
							spvVo.setFlashSale(flashSale);

							// 判断是否有抢购限量
							if (camp.getLimitAmount() != null && camp.getLimitAmount() > 0) {
								Quota quta = new Quota();
								quta.setTotal(camp.getLimitAmount());
								if (member != null) {
									CampaignStreamVO campStream = new CampaignStreamVO();
									campStream.setSkuCode(spvVo.getSkuCodes().get(0));
									campStream.setCampaignCode(camp.getCode());
									campStream.setMemberCode(member.getCode());
									ServiceResp<Integer> leftResp = campaignLimitService
											.getPanicPerUserLeftAmount(campStream);
									Integer left = leftResp.getBean();
									if (left == null) {
										left = 0;
									}

									// SPreparedStockQueryDTO dto = new
									// SPreparedStockQueryDTO();
									// dto.setSkuCode(spv.getSkuCode());
									// dto.setBusinessCode(camp.getCode());
									// dto.setWarehouseCode(opChannel.getWarehouseForSales());
									// dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
									// // 这里暂时不支付抢购
									// SPreparedStockVO sPreparedStockVO =
									// sStockService.getPreparedQuantity(dto);

									if (left != null && left == -1) {

										quta.setLeft(spv.getCanUseQuantity());

									} else {

										if (spv.getCanUseQuantity() > left) {
											quta.setLeft(left);
										} else {
											quta.setLeft(spv.getCanUseQuantity());
										}

									}

								}

								spvVo.setQuota(quta);
							}
							break;
						}
					}
				}

				spvVo.setDiscount(disc);
				map.put(spv, spvVo);
			}
		}
		Date end = new Date();
		logger.info("方法getSpvByBirthday花费时间：{}毫秒", end.getTime() - start.getTime());
		return map;
	}

	public Map<Long, SpvVO> getSpvPrice(Collection<PsSpvVO> spvs, Collection<PsProductVO> products, MemberVO member,
			OpChannelVO opChannel, Map<String, Date> spvPresaleDateMap, Map<Long, BigDecimal> spvPriceMap) {
		Date start = new Date();
		Map<Long, SpvVO> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			// ================product map===============
			Map<String, PsProductVO> productsMap = Maps.newHashMapWithExpectedSize(products.size());
			// ================presaleDate map===============
			// Map<PsSpvVO, Date> spvPresaleDateMap = mapSpvPresale(spvs);

			if (spvPresaleDateMap == null) {
				spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);
			}

			for (PsProductVO product : products) {
				productsMap.put(product.getId(), product);
			}
			for (PsSpvVO spv : spvs) {
				PsProductVO product = productsMap.get(spv.getProductId().toString());

				SpvVO spvVo = new SpvVO();
				// 设置组合搭配展示信息
				if(BooleanUtils.toBoolean(product.getDisplayInCombinedArea())){
					spvVo.setCombinedSingleSpvs(this.getSpvCombinedSingleList(spv));
					spvVo.setCombination(Boolean.TRUE);
				}
				spvVo.setId(spv.getSpvId());
				// featureImage
				String featureImage = product.getPicList();
				if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
					featureImage = FileConstant.BASE_URL + featureImage;
				}
				spvVo.setImage(featureImage);
				// brand
				List<PsBrandVO> brands = product.getBrands();
				if (CollectionUtils.isNotEmpty(brands)) {
					PsBrandVO brand = brands.get(0);
					if (brand != null) {
						BrandVO brandVO = new BrandVO();
						brandVO.setId(brand.getBrandId());
						brandVO.setName(brand.getBrandNameCN());
						spvVo.setBrand(brandVO);
					}
				}
				// name
				spvVo.setName(product.getNameCn());
				// description
				StringBuilder sb = new StringBuilder();
				List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
				if (CollectionUtils.isNotEmpty(attrList)) {
					for (PsAttributeValuePairVO attr : attrList) {
						if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
								&& StringUtils.isNotBlank(attr.getValue()))
							sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
					}
				}
				spvVo.setSpvDesc(sb.toString());
				// price
				// spvVo.setRawPrice(spv.getSalesPrice()));
				if (product.getCombined()) {
					// price
					spvVo.setRawPrice(spv.getOriginalPrice());
				} else {
					// price
					spvVo.setRawPrice(spv.getSalesPrice());
				}

				BigDecimal discountPrice = spvPriceMap.get(spv.getSpvId());

				spvVo.setPrice(discountPrice);
				// product code
				spvVo.setProductCode(spv.getProductCode());

				// spv库存数量
				if (Integer.valueOf(1).equals(opChannel.getChannelType())) {
					spvVo.setLeft(spv.getCanUseQuantityOffLine());
				} else {
					spvVo.setLeft(spv.getCanUseQuantity());
				}
				// skuCodes
				List<PsSkuVO> skuList = new ArrayList<>();
				List<String> skuCodes = Lists.newArrayList();
				if (spv.getCombined()) {
					for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
						skuCodes.add(sku.getSubSkuCode());
						skuList.add(sku.getSubSkuVO());
					}
				} else {
					skuCodes.add(spv.getSkuCode());
					skuList.add(spv.getSkuVO());

					// 判断是否是定制配方商品
					if (spv.getSkuVO() != null && spv.getSkuVO().getCanCustomize() != null
							&& spv.getSkuVO().getCanCustomize() == 1 && opChannel.getChannelType() != 1) {

						Map<String, WhRecipeInvVO> whReipeInvVOMaps = new HashMap<>();
						if (skuCodes.size() > 0) {
							whReipeInvVOMaps.putAll(sPrdcJobService.caculateRecipeAmountForAssemble(skuCodes,
									opChannel.getWarehouseForSales()));
						}

						WhRecipeInvVO whRecipeInvVO = whReipeInvVOMaps.get(spv.getSkuVO().getSkuCode());
						if (whRecipeInvVO != null && whRecipeInvVO.isRecipeExist() == true) {

							// spv库存数量
							spvVo.setLeft(whRecipeInvVO.getCanUseInv());

						}

					}
				}
				spvVo.setSkuCodes(skuCodes);
				// 是否组合
				spvVo.setCombined(spv.getCombined());

				// 最小起售数
				Integer minAmount = spv.getMinAmount();
				if (minAmount != null) {
					spvVo.setMinAmount(minAmount);
				} else {
					spvVo.setMinAmount(1);
				}
				// XXX:预售信息(海淘商品或者组合商品不显示预售信息)
				PreSellVO presell = spvCommonAdapter.getPresell(product, skuList, spvPresaleDateMap, spv, opChannel);
				if (null != presell) {
					spvVo.setPresell(presell);
				} else {
					spvVo.setPresell(null);
				}
				// discount
				DiscVO disc = new DiscVO();
				Integer mbLevel = -1;
				if (member != null) {

					mbLevel = member.getMemberLevel();

				}
				MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(mbLevel);
				if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
						&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
						&& product.getAllowVipDiscount() == 1) {
					disc.setVipLevel(memberLevel.getCode().toString());
				}
				disc.setBirthday(false);
				if (member != null && member.isInBdayDiscountTime()) {

					// 生日折扣改价格
					if (product.getAllowBdDiscount() == 1) {
						disc.setBirthday(true);
						disc.setVipLevel(null);
					}
				}
				// 抢购
				FlashSaleVO flashSale = new FlashSaleVO();
				List<PsCampaignVO> campList = spv.getCampaignList();
				if (null != campList && campList.size() > 0) {
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId() == 6) {

							Date expire = camp.getExpireTime();
							if (null != expire) {
								String dateExp = DateUtil.format(expire, DateUtil.DEFAULT_DATETIME_FORMAT);
								Timestamp ts = new Timestamp(System.currentTimeMillis());
								try {
									ts = Timestamp.valueOf(dateExp);
									flashSale.setExpiresAt(ts);
									disc.setVipLevel(null);
									disc.setBirthday(false);
								} catch (Exception e) {
									e.printStackTrace();
								}
							} else {
								flashSale.setExpiresAt(null);
							}
							flashSale.setSoldOut(true);
							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(camp.getCode());
							campaignStreamVO.setSkuCode(spv.getSkuCode());
							campaignStreamVO.setMemberCode(member.getCode());
							ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
							Integer stock = resp.getBean();
							if (stock == null) {
								stock = 0;
							}
							// 库存为-1时表示不限量，去查询原有库存
							if (null != stock && stock.compareTo(-1) == 0) {
								if (spv.getCanUseQuantity() > 0) {
									flashSale.setSoldOut(false);
								}
							} else {

								if (!product.getCombined()) {
									// SPreparedStockQueryDTO dto = new
									// SPreparedStockQueryDTO();
									// dto.setSkuCode(spvVo.getSkuCodes().get(0));
									// dto.setBusinessCode(camp.getCode());
									// dto.setWarehouseCode(opChannel.getWarehouseForSales());
									// dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
									// // 这里暂时不支付抢购
									// SPreparedStockVO sPreparedStockVO =
									// sStockService.getPreparedQuantity(dto);

									// if (sPreparedStockVO != null) {
									// spvVo.setLeft(sPreparedStockVO.getPreparedQuantity());
									// }

									if (spvVo.getLeft() > stock) {
										spvVo.setLeft(stock);
									}

									if (spvVo.getLeft().compareTo(0) > 0) {
										flashSale.setSoldOut(false);
									}
								}

							}
							spvVo.setFlashSale(flashSale);
							// 判断是否有抢购限量
							if (camp.getLimitAmount() != null && camp.getLimitAmount() > 0) {
								Quota quta = new Quota();
								quta.setTotal(camp.getLimitAmount());

								if (member != null) {
									CampaignStreamVO campStream = new CampaignStreamVO();
									campStream.setSkuCode(spvVo.getSkuCodes().get(0));
									campStream.setCampaignCode(camp.getCode());
									campStream.setMemberCode(member.getCode());
									ServiceResp<Integer> leftResp = campaignLimitService
											.getPanicPerUserLeftAmount(campStream);
									Integer left = leftResp.getBean();
									if (left == null) {
										left = 0;
									}
									quta.setLeft(left);
								}

								spvVo.setQuota(quta);
							}

							break;
						}
					}
				}

				spvVo.setDiscount(disc);
				map.put(spv.getSpvId(), spvVo);
			}
		}
		Date end = new Date();
		logger.info("方法getSpvWithoutDiscount花费时间：{}毫秒", end.getTime() - start.getTime());
		return map;
	}

	/**
	 * 组合商品单品列表
	 * @param psSpvVO
	 * @return
	 */
	private List<SpvVO> getSpvCombinedSingleList(PsSpvVO psSpvVO){
		List<SpvVO> spvs = Lists.newArrayList();
		if(psSpvVO.getCombined() && CollectionUtils.isNotEmpty(psSpvVO.getSkuCombinationList())){
			for (PsSkuCombinationVO psSkuCombinationVO : psSpvVO.getSkuCombinationList()) {
				PsSkuVO psSkuVO = psSkuCombinationVO.getSubSkuVO();
				SpvVO spvVO = new SpvVO();
				spvVO.setMinAmount(psSkuCombinationVO.getQuantity());
				spvVO.setName(psSkuVO.getSkuNameCN());
				spvVO.setRawPrice(BigDecimal.valueOf(psSkuVO.getSalesPrice()));
				// featureImage
				String image = psSkuVO.getSkuImg();
				if (StringUtils.isNotBlank(image) && !image.startsWith(FileConstant.BASE_URL)) {
					image = FileConstant.BASE_URL + image;
				}
				spvVO.setImage(image);

				SpvVO.BrandVO brand= new BrandVO();
				brand.setName(psSkuVO.getBrandName());
				brand.setId(psSkuVO.getBrandId());
				spvVO.setBrand(brand);

				String skuAttrs = psSkuCombinationVO.getAttrs();
				List<PsAttributeValuePairVO> attrList = psSpvVO.getAttributeValuePairList();
				if(StringUtils.isNotBlank(skuAttrs) && CollectionUtils.isNotEmpty(attrList)){
					StringBuilder sb = new StringBuilder();
					for (PsAttributeValuePairVO attr : attrList) {
						if(skuAttrs.contains(attr.getAttrId()+"")&&skuAttrs.contains(attr.getAttrValueId()+""))
							sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
					}
					spvVO.setSpvDesc(sb.toString());
				}
				spvVO.setSkuCodes(Lists.newArrayList(psSkuVO.getSkuCode()));
				spvs.add(spvVO);
			}
		}
		// 按价格由低到高排序
		Collections.sort(spvs, new Comparator<SpvVO>() {
			@Override
			public int compare(SpvVO o1, SpvVO o2) {
				return o1.getRawPrice().compareTo(o2.getRawPrice());
			}
		});
		return spvs;
	}

}
