package com.thebeastshop.pegasus.channelservice.adapter.product;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.service.operation.vo.CustomizeTypeVO;
import com.thebeastshop.support.enums.Customize.CustomizeMode;
import com.thebeastshop.support.enums.Customize.DimensionType;
import com.thebeastshop.support.enums.Customize.LimitType;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.customize.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.regex.Pattern;

/**
 * spv定制适配
 * <p>
 * Created by feilong.gao on 2017/1/12.
 */
@Component
public class SpvCustomizeAdapter {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private RedisClient redisClient;

	/**
	 * 根据spvId获取定制信息
	 *
	 * @param spvId
	 * @return
	 */
	public SpvCustomizeDetails getSpvCustomizeInfo(Long spvId) {
		SpvCustomizeDetails result = new SpvCustomizeDetails();
		// result = redisClient.getCache(getCustomizeKeyByRedis(spvId));
		// if (null != result) {
		// logger.info("取出spvid={}的定制缓存信息：{}", spvId, result);
		// return result;
		// }
		PsSpvVO psSpvVO = mcPsSpvService.findBySpvId(spvId);
		if (psSpvVO.getCombined()) {
			logger.warn("定制商品暂不支持获取定制信息");
		} else {
			PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(psSpvVO.getSkuCode());
			result = this.convertPsSku2SpvCustomizeDetails(psSkuVO, spvId);
			logger.info("设置出spvid={}的定制缓存信息：{} ttl={}", spvId, result, 60 * 5);
			redisClient.putCache(getCustomizeKeyByRedis(spvId), result, 60 * 5L);
		}
		return result;
	}

	/**
	 * 获取定制费(非定制商品价格)
	 * 
	 * @param skuCode
	 * @return
	 */
	public BigDecimal getCustomizePriceBySkuCode(String skuCode) {
		BigDecimal result = BigDecimal.ZERO;
		result = redisClient.getCache(getCustomizepPriceKeyByRedis(skuCode));
		if (result == null) {
			PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(skuCode);
			if (null != psSkuVO) {

				if (psSkuVO.getCustomizationPrice() != null) {
					result = psSkuVO.getCustomizationPrice();
				} else {
					result = BigDecimal.ZERO;
				}
				redisClient.putCache(getCustomizepPriceKeyByRedis(skuCode), result, 60 * 5L);
			}
		}
		return result;

	}

	public boolean checkWordLimit(Long spvId, List<CartCustomization> cartCustomizes) {
		boolean flag = true;
		SpvCustomizeDetails spvCustomizeDetails = this.getSpvCustomizeInfo(spvId);

		Map<String, InputLimit> limitMap = new HashMap<>();

		if (spvCustomizeDetails != null && spvCustomizeDetails.getDimensions() != null) {
			for (CustomDimension customDimension : spvCustomizeDetails.getDimensions()) {
				if (DimensionType.DIMENSION_TYPE_INPUT.getCode().equals(customDimension.getType())) {
					InputLimit inputLimit = customDimension.getLimit();
					if (inputLimit != null) {
						if (CollectionUtils.isNotEmpty(inputLimit.getType())
								|| !NumberUtil.isNullOrZero(inputLimit.getMaxLength())) {
							limitMap.put(customDimension.getCode(), inputLimit);
						}
					}
				}
			}
		}

		for (CartCustomization cartCustomize : cartCustomizes) {
			if (limitMap.containsKey(cartCustomize.getCustomDimensionId())
					&& StringUtils.isNotEmpty(cartCustomize.getCustomDimensionValue())) {
				String maxLengthStr = cartCustomize.getCustomDimensionValue();
				InputLimit inputLimit = limitMap.get(cartCustomize.getCustomDimensionId());
				String wordValue = cartCustomize.getCustomDimensionValue();
				if (CollectionUtils.isNotEmpty(inputLimit.getType())) {

					if (wordValue != null) {
						String regStr = wordValue;
						maxLengthStr = wordValue.replace("[[love]]", "-").replace("[[smile]]", "-")
								.replace("[[arrowheart]]", "-").replace("[[lbphone]]", "-").replace("[[lbbulb]]", "-")
								.replace("[[lbairplane]]", "-").replace("[[lbsunglasses]]", "-")
								.replace("[[lbflash]]", "-").replace("[[lbstar]]", "-").replace("[[lbbicycle]]", "-")
								.replace("[[lbboy]]", "-").replace("[[lbgirl]]", "-").replace("[[lbok]]", "-").replace("[[bromel]]", "-");
						String regEx = LimitType.getRegEx(inputLimit.getType());
						flag = Pattern.compile(regEx.toString()).matcher(regStr).find();
					}
				}
				if (!NumberUtil.isNullOrZero(inputLimit.getMaxLength())
						&& inputLimit.getMaxLength() < maxLengthStr.length()) {
					flag = false;
				}
			}
		}
		return flag;
	}

	/**
	 * ES返回商品sku信息解析为前端展示定制信息
	 *
	 * @param psSkuVO
	 * @param spvId
	 * @return
	 */
	private SpvCustomizeDetails convertPsSku2SpvCustomizeDetails(PsSkuVO psSkuVO, Long spvId) {
		SpvCustomizeDetails result = new SpvCustomizeDetails();
		result.setSpvId(spvId);
		if (null != psSkuVO) {
			result.setCharge(psSkuVO.getCustomizationPrice());

			List<CustomDimension> dimensions = Lists.newArrayList();

			Map<String, CustomDimension> previewDimensionMap = new HashMap<>();
			if (null != psSkuVO.getCanCustomize() && psSkuVO.getCanCustomize() == 1) {

				PcsCustomizeElementCacheVO elementCacheVO = psSkuVO.getPcsCustomizeElementCacheVO();
				// 1 获取 bodyElement
				List<PcsCustomizeElementVO> bodyEle = elementCacheVO.getElementList();
				List<CustomDimension> bodyDimensions = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(bodyEle)) {
					bodyDimensions = this.getDimensionByBody(bodyEle);
				}
				dimensions.addAll(bodyDimensions);

				// 2 获取 inputColor元素
				List<PcsCustomizeImageVO> imageVOS = elementCacheVO.getCustomizeImageList();
				if (CollectionUtils.isNotEmpty(imageVOS)) {
					List<CustomDimension> textCustomDimensions = this.getDimensionByText(imageVOS);
					dimensions.addAll(textCustomDimensions);
				}

				result.setDimensions(dimensions);
				// 3.设置视图
				CustomPreview preview = getCustomPreview(bodyDimensions, imageVOS);
				result.setPreview(preview);
				result.setDays(getCustomizePlanedDeliveryDate(psSkuVO));
			}
		}
		return result;
	}

	public Integer getCustomizePlanedDeliveryDate(PsSkuVO psSkuVO) {
		// 定制且来单商品设计他的预计发货天数
		int days = psSkuVO.getDeliveryPeriod();
		int lastDay = 0;
		if (psSkuVO.getIsJit() != null && psSkuVO.getIsJit() == 1) {

			String[] ctype = new String[] {};
			if (StringUtils.isNotEmpty(psSkuVO.getCustomizeType())) {

				ctype = psSkuVO.getCustomizeType().split(",");

				for (String type : ctype) {
					// 如果redis里已存在。侧根据取到的日期计算，如查没有就只加交货天数
					CustomizeTypeVO customizeTypeVO = redisClient
							.getCache("customizeType_" + type);

					if (customizeTypeVO != null) {
						logger.info("配方商品预计发货日期:" + DateUtil.format(customizeTypeVO.getPlanedDeliveryDate(),
								DateUtil.DEFAULT_DATE_FORMAT));
						Date date = new Date();
						if (psSkuVO.getDeliveryPeriod() == null) {
							psSkuVO.setDeliveryPeriod(0);
						}
						// 哪果redis里的时间比较旧，就只加交货天数
						if (customizeTypeVO.getPlanedDeliveryDate().getTime() > date.getTime()) {
							try {
								int differenceDay = DateUtil.daysBetween(date, customizeTypeVO.getPlanedDeliveryDate());
								if (lastDay < differenceDay) {
									lastDay = differenceDay;
								}
							} catch (ParseException e) {

								logger.error(e.getMessage());
							}
						}
					}
				}

				days = days + lastDay;
			}

		}

		return days;

	}

	/**
	 * 定制信息KEY根据spvid获取
	 * 
	 * @param spvId
	 * @return
	 */
	private String getCustomizeKeyByRedis(Long spvId) {
		String prefix = "CS_CUSTOMIZE_SPVID";
		StringBuffer sb = new StringBuffer();
		sb.append(prefix).append(":").append(spvId);
		return sb.toString();
	}

	/**
	 * 定制价格KEY根据skuCode获取
	 * 
	 * @param skuCode
	 * @return
	 */
	private String getCustomizepPriceKeyByRedis(String skuCode) {
		String prefix = "CS_CUSTOMIZE_PRICE";
		StringBuffer sb = new StringBuffer();
		sb.append(prefix).append(":").append(skuCode);
		return sb.toString();
	}

	/**
	 * 转换bodyElement
	 * 
	 * @param elements
	 * @return
	 */
	private List<CustomDimension> getDimensionByBody(List<PcsCustomizeElementVO> elements) {
		List<CustomDimension> dimensions = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(elements)) {
			for (PcsCustomizeElementVO element : elements) {
				CustomDimension customDimension = new CustomDimension();
				customDimension.setCode(element.getId().toString());
				customDimension.setName(element.getDisplayName());
				if (null != element.getPositionIcon()) {
					customDimension.setIcon(FileConstant.BASE_URL + element.getPositionIcon());
				}
				customDimension.setType(DimensionType.DIMENSION_TYPE_SELECT.getCode());
				customDimension.setMode(CustomizeMode.BODY);
				customDimension.setHidden(!element.isWhetherShow()); // 展示为ture
																		// 则
																		// hidden为false
				if (CollectionUtils.isNotEmpty(element.getColorList())) {
					List<CustomChoice> customChoices = Lists.newArrayList();

					for (PcsCustomizeColorVO color : element.getColorList()) {
						RelevantColors relevant = new RelevantColors(color.getWordColorValue(),
								color.getBackgroundColorValue());
						CustomChoice customChoice = new CustomChoice(color.getColorName(), color.getColorValue(),
								relevant);
						customChoices.add(customChoice);
					}
					customDimension.setChoices(customChoices);
				}
				dimensions.add(customDimension);
			}
		}
		return dimensions;
	}

	/**
	 * 文本元素转换
	 * 
	 * @param elements
	 * @return
	 */
	private List<CustomDimension> getDimensionByText(List<PcsCustomizeImageVO> elements) {
		List<CustomDimension> dimensions = new ArrayList<>();
		if (CollectionUtils.isEmpty(elements)) {
			return dimensions;
		}
		for (PcsCustomizeImageVO pcsCustomizeImageVO : elements) {
			List<PcsCustomizeImageSetVO> imageSet = pcsCustomizeImageVO.getImages();
			for (PcsCustomizeImageSetVO imageSetVO : imageSet) {

				for (int i = 0; i < imageSetVO.getCustomizeImagePositions().size(); i++) {
					PcsCustomizeImageWordColorVO wordColorVO = imageSetVO.getCustomizeImageWordColor();
					CustomDimension colorCustomDimension = new CustomDimension();
					colorCustomDimension
							.setCode(this.getWordDimensionCode(CustomizeMode.TEXT_COLOR, imageSetVO.getImageId(), i));
					colorCustomDimension.setImageId(imageSetVO.getImageId());
					colorCustomDimension.setPositionIndex(i);
					colorCustomDimension
							.setPositionName(imageSetVO.getCustomizeImagePositions().get(i).getPositionName());
					colorCustomDimension.setName(wordColorVO.getIconText());
					if (null != wordColorVO.getIcon()) {
						colorCustomDimension.setIcon(FileConstant.BASE_URL + wordColorVO.getIcon());
					}
					colorCustomDimension.setHidden(!wordColorVO.isWhetherShow());
					colorCustomDimension.setType(DimensionType.DIMENSION_TYPE_SELECT.getCode());
					colorCustomDimension.setMode(CustomizeMode.TEXT_COLOR);
					List<PcsCustomizeColorVO> colorVOS = wordColorVO.getImgWordColorList();
					if (CollectionUtils.isNotEmpty(colorVOS)) {
						List<CustomChoice> customChoices = Lists.newArrayList();

						for (PcsCustomizeColorVO color : colorVOS) {
							CustomChoice customChoice = new CustomChoice(color.getColorName(), color.getColorValue(),color.getIconColorValue());
							customChoices.add(customChoice);
						}
						colorCustomDimension.setChoices(customChoices);
					}

					PcsCustomizeImageWordContentVO wordContent = imageSetVO.getCustomizeImageWordContent();

					CustomDimension wordCustomDimension = new CustomDimension();
					wordCustomDimension
							.setCode(this.getWordDimensionCode(CustomizeMode.TEXT_INPUT, imageSetVO.getImageId(), i));
					wordCustomDimension.setImageId(imageSetVO.getImageId());
					wordCustomDimension.setPositionIndex(i);
					wordCustomDimension
							.setPositionName(imageSetVO.getCustomizeImagePositions().get(i).getPositionName());
					wordCustomDimension.setName(wordContent.getIconText());
					if (null != wordContent.getIcon()) {
						wordCustomDimension.setIcon(FileConstant.BASE_URL + wordContent.getIcon());
					}
					wordCustomDimension.setHidden(!wordContent.isWhetherShow());
					wordCustomDimension.setType(DimensionType.DIMENSION_TYPE_INPUT.getCode());
					wordCustomDimension.setMode(CustomizeMode.TEXT_INPUT);
					List<LimitType> types = new ArrayList<>();
					List<PcsCustomizeContentTypeVO> contentTypeList = wordContent.getCustomizeContentTypeList();
					for (PcsCustomizeContentTypeVO contentTypeVO : contentTypeList) {
						types.add(LimitType.getLimitTypeByCode(contentTypeVO.getTypeCode()));
					}

					if (null != imageSetVO.getCustomizeImagePositions().get(i).getPositionType()
							&& imageSetVO.getCustomizeImagePositions().get(i).getPositionType() == 2) {// 订单日期不校验
						wordCustomDimension.setLimit(null);

					} else {
						InputLimit inputLimit = new InputLimit(types, wordContent.getWordLimit().intValue(),
								wordContent.getEnglishFont(), wordContent.getDigitalFont());
						wordCustomDimension.setLimit(inputLimit);
					}
					dimensions.add(colorCustomDimension);
					dimensions.add(wordCustomDimension);
				}

			}
		}

		return dimensions;
	}

	/**
	 * 获取视图
	 * 
	 * @param dimensions
	 * @param images
	 * @return
	 */
	private CustomPreview getCustomPreview(List<CustomDimension> dimensions, List<PcsCustomizeImageVO> images) {
		CustomPreview preview = new CustomPreview();
		if (CollectionUtils.isNotEmpty(images)) {
			Map<String, CustomDimension> previewMap = new HashMap<>();
			for (CustomDimension body : dimensions) {
				previewMap.put(body.getCode(), body);
			}
			List<CustomPreviewImage> previewImages = Lists.newArrayList();
			List<Long> previewDimensions = Lists.newArrayList();

			// 获取图片匹配元素集合
			PcsCustomizeImageVO psCustomizeImageVO = images.get(0);
			for (List aa : psCustomizeImageVO.getAttrs()) {
				previewDimensions.add(Long.parseLong(aa.get(0).toString()));
			}

			for (PcsCustomizeImageVO image : images) {
				CustomPreviewImage customPreviewImage = new CustomPreviewImage();
				List<Long> group = Lists.newArrayList();
				for (List bb : image.getAttrs()) {
					CustomDimension cd = previewMap.get(bb.get(0).toString());
					for (int i = 0; i < cd.getChoices().size(); i++) {
						if (cd.getChoices().get(i).getName().equalsIgnoreCase(bb.get(1).toString())) {
							group.add(Long.parseLong(i + ""));
							break;
						}
					}
				}
				customPreviewImage.setGroup(group);
				customPreviewImage.setImages(convertByCustomizeImageSet(image.getImages()));
				previewImages.add(customPreviewImage);
			}
			preview.setDimensions(previewDimensions);
			preview.setImages(previewImages);
		}

		return preview;
	}

	private List<CustomImage> convertByCustomizeImageSet(List<PcsCustomizeImageSetVO> imageSetVOS) {
		List<CustomImage> customImages = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(imageSetVOS)) {
			for (PcsCustomizeImageSetVO imageSetVO : imageSetVOS) {
				CustomImage customImage = new CustomImage();
				customImage.setId(imageSetVO.getImageId().longValue());

				List<CustomImagePosition> imagePositions = new ArrayList<>();
				List<PcsCustomizeImagePositionVO> positionVOS = imageSetVO.getCustomizeImagePositions();
				if (CollectionUtils.isNotEmpty(positionVOS)) {
					for (int i = 0; i < positionVOS.size(); i++) {
						CustomImagePosition customImagePosition = new CustomImagePosition();
						PcsCustomizeImagePositionVO positionVO = positionVOS.get(i);
						customImagePosition.setColor(
								this.getWordDimensionCode(CustomizeMode.TEXT_COLOR, imageSetVO.getImageId(), i));
						customImagePosition.setWord(
								this.getWordDimensionCode(CustomizeMode.TEXT_INPUT, imageSetVO.getImageId(), i));
						CustomPosition customPosition = new CustomPosition(positionVO.getPositionName(),
								positionVO.getHeight(), positionVO.getLength(), positionVO.getFontSize(),
								positionVO.getPositionX(), positionVO.getPositionY(), positionVO.getOpacity());

						customPosition.setType("general");
						switch (positionVO.getPositionType()) {
						case 1:
							customPosition.setType("general");
							logger.info("手动生成类型");
							break;
						case 2:
							customPosition.setType("auto");
							logger.info("自动生成类型" + "内容生成类型={}", positionVO.getContentType());
							if (null != positionVO.getContentType() && positionVO.getContentType() == 1) {// 自动生成日期

								Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT+08:00"));
								String year = c.get(Calendar.YEAR) + "";
								String month = (c.get(Calendar.MONTH) + 1) + "";
								String day = c.get(Calendar.DAY_OF_MONTH) + "";

								String date = "";

								if (day.length() > 1) {
									date = day + ".";
								} else {
									date = "0" + day + ".";
								}

								if (month.length() > 1) {
									date = date + month + ".";
								} else {
									date = date + "0" + month + ".";
								}

								date = date + year.substring(year.length() - 2, year.length());
								customPosition.setContent(date);
							}
							break;
						}
						customPosition.setIsShow(false);
						switch (positionVO.getBorderDisplayRrule()) {
						case 0:
							customPosition.setIsShow(false);
							logger.info("不显示定制边框");
							break;
						case 1:
							customPosition.setIsShow(true);
							logger.info("显示定制边框");
							break;
						}

						customPosition.setTextAlign("center");
						switch (positionVO.getPlacementPosition()) {
						case 1:
							customPosition.setTextAlign("left");
							logger.info("定制位置居左");
							break;
						case 2:
							customPosition.setTextAlign("center");
							logger.info("定制位置居中");
							break;
						case 3:
							customPosition.setTextAlign("right");
							logger.info("定制位置居右");
							break;
						}
						customImagePosition.setPosition(customPosition);
						imagePositions.add(customImagePosition);
					}
				}
				customImage.setPositions(imagePositions);
				if (StringUtils.isNotEmpty(imageSetVO.getImageUrl())) {
					customImage.setUrl(FileConstant.BASE_URL + imageSetVO.getImageUrl());
				}
				customImages.add(customImage);
			}
		}
		return customImages;
	}

	private String getWordDimensionCode(CustomizeMode customizeMode, Integer imageId, Integer positionIndex) {
		StringBuffer code = new StringBuffer();
		code.append(customizeMode.getId()).append("_").append(imageId).append("_").append(positionIndex);
		return code.toString();
	}
}
