package com.thebeastshop.pegasus.channelservice.adapter.product;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.support.YesOrNo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.support.vo.product.PreSellVO;

/**
 * spv通用适配器
 * 
 * @author Wang Yawei
 *
 */
@Component
public class SpvCommonAdapter {

	@Autowired
	private SPresaleService spresaleService;

	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;

	/**
	 * 根据sku取得预售日期
	 * 
	 * @param skuCodes
	 * @param type：0
	 *            线上，1线下
	 * @return Map<String, Date>
	 */
	public Map<String, Date> mapSkuCodePresale(Collection<PsSpvVO> spvs, OpChannelVO opChannel) {

		Map<String, Date> planedDeliveryDate = null;
		if (CollectionUtils.isNotEmpty(spvs)) {

			List<String> skuCodes = new ArrayList<>();
			for (PsSpvVO psSpvVo : spvs) {
				skuCodes.add(psSpvVo.getSkuCode());
			}

			Integer type = opChannel.getChannelType() == 1 ? OpPresaleVO.CHANNEL_TYPE_OFFLINE : OpPresaleVO.CHANNEL_TYPE_BEAST;
			planedDeliveryDate = spresaleService.findPlanedDeliveryDateBySkuCodes(skuCodes, type);

		}

		if (planedDeliveryDate == null)
			planedDeliveryDate = Maps.newHashMap();

		return planedDeliveryDate;
	}
	
	public PreSellVO getPresell(PsProductVO product, List<PsSkuVO> skuList, Map<String, Date> spvPresaleDateMap,
			PsSpvVO spv, OpChannelVO opChannel)

	{
		if (YesOrNo.YES.getId().equals(product.getIsMonthSend())){
			return null;
		}
		Date presaleDate = new Date();
		// Date presaleDateForIpos = new Date();
		int d = 0;
		int p = 0;
		PreSellVO presell = new PreSellVO();

		if ((product.getCombined() == null || !product.getCombined().equals(1))
				&& (product.getCrossBorderFlag() == null || !product.getCrossBorderFlag().equals(1))) {
			presaleDate = spvPresaleDateMap.get(spv.getSkuCode());
			// presaleDateForIpos = spvPresaleDateMap.get(spv);
			if (null != presaleDate) {
				d++;
			} else {
				presaleDate = new Date();
			}
		}
		if (d > 0) {

			// SimpleDateFormat sdf = new
			// SimpleDateFormat("yyyy-MM-dd");
			Calendar c = Calendar.getInstance();
			c.setTime(presaleDate);
			int month = c.get(Calendar.MONTH) + 1;
			int day = c.get(Calendar.DAY_OF_MONTH);
			presell.setContent("该商品预售, 预计" + month + "月" + day + "日发货");

		}
		// 找出所有skucode
		List<String> skus = new ArrayList<String>();
		if (null != spv.getSkuCode()) {
			skus.add(spv.getSkuCode());
		} else {
			if (null != spv.getSkuCombinationList()) {
				List<PsSkuCombinationVO> combs = spv.getSkuCombinationList();
				for (PsSkuCombinationVO comb : combs) {
					if (null != comb.getSubSkuCode()) {
						skus.add(comb.getSubSkuCode());
					}
				}
			}
		}

		Integer deliverTime = 0;

		for (PsSkuVO sku : skuList) {
			if (sku != null && null != sku.getIsJit() && sku.getIsJit() == 1) {
				
				// 来单发货时间计算
				Integer deliver = sku.getDeliveryPeriod();

				if (StringUtils.isNotBlank(sku.getCustomizeType())) {
					Integer days = spvCustomizeAdapter.getCustomizePlanedDeliveryDate(sku);
					if (deliver < days) {
						deliver = days - 1;
					}
				}

				Date deliverDate = new Date();
				Calendar calendar = new GregorianCalendar();
				calendar.setTime(deliverDate);
				if (null == deliver) {
					deliver = 0;
				}
				if (deliver > deliverTime) {
					deliverTime = deliver + 1;
				}
				calendar.add(calendar.DATE, deliver + 1);
				deliverDate = calendar.getTime();
				if (deliverDate.after(presaleDate)) {
					presaleDate = deliverDate;
					p++;
				} 
			}
		}

		if (p > 0 && deliverTime > 0) {

			presell.setContent("该商品预售，预计将于" + deliverTime + "个工作日后发货");
		}
		if (d + p > 0) {
			String dateStr = DateUtil.format(presaleDate, DateUtil.DEFAULT_DATETIME_FORMAT);
			Timestamp ts = new Timestamp(System.currentTimeMillis());

			try {
				ts = Timestamp.valueOf(dateStr);
				presell.setDeliverAt(ts);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			return null;
		}

		if (null != opChannel && Integer.valueOf(1).equals(opChannel.getChannelType())) {
			if (d > 0) {

				// SimpleDateFormat sdf = new
				// SimpleDateFormat("yyyy-MM-dd");
				Calendar c = Calendar.getInstance();
				c.setTime(presaleDate);
				int month = c.get(Calendar.MONTH) + 1;
				int day = c.get(Calendar.DAY_OF_MONTH);
				presell.setContent("该商品预售, 预计" + month + "月" + day + "日发货");
				String dateStr = DateUtil.format(presaleDate, DateUtil.DEFAULT_DATETIME_FORMAT);
				Timestamp ts = new Timestamp(System.currentTimeMillis());

				try {
					ts = Timestamp.valueOf(dateStr);
					presell.setDeliverAt(ts);
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				return null;
			}
		}
		return presell;
	}
	
}
