package com.thebeastshop.pegasus.channelservice.adapter.product;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pcs.sservice.SPrdcJobService;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.stock.dto.SPreparedStockQueryDTO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPreparedStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.product.PreSellVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SpvVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;
import com.thebeastshop.support.vo.product.SpvVO.FlashSaleVO;
import com.thebeastshop.support.vo.product.SpvVO.Quota;
import com.thebeastshop.wms.vo.WhRecipeInvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.*;

/**
 * spv适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class SpvAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private LabelService labelService;
	@Autowired
	private SpvCommonAdapter spvCommonAdapter;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private SStockService sStockService;

	@Autowired
	private SPrdcJobService sPrdcJobService;

	public Map<Long, SpvVO> getSpvWithoutDiscountNew(Collection<PsSpvVO> spvs, Collection<PsProductVO> products,
			MemberVO member, OpChannelVO opChannel, Map<String, Date> spvPresaleDateMap) {
		Date start = new Date();
		Map<Long, SpvVO> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			// ================product map===============
			Map<String, PsProductVO> productsMap = Maps.newHashMapWithExpectedSize(products.size());
			// ================presaleDate map===============
			// Map<PsSpvVO, Date> spvPresaleDateMap = mapSpvPresale(spvs);

			if (spvPresaleDateMap == null) {
				spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);
			}

			for (PsProductVO product : products) {
				productsMap.put(product.getId(), product);
			}
			for (PsSpvVO spv : spvs) {
				PsProductVO product = productsMap.get(spv.getProductId().toString());

				SpvVO spvVo = new SpvVO();
				spvVo.setId(spv.getSpvId());
				// featureImage
				String featureImage = product.getPicList();
				if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
					featureImage = FileConstant.BASE_URL + featureImage;
				}
				spvVo.setImage(featureImage);
				// brand
				List<PsBrandVO> brands = product.getBrands();
				if (CollectionUtils.isNotEmpty(brands)) {
					PsBrandVO brand = brands.get(0);
					if (brand != null) {
						BrandVO brandVO = new BrandVO();
						brandVO.setId(brand.getBrandId());
						brandVO.setName(brand.getBrandNameCN());
						spvVo.setBrand(brandVO);
					}
				}
				// name
				spvVo.setName(product.getNameCn());
				// description
				StringBuilder sb = new StringBuilder();
				List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
				if (CollectionUtils.isNotEmpty(attrList)) {
					for (PsAttributeValuePairVO attr : attrList) {
						if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
								&& StringUtils.isNotBlank(attr.getValue()))
							sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
					}
				}
				spvVo.setSpvDesc(sb.toString());

				if (product.getCombined()) {
					// price
					spvVo.setRawPrice(spv.getOriginalPrice());
				} else {
					// price
					spvVo.setRawPrice(spv.getSalesPrice());
				}

				if (spv.getDiscountPrice() != null) {
					spvVo.setPrice(spv.getDiscountPrice());
				} else {
					spvVo.setPrice(spv.getSalesPrice());
				}
				// product code
				spvVo.setProductCode(spv.getProductCode());

				// spv库存数量
				if (Integer.valueOf(1).equals(opChannel.getChannelType())) {
					spvVo.setLeft(spv.getCanUseQuantityOffLine());
				} else {
					spvVo.setLeft(spv.getCanUseQuantity());
				}
				// skuCodes
				List<PsSkuVO> skuList = new ArrayList<>();
				List<String> skuCodes = Lists.newArrayList();
				if (spv.getCombined()) {
					for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
						skuCodes.add(sku.getSubSkuCode());
						skuList.add(sku.getSubSkuVO());
					}
				} else {
					skuCodes.add(spv.getSkuCode());
					skuList.add(spv.getSkuVO());

					// 判断是否是定制配方商品
					if (spv.getSkuVO() != null && spv.getSkuVO().getCanCustomize() != null
							&& spv.getSkuVO().getCanCustomize() == 1 && opChannel.getChannelType() != 1) {

						Map<String, WhRecipeInvVO> whReipeInvVOMaps = new HashMap<>();
						if (skuCodes.size() > 0) {
							whReipeInvVOMaps.putAll(sPrdcJobService.caculateRecipeAmountForAssemble(skuCodes,
									opChannel.getWarehouseForSales()));
						}

						WhRecipeInvVO whRecipeInvVO = whReipeInvVOMaps.get(spv.getSkuVO().getSkuCode());
						if (whRecipeInvVO != null && whRecipeInvVO.isRecipeExist() == true) {

							// spv库存数量
							spvVo.setLeft(whRecipeInvVO.getCanUseInv());

						}

					}
				}
				spvVo.setSkuCodes(skuCodes);

				// 最小起售数
				Integer minAmount = spv.getMinAmount();
				if (minAmount != null) {
					spvVo.setMinAmount(minAmount);
				} else {
					spvVo.setMinAmount(1);
				}
				// XXX:预售信息(海淘商品或者组合商品不显示预售信息)
				PreSellVO presell = spvCommonAdapter.getPresell(product, skuList, spvPresaleDateMap, spv, opChannel);
				if (null != presell) {
					spvVo.setPresell(presell);
				} else {
					spvVo.setPresell(null);
				}

				// discount
				DiscVO disc = new DiscVO();
				Integer mbLevel = -1;
				if (member != null) {

					mbLevel = member.getMemberLevel();

				}
				MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(mbLevel);
				if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
						&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
						&& product.getAllowVipDiscount() == 1) {
					disc.setVipLevel(memberLevel.getCode().toString());
				}
				if (member != null && member.isInBdayDiscountTime()) {

					// 生日折扣改价格
					if (product.getAllowBdDiscount() == 1) {
						disc.setBirthday(true);
						disc.setVipLevel(null);
						if (spv.getBdDiscountPrice() != null) {
							spvVo.setPrice(spv.getBdDiscountPrice());
						}
					}
				}
				// 抢购
				FlashSaleVO flashSale = new FlashSaleVO();
				List<PsCampaignVO> campList = spv.getCampaignList();
				if (null != campList && campList.size() > 0) {
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId() == 6) {

							Date expire = camp.getExpireTime();
							if (null != expire) {
								String dateExp = DateUtil.format(expire, DateUtil.DEFAULT_DATETIME_FORMAT);
								Timestamp ts = new Timestamp(System.currentTimeMillis());
								try {
									ts = Timestamp.valueOf(dateExp);
									flashSale.setExpiresAt(ts);
									disc.setVipLevel(null);
								} catch (Exception e) {
									e.printStackTrace();
								}
							} else {
								flashSale.setExpiresAt(null);
							}
							flashSale.setSoldOut(true);
							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(camp.getCode());
							campaignStreamVO.setSkuCode(spv.getSkuCode());
							ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
							Integer stock = resp.getBean();
							// Integer stock =
							// PegasusWarehouseInnerServiceFacade.getInstance().getPanicBuyCampaignOccupy(channel.getWarehouseCode(),
							// camp.getCode(), spv.getSkuCode());
							// 库存为-1时表示不限量，去查询原有库存
							if (null != stock && stock.compareTo(-1) == 0) {
								if (spv.getCanUseQuantity() > 0) {
									flashSale.setSoldOut(false);
								}
							} else {

								// SPreparedStockQueryDTO dto = new
								// SPreparedStockQueryDTO();
								// dto.setSkuCode(spvVo.getSkuCodes().get(0));
								// dto.setBusinessCode(camp.getCode());
								// dto.setWarehouseCode(opChannel.getWarehouseForSales());
								// dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
								// // 这里暂时不支付抢购
								// SPreparedStockVO sPreparedStockVO =
								// sStockService.getPreparedQuantity(dto);
								//
								// if (sPreparedStockVO != null) {
								// spvVo.setLeft(sPreparedStockVO.getPreparedQuantity());
								// }

								if (spvVo.getLeft() > stock) {
									spvVo.setLeft(stock);
								}

								if (spvVo.getLeft().compareTo(0) > 0) {
									flashSale.setSoldOut(false);
								}
							}
							spvVo.setFlashSale(flashSale);
							// 判断是否有抢购限量
							if (camp.getLimitAmount() != null && camp.getLimitAmount() > 0) {
								Quota quta = new Quota();
								quta.setTotal(camp.getLimitAmount());
								if (member != null) {
									CampaignStreamVO campStream = new CampaignStreamVO();
									campStream.setSkuCode(spvVo.getSkuCodes().get(0));
									campStream.setCampaignCode(camp.getCode());
									campStream.setMemberCode(member.getCode());
									ServiceResp<Integer> leftResp = campaignLimitService
											.getPanicPerUserLeftAmount(campStream);
									Integer left = leftResp.getBean();
									// Integer left =
									// poInstance.sumPanicBuyLimitAmount(camp.getStartTime(),
									// camp.getExpireTime(), member.getCode(),
									// spvVo.getSkuCodes().get(0));
									quta.setLeft(left);
								} else {
									quta.setLeft(quta.getTotal());
								}

								spvVo.setQuota(quta);
							}

							break;
						}
					}
				}

				spvVo.setDiscount(disc);
				map.put(spv.getSpvId(), spvVo);
			}
		}
		Date end = new Date();
		logger.info("方法getSpvWithoutDiscount花费时间：{}毫秒", end.getTime() - start.getTime());
		return map;
	}

	/**
	 * 批量获取spv信息(不获取折扣金额),并组成map
	 * 
	 * @param spvs
	 * @param member
	 * @param opChannel
	 * @return
	 */
	public Map<Long, SpvVO> getSpvWithoutDiscountNew2(Collection<PsSpvVO> spvs, MemberVO member, OpChannelVO opChannel,
			Map<String, PsProductVO> prodMap) {
		Map<Long, SpvVO> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {

			List<PsProductVO> products = new ArrayList<>();
			// List<String> prodIds =
			// Lists.newArrayListWithExpectedSize(spvs.size());
			for (PsSpvVO spv : spvs) {
				if (null != spv) {
					products.add(prodMap.get(spv.getProductId().toString()));
				}
			}
			// ================product map===============

			map = getSpvWithoutDiscountNew(spvs, products, member, opChannel, null);

		}
		return map;
	}

	/**
	 * 获取商品标签
	 * 
	 * @param spvs
	 * @return
	 */
	public Map<PsSpvVO, List<Label>> getSpvLabels(Collection<PsSpvVO> spvs, AccessWayEnum accessWay) {
		return labelService.getSpvLabels(spvs, accessWay);
	}

	public Map<PsSpvVO, SpvVO> getSpvByBirthdayNew(Collection<PsSpvVO> spvs, Map<String, PsProductVO> productsMap,
			MemberVO member, OpChannelVO opChannel, boolean birthday, Map<String, Date> spvPresaleDateMap) {
		Date start = new Date();
		Map<PsSpvVO, SpvVO> map = Maps.newLinkedHashMap();
		if (CollectionUtils.isNotEmpty(spvs)) {
			// ================product map===============
			// Map<String, PsProductVO> productsMap =
			// Maps.newHashMapWithExpectedSize(products.size());
			// ================presaleDate map===============
			if (spvPresaleDateMap == null) {
				spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);
			}

			// for (PsProductVO product : products) {
			// productsMap.put(product.getId(), product);
			// }
			for (PsSpvVO spv : spvs) {
				PsProductVO product = productsMap.get(spv.getProductId().toString());
				List<PsSkuVO> skuList = new ArrayList<>();
				SpvVO spvVo = new SpvVO();
				spvVo.setId(spv.getSpvId());
				// featureImage
				String featureImage = product.getPicList();
				if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
					featureImage = FileConstant.BASE_URL + featureImage;
				}
				spvVo.setImage(featureImage);
				// brand
				List<PsBrandVO> brands = product.getBrands();
				if (CollectionUtils.isNotEmpty(brands)) {
					PsBrandVO brand = brands.get(0);
					if (brand != null) {
						BrandVO brandVO = new BrandVO();
						brandVO.setId(brand.getBrandId());
						brandVO.setName(brand.getBrandNameCN());
						spvVo.setBrand(brandVO);
					}
				}
				// name
				spvVo.setName(product.getNameCn());
				// description
				StringBuilder sb = new StringBuilder();
				List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
				if (CollectionUtils.isNotEmpty(attrList)) {
					for (PsAttributeValuePairVO attr : attrList) {
						if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
								&& StringUtils.isNotBlank(attr.getValue()))
							sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
					}
				}
				spvVo.setSpvDesc(sb.toString());
				// price
				if (product.getCombined()) {

					logger.info("prod code:" + product.getCode());

					logger.info("getOriginalPrice:" + spv.getOriginalPrice());

					// price
					spvVo.setRawPrice(spv.getOriginalPrice());
				} else {
					// price
					spvVo.setRawPrice(spv.getSalesPrice());
				}
				if (spv.getDiscountPrice() != null) {
					spvVo.setPrice(spv.getDiscountPrice());
				} else {
					spvVo.setPrice(spv.getSalesPrice());
				}
				// product code
				spvVo.setProductCode(spv.getProductCode());
				// skuCodes
				List<String> skuCodes = Lists.newArrayList();
				if (spv.getCombined()) {
					for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
						skuCodes.add(sku.getSubSkuCode());
						skuList.add(sku.getSubSkuVO());
					}
				} else {
					skuCodes.add(spv.getSkuCode());
					skuList.add(spv.getSkuVO());
				}
				spvVo.setSkuCodes(skuCodes);
				// spv库存数量
				spvVo.setLeft(spv.getCanUseQuantity());
				// 最小起售数
				Integer minAmount = spv.getMinAmount();
				if (minAmount != null) {
					spvVo.setMinAmount(minAmount);
				} else {
					spvVo.setMinAmount(1);
				}

				// XXX:预售信息(海淘商品或者组合商品不显示预售信息)
				PreSellVO presell = spvCommonAdapter.getPresell(product, skuList, spvPresaleDateMap, spv, opChannel);
				if (null != presell) {
					spvVo.setPresell(presell);
				} else {
					spvVo.setPresell(null);
				}
				// discount
				DiscVO disc = new DiscVO();
				// 默认为初始等级
				Integer memL = -1;
				if (member != null) {
					memL = member.getMemberLevel();
				}

				MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(memL);
				if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
						&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
						&& product.getAllowVipDiscount() == 1) {
					disc.setVipLevel(memberLevel.getCode().toString());
				}
				if (member != null && member.isInBdayDiscountTime() && birthday) {
					if (product.getAllowBdDiscount() == 1) {
						disc.setBirthday(true);
						disc.setVipLevel(null);
						if (spv.getBdDiscountPrice() != null) {
							spvVo.setPrice(spv.getBdDiscountPrice());
						}
					}
				}
				// 抢购
				FlashSaleVO flashSale = new FlashSaleVO();
				List<PsCampaignVO> campList = spv.getCampaignList();
				if (null != campList && campList.size() > 0) {
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId() == 6) {

							Date expire = camp.getExpireTime();
							if (null != expire) {
								String dateExp = DateUtil.format(expire, DateUtil.DEFAULT_DATETIME_FORMAT);
								Timestamp ts = new Timestamp(System.currentTimeMillis());
								try {
									ts = Timestamp.valueOf(dateExp);
									flashSale.setExpiresAt(ts);
									disc.setVipLevel(null);
								} catch (Exception e) {
									e.printStackTrace();
								}
							} else {
								flashSale.setExpiresAt(null);
							}
							flashSale.setSoldOut(true);
							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(camp.getCode());
							campaignStreamVO.setSkuCode(spv.getSkuCode());
							ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
							Integer stock = resp.getBean();
							if (stock == null) {
								stock = 0;
							}
							// Integer stock =
							// PegasusWarehouseInnerServiceFacade.getInstance().getPanicBuyCampaignOccupy(channel.getWarehouseCode(),
							// camp.getCode(), spv.getSkuCode());
							// 库存为-1时表示不限量，去查询原有库存
							if (stock.compareTo(-1) == 0) {
								if (spv.getCanUseQuantity() != null && spv.getCanUseQuantity() > 0) {
									flashSale.setSoldOut(false);
								}
							} else {

								if (spvVo.getLeft() > stock) {
									spvVo.setLeft(stock);
								}

								if (spvVo.getLeft().compareTo(0) > 0) {
									flashSale.setSoldOut(false);
								}
							}
							spvVo.setFlashSale(flashSale);
							disc.setBirthday(null);
							disc.setVipLevel(null);
							// 判断是否有抢购限量
							if (camp.getLimitAmount() != null && camp.getLimitAmount() > 0) {
								Quota quta = new Quota();
								quta.setTotal(camp.getLimitAmount());
								if (member != null) {
									CampaignStreamVO campStream = new CampaignStreamVO();
									campStream.setSkuCode(spvVo.getSkuCodes().get(0));
									campStream.setCampaignCode(camp.getCode());
									campStream.setMemberCode(member.getCode());
									ServiceResp<Integer> leftResp = campaignLimitService
											.getPanicPerUserLeftAmount(campStream);
									Integer left = leftResp.getBean();
									if (left == null) {
										left = 0;
									}
									// Integer left =
									// poInstance.sumPanicBuyLimitAmount(camp.getStartTime(),
									// camp.getExpireTime(), member.getCode(),
									// spvVo.getSkuCodes().get(0));

									SPreparedStockQueryDTO dto = new SPreparedStockQueryDTO();
									dto.setSkuCode(spv.getSkuCode());
									dto.setBusinessCode(camp.getCode());
									dto.setWarehouseCode(opChannel.getWarehouseForSales());
									dto.setOccupyType(SStockOccupyTypeEnum.CAMPAIGN_OUT);
									// 这里暂时不支付抢购
									SPreparedStockVO sPreparedStockVO = sStockService.getPreparedQuantity(dto);

									if (sPreparedStockVO != null) {

										if (sPreparedStockVO.getPreparedQuantity() > left) {
											quta.setLeft(left);
										} else {
											quta.setLeft(sPreparedStockVO.getPreparedQuantity());
										}

									} else {
										quta.setLeft(left);
									}

								} else {
									quta.setLeft(quta.getTotal());
								}

								spvVo.setQuota(quta);
							}
							break;
						}
					}
				}

				spvVo.setDiscount(disc);
				map.put(spv, spvVo);
			}
		}
		Date end = new Date();
		logger.info("方法getSpvByBirthday花费时间：{}毫秒", end.getTime() - start.getTime());
		return map;
	}

}
