package com.thebeastshop.pegasus.channelservice.adapter.product;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.enums.FactorTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.enums.FavoriteExtTypeEnum;
import com.thebeastshop.cart.req.FavoriteCondition;
import com.thebeastshop.cart.service.FavoriteService;
import com.thebeastshop.cart.vo.Favorite;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.cooperation.service.deposit.DepositService;
import com.thebeastshop.cooperation.vo.deposit.DepositInfoVO;
import com.thebeastshop.forcast.vo.ForcastVO;
import com.thebeastshop.forcast.vo.LevelInfo;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.CommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.StockAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.flowermonth.FlowerMonthShowAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.constants.ProductConstant;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.channelservice.util.HtmlUtil;
import com.thebeastshop.pegasus.channelservice.util.PriceResultUtils;
import com.thebeastshop.pegasus.merchandise.IService.IInterestGoodsService;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPcsCopywriterService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalcProductDTO;
import com.thebeastshop.price.vo.PrsProductPriceResultVO;
import com.thebeastshop.price.vo.PrsSpvPriceResultVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsVO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.FavoriteExtType;
import com.thebeastshop.support.enums.LogisticsType;
import com.thebeastshop.support.enums.flowerMonth.FlowerMonthDistType;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.product.*;
import com.thebeastshop.support.vo.product.SimpleProductVO.BigPicVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SimpleProductVO.PriceForecastVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

/**
 * 商品适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class ProductAdapter {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	private final String RUSH_ONOFF = "rush_onoff";

	private final String RUSH_LIST = "rush_list";

	private static String DEPOSIT = "DEPOSIT";

	private final String DEPOSIT_ONOFF = "deposit_onoff";
	@Autowired
	private RedisClient redisClient;

	@Autowired
	private CommonAdapter commonAdapter;

	@Autowired
	private LabelService labelService;

	@Autowired
	private FavoriteService favoriteService;

	@Autowired
	private McPcsCopywriterService mcPcsCopywriterService;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private SpvPriceAdapter spvPriceAdapter;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private SpvAdapter spvAdapter;

	@Autowired
	private FlowerMonthShowAdapter flowerMonthShowAdapter;

	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private ForecastAdapter forecastAdapter;
	@Autowired
	private SStockService sStockService;

	@Autowired
	private CampaignLimitService campaignLimitService;
	@Autowired
	private IInterestGoodsService iInterestGoodsService;

	@Autowired
	private DepositService depositService;

	@Autowired
	private StockAdapter stockAdapter;

	String badgeColor = "#000000";
	String badgeIcon = "http://img.thebeastshop.com/apppictures/2017-08-23/e77bb85354de40eabb04171bc7b6da23.png";

	String priceTagTextColor = "#AB916B";
	String priceTagEdgeColor = "#AB916B";

	// ===============private================

	/**
	 * 判断商品是否售罄
	 * 
	 * @param product
	 * @param opChannel
	 * @return
	 */
	public boolean checkIsSoldOut(PsProductVO product, OpChannelVO opChannel) {
		if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
			return !flowerMonthShowAdapter.hasFlowerStocks(product, opChannel);
		}
		Integer stock = this.getProductStock(product, opChannel);
		return NumberUtil.isNullOrZero(stock);
	}

	/**
	 * 判断商品是否售罄
	 *
	 * @param product
	 * @param opChannel
	 * @return
	 */
	 public Integer getProductStock(PsProductVO product, OpChannelVO opChannel) {
		Integer stock = 0;

		// 正常商品去库存
		List<PsChnStockVO> stocks = product.getStocks();
		if (CollectionUtils.isNotEmpty(stocks)) {
			for (PsChnStockVO psChnStockVO : stocks) {
				if (opChannel.getCode().equals(psChnStockVO.getChnCode())) {

					if (psChnStockVO.getSoldOut() != null && psChnStockVO.getSoldOut().equals(0)
							&& NumberUtil.isNullOrZero(psChnStockVO.getStock())) {
						stock = 9999;
					} else {
						stock = psChnStockVO.getStock();
					}

				}
			}
		}

		// 如果商品参加抢购活动取抢购库存判断是否soldOut
		List<PsSpvVO> spvs = product.getSpvList();
		if (CollectionUtils.isNotEmpty(spvs)) {
			for (PsSpvVO spv : spvs) {
				List<PsCampaignVO> campList = spv.getCampaignList();
				if (CollectionUtils.isNotEmpty(campList)) {
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId() == 6
								&& DateUtil.isInTime(camp.getStartTime(), camp.getExpireTime(), new Date())) {
							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(camp.getCode());
							campaignStreamVO.setSkuCode(spv.getSkuCode());
							ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
							Integer limitStock = resp.getBean();
							if (NumberUtil.isNullOrZero(resp.getBean())) {
								limitStock = 0;
							}

							if (limitStock != -1) {
								stock = limitStock;
							}
						}
					}
				}
			}
		}

		return stock;
	}

	private SPresaleSaleInvVO getProductPresale(PsProductVO product) {
		SPresaleSaleInvVO presale = null;
		if (product != null) {
			Map<String, SPresaleSaleInvVO> mapSkuPresale = mapSkuPresale(product.getSkuCodes());
			if (mapSkuPresale != null) {
				Iterator<SPresaleSaleInvVO> iterator = mapSkuPresale.values().iterator();
				while (iterator.hasNext()) {
					SPresaleSaleInvVO next = iterator.next();
					if (next != null && next.getPlanedDeliveryDate() != null) {
						presale = next;// TODO:默认取第一个预售信息
						break;
					}
				}
			}
		}

		return presale;
	}

	private Map<String, SPresaleSaleInvVO> mapSkuPresale(List<String> skuCodes) {
		if (CollectionUtils.isNotEmpty(skuCodes)) {
			Map<String, SPresaleSaleInvVO> rt = Maps.newHashMap();
			// rt = poInstance.findCanUseQttBySkuCodes(skuCodes, null);

			rt = sPresaleService.findCanUseQttBySkuCodes(skuCodes, null);
			return rt;
		}
		return null;
	}

	private ProductShareVO getProductShareVO(ProductVO productBasicVO, PsProductVO product) {
		ProductShareVO productShareVO = new ProductShareVO();

		productShareVO.setTitle(
				(StringUtils.isNotBlank(productBasicVO.getSummary()) ? "「" + productBasicVO.getSummary() + "」" : "")
						+ productBasicVO.getName());
		String desc = getRecommendDesc(Long.parseLong(product.getId()));
		productShareVO.setContent((StringUtils.isNotBlank(desc) ? desc : ""));
		if (null != product && StringUtils.isNotBlank(product.getCode())) {
			productShareVO.setLink("https://m.thebeastshop.com/product/" + product.getCode());
		} else {
			productShareVO.setLink("");
		}
		productShareVO.setImage(productBasicVO.getFeatureImage());

		return productShareVO;
	}

	// ======================================

	/**
	 * 获取商品
	 * 
	 * @param product
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public ProductVO getProduct(PsProductVO product, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		ProductVO productVO = null;
		if (product != null && member != null && opChannel != null) {
			logger.info("商品的product查询为 product={}   方法名是getProduct()  参数为 productCode={},memberId={},channelCode={}",
					product, product.getCode(), member.getId(), opChannel.getCode());
			if (null != product) {
				List<ForcastVO> prevues = new ArrayList<ForcastVO>();
				prevues = forecastAdapter.getPrevueProduct(product.getCode());

				// 去sku详情
				List<String> codes = product.getSkuCodes();

				List<PsSkuVO> skus = new ArrayList<PsSkuVO>();
				List<String> onoffList = JsonUtil.toList(PropConstants.getProperties(RUSH_ONOFF), String.class);
				Boolean onoffState = commonAdapter.on_off(onoffList.get(0), onoffList.get(1));
				Boolean onlineState = commonAdapter.isOnline(opChannel.getCode());
				List<String> rushList = JsonUtil.toList(PropConstants.getProperties(RUSH_LIST), String.class);
				if (onoffState && onlineState && rushList.contains(product.getCode())) {// 开关期间，且有线上渠道，且抢购商品

					List<String> addList = new ArrayList<String>();
					for (String code : codes) {
						logger.info("从redis里取sku code={}", code);
						PsSkuVO sku = redisClient.getCache(commonAdapter.buildSkuKey(code));
						if (null != sku) {
							skus.add(sku);
						} else {
							addList.add(code);
						}
					}
					if (CollectionUtils.isNotEmpty(addList)) {
						logger.info("redis没取全，push一下 codes={}", addList);
						List<PsSkuVO> adds = commonAdapter.pushSku(addList);
						skus.addAll(adds);
					}
				} else {
					skus = mcPsSkuService.findBySkuCodes(codes);
				}
				// String ISNEWPRODUCTPRICE =
				// PropConstants.getProperties("ISNEWPRODUCTPRICE");//

				// if (ISNEWPRODUCTPRICE.equals("true")) {
				PrsCalcProductDTO arg0 = priceAdapter.assemblePriceProduct(product, skus, member, opChannel, accessWay);

				if (null == arg0) {
					logger.info("商品组装出现问题：取不到该商品完整信息，productcode=" + product.getCode());
					return null;
				}
				// arg1.setBirthday(member.getBirthday());
				// arg1.setCode(member.getCode());
				// arg1.setId(member.getId());
				// arg1.setMemberLevel(member.getMemberLevel());
				// arg1.setNickName(member.getNickName());
				logger.info("商详页调用价格计算");

				List<String> skuCodes = new ArrayList<String>();
				if (CollectionUtils.isNotEmpty(skus)) {
					for (PsSkuVO psSkuVO : skus) {
						skuCodes.add(psSkuVO.getId());
					}
				}

				Map<String, SSkuStockVO> stockMap = sStockService.getSkuStocks(skuCodes,
						opChannel.getWarehouseForSales());

				PrsProductPriceResultVO priceVo = prsPriceService.calculatePrs4ProductDetail(arg0);
				productVO = new ProductVO(this.getSimpleProductPrice(product, member, opChannel, accessWay, "", skus,
						prevues, priceVo, stockMap));

				Map<Long, BigDecimal> spvMap = combineSpvPrice(priceVo);
				// ===========规格==========
				productVO.setVariant(getProductVariantPrice(product, member, opChannel, accessWay, spvMap));

				if (CollectionUtils.isNotEmpty(product.getSpvList())) {
					List<PsCampaignVO> campList = product.getSpvList().get(0).getCampaignList();
					for (PsCampaignVO camp : campList) {
						if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
							GrouponVO grouponVO = new GrouponVO();
							String groupCode = camp.getCode();
							grouponVO.setLink("beastapp://entry?name=group-purchase&productId=" + product.getCode());
							grouponVO.setNumber(camp.getGroupNumber());
							List<PsCampaignSectionVO> sectionList = camp.getCampaignSectionList();

							// 排序 团购价
							Collections.sort(sectionList, new Comparator<PsCampaignSectionVO>() {
								@Override
								public int compare(PsCampaignSectionVO o1, PsCampaignSectionVO o2) {
									BigDecimal a = o1.getFactor();
									BigDecimal b = o2.getFactor();
									return (a.compareTo(b));
								}
							});

							List<BigDecimal> range = new ArrayList<BigDecimal>();
							range.add(sectionList.get(0).getFactor());
							range.add(sectionList.get(sectionList.size() - 1).getFactor());
							grouponVO.setRange(range);
							productVO.setGroupon(grouponVO);
						}

					}
				}

				// } else {
				// productVO = new ProductVO(
				// this.getSimpleProduct(product, member, opChannel, accessWay,
				// "", prevues));
				// // ===========规格==========
				// productVO.setVariant(getProductVariant(product, member,
				// opChannel, accessWay));
				//
				// }

				// ===========是否需要验证地址==========

				LogisticsType logisticsType = EnumUtil.valueOf(product.getExpressType(), LogisticsType.class);
				// "店送"和"联邦"快递的时候，该商品就需要验证配送地址才能加入购物车
				// Boolean needAddress = false;
				if (logisticsType != null) {
					switch (logisticsType) {
					case SHOP:
					case FEDEX:
					case SELF:
						// needAddress = true;
						productVO.setNeedVerifyAddress(true);
						break;
					default:
						break;

					}
				}

				// ===========标签==========
				Map<PsProductVO, List<Label>> labelMap = getProductLabels(Arrays.asList(product));
				productVO.setLabels(labelMap.get(product));

				// ===========分享==========
				productVO.setShare(this.getProductShareVO(productVO, product));
				// ===========是否收藏==========
				FavoriteCondition condition = new FavoriteCondition();
				condition.setOwnerId(member.getId());
				condition.setExtType(FavoriteExtTypeEnum.PRODUCT);
				condition.setExtId(Long.parseLong(product.getId()));
				List<Favorite> favorites = favoriteService.getByCondition(condition);
				if (CollectionUtils.isNotEmpty(favorites)) {
					productVO.setFavorited(true);
				} else {
					productVO.setFavorited(false);
				}

				// ===========大家具==========
				Boolean furniture = false;

				for (PsSkuVO sku : skus) {
					if (sku.getWhetherLogistics() != null && sku.getWhetherLogistics() == 1) {
						furniture = true;
						break;
					}
				}
				productVO.setFurniture(furniture);
				// ===========提示==========
				productVO.setTips(this.getTips(furniture, logisticsType));
				// ===========徽章==========
				productVO.setBadges(this.getProductBadges(product, skus, furniture));
				// 积分兑换野兽课堂
				if(productVO.getPointDeduction()){
					productVO.setUseHTML(Boolean.TRUE);
					productVO.setHtmlLink("beastapp://entry?name=m-product-detail&pageType=LESSON");
				}
				if (productVO.getCustomizable()) {
					productVO.setUseHTML(Boolean.TRUE);
					productVO.setHtmlLink("beastapp://entry?name=customization-edit");
				}

				// 定制商品售罄判断
				if ((productVO.getUseHTML() && productVO.getPresell() == null) || productVO.getRaw().getRush()) {

					if (productVO.getVariant().getSpvs().size() > 0) {
						productVO.setSoldOut(true);
						for (SpvVO spvVO : productVO.getVariant().getSpvs()) {

							if (spvVO.getLeft() != null && spvVO.getLeft() > 0) {
								productVO.setSoldOut(false);
								break;
							}

						}
					}
				}

				// ===========XXX:预售信息(海淘商品或者组合商品不显示预售信息 包括来单商品，取最长时间)==========
				productVO.setPresell(setProductPreSell(product, accessWay, skus));

				// ===========PriceForecast预告价===============

				PsAdvanceCampaignVO psAdvanceCampaignVO = product.getPsAdvanceCampaignVO();
				if (psAdvanceCampaignVO != null
						&& CollectionUtils.isNotEmpty(psAdvanceCampaignVO.getAdvanceCampaignList())) {
					PriceForecastVO priceForecast = new PriceForecastVO();
					List<PsCampaignVO> foreCampaigns = psAdvanceCampaignVO.getAdvanceCampaignList();
					PsCampaignVO cam = foreCampaigns.get(0);
					Date date = cam.getStartTime();
					List<BigDecimal> range = new ArrayList<BigDecimal>();
					if (null != date) {
						String dateStr = DateUtil.format(date, DateUtil.DEFAULT_DATETIME_FORMAT);
						Timestamp ts = new Timestamp(System.currentTimeMillis());
						try {
							ts = Timestamp.valueOf(dateStr);
							priceForecast.setSince(ts);
						} catch (Exception e) {
							e.printStackTrace();
						}
					}

					priceForecast.setName(cam.getAdvancePriceTitle());
					BigDecimal minAdvancePrice = psAdvanceCampaignVO.getMinPrice();
					BigDecimal maxAdvancePrice = psAdvanceCampaignVO.getMaxPrice();
					range.add(minAdvancePrice);
					range.add(maxAdvancePrice);
					priceForecast.setRange(range);
					productVO.setPriceForecast(priceForecast);
				} else {
					productVO.setPriceForecast(null);
				}
				// ===========是否可以购买===============
				if (accessWay != null && accessWay.equals(AccessWayEnum.OFFLINE)) {
					productVO.setBuyable(false);
				} else {
					productVO.setBuyable(true);
				}
				if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
					productVO.setMonthSend(true);
					// 月送鲜花配送地址验证设置为false 提示列表设置为null
					productVO.setNeedVerifyAddress(false);
					productVO.setTips(Lists.<ProductTipVO> newArrayList());
					if (product.getFlowerMonProductionType() != null && SFlowerProductionTypeEnum.STORE.getValue()
							.equals(product.getFlowerMonProductionType().byteValue())) {
						productVO.setMonthSendDistType(FlowerMonthDistType.SHOP);
					}
				}
				// 水印图片
				if (null != product.getLargeIconList() && !product.getLargeIconList().isEmpty()) {
					List<String> waterMark = new ArrayList<String>();
					waterMark.add(product.getLargeIconList().get(0));
					productVO.setWaterMarkImage(waterMark);
				}
				// 视频
				List<VideoVO> videos = new ArrayList<VideoVO>();
				VideoVO video = new VideoVO();

				if (StringUtils.isNotEmpty(product.getVideo())) {
					video.setUrl(FileConstant.BASE_URL + product.getVideo());
				}
				if (StringUtils.isNotEmpty(product.getVideoCover())) {
					// 图片服务拼接
					video.setThumbnailUrl(
							FileConstant.BASE_URL + product.getVideoCover() + "@4e_0o_0l_721h_690w_90q.jpg");
				}
				// video.setUrl("https://cloud.video.taobao.com/play/u/1746622942/p/2/e/6/t/1/50012780941.mp4?appKey=7579");
				// video.setThumbnailUrl(
				// "http://img.thebeastshop.com/image/20170815185544391523.jpg@4e_0o_0l_721h_690w_90q.webp");
				if (StringUtils.isNotEmpty(product.getVideo()) && StringUtils.isNotEmpty(product.getVideoCover())) {
					videos.add(video);
				}
				productVO.setVideos(videos);

				// priceTags(since1.11 代替discount)
				List<PriceTagVO> priceTags = new ArrayList<PriceTagVO>();
				// CROWN
				PriceTagVO CROWN = null;
				if (null != product.getIsDiscount() && product.getIsDiscount() == 1 && member.getMemberLevel() > 1) {
					CROWN = new PriceTagVO();
					CROWN.setEdgeColor(priceTagEdgeColor);
					CROWN.setIcon("CROWN");
					CROWN.setText("专享88折");
					CROWN.setTextColor(priceTagTextColor);
				}

				// CAKE
				PriceTagVO CAKE = null;
				if (member.isInBdayDiscountTime()) {// 生日折扣改价格
					if (product.getAllowBdDiscount() == 1) {
						CAKE = new PriceTagVO();
						CAKE.setEdgeColor(priceTagEdgeColor);
						CAKE.setIcon("CAKE");
						CAKE.setText("生日折扣");
						CAKE.setTextColor(priceTagTextColor);

					}
				}

				// VIP
				PriceTagVO VIP = null;
				if (member.getMemberLevel() > 0) {// 生日折扣改价格
					if (product.getAllowBdDiscount() == 1) {
						VIP = new PriceTagVO();
						VIP.setEdgeColor(priceTagEdgeColor);
						Integer VIPLevel = member.getMemberLevel() + 1;
						String VIPName = "VIP" + VIPLevel.toString();
						VIP.setIcon(VIPName);
						VIP.setText(member.getMemberLevelDesc());
						VIP.setTextColor(priceTagTextColor);
					}
				}

				if (null != CAKE) {
					priceTags.add(CAKE);
				} else if (null != CROWN) {
					priceTags.add(CROWN);
				} else if (null != VIP) {
					priceTags.add(VIP);
				}

				productVO.setPriceTags(priceTags);

				if (productVO.getForetell()) {

					if (CollectionUtils.isNotEmpty(prevues)) {
						PrevueVO prevue = new PrevueVO();
						for (ForcastVO forecast : prevues) {

							logger.info("取到当前预告 id:{},islevel:{}", forecast.getForecastId(), forecast.isLevel());
							Date endtime = forecast.getEndTime();

							Date dendtime = forecast.getEndTime();
							String desc = "";
							if (forecast.isLevel()) {
								Date endtime00 = forecast.getEndTime();
								Date endtime0 = forecast.getEndTime();
								Date endtime1 = forecast.getEndTime();
								Date endtime2 = forecast.getEndTime();
								Date endtime3 = forecast.getEndTime();
								List<LevelInfo> levels = forecast.getLevels();
								if (CollectionUtils.isNotEmpty(levels)) {
									for (LevelInfo level : levels) {
										switch (level.getMemberLevel()) {

										case -1:
											endtime00 = level.getEndTime();
											desc = desc + "注册";
											break;
										case 0:
											endtime0 = level.getEndTime();
											desc = desc + "松鼠";
											break;
										case 1:
											endtime1 = level.getEndTime();
											desc = desc + "小猫";
											break;
										case 2:
											endtime2 = level.getEndTime();
											desc = desc + "老虎";
											break;
										case 3:
											endtime3 = level.getEndTime();
											desc = desc + "大象";
											break;
										default:
											break;
										}
									}

								}

								logger.info("当前会员等级 memberlevel={}", member.getMemberLevel());
								switch (member.getMemberLevel()) {
								case -1:
									endtime = endtime00;
									break;
								case 0:
									endtime = endtime0;
									break;
								case 1:
									endtime = endtime1;
									break;
								case 2:
									endtime = endtime2;
									break;
								case 3:
									endtime = endtime3;
									break;
								default:
									break;
								}

							}
							logger.info("会员时间 endtime={}", endtime);

							if (null != forecast && endtime.after(new Date())) {
								prevue.setId(forecast.getForecastId());

								// 默认时间
								String ddateStr = "";
								DateFormat dsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
								ddateStr = dsdf.format(dendtime);
								Timestamp defaultTime = Timestamp.valueOf(ddateStr);
								prevue.setSince(defaultTime);

								// vip时间
								String dateStr = "";
								DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
								dateStr = sdf.format(endtime);
								Timestamp vipTime = Timestamp.valueOf(dateStr);
								prevue.setVipSince(vipTime);

								if (forecast.isLevel()) {
									Date le = forecast.getLevels().get(0).getEndTime();
									long diff = defaultTime.getTime() - le.getTime();
									long min = diff / (1000 * 60);
									if (!desc.isEmpty()) {
										desc = desc + "会员提前";
										if (min > 0) {
											Long h = min / (60);
											Long m = min % (60);
											if (h > 0) {
												desc = desc + h + "小时";
											}
											if (m > 0) {
												desc = desc + m + "分钟";
											}
											desc = desc + "开抢，抢完即止";

											prevue.setDesc(desc);
										}
									}
								}
								break;
							}
						}
						if (null != prevue.getId() && !prevue.getId().isEmpty()) {
							productVO.setPrevue(prevue);
							logger.info("商品预告prevue", prevue.getDesc());
						}

					}
				}
				try {
					List<String> times = JsonUtil.toList(PropConstants.getProperties(DEPOSIT_ONOFF), String.class);

					Date start = new Date();
					Date end = new Date();
					DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

					Date now = new Date();

					start = dateFormat.parse(times.get(0));
					end = dateFormat.parse(times.get(1));
//					if (now.after(start) && now.before(end)) {
//						List<DownSpvVO> details = new ArrayList<DownSpvVO>();
//
//						List<BigDecimal> prices = new ArrayList<BigDecimal>();
//
//						Map<String, DepositInfoVO> infos = redisClient.getCache(DEPOSIT);
//
//						if (null == infos) {
//							ServiceResp<Map<String, DepositInfoVO>> resp = depositService.getAll();
//							if (resp.isSuccess()) {
//								if (!resp.getBean().isEmpty()) {
//									infos = resp.getBean();
//									redisClient.putCache(DEPOSIT, infos, 300L);
//								}
//							}
//						}
//						if (null != infos && !infos.isEmpty()) {
//
//							List<String> virtualSkus = new ArrayList<String>();
//
//							List<DepositInfoVO> resultInfos = new ArrayList<DepositInfoVO>();
//							for (String sku : codes) {
//								if (infos.containsKey(sku)) {
//									DepositInfoVO info = infos.get(sku);
//									virtualSkus.add(info.getVirtualSku());
//									resultInfos.add(info);
//
//								}
//							}
//							Map<String, SSkuStockVO> smap = sStockService.getSkuStocks(virtualSkus,
//									opChannel.getWarehouseForSales());
//
//							if (CollectionUtils.isNotEmpty(resultInfos)) {
//								int resultStock = 0;
//								for (DepositInfoVO result : resultInfos) {
//
//									DownSpvVO spvVO = new DownSpvVO();
//									InterestGoodsVO interestGoods = interestGoodsService
//											.selectInterestGoodsSku(result.getInterestId().intValue());
//									if (null != interestGoods.getInterestGoodsSkuList().get(0).getDeductionPrice())
//										spvVO.setDeduction(
//												interestGoods.getInterestGoodsSkuList().get(0).getDeductionPrice());
//
//									PsProductVO virp = mcPsProductService.findProdBySkuCode(result.getVirtualSku());
//									MemberLevelEnum memberLevel = MemberLevelEnum
//											.getEnumByCode(member.getMemberLevel());
//
//									PsMatchCampaignCond cond = new PsMatchCampaignCond();
//									cond.setMatchCampaign(true);
//									cond.setChannelCode(opChannel.getCode());
//									cond.setAccessWay(accessWay.getCode());
//									cond.setMemberLevel(memberLevel.getCode());
//									cond.setDiscount(memberLevel.getLevelAmountCondition());
//									cond.setBdDiscount(member.getBdayDiscountRatio());
//									PsProductVO virtualprod = mcPsProductService
//											.getProductDetailByCode(opChannel.getCode(), virp.getCode(), cond);
//									for (PsSpvVO virtualspv : virtualprod.getSpvList()) {
//										if (virtualspv.getSkuCode().equals(result.getVirtualSku())) {
//											spvVO.setPrice(virtualspv.getSalesPrice());
//											break;
//										}
//									}
//
//									SSkuStockVO svo = smap.get(result.getVirtualSku());
//									if (null != svo) {
//										spvVO.setStock(svo.getCanUseQuantity());
//										resultStock = resultStock + svo.getCanUseQuantity();
//									}
//
//									PsProductVO vp = mcPsProductService.findProdBySkuCode(result.getVirtualSku());
//
//									if (null != vp) {
//										for (PsSpvVO vsp : vp.getSpvList()) {
//											if (vsp.getSkuCode().equals(result.getVirtualSku())) {
//												spvVO.setVirtual(vsp.getSpvId());
//												break;
//											}
//										}
//									}
//
//									for (SpvVO varspv : productVO.getVariant().getSpvs()) {
//										if (varspv.getSkuCodes().get(0).equals(result.getSkuCode())) {
//											spvVO.setSpvId(varspv.getId());
//											if (null != interestGoods.getInterestGoodsSkuList().get(0)
//													.getDeductionPrice()) {
//												spvVO.setFinalPrice(varspv.getPrice().subtract(interestGoods
//														.getInterestGoodsSkuList().get(0).getDeductionPrice()));
//											} else {
//												spvVO.setFinalPrice(varspv.getPrice());
//											}
//											varspv.setLeft(999);
//										}
//									}
//
//									prices.add(spvVO.getFinalPrice());
//									details.add(spvVO);
//								}
//								if (resultStock > 0) {
//									productVO.setSoldOut(false);
//								} else {
//									productVO.setSoldOut(true);
//								}
//
//							}
//
//						}
//
//						if (CollectionUtils.isNotEmpty(details)) {
//
//							// 排序 根据soldout
//							Collections.sort(prices, new Comparator<BigDecimal>() {
//								@Override
//								public int compare(BigDecimal o1, BigDecimal o2) {
//									return (o1.compareTo(o2));
//								}
//							});
//
//							List<BigDecimal> range = new ArrayList<BigDecimal>();
//							range.add(prices.get(0));
//							range.add(prices.get(prices.size() - 1));
//							DownPaymentVO downPayment = new DownPaymentVO();
//							downPayment.setDetails(details);
//							downPayment.setRange(prices);
//							productVO.setDownPayment(downPayment);
//							// productVO.setSoldOut(false);
//							productVO.setUseHTML(true);// 给顺子暂改
//
//						} else {
//							productVO.setDownPayment(null);
//						}
//					}

				} catch (ParseException e) {
					// TODO Auto-generated catch block
					// e.printStackTrace();
					throw new ChannelException(ErrorCode.CONFIG_ERROR.getCode(),
							ErrorCode.CONFIG_ERROR.getMesage() + ": " + e.getMessage());

				}

			}
		}
		return productVO;

	}

	/**
	 * 设置预售商品提示信息 a>预售信息(海淘商品或者组合商品不显示预售信息 包括来单商品，取最长时间) b>月送鲜花不显示预售信息
	 * 
	 * @param product
	 * @param accessWay
	 * @param skus
	 * @return
	 */
	private PreSellVO setProductPreSell(PsProductVO product, AccessWayEnum accessWay, List<PsSkuVO> skus) {
		if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
			return null;
		}
		PreSellVO presell = new PreSellVO();
		Date presellDate = new Date();
		Date presellDateForIpos = new Date();
		int d = 0;
		int p = 0;
		if ((product.getCombined() == null || !product.getCombined().equals(1))
				&& (product.getCrossBorderFlag() == null || !product.getCrossBorderFlag().equals(1))) {

			SPresaleSaleInvVO presale = getProductPresale(product);
			if (null != presale) {
				presellDate = presale.getPlanedDeliveryDate();
				presellDateForIpos = presale.getPlanedDeliveryDate();
				d++;
			}
		}
		if (d > 0) {

			// SimpleDateFormat sdf = new
			// SimpleDateFormat("yyyy-MM-dd");
			Calendar c = Calendar.getInstance();
			c.setTime(presellDate);
			int month = c.get(Calendar.MONTH) + 1;
			int day = c.get(Calendar.DAY_OF_MONTH);
			presell.setContent("该商品预售, 预计" + month + "月" + day + "日发货");
		}
		// 来单发货时间
		if (null != skus && skus.size() > 0) {
			Integer deliverTime = 0;
			for (PsSkuVO sku : skus) {
				if (null != sku.getIsJit() && sku.getIsJit() == 1) {
					
					// 来单发货时间计算
					Integer deliver = sku.getDeliveryPeriod();
					Date deliverDate = new Date();
					Calendar calendar = new GregorianCalendar();
					calendar.setTime(deliverDate);
					if (null == deliver) {
						deliver = 0;
					}
					if (deliver + 1 > deliverTime) {
						deliverTime = deliver + 1;
					}
					calendar.add(calendar.DATE, deliver + 1);
					deliverDate = calendar.getTime();
					if (deliverDate.after(presellDate)) {
						presellDate = deliverDate;
						p++;
					}
				}
			}
			if (p > 0) {
				presell.setContent("该商品预售，预计将于" + deliverTime + "个工作日后发货");
			}
		}

		if (d + p > 0) {

			String dateStr = DateUtil.format(presellDate, DateUtil.DEFAULT_DATETIME_FORMAT);
			Timestamp ts = new Timestamp(System.currentTimeMillis());

			try {
				ts = Timestamp.valueOf(dateStr);
				presell.setDeliverAt(ts);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			return null;
		}

		if (accessWay != null && accessWay.equals(AccessWayEnum.OFFLINE)) {
			if (d > 0) {

				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				Calendar c = Calendar.getInstance();
				c.setTime(presellDateForIpos);
				int month = c.get(Calendar.MONTH) + 1;
				int day = c.get(Calendar.DAY_OF_MONTH);
				presell.setContent("该商品预售, 预计" + month + "月" + day + "日发货");

				String dateStr = DateUtil.format(presellDateForIpos, DateUtil.DEFAULT_DATETIME_FORMAT);
				Timestamp ts = new Timestamp(System.currentTimeMillis());

				try {
					ts = Timestamp.valueOf(dateStr);
					presell.setDeliverAt(ts);
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				return null;
			}

		}
		return presell;
	}

	/**
	 * 通过 product 得到 推荐描述 剔除所有的html 标签
	 * 
	 * @author lijing
	 * @param productId
	 * @return
	 */
	public String getRecommendDesc(Long productId) {
		String str = "";
		PsProductCond cond = new PsProductCond();
		cond.setId(Long.toString(productId));
		PsProductVO product = mcPsProductService.findByProdId(productId);
		if (null != product) {
			List<PsDynmContentVO> produnctContent = product.getDynmContents();
			if (null != produnctContent) {
				List<ProductDetailVO> productDetailVOs = getProductContent(produnctContent);
				if (CollectionUtils.isNotEmpty(productDetailVOs)) {
					for (ProductDetailVO productDetailVO : productDetailVOs) {
						if (ProductConstant.DONY_CONTENT.RECOMMEND_REASON.equals(productDetailVO.getTitle())) {
							str = productDetailVO.getContent();
							break;
						}
					}
				}
			}
		}
		// 提出所有的html 标签
		str = HtmlUtil.getTextFromHtml(str);
		return str;
	}

	public SimpleProductVO getSimpleProductPrice(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String content, List<PsSkuVO> skus, List<ForcastVO> prevues,
			PrsProductPriceResultVO priceVo, Map<String, SSkuStockVO> stockMap) {
		return getSimpleProduct(product, member, opChannel, accessWay, content, skus, prevues, priceVo, stockMap);
	}

	public SimpleProductVO getSimpleProduct(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String content, List<ForcastVO> prevues) {
		return getSimpleProduct(product, member, opChannel, accessWay, content, null, prevues);
	}

	/**
	 * 获取商品基础信息
	 * 
	 * @param product
	 * @param member
	 * @return
	 */
	public SimpleProductVO getSimpleProduct(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String content, List<PsSkuVO> skuList, List<ForcastVO> prevues) {
		SimpleProductVO basic = new SimpleProductVO();
		if (product != null) {
			basic.setId(product.getCode());// 换code
			// featureImage
			String featureImage = product.getPicList();
			if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
				featureImage = FileConstant.BASE_URL + featureImage;
			}
			basic.setFeatureImage(featureImage);
			// images
			List<String> images = product.getPicDetailMuls();
			for (int i = 0; i < images.size(); i++) {
				if (StringUtils.isNotBlank(images.get(i)) && !images.get(i).startsWith(FileConstant.BASE_URL)) {
					String image = FileConstant.BASE_URL + images.get(i);
					images.set(i, image);
				}
			}
			basic.setImages(images);
			// brand
			if (product.getBrands().size() > 0) {
				PsBrandVO brand = product.getBrands().get(0);
				if (brand != null) {
					BrandVO brandVO = new BrandVO();
					brandVO.setId(brand.getBrandId());
					brandVO.setName(brand.getBrandName());
					basic.setBrand(brandVO);
				}
			}
			// name
			basic.setName(product.getNameCn());
			// summary
			basic.setSummary(product.getDescription());
			// sold out
			basic.setSoldOut(checkIsSoldOut(product, opChannel));
			// invisible
			if (CollectionUtils.isEmpty(product.getCanSeeSku(opChannel.getCode()))
					|| CollectionUtils.isEmpty(product.getCanSaleSku(opChannel.getCode()))) {
				basic.setInvisible(true);
			} else {
				basic.setInvisible(false);
			}
			// offShelf
			List<String> onShelfChnCodes = product.getOnShelfChnCodes();
			if (CollectionUtils.isEmpty(onShelfChnCodes) || !onShelfChnCodes.contains(opChannel.getCode())) {
				basic.setOffShelf(true);
			} else {
				basic.setOffShelf(false);
			}

			if (product.getCombined()) {
				// price
				basic.setRawPrice(product.getOriginalPrice());
			} else {
				// price
				basic.setRawPrice(product.getListPrice());
			}

			String advanceTitle = "";
			// priceForecast
			PsAdvanceCampaignVO psAdvanceCampaignVO = product.getPsAdvanceCampaignVO();
			if (psAdvanceCampaignVO != null
					&& CollectionUtils.isNotEmpty(psAdvanceCampaignVO.getAdvanceCampaignList())) {
				PriceForecastVO priceForecast = new PriceForecastVO();
				List<PsCampaignVO> foreCampaigns = psAdvanceCampaignVO.getAdvanceCampaignList();
				PsCampaignVO cam = foreCampaigns.get(0);
				Date date = cam.getStartTime();
				List<BigDecimal> range = new ArrayList<BigDecimal>();
				if (null != date) {
					String dateStr = DateUtil.format(date, DateUtil.DEFAULT_DATETIME_FORMAT);
					Timestamp ts = new Timestamp(System.currentTimeMillis());
					try {
						ts = Timestamp.valueOf(dateStr);
						priceForecast.setSince(ts);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				advanceTitle = cam.getAdvancePriceTitle();
				priceForecast.setName(cam.getAdvancePriceTitle());
				BigDecimal minAdvancePrice = psAdvanceCampaignVO.getMinPrice();
				BigDecimal maxAdvancePrice = psAdvanceCampaignVO.getMaxPrice();
				range.add(minAdvancePrice);
				range.add(maxAdvancePrice);
				priceForecast.setRange(range);
				basic.setPriceForecast(priceForecast);
			} else {
				basic.setPriceForecast(null);
			}

			String rushTitle = "";
			// rush
			basic.setRush(false);
			int size = 0;
			boolean status = true;
			List<PsSpvVO> spvs = product.getSpvList();
			if (null != spvs && spvs.size() > 0) {
				for (PsSpvVO spv : spvs) {
					boolean state = false;
					List<PsCampaignVO> campList = spv.getCampaignList();
					if (null != campList && campList.size() > 0) {
						for (PsCampaignVO camp : campList) {
							if (camp.getDiscountTypeId() == 6) {
								size++;
								rushTitle = camp.getTitle();
								state = state || true;
							}
						}
					}
					status = status && state;
				}
			}
			if (size > 0) {
				basic.setRush(true);
			}
			// discount pirce
			BigDecimal discountPrice = product.getDiscountPrice();
			if (discountPrice != null) {
				basic.setPrice(discountPrice);
			} else {
				basic.setPrice(product.getListPrice());
			}

			// discount
			DiscVO disc = new DiscVO();
			MemberLevelEnum memberLevel = null;
			if (member != null) {
				memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
			}
			if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
					&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
					&& product.getAllowVipDiscount() == 1) {
				disc.setVipLevel(memberLevel.getCode().toString());
			}

			if (member != null && member.isInBdayDiscountTime()) {// 生日折扣改价格
				if (product.getAllowBdDiscount() == 1) {
					disc.setBirthday(true);
					disc.setVipLevel(null);
					if (product.getBdDiscountPrice() != null) {
						basic.setPrice(product.getBdDiscountPrice());
					}
				}
			}
			if (status) {
				disc.setVipLevel(null);
				disc.setBirthday(false);
			}
			basic.setDiscount(disc);

			// vipOnly
			if (null != product.getIsDiscount() && product.getIsDiscount() == 1 && member != null
					&& member.getMemberLevel() > 1)
				basic.setVipOnly(true);

			// 设置是否月送
			if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
				basic.setMonthSend(true);
				if (product.getFlowerMonProductionType() != null && SFlowerProductionTypeEnum.STORE.getValue()
						.equals(product.getFlowerMonProductionType().byteValue())) {
					basic.setMonthSendDistType(FlowerMonthDistType.SHOP);
				}
			}
			// activityDesc
			if (!rushTitle.isEmpty()) {
				content = rushTitle;
			} else if (!advanceTitle.isEmpty()) {
				content = advanceTitle;
			}
			basic.setActivityDesc(content);

			List<PsSkuVO> skus = skuList;
			if (skus == null || skus.size() <= 0) {
				List<String> codes = product.getSkuCodes();
				skus = mcPsSkuService.findBySkuCodes(codes);
			}

			if (null != skus && skus.size() > 0) {
				for (PsSkuVO sku : skus) {
					if (null != sku.getCanCustomize() && sku.getCanCustomize() == 1) {
						basic.setCustomizable(true);
					}
					if (sku != null && sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
						basic.setIsOversea(true);
					}
				}
			}
			// 水印图片
			if (CollectionUtils.isNotEmpty(product.getSmallIconList())) {

				List<String> waterMark = new ArrayList<String>();
				waterMark.add(product.getSmallIconList().get(0));
				logger.info("水印图片" + waterMark);

				basic.setWaterMarkImage(waterMark);
			}

			// 预售商品
			// 查询预告商品信息

			if (CollectionUtils.isNotEmpty(prevues)) {
				for (ForcastVO prevue : prevues) {
					Date endtime = prevue.getEndTime();
					if (prevue.isLevel()) {

						Date endtime00 = prevue.getEndTime();
						Date endtime0 = prevue.getEndTime();
						Date endtime1 = prevue.getEndTime();
						Date endtime2 = prevue.getEndTime();
						Date endtime3 = prevue.getEndTime();
						List<LevelInfo> levels = prevue.getLevels();
						if (CollectionUtils.isNotEmpty(levels)) {
							for (LevelInfo level : levels) {
								switch (level.getMemberLevel()) {

								case -1:
									endtime00 = level.getEndTime();
									break;
								case 0:
									endtime0 = level.getEndTime();
									break;
								case 1:
									endtime1 = level.getEndTime();
									break;
								case 2:
									endtime2 = level.getEndTime();
									break;
								case 3:
									endtime3 = level.getEndTime();
									break;
								default:
									break;
								}
							}

						}

						logger.info("当前会员等级 memberlevel={}", member.getMemberLevel());
						switch (member.getMemberLevel()) {
						case -1:
							endtime = endtime00;
							break;
						case 0:
							endtime = endtime0;
							break;
						case 1:
							endtime = endtime1;
							break;
						case 2:
							endtime = endtime2;
							break;
						case 3:
							endtime = endtime3;
							break;
						default:
							break;
						}
					}
					logger.info("会员时间 endtime={}", endtime);

					if (null != prevue && endtime.after(new Date())) {
						basic.setForetell(true);
						basic.setSoldOut(false);// 预告商品不售罄
						break;
					}
				}
			}

			// presale
			basic.setHasPresale(product.getHasPresale());

			if (null != product.getIsBigDetailImg() && product.getIsBigDetailImg() == 1) {
				logger.info("是大图，大图内容为 src= {}", product.getDetailBigimgUrl());
				BigPicVO bigPic = new BigPicVO();
				bigPic.setIsBigPic(true);
				String src = product.getDetailBigimgUrl();
				if (StringUtils.isNotBlank(src) && !src.startsWith(FileConstant.BASE_URL)) {
					src = FileConstant.BASE_URL + src;
				}
				bigPic.setSrc(src);
				basic.setBigPic(bigPic);
			} else {
				basic.setBigPic(null);
			}

		}

		return basic;
	}

	/**
	 * 获取商品基础信息
	 * 
	 * @param product
	 * @param member
	 * @return
	 */
	public SimpleProductVO getSimpleProduct(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String content, List<PsSkuVO> skuList, List<ForcastVO> prevues,
			PrsProductPriceResultVO priceVo, Map<String, SSkuStockVO> stockMap) {
		SimpleProductVO basic = new SimpleProductVO();
		if (product != null) {
			basic.setId(product.getCode());// 换code
			// featureImage
			String featureImage = product.getPicList();
			if (StringUtils.isNotBlank(featureImage) && !featureImage.startsWith(FileConstant.BASE_URL)) {
				featureImage = FileConstant.BASE_URL + featureImage;
			}
			basic.setFeatureImage(featureImage);
			// images
			List<String> images = product.getPicDetailMuls();
			for (int i = 0; i < images.size(); i++) {
				if (StringUtils.isNotBlank(images.get(i)) && !images.get(i).startsWith(FileConstant.BASE_URL)) {
					String image = FileConstant.BASE_URL + images.get(i);
					images.set(i, image);
				}
			}
			basic.setImages(images);
			// brand
			if (product.getBrands().size() > 0) {
				PsBrandVO brand = product.getBrands().get(0);
				if (brand != null) {
					BrandVO brandVO = new BrandVO();
					brandVO.setId(brand.getBrandId());
					brandVO.setName(brand.getBrandName());
					basic.setBrand(brandVO);
				}
			}
			// name
			basic.setName(product.getNameCn());
			// summary
			basic.setSummary(product.getDescription());
			// sold out
			Integer stockNum = getProductStock(product, opChannel);
			basic.setSoldOut(NumberUtil.isNullOrZero(stockNum));
			// 库存预警
			basic.setStockWarn(stockAdapter.stockWarn(stockNum));
			// combined
			basic.setCombined(product.getCombined());
			
			if(product.getDisplayInCombinedArea() != null){
				// combination
				basic.setCombination(BooleanUtils.toBoolean(product.getDisplayInCombinedArea()));
			}

			if(product.getIsBeastCourse() != null){
				basic.setPointDeduction(BooleanUtils.toBoolean(product.getIsBeastCourse()));
			}
			// 是否野兽课堂
			
			// unSaleDesc
			basic.setUnSaleDesc(product.getIposProdStatus() != null ? product.getIposProdStatus().getDesc() : "");
			// invisible
			if (CollectionUtils.isEmpty(product.getCanSeeSku(opChannel.getCode()))
					|| CollectionUtils.isEmpty(product.getCanSaleSku(opChannel.getCode()))) {
				basic.setInvisible(true);
			} else {
				basic.setInvisible(false);
			}
			// offShelf
			List<String> onShelfChnCodes = product.getOnShelfChnCodes();
			if (CollectionUtils.isEmpty(onShelfChnCodes) || !onShelfChnCodes.contains(opChannel.getCode())) {
				basic.setOffShelf(true);
			} else {
				basic.setOffShelf(false);
			}

			String advanceTitle = "";
			// priceForecast
			PsAdvanceCampaignVO psAdvanceCampaignVO = product.getPsAdvanceCampaignVO();
			if (psAdvanceCampaignVO != null
					&& CollectionUtils.isNotEmpty(psAdvanceCampaignVO.getAdvanceCampaignList())) {
				PriceForecastVO priceForecast = new PriceForecastVO();
				List<PsCampaignVO> foreCampaigns = psAdvanceCampaignVO.getAdvanceCampaignList();
				PsCampaignVO cam = foreCampaigns.get(0);
				Date date = cam.getStartTime();
				List<BigDecimal> range = new ArrayList<BigDecimal>();
				if (null != date) {
					String dateStr = DateUtil.format(date, DateUtil.DEFAULT_DATETIME_FORMAT);
					Timestamp ts = new Timestamp(System.currentTimeMillis());
					try {
						ts = Timestamp.valueOf(dateStr);
						priceForecast.setSince(ts);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				advanceTitle = cam.getAdvancePriceTitle();
				List<PsCampaignSectionVO> sectionList = cam.getCampaignSectionList();
				if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) && sectionList.size() == 1) {
					PsCampaignSectionVO section = sectionList.get(0);
					if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
							|| section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
						advanceTitle = advanceTitle + " ￥" + section.getFactor();
					} else if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
							|| section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId())) {
						advanceTitle = advanceTitle + " " + section.getFactor() + "折";
					}
				}
				priceForecast.setName(cam.getAdvancePriceTitle());
				BigDecimal minAdvancePrice = psAdvanceCampaignVO.getMinPrice();
				BigDecimal maxAdvancePrice = psAdvanceCampaignVO.getMaxPrice();
				range.add(minAdvancePrice);
				range.add(maxAdvancePrice);
				priceForecast.setRange(range);
				basic.setPriceForecast(priceForecast);
			} else {
				basic.setPriceForecast(null);
			}

			String rushTitle = "";
			// rush
			basic.setRush(false);
			List<PsSpvVO> spvs = product.getSpvList();
			
			BigDecimal discountPrice = product.getDiscountPrice();
			if (CollectionUtils.isNotEmpty(spvs)) {
				for (PsSpvVO spv : spvs) {
					List<PsCampaignVO> campList = spv.getCampaignList();
					// spv是否参加抢购活动
					if (this.checkCampaignInDiscountType(campList, DiscountTypeEnum.PANIC_BUY)) {
						basic.setRush(true); // 商品参加抢购活动
						PsCampaignVO camp = getCampaignByDiscountType(campList, DiscountTypeEnum.PANIC_BUY);
						rushTitle = camp.getTitle();
						List<PsCampaignSectionVO> sectionList = camp.getCampaignSectionList();
						if (null != sectionList && CollectionUtils.isNotEmpty(sectionList) && sectionList.size() == 1) {
							PsCampaignSectionVO section = sectionList.get(0);
							if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_AMOUNT.getId())
									|| section.getFactorType().equals(FactorTypeEnum.FIXED_AMOUNT.getId())) {
								rushTitle = rushTitle + " ￥" + section.getFactor();
							} else if (section.getFactorType().equals(FactorTypeEnum.DIFFERENT_DISCOUNT.getId())
									|| section.getFactorType().equals(FactorTypeEnum.FIXED_DISCOUNT.getId())) {
								rushTitle = rushTitle + " " + section.getFactor() + "折";
							}
						}
						break;
					}

				}
				
				
				// 列表价（取spv上最小的价格）
				Map<Long, BigDecimal> map = combineSpvPrice(priceVo);
				int mcount = 0;
				// 折扣价格和原价取有库存的spv的价格	 ipos不看库存
				for (PsSpvVO spv : spvs) {
					if (Integer.valueOf(1).equals(opChannel.getChannelType()) || getSpvStock(spv, stockMap) > 0) {
						BigDecimal spvDiscountPrice = map.get(spv.getSpvId());
						if (mcount == 0 || spvDiscountPrice.compareTo(discountPrice) <= 0) {
							discountPrice = spvDiscountPrice;
							mcount++;
						}
					}
				}

			}


			
			BigDecimal rawPrice = BigDecimal.ZERO;
			if (product.getCombined()) {
				rawPrice = product.getOriginalPrice();
			} else {
				rawPrice = product.getListPrice();
			}
			
			if (null != discountPrice) {
				basic.setPrice(discountPrice);
			}else {
				basic.setPrice(rawPrice);
			}
			if (null != rawPrice) {
				basic.setRawPrice(rawPrice);
			}

			// discount
			DiscVO disc = new DiscVO();
			MemberLevelEnum memberLevel = null;
			if (member != null) {
				memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
			}
			if (memberLevel != null && !memberLevel.equals(MemberLevelEnum.NORMAL)
					&& !memberLevel.equals(MemberLevelEnum.VIP) && product.getAllowVipDiscount() != null
					&& product.getAllowVipDiscount() == 1) {
				disc.setVipLevel(memberLevel.getCode().toString());
			}

			if (basic.getRush()) {
				disc.setVipLevel(null);
				disc.setBirthday(false);
			}
			basic.setDiscount(disc);

			// vipOnly
			if (null != product.getIsDiscount() && product.getIsDiscount() == 1 && member != null
					&& member.getMemberLevel() > 1)
				basic.setVipOnly(true);

			// activityDesc
			if (!rushTitle.isEmpty()) {
				content = rushTitle;
			} else if (!advanceTitle.isEmpty()) {
				content = advanceTitle;
			}
			basic.setActivityDesc(content);

			List<PsSkuVO> skus = skuList;
			if (skus == null || skus.size() <= 0) {
				List<String> codes = product.getSkuCodes();
				skus = mcPsSkuService.findBySkuCodes(codes);
			}

			if (null != skus && skus.size() > 0) {
				for (PsSkuVO sku : skus) {
					if (null != sku.getCanCustomize() && sku.getCanCustomize() == 1) {
						basic.setCustomizable(true);
					}
					if (sku != null && sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
						basic.setIsOversea(true);
					}
				}
			}

			// 设置是否月送
			if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
				basic.setMonthSend(true);
				if (product.getFlowerMonProductionType() != null && SFlowerProductionTypeEnum.STORE.getValue()
						.equals(product.getFlowerMonProductionType().byteValue())) {
					basic.setMonthSendDistType(FlowerMonthDistType.SHOP);
				}
				// 设置月送列表价格
				if (CollectionUtils.isNotEmpty(skus)) {
					Integer minDeliveryTimes = Integer.MAX_VALUE;
					for (PsSkuVO psSkuVO : skus) {
						if (psSkuVO.getDeliveryTimes() < minDeliveryTimes) {
							minDeliveryTimes = psSkuVO.getDeliveryTimes();
						}
					}

					if (product.getCombined()) {
						basic.setRawPrice(product.getOriginalPrice().multiply(new BigDecimal(minDeliveryTimes)));
					} else {
						basic.setRawPrice(product.getListPrice().multiply(new BigDecimal(minDeliveryTimes)));
					}

					if (discountPrice != null) {
						basic.setPrice(discountPrice.multiply(new BigDecimal(minDeliveryTimes)));
					} else {
						basic.setPrice(basic.getRawPrice());
					}
				}
			}
			// 水印图片
			if (CollectionUtils.isNotEmpty(product.getSmallIconList())) {

				List<String> waterMark = new ArrayList<String>();
				waterMark.add(product.getSmallIconList().get(0));
				logger.info("水印图片" + waterMark);

				basic.setWaterMarkImage(waterMark);
			}

			// 预售商品
			// 查询预告商品信息

			if (CollectionUtils.isNotEmpty(prevues)) {
				for (ForcastVO prevue : prevues) {
					Date endtime = prevue.getEndTime();
					if (prevue.isLevel()) {

						Date endtime00 = prevue.getEndTime();
						Date endtime0 = prevue.getEndTime();
						Date endtime1 = prevue.getEndTime();
						Date endtime2 = prevue.getEndTime();
						Date endtime3 = prevue.getEndTime();
						List<LevelInfo> levels = prevue.getLevels();
						if (CollectionUtils.isNotEmpty(levels)) {
							for (LevelInfo level : levels) {
								switch (level.getMemberLevel()) {

								case -1:
									endtime00 = level.getEndTime();
									break;
								case 0:
									endtime0 = level.getEndTime();
									break;
								case 1:
									endtime1 = level.getEndTime();
									break;
								case 2:
									endtime2 = level.getEndTime();
									break;
								case 3:
									endtime3 = level.getEndTime();
									break;
								default:
									break;
								}
							}

						}

						logger.info("当前会员等级 memberlevel={}", member.getMemberLevel());
						switch (member.getMemberLevel()) {
						case -1:
							endtime = endtime00;
							break;
						case 0:
							endtime = endtime0;
							break;
						case 1:
							endtime = endtime1;
							break;
						case 2:
							endtime = endtime2;
							break;
						case 3:
							endtime = endtime3;
							break;

						default:
							break;
						}
					}
					logger.info("会员时间 endtime={}", endtime);

					if (null != prevue && endtime.after(new Date())) {
						basic.setForetell(true);
						basic.setSoldOut(false);// 预告商品不售罄
						break;
					}
				}
			}

			// presale
			basic.setHasPresale(product.getHasPresale());

			basic.setCampaigns(this.getSimpleProductCampaigns(product, getProductStock(product, opChannel)));

			if (null != product.getIsBigDetailImg() && product.getIsBigDetailImg() == 1) {
				logger.info("是大图，大图内容为 src= {}", product.getDetailBigimgUrl());
				BigPicVO bigPic = new BigPicVO();
				bigPic.setIsBigPic(true);
				String src = product.getDetailBigimgUrl();
				if (StringUtils.isNotBlank(src) && !src.startsWith(FileConstant.BASE_URL)) {
					src = FileConstant.BASE_URL + src;
				}
				bigPic.setSrc(src);
				basic.setBigPic(bigPic);
			} else {
				basic.setBigPic(null);
			}
			// hasJit
			basic.setHasJit(this.iposProductIsJit(product, opChannel));

            // 设置新品标签
            basic.setNewcomerTag(PriceResultUtils.getProductNewcomerTag(priceVo));
		}
		return basic;
	}
	
	private boolean iposProductIsJit(PsProductVO product, OpChannelVO opChannel) {
		// 非线下
		if (!Integer.valueOf(1).equals(opChannel.getChannelType())) {
			return false;
		}
		// 非来单
		if (!Integer.valueOf(1).equals(product.getIsJit())) {
			return false;
		}
		// 来单预售
		if (BooleanUtils.isTrue(product.getPresale())) {
			return true;
		}
		// 来单
		List<PsChnStockVO> chnStockList = product.getStocks();
		if (CollectionUtils.isNotEmpty(chnStockList)) {
			for (PsChnStockVO chnStock : chnStockList) {
				if (!opChannel.getCode().equals(chnStock.getChnCode())) {
					continue;
				}
				if (chnStock.getFurniture() == 0 && chnStock.getPresale() == 0 && chnStock.getStock() == 0) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 
	 * @param products
	 * @param member
	 * @param opChannel
	 * @return
	 */
	public List<SimpleProductVO> getSimpleProducts(List<PsProductVO> products, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		logger.info("商品列表数据共有size={}", products.size());
		List<SimpleProductVO> list = new ArrayList<SimpleProductVO>();

		List<String> codes = new ArrayList<String>();

		if (CollectionUtils.isNotEmpty(products)) {
			for (PsProductVO product : products) {
				if (null != product) {
					codes.add(product.getCode());
				}
			}
		}
		Map<String, ProductCopywriterVO> map = mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);

		if (CollectionUtils.isNotEmpty(products)) {

			Map<String, List<PsSkuVO>> mapProductId = GetSkusByProduct(products);

			Map<String, List<ForcastVO>> prevues = new HashMap<>();
			boolean prevueBool = forecastAdapter.checkPrevueProduct();
			if (prevueBool) {
				prevues = forecastAdapter.getPrevueProductList(codes);
			}
			PrsCalcProductDTO arg0 = new PrsCalcProductDTO();

			priceAdapter.assemblePriceProducts(arg0, products, mapProductId, member, opChannel, accessWay);
			logger.info("商品列表页批量获取商品价格");
			Map<Long, PrsProductPriceResultVO> priceVos = prsPriceService.calculatePrs4ProductList(arg0);

			List<String> skuCodes = new ArrayList<String>();
			for (PsProductVO product : products) {
				if (null != product) {
					List<PsSkuVO> psSkuVOList = mapProductId.get(product.getId());

					if (CollectionUtils.isNotEmpty(psSkuVOList)) {
						for (PsSkuVO psSkuVO : psSkuVOList) {
							skuCodes.add(psSkuVO.getId());
						}
					}

				}
			}

			Map<String, SSkuStockVO> stockMap = sStockService.getSkuStocks(skuCodes, opChannel.getWarehouseForSales());

			for (PsProductVO product : products) {
				if (null != product) {
					String content = "";
					ProductCopywriterVO tag = map.get(product.getCode());
					if (null != tag) {
						content = tag.getContent();
					}
					List<PsSkuVO> psSkuVOList = mapProductId.get(product.getId());

					list.add(this.getSimpleProductPrice(product, member, opChannel, accessWay, content, psSkuVOList,
							prevues.get(product.getCode()), priceVos.get(Long.parseLong(product.getId())), stockMap));

				}
			}
		}
		return list;
	}

	/*
	 * 批量获取PsSkuVO信息
	 */
	public Map<String, List<PsSkuVO>> GetSkusByProduct(List<PsProductVO> products) {
		Map<String, List<PsSkuVO>> map = new HashMap<String, List<PsSkuVO>>();
		if (CollectionUtils.isEmpty(products)) {
			logger.warn("products is null");
			return map;
		}

		Map<String, String> mapSkus = new HashMap<String, String>();
		for (PsProductVO product : products) {
			if (product == null || product.getSkuCodes() == null || product.getSkuCodes().size() <= 0) {
				logger.warn("product is null");
				continue;
			}
			List<String> productSkuCodeList = product.getSkuCodes();
			if (CollectionUtils.isEmpty(productSkuCodeList)) {
				logger.warn("productSkuCodeList is null");
				continue;
			}
			for (String skuItem : productSkuCodeList) {
				if (skuItem == null || skuItem.length() <= 0) {
					logger.warn("skuItem is null");
					continue;
				}
				mapSkus.put(skuItem, skuItem);
			}
		}
		List<String> skuList = new ArrayList<String>();
		for (Map.Entry<String, String> entry : mapSkus.entrySet()) {
			skuList.add(entry.getKey());
		}
		if (skuList.size() <= 0) {
			logger.warn("skuList is null");
			return map;
		}
		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuList);
		if (skus == null || skus.size() <= 0) {
			logger.warn("skus is null");
			return map;
		}
		logger.info("skus.size()={}", skus.size());
		Map<String, PsSkuVO> skuMap = new HashMap<String, PsSkuVO>();
		for (PsSkuVO psSkuItem : skus) {
			skuMap.put(psSkuItem.getSkuCode(), psSkuItem);
		}

		// 组装skuu
		for (PsProductVO product : products) {
			if (product == null || product.getSkuCodes() == null || product.getSkuCodes().size() <= 0) {
				logger.warn("product is null2");
				continue;
			}
			List<String> productSkuCodeList = product.getSkuCodes();
			if (CollectionUtils.isEmpty(productSkuCodeList)) {
				logger.warn("productSkuCodeList is null");
				continue;
			}

			List<PsSkuVO> psSkuVOList = new ArrayList<PsSkuVO>();
			for (String skuItem : productSkuCodeList) {
				if (skuItem == null || skuItem.length() <= 0) {
					logger.warn("skuItem is null");
					continue;
				}
				PsSkuVO psSkuVOItem = skuMap.get(skuItem);
				if (psSkuVOItem == null) {
					logger.warn("psSkuVOItem is null");
					continue;
				}
				psSkuVOList.add(psSkuVOItem);
			}
			map.put(product.getId(), psSkuVOList);
		}
		return map;
	}

	/**
	 * 获取badges
	 * 
	 * @param product
	 */
	public List<ProductBadgeVO> getProductBadges(PsProductVO product, List<PsSkuVO> skus, Boolean furniture) {
		List<ProductBadgeVO> badges = Lists.newArrayList();

		if (!furniture) {

			// 正品保证（全部商品）
			ProductBadgeVO baged1 = new ProductBadgeVO();
			baged1.setColor(badgeColor);
			baged1.setIcon(badgeIcon);
			baged1.setText("正品保证");
			badges.add(baged1);
		}

		// 香港直邮，价格已含税（海淘商品）
//		ProductBadgeVO baged2 = new ProductBadgeVO();
//		baged2.setColor(badgeColor);
//		baged2.setIcon(badgeIcon);
//		baged2.setText("");
		ProductBadgeVO baged3 = new ProductBadgeVO();
		baged3.setColor(badgeColor);
		baged3.setIcon(badgeIcon);
		baged3.setText("价格已含跨境电商综合税");
		// List<String> codes = product.getSkuCodes();
		// List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);
		if (null != skus && skus.size() > 0) {
			for (PsSkuVO sku : skus) {
				if (sku != null && sku.getCrossBorderFlag() != null && sku.getCrossBorderFlag().equals(1)) {
					//badges.add(baged2);
					badges.add(baged3);
					break;
				}
			}
		}

		// 品牌授权
		ProductBadgeVO baged4 = new ProductBadgeVO();
		baged4.setColor(badgeColor);
		baged4.setIcon(badgeIcon);
		baged4.setText("品牌授权");

		if (product.getBrands().size() > 0) {
			PsBrandVO brand = product.getBrands().get(0);
			if (brand != null) {
				if (null != brand.getAuthLetter()) {
					badges.add(baged4);
				}
			}
		}

		ProductBadgeVO baged5 = new ProductBadgeVO();
		baged5.setColor(badgeColor);
		baged5.setIcon(badgeIcon);
		baged5.setText("免费配送");
		baged5.setLink("beastapp://entry?name=big-furniture-tips");
		ProductBadgeVO baged6 = new ProductBadgeVO();
		baged6.setColor(badgeColor);
		baged6.setIcon(badgeIcon);
		baged6.setText("代客存储");
		baged6.setLink("beastapp://entry?name=big-furniture-tips");
		ProductBadgeVO baged7 = new ProductBadgeVO();
		baged7.setColor(badgeColor);
		baged7.setIcon(badgeIcon);
		baged7.setText("7日保价");
		baged7.setLink("beastapp://entry?name=big-furniture-tips");
		ProductBadgeVO baged8 = new ProductBadgeVO();
		baged8.setColor(badgeColor);
		baged8.setIcon(badgeIcon);
		baged8.setText("3年质保");
		baged8.setLink("beastapp://entry?name=big-furniture-tips");
		if (furniture) {
			badges.add(baged5);
			badges.add(baged6);
			badges.add(baged7);
			badges.add(baged8);
		}
		return badges;
	}

	/**
	 * 大家具提示语
	 * 
	 * @param furniture
	 */
	public List<ProductTipVO> getTips(Boolean furniture, LogisticsType logisticsType) {
		List<ProductTipVO> tips = Lists.newArrayList();
		if (furniture) {
			tips.add(new ProductTipVO("特别提醒：", "大件家具下单后，客服会与您联系确认。大件家具的物流配送时效比普通快递有所延长，超出配送区域的，将为您免费发至最近的服务网点，由您自提。",
					""));
		}
		if (LogisticsType.FEDEX.id == logisticsType.getId()) {
			tips.add(new ProductTipVO("特别提醒：", "仅限联邦快递24小时可达地区,为方便物流的跟踪,请务必填写收件地址的正确邮编,以免造成投递失败。",
					"本产品可免费享受指定日期送达服务，请在确认订单时选择"));
		} else if (LogisticsType.SHOP.id == logisticsType.getId()) {
			tips.add(new ProductTipVO("", "", "本产品可免费享受指定日期送达服务，请在确认订单时选择"));
		}
		return tips;
	}

	/**
	 * 获取商品规格
	 * 
	 * @param product
	 * @return
	 */
	public ProductVariantVO getProductVariant(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		if (product != null) {
			logger.info("product不为空");
			Date start = new Date();
			// 月送鲜花
			if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
				return flowerMonthShowAdapter.getFlowerMonthVariant(product, member, opChannel);
			}
			List<PsSpvVO> spvs = product.getSpvList();

			ProductVariantVO variant = new ProductVariantVO();
			if (CollectionUtils.isNotEmpty(spvs)) {
				Map<Long, SpvVO> spvMap = spvAdapter.getSpvWithoutDiscountNew(spvs, Lists.newArrayList(product), member,
						opChannel, null);
				// 设置折扣价
				/*
				 * if (member.isInBdayDiscountTime()) { // 生日折扣改价格 if
				 * (product.getAllowBdDiscount() == 1) { for (PsSpvVO spv :
				 * spvs) { SpvVO spvVO = spvMap.get(spv);
				 * spvVO.setPrice(spv.getBdDiscountPrice()); } } } else { for
				 * (PsSpvVO spv : spvs) { SpvVO spvVO = spvMap.get(spv);
				 * spvVO.setPrice(spv.getDiscountPrice()); } }
				 */
				for (PsSpvVO spv : spvs) {
					SpvVO spvVO = spvMap.get(spv.getSpvId());
					// if (member.isInBdayDiscountTime() &&
					// product.getAllowBdDiscount() == 1) {
					// spvVO.setPrice(spv.getBdDiscountPrice());
					// } else {
					// spvVO.setPrice(spv.getDiscountPrice());
					// }
					// 是否低价销售 = 成本价高于售价的70%
					spvVO.setCheap(spv.getCostPrice().compareTo(spvVO.getRawPrice().multiply(new BigDecimal("0.7"))) == 1);
				}
				Map<String, ProductDimensionVO> pdMap = Maps.newLinkedHashMap(); // 规格信息
				for (PsSpvVO spv : spvs) {
					SpvVO spvVO = spvMap.get(spv.getSpvId());

					List<Integer> group = null;
					List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
					if (CollectionUtils.isNotEmpty(attrList)) {
						group = new ArrayList<Integer>();
						// 设置规格信息
						for (PsAttributeValuePairVO attr : attrList) {
							if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
									&& StringUtils.isNotBlank(attr.getValue())) {
								String attrName = attr.getAttrName();
								String attrValue = attr.getValue();
								ProductDimensionVO pd = pdMap.get(attrName);
								if (pd == null) {
									pd = new ProductDimensionVO();
									pd.setChoices(new ArrayList<String>());
									pd.setName(attrName);
									pdMap.put(attrName, pd);
								}
								List<String> choices = pd.getChoices();
								if (!choices.contains(attrValue))
									choices.add(attrValue);
								group.add(choices.indexOf(attrValue));
							}
						}
					}

					spvVO.setGroup(group);
				}

				Collection<ProductDimensionVO> dimensionVos = pdMap.values();
				// TODO:当规格为一个的时候不显示规格信息
				if (CollectionUtils.isNotEmpty(dimensionVos) && dimensionVos.size() == 1) {
					Iterator<ProductDimensionVO> iterator = dimensionVos.iterator();
					ProductDimensionVO vo = iterator.next();
					List<String> choices = vo.getChoices();
					if (CollectionUtils.isNotEmpty(choices) && choices.size() == 1) {
						dimensionVos = null;
					}
				}

				// 预售商品
				// 查询预告商品信息
				Boolean prevueState = false;
				List<ForcastVO> prevues = forecastAdapter.getPrevueProduct(product.getCode());
				if (CollectionUtils.isNotEmpty(prevues)) {
					for (ForcastVO prevue : prevues) {
						if (null != prevue && prevue.getEndTime().after(new Date())) {
							prevueState = true;
							break;
						}
					}
				}
				// 预告商品库存不为0
				if (prevueState) {

					Map<Long, SpvVO> spvMap2 = Maps.newLinkedHashMap();
					for (Entry<Long, SpvVO> entry : spvMap.entrySet()) {
						SpvVO spv = entry.getValue();
						spv.setLeft(999);// 给预告商品设置库存
						spvMap2.put(entry.getKey(), spv);
					}
					variant.setSpvs(spvMap2.values());
				} else {
					variant.setSpvs(spvMap.values());
				}
				variant.setDimensions(dimensionVos);
			}
			if (CollectionUtils.isNotEmpty(product.getLargeIconList())) {

				List<String> waterMark = new ArrayList<String>();
				waterMark.add(product.getSmallIconList().get(0));
				logger.info("水印图片" + waterMark);

				variant.setWaterMarkImage(waterMark);
			}
			Date end = new Date();
			logger.info("获取规格方法花费时间：{}毫秒", end.getTime() - start.getTime());
			return variant;
		}
		return null;
	}

	/**
	 * 获取商品标签
	 * 
	 * @param products
	 * @return
	 */
	public Map<PsProductVO, List<Label>> getProductLabels(Collection<PsProductVO> products) {
		return labelService.getProductLabels(products);
	}

	/**
	 * 商品动态内容
	 * 
	 * @param productContent
	 * @return
	 */
	public List<ProductDetailVO> getProductContent(List<PsDynmContentVO> productContent) {
		List<ProductDetailVO> productDetailVO = new ArrayList<ProductDetailVO>();
		if (CollectionUtils.isNotEmpty(productContent)) {
			Collections.sort(productContent, new Comparator<PsDynmContentVO>() {
				@Override
				public int compare(PsDynmContentVO o1, PsDynmContentVO o2) {
					if (o1 != null && o1.getSort() != null && o2 != null && o2.getSort() != null) {
						return o1.getSort().compareTo(o2.getSort());
					}
					return 0;
				}
			});
			for (PsDynmContentVO item : productContent) {
				ProductDetailVO detail = new ProductDetailVO();
				detail.setTitle(item.getTitleCn());
				detail.setContent(item.getContent());
				productDetailVO.add(detail);
			}
		}
		return productDetailVO;
	}

	/**
	 * 
	 * @param products
	 * @param member
	 * @param opChannel
	 * @return
	 */
	public List<SPDSimpleProductVO> getSPDSimpleProducts(List<PsProductVO> products, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay, Boolean canBuy) {
		logger.info("商品列表数据共有size={}", products.size());

		List<SPDSimpleProductVO> SPDlist = new ArrayList<SPDSimpleProductVO>();
		List<String> codes = new ArrayList<String>();
		if (CollectionUtils.isNotEmpty(products)) {
			for (PsProductVO product : products) {
				if (null != product) {
					codes.add(product.getCode());
				}
			}
		}
		Map<String, ProductCopywriterVO> map = mcPcsCopywriterService.selectProductCopywriterByProdCodes(codes);

		if (CollectionUtils.isNotEmpty(products)) {

			Map<String, List<ForcastVO>> prevues = new HashMap<>();
			boolean prevueBool = forecastAdapter.checkPrevueProduct();
			if (prevueBool) {
				prevues = forecastAdapter.getPrevueProductList(codes);
			}
			for (PsProductVO product : products) {
				if (null != product) {
					String content = "";
					ProductCopywriterVO tag = map.get(product.getCode());
					if (null != tag) {
						content = tag.getContent();
					}
					SimpleProductVO simple = this.getSimpleProduct(product, member, opChannel, accessWay, content,
							prevues.get(product.getCode()));
					SPDSimpleProductVO spd = new SPDSimpleProductVO();

					// 重新取库存
					logger.info("重新取库存 product={}，sku={}", product.getCode(), product.getSkuCodes().toString());
					Map<String, SSkuStockVO> skuStockVOMap = sStockService.getSkuStocks(product.getSkuCodes(),
							opChannel.getWarehouseForSales());
					int count = 0;
					if (null != skuStockVOMap) {
						for (int i = 0; i < product.getSkuCodes().size(); i++) {

							SSkuStockVO stock = skuStockVOMap.get(product.getSkuCodes().get(i));
							if (stock != null) {
								// 实际库存
								count = count + stock.getCanUseQuantity();
							}

						}
					}
					if (count > 0) {
						simple.setSoldOut(false);
					} else {
						simple.setSoldOut(true);
					}
					spd.setProduct(simple);
					spd.setCanBuy(canBuy);
					Boolean isFlower = false;
					if (null != product && (product.getExpressType().equals(1) || product.getExpressType().equals(2))) {
						isFlower = true;
					}
					spd.setIsFlower(isFlower);
					SPDlist.add(spd);
				}
			}
		}
		return SPDlist;
	}

	// spv价格组装并升序排序
	public Map<Long, BigDecimal> combineSpvPrice(PrsProductPriceResultVO priceVo) {

		Map<Long, BigDecimal> spvPriceMap = new HashMap<>();

		if (priceVo !=null && CollectionUtils.isNotEmpty(priceVo.getSpvPriceResultVOs())) {
			List<PrsSpvPriceResultVO> result = priceVo.getSpvPriceResultVOs();
			for (PrsSpvPriceResultVO re : result) {
				spvPriceMap.put(re.getSpvId(), re.getDiscountPrice());
			}
		}

		if(spvPriceMap.size() > 0){
			List<Map.Entry<Long, BigDecimal>> list = new ArrayList<Map.Entry<Long, BigDecimal>>(spvPriceMap.entrySet());
			Collections.sort(list, new Comparator<Map.Entry<Long, BigDecimal>>() {
				// 升序排序
				public int compare(Entry<Long, BigDecimal> o1, Entry<Long, BigDecimal> o2) {
					return o1.getValue().compareTo(o2.getValue());
				}

			});
		}
		
		return spvPriceMap;
	}

	/**
	 * 获取商品规格
	 * 
	 * @param product
	 * @return
	 */
	public ProductVariantVO getProductVariantPrice(PsProductVO product, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, Map<Long, BigDecimal> priceMap) {
		if (product != null) {
			logger.info("product不为空");
			Date start = new Date();
			// 月送鲜花
			if (YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
				return flowerMonthShowAdapter.getFlowerMonthVariant(product, member, opChannel);
			}
			List<PsSpvVO> spvs = product.getSpvList();

			ProductVariantVO variant = new ProductVariantVO();
			if (CollectionUtils.isNotEmpty(spvs)) {
				Map<Long, SpvVO> spvMap = spvPriceAdapter.getSpvPrice(spvs, Lists.newArrayList(product), member,
						opChannel, null, priceMap);
				for (PsSpvVO spv : spvs) {
					SpvVO spvVO = spvMap.get(spv.getSpvId());
					// 是否低价销售 = 成本价高于售价的70%
					spvVO.setCheap(
							spv.getCostPrice().compareTo(spvVO.getRawPrice().multiply(new BigDecimal("0.7"))) == 1);
				}
				// 预售商品
				// 查询预告商品信息
				Boolean prevueState = false;
				List<ForcastVO> prevues = forecastAdapter.getPrevueProduct(product.getCode());
				if (CollectionUtils.isNotEmpty(prevues)) {
					for (ForcastVO prevue : prevues) {
						if (null != prevue && prevue.getEndTime().after(new Date())) {
							prevueState = true;
							break;
						}
					}
				}
				Map<String, ProductDimensionVO> pdMap = Maps.newLinkedHashMap(); // 规格信息
				for (PsSpvVO spv : spvs) {
					SpvVO spvVO = spvMap.get(spv.getSpvId());

					List<Integer> group = null;
					List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
					if (CollectionUtils.isNotEmpty(attrList)) {
						group = new ArrayList<Integer>();
						// 设置规格信息
						for (PsAttributeValuePairVO attr : attrList) {
							if (attr != null && StringUtils.isNotBlank(attr.getAttrName())
									&& StringUtils.isNotBlank(attr.getValue())) {
								String attrName = attr.getAttrName();
								String attrValue = attr.getValue();
								ProductDimensionVO pd = pdMap.get(attrName);
								if (pd == null) {
									pd = new ProductDimensionVO();
									pd.setChoices(new ArrayList<String>());
									pd.setName(attrName);
									pdMap.put(attrName, pd);
								}
								List<String> choices = pd.getChoices();
								if (!choices.contains(attrValue))
									choices.add(attrValue);
								group.add(choices.indexOf(attrValue));
							}
						}
					}

					spvVO.setGroup(group);

					if (prevueState) {
						spvVO.setLeft(999);
					}
				}

				Collection<ProductDimensionVO> dimensionVos = pdMap.values();
				// TODO:当规格为一个的时候不显示规格信息
				if (CollectionUtils.isNotEmpty(dimensionVos) && dimensionVos.size() == 1) {
					Iterator<ProductDimensionVO> iterator = dimensionVos.iterator();
					ProductDimensionVO vo = iterator.next();
					List<String> choices = vo.getChoices();
					if (CollectionUtils.isNotEmpty(choices) && choices.size() == 1) {
						dimensionVos = null;
					}
				}

				variant.setDimensions(dimensionVos);
				if (CollectionUtils.isEmpty(dimensionVos)) {
					for (PsSpvVO spv : spvs) {
						SpvVO spvVO = spvMap.get(spv.getSpvId());
						spvVO.setGroup(null);
					}
				}
				List<SpvVO> spvVOS = Lists.newArrayList(spvMap.values());
				Collections.sort(spvVOS, new Comparator<SpvVO>() {
					@Override
					public int compare(SpvVO o1, SpvVO o2) {
						Integer o1Val = 0;
						Integer o2Val = 0;
						Integer campVal = 0;
						
						if(o1.getGroup()!=null && o2.getGroup()!=null){
							for (int i = 0; i < o1.getGroup().size(); i++) {
								o1Val = (Integer) o1.getGroup().toArray()[i];
								o2Val = (Integer) o2.getGroup().toArray()[i];
								campVal = o1Val.compareTo(o2Val);
								if(campVal!=0){
									break;
								}
							}
						}
						

						return campVal;
					}
				});
				variant.setSpvs(spvVOS);

				if (CollectionUtils.isNotEmpty(product.getLargeIconList())) {

					List<String> waterMark = new ArrayList<String>();
					waterMark.add(product.getSmallIconList().get(0));
					logger.info("水印图片" + waterMark);

					variant.setWaterMarkImage(waterMark);
				}
				Date end = new Date();
				logger.info("获取规格方法花费时间：{}毫秒", end.getTime() - start.getTime());
				return variant;
			}
		}
		return null;
	}

	/**
	 * 获取商品活动信息，目前只支持价格折扣和，抢购
	 * 
	 * @param product
	 * @param stock
	 * @return
	 */
	private List<ProductCampaignVO> getSimpleProductCampaigns(PsProductVO product, Integer stock) {
		List<ProductCampaignVO> result = Lists.newArrayList();
		List<ProductCampaignVO> campList = this.getProductCampaignByCampaigns(product, stock);
		List<ProductCampaignVO> advanceList = this.getProductCampaignByAdvanceCampaigns(product);
		if (CollectionUtils.isNotEmpty(campList)) {
			result.addAll(campList);
		}
		if (CollectionUtils.isNotEmpty(advanceList)) {
			result.addAll(advanceList);
		}
		return result;
	}

	/**
	 * 获取商品活动，全场和费全场取的活动限制不同 全场活动没有抢购
	 * 
	 * @param product
	 * @param stock
	 * @return
	 */
	private List<ProductCampaignVO> getProductCampaignByCampaigns(PsProductVO product, Integer stock) {
		List<ProductCampaignVO> result = Lists.newArrayList();
		List<ProductCampaignVO> panicList = Lists.newArrayList();
		List<ProductCampaignVO> priceList = Lists.newArrayList();

		if (CollectionUtils.isNotEmpty(product.getCampaignList())) {
			for (PsCampaignVO camp : product.getCampaignList()) {
				if (checkCampaignDiscountType(camp, DiscountTypeEnum.PRICE_DISCOUNT)) {
					Integer campLimit = this.getCampaignLimit(camp, stock);
					priceList.add(this.buildCampaign(camp, campLimit));
				}
			}
		}

		if (CollectionUtils.isNotEmpty(product.getSpvList())) {
			for (PsSpvVO psSpvVO : product.getSpvList()) {
				if (CollectionUtils.isNotEmpty(psSpvVO.getCampaignList())) {
					if (checkCampaignInDiscountType(psSpvVO.getCampaignList(), DiscountTypeEnum.PANIC_BUY)) {
						PsCampaignVO panicBuyCamp = getCampaignByDiscountType(psSpvVO.getCampaignList(),
								DiscountTypeEnum.PANIC_BUY);
						Integer campLimit = this.getCampaignLimit(panicBuyCamp, stock);
						panicList.add(this.buildCampaign(panicBuyCamp, campLimit));
					} else {
						for (PsCampaignVO camp : psSpvVO.getCampaignList()) {
							if (checkCampaignDiscountType(camp, DiscountTypeEnum.PRICE_DISCOUNT)) {
								Integer campLimit = this.getCampaignLimit(camp, stock);
								priceList.add(this.buildCampaign(camp, campLimit));
							}
						}
					}
				}
			}
		}
		if (CollectionUtils.isNotEmpty(panicList)) {
			result.addAll(panicList);
		}
		if (CollectionUtils.isNotEmpty(priceList)) {
			result.addAll(priceList);
		}
		return result;
	}

	/**
	 * 获取商品预告活动，返回活动排序 抢购>价钱折扣
	 * 
	 * @param product
	 * @return
	 */
	private List<ProductCampaignVO> getProductCampaignByAdvanceCampaigns(PsProductVO product) {
		List<ProductCampaignVO> result = Lists.newArrayList();
		List<PsCampaignVO> advanceList = Lists.newArrayList();
		if (null != product.getPsAdvanceCampaignVO()
				&& CollectionUtils.isNotEmpty(product.getPsAdvanceCampaignVO().getAdvanceCampaignList())) {
			advanceList.addAll(product.getPsAdvanceCampaignVO().getAdvanceCampaignList());
		}

		if (CollectionUtils.isNotEmpty(product.getSpvList())) {
			for (PsSpvVO psSpvVO : product.getSpvList()) {
				if (null != product.getPsAdvanceCampaignVO()
						&& CollectionUtils.isNotEmpty(psSpvVO.getAdvanceCampaignList())) {
					advanceList.addAll(psSpvVO.getAdvanceCampaignList());
				}
			}
		}
		if (CollectionUtils.isNotEmpty(advanceList)) {
			List<ProductCampaignVO> panicList = Lists.newArrayList();
			List<ProductCampaignVO> priceList = Lists.newArrayList();
			for (PsCampaignVO camp : advanceList) {
				if (checkCampaignDiscountType(camp, DiscountTypeEnum.PANIC_BUY)) {
					panicList.add(this.buildPreviewCampaign(camp));
				}
				if (checkCampaignDiscountType(camp, DiscountTypeEnum.PRICE_DISCOUNT)) {
					priceList.add(this.buildPreviewCampaign(camp));
				}
			}
			if (CollectionUtils.isNotEmpty(panicList)) {
				result.addAll(panicList);
			}
			if (CollectionUtils.isNotEmpty(priceList)) {
				result.addAll(priceList);
			}
		}
		return result;
	}

	/**
	 * 校验活动类型
	 * 
	 * @param camp
	 * @param discountType
	 * @return
	 */
	private Boolean checkCampaignDiscountType(PsCampaignVO camp, DiscountTypeEnum discountType) {
		return discountType.getId().equals(camp.getDiscountTypeId());
	}

	/**
	 * 构建商品活动展示信息
	 * 
	 * @param camp
	 * @param campaignLimit
	 * @return
	 */
	private ProductCampaignVO buildCampaign(PsCampaignVO camp, Integer campaignLimit) {
		DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.getEnumById(camp.getDiscountTypeId());
		ProductCampaignVO campaignVO = new ProductCampaignVO();
		campaignVO.setBgTime(camp.getStartTime());
		campaignVO.setEdTime(camp.getExpireTime());
		campaignVO.setName(camp.getTitle());
		campaignVO.setDiscountType(discountTypeEnum.name());
		campaignVO.setPreview(Boolean.FALSE);
		campaignVO.setLimit(campaignLimit);
		return campaignVO;
	}

	/**
	 * 构建商品预告活动展示信息
	 * 
	 * @param camp
	 * @return
	 */
	private ProductCampaignVO buildPreviewCampaign(PsCampaignVO camp) {
		DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.getEnumById(camp.getDiscountTypeId());
		ProductCampaignVO campaignVO = new ProductCampaignVO();
		campaignVO.setBgTime(camp.getStartTime());
		campaignVO.setEdTime(camp.getExpireTime());
		campaignVO.setName(camp.getTitle());
		campaignVO.setDiscountType(discountTypeEnum.name());
		campaignVO.setPreview(Boolean.TRUE);
		return campaignVO;
	}

	/**
	 * 获取商品参加活动数量限制
	 *
	 * @param camp
	 * @param stock
	 * @return
	 */
	private Integer getCampaignLimit(PsCampaignVO camp, Integer stock) {

		if (NumberUtil.isNullOrZero(camp.getPanicBuyAmount()) || camp.getPanicBuyAmount() == -1
				|| camp.getPanicBuyAmount() > stock) {
			return stock;
		}
		return camp.getPanicBuyAmount();
	}

	/**
	 * 获取skuCode库存
	 * 
	 * @param camp
	 * @param stockMap
	 * @return
	 */
	private Integer getSkuStock(String skuCode, PsCampaignVO camp, Map<String, SSkuStockVO> stockMap) {
		Integer stock = 0;
		SSkuStockVO stockVO = stockMap.get(skuCode);
		if (stockVO == null) {
			return stock; // sku库存为空则返回库存数0
		}
		// 抢购库存特殊处理
		if (camp != null && this.checkCampaignDiscountType(camp, DiscountTypeEnum.PANIC_BUY)) {
			CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
			campaignStreamVO.setCampaignCode(camp.getCode());
			campaignStreamVO.setSkuCode(skuCode);
			ServiceResp<Integer> resp = campaignLimitService.getPanicLeftAmount(campaignStreamVO);
			Integer limitStock = resp.getBean();
			if (NumberUtil.isNullOrZero(resp.getBean())) {
				limitStock = 0;
			}

			if (limitStock != -1) {
				stock = limitStock;
			}
		} else if (stockVO.getCanUseQuantity() > 0) {
			stock += stockVO.getCanUseQuantity();
		}
		return stock;
	}

	/**
	 * 获取Spv库存 1、组合商品库存 subSkuStock=skuStock/quantity(spv中sku数量) spvStock =
	 * subSkuStock[] =>min subSkuStock 2、普通商品库存数 spvStock = skuStock
	 * 
	 * @param spv
	 * @param stockMap
	 * @return
	 */
	private Integer getSpvStock(PsSpvVO spv, Map<String, SSkuStockVO> stockMap) {
		Integer spvStock = 0;
		PsCampaignVO panicBuyCamp = this.getCampaignByDiscountType(spv.getCampaignList(), DiscountTypeEnum.PANIC_BUY);

		if (spv.getCombined()) {
			if (CollectionUtils.isNotEmpty(spv.getSkuCombinationList())) {
				spvStock = Integer.MAX_VALUE;
				for (PsSkuCombinationVO psc : spv.getSkuCombinationList()) {
					Integer subSkuStock = this.getSkuStock(psc.getSubSkuCode(), panicBuyCamp, stockMap);
					if (subSkuStock == 0) {
						spvStock = 0;
						break;
					} else {
						if (psc.getQuantity() > 0) {
							Integer tempSpvStock = subSkuStock / psc.getQuantity();
							if (tempSpvStock < spvStock) {
								spvStock = tempSpvStock;
							}
						}

					}
				}
			}
		} else {
			spvStock = this.getSkuStock(spv.getSkuCode(), panicBuyCamp, stockMap);
		}

		return spvStock;
	}

	/**
	 * 获取活动列表指定折扣类型的活动
	 * 
	 * @param camps
	 * @param discountType
	 * @return
	 */
	private PsCampaignVO getCampaignByDiscountType(List<PsCampaignVO> camps, DiscountTypeEnum discountType) {
		if (CollectionUtils.isNotEmpty(camps)) {
			for (PsCampaignVO camp : camps) {
				if (discountType.getId().equals(camp.getDiscountTypeId())) {
					return camp;
				}
			}
		}
		return null;
	}

	/**
	 * 校验活动列表是否包含指定折扣类型
	 * 
	 * @param camps
	 * @param discountType
	 * @return
	 */
	private Boolean checkCampaignInDiscountType(List<PsCampaignVO> camps, DiscountTypeEnum discountType) {
		return null != this.getCampaignByDiscountType(camps, discountType);
	}

}
