package com.thebeastshop.pegasus.channelservice.adapter.product;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.redis.util.RedisClient;
import com.thebeastshop.forcast.service.ForcastService;
import com.thebeastshop.forcast.vo.ForcastQueryResp;
import com.thebeastshop.forcast.vo.ForcastVO;
import com.thebeastshop.forcast.vo.LevelInfo;
import com.thebeastshop.forcast.vo.SubscribeQueryResp;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.item.ProductItemVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.product.PrevueVO;
import org.apache.commons.collections.CollectionUtils;
import org.forest.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 预售适配 Created by GFL on 2017/10/31.
 */
@Component
public class ForecastAdapter {

	private static Logger logger = LoggerFactory.getLogger(ForecastAdapter.class);

	private String FORECAST_PROD_MAP_REDIS_KEY = "NEW-PRODUCT:FORECAST";

	private String ISCHECK_FORECAST = "ISCHECK_FORECAST_CS";
	private String FORESHOW_MESSAGE = "该商品XXX开售，先加入购物车吧！";

	// /**
	// * 生成prevue Key
	// *
	// * @param articleId
	// * @return
	// */
	// private static String buildPrevueKey(String code) {
	//
	// return "forecast_" + code;
	// }

	/**
	 * 预售服务
	 */
	@Autowired
	private ForcastService forcastService;

	@Autowired
	private RedisClient redisClient;

	@Autowired
	private MemberQueryService memberQueryService;

	public List<ForcastVO> getPrevueProduct(String code) {
		// logger.info("获取预告商品");
		List<ForcastVO> prodcutPrevue = new ArrayList<ForcastVO>();
		String state = redisClient.getCache(ISCHECK_FORECAST);
		if (null != state && state.equals("TRUE")) {
			logger.info("缓存ISCHECK_FORECAST，没有预告商品");
			return prodcutPrevue;
		}
		logger.info("没有缓存ISCHECK_FORECAST，去查询具体商品");
		Map<String, List<ForcastVO>> prevueList = getAllForecastProd();
		if (null != prevueList && prevueList.containsKey(code)) {
			prodcutPrevue = prevueList.get(code);
		}
		return prodcutPrevue;
	}

	public Map<String, List<ForcastVO>> getPrevueProductList(List<String> codes) {
		logger.info("获取预告商品");
		Map<String, List<ForcastVO>> prevueList = new HashMap<>();
		String state = redisClient.getCache(ISCHECK_FORECAST);
		if (null != state && state.equals("TRUE")) {
			logger.info("缓存ISCHECK_FORECAST，没有预告商品");
			return prevueList;
		}
		logger.info("没有缓存ISCHECK_FORECAST，去查询具体商品");
		prevueList = getAllForecastProd();
		return prevueList;
	}


	public boolean checkPrevueProduct() {
		logger.info("获取是否有预告商品");

		String state = redisClient.getCache(ISCHECK_FORECAST);
		if (null != state && state.equals("TRUE")) {
			logger.info("缓存ISCHECK_FORECAST，没有预告商品");
			return false;
		}

		return true;

	}

	private Map<String, List<ForcastVO>> getAllForecastProd() {
		Map<String, List<ForcastVO>> prevueMap = redisClient.getCache(FORECAST_PROD_MAP_REDIS_KEY);
		if (null == prevueMap) {
			prevueMap = new HashMap<>();
			ForcastQueryResp resp = forcastService.queryValidForecast();
			List<ForcastVO> forecasts = resp.getData();
			if (CollectionUtils.isNotEmpty(forecasts)) {
				logger.info("获取预告信息，共有预告size：{} 个", forecasts.size());
				for (ForcastVO forecast : forecasts) {
					List<String> products = forecast.getProducts();
					for (String product : products) {
						List<ForcastVO> proPrevues = new ArrayList<ForcastVO>();
						if (null != prevueMap && prevueMap.containsKey(product)) {
							proPrevues.addAll(prevueMap.get(product));
						}
						proPrevues.add(forecast);
						logger.info("是否有level={}", forecast.isLevel());
						prevueMap.put(product, proPrevues);
					}
				}
				redisClient.putCache(FORECAST_PROD_MAP_REDIS_KEY, prevueMap, 300L);
			} else {
				logger.info("服务查询没有预告商品，存入缓存ISCHECK_FORECAST");
				redisClient.putCache(ISCHECK_FORECAST, "TRUE", 300L);
			}
		}
		return prevueMap;
	}

	/**
	 * 设置购物车预告信息
	 *
	 * @param packVos
	 */
	public void setCartPackVOsForecast(List<CartProductPackVO> packVos, MemberLevelEnum levelEnum) {
		StringBuffer tipText = new StringBuffer();
		if (CollectionUtils.isNotEmpty(packVos)) {

			if (checkPrevueProduct()) {
				for (CartProductPackVO packVo : packVos) {
					if (CartPackSource.RAW.equals(packVo.getSource())) {
						tipText.setLength(0);
						List<ForcastVO> forcastVOs = getPrevueProduct(packVo.getProductId());
						if (CollectionUtils.isNotEmpty(forcastVOs)) {
							for (ForcastVO forcastVO : forcastVOs) {
								// 展示过期文案
								String endDateStr = DateUtil.format(forcastVO.getEndTime(), "MM月dd日 HH:mm");
								// 预告校验结束时间，根据会员等级获取
								Date endDate = this.getMemberLevelForecastTime(forcastVO, levelEnum);
								// 在预告时间内
								if (DateUtil.isInTime(forcastVO.getStartTime(), endDate, null)) {
									packVo.getInvalid().setInvalid(Boolean.TRUE);
									tipText.append("即将开售").append("|").append(endDateStr).append("开售");
									// 追加会员等级提示文案
									tipText.append(this.getMemberLevelAdvanceText(forcastVO));
									packVo.getInvalid().setDesc(tipText.toString());
									packVo.getSpv().setLeft(100);
									break;
								}
							}
						}
					}
				}
			}

		}
	}

	/**
	 * 校验商品是否为预告商品
	 *
	 * @param productCode
	 */
	public Boolean checkForecastProduct(String productCode, MemberLevelEnum memberLevelEnum) {

		if (StringUtils.isNotEmpty(productCode)) {
			List<ForcastVO> forcastVOs = getPrevueProduct(productCode);
			if (CollectionUtils.isNotEmpty(forcastVOs)) {
				for (ForcastVO forcastVO : forcastVOs) {
					// 在预售时间内
					Date endTime = this.getMemberLevelForecastTime(forcastVO, memberLevelEnum);
					if (DateUtil.isInTime(forcastVO.getStartTime(), endTime, null)) {
						return Boolean.TRUE;
					}
				}
			}
		}
		return Boolean.FALSE;
	}

	/**
	 * 验证订单商品预告信息
	 *
	 * @param packs
	 */
	public void checkOrderPacksForecast(List<CartProductPack> packs, Integer memberLevel) throws ChannelException {
		if (CollectionUtils.isNotEmpty(packs)) {

			for (CartProductPack pack : packs) {
				String productCode = pack.getProduct().getCode();

				List<ForcastVO> forcastVOs = getPrevueProduct(productCode);
				if (CartPackSourceEnum.RAW.equals(pack.getSource()) && CollectionUtils.isNotEmpty(forcastVOs)) {
					for (ForcastVO forcastVO : forcastVOs) {

						Date date = this.getMemberLevelForecastTime(forcastVO,
								MemberLevelEnum.getEnumByCode(memberLevel));
						// 在预售时间内
						if (DateUtil.isInTime(forcastVO.getStartTime(), date, null)) {

							SimpleDateFormat monthFormat = new SimpleDateFormat("MM");
							SimpleDateFormat dayFormat = new SimpleDateFormat("dd");
							SimpleDateFormat hFormat = new SimpleDateFormat("HH:mm:ss");

							String time = monthFormat.format(date) + "月" + dayFormat.format(date) + "日" + " "
									+ hFormat.format(date);
							String[] message = FORESHOW_MESSAGE.split("XXX");

							// String errmesg = pack.getSpv().getProductName() +
							// "商品还未开售，请返回购物车重新选择";
							String errmesg = message[0] + time + message[1];
							logger.error(errmesg);
							throw new ChannelException(400, errmesg);
						}
					}
				}
			}
		}
	}

	public void setPrevue(ProductItemVO vo, String memberCode) {

		List<ForcastVO> forcastVOs = getPrevueProduct(vo.getCode());
		if (CollectionUtils.isNotEmpty(forcastVOs)) {
			for (ForcastVO forcastVO : forcastVOs) {
				if (null != forcastVO && null != forcastVO.getEndTime() && forcastVO.getEndTime().after(new Date())) {
					MemberVO member = memberQueryService.getByCode(memberCode);

					vo.setForetell(true);
					PrevueVO prevue = new PrevueVO();
					prevue.setId(forcastVO.getForecastId());

					Date date = forcastVO.getEndTime();
					// format的格式可以任意
					DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					Date endDate = date;
					if (member != null) {
						endDate = getMemberLevelForecastTime(forcastVO,
								MemberLevelEnum.getEnumByCode(member.getMemberLevel()));
					}

					// 预告开始了
					if (endDate.getTime() < new Date().getTime()) {
						vo.setForetell(false);
						return;
					}

					prevue.setSince(Timestamp.valueOf(sdf.format(date)));

					prevue.setDesc(getMemberLevelAdvanceText(forcastVO));

					prevue.setRemind(false);

					// 查询该用户预告提醒
					if (member != null && member.getId() != MemberConstant.DEFAULT_MEMBER_ID) {
						List<Long> members = new ArrayList<Long>();
						members.add(member.getId());
						SubscribeQueryResp subResp = forcastService.querySubscribe(members);
						Boolean state = false;
						HashMap<Long, HashMap<String, HashMap<String, String>>> subMap = subResp.getData();
						if (null != subMap && !subMap.isEmpty() && subMap.containsKey(member.getId())) {
							HashMap<String, HashMap<String, String>> memberMap = subMap.get(member.getId());

							if (!memberMap.isEmpty() && memberMap.containsKey(prevue.getId())) {
								// Iterator iter =
								// memberMap.entrySet().iterator();
								// while (iter.hasNext()) {
								// Map.Entry entry = (Map.Entry)
								// iter.next();
								// Object key = entry.getKey();
								HashMap<String, String> products = memberMap.get(prevue.getId());
								if (!products.isEmpty() && products.containsKey(vo.getCode())) {
									state = state || true;
									// }
								}

							}
						}
						prevue.setRemind(state);
					}
					vo.setPrevue(prevue);

					break;
				}
			}
		}
	}

	/**
	 * 获取指定会员等级预告时间
	 *
	 * @param forcastVO
	 * @param memberLevel
	 * @return
	 */
	private Date getMemberLevelForecastTime(ForcastVO forcastVO, MemberLevelEnum memberLevel) {
		if (null == forcastVO) {
			return null;
		}
		if (null != memberLevel) {
			if (CollectionUtils.isNotEmpty(forcastVO.getLevels())) {
				for (LevelInfo levelInfo : forcastVO.getLevels()) {
					if (memberLevel.getCode() == levelInfo.getMemberLevel()) {
						return levelInfo.getEndTime();
					}
				}
			}
		}
		return forcastVO.getEndTime();
	}

	/**
	 * 会员等级提前展示文案
	 *
	 * @param forcastVO
	 * @return
	 */
	private String getMemberLevelAdvanceText(ForcastVO forcastVO) {
		if (null == forcastVO || null == forcastVO.getEndTime() || CollectionUtils.isEmpty(forcastVO.getLevels())) {
			return "";
		}
		Date levelEndDate = forcastVO.getLevels().get(0).getEndTime();
		if (null == levelEndDate) {
			return "";
		}
		StringBuffer advanceText = new StringBuffer();
		advanceText.append("<br/><span style='color:#AB916B;'>");
		for (LevelInfo levelInfo : forcastVO.getLevels()) {
			MemberLevelEnum memberLevelEnum = MemberLevelEnum.getEnumByCode(levelInfo.getMemberLevel());
			if (null != memberLevelEnum) {
				advanceText.append(memberLevelEnum.getName().replace("会员", ""));
			}
		}

		// 获取会员等级提前时间
		Date defaultDate = forcastVO.getEndTime();
		long def_time = defaultDate.getTime();
		long mem_time = levelEndDate.getTime();
		long advance_time = def_time - mem_time;
		long minute = advance_time / 1000 / 60;
		long advance_hour = minute / 60;
		long advance_minute = minute % 60;

		advanceText.append("提前");
		if (advance_hour > 0) {
			advanceText.append(advance_hour).append("小时");
		}
		if (advance_minute > 0) {
			advanceText.append(advance_minute).append("分钟");
		}
		advanceText.append("开抢，抢完即止");
		advanceText.append("</span>");

		return advanceText.toString();
	}

}
