package com.thebeastshop.pegasus.channelservice.adapter.price;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.enums.MemberTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFixedPriceVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.coupon.vo.CpFullDiscountVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigDetailVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigVO;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartCommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCustomizeAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvPriceAdapter;
import com.thebeastshop.pegasus.channelservice.util.CampaignUtils;
import com.thebeastshop.pegasus.channelservice.vo.SpvPriceVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.IService.IInterestGoodsService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.price.enums.*;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.*;
import com.thebeastshop.privilege.service.InterestFreeService;
import com.thebeastshop.privilege.vo.InterestFreeCashVO;
import com.thebeastshop.privilege.vo.InterestFreeVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.vo.interest.InterestGoodsVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.Label.CampaignVO;
import com.thebeastshop.support.Label.LabelMode;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.cart.CartBenefitVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO.PackCampaignVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO.PackCampaignVO.InfoVO;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.product.SpvVO;
import com.thebeastshop.support.vo.product.SpvVO.BrandVO;
import com.thebeastshop.support.vo.product.SpvVO.Quota;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 价格计算适配器
 * 
 * @author Wang Yawei
 *
 */
@Component("priceAdapter")
public class PriceAdapter {
	@Autowired
	private IInterestGoodsService iInterestGoodsService;

	@Autowired
	private SPresaleService sPresaleService;
	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;
	@Autowired
	private CartCommonAdapter cartCommonAdapter;
	@Autowired
	private PrsPriceService prsPriceService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private SStockService sStockService;
	@Autowired
	private SpvPriceAdapter spvPriceAdapter;

	@Autowired
	private InterestAdapter interestAdapter;
	@Autowired
	private ProductAdapter productAdapter;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private InterestFreeService interestFreeService;

	@Autowired
	private CampaignLimitService campaignLimitService;
	
	@Autowired
	private IposPriceAdapter iposPriceAdapter;
	@Resource(name = "appMemberAdapter")
	private MemberAdapter memberAdapter;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 价格计算服务调用参数组装
	 * 
	 * 
	 * @param interestGoodsMap
	 * @param arg0
	 * @param packs
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @param cpCoupon
	 * @param customPostage
	 * @param interestId
	 */
	public void assemblePriceCartpacks(Map<Long, InterestGoods> interestGoodsMap, PrsCalPackDto arg0,
			List<? extends CartProductPack> packs, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay,
			CpCouponVO cpCoupon, BigDecimal customPostage, BigDecimal remotePostage, List<Integer> interestId,
			Boolean birthday, List<GiftCardVO> giftCards, Map<String, ExchgSpuConfigVO> exchgSpuConfigMap) {

		if (null != customPostage) {
			logger.info("ipos运费={}", customPostage);
			arg0.setCustomPostage(customPostage);
		}
		if (null != remotePostage && remotePostage.compareTo(BigDecimal.ZERO) > 0) {
			logger.info("偏远地区运费={}", remotePostage);
			arg0.setRemoteDeliveryFee(remotePostage);
			arg0.setRemoteAreaDelivery(true);
		}
		List<String> productCodes = new ArrayList<String>();
		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());
		if (null != giftCards && CollectionUtils.isNotEmpty(giftCards)) {
			List<PrsGiftCardVO> giftCardList = new ArrayList<PrsGiftCardVO>();
			for (GiftCardVO card : giftCards) {
				PrsGiftCardVO giftCart = new PrsGiftCardVO();
				giftCart.setAmount(card.getAmount());
				giftCart.setCardNo(card.getCardNo());
				String date = "2999-12-31 00:00:00";
				if (null != card.getExpireDate() && !card.getExpireDate().equals("")) {
					date = card.getExpireDate();
				}
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				try {
					giftCart.setExpireDate(sdf.parse(date));
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				giftCardList.add(giftCart);
			}
			arg0.setGiftCardList(giftCardList);
			arg0.setUseGiftCard(true);
		}
		if (null != cpCoupon) {

			PrsCouponVO coupon = new PrsCouponVO();

			PrsCouponSampleVO sample = new PrsCouponSampleVO();
			sample.setAccessWayIds(cpCoupon.getCouponSample().getAccessWayIds());
			sample.setCategoryIds(cpCoupon.getCouponSample().getCategoryIds());
			sample.setCouponTypeId(cpCoupon.getCouponSample().getCouponTypeId());
			sample.setCrossBorder(cpCoupon.getCouponSample().getCrossBorder());

			if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
				CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getCutPrice());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加
				if (fullCutCoupon.getIsTopLimit() == null) {
					sample.setCumulative(0);
				} else if (fullCutCoupon.getIsTopLimit() == 0) {
					sample.setCumulative(1);
				} else {
					sample.setCumulative(0);
				}

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(fullCutCoupon.getFullPrice());
				couponSectionVO.setFactor(fullCutCoupon.getCutPrice());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(fullCutCoupon.getFullPrice());
			} else if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.DISCOUNT_LINE.getId())) {
				CpFullDiscountVO fullCutCoupon = (CpFullDiscountVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getDiscount());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加

				sample.setCumulative(0);

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(fullCutCoupon.getFullPrice());
				couponSectionVO.setFactor(fullCutCoupon.getDiscount());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(fullCutCoupon.getFullPrice());
			} else if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.FIXEDPRICE_LINE.getId())) {
				CpFixedPriceVO fullCutCoupon = (CpFixedPriceVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getFixedPrice());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加

				sample.setCumulative(0);

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(BigDecimal.ZERO);
				couponSectionVO.setFactor(fullCutCoupon.getFixedPrice());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(BigDecimal.ZERO);
			}

			sample.setId(cpCoupon.getCouponSample().getId());
			sample.setName(cpCoupon.getCouponSample().getName());
			sample.setOfflineStoreIds(cpCoupon.getCouponSample().getOfflineStoreIds());
			sample.setProductIds(cpCoupon.getCouponSample().getProductIds());
			sample.setProductScopeId(cpCoupon.getCouponSample().getProductScopeId());
			sample.setStartTime(cpCoupon.getCouponSample().getStartTime());
			sample.setStateId(cpCoupon.getCouponSample().getStateId());
			sample.setTitle(cpCoupon.getCouponSample().getTitle());
			coupon.setCouponSample(sample);
			coupon.setCouponSampleId(cpCoupon.getCouponSampleId());
			coupon.setExpireTime(cpCoupon.getExpireTime());
			coupon.setId(cpCoupon.getId());
			coupon.setOwnerId(cpCoupon.getOwnerId());
			coupon.setStartTime(cpCoupon.getStartTime());
			coupon.setUsed(cpCoupon.getUsed());
			coupon.setValid(cpCoupon.getValid());
			arg0.setCoupon(coupon);
		}

		if (null != member) {
			PrsMemberVO membervo = new PrsMemberVO();
			membervo.setBirthday(member.getBirthday());
			membervo.setCode(member.getCode());
			membervo.setId(member.getId());
			membervo.setMemberLevel(member.getMemberLevel());
			membervo.setNickName(member.getNickName());
			if (Integer.valueOf(1).equals(opChannel.getChannelType())) {
				membervo.setFishMan(memberAdapter.isNewMemberIposCart(member.getId()));
			} else {
				membervo.setFishMan(memberAdapter.isNewMember(member.getId()));
			}
			arg0.setMember(membervo);
		}
		List<PsProductVO> products = new ArrayList<PsProductVO>();
		for (ProductPack pack : packs) {
			products.add(pack.getProduct());
		}
		Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);

		List<PrsProductPackVO> packList = new ArrayList<PrsProductPackVO>();
		for (CartProductPack pack : packs) {
			PrsProductPackVO packvo = new PrsProductPackVO();

			PsSpvVO psSpv = pack.getSpv();
			PsProductVO psProduct = pack.getProduct();
			List<PsSkuVO> psSkus = skuMap.get(psProduct.getId());
			List<PrsCampaignVO> advanceCampaignList = new ArrayList<PrsCampaignVO>();

			List<PsCampaignVO> psAdvanceCampaignList = psSpv.getAdvanceCampaignList();
			if (CollectionUtils.isNotEmpty(psAdvanceCampaignList)) {
				for (PsCampaignVO psAdvanceCampaign : psAdvanceCampaignList) {
					PrsCampaignVO advanceCampaign = new PrsCampaignVO();
					advanceCampaign.setAccessWayIds(psAdvanceCampaign.getAccessWayIds());
					advanceCampaign.setAdvance(psAdvanceCampaign.getAdvance());
					advanceCampaign.setApprovalState(psAdvanceCampaign.getApprovalState());

					List<PsCampaignSectionVO> psCampaignSectionList = psAdvanceCampaign.getCampaignSectionList();
					List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

					if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
						for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
							PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
							campaignSection.setCampaignId(psCampaignSection.getCampaignId());
							campaignSection.setFactor(psCampaignSection.getFactor());
							campaignSection.setFactorType(psCampaignSection.getFactorType());
							campaignSection.setId(psCampaignSection.getId());
							campaignSection.setLine(psCampaignSection.getLine());
							List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
									.getCampaignSectionProducts();
							List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
							if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

								for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
									PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
									campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
									campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
									campaignSectionProduct
											.setCampaignSectionId(psCampaignSectionProduct.getCampaignSectionId());
									campaignSectionProduct.setId(psCampaignSectionProduct.getId());
									campaignSectionProduct.setLimitCount(psCampaignSectionProduct.getLimitCount());
									campaignSectionProduct.setCount(psCampaignSectionProduct.getPriceCount());
									campaignSectionProduct.setPrice(psCampaignSectionProduct.getPricePrice());
									campaignSectionProduct.setProductId(psCampaignSectionProduct.getProductId());
									campaignSectionProductList.add(campaignSectionProduct);
								}
							}
							campaignSection.setSectionProductVOList(campaignSectionProductList);
							campaignSection.setType(psCampaignSection.getConditionType());
							campaignSection.setSort(psCampaignSection.getRanking().floatValue());
							campaignSectionList.add(campaignSection);
						}
					}

					advanceCampaign.setCampaignSectionList(campaignSectionList);
					advanceCampaign.setCode(psAdvanceCampaign.getCode());
					advanceCampaign.setCrossBorderFlag(psAdvanceCampaign.getCrossBorderFlag());
					advanceCampaign.setCumulative(psAdvanceCampaign.getCumulative());
					advanceCampaign.setDiscountTypeId(psAdvanceCampaign.getDiscountTypeId());
					advanceCampaign.setExpireTime(psAdvanceCampaign.getExpireTime());
					advanceCampaign.setId(psAdvanceCampaign.getId());
					advanceCampaign.setLadderRule(psAdvanceCampaign.getLadderRule());
					advanceCampaign.setLevel(psAdvanceCampaign.getLevel());
					advanceCampaign.setMemberLevels(psAdvanceCampaign.getMemberLevels());
					advanceCampaign.setName(psAdvanceCampaign.getName());
					advanceCampaign.setProductScopeId(psAdvanceCampaign.getProductScopeId());
					advanceCampaign.setOptionFlag(psAdvanceCampaign.getOptionFlag());
					advanceCampaign.setStartTime(psAdvanceCampaign.getStartTime());
					advanceCampaign.setState(psAdvanceCampaign.getState());
					advanceCampaign.setTitle(psAdvanceCampaign.getTitle());
                    if (MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(psAdvanceCampaign.getMemberType())) {
                        advanceCampaign.setMemberType(PrsMemberTypeEnum.FISH_MAN);
                    } else {
                        advanceCampaign.setMemberType(PrsMemberTypeEnum.ALL);
                    }
					advanceCampaignList.add(advanceCampaign);
				}
			}
			packvo.setAdvanceCampaignList(advanceCampaignList);
			if (psProduct.getAllowVipDiscount() != null && psProduct.getAllowVipDiscount() == 1) {
				packvo.setAllowVipDiscount(true);
			} else {
				packvo.setAllowVipDiscount(false);
			}
			// 商品活动和spv活动都要取
			List<PrsCampaignVO> campaignList = new ArrayList<PrsCampaignVO>();
			List<PsCampaignVO> spvCampaignList = psSpv.getCampaignList();
			List<PsCampaignVO> prodCampaignList = psProduct.getCampaignList();
			List<PsCampaignVO> psCampaignList = new ArrayList<PsCampaignVO>();

			if (CollectionUtils.isNotEmpty(spvCampaignList)) {
				psCampaignList.addAll(spvCampaignList);
			}
			if (CollectionUtils.isNotEmpty(prodCampaignList)) {
				psCampaignList.addAll(prodCampaignList);
			}

			if (CollectionUtils.isNotEmpty(psCampaignList)) {
				for (PsCampaignVO psCampaign : psCampaignList) {
					PrsCampaignVO campaign = new PrsCampaignVO();
					campaign.setAccessWayIds(psCampaign.getAccessWayIds());
					campaign.setAdvance(psCampaign.getAdvance());
					campaign.setApprovalState(psCampaign.getApprovalState());
					List<PsCampaignSectionVO> psCampaignSectionList = psCampaign.getCampaignSectionList();
					List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

					if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
						for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
							PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
							campaignSection.setCampaignId(psCampaignSection.getCampaignId());
							campaignSection.setFactor(psCampaignSection.getFactor());
							campaignSection.setFactorType(psCampaignSection.getFactorType());
							campaignSection.setId(psCampaignSection.getId());
							campaignSection.setLine(psCampaignSection.getLine());
							campaignSection.setSort(psCampaignSection.getRanking().floatValue());
							List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
									.getCampaignSectionProducts();
							List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
							if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

								for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
									PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
									campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
									campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
									campaignSectionProduct
											.setCampaignSectionId(psCampaignSectionProduct.getCampaignSectionId());
									campaignSectionProduct.setId(psCampaignSectionProduct.getId());
									campaignSectionProduct.setLimitCount(psCampaignSectionProduct.getLimitCount());
									campaignSectionProduct.setCount(psCampaignSectionProduct.getPriceCount());
									campaignSectionProduct.setPrice(psCampaignSectionProduct.getPricePrice());
									campaignSectionProduct.setProductId(psCampaignSectionProduct.getProductId());
									campaignSectionProductList.add(campaignSectionProduct);
								}
							}
							campaignSection.setSectionProductVOList(campaignSectionProductList);
							campaignSection.setType(psCampaignSection.getConditionType());

							campaignSectionList.add(campaignSection);
						}
					}
					campaign.setCampaignSectionList(campaignSectionList);
					campaign.setCode(psCampaign.getCode());
					campaign.setCrossBorderFlag(psCampaign.getCrossBorderFlag());
					campaign.setCumulative(psCampaign.getCumulative());
					campaign.setDiscountTypeId(psCampaign.getDiscountTypeId());
					campaign.setExpireTime(psCampaign.getExpireTime());
					campaign.setId(psCampaign.getId());
					campaign.setLadderRule(psCampaign.getLadderRule());
					campaign.setLevel(psCampaign.getLevel());
					campaign.setMemberLevels(psCampaign.getMemberLevels());
					campaign.setName(psCampaign.getName());
					campaign.setOptionFlag(psCampaign.getOptionFlag());
					campaign.setProductScopeId(psCampaign.getProductScopeId());
					campaign.setStartTime(psCampaign.getStartTime());
					campaign.setState(psCampaign.getState());
					campaign.setTitle(psCampaign.getTitle());
                    if (MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(psCampaign.getMemberType())) {
                        campaign.setMemberType(PrsMemberTypeEnum.FISH_MAN);
                    } else {
                        campaign.setMemberType(PrsMemberTypeEnum.ALL);
                    }
					campaignList.add(campaign);
				}
			}

			packvo.setCampaignList(campaignList);
			packvo.setCategoryId(psProduct.getCategoryId());
			packvo.setCount(pack.getCount());
			packvo.setCrossBorderFlag(psProduct.getCrossBorderFlag());
			if (null != psProduct.getIsDiscount() && psProduct.getIsDiscount() == 1) {
				packvo.setHasSpecialDiscount(true);
			} else {
				packvo.setHasSpecialDiscount(false);

			}
			packvo.setId(pack.getId());

			packvo.setIsCustomize(false);
			if (null != psSkus && psSkus.size() > 0) {
				for (PsSkuVO psSku : psSkus) {
					if (null != psSku.getCanCustomize() && psSku.getCanCustomize() == 1) {
						packvo.setIsCustomize(true);

						packvo.setCustomizePrice(BigDecimal.ZERO);
						BigDecimal customizePrice = spvCustomizeAdapter
								.getCustomizePriceBySkuCode(pack.getSpv().getSkuCode());
						if (!NumberUtil.isNullOrZero(customizePrice)) {
							packvo.setCustomizePrice(customizePrice);
						}

						break;
					}
				}
			}
			packvo.setAllowVipDiscount(false);
			if (null != psProduct.getAllowVipDiscount() && psProduct.getAllowVipDiscount() == 1) {
				packvo.setAllowVipDiscount(true);
			}
			packvo.setUseBirthdayDiscount(false);
			if (null != member) {
				if (birthday) {
					if (member.isInBdayDiscountTime()) {
						if (null != psProduct.getAllowBdDiscount() && psProduct.getAllowBdDiscount() == 1) {
							packvo.setUseBirthdayDiscount(true);

						}
					}
				}
			}
			packvo.setHasSpecialDiscount(
					null != psProduct.getIsDiscount() && psProduct.getIsDiscount() == 1 ? true : false);
			packvo.setMinAmount(psSpv.getMinAmount());
			packvo.setProductCode(psProduct.getCode());
			packvo.setProductId(Long.parseLong(psProduct.getId()));
			packvo.setProductName(psProduct.getNameCn());

			// if(psProduct.getCombined()){
			// packvo.setSalesPrice(psSpv.getOriginalPrice());
			// }else{
			packvo.setSalesPrice(psSpv.getSalesPrice());
			// }

			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {

				if (psProduct.getCombined()) {
					packvo.setSalesPrice(psSpv.getOriginalPrice());
				} else {
					packvo.setSalesPrice(psSpv.getSalesPrice());
				}

			} else {
				packvo.setSalesPrice(psSpv.getSalesPrice());
			}

			packvo.setOriginalPrice(psSpv.getOriginalPrice());
			packvo.setCombination(psSpv.getCombined());
			List<PrsSkuVO> skus = new ArrayList<PrsSkuVO>();

			if (psSpv.getCombined()) {

				Map<String, Integer> subSkuCountMap = new HashMap<String, Integer>();
				List<String> skuCodes = new ArrayList<>();
				if (CollectionUtils.isNotEmpty(psSpv.getSkuCombinationList())) {
					for (PsSkuCombinationVO psSku : psSpv.getSkuCombinationList()) {
						skuCodes.add(psSku.getSubSkuCode());
						subSkuCountMap.put(psSku.getSubSkuCode(), psSku.getQuantity());
					}
				}
				for (String skuCode : skuCodes) {
					for (PsSkuVO psSku : psSkus) {
						if (psSku.getSkuCode().equals(skuCode)) {
							PrsSkuVO sku = new PrsSkuVO(psSpv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
									new BigDecimal(psSku.getSalesPrice()), subSkuCountMap.get(skuCode));
							skus.add(sku);
						}
					}
				}
			} else {
				BigDecimal salesPrice = BigDecimal.ZERO;
				for (PsSkuVO psSku : psSkus) {
					if (psSpv.getSkuCode().equals(psSku.getSkuCode())) {
						salesPrice = psSpv.getSalesPrice();
						PrsSkuVO sku = new PrsSkuVO(psSpv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
								salesPrice, 1);
						skus.add(sku);
					}
				}
			}

			packvo.setSkuList(skus);

			packvo.setSpvId(psSpv.getSpvId());
			if (pack.getSource().equals(CartPackSourceEnum.BENEFIT)) {
				logger.info("权益商品组装，spvid={},packId={},interestId={}", psSpv.getSpvId(), pack.getId(),
						pack.getSourceBindVal());
				InterestGoods interestGoods = interestAdapter.getInterestInfo(pack.getSourceBindVal());
				interestGoodsMap.put(pack.getSpvId(), interestGoods);
				PrsInterestGoodsVO interest = new PrsInterestGoodsVO(interestGoods.getId(), false);
				if (null != interestGoods.getIsFreePost() && interestGoods.getIsFreePost() == 1) {
					interest.setFreePostage(true);
				}
				interest.setInterestGoodsId(Integer.parseInt(pack.getSourceBindVal()));
				interest.setCashEndTime(interestGoods.getCashEndTime());
				interest.setCashStartTime(interestGoods.getCashStartTime());
				interest.setCashThreshold(interestGoods.getCashThreshold());

				InterestGoodsVO depositGoods = iInterestGoodsService
						.selectInterestGoodsSku(Integer.parseInt(pack.getSourceBindVal()));
				if (null != depositGoods.getInterestGoodsSkuList().get(0).getDeductionPrice() && depositGoods
						.getInterestGoodsSkuList().get(0).getDeductionPrice().compareTo(BigDecimal.ZERO) != 0) {
					interest.setDeductionPrice(depositGoods.getInterestGoodsSkuList().get(0).getDeductionPrice());
					packvo.setHasDeposit(true);
				}

				interest.setMemberId(member.getId().intValue());
				interest.setSkuCode(pack.getSpv().getSkuCode());
				interest.setSkuNameCn(pack.getSpv().getSkuVO().getSkuNameCN());
				packvo.setInterestGoods(interest);
			}
			packvo.setSource(PrsCartSourceEnum.getEnumByCode(pack.getSource().getCode()));
			productCodes.add(pack.getProduct().getCode());

			if (null != exchgSpuConfigMap) {
				ExchgSpuConfigVO exchangeVO = exchgSpuConfigMap.get(pack.getProduct().getCode());
				List<ExchgSpuConfigDetailVO> exchangelist = exchangeVO.getSpuConfigDetailList();
				if (CollectionUtils.isNotEmpty(exchangelist)) {

					for (ExchgSpuConfigDetailVO exchange : exchangelist) {
						if (exchange.getSkuCode().equalsIgnoreCase(psSpv.getSkuCode())) {
							logger.info("exchange spvid={},psSpv spvid={}", exchange.getSpvId(), psSpv.getSpvId());
							packvo.setPoints(exchange.getExchangeAmount());
							if(null != exchange.getExchangePrice()){
								packvo.setPointDeductPrice(exchange.getExchangePrice());
							}
							packvo.setPointExchange(Boolean.TRUE);
							arg0.setPostageFree(true);
							break;
						}
					}
				}

			} else {
				packvo.setPoints(0);
			}
			
			List<PrsPostageDeliverVo> postageDeliverVos = iposPriceAdapter.getPrsPackDelivery(pack);
			
			packvo.setPostageDeliverVos(postageDeliverVos);
			packList.add(packvo);
		}
		arg0.setPackList(packList);
		arg0.setCampaignLimitList(getPrsCampLimit4Prods(products,member));
		if (null != member) {
			// if (interestGoodsMap.size() < 1) {
			
			logger.info("interestFreeService productCodes:"+productCodes.toString());
			
			if (CollectionUtils.isNotEmpty(productCodes)) {
				InterestFreeCashVO interestFreeCashVO = new InterestFreeCashVO();
				interestFreeCashVO.setMemberId(member.getId().intValue());
				interestFreeCashVO.setProdCodes(productCodes);
				interestFreeCashVO.setAccessWay(accessWay);
				interestFreeCashVO.setStoreChannel(opChannel.getCode());
				
				
				logger.info("interestFreeService getOptimallyUsableInterestFree:"+interestFreeCashVO.toString());
				ServiceResp<InterestFreeVO> resp = interestFreeService.getOptimallyUsableInterestFree(interestFreeCashVO);
				if (resp.getBean() != null) {
					InterestFreeVO interestFreeVO = resp.getBean();
					logger.info("interestFreeService interestFreeVO.getProvideId():"+interestFreeVO.getProvideId());
					
					
					arg0.setInterestFreeId(interestFreeVO.getProvideId());
					interestId.add(interestFreeVO.getProvideId());
				}
			}
		}
	}


    /**
     * 商品列表获取价格折扣活动限量
     * 已登录用户：访问活动服务查询限量值
     * 未登录用户：取活动配置限量值
     * @param prods
     * @return
     */
    private List<PrsCampaignLimitVO> getPrsCampLimit4Prods(List<PsProductVO> prods,MemberVO member) {
        List<PrsCampaignLimitVO> targets = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(prods)) {
            for (PsProductVO prod : prods) {
                List<PrsCampaignLimitVO> prodCampLists = getPrsCampLimit4Prod(prod,member);
                if(CollectionUtils.isNotEmpty(prodCampLists)){
                    targets.addAll(prodCampLists);
                }
            }
        }
        return targets;
    }

    /**
     * 获取单商品价格折扣活动限量信息
     * 已登录用户：访问活动服务查询限量值
     * 未登录用户：取活动配置限量值
     * @param prod
     * @param member
     * @return
     */
    private List<PrsCampaignLimitVO> getPrsCampLimit4Prod(PsProductVO prod, MemberVO member) {
        List<PrsCampaignLimitVO> targets = Lists.newArrayList();
        if (null != prod &&CollectionUtils.isNotEmpty(prod.getSpvList())) {
            for (PsSpvVO psSpvVO : prod.getSpvList()) {
                List<PsCampaignVO> camps = CampaignUtils.getCampaignsByDiscountType(psSpvVO.getCampaignList(),
                        DiscountTypeEnum.PRICE_DISCOUNT);
                if (CollectionUtils.isNotEmpty(camps)) {
                    for (PsCampaignVO camp : camps) {
                        Integer limitAmount = camp.getLimitAmount();
                        if(null != member && !MemberConstant.DEFAULT_MEMBER_ID.equals(member.getId())){
                            CampaignStreamVO campaignStream = new CampaignStreamVO();
                            campaignStream.setCampaignCode(camp.getCode());
                            campaignStream.setSkuCode(psSpvVO.getSkuCode());
                            campaignStream.setProductCode(psSpvVO.getProductCode());
                            campaignStream.setMemberCode(member.getCode());
                            ServiceResp<Integer> resp  = campaignLimitService.getPriceDiscountPerUserLeftAmount(campaignStream);
                            if(resp.isSuccess()){
                                limitAmount = resp.getBean();
                            }
                        }
                        PrsCampaignLimitVO campLimit = new PrsCampaignLimitVO();
                        campLimit.setSpvId(psSpvVO.getSpvId());
                        campLimit.setAvailCnt(limitAmount);
                        campLimit.setCampaignId(camp.getId());
                        targets.add(campLimit);
                    }
                }
            }
        }
        return targets;
    }


    /**
	 * 价格计算服务调用参数组装
	 * 
	 * 
	 * @param interestGoodsMap
	 * @param arg0
	 * @param packs
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @param cpCoupon
	 * @param customPostage
	 * @param interestId
	 */
	public void assemblePricepacks(Map<Long, InterestGoods> interestGoodsMap, PrsCalPackDto arg0,
			List<? extends ProductPack> packs, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay,
			CpCouponVO cpCoupon, BigDecimal customPostage, BigDecimal remotePostage, List<Integer> interestId,
			Boolean birthday, List<GiftCardVO> giftCards, Map<String, ExchgSpuConfigVO> exchgSpuConfigMap) {

		if (null != customPostage) {
			logger.info("ipos运费={}", customPostage);
			arg0.setCustomPostage(customPostage);
		}
		if (null != remotePostage && remotePostage.compareTo(BigDecimal.ZERO) > 0) {
			logger.info("偏远地区运费={}", remotePostage);
			arg0.setRemoteDeliveryFee(remotePostage);
			arg0.setRemoteAreaDelivery(true);
		}
		List<String> productCodes = new ArrayList<String>();
		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());
		if (null != giftCards && CollectionUtils.isNotEmpty(giftCards)) {
			List<PrsGiftCardVO> giftCardList = new ArrayList<PrsGiftCardVO>();
			for (GiftCardVO card : giftCards) {
				PrsGiftCardVO giftCart = new PrsGiftCardVO();
				giftCart.setAmount(card.getAmount());
				giftCart.setCardNo(card.getCardNo());
				String date = "2999-12-31 00:00:00";
				if (null != card.getExpireDate() && !card.getExpireDate().equals("")) {
					date = card.getExpireDate();
				}
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				try {
					giftCart.setExpireDate(sdf.parse(date));
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				giftCardList.add(giftCart);
			}
			arg0.setGiftCardList(giftCardList);
			arg0.setUseGiftCard(true);
		}
		if (null != cpCoupon) {

			PrsCouponVO coupon = new PrsCouponVO();

			PrsCouponSampleVO sample = new PrsCouponSampleVO();
			sample.setAccessWayIds(cpCoupon.getCouponSample().getAccessWayIds());
			sample.setCategoryIds(cpCoupon.getCouponSample().getCategoryIds());
			sample.setCouponTypeId(cpCoupon.getCouponSample().getCouponTypeId());
			sample.setCrossBorder(cpCoupon.getCouponSample().getCrossBorder());

			if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
				CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getCutPrice());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加
				if (fullCutCoupon.getIsTopLimit() == null) {
					sample.setCumulative(0);
				} else if (fullCutCoupon.getIsTopLimit() == 0) {
					sample.setCumulative(1);
				} else {
					sample.setCumulative(0);
				}

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(fullCutCoupon.getFullPrice());
				couponSectionVO.setFactor(fullCutCoupon.getCutPrice());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(fullCutCoupon.getFullPrice());
			} else if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.DISCOUNT_LINE.getId())) {
				CpFullDiscountVO fullCutCoupon = (CpFullDiscountVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getDiscount());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加

				sample.setCumulative(0);

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(fullCutCoupon.getFullPrice());
				couponSectionVO.setFactor(fullCutCoupon.getDiscount());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(fullCutCoupon.getFullPrice());
			} else if (cpCoupon.getCouponSample().getCouponTypeId().equals(CpCouponTypeEnum.FIXEDPRICE_LINE.getId())) {
				CpFixedPriceVO fullCutCoupon = (CpFixedPriceVO) cpCoupon.getCouponSample().getCouponContent();
				sample.setCutPrice(fullCutCoupon.getFixedPrice());
				sample.setExcludeProductIds(cpCoupon.getCouponSample().getExcludeProductIds());
				sample.setExpireTime(cpCoupon.getCouponSample().getExpireTime());

				// 是否可优惠累加

				sample.setCumulative(0);

				// 优惠内容
				PrsCouponSectionVO couponSectionVO = new PrsCouponSectionVO();
				couponSectionVO.setLine(BigDecimal.ZERO);
				couponSectionVO.setFactor(fullCutCoupon.getFixedPrice());
				sample.setSectionVOS(Lists.newArrayList(couponSectionVO));

				sample.setFullPrice(BigDecimal.ZERO);
			}

			sample.setId(cpCoupon.getCouponSample().getId());
			sample.setName(cpCoupon.getCouponSample().getName());
			sample.setOfflineStoreIds(cpCoupon.getCouponSample().getOfflineStoreIds());
			sample.setProductIds(cpCoupon.getCouponSample().getProductIds());
			sample.setProductScopeId(cpCoupon.getCouponSample().getProductScopeId());
			sample.setStartTime(cpCoupon.getCouponSample().getStartTime());
			sample.setStateId(cpCoupon.getCouponSample().getStateId());
			sample.setTitle(cpCoupon.getCouponSample().getTitle());
			coupon.setCouponSample(sample);
			coupon.setCouponSampleId(cpCoupon.getCouponSampleId());
			coupon.setExpireTime(cpCoupon.getExpireTime());
			coupon.setId(cpCoupon.getId());
			coupon.setOwnerId(cpCoupon.getOwnerId());
			coupon.setStartTime(cpCoupon.getStartTime());
			coupon.setUsed(cpCoupon.getUsed());
			coupon.setValid(cpCoupon.getValid());
			arg0.setCoupon(coupon);
		}

		if (null != member) {
			PrsMemberVO membervo = new PrsMemberVO();
			membervo.setBirthday(member.getBirthday());
			membervo.setCode(member.getCode());
			membervo.setId(member.getId());
			membervo.setMemberLevel(member.getMemberLevel());
			membervo.setNickName(member.getNickName());
			arg0.setMember(membervo);
		}
		List<PsProductVO> products = new ArrayList<PsProductVO>();
		for (ProductPack pack : packs) {
			products.add(pack.getProduct());
		}
		Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);

		List<PrsProductPackVO> packList = new ArrayList<PrsProductPackVO>();
		for (ProductPack pack : packs) {
			PrsProductPackVO packvo = new PrsProductPackVO();

			PsSpvVO psSpv = pack.getSpv();
			PsProductVO psProduct = pack.getProduct();
			List<PsSkuVO> psSkus = skuMap.get(psProduct.getId());
			List<PrsCampaignVO> advanceCampaignList = new ArrayList<PrsCampaignVO>();

			List<PsCampaignVO> psAdvanceCampaignList = psSpv.getAdvanceCampaignList();
			if (CollectionUtils.isNotEmpty(psAdvanceCampaignList)) {
				for (PsCampaignVO psAdvanceCampaign : psAdvanceCampaignList) {
					PrsCampaignVO advanceCampaign = new PrsCampaignVO();
					advanceCampaign.setAccessWayIds(psAdvanceCampaign.getAccessWayIds());
					advanceCampaign.setAdvance(psAdvanceCampaign.getAdvance());
					advanceCampaign.setApprovalState(psAdvanceCampaign.getApprovalState());

					List<PsCampaignSectionVO> psCampaignSectionList = psAdvanceCampaign.getCampaignSectionList();
					List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

					if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
						for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
							PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
							campaignSection.setCampaignId(psCampaignSection.getCampaignId());
							campaignSection.setFactor(psCampaignSection.getFactor());
							campaignSection.setFactorType(psCampaignSection.getFactorType());
							campaignSection.setId(psCampaignSection.getId());
							campaignSection.setLine(psCampaignSection.getLine());
							List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
									.getCampaignSectionProducts();
							List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
							if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

								for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
									PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
									campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
									campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
									campaignSectionProduct
											.setCampaignSectionId(psCampaignSectionProduct.getCampaignSectionId());
									campaignSectionProduct.setId(psCampaignSectionProduct.getId());
									campaignSectionProduct.setLimitCount(psCampaignSectionProduct.getLimitCount());
									campaignSectionProduct.setCount(psCampaignSectionProduct.getPriceCount());
									campaignSectionProduct.setPrice(psCampaignSectionProduct.getPricePrice());
									campaignSectionProduct.setProductId(psCampaignSectionProduct.getProductId());
									campaignSectionProductList.add(campaignSectionProduct);
								}
							}
							campaignSection.setSectionProductVOList(campaignSectionProductList);
							campaignSection.setType(psCampaignSection.getConditionType());
							campaignSection.setSort(psCampaignSection.getRanking().floatValue());
							campaignSectionList.add(campaignSection);
						}
					}

					advanceCampaign.setCampaignSectionList(campaignSectionList);
					advanceCampaign.setCode(psAdvanceCampaign.getCode());
					advanceCampaign.setCrossBorderFlag(psAdvanceCampaign.getCrossBorderFlag());
					advanceCampaign.setCumulative(psAdvanceCampaign.getCumulative());
					advanceCampaign.setDiscountTypeId(psAdvanceCampaign.getDiscountTypeId());
					advanceCampaign.setExpireTime(psAdvanceCampaign.getExpireTime());
					advanceCampaign.setId(psAdvanceCampaign.getId());
					advanceCampaign.setLadderRule(psAdvanceCampaign.getLadderRule());
					advanceCampaign.setLevel(psAdvanceCampaign.getLevel());
					advanceCampaign.setMemberLevels(psAdvanceCampaign.getMemberLevels());
					advanceCampaign.setName(psAdvanceCampaign.getName());
					advanceCampaign.setProductScopeId(psAdvanceCampaign.getProductScopeId());
					advanceCampaign.setOptionFlag(psAdvanceCampaign.getOptionFlag());
					advanceCampaign.setStartTime(psAdvanceCampaign.getStartTime());
					advanceCampaign.setState(psAdvanceCampaign.getState());
					advanceCampaign.setTitle(psAdvanceCampaign.getTitle());
					advanceCampaignList.add(advanceCampaign);
				}
			}
			packvo.setAdvanceCampaignList(advanceCampaignList);
			if (psProduct.getAllowVipDiscount() != null && psProduct.getAllowVipDiscount() == 1) {
				packvo.setAllowVipDiscount(true);
			} else {
				packvo.setAllowVipDiscount(false);
			}
			// 商品活动和spv活动都要取
			List<PrsCampaignVO> campaignList = new ArrayList<PrsCampaignVO>();
			List<PsCampaignVO> spvCampaignList = psSpv.getCampaignList();
			List<PsCampaignVO> prodCampaignList = psProduct.getCampaignList();
			List<PsCampaignVO> psCampaignList = new ArrayList<PsCampaignVO>();

			if (CollectionUtils.isNotEmpty(spvCampaignList)) {
				psCampaignList.addAll(spvCampaignList);
			}
			if (CollectionUtils.isNotEmpty(prodCampaignList)) {
				psCampaignList.addAll(prodCampaignList);
			}

			if (CollectionUtils.isNotEmpty(psCampaignList)) {
				for (PsCampaignVO psCampaign : psCampaignList) {
					PrsCampaignVO campaign = new PrsCampaignVO();
					campaign.setAccessWayIds(psCampaign.getAccessWayIds());
					campaign.setAdvance(psCampaign.getAdvance());
					campaign.setApprovalState(psCampaign.getApprovalState());
					List<PsCampaignSectionVO> psCampaignSectionList = psCampaign.getCampaignSectionList();
					List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

					if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
						for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
							PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
							campaignSection.setCampaignId(psCampaignSection.getCampaignId());
							campaignSection.setFactor(psCampaignSection.getFactor());
							campaignSection.setFactorType(psCampaignSection.getFactorType());
							campaignSection.setId(psCampaignSection.getId());
							campaignSection.setLine(psCampaignSection.getLine());
							campaignSection.setSort(psCampaignSection.getRanking().floatValue());
							List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
									.getCampaignSectionProducts();
							List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
							if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

								for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
									PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
									campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
									campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
									campaignSectionProduct
											.setCampaignSectionId(psCampaignSectionProduct.getCampaignSectionId());
									campaignSectionProduct.setId(psCampaignSectionProduct.getId());
									campaignSectionProduct.setLimitCount(psCampaignSectionProduct.getLimitCount());
									campaignSectionProduct.setCount(psCampaignSectionProduct.getPriceCount());
									campaignSectionProduct.setPrice(psCampaignSectionProduct.getPricePrice());
									campaignSectionProduct.setProductId(psCampaignSectionProduct.getProductId());
									campaignSectionProductList.add(campaignSectionProduct);
								}
							}
							campaignSection.setSectionProductVOList(campaignSectionProductList);
							campaignSection.setType(psCampaignSection.getConditionType());

							campaignSectionList.add(campaignSection);
						}
					}
					campaign.setCampaignSectionList(campaignSectionList);
					campaign.setCode(psCampaign.getCode());
					campaign.setCrossBorderFlag(psCampaign.getCrossBorderFlag());
					campaign.setCumulative(psCampaign.getCumulative());
					campaign.setDiscountTypeId(psCampaign.getDiscountTypeId());
					campaign.setExpireTime(psCampaign.getExpireTime());
					campaign.setId(psCampaign.getId());
					campaign.setLadderRule(psCampaign.getLadderRule());
					campaign.setLevel(psCampaign.getLevel());
					campaign.setMemberLevels(psCampaign.getMemberLevels());
					campaign.setName(psCampaign.getName());
					campaign.setOptionFlag(psCampaign.getOptionFlag());
					campaign.setProductScopeId(psCampaign.getProductScopeId());
					campaign.setStartTime(psCampaign.getStartTime());
					campaign.setState(psCampaign.getState());
					campaign.setTitle(psCampaign.getTitle());
					campaignList.add(campaign);
				}
			}

			packvo.setCampaignList(campaignList);
			packvo.setCategoryId(psProduct.getCategoryId());
			packvo.setCount(pack.getCount());
			packvo.setCrossBorderFlag(psProduct.getCrossBorderFlag());
			if (null != psProduct.getIsDiscount() && psProduct.getIsDiscount() == 1) {
				packvo.setHasSpecialDiscount(true);
			} else {
				packvo.setHasSpecialDiscount(false);

			}
			packvo.setId(pack.getId());

			packvo.setIsCustomize(false);
			if (null != psSkus && psSkus.size() > 0) {
				for (PsSkuVO psSku : psSkus) {
					if (null != psSku.getCanCustomize() && psSku.getCanCustomize() == 1) {
						packvo.setIsCustomize(true);

						packvo.setCustomizePrice(BigDecimal.ZERO);
						BigDecimal customizePrice = spvCustomizeAdapter
								.getCustomizePriceBySkuCode(pack.getSpv().getSkuCode());
						if (!NumberUtil.isNullOrZero(customizePrice)) {
							packvo.setCustomizePrice(customizePrice);
						}

						break;
					}
				}
			}
			packvo.setAllowVipDiscount(false);
			if (null != psProduct.getAllowVipDiscount() && psProduct.getAllowVipDiscount() == 1) {
				packvo.setAllowVipDiscount(true);
			}
			packvo.setUseBirthdayDiscount(false);
			if (null != member) {
				if (birthday) {
					if (member.isInBdayDiscountTime()) {
						if (null != psProduct.getAllowBdDiscount() && psProduct.getAllowBdDiscount() == 1) {
							packvo.setUseBirthdayDiscount(true);

						}
					}
				}
			}
			packvo.setHasSpecialDiscount(
					null != psProduct.getIsDiscount() && psProduct.getIsDiscount() == 1 ? true : false);
			packvo.setMinAmount(psSpv.getMinAmount());
			packvo.setProductCode(psProduct.getCode());
			packvo.setProductId(Long.parseLong(psProduct.getId()));
			packvo.setProductName(psProduct.getNameCn());

			// if(psProduct.getCombined()){
			// packvo.setSalesPrice(psSpv.getOriginalPrice());
			// }else{
			packvo.setSalesPrice(psSpv.getSalesPrice());
			// }

			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {

				if (psProduct.getCombined()) {
					packvo.setSalesPrice(psSpv.getOriginalPrice());
				} else {
					packvo.setSalesPrice(psSpv.getSalesPrice());
				}

			} else {
				packvo.setSalesPrice(psSpv.getSalesPrice());
			}

			packvo.setOriginalPrice(psSpv.getOriginalPrice());
			packvo.setCombination(psSpv.getCombined());
			List<PrsSkuVO> skus = new ArrayList<PrsSkuVO>();

			if (psSpv.getCombined()) {

				Map<String, Integer> subSkuCountMap = new HashMap<String, Integer>();
				List<String> skuCodes = new ArrayList<>();
				if (CollectionUtils.isNotEmpty(psSpv.getSkuCombinationList())) {
					for (PsSkuCombinationVO psSku : psSpv.getSkuCombinationList()) {
						skuCodes.add(psSku.getSubSkuCode());
						subSkuCountMap.put(psSku.getSubSkuCode(), psSku.getQuantity());
					}
				}
				for (String skuCode : skuCodes) {
					for (PsSkuVO psSku : psSkus) {
						if (psSku.getSkuCode().equals(skuCode)) {
							PrsSkuVO sku = new PrsSkuVO(psSpv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
									new BigDecimal(psSku.getSalesPrice()), subSkuCountMap.get(skuCode));
							skus.add(sku);
						}
					}
				}
			} else {
				BigDecimal salesPrice = BigDecimal.ZERO;
				for (PsSkuVO psSku : psSkus) {
					if (psSpv.getSkuCode().equals(psSku.getSkuCode())) {
						salesPrice = psSpv.getSalesPrice();
						PrsSkuVO sku = new PrsSkuVO(psSpv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
								salesPrice, 1);
						skus.add(sku);
					}
				}
			}

			packvo.setSkuList(skus);

			packvo.setSpvId(psSpv.getSpvId());
			if (pack.getSource().equals(CartPackSourceEnum.BENEFIT)) {
				logger.info("权益商品组装，spvid={},packId={},interestId={}", psSpv.getSpvId(), pack.getId(),
						pack.getSourceBindVal());
				InterestGoods interestGoods = interestAdapter.getInterestInfo(pack.getSourceBindVal());
				interestGoodsMap.put(pack.getSpvId(), interestGoods);
				PrsInterestGoodsVO interest = new PrsInterestGoodsVO(interestGoods.getId(), false);
				if (null != interestGoods.getIsFreePost() && interestGoods.getIsFreePost() == 1) {
					interest.setFreePostage(true);
				}
				interest.setInterestGoodsId(Integer.parseInt(pack.getSourceBindVal()));
				interest.setCashEndTime(interestGoods.getCashEndTime());
				interest.setCashStartTime(interestGoods.getCashStartTime());
				interest.setCashThreshold(interestGoods.getCashThreshold());

				InterestGoodsVO depositGoods = iInterestGoodsService
						.selectInterestGoodsSku(Integer.parseInt(pack.getSourceBindVal()));
				if (null != depositGoods.getInterestGoodsSkuList().get(0).getDeductionPrice() && depositGoods
						.getInterestGoodsSkuList().get(0).getDeductionPrice().compareTo(BigDecimal.ZERO) != 0) {
					interest.setDeductionPrice(depositGoods.getInterestGoodsSkuList().get(0).getDeductionPrice());
					packvo.setHasDeposit(true);
				}

				interest.setMemberId(member.getId().intValue());
				interest.setSkuCode(pack.getSpv().getSkuCode());
				interest.setSkuNameCn(pack.getSpv().getSkuVO().getSkuNameCN());
				packvo.setInterestGoods(interest);
			}
			packvo.setSource(PrsCartSourceEnum.getEnumByCode(pack.getSource().getCode()));
			productCodes.add(pack.getProduct().getCode());

			if (null != exchgSpuConfigMap) {
				ExchgSpuConfigVO exchangeVO = exchgSpuConfigMap.get(pack.getProduct().getCode());
				List<ExchgSpuConfigDetailVO> exchangelist = exchangeVO.getSpuConfigDetailList();
				if (CollectionUtils.isNotEmpty(exchangelist)) {

					for (ExchgSpuConfigDetailVO exchange : exchangelist) {
						if (exchange.getSkuCode().equalsIgnoreCase(psSpv.getSkuCode())) {
							logger.info("exchange spvid={},psSpv spvid={}", exchange.getSpvId(), psSpv.getSpvId());
							packvo.setPoints(exchange.getExchangeAmount());
							if(null != exchange.getExchangePrice()){
								packvo.setPointDeductPrice(exchange.getExchangePrice());
							}
							packvo.setPointExchange(Boolean.TRUE);
							arg0.setPostageFree(true);
							break;
						}
					}
				}

			} else {
				packvo.setPoints(0);
			}
			
			packList.add(packvo);
		}
		arg0.setPackList(packList);
		if (null != member) {
			// if (interestGoodsMap.size() < 1) {
			if (CollectionUtils.isNotEmpty(productCodes)) {
				InterestFreeCashVO interestFreeCashVO = new InterestFreeCashVO();
				interestFreeCashVO.setMemberId(member.getId().intValue());
				interestFreeCashVO.setProdCodes(productCodes);
				interestFreeCashVO.setAccessWay(accessWay);
				interestFreeCashVO.setStoreChannel(opChannel.getCode());
				ServiceResp<InterestFreeVO> resp = interestFreeService.getOptimallyUsableInterestFree(interestFreeCashVO);
				if (resp.getBean() != null) {
					InterestFreeVO interestFreeVO = resp.getBean();
					arg0.setInterestFreeId(interestFreeVO.getProvideId());
					interestId.add(interestFreeVO.getProvideId());
				}
			}
		}
	}

	
	/**
	 * 取到所有活动list
	 * 
	 * @param steps
	 * @return
	 */
	public List<PrsCampaignVO> allCampaignResults(List<PrsPriceStepVO> steps) {
		List<PrsCampaignVO> campaginList = new ArrayList<PrsCampaignVO>();
		if (CollectionUtils.isNotEmpty(steps)) {

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign()) {
					campaginList.add(step.getCampaign());
				}
			}
		}

		return campaginList;
	}

	/**
	 * 取到所有活动list
	 * 
	 * @param steps
	 * @return
	 */
	public List<OpSalesOrderGiftCardVO> getGiftCardList(List<PrsPriceStepVO> steps) {
		List<OpSalesOrderGiftCardVO> gifts = new ArrayList<OpSalesOrderGiftCardVO>();
		if (CollectionUtils.isNotEmpty(steps)) {

			for (PrsPriceStepVO step : steps) {
				if (CollectionUtils.isNotEmpty(step.getGiftCardList())) {
					for (PrsGiftCardVO card : step.getGiftCardList()) {
						OpSalesOrderGiftCardVO gift = new OpSalesOrderGiftCardVO();
						gift.setGiftCardNo(card.getCardNo());
						gift.setGiftCardValue(card.getDecreaseAmount());
						gifts.add(gift);
					}
				}
			}
		}

		return gifts;
	}

	/**
	 * 获取单品赠品包，多品赠品包和换购包
	 * 
	 * @param steps
	 * @param singleGiftMap
	 * @param giftList
	 * @param addList
	 * @param campaignCodeMap
	 */
	public void getAdditionPacks(List<PrsPriceStepVO> steps, Map<Long, List<PrsAdditionalPackVO>> singleGiftMap,
			List<PrsAdditionalPackVO> giftList, List<PrsAdditionalPackVO> addList,
			Map<String, String> campaignCodeMap) {

		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				List<PrsAdditionalPackVO> adPacks = step.getAdditionalPackList();
				if (CollectionUtils.isNotEmpty(adPacks)) {
					for (PrsAdditionalPackVO adPack : adPacks) {
						if (step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)) {

							if (adPack.getIsSingleScopeCampaign()) {
								List<PrsAdditionalPackVO> giftSingleList = new ArrayList<PrsAdditionalPackVO>();
								if (singleGiftMap.containsKey(adPack.getBindSpvIds().get(0))) {
									giftSingleList.addAll(singleGiftMap.get(adPack.getBindSpvIds().get(0)));
								}
								giftSingleList.add(adPack);
								singleGiftMap.put(adPack.getBindSpvIds().get(0), giftSingleList);
							} else {
								giftList.add(adPack);

							}

							campaignCodeMap.put(adPack.getProductId().toString(), step.getCampaign().getCode());
						} else {
							addList.add(adPack);

						}

					}
				}
			}
		}
	}

	/**
	 * cart包价格组装
	 * 
	 * @param paramPacks
	 * @param spvMap
	 */
	public void assemblePackWithPrice(List<CartProductPack> paramPacks, Map<Long, BigDecimal> spvMap) {
		if (CollectionUtils.isNotEmpty(paramPacks)) {

			Iterator<CartProductPack> iterator = paramPacks.iterator();
			while (iterator.hasNext()) {
				CartProductPack pack = iterator.next();
				PsSpvVO spv = pack.getSpv();
				spv.setDiscountPrice(spvMap.get(pack.getSpvId()));
				pack.setSpv(spv);
			}
		}

	}

	/**
	 * 订单价格步骤组装
	 * 
	 * @param priceResult
	 * @return
	 */
	public Collection<PriceStepVO> getPriceSteps(PrsPacksPriceResultVO priceResult, String desc, String couponTitle) {
		List<PriceStepVO> priceSteps = new ArrayList<PriceStepVO>();
		List<PrsPriceStepVO> stepLists = priceResult.getPriceStepVOs();
		priceSteps.add(new PriceStepVO("商品总额", priceResult.getOriginalTotalPrice()));
		if (CollectionUtils.isNotEmpty(stepLists)) {
			for (PrsPriceStepVO stepList : stepLists) {
				if (stepList.getPriceChange().compareTo(BigDecimal.ZERO) != 0) {
					if (stepList.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)) {
						priceSteps.add(new PriceStepVO(desc + stepList.getStepDesc(), stepList.getPriceChange()));
					} else if (stepList.getPriceType().equals(PrsPriceTypeEnum.COUPON)) {
						if (StringUtils.isNoneBlank(couponTitle)) {
							priceSteps.add(new PriceStepVO(couponTitle, stepList.getPriceChange()));
						} else {
							priceSteps.add(new PriceStepVO(stepList.getStepDesc(), stepList.getPriceChange()));
						}
					} else {
						priceSteps.add(new PriceStepVO(stepList.getStepDesc(), stepList.getPriceChange()));
					}
				}
			}
		}

		return priceSteps;

	}

	/**
	 * 运费（购物车用）
	 * 
	 * @param steps
	 * @return
	 */
	public BigDecimal getPostagePrice(List<PrsPriceStepVO> steps) {
		BigDecimal postage = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (step.getPriceType().equals(PrsPriceTypeEnum.POSTAGE)
						|| step.getPriceType().equals(PrsPriceTypeEnum.POSTAGE_FREE)
						|| step.getPriceType().equals(PrsPriceTypeEnum.POINTS_EXCHANGE_FREE)
						|| step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)
						|| step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_PRD_POSTAGE_FREE)) {
					postage = postage.add(step.getPriceChange());
				}
			}
		}

		return postage;

	}

	/**
	 * 是否使用免邮权益
	 * 
	 * @param steps
	 * @return
	 */
	public Boolean getPostageInterest(List<PrsPriceStepVO> steps) {
		Boolean postage = false;
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)
						|| step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_PRD_POSTAGE_FREE)) {
					postage = true;
					break;
				}
			}
		}

		return postage;

	}

	/**
	 * 是否使用优惠券
	 * 
	 * @param steps
	 * @return
	 */
	public Boolean isUseCoupon(List<PrsPriceStepVO> steps) {
		Boolean postage = false;
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (step.getPriceType().equals(PrsPriceTypeEnum.COUPON)) {
					postage = true;
					break;
				}
			}
		}

		return postage;

	}

	public Boolean isUseMarketVip(List<PrsPriceStepVO> steps) {
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (step.getPriceType().equals(PrsPriceTypeEnum.MARKET_DISCOUNT)) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 找出每个主品spvId对应的赠品productId列表
	 * 
	 * @param steps
	 * @return
	 */
	public Map<Long, List<PrsPriceStepVO>> getSingleGiftFromSteps(List<PrsPriceStepVO> steps) {

		Map<Long, List<PrsPriceStepVO>> map = new HashMap<Long, List<PrsPriceStepVO>>();
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				List<PrsPriceStepVO> listVO = new ArrayList<PrsPriceStepVO>();
				if (step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
					List<PrsAdditionalPackVO> adds = step.getAdditionalPackList();
					for (PrsAdditionalPackVO add : adds) {
						for (Long id : add.getBindSpvIds()) {
							if (map.containsKey(id)) {
								listVO.addAll(map.get(id));
							}
							listVO.add(step);
							map.put(id, listVO);
						}
					}
				}

			}
		}

		return map;

	}

	/**
	 * 找出每个主品spvId对应的step列表
	 * 
	 * @param steps
	 * @return
	 */
	public void getSingleGiftFromSteps(List<PrsPriceStepVO> steps, List<String> mitiGifts,
			Map<String, List<String>> singleMap, List<String> adds) {

		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
					if (step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)) {
						for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
							if (add.getIsSingleScopeCampaign()) {
								List<String> ads = new ArrayList<>();
								if (singleMap.containsKey(add.getBindSpvIds().get(0).toString())) {
									ads.addAll(singleMap.get(add.getBindSpvIds().get(0).toString()));
								}
								ads.add(add.getProductId().toString());
								singleMap.put(add.getBindSpvIds().get(0).toString(), ads);
							} else {
								mitiGifts.add(add.getProductId().toString());
							}
						}
					} else if (step.getCampaign().getDiscountTypeId().equals(DiscountType.CHEAPEN_OTHER.id)) {
						for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
							adds.add(add.getProductId().toString());
						}
					}
				}
			}

		}

	}

	/**
	 * 找出所有赠品
	 * 
	 * @param steps
	 * @return
	 */
	public void getAllGiftFromSteps(List<PrsPriceStepVO> steps, List<String> gifts) {

		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
					if (step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)) {
						for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
							gifts.add(add.getProductId().toString());
						}
					}
				}
			}

		}

	}

	/**
	 * 组装单品赠品包
	 * 
	 * @param products
	 * @param steps
	 * @param spvId
	 * @param stockMap
	 * @param hasVariantsMap
	 * @return
	 */
	public List<CartProductPackVO> getGiftPacks(List<PsProductVO> products, List<PrsPriceStepVO> steps, Long spvId,
			Map<String, SSkuStockVO> stockMap, Map<PsProductVO, Boolean> hasVariantsMap) {

		Map<String, CampaignStreamVO> csMap = new HashMap<>();
		Map<String, Integer> checkCspLimitMap = new HashMap<>();
		for (PrsPriceStepVO step : steps) {

			if (null != step.getCampaign() && step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
					&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
				for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
					if (add.getIsSingleScopeCampaign() && add.getBindSpvIds().get(0).equals(spvId)) {
						for (PsProductVO product : products) {
							if (null != product) {

								if (add.getProductId().toString().equals(product.getId())
										&& csMap.get(product.getId()) == null) {
									CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
									campaignStreamVO.setCampaignCode(step.getCampaign().getCode());
									campaignStreamVO.setProductCode(product.getCode());
									csMap.put(product.getId(), campaignStreamVO);
								}
							}
						}
					}
				}
			}
		}

		// 验证赠品限量库存
		ServiceResp<Map<String, Integer>> srp = campaignLimitService
				.mapLeftCspLimitAmount(new ArrayList<>(csMap.values()));
		if (srp.isSuccess() && srp.getBean() != null) {

			checkCspLimitMap.putAll(srp.getBean());
		}

		List<CartProductPackVO> list = new ArrayList<CartProductPackVO>();
		for (PrsPriceStepVO step : steps) {

			if (null != step.getCampaign() && step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
					&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
				for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
					if (add.getIsSingleScopeCampaign() && add.getBindSpvIds().get(0).equals(spvId)) {
						for (PsProductVO product : products) {
							if (null != product) {

								if (add.getProductId().toString().equals(product.getId())) {

									CartProductPackVO pack = new CartProductPackVO();
									PrsCampaignVO camp = step.getCampaign();
									pack.setCount(add.getCount());
									pack.setSource(CartPackSource.GIFT);
									pack.setProductId(product.getCode());

									// 获取有库存的spv
									PsSpvVO spv = null;
									Integer left = 0;
									for (PsSpvVO spvLeft : product.getSpvList()) {
										left = getSpvLeft(stockMap, spvLeft);
										if (left < add.getCount()) {
											left = 0;
										}
										String key = step.getCampaign().getCode() + product.getCode();
										// 已达限量上限
										if (checkCspLimitMap.get(key) != null
												&& checkCspLimitMap.get(key) < add.getCount()) {
											left = 0;
										}
										if (left > 0) {
											spv = spvLeft;
											break;
										}
									}
									if (spv == null) {
										break;
									}

									SpvVO spvVO = new SpvVO();
									spvVO.setId(spv.getSpvId());
									BrandVO brand = new BrandVO();
									brand.setId(product.getBrands().get(0).getBrandId());
									brand.setName(product.getBrands().get(0).getBrandNameCN());
									spvVO.setBrand(brand);

									StringBuilder sb = new StringBuilder();
									List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
									if (CollectionUtils.isNotEmpty(attrList)) {
										for (PsAttributeValuePairVO attr : attrList) {
											if (attr != null
													&& org.apache.commons.lang.StringUtils
															.isNotBlank(attr.getAttrName())
													&& org.apache.commons.lang.StringUtils.isNotBlank(attr.getValue()))
												sb.append(attr.getAttrName()).append(" : ").append(attr.getValue())
														.append(" ");
										}
									}
									spvVO.setSpvDesc(sb.toString());
									// 图片加前缀
									String featureImage = product.getPicList();
									if (org.apache.commons.lang.StringUtils.isNotBlank(featureImage)
											&& !featureImage.startsWith(FileConstant.BASE_URL)) {
										featureImage = FileConstant.BASE_URL + featureImage;
									}
									spvVO.setImage(featureImage);
									spvVO.setMinAmount(spv.getMinAmount());
									spvVO.setName(product.getNameCn());
									spvVO.setPrice(BigDecimal.ZERO);
									if (product.getCombined()) {
										// price
										spvVO.setRawPrice(spv.getOriginalPrice());
									} else {
										// price
										spvVO.setRawPrice(spv.getSalesPrice());
									}
									spvVO.setSkuCodes(this.getSkuCodesBySpv(spv));
									spvVO.setLeft(left);
									spvVO.setProductCode(spv.getProductCode());
									pack.setSpv(spvVO);
									PackCampaignVO campaignVO = new PackCampaignVO();
									campaignVO.setId(camp.getId());
									campaignVO.setName(camp.getName());
									InfoVO info = new InfoVO();
									info.setType("赠品");
									info.setSummaryColor(
											spvVO.getLeft() != null && spvVO.getLeft() <= 0 ? "#000000" : "#333333");

									campaignVO.setInfo(info);

									pack.setCampaign(campaignVO);
									pack.setHasVariants(hasVariantsMap.get(product));
									pack.setOwned(pack.getCount() != 0);
									list.add(pack);
								}
							}
						}
					}
				}
			}
		}
		return list;

	}

	/**
	 * 组装多品赠品包
	 * 
	 * @param products
	 * @param steps
	 * @param stockMap
	 * @param hasVariantsMap
	 * @return
	 */
	public List<CartProductPackVO> getMutiGiftPacks(List<PsProductVO> products, List<PrsPriceStepVO> steps,
			Map<String, SSkuStockVO> stockMap, Map<PsProductVO, Boolean> hasVariantsMap) {
		logger.info("多品赠品包组装");
		List<CartProductPackVO> list = new ArrayList<CartProductPackVO>();
		if (CollectionUtils.isNotEmpty(products)) {
			logger.info("多品赠品共有 size= {}", products.size());
			Map<String, CampaignStreamVO> csMap = new HashMap<>();
			Map<String, Integer> checkCspLimitMap = new HashMap<>();
			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign() && step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
						if (!add.getIsSingleScopeCampaign()) {
							for (PsProductVO product : products) {
								if (null != product) {
									if (add.getProductId().toString().equals(product.getId())) {

										CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
										campaignStreamVO.setCampaignCode(step.getCampaign().getCode());
										campaignStreamVO.setProductCode(product.getCode());
										csMap.put(product.getId(), campaignStreamVO);

									}
								}
							}
						}
					}
				}
			}

			// 验证赠品限量库存
			ServiceResp<Map<String, Integer>> srp = campaignLimitService
					.mapLeftCspLimitAmount(new ArrayList<>(csMap.values()));
			if (srp.isSuccess() && srp.getBean() != null) {

				checkCspLimitMap.putAll(srp.getBean());
			}

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign() && step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
						if (!add.getIsSingleScopeCampaign()) {
							for (PsProductVO product : products) {
								if (null != product) {
									if (add.getProductId().toString().equals(product.getId())) {
										CartProductPackVO pack = new CartProductPackVO();

										PrsCampaignVO camp = step.getCampaign();
										pack.setCount(add.getCount());
										pack.setSource(CartPackSource.GIFT);
										pack.setProductId(product.getCode());

										// 获取有库存的spv
										PsSpvVO spv = null;
										Integer left = 0;
										for (PsSpvVO spvLeft : product.getSpvList()) {
											left = getSpvLeft(stockMap, spvLeft);
											if (left < add.getCount()) {
												left = 0;
											}
											String key = step.getCampaign().getCode() + product.getCode();
											// 已达限量上限
											if (checkCspLimitMap.get(key) != null
													&& checkCspLimitMap.get(key) < add.getCount()) {
												left = 0;
											}
											if (left > 0) {
												spv = spvLeft;
												break;
											}
										}
										if (spv == null) {
											break;
										}

										SpvVO spvVO = new SpvVO();
										spvVO.setId(spv.getSpvId());
										BrandVO brand = new BrandVO();
										brand.setId(product.getBrands().get(0).getBrandId());
										brand.setName(product.getBrands().get(0).getBrandNameCN());
										spvVO.setBrand(brand);
										StringBuilder sb = new StringBuilder();
										List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
										if (CollectionUtils.isNotEmpty(attrList)) {
											for (PsAttributeValuePairVO attr : attrList) {
												if (attr != null
														&& org.apache.commons.lang.StringUtils
																.isNotBlank(attr.getAttrName())
														&& org.apache.commons.lang.StringUtils
																.isNotBlank(attr.getValue()))
													sb.append(attr.getAttrName()).append(" : ").append(attr.getValue())
															.append(" ");
											}
										}
										spvVO.setSpvDesc(sb.toString());
										// 图片加前缀
										String featureImage = product.getPicList();
										if (org.apache.commons.lang.StringUtils.isNotBlank(featureImage)
												&& !featureImage.startsWith(FileConstant.BASE_URL)) {
											featureImage = FileConstant.BASE_URL + featureImage;
										}
										spvVO.setImage(featureImage);

										spvVO.setMinAmount(spv.getMinAmount());
										spvVO.setName(product.getNameCn());
										spvVO.setPrice(BigDecimal.ZERO);

										if (product.getCombined()) {
											// price
											spvVO.setRawPrice(spv.getOriginalPrice());
										} else {
											// price
											spvVO.setRawPrice(spv.getSalesPrice());
										}

										if (add.getLimitCount() != -1) {
											Quota quota = new Quota();
											quota.setTotal(add.getLimitCount());
											quota.setLeft(add.getLimitCount());
											spvVO.setQuota(quota);
										}

										spvVO.setSkuCodes(getSkuCodesBySpv(spv));
										spvVO.setLeft(left);
										spvVO.setProductCode(spv.getProductCode());
										pack.setSpv(spvVO);
										pack.setHasVariants(hasVariantsMap.get(product));
										pack.setOwned(pack.getCount() != 0);
										PackCampaignVO campaignVO = new PackCampaignVO();
										campaignVO.setId(camp.getId());
										campaignVO.setName(camp.getName());
										InfoVO info = new InfoVO();
										info.setType("赠品");
										if (camp.getCode().equals("app_first_buy")) {
											info.setType("首单赠");
										}
										info.setSummaryColor(spvVO.getLeft() != null && spvVO.getLeft() <= 0 ? "#000000"
												: "#333333");

										campaignVO.setInfo(info);
										pack.setCampaign(campaignVO);

										list.add(pack);
									}
								}
							}
						}
					}
				}
			}
		}
		return list;

	}

	private List<String> getSkuCodesBySpv(PsSpvVO spv) {
		List<String> skuCodes = Lists.newArrayList();
		if (spv.getCombined()) {
			if (CollectionUtils.isNotEmpty(spv.getSkuCombinationList())) {
				for (PsSkuCombinationVO psc : spv.getSkuCombinationList()) {
					skuCodes.add(psc.getSubSkuCode());
				}
			}
		} else {
			skuCodes.add(spv.getSkuCode());
		}
		return skuCodes;
	}

	private int getSpvLeft(Map<String, SSkuStockVO> stockMap, PsSpvVO spv) {
		int left = 0;
		if (spv.getCombined()) {
			List<String> skuCodes = this.getSkuCodesBySpv(spv);
			left = stockMap.get(skuCodes.get(0)).getCanUseQuantity();
			for (String sku : skuCodes) {
				SSkuStockVO stock = stockMap.get(sku);
				if (left > stock.getCanUseQuantity()) {
					left = stock.getCanUseQuantity();
				}
			}
		} else {

			// 不是组合商品先查询预售库存
			SPresaleVO sPresaleVO = sPresaleService.findAvaliableBySkuCode(spv.getSkuCode(), false);
			if (null != sPresaleVO) {

				SPresaleSaleInvVO spaleInvMap = spaleInvMap = sPresaleService.findCanUseQttBySkuCode(spv.getSkuCode(),
						null);
				left = left + spaleInvMap.getCanUseInv();
				logger.info("预售商品库存 spvId={}，skuCode={}，left={} ", spv.getSpvId(), spv.getSkuCode(), left);
			}
			if (left < 1) {// 预售库存没有时再查询实际库存

				SSkuStockVO stock = stockMap.get(spv.getSkuCode());
				left = left + stock.getCanUseQuantity();
				logger.info("不是预售商品或没有预售库存,查询实际库存 spvId={}，skuCode={}，left={} ", spv.getSpvId(), spv.getSkuCode(),
						left);

			}

		}
		return left;
	}

	/**
	 * 组装所有赠品包
	 * 
	 * @param products
	 * @param steps
	 * @return
	 */
	public List<CartProductPack> getAllGiftPacks(List<PsProductVO> products, List<PrsPriceStepVO> steps) {
		List<CartProductPack> list = new ArrayList<CartProductPack>();
		if (CollectionUtils.isNotEmpty(products)) {
			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign() && step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
						for (PsProductVO product : products) {
							if (null != product) {
								if (add.getProductId().toString().equals(product.getId())) {
									CartProductPack pack = new CartProductPack();

									pack.setCount(add.getCount());
									pack.setSource(CartPackSourceEnum.GIFT);
									pack.setProductId(Long.parseLong(product.getId()));
									PsSpvVO spv = product.getSpvList().get(0);
									List<String> skuCodes = Lists.newArrayList();
									spv.setDiscountPrice(BigDecimal.ZERO);
									pack.setSpv(spv);
									pack.setProduct(product);
									list.add(pack);
								}
							}
						}
					}
				}
			}
		}
		return list;

	}

	/**
	 * 组装换购包
	 *
	 * @param products
	 * @param steps
	 * @param addiblePacks
	 * @param stockMap
	 * @param hasVariantsMap
	 * @param opChannel
	 * @return
	 */
	public List<CartProductPackVO> getAddPacks(List<PsProductVO> products, List<PrsPriceStepVO> steps,
			List<? extends ProductPack> addiblePacks, Map<String, SSkuStockVO> stockMap,
			Map<PsProductVO, Boolean> hasVariantsMap, OpChannelVO opChannel) {
		return this.getAddPacks(products, steps, addiblePacks, stockMap, hasVariantsMap, opChannel, Boolean.FALSE);
	}

	/**
	 * 组装换购包
	 * 
	 * @param products
	 * @param steps
	 * @param addiblePacks
	 * @param stockMap
	 * @param hasVariantsMap
	 * @param opChannel
	 * @param isSmartPos
	 * @return
	 */
	public List<CartProductPackVO> getAddPacks(List<PsProductVO> products, List<PrsPriceStepVO> steps,
			List<? extends ProductPack> addiblePacks, Map<String, SSkuStockVO> stockMap,
			Map<PsProductVO, Boolean> hasVariantsMap, OpChannelVO opChannel, Boolean isSmartPos) {
		List<CartProductPackVO> list = new ArrayList<CartProductPackVO>();

		Map<String, PsSpvVO> ownedProdAndSpvidMap = new HashMap<>();
		if (CollectionUtils.isNotEmpty(addiblePacks)) {
			for (ProductPack addiblePack : addiblePacks) {
				ownedProdAndSpvidMap.put(addiblePack.getProductId().toString(), addiblePack.getSpv());
			}
		}

		if (CollectionUtils.isNotEmpty(products)) {

			Map<String, Integer> checkCspLimitMap = new HashMap<>();
			Map<String, CampaignStreamVO> csMap = new HashMap<>();
			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign()
						&& step.getCampaign().getDiscountTypeId().equals(DiscountType.CHEAPEN_OTHER.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
						for (PsProductVO product : products) {
							if (null != product) {
								if (add.getProductId().toString().equals(product.getId())) {

									CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
									campaignStreamVO.setCampaignCode(step.getCampaign().getCode());
									campaignStreamVO.setProductCode(product.getCode());
									csMap.put(product.getId(), campaignStreamVO);

								}
							}
						}
					}
				}
			}

			// 验证赠品限量库存
			ServiceResp<Map<String, Integer>> srp = campaignLimitService
					.mapLeftCspLimitAmount(new ArrayList<>(csMap.values()));
			if (srp.isSuccess() && srp.getBean() != null) {

				checkCspLimitMap.putAll(srp.getBean());
			}

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign()
						&& step.getCampaign().getDiscountTypeId().equals(DiscountType.CHEAPEN_OTHER.id)
						&& CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
						for (PsProductVO product : products) {
							if (null != product) {
								if (add.getProductId().toString().equals(product.getId())) {
									CartProductPackVO pack = new CartProductPackVO();

									PrsCampaignVO camp = step.getCampaign();
									pack.setCount(add.getCount());
									pack.setSource(CartPackSource.ADDIBLE);
									pack.setProductId(product.getCode());

									// 获取有库存的spv
									PsSpvVO spv = null;
									Integer left = 0;
									// 取已选定换购商品
									if (ownedProdAndSpvidMap.containsKey(product.getId())) {
										spv = ownedProdAndSpvidMap.get(product.getId());
										if (Integer.valueOf(1).equals(opChannel.getChannelType())
												&& BooleanUtils.isFalse(isSmartPos)) {
											left = forIposAddSpvCanSaleNum(spv, stockMap);
										} else {
											left = this.getSpvLeft(stockMap, spv);
										}
										// if (left < add.getCount()) {
										// left = 0;
										// }
										String key = step.getCampaign().getCode() + product.getCode();
										// 已达限量上限
										if (checkCspLimitMap.get(key) != null
												&& checkCspLimitMap.get(key) < add.getCount()) {
											left = checkCspLimitMap.get(key);
										}
									} else {
										// 取默认库存非0的spv对象
										for (PsSpvVO spvLeft : product.getSpvList()) {
											if (Integer.valueOf(1).equals(opChannel.getChannelType())) {
												left = forIposAddSpvCanSaleNum(spvLeft, stockMap);
											} else {
												left = this.getSpvLeft(stockMap, spvLeft);
											}
											// if (left < add.getCount()) {
											// left = 0;
											// }
											String key = step.getCampaign().getCode() + product.getCode();
											// 已达限量上限
											if (checkCspLimitMap.get(key) != null
													&& checkCspLimitMap.get(key) < add.getCount()) {
												left = checkCspLimitMap.get(key);
											}
											if (left > 0) {
												spv = spvLeft;
												break;
											}
										}
										if (spv == null) {
											spv = product.getSpvList().get(0);
										}
									}
									SpvVO spvVO = new SpvVO();

									spvVO.setId(spv.getSpvId());
									BrandVO brand = new BrandVO();
									brand.setId(product.getBrands().get(0).getBrandId());
									brand.setName(product.getBrands().get(0).getBrandNameCN());
									spvVO.setBrand(brand);

									StringBuilder sb = new StringBuilder();
									List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
									if (CollectionUtils.isNotEmpty(attrList)) {
										for (PsAttributeValuePairVO attr : attrList) {
											if (attr != null
													&& org.apache.commons.lang.StringUtils
															.isNotBlank(attr.getAttrName())
													&& org.apache.commons.lang.StringUtils.isNotBlank(attr.getValue()))
												sb.append(attr.getAttrName()).append(" : ").append(attr.getValue())
														.append(" ");
										}
									}
									spvVO.setSpvDesc(sb.toString());
									// 图片加前缀
									String featureImage = product.getPicList();
									if (org.apache.commons.lang.StringUtils.isNotBlank(featureImage)
											&& !featureImage.startsWith(FileConstant.BASE_URL)) {
										featureImage = FileConstant.BASE_URL + featureImage;
									}
									spvVO.setImage(featureImage);
									spvVO.setMinAmount(spv.getMinAmount());
									spvVO.setName(product.getNameCn());
									spvVO.setPrice(add.getDiscountPrice());
									if (product.getCombined()) {
										// price
										spvVO.setRawPrice(spv.getOriginalPrice());
									} else {
										// price
										spvVO.setRawPrice(spv.getSalesPrice());
									}
									spvVO.setSkuCodes(this.getSkuCodesBySpv(spv));

									spvVO.setLeft(left);
									spvVO.setProductCode(spv.getProductCode());
									if (add.getLimitCount() != -1) {
										Quota quota = new Quota();
										quota.setTotal(add.getLimitCount());
										quota.setLeft(add.getLimitCount());
										if (left == 0) {
											quota.setLeft(0);
										}
										spvVO.setQuota(quota);
									}

									pack.setSpv(spvVO);
									pack.setHasVariants(hasVariantsMap.get(product));
									PackCampaignVO campaignVO = new PackCampaignVO();
									campaignVO.setId(camp.getId());
									campaignVO.setName(camp.getName());
									InfoVO info = new InfoVO();
									info.setType("换购");
									info.setSummaryColor(
											spvVO.getLeft() != null && spvVO.getLeft() <= 0 ? "#000000" : "#333333");

									campaignVO.setInfo(info);
									pack.setCampaign(campaignVO);

									pack.setOwned(false);
									if (CollectionUtils.isNotEmpty(addiblePacks)) {
										for (ProductPack addiblePack : addiblePacks) {
											if (addiblePack.getSpvId().equals(pack.getSpv().getId())) {
												pack.setOwned(true);
												if (spvVO.getLeft() == 0 || pack.getCount() > spvVO.getLeft()
														|| pack.getCount() < addiblePack.getCount()) {
													pack.setOwned(false);
												}
												pack.setId(addiblePack.getId());
											}
										}
									}

									list.add(pack);
								}
							}
						}
					}
				}
			}
		}
		return list;

	}

	public void getLabels(List<PrsCartSettleLabelVO> labelList, List<PrsCartSettleLabelVO> mutiLabels,
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap) {
		if (CollectionUtils.isNotEmpty(labelList)) {
			for (PrsCartSettleLabelVO label : labelList) {
				if (label.getIsSingleScopeCampaign()) {
					List<PrsCartSettleLabelVO> sl = new ArrayList<PrsCartSettleLabelVO>();
					if (null != singleLabelMap.get(label.getSingleScopeSpvId())) {
						sl.addAll(singleLabelMap.get(label.getSingleScopeSpvId()));
					}
					sl.add(label);
					singleLabelMap.put(label.getSingleScopeSpvId(), sl);
				} else {
					mutiLabels.add(label);
				}
			}
		}
	}

	/**
	 * 根据活动组装标签
	 * 
	 * @param prsLabel
	 * @return
	 */
	public Label setupLabel(PrsCartSettleLabelVO prsLabel) {
		Label label = new Label();
		label.setType(prsLabel.getCartSettleLabel().getName());
		label.setSummary(prsLabel.getLabelDesc());
		if (prsLabel.getCartSettleLabel().equals(PrsCartSettleLabelEnum.POSTAGE)) {
			label.setMode(LabelMode.POSTAGE);
		} else {
			label.setMode(LabelMode.CAMPAIGN);
		}
		CampaignVO campaignVO = new CampaignVO();
		campaignVO.setId(prsLabel.getCampaignId());
		campaignVO.setName(prsLabel.getCampaignTitle());

		campaignVO.setFulfilled(false);
		if (prsLabel.getHintWords().equals("已满足")) {
			campaignVO.setFulfilled(true);
		}
		campaignVO.setLinkDesc(prsLabel.getHintWords());
		label.setCampaign(campaignVO);
		return label;
	}

//	/**
//	 * 取服务费价格步骤（下单用）
//	 * 
//	 * @param steps
//	 * @return
//	 */
//	public List<ServiceFeeStep> setServiceStep(List<PrsPriceStepVO> steps) {
//		List<ServiceFeeStep> serviceSteps = new ArrayList<ServiceFeeStep>();
//		for (PrsPriceStepVO step : steps) {
//
//			if (step.getPriceType().equals(PrsPriceTypeEnum.CUSTOMIZE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.CUSTOMIZE_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.OVERSEA_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.OVERSEAS)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.POSTAGE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.POSTAGE_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.POINTS_EXCHANGE_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.REMOTE_AREA_DELIVERY)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_PRD_POSTAGE_FREE)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.TIME)
//					|| step.getPriceType().equals(PrsPriceTypeEnum.POINTS_EXCHANGE)) {
//
//				ServiceFeeStep service = new ServiceFeeStep();
//				service.setDesc(step.getStepDesc());
//				service.setPrice(step.getPriceChange());
//				service.setPriceType(PriceType.getByCode(step.getPriceType().getCode()));
//				serviceSteps.add(service);
//			}
//		}
//
//		return serviceSteps;
//	}

	/**
	 * 组装订单packvo
	 * 
	 * @param packList
	 * @param member
	 * @param opChannel
	 * @param withLabels
	 * @param withGifts
	 * @param checkHasVariants
	 * @param accessWay
	 * @param birthday
	 * @param spvPresaleDateMap
	 * @param interestMaps
	 * @param giftSinglePackMaps
	 * @param singleLabelMap
	 * @param isOrder
	 * @param spvLabelMap
	 * @return
	 */
	public List<CartProductPackVO> getCartProductPackList(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, boolean withLabels, boolean withGifts, boolean checkHasVariants,
			AccessWayEnum accessWay, boolean birthday, Map<String, Date> spvPresaleDateMap,
			Map<Long, InterestGoods> interestMaps, Map<Long, List<CartProductPackVO>> giftSinglePackMaps,
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap, Boolean isOrder,
			Map<PsSpvVO, List<Label>> spvLabelMap) {

		logger.info("无效商品商品包查询");
		Date start = new Date();
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		logger.info("商品包不为空");
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());
		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		logger.info("获取商品spv");
		Map<PsSpvVO, SpvVO> spvVoMap = spvPriceAdapter.getSpvMapWithSpvPrice(spvs, productMap, member, opChannel,
				spvPresaleDateMap);

		// ===========spv label map============

		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = null;
		if (checkHasVariants) {
			hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(), opChannel);
		}

		// ==============================
		for (int i = 0; i < packList.size(); i++) {
			ProductPack pack = packList.get(i);
			PsProductVO product = productMap.get(pack.getProductId().toString());
			PsSpvVO spv = pack.getSpv();
			SpvVO spvVO = spvVoMap.get(spv);
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				spvVO.setPrice(pack.getSpv().getDiscountPrice());
				packVo.setSpv(spvVO);
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {

					packVo.setLabels(Lists.newArrayList(label));
				}
				if (checkHasVariants) {
					packVo.setHasVariants(hasVariantsMap.get(product));
				}

				// 给pack加上单品活动标签
				if (singleLabelMap.size() > 0) {
					if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
						if (CollectionUtils.isNotEmpty(singleLabelMap.get(packVo.getSpv().getId()))) {
							List<Label> singleLabels = new ArrayList<Label>();
							for (PrsCartSettleLabelVO single : singleLabelMap.get(packVo.getSpv().getId())) {
								if (single.isFit()) {
									if (null != single.getDiscountType()
											&& !single.getDiscountType().getId().equals(DiscountType.GIFT.id) && !single
													.getDiscountType().getId().equals(DiscountType.CHEAPEN_OTHER.id)) {
										singleLabels.add(setupLabel(single));

									}
								}

							}
							packVo.setLabels(singleLabels);
						}
					}
				}

				if (pack.isCustomize()) {
					List<UserSingleCustomization> userCustomizes = Lists.newArrayList();
					if (CollectionUtils.isNotEmpty(pack.getCustomizeList())) {
						for (CartCustomization cartCustomization : pack.getCustomizeList()) {
							UserSingleCustomization userSingleCustomization = new UserSingleCustomization();
							userSingleCustomization.setCode(cartCustomization.getCustomDimensionId());
							userSingleCustomization.setName(cartCustomization.getCustomDimensionName());
							userSingleCustomization.setValue(cartCustomization.getCustomDimensionValue());
							userCustomizes.add(userSingleCustomization);
						}
					}
					packVo.setCustomized(pack.isCustomize());
					packVo.setCustomizes(userCustomizes);
				}
				if (withGifts) {
					packVo.setGiftPacks(giftSinglePackMaps.get(pack.getSpvId()));
				}
				// 如果是权益修改商品
				if (!CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
					list.add(packVo);
				} else {
					InterestGoods interestGoods = interestMaps.get(pack.getSpvId());
					CartBenefitVO cartBenefitVO = new CartBenefitVO();
					cartBenefitVO.setId(pack.getSourceBindVal());
					cartBenefitVO.setCashStartTime(interestGoods.getCashStartTime());
					cartBenefitVO.setCashEndTime(interestGoods.getCashEndTime());
					if (DateUtil.isInTime(null, interestGoods.getCashEndTime(), null)) {
						packVo.setBenefit(cartBenefitVO);
						packVo.setHasVariants(interestAdapter.hasVariants(pack.getSourceBindVal()));
						packVo.setSpv(
								cartProductPackAdapter.convertInterestSpvVO4PsSpvVO(spv, product, spvVO.getDiscount()));
						list.add(packVo);
					}
				}

			}
		}

		Date end = new Date();
		logger.info("方法getCartProductPackList花费时间：{}毫秒", end.getTime() - start.getTime());
		return list;

	}

	// /**
	// * 组装单品赠品包
	// *
	// * @param paramPacks
	// * @param singleGiftMap
	// * @param spvMap
	// * @return
	// */
	// public Map<Long, List<CartProductPackVO>>
	// assambleGiftMap(List<CartProductPack> paramPacks,
	// Map<Long, List<PrsAdditionalPackVO>> singleGiftMap, Map<PsSpvVO, SpvVO>
	// spvMap) {
	//
	// Map<Long, List<CartProductPackVO>> map = new HashMap<Long,
	// List<CartProductPackVO>>();
	// for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry :
	// singleGiftMap.entrySet()) {
	// List<CartProductPackVO> list = new ArrayList<CartProductPackVO>();
	// for (PrsAdditionalPackVO single : entry.getValue()) {
	//
	// for (CartProductPack paramPack : paramPacks) {
	// if (single.getProductId().equals(paramPack.getProductId())) {
	// list.add(assambleGiftPack(paramPack, spvMap.get(paramPack.getSpv())));
	// }
	// }
	// }
	//
	// map.put(entry.getKey(), list);
	//
	// }
	// return map;
	//
	// }

	// /**
	// * 组装赠品包
	// *
	// * @param paramPacks
	// * @param singleGiftMap
	// * @param spvMap
	// * @return
	// */
	// public List<CartProductPackVO> assambleMutiGiftMap(List<CartProductPack>
	// paramPacks,
	// List<PrsAdditionalPackVO> giftList, Map<PsSpvVO, SpvVO> spvMap) {
	//
	// List<CartProductPackVO> list = new ArrayList<CartProductPackVO>();
	// for (PrsAdditionalPackVO gift : giftList) {
	//
	// for (CartProductPack paramPack : paramPacks) {
	// if (gift.getProductId().equals(paramPack.getProductId())) {
	// list.add(assambleGiftPack(paramPack, spvMap.get(paramPack.getSpv())));
	// }
	// }
	// }
	//
	// return list;
	//
	// }

	/**
	 * 把每个赠品绑到主品上 多品赠品随便绑一个，默认绑到第一个上
	 * 
	 * @param singleMap
	 * @param mutiMap
	 * @return
	 */
	public Map<Long, List<Long>> blindGift(Map<Long, List<PrsAdditionalPackVO>> singleMap,
			Map<Long, List<PrsAdditionalPackVO>> mutiMap) {
		Map<Long, List<Long>> giftMap = new HashMap<Long, List<Long>>();
		if (!singleMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					for (PrsAdditionalPackVO add : entry.getValue()) {
						List<Long> ads = new ArrayList<Long>();
						if (giftMap.containsKey(add.getBindSpvIds().get(0))) {
							ads.addAll(giftMap.get(add.getBindSpvIds().get(0)));
						}
						ads.add(add.getProductId());
						giftMap.put(add.getBindSpvIds().get(0), ads);
					}
				}
			}
		}

		if (!mutiMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : mutiMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					for (PrsAdditionalPackVO add : entry.getValue()) {
						List<Long> ads = new ArrayList<Long>();
						if (giftMap.containsKey(add.getBindSpvIds().get(0))) {
							ads.addAll(giftMap.get(add.getBindSpvIds().get(0)));
						}
						ads.add(add.getProductId());
						giftMap.put(add.getBindSpvIds().get(0), ads);
					}
				}
			}
		}
		return giftMap;
	}

	/**
	 * 取赠品数量
	 * 
	 * @param singleGiftMap
	 * @param mutiGiftMap
	 * @return
	 */
	public Map<Long, Integer> getGiftSize(Map<Long, List<PrsAdditionalPackVO>> singleGiftMap,
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap) {
		Map<Long, Integer> giftMap = new HashMap<Long, Integer>();

		if (singleGiftMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					for (PrsAdditionalPackVO add : entry.getValue()) {
						giftMap.put(add.getBindSpvIds().get(0), add.getCount());
					}
				}
			}
		}
		if (mutiGiftMap.isEmpty()) {
			for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : mutiGiftMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					for (PrsAdditionalPackVO add : entry.getValue()) {
						giftMap.put(add.getBindSpvIds().get(0), add.getCount());
					}
				}
			}
		}
		return giftMap;
	}

	// /**
	// * 把每个赠品绑到主品上 多品赠品随便绑一个，默认绑到第一个上
	// *
	// * @param steps
	// * @return
	// */
	// public Map<Long, List<PrsAdditionalPackVO>>
	// blindGiftFromProduct(List<PrsPriceStepVO> steps,
	// Map<String, String> campaignCodeMap) {
	// Map<Long, List<PrsAdditionalPackVO>> giftMap = new HashMap<Long,
	// List<PrsAdditionalPackVO>>();
	// if (CollectionUtils.isNotEmpty(steps)) {
	// for (PrsPriceStepVO step : steps) {
	// if (CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
	// if (step.getCampaign().getDiscountTypeId().equals(DiscountType.GIFT.id))
	// {
	// for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
	// List<PrsAdditionalPackVO> ads = new ArrayList<PrsAdditionalPackVO>();
	// if (giftMap.containsKey(add.getBindSpvIds().get(0))) {
	// ads.addAll(giftMap.get(add.getBindSpvIds().get(0)));
	// }
	// ads.add(add);
	// giftMap.put(add.getBindSpvIds().get(0), ads);
	// campaignCodeMap.put(add.getProductId().toString(),
	// step.getCampaign().getCode());
	// }
	// }
	// }
	// }
	// }
	// return giftMap;
	// }

	/**
	 * 取所有的赠品pack
	 * 
	 * @param packs
	 * @return
	 */
	public List<CartProductPack> getGifts(List<CartProductPack> packs) {
		List<CartProductPack> giftPacks = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {
				if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
					giftPacks.add(pack);
				}
				
				if(CollectionUtils.isNotEmpty(pack.getGiftPacks())){
					for (CartProductPack giftPack : pack.getGiftPacks()) {
						giftPacks.add(giftPack);
					}
					
					
				}
			}
		}
		return giftPacks;
	}

	public Map<Long, String> getAdds(List<PrsPriceStepVO> steps, List<CartProductPack> packs) {
		Map<Long, String> addCamps = new HashMap<Long, String>();
		List<CartProductPack> addPacks = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {
				if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
					addPacks.add(pack);
				}
			}
		}
		Map<PrsAdditionalPackVO, String> addMap = new HashMap<PrsAdditionalPackVO, String>();

		if (CollectionUtils.isNotEmpty(addPacks)) {
			if (CollectionUtils.isNotEmpty(steps)) {
				for (PrsPriceStepVO step : steps) {
					if (CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {
						for (PrsAdditionalPackVO add : step.getAdditionalPackList()) {
							if (step.getCampaign().getDiscountTypeId().equals(DiscountType.CHEAPEN_OTHER.id)) {
								addMap.put(add, step.getCampaign().getCode());
							}
						}
					}
				}
			}

			for (CartProductPack addPack : addPacks) {
				for (Map.Entry<PrsAdditionalPackVO, String> entry : addMap.entrySet()) {
					if (entry.getKey().getProductId().toString().equals(addPack.getProduct().getId())) {
						addCamps.put(addPack.getSpvId(), entry.getValue());
						break;
					}

				}
			}

		}
		return addCamps;
	}

	/**
	 * 取所有的赠品pack
	 * 
	 * @param spvSteps
	 * @param steps
	 * @return
	 */
	public Map<Long, List<PrsCampaignVO>> getSpvCampaign(List<PrsSpvPriceStepVO> spvSteps, List<PrsPriceStepVO> steps) {
		Map<Long, List<PrsCampaignVO>> campaignMap = new HashMap<Long, List<PrsCampaignVO>>();
		Map<Long, PrsCampaignVO> campaignList = new HashMap<Long, PrsCampaignVO>();
		if (CollectionUtils.isNotEmpty(steps)) {

			for (PrsPriceStepVO step : steps) {
				if (null != step.getCampaign()) {
					campaignList.put(step.getCampaign().getId(), step.getCampaign());
				}
			}
		}
		if (CollectionUtils.isNotEmpty(spvSteps)) {
			for (PrsSpvPriceStepVO spvStep : spvSteps) {
				List<PrsCampaignVO> camps = new ArrayList<PrsCampaignVO>();
				if (spvStep.getPriceType().equals(PrsPriceTypeEnum.CAMPAIGN)) {
					if (campaignMap.containsKey(spvStep.getSpvId())) {
						camps.addAll(campaignMap.get(spvStep.getSpvId()));
					}
					camps.add(campaignList.get(spvStep.getExtId()));
					campaignMap.put(spvStep.getSpvId(), camps);
				}
			}
		}
		return campaignMap;
	}

	public Map<String, SSkuStockVO> forSpvLeft(Map<String, PsProductVO> psProductVOMap, OpChannelVO opChannel) {

		Map<String, SSkuStockVO> skuStockVOMap = new HashMap<String, SSkuStockVO>();
		if (null != psProductVOMap && psProductVOMap.size() > 0) {
			logger.info("重新取库存 ");

			// 找出所有skucode

			List<String> skuCodes = new ArrayList<String>();
			if (null != psProductVOMap && psProductVOMap.size() > 0) {
				for (Map.Entry<String, PsProductVO> productEntry : psProductVOMap.entrySet()) {
					if (null != productEntry.getValue()) {
						List<PsSpvVO> spvs = productEntry.getValue().getSpvList();
						for (PsSpvVO spv : spvs) {
							if (null != spv.getSkuCode()) {
								skuCodes.add(spv.getSkuCode());
							} else {
								if (null != spv.getSkuCombinationList()) {
									List<PsSkuCombinationVO> combs = spv.getSkuCombinationList();
									for (PsSkuCombinationVO comb : combs) {
										if (null != comb.getSubSkuCode()) {
											skuCodes.add(comb.getSubSkuCode());
										}
									}
								}
							}
						}
					}
				}
			}
			// 从库存服务取库存map
			skuStockVOMap = sStockService.getSkuStocks(skuCodes, opChannel.getWarehouseForSales());

		}
		return skuStockVOMap;
	}

	// 商品价格计算查询组装
	public PrsCalcProductDTO assemblePriceProduct(PsProductVO prod, List<PsSkuVO> skus, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {

		PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
		PrsMemberVO arg1 = new PrsMemberVO();

		if(member != null){
			arg1.setBirthday(member.getBirthday());
			arg1.setCode(member.getCode());
			arg1.setId(member.getId());
			arg1.setMemberLevel(member.getMemberLevel());
			arg1.setNickName(member.getNickName());
			arg0.setMemberVO(arg1);
		}

		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());
		
		List<PrsProductVO> products = new ArrayList<PrsProductVO>();
		PrsProductVO product = assembleProduct(prod, skus, member);

		if (null != product) {
			products.add(product);
			arg0.setProductVOList(products);
		} else {
			arg0 = null;
		}
		return arg0;

	}

	private PrsProductVO assembleProduct(PsProductVO prod, List<PsSkuVO> skus, MemberVO member) {
		PrsProductVO product = new PrsProductVO();
		product.setAllowVipDiscount(false);
		if (null != prod.getAllowVipDiscount() && prod.getAllowVipDiscount() == 1) {
			product.setAllowVipDiscount(true);
		}

		product.setUseBirthdayDiscount(false);
		if (member != null && member.isInBdayDiscountTime()) {
			if (null != prod.getAllowBdDiscount() && prod.getAllowBdDiscount() == 1) {
				product.setUseBirthdayDiscount(true);

			}
		}
		product.setCategoryId(prod.getCategoryId());
		product.setCrossBorderFlag(prod.getCrossBorderFlag());
		product.setHasSpecialDiscount(null != prod.getIsDiscount() && prod.getIsDiscount() == 1 ? true : false);
		product.setIsCustomize(false);
		if (null != skus && skus.size() > 0) {
			for (PsSkuVO sku : skus) {
				if (null != sku.getCanCustomize() && sku.getCanCustomize() == 1) {
					product.setIsCustomize(true);
					break;
				}
			}
		}
		product.setProductCode(prod.getCategoryCode());
		product.setProductId(Long.parseLong(prod.getId()));
		product.setProductName(prod.getNameCn());
		List<PrsSpvVO> spvs = new ArrayList<PrsSpvVO>();

		List<PsSpvVO> psSpvs = prod.getSpvList();
		if (CollectionUtils.isNotEmpty(psSpvs)) {
			for (PsSpvVO psSpv : psSpvs) {
				PrsSpvVO spv = new PrsSpvVO();
				List<PsCampaignVO> psAdvanceCampaignList = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(psSpv.getAdvanceCampaignList())) {
					psAdvanceCampaignList.addAll(psSpv.getAdvanceCampaignList());
				}
				if (null != prod.getPsAdvanceCampaignVO()
						&& CollectionUtils.isNotEmpty(prod.getPsAdvanceCampaignVO().getAdvanceCampaignList())) {
					psAdvanceCampaignList.addAll(prod.getPsAdvanceCampaignVO().getAdvanceCampaignList());
				}
				List<PrsCampaignVO> advanceCampaignList = new ArrayList<PrsCampaignVO>();
				if (CollectionUtils.isNotEmpty(psAdvanceCampaignList)) {
					for (PsCampaignVO psAdvanceCampaign : psAdvanceCampaignList) {
						PrsCampaignVO advanceCampaign = new PrsCampaignVO();
						advanceCampaign.setAccessWayIds(psAdvanceCampaign.getAccessWayIds());
						advanceCampaign.setAdvance(psAdvanceCampaign.getAdvance());
						advanceCampaign.setApprovalState(psAdvanceCampaign.getApprovalState());

						List<PsCampaignSectionVO> psCampaignSectionList = psAdvanceCampaign.getCampaignSectionList();
						List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

						if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
							for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
								PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
								campaignSection.setCampaignId(psCampaignSection.getCampaignId());
								campaignSection.setFactor(psCampaignSection.getFactor());
								campaignSection.setFactorType(psCampaignSection.getFactorType());
								campaignSection.setId(psCampaignSection.getId());
								campaignSection.setLine(psCampaignSection.getLine());
								List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
										.getCampaignSectionProducts();
								List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
								if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

									for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
										PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
										campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
										campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
										campaignSectionProduct
												.setCampaignSectionId(campaignSectionProduct.getCampaignSectionId());
										campaignSectionProduct.setId(campaignSectionProduct.getId());
										campaignSectionProduct.setLimitCount(campaignSectionProduct.getLimitCount());
										campaignSectionProduct.setCount(campaignSectionProduct.getCount());
										campaignSectionProduct.setPrice(campaignSectionProduct.getPrice());
										campaignSectionProduct.setProductId(campaignSectionProduct.getProductId());
										campaignSectionProductList.add(campaignSectionProduct);
									}
								}
								campaignSection.setSectionProductVOList(campaignSectionProductList);
								campaignSection.setType(psCampaignSection.getConditionType());

								campaignSectionList.add(campaignSection);
							}
						}

						advanceCampaign.setCampaignSectionList(campaignSectionList);
						advanceCampaign.setCode(psAdvanceCampaign.getCode());
						advanceCampaign.setCrossBorderFlag(psAdvanceCampaign.getCrossBorderFlag());
						advanceCampaign.setCumulative(psAdvanceCampaign.getCumulative());
						advanceCampaign.setDiscountTypeId(psAdvanceCampaign.getDiscountTypeId());
						advanceCampaign.setExpireTime(psAdvanceCampaign.getExpireTime());
						advanceCampaign.setId(psAdvanceCampaign.getId());
						advanceCampaign.setLadderRule(psAdvanceCampaign.getLadderRule());
						advanceCampaign.setLevel(psAdvanceCampaign.getLevel());
						advanceCampaign.setMemberLevels(psAdvanceCampaign.getMemberLevels());
						advanceCampaign.setName(psAdvanceCampaign.getName());
						advanceCampaign.setProductScopeId(psAdvanceCampaign.getProductScopeId());
						advanceCampaign.setOptionFlag(psAdvanceCampaign.getOptionFlag());
						advanceCampaign.setStartTime(psAdvanceCampaign.getStartTime());
						advanceCampaign.setState(psAdvanceCampaign.getState());
						advanceCampaign.setTitle(psAdvanceCampaign.getTitle());
                        if (MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(psAdvanceCampaign.getMemberType())) {
                            advanceCampaign.setMemberType(PrsMemberTypeEnum.FISH_MAN);
                        } else {
                            advanceCampaign.setMemberType(PrsMemberTypeEnum.ALL);
                        }
						advanceCampaignList.add(advanceCampaign);
					}
				}
				spv.setAdvanceCampaignList(advanceCampaignList);

				List<PsCampaignVO> psCampaignList = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(psSpv.getCampaignList())) {
					psCampaignList.addAll(psSpv.getCampaignList());
				}
				if (CollectionUtils.isNotEmpty(prod.getCampaignList())) {
					psCampaignList.addAll(prod.getCampaignList());
				}
				List<PrsCampaignVO> campaignList = new ArrayList<PrsCampaignVO>();
				if (CollectionUtils.isNotEmpty(psCampaignList)) {
					for (PsCampaignVO psCampaign : psCampaignList) {
						PrsCampaignVO campaign = new PrsCampaignVO();
						campaign.setAccessWayIds(psCampaign.getAccessWayIds());
						campaign.setAdvance(psCampaign.getAdvance());
						campaign.setApprovalState(psCampaign.getApprovalState());

						List<PsCampaignSectionVO> psCampaignSectionList = psCampaign.getCampaignSectionList();
						List<PrsCampaignSectionVO> campaignSectionList = new ArrayList<PrsCampaignSectionVO>();

						if (CollectionUtils.isNotEmpty(psCampaignSectionList)) {
							for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
								PrsCampaignSectionVO campaignSection = new PrsCampaignSectionVO();
								campaignSection.setCampaignId(psCampaignSection.getCampaignId());
								campaignSection.setFactor(psCampaignSection.getFactor());
								campaignSection.setFactorType(psCampaignSection.getFactorType());
								campaignSection.setId(psCampaignSection.getId());
								campaignSection.setLine(psCampaignSection.getLine());
								List<PsCampaignSectionProductVO> psCampaignSectionProductList = psCampaignSection
										.getCampaignSectionProducts();
								List<PrsCampaignSectionProductVO> campaignSectionProductList = new ArrayList<PrsCampaignSectionProductVO>();
								if (CollectionUtils.isNotEmpty(psCampaignSectionProductList)) {

									for (PsCampaignSectionProductVO psCampaignSectionProduct : psCampaignSectionProductList) {
										PrsCampaignSectionProductVO campaignSectionProduct = new PrsCampaignSectionProductVO();
										campaignSectionProduct.setSort(psCampaignSectionProduct.getSort());
										campaignSectionProduct.setCampaignId(psCampaignSectionProduct.getCampaignId());
										campaignSectionProduct
												.setCampaignSectionId(psCampaignSectionProduct.getCampaignSectionId());
										campaignSectionProduct.setId(psCampaignSectionProduct.getId());
										campaignSectionProduct.setLimitCount(psCampaignSectionProduct.getLimitCount());
										campaignSectionProduct.setCount(psCampaignSectionProduct.getPriceCount());
										campaignSectionProduct.setPrice(psCampaignSectionProduct.getPricePrice());
										campaignSectionProduct.setProductId(psCampaignSectionProduct.getProductId());
										campaignSectionProductList.add(campaignSectionProduct);
									}
								}
								campaignSection.setSectionProductVOList(campaignSectionProductList);
								campaignSection.setType(psCampaignSection.getConditionType());

								campaignSectionList.add(campaignSection);
							}
						}
						campaign.setCampaignSectionList(campaignSectionList);
						campaign.setCode(psCampaign.getCode());
						campaign.setCrossBorderFlag(psCampaign.getCrossBorderFlag());
						campaign.setCumulative(psCampaign.getCumulative());
						campaign.setDiscountTypeId(psCampaign.getDiscountTypeId());
						campaign.setExpireTime(psCampaign.getExpireTime());
						campaign.setId(psCampaign.getId());
						campaign.setLadderRule(psCampaign.getLadderRule());
						campaign.setLevel(psCampaign.getLevel());
						campaign.setMemberLevels(psCampaign.getMemberLevels());
						campaign.setName(psCampaign.getName());
						campaign.setOptionFlag(psCampaign.getOptionFlag());
						campaign.setProductScopeId(psCampaign.getProductScopeId());
						campaign.setStartTime(psCampaign.getStartTime());
						campaign.setState(psCampaign.getState());
						campaign.setTitle(psCampaign.getTitle());
                        if (MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(psCampaign.getMemberType())) {
                            campaign.setMemberType(PrsMemberTypeEnum.FISH_MAN);
                        } else {
                            campaign.setMemberType(PrsMemberTypeEnum.ALL);
                        }
						campaignList.add(campaign);
					}
				}
				spv.setCampaignList(campaignList);
				spv.setMinAmount(psSpv.getMinAmount());
				spv.setProductCode(prod.getCode());
				spv.setProductId(Long.parseLong(prod.getId()));
				spv.setProductName(prod.getNameCn());
				spv.setSalesPrice(psSpv.getSalesPrice());
				spv.setOriginalPrice(psSpv.getOriginalPrice());
				spv.setCombination(psSpv.getCombined());
				spv.setSpvId(psSpv.getSpvId());
				List<PrsSkuVO> skuVOList = new ArrayList<PrsSkuVO>();
				if (null != skus) {
					for (PsSkuVO psSku : skus) {
						PrsSkuVO sku = new PrsSkuVO(spv.getSpvId(), psSku.getSkuCode(), psSku.getSkuNameCN(),
								BigDecimal.valueOf(psSku.getSalesPrice()), 1);
						skuVOList.add(sku);
					}

				}
				spv.setSkuVOList(skuVOList);

				spvs.add(spv);
			}
		} else {
			return null;
		}

		product.setSpvVOList(spvs);

		product.setUseBirthdayDiscount(false);
		if (member!=null && member.isInBdayDiscountTime()) {
			if (null != prod.getAllowBdDiscount() && prod.getAllowBdDiscount() == 1) {
				product.setUseBirthdayDiscount(true);

			}
		}
		return product;
	}

	// 商品价格计算查询组装
	public void assemblePriceProducts(PrsCalcProductDTO arg0, List<PsProductVO> prods,
			Map<String, List<PsSkuVO>> skuMap, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		PrsMemberVO arg1 = new PrsMemberVO();


		if(member != null){
			arg1.setBirthday(member.getBirthday());
			arg1.setCode(member.getCode());
			arg1.setId(member.getId());
			arg1.setMemberLevel(member.getMemberLevel());
			arg1.setNickName(member.getNickName());
			arg1.setFishMan(memberAdapter.isNewMember(member.getId()));
			arg0.setMemberVO(arg1);
		}


		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());

		List<PrsProductVO> products = new ArrayList<PrsProductVO>();

		for (PsProductVO prod : prods) {

			PrsProductVO product = assembleProduct(prod, skuMap.get(prod.getId()), member);
			if (null != product) {
				products.add(product);
			}

		}

		arg0.setProductVOList(products);
		// 列表不需要试试获取限购数，因此这里member设置为null
		arg0.setCampaignLimitList(getPrsCampLimit4Prods(prods,null));

	}

	public Map<Long, SpvPriceVO> getProductsPricesForWWW(List<PsProductVO> products, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {

		Map<Long, SpvPriceVO> priceMap = new HashMap<Long, SpvPriceVO>();
		PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
		PrsMemberVO arg1 = new PrsMemberVO();
		arg1.setBirthday(member.getBirthday());
		arg1.setCode(member.getCode());
		arg1.setId(member.getId());
		arg1.setMemberLevel(member.getMemberLevel());
		arg1.setNickName(member.getNickName());
		arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
		arg0.setChannelCode(opChannel.getCode());
		arg0.setMemberVO(arg1);
		List<PrsProductVO> prods = new ArrayList<PrsProductVO>();
		Map<String, List<PsSkuVO>> mapProductId = productAdapter.GetSkusByProduct(products);

		for (PsProductVO product : products) {
			PrsProductVO prod = assembleProduct(product, mapProductId.get(product.getId()), member);
			if (null != prod) {
				prods.add(prod);
			}
		}

		arg0.setProductVOList(prods);
		logger.info("商详页调用价格计算");
		Map<Long, PrsProductPriceResultVO> priceVos = prsPriceService.calculatePrs4ProductList(arg0);
		for (PsProductVO product : products) {
			PrsProductPriceResultVO price = priceVos.get(Long.parseLong(product.getId()));
			for (PrsSpvPriceResultVO spvre : price.getSpvPriceResultVOs()) {
				SpvPriceVO spvPrice = new SpvPriceVO();
				spvPrice.setAdvancePrice(spvre.getAdvancePrice());
				spvPrice.setDiscountPrice(spvre.getDiscountPrice());
				ForbidMemberVipDiscountReasonEnum reasonEnum = spvre.getForbidMemberVipDiscountReason();
				spvPrice.setForBidVipDisReaSon(forBidVipDisReason(member, product, reasonEnum));
				priceMap.put(spvre.getSpvId(), spvPrice);
			}
		}

		return priceMap;

	}

	/**
	 * 会员折扣不可用原因
	 * @param reasonEnum
	 * @return
	 */
	private String forBidVipDisReason(MemberVO member, PsProductVO product, ForbidMemberVipDiscountReasonEnum reasonEnum) {
		if (member == null || product == null || reasonEnum == null) {
			return "";
		}
		// 由于商品因素 不支持会员折扣
		if (member.isInBdayDiscountTime() && !Integer.valueOf(1).equals(product.getAllowBdDiscount())) {
			return "该商品不可叠加会员折扣";
		}
		if (member.getMemberLevel() > MemberLevelEnum.VIP.getCode() && !Integer.valueOf(1).equals(product.getAllowVipDiscount())) {
			return "该商品不可叠加会员折扣";
		}
		// 由于价格因素 不支持会员折扣
		if (ForbidMemberVipDiscountReasonEnum.LOW_PRICE_FORBID_MEMBER_DISCOUNT.equals(reasonEnum)
				|| ForbidMemberVipDiscountReasonEnum.LOW_PRICE_FORBID_MEMBER_BIRTHDAY_DISCOUNT.equals(reasonEnum)) {
			return "该商品不可叠加会员折扣";
		}
		return "";
	}

	// public Map<Long, SpvPriceVO> getProductsPriceForWWW(PsProductVO product,
	// MemberVO member, OpChannelVO opChannel,
	// AccessWayEnum accessWay) {
	//
	// Map<Long, SpvPriceVO> priceMap = new HashMap<Long, SpvPriceVO>();
	// PrsCalcProductDTO arg0 = new PrsCalcProductDTO();
	// PrsMemberVO arg1 = new PrsMemberVO();
	// arg1.setBirthday(member.getBirthday());
	// arg1.setCode(member.getCode());
	// arg1.setId(member.getId());
	// arg1.setMemberLevel(member.getMemberLevel());
	// arg1.setNickName(member.getNickName());
	// arg0.setMemberVO(arg1);
	// arg0.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
	// arg0.setChannelCode(opChannel.getCode());
	//
	// List<PrsProductVO> prods = new ArrayList<PrsProductVO>();
	//
	// List<String> codes = product.getSkuCodes();
	// List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(codes);
	//
	// PrsProductVO prod = assembleProduct(product, skus, member);
	// prods.add(prod);
	// arg0.setProductVOList(prods);
	// logger.info("商详页调用价格计算");
	// PrsProductPriceResultVO price =
	// prsPriceService.calculatePrs4ProductDetail(arg0);
	// for (PrsSpvPriceResultVO spvre : price.getSpvPriceResultVOs()) {
	// SpvPriceVO spvPrice = new SpvPriceVO();
	// spvPrice.setAdvancePrice(spvre.getAdvancePrice());
	// spvPrice.setDiscountPrice(spvre.getDiscountPrice());
	// priceMap.put(spvre.getSpvId(), spvPrice);
	// }
	// return priceMap;
	//
	// }

	/**
	 * 
	 * 从价格步骤里取出所有赠品productlist和以活动为key的赠品map
	 * 
	 * @param steps
	 * @param campaignMap
	 * @param productIds
	 */

	public void getAllGiftsStockAndCampaignMap(List<PrsPriceStepVO> steps,
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap, List<String> productIds,
			Map<String, String> campaignCodeMap) {
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PrsPriceStepVO step : steps) {
				if (CollectionUtils.isNotEmpty(step.getAdditionalPackList())) {

					for (PrsAdditionalPackVO addpack : step.getAdditionalPackList()) {
						productIds.add(addpack.getProductId().toString());
						campaignCodeMap.put(addpack.getProductId().toString(), step.getCampaign().getCode());
					}
					List<PrsAdditionalPackVO> campAddList = new ArrayList<PrsAdditionalPackVO>();
					if (campaignMap.containsKey(step.getCampaign())) {
						campAddList.addAll(campaignMap.get(step.getCampaign()));
					}
					campAddList.addAll(step.getAdditionalPackList());
					campaignMap.put(step.getCampaign(), campAddList);
				}

			}

		}
	}

	/**
	 * 将campaignmap中依次赠多余赠品拆出
	 * 
	 * @param campaignMap
	 * @param stockMap
	 * @param checkCspLimitMap
	 * @param resultMap
	 */
	public void isOptinonGift(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap,
			Map<String, SSkuStockVO> stockMap, Map<String, Integer> checkCspLimitMap,
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap, Map<String, PsProductVO> psProductVOMap) {

		for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : campaignMap.entrySet()) {
			PrsCampaignVO campaignVO = entry.getKey();
			List<PrsAdditionalPackVO> packs = entry.getValue();

			if (CollectionUtils.isNotEmpty(packs) && packs.size() > 0) {
				if (campaignVO.getOptionFlag() == 1) {// 0全部送，1只送一个
					Map<Long, List<PrsAdditionalPackVO>> sectionMap = new HashMap<Long, List<PrsAdditionalPackVO>>();

					for (PrsAdditionalPackVO pack : packs) {
						List<PrsAdditionalPackVO> groupList = new ArrayList<PrsAdditionalPackVO>();
						if (sectionMap.containsKey(pack.getGroupId())) {
							groupList = sectionMap.get(pack.getGroupId());
						}
						groupList.add(pack);
						sectionMap.put(pack.getGroupId(), groupList);
					}

					for (Map.Entry<Long, List<PrsAdditionalPackVO>> sectionEntry : sectionMap.entrySet()) {

						List<PrsAdditionalPackVO> selectList = new ArrayList<PrsAdditionalPackVO>();

						if (resultMap.containsKey(campaignVO)) {
							selectList = resultMap.get(campaignVO);
						}
						List<PrsAdditionalPackVO> packList = sectionEntry.getValue();
						// 排序 根据sort
						Collections.sort(packList, new Comparator<PrsAdditionalPackVO>() {
							@Override
							public int compare(PrsAdditionalPackVO o1, PrsAdditionalPackVO o2) {
								int a = o1.getSort();
								int b = o2.getSort();
								return (a - b);
							}
						});

						for (PrsAdditionalPackVO pack : packList) {
							// 查限量
							PsProductVO product = psProductVOMap.get(pack.getProductId().toString());
							if (null != product) {
								String key = campaignVO.getCode() + product.getCode();

								if (checkCspLimitMap.get(key) != null && checkCspLimitMap.get(key) < pack.getCount()) {// 限量不足
									continue;

								}
								// 限量足够，校验商品库存
								if (checkProductStock(product, stockMap, pack.getCount())) {
									selectList.add(pack);
									break;
								}
							}
						}
						if (CollectionUtils.isNotEmpty(selectList)) {
							resultMap.put(campaignVO, selectList);
						}
					}

				} else {
					resultMap.put(campaignVO, packs);
				}
			} else {
				resultMap.put(campaignVO, packs);
			}

		}

	}

	/**
	 * 将campaignmap中依次赠多余赠品拆出
	 * 
	 * @param newMap
	 * @param stockMap
	 * @param checkCspLimitMap
	 * @param resultMap
	 * @param psProductVOMap
	 */
	public void exceptLimit(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> newMap, Map<String, SSkuStockVO> stockMap,
			Map<String, Integer> checkCspLimitMap, Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap,
			Map<String, PsProductVO> psProductVOMap) {

		for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {
			PrsCampaignVO campaignVO = entry.getKey();
			List<PrsAdditionalPackVO> packs = entry.getValue();

			if (CollectionUtils.isNotEmpty(packs) && packs.size() > 0) {

				List<PrsAdditionalPackVO> newPacks = new ArrayList<PrsAdditionalPackVO>();
				for (PrsAdditionalPackVO pack : packs) {
					// 查限量
					PsProductVO product = psProductVOMap.get(pack.getProductId().toString());
					if (null != product) {
						String key = campaignVO.getCode() + product.getCode();

						if (checkCspLimitMap.get(key) != null && checkCspLimitMap.get(key) < pack.getCount()) {// 限量不足
							continue;
						}

						// 限量足够，校验商品库存
						if (checkProductStock(product, stockMap, pack.getCount())) {
							newPacks.add(pack);
						}
					}
				}
				if (CollectionUtils.isNotEmpty(newPacks)) {
					newMap.put(campaignVO, newPacks);
				}
			}

		}

	}

	/**
	 * 整理单品赠品多品赠品以及加价购
	 * 
	 * @param resultMap
	 * @param singleGiftMap
	 * @param mutiGiftMap
	 * @param addList
	 */
	public void getGiftMapAndAdditionList(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap,
			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap, Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap,
			List<PrsAdditionalPackVO> addList) {

		if (!resultMap.isEmpty()) {
			for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {

				List<PrsAdditionalPackVO> adPacks = entry.getValue();
				if (CollectionUtils.isNotEmpty(adPacks)) {
					for (PrsAdditionalPackVO adPack : adPacks) {
						if (entry.getKey().getDiscountTypeId().equals(DiscountType.GIFT.id)) {

							if (adPack.getIsSingleScopeCampaign()) {
								List<PrsAdditionalPackVO> giftSingleList = new ArrayList<PrsAdditionalPackVO>();
								if (singleGiftMap.containsKey(adPack.getBindSpvIds().get(0))) {
									giftSingleList.addAll(singleGiftMap.get(adPack.getBindSpvIds().get(0)));
								}
								giftSingleList.add(adPack);
								singleGiftMap.put(adPack.getBindSpvIds().get(0), giftSingleList);
							} else {

								List<PrsAdditionalPackVO> giftSingleList = new ArrayList<PrsAdditionalPackVO>();
								if (mutiGiftMap.containsKey(adPack.getBindSpvIds().get(0))) {
									giftSingleList.addAll(mutiGiftMap.get(adPack.getBindSpvIds().get(0)));
								}
								giftSingleList.add(adPack);
								mutiGiftMap.put(adPack.getBindSpvIds().get(0), giftSingleList);

							}

						} else {
							addList.add(adPack);
						}
					}
				}
			}
		}
	}

	/**
	 * 整理单品赠品多品赠品以及加价购
	 * 
	 * @param resultMap
	 * @param singleGiftMap
	 * @param mutiGiftMap
	 * @param addList
	 */
	public void getGiftMapAndAdditionList(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap,
			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap, Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap,
			List<PrsAdditionalPackVO> addList, OpChannelVO opChannel, Map<Long, Integer> spvCountMap) {

		//boolean boolContinue = false;
		if (!resultMap.isEmpty()) {
			Map<Long, PsSpvVO> psMap = new HashMap<>();
			// 如果是线下，需要判断赠品所属主品是不是配送仓，配送仓不送赠品
			if (opChannel.getChannelType() == 1) {

				List<Long> spvIds = new ArrayList<>();
				for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {
					List<PrsAdditionalPackVO> adPacks = entry.getValue();

					if (CollectionUtils.isNotEmpty(adPacks)) {
						for (PrsAdditionalPackVO adPack : adPacks) {
							if (entry.getKey().getDiscountTypeId().equals(DiscountType.GIFT.id)) {

								spvIds.addAll(adPack.getBindSpvIds());

							}
						}
					}
				}

				if (spvIds.size() > 0) {
					psMap.putAll(mcPsSpvService.mapBySpvIdsWithStock(spvIds, opChannel.getCode()));
				}

			}

			for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {

				List<PrsAdditionalPackVO> adPacks = entry.getValue();
				if (CollectionUtils.isNotEmpty(adPacks)) {
					for (PrsAdditionalPackVO adPack : adPacks) {
						if (entry.getKey().getDiscountTypeId().equals(DiscountType.GIFT.id)) {

//							if (opChannel.getChannelType() == 1) {
//								boolContinue = false;
//								for (Long spvId : adPack.getBindSpvIds()) {
//
//									PsSpvVO spv = psMap.get(spvId);
//									Integer count = spvCountMap.get(spvId);
//									if (count == null) {
//										count = 1;
//									}
//									if (spv.getPsStockVO().getCanUseQuantity() < count) {
//
//										if (spv.getPsPresaleSaleStockVO() == null) {
//											boolContinue = true;
//											break;
//										} else if (spv.getPsPresaleSaleStockVO() != null
//												&& spv.getPsPresaleSaleStockVO().getCanUseInv() < count) {
//											boolContinue = true;
//											break;
//										}
//
//									}
//
//								}
//
//								if (boolContinue) {
//									continue;
//								}
//
//							}

							if (adPack.getIsSingleScopeCampaign()) {
								List<PrsAdditionalPackVO> giftSingleList = new ArrayList<PrsAdditionalPackVO>();
								if (singleGiftMap.containsKey(adPack.getBindSpvIds().get(0))) {
									giftSingleList.addAll(singleGiftMap.get(adPack.getBindSpvIds().get(0)));
								}
								giftSingleList.add(adPack);
								singleGiftMap.put(adPack.getBindSpvIds().get(0), giftSingleList);
							} else {

								List<PrsAdditionalPackVO> giftSingleList = new ArrayList<PrsAdditionalPackVO>();
								if (mutiGiftMap.containsKey(adPack.getBindSpvIds().get(0))) {
									giftSingleList.addAll(mutiGiftMap.get(adPack.getBindSpvIds().get(0)));
								}
								giftSingleList.add(adPack);
								mutiGiftMap.put(adPack.getBindSpvIds().get(0), giftSingleList);

							}

						} else {
							addList.add(adPack);
						}
					}
				}
			}
		}

	}

	/**
	 * 将赠品组装成cs用的包(无视用户选择，直接计算分配)
	 * 
	 * @param giftMap
	 * @param stockMap
	 * @param checkCspLimitMap
	 * @param psProductVOMap
	 * @return
	 */
	public Map<Long, List<CartProductPack>> setupGiftPacks(Map<Long, List<PrsAdditionalPackVO>> giftMap,
			Map<String, SSkuStockVO> stockMap, Map<String, Integer> checkCspLimitMap,
			Map<String, PsProductVO> psProductVOMap, Map<String, String> campaignCodeMap) {

		Map<Long, List<CartProductPack>> maps = new HashMap<Long, List<CartProductPack>>();
		for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : giftMap.entrySet()) {

			Long mainId = entry.getKey();
			List<CartProductPack> resultPacks = new ArrayList<CartProductPack>();
			List<PrsAdditionalPackVO> packVOs = entry.getValue();
			for (PrsAdditionalPackVO packVO : packVOs) {
				// 赠品包组装

				logger.info("赠品Id productId={}", packVO.getProductId());
				PsProductVO psProduct = psProductVOMap.get(packVO.getProductId().toString());
				
				if(psProduct == null ){
					logger.error(" setupGiftPacks --> ProductId():"+packVO.getProductId().toString()+":找不到Prod");
					continue;
				}
				
				logger.info("赠品名称 name={}", psProduct.getNameCn());

				CartProductPack pack = new CartProductPack();
				pack.setSource(CartPackSourceEnum.GIFT);
				pack.setCount(packVO.getCount());
				pack.setProduct(psProduct);
				pack.setFactProductPrice(BigDecimal.ZERO);
				pack.setProductId(packVO.getProductId());

				// 检查限量
				String key = campaignCodeMap.get(psProduct.getId()) + psProduct.getCode();
				if (checkCspLimitMap.get(key) != null && checkCspLimitMap.get(key) < packVO.getCount()) {
					logger.info("库存限量不够赠送，跳过此次循环");
					continue;
				}

				// if(checkPanicPerUserLeftMap.size()>0){
				//
				// Integer userLeft =
				// checkPanicPerUserLeftMap.get(psProduct.getSkuCodes().get(0));
				//
				// if(userLeft < packVO.getCount()){
				// logger.info("单人限量已满，跳过此次循环");
				// continue;
				// }
				//
				// }

				PsSpvVO getSpv = null;
				// 找到有库存的spv
				for (PsSpvVO spvLeft : psProductVOMap.get(packVO.getProductId().toString()).getSpvList()) {
					int left = 0;

					if (spvLeft.getCombined()) {
						if (CollectionUtils.isNotEmpty(spvLeft.getSkuCombinationList())) {
							for (PsSkuCombinationVO psc : spvLeft.getSkuCombinationList()) {
								SSkuStockVO stock = stockMap.get(psc.getSubSkuCode());
								if (stock.getCanUseQuantity() > 0) {
									left = left + stock.getCanUseQuantity();
								} else {
									left = 0;
									break;
								}
							}
						}
					} else {

						// 不是组合商品先查询预售库存
						SPresaleVO sPresaleVO = sPresaleService.findAvaliableBySkuCode(spvLeft.getSkuCode(), false);
						if (null != sPresaleVO) {

							SPresaleSaleInvVO spaleInvMap = spaleInvMap = sPresaleService
									.findCanUseQttBySkuCode(spvLeft.getSkuCode(), null);
							left = left + spaleInvMap.getCanUseInv();
							logger.info("预售商品库存 spvId={}，skuCode={}，left={} ", spvLeft.getSpvId(), spvLeft.getSkuCode(),
									left);
						}
						if (left < 1) {// 预售库存没有时再查询实际库存

							SSkuStockVO stock = stockMap.get(spvLeft.getSkuCode());
							left = left + stock.getCanUseQuantity();
							logger.info("不是预售商品或没有预售库存,查询实际库存 spvId={}，skuCode={}，left={} ", spvLeft.getSpvId(),
									spvLeft.getSkuCode(), left);
						}

					}

					if (left < packVO.getCount()) {
						left = 0;
						logger.info("此商品库存小于所需数量，放弃");
					}

					if (left > 0) {
						getSpv = spvLeft;
					}
					if (null != getSpv) {
						logger.info("找到一个有赠品的spv 此时，product={},spv={}", packVO.getProductId(), getSpv.getSpvId());
						if (null != getSpv.getSkuCode() && !getSpv.getSkuCode().isEmpty()) {
							PsSkuVO skuVO = mcPsSkuService.findBySkuCode(getSpv.getSkuCode());
							getSpv.setSkuVO(skuVO);
						} else {
							List<PsSkuCombinationVO> skus = getSpv.getSkuCombinationList();
							List<String> codes = new ArrayList<String>();
							for (PsSkuCombinationVO sku : skus) {
								codes.add(sku.getSubSkuCode());
							}
							List<PsSkuVO> skuVOs = mcPsSkuService.findBySkuCodes(codes);
							List<PsSkuCombinationVO> skuCombinationList = new ArrayList<PsSkuCombinationVO>();

							for (PsSkuVO skuVO : skuVOs) {
								PsSkuCombinationVO vo = new PsSkuCombinationVO();
								vo.setSubSkuCode(skuVO.getSkuCode());
								vo.setSubSkuVO(skuVO);
								skuCombinationList.add(vo);
							}
							getSpv.setSkuCombinationList(skuCombinationList);
						}
						pack.setSpv(getSpv);
						pack.setSpvId(getSpv.getSpvId());
						resultPacks.add(pack);
						break;
					}
				}

			}

			maps.put(mainId, resultPacks);

		}

		return maps;

	}

	public Boolean isOptionalGift(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap,
			List<CartProductPack> clientAddPacks) {
		Boolean giftState = true;
		Map<String, Map<String, Integer>> giftCountMap = new HashMap<String, Map<String, Integer>>();

		// 先找出用户选择
		if (CollectionUtils.isNotEmpty(clientAddPacks)) {
			for (CartProductPack clientAddPack : clientAddPacks) {
				if (clientAddPack.getSource().equals(CartPackSourceEnum.GIFT)) { // 赠品
					Map<String, Integer> map = new HashMap<String, Integer>();
					if (giftCountMap.containsKey(clientAddPack.getProductId().toString())) {
						map = giftCountMap.get(clientAddPack.getProductId().toString());
					}
					int count = 0;
					if (map.containsKey("clinet")) {
						count = map.get("clinet");
					}
					count = count + clientAddPack.getCount();
					map.put("clinet", count);
					giftCountMap.put(clientAddPack.getProductId().toString(), map);
				}
			}
		}

		// 找出价格计算的赠品换购数
		if (!resultMap.isEmpty()) {
			for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					if (entry.getKey().getDiscountTypeId().equals(DiscountType.GIFT.id)) { // 赠品
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							Map<String, Integer> map = new HashMap<String, Integer>();
							if (giftCountMap.containsKey(pack.getProductId().toString())) {
								map = giftCountMap.get(pack.getProductId().toString());
							}
							int count = 0;
							if (map.containsKey("price")) {
								count = map.get("price");
							}
							count = count + pack.getCount();
							map.put("price", count);
							giftCountMap.put(pack.getProductId().toString(), map);
						}
					}
				}
			}
		}

		// 两边赠品比对
		if (!giftCountMap.isEmpty())

		{
			for (Map.Entry<String, Map<String, Integer>> entry : giftCountMap.entrySet()) {
				if (!entry.getValue().isEmpty()) {
					Map<String, Integer> map = entry.getValue();
					int clinetCount = 0;
					int priceCount = 0;
					if (map.containsKey("clinet")) {
						clinetCount = map.get("clinet");
					}
					if (map.containsKey("price")) {
						priceCount = map.get("price");
					}
					if (priceCount != clinetCount) {
						giftState = false;
						break;// 只要有一个数量不对，直接退出不再计算
					}
				}
			}
		}
		return giftState;
	}

	/**
	 * 比对用户选择赠品和价格计算赠品数量
	 *
	 * @param resultMap
	 * @param clientAddPacks
	 * @return
	 */
	public Boolean isOptionalAdd(Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap,
			List<CartProductPack> clientAddPacks) {
		Map<String, Map<String, Integer>> addCountMap = new HashMap<String, Map<String, Integer>>();
		Boolean addState = true;
		// 先找出用户选择
		if (CollectionUtils.isNotEmpty(clientAddPacks)) {
			for (CartProductPack clientAddPack : clientAddPacks) {
				if (clientAddPack.getSource().equals(CartPackSourceEnum.ADDIBLE)) { // 换购
					Map<String, Integer> map = new HashMap<String, Integer>();
					if (addCountMap.containsKey(clientAddPack.getProductId().toString())) {
						map = addCountMap.get(clientAddPack.getProductId().toString());
					}
					int count = 0;
					if (map.containsKey("clinet")) {
						count = map.get("clinet");
					}
					count = count + clientAddPack.getCount();
					map.put("clinet", count);
					addCountMap.put(clientAddPack.getProductId().toString(), map);
				}
			}
		}

		// 找出价格计算的赠品换购数
		if (!resultMap.isEmpty()) {
			for (Map.Entry<PrsCampaignVO, List<PrsAdditionalPackVO>> entry : resultMap.entrySet()) {
				if (CollectionUtils.isNotEmpty(entry.getValue())) {
					if (entry.getKey().getDiscountTypeId().equals(DiscountType.CHEAPEN_OTHER.id)) {// 换购
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							if (pack.getChoiceFlag()) {// 仅看用户选择
								Map<String, Integer> map = new HashMap<String, Integer>();
								if (addCountMap.containsKey(pack.getProductId().toString())) {
									map = addCountMap.get(pack.getProductId().toString());
								}
								int count = 0;
								if (map.containsKey("price")) {
									count = map.get("price");
								}
								count = count + pack.getCount();
								map.put("price", count);
								addCountMap.put(pack.getProductId().toString(), map);
							}
						}
					}
				}
			}
		}

		// 换购比对
		if (!addCountMap.isEmpty()) {
			for (Map.Entry<String, Map<String, Integer>> entry : addCountMap.entrySet()) {
				if (!entry.getValue().isEmpty()) {
					Map<String, Integer> map = entry.getValue();
					int clinetCount = 0;
					int priceCount = 0;
					if (map.containsKey("clinet")) {
						clinetCount = map.get("clinet");
					}
					if (map.containsKey("price")) {
						priceCount = map.get("price");
					}
					if (priceCount != clinetCount) {
						addState = false;
						break;// 只要有一个数量不对，直接退出不再计算
					}
				}
			}
		}
		return addState;
	}

	// =========================================私有方法=======================================================//

	/**
	 * 订单组装单品赠品包
	 * 
	 * @param pack
	 * @param spv
	 * @return
	 */
	private CartProductPackVO assambleGiftPack(CartProductPack pack, SpvVO spv) {
		CartProductPackVO packVo = new CartProductPackVO();
		packVo.setId(pack.getId());
		packVo.setCount(pack.getCount());
		packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
		packVo.setProductId(pack.getProduct().getCode());
		packVo.setSpv(spv);
		return packVo;
	}

	private Boolean checkProductStock(PsProductVO product, Map<String, SSkuStockVO> stockMap, int count) {

		logger.info("检查商品productId={}的库存是否够数量count={}", product.getId(), count);

		Boolean state = false;

		List<PsSpvVO> spvList = product.getSpvList();
		if (CollectionUtils.isNotEmpty(spvList)) {
			for (PsSpvVO spv : spvList) {
				logger.info("spvId = {} ", spv.getSpvId());
				if (spv.getCombined()) {
					if (CollectionUtils.isNotEmpty(spv.getSkuCombinationList())) {
						for (PsSkuCombinationVO psc : spv.getSkuCombinationList()) {
							SSkuStockVO stock = stockMap.get(psc.getSubSkuCode());
							if (stock.getCanUseQuantity() > 0) {
								logger.info("当前spv是组合商品，sku={}的库存为 stock={}", psc.getSubSkuCode(),
										stock.getCanUseQuantity());
								if (stock.getCanUseQuantity() >= count) {
									state = true;
									break;
								}
							}
						}
					}
				} else {
					int spvStock = 0;// 预售库存
					// 不是组合商品先查询预售库存
					logger.info("不是组合商品先查预售库存");
					SPresaleVO sPresaleVO = sPresaleService.findAvaliableBySkuCode(spv.getSkuCode(), false);
					if (null != sPresaleVO) {

						SPresaleSaleInvVO spaleInvMap = spaleInvMap = sPresaleService
								.findCanUseQttBySkuCode(spv.getSkuCode(), null);
						spvStock = spaleInvMap.getCanUseInv();
						logger.info("预售库存为 left={} ", spvStock);
						if (spvStock >= count) {
							state = true;
							break;
						}
					}
					if (spvStock < 1) {// 预售库存没有时再查询实际库存

						SSkuStockVO stock = stockMap.get(spv.getSkuCode());
						logger.info("不是预售商品或没有预售库存,查询实际库存 left={} ", stock.getCanUseQuantity());
						if (stock.getCanUseQuantity() >= count) {
							state = true;
							break;
						}
					}

				}
			}
		}
		logger.info("productId={} 的商品库存校验结果 state={}", product.getId(), state);

		return state;
	}

	/**
	 * ipos赠品可售库存数
	 * 
	 * @Methods Name forIposAddSpvCanSaleNum
	 * @param psSpvVO
	 * @param stockMap
	 * @return int
	 */
	private int forIposAddSpvCanSaleNum(PsSpvVO psSpvVO, Map<String, SSkuStockVO> stockMap) {
		// 组合
		if (psSpvVO.getCombined()) {
			List<PsSkuCombinationVO> pscList = psSpvVO.getSkuCombinationList();
			if (CollectionUtils.isEmpty(pscList)) {
				return 0;
			}
			Integer spvStock = 999;
			for (PsSkuCombinationVO psc : pscList) {
				SSkuStockVO stock = stockMap.get(psc.getSubSkuCode());
				if (stock == null || stock.getCanUseQuantity() < 1) {
					return 0;
				}
				int canSales = stock.getCanUseQuantity() / psc.getQuantity();
				if (canSales < spvStock) {
					spvStock = canSales;
				}
			}
			return spvStock;
		}
		// 非组合
		SSkuStockVO stockVO = stockMap.get(psSpvVO.getSkuCode());
		if (stockVO == null || stockVO.getCanUseQuantity() == null || stockVO.getCanUseQuantity() < 1) {
			return 0;
		}
		return stockVO.getCanUseQuantity();
	}

}
