package com.thebeastshop.pegasus.channelservice.adapter.price;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.enums.MemberTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.price.enums.PrsMemberTypeEnum;
import com.thebeastshop.price.vo.PrsCampaignSectionProductVO;
import com.thebeastshop.price.vo.PrsCampaignSectionVO;
import com.thebeastshop.price.vo.PrsCampaignVO;

@Component
public class IposCampaignAdapter {
	
	/**
	  * 价格计算活动信息
	 * @param psCampaignList
	 * @return
	 */
	public List<PrsCampaignVO> priceCampList(List<PsCampaignVO> psCampaignList) {
		List<PrsCampaignVO> prsCampaignList = new ArrayList<PrsCampaignVO>();
		if (CollectionUtils.isNotEmpty(psCampaignList)) {
			for (PsCampaignVO psAdvanceCampaign : psCampaignList) {
				prsCampaignList.add(buidPrsCampaign(psAdvanceCampaign));
			}
		}
		return prsCampaignList;
	}
	
	/**
	 * 活动
	 * @param psCampaign
	 * @return
	 */
	public PrsCampaignVO buidPrsCampaign(PsCampaignVO psCampaign) {
		PrsCampaignVO prsCampaign = new PrsCampaignVO();
		if (psCampaign == null) {
			return prsCampaign;
		}
		prsCampaign.setAccessWayIds(psCampaign.getAccessWayIds());
		prsCampaign.setAdvance(psCampaign.getAdvance());
		prsCampaign.setApprovalState(psCampaign.getApprovalState());
		prsCampaign.setCode(psCampaign.getCode());
		prsCampaign.setCrossBorderFlag(psCampaign.getCrossBorderFlag());
		prsCampaign.setCumulative(psCampaign.getCumulative());
		prsCampaign.setDiscountTypeId(psCampaign.getDiscountTypeId());
		prsCampaign.setExpireTime(psCampaign.getExpireTime());
		prsCampaign.setId(psCampaign.getId());
		prsCampaign.setLadderRule(psCampaign.getLadderRule());
		prsCampaign.setLevel(psCampaign.getLevel());
		prsCampaign.setMemberLevels(psCampaign.getMemberLevels());
		prsCampaign.setName(psCampaign.getName());
		prsCampaign.setProductScopeId(psCampaign.getProductScopeId());
		prsCampaign.setOptionFlag(psCampaign.getOptionFlag());
		prsCampaign.setStartTime(psCampaign.getStartTime());
		prsCampaign.setState(psCampaign.getState());
		prsCampaign.setTitle(psCampaign.getTitle());
		if (MemberTypeEnum.NEW_MEMBER.getCode().equals(psCampaign.getMemberType())) {
			prsCampaign.setMemberType(PrsMemberTypeEnum.FISH_MAN);
		} 
		prsCampaign.setCampaignSectionList(buidPrsCs(psCampaign.getCampaignSectionList()));
		return prsCampaign;
	}
	
	/**
	 * 活动区间
	 * @param psCampaignSectionList
	 * @return
	 */
	private List<PrsCampaignSectionVO> buidPrsCs(List<PsCampaignSectionVO> psCampaignSectionList) {
		List<PrsCampaignSectionVO> prsCampaignSectionList = Lists.newArrayList();
		if (CollectionUtils.isEmpty(psCampaignSectionList)) {
			return prsCampaignSectionList;
		}
		for (PsCampaignSectionVO psCampaignSection : psCampaignSectionList) {
			PrsCampaignSectionVO prsCampaignSection = new PrsCampaignSectionVO();
			prsCampaignSection.setCampaignId(psCampaignSection.getCampaignId());
			prsCampaignSection.setFactor(psCampaignSection.getFactor());
			prsCampaignSection.setFactorType(psCampaignSection.getFactorType());
			prsCampaignSection.setId(psCampaignSection.getId());
			prsCampaignSection.setLine(psCampaignSection.getLine());
			prsCampaignSection.setType(psCampaignSection.getConditionType());
			prsCampaignSection.setSort(psCampaignSection.getRanking().floatValue());
			prsCampaignSection.setSectionProductVOList(buidPrsCspList(psCampaignSection.getCampaignSectionProducts()));
			prsCampaignSectionList.add(prsCampaignSection);
		}
		return prsCampaignSectionList;
	}
	
	/**
	 * 活动区间商品
	 * @param psCampaignSectionProductList
	 * @return
	 */
	private List<PrsCampaignSectionProductVO> buidPrsCspList(
			List<PsCampaignSectionProductVO> psCampaignSectionProductList) {
		
		List<PrsCampaignSectionProductVO> prsCspList = Lists.newArrayList();
		if (CollectionUtils.isEmpty(psCampaignSectionProductList)) {
			return prsCspList;
		}
		for (PsCampaignSectionProductVO psCsp : psCampaignSectionProductList) {
			PrsCampaignSectionProductVO prsCsp = new PrsCampaignSectionProductVO();
			prsCsp.setSort(psCsp.getSort());
			prsCsp.setCampaignId(psCsp.getCampaignId());
			prsCsp.setCampaignSectionId(psCsp.getCampaignSectionId());
			prsCsp.setId(psCsp.getId());
			prsCsp.setLimitCount(psCsp.getLimitCount());
			prsCsp.setCount(psCsp.getPriceCount());
			prsCsp.setPrice(psCsp.getPricePrice());
			prsCsp.setProductId(psCsp.getProductId());
			prsCspList.add(prsCsp);
		}
		return prsCspList;
	}
	
}
