package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.pegasus.component.delivery.constants.PostageConstant;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO;
import com.thebeastshop.price.vo.PrsSpvPriceStepVO.SkuPriceWithCnt;
import com.thebeastshop.salesorder.service.OrderPriceService;
import com.thebeastshop.salesorder.vo.snapshoot.OrderPriceSkuVO;
import com.thebeastshop.salesorder.vo.snapshoot.OrderPriceSpvVO;
import com.thebeastshop.salesorder.vo.snapshoot.OrderPriceVO;
import com.thebeastshop.salesorder.vo.snapshoot.OrderStepVO;
import com.thebeastshop.support.enums.PriceType;

/**
 * 订单快照适配器
 * 
 * @author wangyawei
 *
 */
@Component("snapshotAdapter")
public class SnapshotAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private OrderPriceService orderPriceService;

	@Autowired
	private KafkaProducerClient kafkaProducerClient;

	public Boolean saveSnapshot(Long orderId, PrsPacksPriceResultVO priceResult, String memberDesc,
			String couponTitle) {

		logger.info("保存订单快照");
		Boolean state = false;
		try {
			OrderStepVO stepVO = new OrderStepVO();

			stepVO = assambleVO(orderId, priceResult, memberDesc, couponTitle);

			
			if (CollectionUtils.isNotEmpty(stepVO.getPriceStep()) || CollectionUtils.isNotEmpty(stepVO.getPriceSpvStep()) || CollectionUtils.isNotEmpty(stepVO.getPriceSkuStep())) {
				kafkaProducerClient.send("order_snapShot", stepVO);
			}

			// state = orderPriceService.createSnapShoot(stepVO);
			state = true;
		} catch (Exception e) {
			logger.error("保存订单快照异常，e:{}", e);
			return state;
		}
		return state;
	}

	public Boolean savePSDOrderSnapshot(Long orderId, PsSpvVO spv) {
		Boolean state = false;
		try {
			OrderStepVO stepVO = new OrderStepVO();

			List<OrderPriceSkuVO> priceSkuStep = new ArrayList<OrderPriceSkuVO>();
			List<OrderPriceSpvVO> priceSpvStep = new ArrayList<OrderPriceSpvVO>();
			List<OrderPriceVO> priceStep = new ArrayList<OrderPriceVO>();

			// 订单快照
			int shotSort = 1;
			OrderPriceVO priceShot = new OrderPriceVO();
			priceShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.PSD.getId()));
			priceShot.setExtId(spv.getSpvId());
			priceShot.setSavedPrice(spv.getSalesPrice());
			priceShot.setSort(shotSort);
			priceShot.setNote("浦发专享权益");
			priceStep.add(priceShot);

			// 运费
			OrderPriceVO postageShot = new OrderPriceVO();
			shotSort++;
			postageShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.POSTAGE.getId()));
			postageShot.setExtId(spv.getSpvId());
			postageShot.setSavedPrice(BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE));
			postageShot.setSort(shotSort);
			postageShot.setNote("运费");
			priceStep.add(postageShot);

			// 运费减免
			OrderPriceVO postageSubtractShot = new OrderPriceVO();
			shotSort++;
			postageSubtractShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.POSTAGE_FREE.getId()));
			postageSubtractShot.setExtId(spv.getSpvId());
			postageSubtractShot.setSavedPrice(PostageConstant.NORMAL_PRICE);
			postageSubtractShot.setSort(shotSort);
			postageSubtractShot.setNote("浦发专享权益免运费");
			priceStep.add(postageSubtractShot);

			if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
				OrderPriceSpvVO orderPriceSpv = new OrderPriceSpvVO();
				int sort = 1;
				orderPriceSpv.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.PSD.getId()));
				orderPriceSpv.setExtId(spv.getSpvId());
				orderPriceSpv.setSpvId(spv.getSpvId());
				orderPriceSpv.setSpvPrice(spv.getSalesPrice());
				orderPriceSpv.setSavedPrice(spv.getSalesPrice());
				orderPriceSpv.setCount(1);
				orderPriceSpv.setSort(sort);
				postageSubtractShot.setNote("浦发专享权益");
				priceSpvStep.add(orderPriceSpv);
			}

			if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
				OrderPriceSkuVO orderPriceSku = new OrderPriceSkuVO();
				int sort = 1;
				orderPriceSku.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.PSD.getId()));
				orderPriceSku.setExtId(spv.getSpvId());
				orderPriceSku.setSpvId(spv.getSpvId());
				orderPriceSku.setSavedPrice(spv.getSalesPrice());
				orderPriceSku.setSkuCode(spv.getSkuCode());
				orderPriceSku.setSkuPrice(spv.getSalesPrice());
				orderPriceSku.setCount(1);
				orderPriceSku.setSort(sort);
				postageSubtractShot.setNote("浦发专享权益");
				priceSkuStep.add(orderPriceSku);
			}

			stepVO.setPriceSkuStep(priceSkuStep);
			stepVO.setPriceSpvStep(priceSpvStep);
			stepVO.setPriceStep(priceStep);
			stepVO.setOrderId(orderId);
			state = orderPriceService.createSnapShoot(stepVO);

		} catch (Exception e) {
			logger.error("保存订单快照异常，e:{}", e);
		}
		return state;
	}

	public Boolean saveJBROrderSnapshot(Long orderId, PsSpvVO spv, BigDecimal price) {
		Boolean state = false;
		try {

			OrderStepVO stepVO = new OrderStepVO();

			List<OrderPriceSkuVO> priceSkuStep = new ArrayList<OrderPriceSkuVO>();
			List<OrderPriceSpvVO> priceSpvStep = new ArrayList<OrderPriceSpvVO>();
			List<OrderPriceVO> priceStep = new ArrayList<OrderPriceVO>();

			// 订单快照
			int shotSort = 1;
			OrderPriceVO priceShot = new OrderPriceVO();
			priceShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.JBR.getId()));
			priceShot.setExtId(spv.getSpvId());
			priceShot.setSavedPrice(spv.getSalesPrice());
			priceShot.setSort(shotSort);
			priceShot.setNote("集赞折扣");
			priceStep.add(priceShot);

			// 运费
			OrderPriceVO postageShot = new OrderPriceVO();
			shotSort++;
			postageShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.POSTAGE.getId()));
			postageShot.setExtId(spv.getSpvId());
			postageShot.setSavedPrice(BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE));
			postageShot.setSort(shotSort);
			postageShot.setNote("运费");
			priceStep.add(postageShot);

			// 运费减免
			if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
				OrderPriceVO postageSubtractShot = new OrderPriceVO();
				shotSort++;
				postageSubtractShot.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.POSTAGE_FREE.getId()));
				postageSubtractShot.setExtId(spv.getSpvId());
				postageSubtractShot.setSavedPrice(PostageConstant.NORMAL_PRICE);
				postageSubtractShot.setSort(shotSort);
				postageSubtractShot.setNote("实付99元免运费");
				priceStep.add(postageSubtractShot);
			}

			if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
				OrderPriceSpvVO orderPriceSpv = new OrderPriceSpvVO();
				int sort = 1;
				orderPriceSpv.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.JBR.getId()));
				orderPriceSpv.setExtId(spv.getSpvId());
				orderPriceSpv.setSpvId(spv.getSpvId());
				orderPriceSpv.setSpvPrice(spv.getSalesPrice());
				orderPriceSpv.setSavedPrice(spv.getSalesPrice());
				orderPriceSpv.setCount(1);
				orderPriceSpv.setSort(sort);
				orderPriceSpv.setNote("集赞折扣");
				priceSpvStep.add(orderPriceSpv);
			}

			if (spv.getSalesPrice().compareTo(BigDecimal.ZERO) > 0) {
				OrderPriceSkuVO orderPriceSku = new OrderPriceSkuVO();
				int sort = 1;
				orderPriceSku.setType(PrsPriceTypeEnum.getEnumByCode(PriceType.JBR.getId()));
				orderPriceSku.setExtId(spv.getSpvId());
				orderPriceSku.setSpvId(spv.getSpvId());
				orderPriceSku.setSavedPrice(spv.getSalesPrice());
				orderPriceSku.setSkuCode(spv.getSkuCode());
				orderPriceSku.setSkuPrice(spv.getSalesPrice());
				orderPriceSku.setCount(1);
				orderPriceSku.setSort(sort);
				orderPriceSku.setNote("集赞折扣");
				priceSkuStep.add(orderPriceSku);
			}

			stepVO.setPriceSkuStep(priceSkuStep);
			stepVO.setPriceSpvStep(priceSpvStep);
			stepVO.setPriceStep(priceStep);
			stepVO.setOrderId(orderId);
			state = orderPriceService.createSnapShoot(stepVO);

		} catch (Exception e) {
			logger.error("保存订单快照异常，e:{}", e);
		}
		return state;
	}

	private OrderStepVO assambleVO(Long orderId, PrsPacksPriceResultVO priceResult, String memberDesc,
			String couponTitle) {

		logger.info("订单快照实体整理");

		OrderStepVO stepVO = new OrderStepVO();
		try {

			List<OrderPriceSkuVO> priceSkuStep = new ArrayList<OrderPriceSkuVO>();
			List<OrderPriceSpvVO> priceSpvStep = new ArrayList<OrderPriceSpvVO>();
			List<OrderPriceVO> priceStep = new ArrayList<OrderPriceVO>();

			List<PrsPriceStepVO> steps = priceResult.getPriceStepVOs();
			List<PrsSpvPriceStepVO> spvSteps = priceResult.getSpvPriceStepVOs();

			// 订单快照
			if (CollectionUtils.isNotEmpty(steps)) {
				int sort = 1;
				for (PrsPriceStepVO step : steps) {
					OrderPriceVO price = new OrderPriceVO();
					price.setExtId(orderId);
					if (null != step.getExtId()) {
						price.setExtId(step.getExtId());
					}
					price.setNote(step.getStepDesc());
					if (step.getPriceType().equals(PrsPriceTypeEnum.INTEREST_MEM_POSTAGE_FREE)
							|| step.getPriceType().equals(PrsPriceTypeEnum.BIRTHDAY)) {
						price.setNote(memberDesc + step.getStepDesc());
					} else if (step.getPriceType().equals(PrsPriceTypeEnum.MEMBER_LEVEL)) {
						price.setNote(memberDesc.substring(0, 2) + step.getStepDesc());
					} else if (step.getPriceType().equals(PrsPriceTypeEnum.COUPON)) {
						price.setNote(couponTitle);// 每个订单只能用一个优惠券，（应该去查才比较靠谱，暂时先这样吧）
					}
					price.setSavedPrice(BigDecimal.ZERO);
					if (step.getPriceChange().compareTo(BigDecimal.ZERO) != 0) {
						price.setSavedPrice(BigDecimal.ZERO.subtract(step.getPriceChange()));
						price.setSort(sort);
						price.setType(PrsPriceTypeEnum.getEnumByCode(step.getPriceType().getCode()));
						sort++;
						priceStep.add(price);
					}
				}
			}


			// spv快照
			if (CollectionUtils.isNotEmpty(spvSteps)) {
				int sort = 1;
				for (int i = 0; i < spvSteps.size(); i++) {
					PrsSpvPriceStepVO spvStep = spvSteps.get(i);

					if (spvStep.getExtId() == null) {
						spvStep.setExtId(orderId);
					}
					if (null != spvStep.getSkuPriceWithCntMap()) {
						Map<String, SkuPriceWithCnt> spvSkuMap = spvStep.getSkuPriceWithCntMap();

						// sku快照
						for (Map.Entry<String, SkuPriceWithCnt> entry : spvSkuMap.entrySet()) {
							OrderPriceSkuVO priceSku = new OrderPriceSkuVO();
							priceSku.setCount(entry.getValue().getCnt() * spvStep.getCount());
							priceSku.setExtId(spvStep.getSpvId());
							priceSku.setExtId(spvStep.getExtId());
							priceSku.setNote(spvStep.getPriceType().getName());
							priceSku.setSavedPrice(entry.getValue().getSavePriceWithCnt()
									.multiply(new BigDecimal(spvStep.getCount())));

							priceSku.setSkuCode(entry.getValue().getSkuCode().replace("-", ""));
							priceSku.setSkuPrice(
									entry.getValue().getPriceWithCnt().multiply(new BigDecimal(spvStep.getCount())));
							priceSku.setSort(sort);
							priceSku.setSpvId(Math.abs(spvStep.getSpvId()));
							priceSku.setType(PrsPriceTypeEnum.getEnumByCode(spvStep.getPriceType().getCode()));
							priceSkuStep.add(priceSku);
						}

					}

					if (i > 0 && !spvSteps.get(i).getExtId().equals(spvSteps.get(i - 1).getExtId())) {
						sort++;
					}
					OrderPriceSpvVO orderPriceProduct = new OrderPriceSpvVO();
					orderPriceProduct.setType(PrsPriceTypeEnum.getEnumByCode(spvStep.getPriceType().getCode()));
					orderPriceProduct.setExtId(spvStep.getExtId());
					orderPriceProduct.setSpvId(Math.abs(spvStep.getSpvId()));

					orderPriceProduct
							.setSavedPrice(spvStep.getSpvSavedPrice().multiply(new BigDecimal(spvStep.getCount())));
					orderPriceProduct.setCount(spvStep.getCount());
					orderPriceProduct.setSort(sort);
					orderPriceProduct.setSpvPrice(spvStep.getSpvPrice().multiply(new BigDecimal(spvStep.getCount())));
					orderPriceProduct.setNote(spvStep.getPriceType().getName());
					priceSpvStep.add(orderPriceProduct);
				}
			}
			stepVO.setPriceSkuStep(priceSkuStep);
			stepVO.setPriceSpvStep(priceSpvStep);
			stepVO.setPriceStep(priceStep);
			stepVO.setOrderId(orderId);

		} catch (Exception e) {
			logger.error("订单快照保存实体整理异常，e:{}", e.getMessage());
		}
		return stepVO;
	}
}
