package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuCustomizeVO;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.WeekEnum;

/**
 * 商品包适配器
 * 
 * @author Paul-xiong
 *
 */
@Component
public class OrderProductPackAdapter {
	//@Autowired
	//private McPsSpvService mcPsSpvService;
	@Autowired
	private McPsSkuService mcPsSkuService;

	//@Autowired
	//private SpvAdapter spvAdapter;

	/**
	 * 批量获取获取商品包
	 * 
	 * @param skus
	 * @param member
	 * @param channel
	 * @return
	 */
//	@Deprecated
//	public List<OrderProductPackVO> getProductPack(Collection<OpSoPackageSkuVO> skus, MemberVO member, OpChannelVO opChannel,
//			AccessWay accessWay) {
//		if (CollectionUtils.isNotEmpty(skus)) {
//			List<OrderProductPackVO> rt = Lists.newArrayListWithExpectedSize(skus.size());
//			Map<Long, OrderProductPackVO> temp = Maps.newLinkedHashMap();
//			// ===========spv map================
//			List<Long> spvIds = Lists.newArrayList();
//			List<String> skuCodes = Lists.newArrayList();
//			for (OpSoPackageSkuVO sku : skus) {
//				if (sku != null && sku.getSpvId() != null) {
//					spvIds.add(sku.getSpvId());
//				}
//				if (sku != null && sku.getSkuCode() != null) {
//					skuCodes.add(sku.getSkuCode());
//				}
//			}
//			Map<Long, PsSpvVO> spvMap = mcPsSpvService.mapBySpvIdsWithStock(spvIds,opChannel.getCode());
//			Map<String,String> spvDescMap = getFlowerSpvDescMap(skuCodes);
//			if (spvMap != null) {
//				Collection<PsSpvVO> spvs = spvMap.values();
//				// ===========spv label map============
//				Map<PsSpvVO, List<Label>> spvLabelMap = spvAdapter.getSpvLabels(spvs, accessWay);
//				for (OpSoPackageSkuVO sku : skus) {
//					if (sku != null) {
//						PsSpvVO spv = spvMap.get(sku.getSpvId());
//						SpvVO spvVO = spvAdapter.getSpvWithoutDiscount(spv, member, opChannel);
//						if (spv != null) {
//							// 月送鲜花获取规格提示信息
//							String spvDesc = spvDescMap.get(spv.getSkuCode());
//							if(StringUtils.isNotEmpty(spvDesc)){
//								spvVO.setSpvDesc(spvDesc);
//							}
//							// 设置定制信息
//							if(CollectionUtils.isNotEmpty(sku.getCustomizeList())){
//								spvVO.setSpvDesc(getCustomizeDesc(sku.getCustomizeList()));
//							}
//							
//							if(sku.getAptUCouponDiscountAmount()==null){
//								sku.setAptUCouponDiscountAmount(BigDecimal.ZERO);
//							}
//							
//							if (sku.getProductId() != null) {
//								// 组合商品
//								OrderProductPackVO packVO = temp.get(spv.getSpvId());
//								if (packVO == null) {
//									OrderProductPackVO vo = new OrderProductPackVO();
//									Integer quantity = 0;
//									if (sku.getQuantity() != null) {
//										quantity += sku.getQuantity();
//									}
//									if (sku.getCancleQuantity() != null) {
//										quantity += sku.getCancleQuantity();
//									}
//									vo.setCount(quantity);
//									vo.setProductId(spv.getProductCode());
//									BigDecimal price = sku.getUnitPrice();
//									spvVO.setRawPrice(PriceUtil.keepToCent(price));
//									BigDecimal discount = sku.getUnitPriceAfterDiscount();
//									if (discount != null) {
//										spvVO.setPrice(PriceUtil.keepToCent(discount).add(sku.getAptUCouponDiscountAmount()));
//									} else {
//										spvVO.setPrice(PriceUtil.keepToCent(price));
//									}
//									vo.setSpv(spvVO);
//									vo.setLabels(spvLabelMap.get(spv));
//									rt.add(vo);
//									temp.put(spv.getSpvId(), vo);
//								} else {
//									spvVO = packVO.getSpv();
//									BigDecimal price = sku.getUnitPrice();
//									spvVO.setRawPrice(PriceUtil.keepToCent(spvVO.getRawPrice().add(price)));
//									BigDecimal discount = sku.getUnitPriceAfterDiscount();
//									if (discount != null) {
//										spvVO.setPrice(PriceUtil.keepToCent(spvVO.getPrice().add(discount).add(sku.getAptUCouponDiscountAmount())));
//									} else {
//										spvVO.setPrice(PriceUtil.keepToCent(spvVO.getPrice().add(price)));
//									}
//								}
//							} else {
//								OrderProductPackVO vo = new OrderProductPackVO();
//								Integer quantity = 0;
//								if (sku.getQuantity() != null) {
//									quantity += sku.getQuantity();
//								}
//								if (sku.getCancleQuantity() != null) {
//									quantity += sku.getCancleQuantity();
//								}
//								vo.setCount(quantity);
//								vo.setProductId(spv.getProductCode());
//								BigDecimal price = sku.getUnitPrice();
//								spvVO.setRawPrice(PriceUtil.keepToCent(price));
//								BigDecimal discount = sku.getUnitPriceAfterDiscount();
//								if (discount != null) {
//									spvVO.setPrice(PriceUtil.keepToCent(discount.add(sku.getAptUCouponDiscountAmount())));
//								} else {
//									spvVO.setPrice(PriceUtil.keepToCent(price));
//								}
//								vo.setSpv(spvVO);
//								vo.setLabels(spvLabelMap.get(spv));
//								rt.add(vo);
//								temp.put(spv.getSpvId(), vo);
//							}
//						}
//					}
//				}
//			}
//			return rt;
//		}
//		return null;
//	}


	/**
	 * 获取鲜花提示信息
	 * @param skuCodes
	 * @return
	 */
	private Map<String ,String> getFlowerSpvDescMap(List<String> skuCodes){
		Map<String ,String> result = new HashMap<>();
		List<PsSkuVO> skuVOList = mcPsSkuService.findBySkuCodes(skuCodes);
		if(CollectionUtils.isNotEmpty(skuVOList)){
			for(PsSkuVO psSkuVO : skuVOList){
				if(YesOrNo.YES.getId().equals(psSkuVO.getIsMonthSend())){
					String spvDesc = this.getFlowerShowDesc(psSkuVO);
					result.put(psSkuVO.getSkuCode(),spvDesc);
				}
			}
		}
		return result;
	}

	/**
	 * 鲜花规格文字
	 * @param psSkuVO
	 * @return
	 */
	private String getFlowerShowDesc(PsSkuVO psSkuVO) {
		StringBuffer sb = new StringBuffer();
		sb.append("订几周").append(":");
		sb.append(psSkuVO.getDeliveryTimes()).append("周").append(";");
		sb.append("每周几收花").append(":");
		sb.append(WeekEnum.getDesc(psSkuVO.getMonthSendDeliveryRule())).append(";");
		return sb.toString();
	}

	/**
	 * 定制规格
	 * @param customizeVOs
	 * @return
	 */
	private String getCustomizeDesc(List<OpSoPackageSkuCustomizeVO> customizeVOs) {
		StringBuffer sb = new StringBuffer();
		for(OpSoPackageSkuCustomizeVO opSoPackageSkuCustomizeVO : customizeVOs){
			sb.append(opSoPackageSkuCustomizeVO.getCustomDimensionName()).append(":");
			String value = opSoPackageSkuCustomizeVO.getCustomDimensionValue();
			value = value.replaceAll("\\[\\[love\\]\\]","❤");
			sb.append(value).append(" ");
		}
		return sb.toString();
	}


}
