package com.thebeastshop.pegasus.channelservice.adapter.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.enums.DiscountTypeEnum;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.service.GroupBuyService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.campaign.vo.GroupBuyRecordVO;
import com.thebeastshop.campaign.vo.GroupBuyResultVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.cooperation.enums.DepositStatus;
import com.thebeastshop.cooperation.enums.DepositType;
import com.thebeastshop.cooperation.service.ShopVipService;
import com.thebeastshop.cooperation.service.deposit.DepositService;
import com.thebeastshop.cooperation.vo.VipActivityVO;
import com.thebeastshop.cooperation.vo.VipRecordVO;
import com.thebeastshop.cooperation.vo.deposit.DepositOrderVO;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.delivery.dto.DeliveryInfoDTO;
import com.thebeastshop.delivery.service.DeliveryRuleService;
import com.thebeastshop.delivery.vo.DeliveryInfoVO;
import com.thebeastshop.exchange.service.ExchangeService;
import com.thebeastshop.exchange.vo.ExchgRecordVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigDetailVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigVO;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.member.service.IdCardQueryService;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemIdCardVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.payment.dto.PIntegralPaymentDTO;
import com.thebeastshop.payment.service.PPaymentService;
import com.thebeastshop.payment.vo.PPaymentTradeVO;
import com.thebeastshop.pcs.sservice.SPrdcJobService;
import com.thebeastshop.pegasus.channelservice.adapter.ComOrderAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.exchange.ExchangeAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCommonAdapter;
import com.thebeastshop.pegasus.channelservice.service.ExchangeCartService;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.time.TimeSlot;
import com.thebeastshop.pegasus.component.time.service.TimeSlotService;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
import com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.*;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.dto.SGroupbuyOwnerOccupyDTO;
import com.thebeastshop.stock.dto.SGroupbuyParterOccupyDTO;
import com.thebeastshop.stock.vo.*;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.market.MarketVipDTO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
import com.thebeastshop.support.vo.order.OrderCard;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderConfirmVO.BdayVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.constant.WMSConstants;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Map.Entry;

/**
 * 新价格计算订单适配器
 * 
 * @author Wang Yawei
 *
 */
@Component("appOrderPriceAdapter")
public class OrderPriceAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private final String FINAL_ONOFF = "final_onoff";

	@Autowired
	private DepositService depositService;

	@Autowired
	private SPrdcJobService sPrdcJobService;

	@Autowired
	private MemberAddressService memberAddressService;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McOpChannelService mcOpChannelService;

	@Autowired
	private ExchangeService exchangeService;

	@Autowired
	private ExchangeAdapter exchangeAdapter;

	@Autowired
	private ProductAdapter productAdapter;

	@Autowired
	DeliveryRuleService deliveryRuleService;

	@Autowired
	private SnapshotAdapter snapshotAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private OrderCommonAdapter orderCommonAdapter;

	@Autowired
	private ComOrderAdapter comOrderAdapter;

	@Autowired
	private CartService cartService;
	@Autowired
	private SpvAdapter spvAdaptor;
	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private GroupBuyService groupBuyService;

	@Autowired
	private OverseaService overseaService;

	private TimeSlotService timeSlotService = ComponentServiceLoader.getBean(TimeSlotService.class);

	@Autowired
	private PriceAdapter priceAdapter;
	@Autowired
	private MemberAddressAdapter memberAddressAdapter;
	@Autowired
	private LogisticsAdapter logisticsAdapter;
	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;
	@Autowired
	private ExchangeCartService exchangeCartService;

	@Autowired
	private IdCardQueryService idCardQueryService;
	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private SpvCommonAdapter spvCommonAdapter;

	@Autowired
	private PPaymentService pPaymentService;

	@Autowired
	private ShopVipService shopVipService;

	/**
	 * 获取订单确认(从价格计算服务取价格步骤)
	 * 
	 * @param paramPacks
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public OrderConfirmVO getOrderPreview(OrderPreviewDTO orderPreview, List<CartProductPack> paramPacks,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(paramPacks)) {
			throw new WrongArgException("商品包不能为空");
		}

		OrderConfirmVO rt = new OrderConfirmVO();
		rt.setOrderType(orderPreview.getOrderType());
		boolean hasOverSea = overseaService.isOversea(paramPacks);// 判断是否有海外购商品

		// =============地址信息=============
		DeliverableVO deliverableTime = new DeliverableVO();
		com.thebeastshop.member.vo.MemberAddressVO address = null;

		Long addressId = orderPreview.getAddressId();
		if (null != addressId && addressId != 0) {
			address = memberAddressService.getById(addressId);
			if (address != null) {
				MemberAddressVO deliveryAddress = new MemberAddressVO();
				deliveryAddress.setId(address.getId());
				deliveryAddress.setAsDefault(address.getAsDefault());
				DistrictVO district = new DistrictVO();
				district.setFullName(address.getDistrict().getFullName());
				district.setId(address.getDistrict().getId());
				district.setName(address.getDistrict().getName());
				deliveryAddress.setDistrict(district);
				deliveryAddress.setLocation(address.getAddress());
				logger.info("地址详情来一发 address:{},addressId:{},location:{}", address, addressId, address.getAddress());
				deliveryAddress.setReceiverName(address.getReceiver());
				deliveryAddress.setReceiverPhone(address.getReceiverPhone());
				deliveryAddress.setZipCode(address.getZipCode());
				rt.setAddress(deliveryAddress);
			} else {
				throw new WrongArgException("地址不可用！");
			}
			deliverableTime = logisticsAdapter.getDeliverableForOrderPrice(paramPacks, address, member, accessWay,
					opChannel, orderPreview.getPostage(), hasOverSea, BigDecimal.ZERO);

		} else {
			address = memberAddressService.getDefaultByOwnerId(member.getId());// 不传时使用默认地址
			rt.setAddress(memberAddressAdapter.getMemberAddress(address, member));
			deliverableTime = logisticsAdapter.getDeliverableForOrderPrice(paramPacks, address, member, accessWay,
					opChannel, orderPreview.getPostage(), hasOverSea, BigDecimal.ZERO);
		}

		Long couponId = orderPreview.getCouponId();
		PrsCalPackDto arg0 = new PrsCalPackDto();
		BigDecimal customPostage = null;
		List<GiftCardVO> giftCards = orderPreview.getGiftCards();
		// spv 购买数量
		Map<Long, Integer> spvCountMap = new HashMap<Long, Integer>();
		// 兼容小程序
		if (!StringUtils.isBlank(orderPreview.getDeliveryTime()) || orderPreview.getDeliveryTimeSlot() > 0) {

			if (deliverableTime != null && deliverableTime.getPostage() != null) {

				arg0.setSelectedTimeDelivery(true);
				arg0.setPreciseTimeDeliveryFee(deliverableTime.getPostage().getEDT());
			}

		}
		// 如果是线下，用线下传进来的运费
		if (opChannel.getChannelType() == 1) {
			customPostage = BigDecimal.ZERO;
			if (null != orderPreview.getPostage() && null != orderPreview.getPostage().getNormal()) {
				customPostage = orderPreview.getPostage().getNormal();
			}
		}
		boolean birthday = true;
		if (null != orderPreview.isUseBdayDiscount() && !orderPreview.isUseBdayDiscount()) {
			logger.info("isUseBdayDiscount" + orderPreview.isUseBdayDiscount());
			birthday = false;
		}

		PostageVO postageVO = new PostageVO();
		if (deliverableTime != null) {
			postageVO = deliverableTime.getPostage();
		}
		BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
		if (deliveryFee != null) {
			if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
				arg0.setRemoteDeliveryFee(deliveryFee);
			}
		}

		Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
		List<Integer> interestId = new ArrayList<Integer>();
		BigDecimal remotePostage = BigDecimal.ZERO;

		if (null != orderPreview.getPostage() && null != orderPreview.getPostage().getNormal()) {
			remotePostage = orderPreview.getPostage().getFaraway();
		}

		// 积分兑换订单
		Map<String, ExchgSpuConfigVO> exchgSpuConfigMap = checkExchangeAndgetExchgSpuConfigVOMap(
				orderPreview.getOrderType(), member, paramPacks);

		// 优惠券
		String couponTitle = "";
		CpCouponVO couponVO = null;
		if (couponId != null && member != null) {
			ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId, member.getId(), opChannel.getCode());
			if (rsp == null || rsp.getBean() == null) {
				throw new WrongArgException("优惠券不可用!", "couponId", couponId);
			}
			couponVO = rsp.getBean();
			couponTitle = rsp.getBean().getCouponSample().getTitle();
		}

		// 价格计算 参数组装
		priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, paramPacks, member, opChannel, accessWay, couponVO,
				customPostage, remotePostage, interestId, birthday, giftCards, exchgSpuConfigMap);

		// 商场VIP
		if (orderPreview.getMarketVip() != null) {
			MarketVipDTO marketVip = orderPreview.getMarketVip();
			ServiceResp<Boolean> resp = shopVipService.isCardUseful(marketVip.getActivityId(),
					marketVip.getVipCardNo());
			if (!resp.getBean()) {
				throw new WrongArgException("商场VIP卡在本店下单超过限制次数!", "vipCardNo", marketVip.getVipCardNo());
			}
			ServiceResp<VipActivityVO> serviceResp = shopVipService.getVipActivity(marketVip.getActivityId());
			arg0.setMarketDiscount(serviceResp.getBean().getDiscount());
		}

		// 精确时段配送费
		if (!StringUtils.isBlank(orderPreview.getDeliveryTime())) {

			logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderPreview.getDeliveryTime());
			DeliveryInfoDTO dto = new DeliveryInfoDTO();
			dto.setDistrictId(address.getDistrict().getId().intValue());
			List<PsProductVO> products = new ArrayList<PsProductVO>();
			for (ProductPack pack : paramPacks) {
				// 联邦或店送时，需要取得配送日期
				if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
					products.add(pack.getProduct());
				}
			}
			Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
			List<String> skuCodeList = new ArrayList<String>();
			for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
				for (PsSkuVO sku : entry.getValue()) {
					skuCodeList.add(sku.getSkuCode());
				}
			}
			dto.setSkuCodeList(skuCodeList);

			Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
			for (ProductPack pack : paramPacks) {
				PsProductVO psProduct = pack.getProduct();
				if (products.contains(psProduct)) {
					String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
					skuCountMap.put(skucode, pack.getCount());
				}
			}
			dto.setSkuCountMap(skuCountMap);

			arg0.setSelectedTimeDelivery(false);
			ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

			if (resp.isSuccess()) {
				DeliveryInfoVO vo = resp.getBean();
				logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
				arg0.setSelectedTimeDelivery(true);
				arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
			} else {
				logger.info("查询张天琪配送费成功失败 message={}", resp.getRespMsg());

			}
		}

		logger.info("订单预览页价格计算查询");

		// 积分兑换订单
		PrsPacksPriceResultVO priceResult = null;
		if (OrderBusinessType.EXCHANGE.equals(orderPreview.getOrderType())) {
			if (CollectionUtils.isNotEmpty(arg0.getPackList())) {
				PrsCalPackDto prsCalcSkuDTO = new PrsCalPackDto();
				prsCalcSkuDTO.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
				prsCalcSkuDTO.setPostageFree(true);
				prsCalcSkuDTO.setPackList(arg0.getPackList());
				priceResult = prsPriceService.calculatePointDeduct4Preview(prsCalcSkuDTO);
			} else {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，兑换商品包未包含商品.");
			}
		} else {
			
			priceResult = prsPriceService.calculatePrs4PreviewOrder(arg0);
		}
		logger.info("下单价格计算查询 requestId={}", priceResult.getRequestId());

		// 查看架构有没有用优惠券
		if (couponId != null && member != null) {
			// 如果使用了优惠券，那么传给张天琪
			if (priceAdapter.isUseCoupon(priceResult.getPriceStepVOs())) {
				logger.info("使用优惠卷code:" + couponId.toString() + ",memberCode:" + member.getCode());
			} else {
				// 将优惠清理掉
				couponId = null;
				throw new WrongArgException("优惠券不可用!", "couponId", couponId);
			}
		}

		// 修改pack价格，从格计算服务中取spv价格
		priceAdapter.assemblePackWithPrice(paramPacks, priceResult.getSpvPriceMap());

		List<CartProductPack> clientAddPacks = new ArrayList<CartProductPack>();// 用户选规格赠品换购包

		for (CartProductPack paramPack : paramPacks) {
			if (paramPack.getSource().equals(CartPackSourceEnum.GIFT)
					|| paramPack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				clientAddPacks.add(paramPack);
			}
			if (paramPack.getSource().equals(CartPackSourceEnum.RAW)) {
				spvCountMap.put(paramPack.getSpvId(), paramPack.getCount());
			}
		}

		// 运费
		BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());
		if (null != postageVO) {
			postageVO.setNormal(postage);
		}
		if (null != deliverableTime && null != deliverableTime.getPostage()) {
			deliverableTime.getPostage().setNormal(postage);
		}

		/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
		List<String> productIds = new ArrayList<>();// 赠品productIdList
		Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

		// 从价格步骤中将需要的东西筛选出来
		priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
				campaignCodeMap);

		/* 取库存取商品详情取限量 */
		Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
		Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
		Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

		if (CollectionUtils.isNotEmpty(productIds)) {
			// 取商详
			psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// 取库存
			stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
			// 取限量
			List<CampaignStreamVO> csList = new ArrayList<>();
			if (null != psProductVOMap && !psProductVOMap.isEmpty()) {
				for (PsProductVO ppVO : psProductVOMap.values()) {
					CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
					campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
					campaignStreamVO.setProductCode(ppVO.getCode());
					campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
					campaignStreamVO.setMemberCode(member.getCode());
					csList.add(campaignStreamVO);
				}
				// 验证赠品限量库存
				ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
				if (srp.isSuccess() && srp.getBean() != null) {
					checkCspLimitMap.putAll(srp.getBean());
				}
			}
		}
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> sectionGiftMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map

		// 筛选赠一赠多
		priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, sectionGiftMap, psProductVOMap);

		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map

		// 去掉库存可限量不够的商品
		priceAdapter.exceptLimit(resultMap, stockMap, checkCspLimitMap, sectionGiftMap, psProductVOMap);

		/* 整理单品赠品、多品赠品、加价购包 */
		Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
		Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
		List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

		priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList, opChannel, spvCountMap);

		/* 将赠品和换购包装成cs使用的包 */
		Boolean giftState = priceAdapter.isOptionalGift(resultMap, clientAddPacks);// 是否使用用户选择规格标志
		Boolean addState = priceAdapter.isOptionalAdd(resultMap, clientAddPacks);// 是否使用用户选择规格标志

		List<CartProductPack> resultPacks = new ArrayList<CartProductPack>();// 重新拼装过后的商品包

		/* 不使用用户选择spv，赠品重新组装 */

		// 拼换购包
		if (addState) {// 如果用户换购数量不一致，直接不给换购，如需要，回购物车重新选
			for (CartProductPack pack : paramPacks) {
				if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
					if (CollectionUtils.isNotEmpty(addList)) {
						for (PrsAdditionalPackVO add : addList) {
							if (add.getProductId().equals(pack.getProductId())) {

								PsSpvVO spv = new PsSpvVO();
								spv.setDiscountPrice(add.getDiscountPrice());
								spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
								spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
								spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
								spv.setAttrs(pack.getSpv().getAttrs());
								spv.setAttrValues(pack.getSpv().getAttrValues());
								spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
								spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
								spv.setCampaignList(pack.getSpv().getCampaignList());
								spv.setCategoryId(pack.getSpv().getCategoryId());
								spv.setCombined(pack.getSpv().getCombined());
								spv.setCostPrice(pack.getSpv().getCostPrice());
								spv.setMinAmount(pack.getSpv().getMinAmount());
								spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
								spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
								spv.setProductCode(pack.getSpv().getProductCode());
								spv.setProductId(pack.getSpv().getProductId());
								spv.setProductName(pack.getSpv().getProductName());
								spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
								spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
								spv.setPsStockVO(pack.getSpv().getPsStockVO());
								spv.setSalesPrice(pack.getSpv().getSalesPrice());
								spv.setSkuCode(pack.getSpv().getSkuCode());
								spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
								spv.setSkuVO(pack.getSpv().getSkuVO());
								spv.setSpvId(pack.getSpv().getSpvId());
								pack.setSpv(spv);

								resultPacks.add(pack);
							}
						}
					}
				}
			}
		}
		// 拼主商品包
		for (CartProductPack pack : paramPacks) {
			if (pack.getSource().equals(CartPackSourceEnum.RAW)) {

				PsSpvVO spv = new PsSpvVO();
				spv.setDiscountPrice(priceResult.getSpvPriceMap().get(pack.getSpvId()));
				spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
				spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
				spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
				spv.setAttrs(pack.getSpv().getAttrs());
				spv.setAttrValues(pack.getSpv().getAttrValues());
				spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
				spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
				spv.setCampaignList(pack.getSpv().getCampaignList());
				spv.setCategoryId(pack.getSpv().getCategoryId());
				spv.setCombined(pack.getSpv().getCombined());
				spv.setCostPrice(pack.getSpv().getCostPrice());
				spv.setMinAmount(pack.getSpv().getMinAmount());
				spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
				spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
				spv.setProductCode(pack.getSpv().getProductCode());
				spv.setProductId(pack.getSpv().getProductId());
				spv.setProductName(pack.getSpv().getProductName());
				spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
				spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
				spv.setPsStockVO(pack.getSpv().getPsStockVO());
				spv.setSalesPrice(pack.getSpv().getSalesPrice());
				spv.setSkuCode(pack.getSpv().getSkuCode());
				spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
				spv.setSkuVO(pack.getSpv().getSkuVO());
				spv.setSpvId(pack.getSpv().getSpvId());
				pack.setSpv(spv);

				resultPacks.add(pack);
			}

			if (pack.getSource().equals(CartPackSourceEnum.BENEFIT)) {
				PsSpvVO spv = new PsSpvVO();
				if (priceResult.getSpvPriceMap().containsKey(-pack.getSpvId())) {
					spv.setDiscountPrice(priceResult.getSpvPriceMap().get(-pack.getSpvId()));
				} else {
					spv.setDiscountPrice(BigDecimal.ZERO);
				}

				spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
				spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
				spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
				spv.setAttrs(pack.getSpv().getAttrs());
				spv.setAttrValues(pack.getSpv().getAttrValues());
				spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
				spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
				spv.setCampaignList(pack.getSpv().getCampaignList());
				spv.setCategoryId(pack.getSpv().getCategoryId());
				spv.setCombined(pack.getSpv().getCombined());
				spv.setCostPrice(pack.getSpv().getCostPrice());
				spv.setMinAmount(pack.getSpv().getMinAmount());
				spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
				spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
				spv.setProductCode(pack.getSpv().getProductCode());
				spv.setProductId(pack.getSpv().getProductId());
				spv.setProductName(pack.getSpv().getProductName());
				spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
				spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
				spv.setPsStockVO(pack.getSpv().getPsStockVO());
				spv.setSalesPrice(pack.getSpv().getSalesPrice());
				spv.setSkuCode(pack.getSpv().getSkuCode());
				spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
				spv.setSkuVO(pack.getSpv().getSkuVO());
				spv.setSpvId(pack.getSpv().getSpvId());
				pack.setSpv(spv);

				resultPacks.add(pack);
			}

		}
		if (!giftState) {// 如果用户赠品书不对，则随机分配
			Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap, stockMap,
					checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack

			Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
					checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

			if (!singlePackMap.isEmpty()) {
				for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
					resultPacks.addAll(entry.getValue());
				}
			}

			if (!mutiPackMap.isEmpty()) {
				for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
					resultPacks.addAll(entry.getValue());
				}
			}
		} else {// 否则按用户选择直接给赠品
			for (CartProductPack pack : paramPacks) {
				if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
					resultPacks.add(pack);
				}
			}
		}

		List<CartProductPackVO> packVOs = Lists.newArrayListWithExpectedSize(resultPacks.size());
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(resultPacks.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(resultPacks.size());

		for (ProductPack pack : resultPacks) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}

		Collection<PsSpvVO> spvs = spvMap.values();
		Map<String, Date> spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);

		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);

		/* 标签处理 */
		Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();
		List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
		priceAdapter.getLabels(priceResult.getCartSettleLabelList(), mutiLabels, singleLabelMap);
		// 是否需要照片
		boolean hasOverseaPhoto = false;
		for (CartProductPack pack : resultPacks) {
			//
			if (hasOverSea && !hasOverseaPhoto) {
				if (pack.getProduct().getCombined()) {

					if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
						for (PsSkuCombinationVO sku : pack.getSpv().getSkuCombinationList()) {

							if (sku.getSubSkuVO().getClearanceWay() == 2) {
								hasOverseaPhoto = true;
							}
							break;
						}
					}

				} else {

					if (pack.getSpv() != null && pack.getSpv().getSkuVO() != null
							&& pack.getSpv().getSkuVO().getClearanceWay() == 2) {
						hasOverseaPhoto = true;

					}

				}
			}

			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				CartProductPackVO packVO = cartProductPackAdaptor.getAddibleCartProductPackListNew(Arrays.asList(pack),
						member, opChannel, accessWay, spvPresaleDateMap, false).get(0);
				// 加价购商品添加"换购"标签
				Label label = new Label();
				label.setType("换购");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
				CartProductPackVO packVO = cartProductPackAdaptor.getAddibleCartProductPackListNew(Arrays.asList(pack),
						member, opChannel, accessWay, spvPresaleDateMap, true).get(0);
				// 赠品商品添加"赠品"标签
				Label label = new Label();
				label.setType("赠品");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else {
				// 订单预览页主品上不需要绑赠品
				packVOs.addAll(priceAdapter.getCartProductPackList(Arrays.asList(pack), member, opChannel, true, false,
						true, accessWay, birthday, spvPresaleDateMap, interestGoodsMap,
						new HashMap<Long, List<CartProductPackVO>>(), singleLabelMap, true, spvLabelMap));

			}
		}
		// ==============商品包================
		// 积分兑换返回商品包设置积分信息
		if (OrderBusinessType.EXCHANGE.equals(orderPreview.getOrderType()) && null != exchgSpuConfigMap) {
			for (CartProductPackVO packVO : packVOs) {
				if (packVO.getSource().equals(CartPackSource.RAW)) {
					ExchgSpuConfigVO exchangeVO = exchgSpuConfigMap.get(packVO.getSpv().getProductCode());
					List<ExchgSpuConfigDetailVO> exchangelist = exchangeVO.getSpuConfigDetailList();
					if (CollectionUtils.isNotEmpty(exchangelist)) {
						for (ExchgSpuConfigDetailVO exchange : exchangelist) {
							if (exchange.getSkuCode().equalsIgnoreCase(packVO.getSpv().getSkuCodes().get(0))) {
								packVO.getSpv().setPoint(exchange.getExchangeAmount());
								if (!NumberUtil.isNullOrZero(exchange.getExchangePrice())) {
									packVO.getSpv().setPointPrice(packVO.getSpv().getRawPrice()
											.setScale(2, BigDecimal.ROUND_HALF_UP).subtract(
													exchange.getExchangePrice().setScale(2, BigDecimal.ROUND_HALF_UP)));
								}
								break;
							}
						}
					}
				}
			}
		}
		rt.setPacks(packVOs);

		// =========是否包含海外购商品===========
		rt.setHasOverseaProducts(hasOverSea);
		rt.setHasOverseaPhoto(hasOverseaPhoto);
		// =========可用的支付方式===========
		rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));

		// ===============标签(订单只显示满足条件的标签)================

		// 多品标签（订单只显示满足条件的价格类型标签）
		List<Label> cartLabels = new ArrayList<Label>();
		if (CollectionUtils.isNotEmpty(mutiLabels))

		{
			for (PrsCartSettleLabelVO label : mutiLabels) {
				if (label.isFit()) {
					// 满赠换购不显示
					if (null != label.getDiscountType() && !label.getDiscountType().getId().equals(DiscountType.GIFT.id)
							&& !label.getDiscountType().getId().equals(DiscountType.CHEAPEN_OTHER.id)) {
						cartLabels.add(priceAdapter.setupLabel(label));
					}
				}
			}
		}
		rt.setLabels(cartLabels);
		if (deliverableTime != null)

		{
			postageVO = deliverableTime.getPostage();
		}

		// 如果是线下，用线下传进来的运费
		if (opChannel.getChannelType() == 1)

		{
			postageVO = orderPreview.getPostage();
		}

		// =============价格步骤===============
		Collection<PriceStepVO> priceSteps = priceAdapter.getPriceSteps(priceResult, member.getMemberLevelDesc(),
				couponTitle);

		rt.setPrice(priceResult.getFinalTotalPrice());
		rt.setPriceSteps(priceSteps);

		// ===============定制信息===============
		for (CartProductPack cartProductPack : resultPacks)

		{
			if (cartProductPack.isCustomize()) {
				rt.setCustomizable(Boolean.TRUE);
				break;
			}
		}

		// ===============配送信息（是否使用语音卡）===============
		int voiceCard = 0;
		rt.setVoiceCard(false);
		for (CartProductPack cartProductPack : resultPacks)

		{
			PsProductVO pro = cartProductPack.getProduct();
			if (!pro.getExpressType().equals(WMSConstants.ExpressType.SHOP)) {
				voiceCard++;
			}
		}
		if (voiceCard > 0) {
			rt.setVoiceCard(true);
		}
		try {
			deliverableTime = logisticsAdapter.getDeliverablePrice(resultPacks, address, member, accessWay, opChannel,
					orderPreview.getPostage(), hasOverSea, postage);
		} catch (WrongArgException e) {
			deliverableTime = null;
			rt.setAddress(null);
			logger.error("e:{}", e);
		} catch (Throwable e) {
			logger.error("[" + this + "] - [getOrderConfirm] " + e.getMessage(), e);
			throw e;
		}

		if (deliverableTime != null) {
			// **********配送描述*********
			if (deliverableTime.getDeliveryTip() != null) {
				rt.setDeliveryTip(deliverableTime.getDeliveryTip());
			}
			// *********可配送日期*********
			if (deliverableTime.getDeliverableDates() != null) {
				rt.setDeliverableDates(deliverableTime.getDeliverableDates());
			}
			// ************时段**********
			if (deliverableTime.getDeliverableTimeSlots() != null) {
				rt.setDeliverableTimeSlots(deliverableTime.getDeliverableTimeSlots());
			}
			// **********运费*********
			rt.setPostage(deliverableTime.getPostage());
		}

		// =======生日折扣===========
		rt.setBday(getBdayVO(member, birthday, priceResult));
		// ===========是否可以注释============
		rt.setCanRemark(orderCommonAdapter.getCanRemark(resultPacks));
		rt.setGiftCards(giftCards);
		return rt;

	}

	/**
	 * 设置生日折扣
	 */
	private BdayVO getBdayVO(MemberVO member, Boolean useBdDiscount, PrsPacksPriceResultVO priceResult) {
		// 匿名用户
		if (member == null || member.getMemberLevel() == null) {
			return null;
		}
		// 注册用户 或 非生日期间
		if (MemberLevelEnum.NORMAL.getCode().equals(member.getMemberLevel()) || !member.isInBdayDiscountTime()) {
			return null;
		}
		BdayVO bday = new BdayVO();
		bday.setWithin(member.isInBdayDiscountTime());
		bday.setUsed(member.isBdayDiscountUsed());
		bday.setRatio(member.getBdayDiscountRatio());

		Boolean noBrithdayPriceStep = true;
		List<PrsPriceStepVO> priceStepList = priceResult.getPriceStepVOs();
		for (PrsPriceStepVO step : priceStepList) {
			if (PrsPriceTypeEnum.BIRTHDAY.equals(step.getPriceType())) {
				noBrithdayPriceStep = false;
				break;
			}
		}
		//使用生日折扣 但未享受生日折扣优惠
		if (useBdDiscount && noBrithdayPriceStep) {
			return null;
		}
		return bday;
	}

	/**
	 * 新创建订单方法（价格计算）
	 * 
	 * @param orderConfirmDTO
	 * @throws ParseException
	 */
	public String orderCreate(OrderConfirmDTO orderConfirmDTO, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String deviceId) throws ParseException {
		logger.info("execute  _callOldOrderCreate");
		String orderCode = "";
		Map<Long, CartProductPack> benefitMap = new HashMap<Long, CartProductPack>();// 权益map
		List<Long> finalList = new ArrayList<Long>();

		List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
		List<Long> packIds = Lists.newArrayList();
		List<RequestPack> noIdPacks = Lists.newArrayList();
		if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestPacks)) {
			OrderCreateVO oldOrderCreate = new OrderCreateVO();
			oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
			oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
			oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
			oldOrderCreate.setTbsClient(orderConfirmDTO.getTbsClient());
			oldOrderCreate.setTbsUSource(orderConfirmDTO.getTbsUSource());
			oldOrderCreate.setPlatForm(orderConfirmDTO.getPlatForm());
			oldOrderCreate.setActualPayPoint(orderConfirmDTO.getPoint());
			// =============商品包=============
			List<CartProductPack> packs = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
					noIdPacks.addAll(exchangeCartService.getPacksByIds(member.getId(), packIds));
				} else {
					packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
				}
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			// 预售商库存
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();

			Map<String, SPresaleVO> sPresaleMap = new HashMap<>();

			// 商品验证
			orderCommonAdapter.checkPack(packs, opChannel, member, oldOrderCreate, sPresaleMap, sPresaleSaleInvMap,
					orderConfirmDTO);

			// =========是否包含海外购商品===========
			int isOverseaOrPhoto = overseaService.isOverseaOrPhoto(packs);
			boolean isHasOverSea = false;
			if (isOverseaOrPhoto > 0) {
				isHasOverSea = true;
			}

			// =============APP下载来源============
			oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
			// =============渠道编号=============
			oldOrderCreate.setChannelCode(opChannel.getCode());
			// ==============会员id=============
			if (member != null) {
				oldOrderCreate.setCustomerId(member.getId());
			}

			// =============地址=============

			com.thebeastshop.member.vo.MemberAddressVO address = null;
			if (orderConfirmDTO.getAddressId() > 0) {
				address = memberAddressService.getById(orderConfirmDTO.getAddressId());
				if (address != null) {
					AddressVO deliveryAddress = new AddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setCircuit(address.getCircuitDesc());
					deliveryAddress.setDistrictId(address.getDistrict().getId());
					deliveryAddress.setDistrict(address.getDistrict().getName());
					deliveryAddress.setCompanyName(address.getCompanyName());
					deliveryAddress.setMemberId(address.getMemberId());
					deliveryAddress.setZip(address.getZipCode());
					deliveryAddress.setPhone(address.getReceiverPhone());
					deliveryAddress.setName(address.getReceiver());
					deliveryAddress.setMagentoTitle(address.getTitle());
					deliveryAddress.setStreet(address.getAddress());
					oldOrderCreate.setDeliveryAddress(deliveryAddress);
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
							"当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
				}
			}

			oldOrderCreate.setDeviceId(deviceId);

			// =============是否匿名购买=============
			oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
			// =============是否使用生日折扣=============
			oldOrderCreate.setUseBdayDiscount(orderConfirmDTO.isUseBdayDiscount());
			// =============卡片内容 卡片类型，0不需要1空白2代写=============
			OrderCard card = orderConfirmDTO.getNewCard();
			oldOrderCreate.setNoteCard(card.getType().getCode());
			oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
			oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
			oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));

			// =============配送日期=============
			oldOrderCreate.setDeliveryDate(orderConfirmDTO.getDeliveryDate());
			// =============配送时段=============
			TimeSlot timeSlot = timeSlotService.getById(orderConfirmDTO.getDeliveryTimeSlot());
			// 兼容小程序
			if (timeSlot != null)
				oldOrderCreate.setLimitedHour(timeSlot.getText());
			else {
				oldOrderCreate.setLimitedHour(orderConfirmDTO.getDeliveryTime());
			}

			// =============TODO:优惠券,现在数据库中字段的表示优惠口令（优惠码），暂时把优惠券id放在这个字段里，以后数据库中字段名应该改成couponId=============
			Long couponId = orderConfirmDTO.getCouponId();

			List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
			PrsCalPackDto arg0 = new PrsCalPackDto();
			BigDecimal customPostage = null;
			// 如果是线下，用线下传进来的运费
			if (opChannel.getChannelType() == 1) {
				customPostage = BigDecimal.ZERO;
				if (null != orderConfirmDTO.getPostage() && null != orderConfirmDTO.getPostage().getNormal()) {
					customPostage = orderConfirmDTO.getPostage().getNormal();
				}
			}
			List<Integer> interestId = new ArrayList<Integer>();

			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			boolean birthday = true;
			oldOrderCreate.setUseBdayDiscount(orderConfirmDTO.isUseBdayDiscount());
			if (!orderConfirmDTO.isUseBdayDiscount()) {
				logger.info("isUseBdayDiscount" + orderConfirmDTO.isUseBdayDiscount());
				birthday = false;
			}

			BigDecimal remotePostage = BigDecimal.ZERO;

			if (null != orderConfirmDTO.getDeliveryPrice()
					&& orderConfirmDTO.getDeliveryPrice().compareTo(BigDecimal.ZERO) > 0) {
				remotePostage = orderConfirmDTO.getDeliveryPrice();
			}

			// 积分兑换订单
			Map<String, ExchgSpuConfigVO> exchgSpuConfigMap = checkExchangeAndgetExchgSpuConfigVOMap(
					orderConfirmDTO.getOrderType(), member, packs);

			CpCouponVO couponVO = new CpCouponVO();
			if (couponId != null && member != null) {
				// 判断优惠券是否可以使用
				ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId, member.getId(),
						opChannel.getCode());
				if (rsp == null || rsp.getBean() == null) {
					throw new WrongArgException("优惠券不可用!", "couponId", couponId);
				}
				couponVO = rsp.getBean();
				priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay,
						rsp.getBean(), customPostage, remotePostage, interestId, birthday, giftCard, exchgSpuConfigMap);
			} else {
				priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
						customPostage, remotePostage, interestId, birthday, giftCard, exchgSpuConfigMap);
			}

			// 商场VIP
			if (orderConfirmDTO.getMarketVip() != null) {
				MarketVipDTO marketVip = orderConfirmDTO.getMarketVip();
				ServiceResp<Boolean> resp = shopVipService.isCardUseful(marketVip.getActivityId(),
						marketVip.getVipCardNo());
				if (!resp.getBean()) {
					throw new WrongArgException("商场VIP卡在本店下单超过限制次数!", "vipCardNo", marketVip.getVipCardNo());
				}
				ServiceResp<VipActivityVO> serviceResp = shopVipService.getVipActivity(marketVip.getActivityId());
				BigDecimal marketVipDiscount = serviceResp.getBean().getDiscount();
				orderConfirmDTO.getMarketVip().setDiscount(marketVipDiscount);
				arg0.setMarketDiscount(marketVipDiscount);
			}

			if (!StringUtils.isBlank(orderConfirmDTO.getDeliveryTime())) {

				logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderConfirmDTO.getDeliveryTime());
				DeliveryInfoDTO dto = new DeliveryInfoDTO();
				dto.setDistrictId(address.getDistrict().getId().intValue());
				List<PsProductVO> products = new ArrayList<PsProductVO>();
				for (ProductPack pack : packs) {
					// 联邦或店送时，需要取得配送日期
					if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
						products.add(pack.getProduct());
					}
				}
				Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
				List<String> skuCodeList = new ArrayList<String>();
				for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
					for (PsSkuVO sku : entry.getValue()) {
						skuCodeList.add(sku.getSkuCode());
					}
				}
				dto.setSkuCodeList(skuCodeList);

				Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
				for (ProductPack pack : packs) {
					PsProductVO psProduct = pack.getProduct();
					if (products.contains(psProduct)) {
						String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
						skuCountMap.put(skucode, pack.getCount());
					}
				}
				dto.setSkuCountMap(skuCountMap);

				arg0.setSelectedTimeDelivery(false);
				ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);
				if (resp.isSuccess()) {
					DeliveryInfoVO vo = resp.getBean();
					logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
					arg0.setSelectedTimeDelivery(true);
					arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
				}
			}
			DeliverableVO deliverableTime = logisticsAdapter.getDeliverablePrice(packs, address, member, accessWay,
					opChannel, orderConfirmDTO.getPostage(), isHasOverSea, BigDecimal.ZERO);

			PostageVO postageVO = new PostageVO();
			if (deliverableTime != null) {
				postageVO = deliverableTime.getPostage();
			}
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					arg0.setRemoteDeliveryFee(deliveryFee);
				}
			}

			logger.info("订单确认价格计算");

			PrsPacksPriceResultVO priceResult = null;

			// 积分兑换订单
			if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {

				if (CollectionUtils.isNotEmpty(arg0.getPackList())) {

					PrsCalPackDto prsCalcSkuDTO = new PrsCalPackDto();
					prsCalcSkuDTO.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
					prsCalcSkuDTO.setPostageFree(true);
					prsCalcSkuDTO.setPackList(arg0.getPackList());
					// TODO 偏远地区和精确时段需要等组合支付支持
					// prsCalcSkuDTO.setRemoteDeliveryFee(arg0.getRemoteDeliveryFee());
					// prsCalcSkuDTO.setRemoteAreaDelivery(arg0.getRemoteAreaDelivery());
					// prsCalcSkuDTO.setPreciseTimeDeliveryFee(arg0.getPreciseTimeDeliveryFee());
					// prsCalcSkuDTO.setSelectedTimeDelivery(arg0.getSelectedTimeDelivery());
					priceResult = prsPriceService.calculatePointDeduct4Submit(prsCalcSkuDTO);
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，兑换商品包未包含商品.");
				}

			} else {
				
			
				priceResult = prsPriceService.calculatePrs4SubmitOrder(arg0);
			}

			logger.info("价格计算查询 requestId={}", priceResult.getRequestId());

			// 运费
			BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());

			postageVO.setNormal(postage);
			if (null != deliverableTime && null != deliverableTime.getPostage()) {
				deliverableTime.getPostage().setNormal(postage);
			}
			// 先去看架构有没有用免邮权益
			if (CollectionUtils.isNotEmpty(interestId)) {
				// 如果使用了免邮权益，那么传给张天琪
				if (priceAdapter.getPostageInterest(priceResult.getPriceStepVOs())) {

					OrderCreateVO.InterestsVO interestsVO = oldOrderCreate.new InterestsVO();
					interestsVO.setId(interestId.get(0));
					oldOrderCreate.setInterestsVO(interestsVO);
				}

			}

			// 查看架构有没有用优惠券
			if (couponId != null && member != null) {
				// 如果使用了优惠券，那么传给张天琪
				if (priceAdapter.isUseCoupon(priceResult.getPriceStepVOs())) {
					logger.info("使用优惠卷code:" + couponId.toString() + ",memberCode:" + member.getCode());
					oldOrderCreate.setCouponCode(couponId.toString());
				} else {
					// 将优惠清理掉
					couponId = null;
				}

			}

			// 是否使用商场VIP
			if (orderConfirmDTO.getMarketVip() != null) {
				if (priceAdapter.isUseMarketVip(priceResult.getPriceStepVOs())) {
					OrderCreateVO.MarketVipVO marketVip = oldOrderCreate.new MarketVipVO();
					marketVip.setActivityId(orderConfirmDTO.getMarketVip().getActivityId());
					marketVip.setVipCardNo(orderConfirmDTO.getMarketVip().getVipCardNo());
					marketVip.setVipDiscount(orderConfirmDTO.getMarketVip().getDiscount());
					oldOrderCreate.setMarketVip(marketVip);
				}
			}

			if (isHasOverSea) {
				// =========设置海淘标记=========

				// ChannelCrossBoarder channelCrossBoarder =
				// com.thebeastshop.pegasus.channelservice.util.ConstUtil.channelCrossBoarderMap.get(opChannel.getCode());

				// if(channelCrossBoarder == null){
				// if
				// (accessWay.getCode().equals(AccessWayEnum.OFFLINE.getCode())
				// ||
				// accessWay.getCode().equals(AccessWayEnum.LITTLE_B.getCode()))
				// {

				// oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA_3);
				// } else {

				oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
				// }
				// }else{
				// oldOrderCreate.setCrossBorderFlag(channelCrossBoarder.getCrossBoarderFlg());
				// }

				if (orderConfirmDTO.getMemberIdCardDTO() != null) {
					// =========设置身份证信息=========

					if (orderConfirmDTO.getMemberIdCardDTO().getId() != null) {
						MemIdCardVO memIdCardVO = idCardQueryService
								.getIdCardById(orderConfirmDTO.getMemberIdCardDTO().getId());
						if (memIdCardVO != null) {
							IdCardVO idCardVO = new IdCardVO();
							idCardVO.setAuditStatus(memIdCardVO.getStatus());
							// 需要照片
							if (isOverseaOrPhoto == 2) {
								idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
								idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
							}

							idCardVO.setIdNumber(memIdCardVO.getIdNumber());
							idCardVO.setImgStatus(memIdCardVO.getImgStatus());
							idCardVO.setName(memIdCardVO.getName());
							idCardVO.setId(memIdCardVO.getId().longValue());
							oldOrderCreate.setIdCardVO(idCardVO);
						}

					} else {
						// =========设置身份证信息=========
						if (member != null && StringUtils.isNotBlank(orderConfirmDTO.getMemberIdCardDTO().getIdNumber())
								&& StringUtils.isNotBlank(orderConfirmDTO.getMemberIdCardDTO().getName())) {
							MemIdCardVO memIdCardVO = idCardQueryService.getIdCardByIdNumberAndNameAndMemberCode(
									orderConfirmDTO.getMemberIdCardDTO().getIdNumber(),
									orderConfirmDTO.getMemberIdCardDTO().getName(), member.getCode());
							if (memIdCardVO != null) {
								IdCardVO idCardVO = new IdCardVO();
								idCardVO.setAuditStatus(memIdCardVO.getStatus());
								// 需要照片
								if (isOverseaOrPhoto == 2) {
									idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
									idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
								}

								idCardVO.setIdNumber(memIdCardVO.getIdNumber());
								idCardVO.setImgStatus(memIdCardVO.getImgStatus());
								idCardVO.setName(memIdCardVO.getName());
								idCardVO.setId(memIdCardVO.getId().longValue());
								oldOrderCreate.setIdCardVO(idCardVO);
							}
						}
					}

				} else {

					// =========设置身份证信息=========
					if (member != null && address != null) {
						MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(),
								address.getReceiver());
						if (memIdCardVO != null) {
							IdCardVO idCardVO = new IdCardVO();
							idCardVO.setAuditStatus(memIdCardVO.getImgStatus());
							if (isOverseaOrPhoto == 2) {
								idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
								idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());

							}

							idCardVO.setIdNumber(memIdCardVO.getIdNumber());
							idCardVO.setImgStatus(memIdCardVO.getImgStatus());
							idCardVO.setName(memIdCardVO.getName());
							idCardVO.setId(memIdCardVO.getId().longValue());
							oldOrderCreate.setIdCardVO(idCardVO);
						}
					}

				}

			}
			// // 给张天琪的相关信息
			// // 给张天琪兑换积分信息
			// Map<Long, Integer> exchangeMap = new HashMap<Long, Integer>();

			// 所有商品的包 List<CartProductPack> packs

			Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
			Map<Long, Integer> spvCountMap = new HashMap<>();

			// spvId对应权益商品 Map<Long,InterestGoods>： interestGoodsMap
			// 兑换积分信息
			// oldOrderCreate.setExchangeMap(exchangeMap);

			// ====================xiugai======================
			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

			// Map<String, Integer> checkPanicPerUserLeftMap = new
			// HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
						if (member != null) {
							campaignStreamVO.setMemberCode(member.getCode());
						}

						csList.add(campaignStreamVO);

					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}
				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList, opChannel,
					spvCountMap);

			// ====================xiugai======================

			// 换购商品map,key:换购商品spvId，value:活动code Map<Long, String>： addPacks
			Map<Long, String> addiblePacks = priceAdapter.getAdds(priceResult.getPriceStepVOs(), packs);

			// 主品（spvid作为key）对应的赠品Map<Long,List<CartProductPack>> ： giftPackMap

			Map<Long, List<Long>> giftMap = priceAdapter.blindGift(singleGiftMap, mutiGiftMap);

			Map<Long, Integer> giftSizeMap = priceAdapter.getGiftSize(singleGiftMap, mutiGiftMap);

			Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
			List<CartProductPack> giftPacks = priceAdapter.getGifts(packs);
			if (CollectionUtils.isNotEmpty(giftPacks)) {
				if (null != giftMap && giftMap.size() > 0) {
					// if (CollectionUtils.isNotEmpty(giftPacks)) {

					for (Map.Entry<Long, List<Long>> gift : giftMap.entrySet()) {
						if (CollectionUtils.isNotEmpty(gift.getValue())) {
							List<CartProductPack> resultList = new ArrayList<CartProductPack>();
							for (Long productId : gift.getValue()) {
								for (CartProductPack gif : giftPacks) {// 取一个删一个，防止出现同一个product下多个spv赠品
									if (productId.equals(gif.getProductId())) {
										logger.info("给赠品塞数量，赠品productId = {}", productId);
										if (giftSizeMap.containsKey(productId)) {

											logger.info("，赠品productId = {}的实际数量为 count={}", productId,
													giftSizeMap.get(productId));
											gif.setCount(giftSizeMap.get(productId));
										} else {
											logger.info("，赠品productId = {}没有数量", productId);
										}
										resultList.add(gif);
										giftPacks.remove(gif);
										break;
									}
								}

							}
							if (CollectionUtils.isNotEmpty(resultList)) {
								giftPackMap.put(Math.abs(gift.getKey()), resultList);// 权益带来的赠品，需要把id-去掉
							}
						}
					}
				}

			} else {// 前端如果不带赠品来，后端塞赠品
				if (!singleGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap,
							stockMap, checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack
					for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}

				if (!mutiGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
							checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

					for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}
			}

			Map<Long, BigDecimal> priceMap = priceResult.getSpvPriceMap();

			for (CartProductPack pack : packs) {
				if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
					spvCountMap.put(pack.getSpvId(), pack.getCount());

					PsSpvVO spv = new PsSpvVO();
					spv.setDiscountPrice(spvMap.get(pack.getSpvId()));
					spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
					spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
					spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
					spv.setAttrs(pack.getSpv().getAttrs());
					spv.setAttrValues(pack.getSpv().getAttrValues());
					spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
					spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
					spv.setCampaignList(pack.getSpv().getCampaignList());
					spv.setCategoryId(pack.getSpv().getCategoryId());
					spv.setCombined(pack.getSpv().getCombined());
					spv.setCostPrice(pack.getSpv().getCostPrice());
					spv.setMinAmount(pack.getSpv().getMinAmount());
					spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
					spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
					spv.setProductCode(pack.getSpv().getProductCode());
					spv.setProductId(pack.getSpv().getProductId());
					spv.setProductName(pack.getSpv().getProductName());
					spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
					spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
					spv.setPsStockVO(pack.getSpv().getPsStockVO());
					spv.setSalesPrice(pack.getSpv().getSalesPrice());
					spv.setSkuCode(pack.getSpv().getSkuCode());
					spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
					spv.setSkuVO(pack.getSpv().getSkuVO());
					spv.setSpvId(pack.getSpv().getSpvId());
					pack.setSpv(spv);
				}

				if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
					if (CollectionUtils.isNotEmpty(addList)) {
						for (PrsAdditionalPackVO add : addList) {
							if (add.getProductId().equals(pack.getProductId())) {

								PsSpvVO spv = new PsSpvVO();
								spv.setDiscountPrice(add.getDiscountPrice());
								spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
								spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
								spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
								spv.setAttrs(pack.getSpv().getAttrs());
								spv.setAttrValues(pack.getSpv().getAttrValues());
								spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
								spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
								spv.setCampaignList(pack.getSpv().getCampaignList());
								spv.setCategoryId(pack.getSpv().getCategoryId());
								spv.setCombined(pack.getSpv().getCombined());
								spv.setCostPrice(pack.getSpv().getCostPrice());
								spv.setMinAmount(pack.getSpv().getMinAmount());
								spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
								spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
								spv.setProductCode(pack.getSpv().getProductCode());
								spv.setProductId(pack.getSpv().getProductId());
								spv.setProductName(pack.getSpv().getProductName());
								spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
								spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
								spv.setPsStockVO(pack.getSpv().getPsStockVO());
								spv.setSalesPrice(pack.getSpv().getSalesPrice());
								spv.setSkuCode(pack.getSpv().getSkuCode());
								spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
								spv.setSkuVO(pack.getSpv().getSkuVO());
								spv.setSpvId(pack.getSpv().getSpvId());
								pack.setSpv(spv);
							}
						}
					}

				}
				if (pack.getSource().equals(CartPackSourceEnum.BENEFIT)) {

					PsSpvVO spv = new PsSpvVO();

					if (priceMap.containsKey(-pack.getSpvId())) {
						spv.setDiscountPrice(priceMap.get(-pack.getSpvId()));
					} else {
						spv.setDiscountPrice(BigDecimal.ZERO);
					}
					spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
					spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
					spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
					spv.setAttrs(pack.getSpv().getAttrs());
					spv.setAttrValues(pack.getSpv().getAttrValues());
					spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
					spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
					spv.setCampaignList(pack.getSpv().getCampaignList());
					spv.setCategoryId(pack.getSpv().getCategoryId());
					spv.setCombined(pack.getSpv().getCombined());
					spv.setCostPrice(pack.getSpv().getCostPrice());
					spv.setMinAmount(pack.getSpv().getMinAmount());
					spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
					spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
					spv.setProductCode(pack.getSpv().getProductCode());
					spv.setProductId(pack.getSpv().getProductId());
					spv.setProductName(pack.getSpv().getProductName());
					spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
					spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
					spv.setPsStockVO(pack.getSpv().getPsStockVO());
					spv.setSalesPrice(pack.getSpv().getSalesPrice());
					spv.setSkuCode(pack.getSpv().getSkuCode());
					spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
					spv.setSkuVO(pack.getSpv().getSkuVO());
					spv.setSpvId(pack.getSpv().getSpvId());
					pack.setSpv(spv);

					benefitMap.put(pack.getSpvId(), pack);
				}

				// if (null != exchgSpuConfigMap) {
				// ExchgSpuConfigVO exchangeVO =
				// exchgSpuConfigMap.get(pack.getProduct().getCode());
				// List<ExchgSpuConfigDetailVO> exchangelist =
				// exchangeVO.getSpuConfigDetailList();
				// if (CollectionUtils.isNotEmpty(exchangelist)) {
				//
				// for (ExchgSpuConfigDetailVO exchange : exchangelist) {
				//
				// if (pack.getSpv().getCombined()) {
				// if (exchange.getSpvId().longValue() == pack.getSpvId()) {
				// logger.info("exchange spvid={},pack spvid={}",
				// exchange.getSpvId(),
				// pack.getSpvId());
				//
				// exchangeMap.put(pack.getSpvId(),
				// exchange.getExchangeAmount());
				// }
				// } else {
				// if (exchange.getSkuCode().equals(pack.getSpv().getSkuCode()))
				// {
				// logger.info("exchange spvid={},pack spvid={}",
				// exchange.getSpvId(),
				// pack.getSpvId());
				//
				// exchangeMap.put(pack.getSpvId(),
				// exchange.getExchangeAmount());
				// }
				// }
				//
				// }
				// }
				//
				// }
			}
			oldOrderCreate.setOrderBusinessType(orderConfirmDTO.getOrderType());

			if (!benefitMap.isEmpty()) {// 查询是否尾款订单

				List<String> times = JsonUtil.toList(PropConstants.getProperties(FINAL_ONOFF), String.class);

				Date start = new Date();
				Date end = new Date();
				DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

				Date now = new Date();

				start = dateFormat.parse(times.get(0));
				end = dateFormat.parse(times.get(1));
				if (now.after(start) && now.before(end)) {

//					List<Long> codes = new ArrayList<Long>();
//
//					for (Map.Entry<Long, CartProductPack> entry : benefitMap.entrySet()) {
//						codes.add(Long.parseLong(entry.getValue().getSourceBindVal()));
//					}
//					ServiceResp<List<Long>> resp = depositService.checkByIds(codes);
//					if (resp.isSuccess()) {
//						if (CollectionUtils.isNotEmpty(resp.getBean())) {
//							oldOrderCreate.setOrderBusinessType(OrderBusinessType.FINAL);// 尾款类型
//							finalList.addAll(resp.getBean());
//						}
//					}
				}
			}
			oldOrderCreate.setPacks(packs);

			oldOrderCreate.setAddiblePacks(addiblePacks);
			// oldOrderCreate.setCampaignMap(campaignMap);
			oldOrderCreate.setGiftPackMap(giftPackMap);
			oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
			oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());
			// oldOrderCreate.setInterestGoodsMap(interestGoodsMap);
			// oldOrderCreate.setServiceStep(priceAdapter.setServiceStep(priceResult.getPriceStepVOs()));

			if (CollectionUtils.isNotEmpty(priceResult.getSkuPriceStepVOs())) {
				Map<String, PrsSkuPriceStepVO> skuPriceStepMap = new HashMap<>();
				for (PrsSkuPriceStepVO vo : priceResult.getSkuPriceStepVOs()) {
					skuPriceStepMap.put(vo.getSpvId() + vo.getSkuCode() + vo.getPriceType().getCode(), vo);
				}
				oldOrderCreate.setSkuPriceStepMap(skuPriceStepMap);
			}

			// =============支付金额校验=============
			BigDecimal payment = priceResult.getFinalTotalPrice();

			// 价格比较
			if (payment.subtract(orderConfirmDTO.getPrice()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
				throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE,
						"商品支付价格有误,payment=" + payment + ",Price=" + orderConfirmDTO.getPrice());
			}
			oldOrderCreate.setActualPayFee(payment);

			// 礼品卡信息
			oldOrderCreate.setOpSalesOrderGiftCardVOs(priceAdapter.getGiftCardList(priceResult.getPriceStepVOs()));

			// =============客户备注===========
			oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
			// 投放来源
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());

			// 配送方式，0非快递1快递
			if (orderConfirmDTO.getAddressId() > 0) {
				oldOrderCreate.setDeliveryType(1);
			} else {
				oldOrderCreate.setDeliveryType(0);
			}
			if (CollectionUtils.isEmpty(oldOrderCreate.getPacks())) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，商品包未包含商品.");
			}
			// 调用方法了
			OpSalesOrderVO opSalesOrderVO = null;

			if (opChannel.getChannelType() == 1) {
				// 调用方法了
				opSalesOrderVO = comOrderAdapter.orderWebsite2CommonIPOS(oldOrderCreate, accessWay, member, opChannel,
						sPresaleMap, sPresaleSaleInvMap);
			} else {
				// 调用方法了
				opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay, member, opChannel,
						sPresaleMap, sPresaleSaleInvMap);
			}

			OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);
			if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {

				orderCode = orderResp.getOrderCode();
				// 如果订单中有配方商品需要占用库存，如果占用失败，将订单改为不可见
				if (CollectionUtils.isNotEmpty(opSalesOrderVO.getCustomizeInvList())
						&& opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					try {
						sPrdcJobService.createAllotOrPrdcJob(opSalesOrderVO.getCustomizeInvList());
					} catch (Exception e) {

						pcInstance.deleteSalesOrder(opSalesOrderVO.getMemberCode(), orderCode, "配方定制商品库存占用失败,订单隐藏");
						logger.info(e.getMessage());
						logger.info("配方定制商品库存占用失败，orderCode:" + opSalesOrderVO.getCode());
						throw new ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE, "配方定制商品库存不足");
					}
				}

				if (couponId != null && StringUtils.isNotBlank(orderCode)) {
					// TODO：如果创建订单成功,则优惠券要改为已使用（注：这个应该是在下订单流程中处理的，以后要改）
					ServiceResp<Boolean> resp = cpCouponService.use(couponId);
					if (resp.isFailure()) {
						throw new ChannelException(ChannelExceptionErrorCode.COUPON_INVALID_CODE,
								"使用优惠券失败 [couponId=" + couponId + "]: " + resp.getRespMsg());
					}
				}

				// 保存订单快照
				if (StringUtils.isNotBlank(orderCode)) {
					String couponTitle = "";
					if (null != couponId) {
						couponTitle = couponVO.getCouponSample().getTitle();
					}
					snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(),
							couponTitle);
				}

				Integer paymentType = -1;
				// 积分兑换订单
				if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
					// if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <=
					// 0) {

					if (CollectionUtils.isNotEmpty(opSalesOrderVO.getExchgRecordVOs())) {

						for (ExchgRecordVO exchgRecordVO : opSalesOrderVO.getExchgRecordVOs()) {
							exchgRecordVO.setSalesOrderNo(orderCode);
							ServiceResp<Boolean> resp = exchangeService.initExchgRecordByOrder(orderCode,
									opSalesOrderVO.getExchgRecordVOs());
							if (resp.isFailure()) {
								logger.error("exchangeService.initExchgRecord message:" + resp.getRespMsg());
								throw new ChannelException("500", "下单保存积兑换记录失败，" + resp.getRespMsg());
							}
						}

					}

					

					PIntegralPaymentDTO dto = new PIntegralPaymentDTO();

					dto.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
					dto.setRemark(opSalesOrderVO.getPointOnLineDeduction().toString());
					dto.setChannelCode(opChannel.getCode());
					dto.setChannelName(opChannel.getName());
					dto.setMemberId(member.getId());
					dto.setOutTradeCode(orderCode);
					dto.setPaymentAmount(opSalesOrderVO.getPointOnLine());
					ServiceResp<PPaymentTradeVO> resp = pPaymentService.payForLocal(dto);
					if (resp.isFailure() || resp.getBean() == null) {
						throw new ChannelException("500", "积分支付失败，" + resp.getRespMsg());
					}

					
					logger.info("积分兑换商品，需要通知兑换服务.");
					try {

						ServiceResp<?> resp2 = exchangeService.processExchgRecordBySalesOrderNo(orderCode);
						if (resp2.isFailure()) {
							logger.info("积分兑换商品，通知兑换服务异常,message:" + resp2.getRespMsg());
						} else {
							logger.info("积分兑换商品，成功通知兑换服务.");
						}

					} catch (Exception e) {
						logger.error("积分兑换商品，通知兑换服务异常,message:" + e.getMessage());

						throw new ChannelException("500", "积分兑换商品，通知兑换服务异常，" + e.getMessage());
					}
					
					paymentType = PegasusConstants.Payment.TYPE_EXCHANGE;
					// }

				} else {

					if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
						orderCommonAdapter.orderPay(orderCode, paymentType, orderResp.getAmount(), "");
					}
				}

				// 清空购物车
				if (StringUtils.isNotBlank(orderCode)) {
					// 如果创建订单成功且从购物车中来,则删除购物车中商品包
					if (member != null && CollectionUtils.isNotEmpty(packIds)) {
						if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
							exchangeCartService.delPacks(member.getId(), packIds);
						} else {
							cartService.removePacksById(member, packIds);
						}
					}
				}
				if (member != null) {
					// 如果用户未设置默认地址，则这次订单地址设为默认地址
					com.thebeastshop.member.vo.MemberAddressVO memberAddress = memberAddressService
							.getDefaultByOwnerId(member.getId());
					if (memberAddress == null && address != null) {
						address.setAsDefault(true);
						memberAddressService.update(address);
					}
				}

				if (oldOrderCreate.getMarketVip() != null) {
					try {
						VipRecordVO vipRecordVO = new VipRecordVO();
						vipRecordVO.setActivityId(oldOrderCreate.getMarketVip().getActivityId());
						vipRecordVO.setVipCardNum(oldOrderCreate.getMarketVip().getVipCardNo());
						vipRecordVO.setOrderId(orderCode);
						vipRecordVO.setDiscount(oldOrderCreate.getMarketVip().getVipDiscount());
						shopVipService.addVipRecord(vipRecordVO);
					} catch (Exception e) {
						logger.error("调用商场VIP通知接口异常：" + e.getMessage());

					}
				}

//				try {
//					// ezr coupon
//					cpCouponService.couponUseEzr(couponId, opChannel.getCode(), orderCode,
//							opSalesOrderVO.getCouponFee().doubleValue());
//				} catch (Exception e) {
//					logger.error("couponUseEzr error");
//					logger.error(e.getMessage());
//				}

			}

			if (CollectionUtils.isNotEmpty(finalList)) {// 尾款订单入库
				List<DepositOrderVO> arg0s = new ArrayList<DepositOrderVO>();

				HashSet h = new HashSet(finalList);// list去重
				finalList.clear();
				finalList.addAll(h);

				for (Long interest : finalList) {
					for (Map.Entry<Long, CartProductPack> entry : benefitMap.entrySet()) {
						if (entry.getValue().getSourceBindVal().equals(interest.toString())) {
							DepositOrderVO finalvo = new DepositOrderVO();
							finalvo.setCount(entry.getValue().getCount());
							finalvo.setMemberId(member.getId());
							finalvo.setOrderCode(orderCode);
							finalvo.setSkuCode(entry.getValue().getSpv().getSkuCode());
							finalvo.setState(DepositStatus.DEFAULT);
							finalvo.setType(DepositType.FINAL);
							finalvo.setInterestId(interest);
							arg0s.add(finalvo);
						}
					}
				}
				ServiceResp<Boolean> state = depositService.saveList(arg0s);
				logger.info("尾款信息入库结果 state=" + state.getBean());
			}
		}
		return orderCode;
	}

	/**
	 * 团购价格计算
	 * 
	 * @param orderConfirmDTO
	 */
	public BigDecimal calculate(OrderConfirmDTO orderConfirmDTO, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		BigDecimal price = BigDecimal.ZERO;
		List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
		List<Long> packIds = Lists.newArrayList();
		List<RequestPack> noIdPacks = Lists.newArrayList();
		if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestPacks)) {
			List<CartProductPack> packs = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			// =============地址=============

			com.thebeastshop.member.vo.MemberAddressVO address = null;
			if (orderConfirmDTO.getAddressId() > 0) {
				address = memberAddressService.getById(orderConfirmDTO.getAddressId());
				if (address != null) {
					AddressVO deliveryAddress = new AddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setCircuit(address.getCircuitDesc());
					deliveryAddress.setDistrictId(address.getDistrict().getId());
					deliveryAddress.setDistrict(address.getDistrict().getName());
					deliveryAddress.setCompanyName(address.getCompanyName());
					deliveryAddress.setMemberId(address.getMemberId());
					deliveryAddress.setZip(address.getZipCode());
					deliveryAddress.setPhone(address.getReceiverPhone());
					deliveryAddress.setName(address.getReceiver());
					deliveryAddress.setMagentoTitle(address.getTitle());
					deliveryAddress.setStreet(address.getAddress());
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
							"当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
				}
			}

			List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
			PrsCalPackDto arg0 = new PrsCalPackDto();
			BigDecimal customPostage = null;

			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			boolean birthday = false;

			BigDecimal remotePostage = BigDecimal.ZERO;

			if (null != orderConfirmDTO.getDeliveryPrice()
					&& orderConfirmDTO.getDeliveryPrice().compareTo(BigDecimal.ZERO) > 0) {
				remotePostage = orderConfirmDTO.getDeliveryPrice();
			}

			// 积分兑换订单
			Map<String, ExchgSpuConfigVO> exchgSpuConfigMap = checkExchangeAndgetExchgSpuConfigVOMap(
					orderConfirmDTO.getOrderType(), member, packs);
			List<Integer> interestId = new ArrayList<Integer>();

			priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
					customPostage, remotePostage, interestId, birthday, giftCard, exchgSpuConfigMap);
			if (CollectionUtils.isEmpty(arg0.getPackList())) {
				logger.info("购物车价格计算组装包异常");
				return price;
			}

			// 精确时段配送费
			if (!StringUtils.isBlank(orderConfirmDTO.getDeliveryTime())) {

				logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderConfirmDTO.getDeliveryTime());
				DeliveryInfoDTO dto = new DeliveryInfoDTO();
				dto.setDistrictId(address.getDistrict().getId().intValue());
				List<PsProductVO> products = new ArrayList<PsProductVO>();
				for (ProductPack pack : packs) {
					// 联邦或店送时，需要取得配送日期
					if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
						products.add(pack.getProduct());
					}
				}
				Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
				List<String> skuCodeList = new ArrayList<String>();
				for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
					for (PsSkuVO sku : entry.getValue()) {
						skuCodeList.add(sku.getSkuCode());
					}
				}
				dto.setSkuCodeList(skuCodeList);

				Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
				for (ProductPack pack : packs) {
					PsProductVO psProduct = pack.getProduct();
					if (products.contains(psProduct)) {
						String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
						skuCountMap.put(skucode, pack.getCount());
					}
				}
				dto.setSkuCountMap(skuCountMap);

				arg0.setSelectedTimeDelivery(false);
				ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

				if (resp.isSuccess()) {
					DeliveryInfoVO vo = resp.getBean();
					logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
					arg0.setSelectedTimeDelivery(true);
					arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
				} else {
					logger.info("查询张天琪配送费成功失败 message={}", resp.getRespMsg());

				}
			}

			logger.info("订单预览页价格计算查询");

			// 积分兑换订单
			PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4GroupBuy(arg0);

			logger.info("积分兑换订单价格计算查询 requestId={}", priceResult.getRequestId());

			price = priceResult.getFinalTotalPrice();
		}

		return price;
	}

	/**
	 * 校验积分兑换，并且获取兑换配置信息
	 * 
	 * @param orderBusinessType
	 * @param member
	 * @param packs
	 * @return
	 */
	private Map<String, ExchgSpuConfigVO> checkExchangeAndgetExchgSpuConfigVOMap(OrderBusinessType orderBusinessType,
			MemberVO member, List<CartProductPack> packs) {
		Map<String, ExchgSpuConfigVO> exchgSpuConfigMap = null;
		if (OrderBusinessType.EXCHANGE.equals(orderBusinessType)) {
			if (CollectionUtils.isNotEmpty(packs)) {
				List<String> prodCodes = Lists.newArrayList();
				// 兑换商品校验
				for (CartProductPack pack : packs) {
					String productCode = pack.getProduct().getCode();
					// 校验是否有兑换权限
					exchangeAdapter.checkExchangeGoods(member, productCode, pack.getSpv().getSkuCode(),
							pack.getCount());
					prodCodes.add(productCode);
				}
				if (CollectionUtils.isNotEmpty(prodCodes)) {
					exchgSpuConfigMap = new HashMap<>();
					List<ExchgSpuConfigVO> spuConfigVOS = exchangeService
							.queryExchgSpuConfigByReferenceCodes(prodCodes);
					for (ExchgSpuConfigVO spuConfigVO : spuConfigVOS) {
						exchgSpuConfigMap.put(spuConfigVO.getReferenceCode(), spuConfigVO);
					}
				}
			} else {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，兑换商品包未包含商品.");
			}

		}
		return exchgSpuConfigMap;
	}

	/**
	 * 参团下单
	 * 
	 * @param orderConfirmDTO
	 */
	public Boolean orderCreateForJoinGroupon(OrderConfirmDTO orderConfirmDTO, Long memberId, String deviceId,
			String orderCode, int leftNumber, Map<String, Integer> limitMap, String groupId) {
		logger.info("execute  orderJoinForGroupon 团号 groupId={}", groupId);
		Boolean state = false;

		OpChannelVO opChannel = mcOpChannelService.findByCode("CHN2078");
		MemberVO member = memberQueryService.getById(memberId);
		AccessWayEnum accessWay = AccessWayEnum.APPLET;
		List<RequestPack> requestpacks = orderConfirmDTO.getPacks();
		if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestpacks)) {
			OrderCreateVO oldOrderCreate = new OrderCreateVO();
			oldOrderCreate.setPaymentType(4);// 小程序参团微信支付
			oldOrderCreate.setGroupbuy(false);
			oldOrderCreate.setOrderBusinessType(OrderBusinessType.GROUPON);
			oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
			oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
			oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
			// =============商品包=============
			List<CartProductPack> packs = Lists.newArrayList();
			List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestpacks,
					accessWay, member, opChannel.getCode());
			packs.addAll(prodPacks);
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			// 预售商库存
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();

			Map<String, SPresaleVO> sPresaleMap = new HashMap<>();

			// 商品验证
			orderCommonAdapter.checkPack(packs, opChannel, member, oldOrderCreate, sPresaleMap, sPresaleSaleInvMap,
					orderConfirmDTO);

			// =========是否包含海外购商品===========
			boolean isHasOverSea = overseaService.isOversea(packs);
			// =============APP下载来源============
			oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
			// =============渠道编号=============
			oldOrderCreate.setChannelCode(opChannel.getCode());
			// ==============会员id=============
			if (member != null) {
				oldOrderCreate.setCustomerId(member.getId());
			}

			// =============地址=============

			com.thebeastshop.member.vo.MemberAddressVO address = null;
			if (orderConfirmDTO.getAddressId() > 0) {
				address = memberAddressService.getById(orderConfirmDTO.getAddressId());
				if (address != null) {
					AddressVO deliveryAddress = new AddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setCircuit(address.getCircuitDesc());
					deliveryAddress.setDistrictId(address.getDistrict().getId());
					deliveryAddress.setDistrict(address.getDistrict().getName());
					deliveryAddress.setCompanyName(address.getCompanyName());
					deliveryAddress.setMemberId(address.getMemberId());
					deliveryAddress.setZip(address.getZipCode());
					deliveryAddress.setPhone(address.getReceiverPhone());
					deliveryAddress.setName(address.getReceiver());
					deliveryAddress.setMagentoTitle(address.getTitle());
					deliveryAddress.setStreet(address.getAddress());
					oldOrderCreate.setDeliveryAddress(deliveryAddress);
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
							"当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
				}
			}

			oldOrderCreate.setDeviceId(deviceId);

			// =============是否匿名购买=============
			oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
			// =============是否使用生日折扣=============
			oldOrderCreate.setUseBdayDiscount(false);
			// =============卡片内容 卡片类型，0不需要1空白2代写=============
			OrderCard card = orderConfirmDTO.getNewCard();
			oldOrderCreate.setNoteCard(card.getType().getCode());
			oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
			oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
			oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));

			// =============配送日期=============
			oldOrderCreate.setDeliveryDate(orderConfirmDTO.getDeliveryDate());
			// =============配送时段=============
			TimeSlot timeSlot = timeSlotService.getById(orderConfirmDTO.getDeliveryTimeSlot());
			// 兼容小程序
			if (timeSlot != null)
				oldOrderCreate.setLimitedHour(timeSlot.getText());
			else {
				oldOrderCreate.setLimitedHour(orderConfirmDTO.getDeliveryTime());
			}

			List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
			PrsCalPackDto arg0 = new PrsCalPackDto();
			BigDecimal customPostage = null;
			// 如果是线下，用线下传进来的运费
			if (opChannel.getChannelType() == 1) {
				customPostage = BigDecimal.ZERO;
				if (null != orderConfirmDTO.getPostage() && null != orderConfirmDTO.getPostage().getNormal()) {
					customPostage = orderConfirmDTO.getPostage().getNormal();
				}
			}
			List<Integer> interestId = new ArrayList<Integer>();

			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			boolean birthday = false;

			BigDecimal remotePostage = BigDecimal.ZERO;

			if (null != orderConfirmDTO.getDeliveryPrice()
					&& orderConfirmDTO.getDeliveryPrice().compareTo(BigDecimal.ZERO) > 0) {
				remotePostage = orderConfirmDTO.getDeliveryPrice();
			}

			priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
					customPostage, remotePostage, interestId, birthday, giftCard, null);

			if (!StringUtils.isBlank(orderConfirmDTO.getDeliveryTime())) {

				logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderConfirmDTO.getDeliveryTime());
				DeliveryInfoDTO dto = new DeliveryInfoDTO();
				dto.setDistrictId(address.getDistrict().getId().intValue());
				List<PsProductVO> products = new ArrayList<PsProductVO>();
				for (ProductPack pack : packs) {
					// 联邦或店送时，需要取得配送日期
					if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
						products.add(pack.getProduct());
					}
				}
				Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
				List<String> skuCodeList = new ArrayList<String>();
				for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
					for (PsSkuVO sku : entry.getValue()) {
						skuCodeList.add(sku.getSkuCode());
					}
				}
				dto.setSkuCodeList(skuCodeList);

				Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
				for (ProductPack pack : packs) {
					PsProductVO psProduct = pack.getProduct();
					if (products.contains(psProduct)) {
						String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
						skuCountMap.put(skucode, pack.getCount());
					}
				}
				dto.setSkuCountMap(skuCountMap);

				arg0.setSelectedTimeDelivery(false);
				ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);
				if (resp.isSuccess()) {
					DeliveryInfoVO vo = resp.getBean();
					logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
					arg0.setSelectedTimeDelivery(true);
					arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
				}
			}
			DeliverableVO deliverableTime = logisticsAdapter.getDeliverablePrice(packs, address, member, accessWay,
					opChannel, orderConfirmDTO.getPostage(), isHasOverSea, BigDecimal.ZERO);

			PostageVO postageVO = new PostageVO();
			if (deliverableTime != null) {
				postageVO = deliverableTime.getPostage();
			}
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					arg0.setRemoteDeliveryFee(deliveryFee);
				}
			}

			logger.info("订单确认价格计算");

			PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4GroupBuy(arg0);

			logger.info("价格计算查询 requestId={}", priceResult.getRequestId());
			// 运费
			BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());

			postageVO.setNormal(postage);
			if (null != deliverableTime && null != deliverableTime.getPostage()) {
				deliverableTime.getPostage().setNormal(postage);
			}
			// 先去看架构有没有用免邮权益
			if (CollectionUtils.isNotEmpty(interestId)) {
				// 如果使用了免邮权益，那么传给张天琪
				if (priceAdapter.getPostageInterest(priceResult.getPriceStepVOs())) {

					OrderCreateVO.InterestsVO interestsVO = oldOrderCreate.new InterestsVO();
					interestsVO.setId(interestId.get(0));
					oldOrderCreate.setInterestsVO(interestsVO);
				}

			}

			if (isHasOverSea) {
				// =========设置海淘标记=========
				oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
				// =========设置身份证信息=========
				if (member != null && address != null) {
					MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(),
							address.getReceiver());
					if (memIdCardVO != null) {
						IdCardVO idCardVO = new IdCardVO();
						idCardVO.setAuditStatus(memIdCardVO.getImgStatus());
						idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
						idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
						idCardVO.setIdNumber(memIdCardVO.getIdNumber());
						idCardVO.setImgStatus(memIdCardVO.getImgStatus());
						idCardVO.setName(memIdCardVO.getName());
						oldOrderCreate.setIdCardVO(idCardVO);
					}
				}
			}

			// ==================== 给张天琪的相关信息======================

			// 给packs重新塞价格
			Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
			for (CartProductPack pack : packs) {
				pack.getSpv().setDiscountPrice(spvMap.get(pack.getSpvId()));
			}
			oldOrderCreate.setPacks(packs);
			// // 给张天琪兑换积分信息
			// oldOrderCreate.setExchangeMap(new HashMap<Long, Integer>());

			// 给张天琪的占库存实体
			SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO = new SGroupbuyParterOccupyDTO();
			SGroupbuyInfoVO sGroupbuyInfoVO = new SGroupbuyInfoVO();
			PsCampaignVO campaign = null;
			for (PsCampaignVO camp : packs.get(0).getSpv().getCampaignList()) {
				if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
					campaign = new PsCampaignVO();
					campaign = camp;
				}
			}
			sGroupbuyInfoVO.setGroupNumber(campaign.getGroupNumber());
			sGroupbuyInfoVO.setMinUnit(campaign.getMinUnit());
			sGroupbuyInfoVO.setGroupbuyId(groupId);
			sGroupbuyInfoVO.setAvailNumber(leftNumber);

			sGroupbuyParterOccupyDTO.setGroupbuyInfo(sGroupbuyInfoVO);

			List<SGroupbuyLimitInfoVO> sGroupbuyLimitInfoVOs = new ArrayList<SGroupbuyLimitInfoVO>();
			for (Entry<String, Integer> entry : limitMap.entrySet()) {
				SGroupbuyLimitInfoVO sGroupbuyLimitInfoVO = new SGroupbuyLimitInfoVO(entry.getKey(), entry.getValue());
				sGroupbuyLimitInfoVOs.add(sGroupbuyLimitInfoVO);
			}

			sGroupbuyParterOccupyDTO.setGroupbuyLimitInfoList(sGroupbuyLimitInfoVOs);
			sGroupbuyParterOccupyDTO.setSelectedSkuCode(packs.get(0).getSpv().getSkuCode());

			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
			// Map<String, Integer> checkPanicPerUserLeftMap = new
			// HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
						if (member != null) {
							campaignStreamVO.setMemberCode(member.getCode());
						}
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}

				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			// 换购商品map,key:换购商品spvId，value:活动code Map<Long, String>： addPacks
			Map<Long, String> addiblePacks = priceAdapter.getAdds(priceResult.getPriceStepVOs(), packs);

			// 主品（spvid作为key）对应的赠品Map<Long,List<CartProductPack>> ： giftPackMap

			Map<Long, List<Long>> giftMap = priceAdapter.blindGift(singleGiftMap, mutiGiftMap);

			Map<Long, Integer> giftSizeMap = priceAdapter.getGiftSize(singleGiftMap, mutiGiftMap);

			Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
			List<CartProductPack> giftPacks = priceAdapter.getGifts(packs);
			if (CollectionUtils.isNotEmpty(giftPacks)) {
				if (null != giftMap && giftMap.size() > 0) {
					// if (CollectionUtils.isNotEmpty(giftPacks)) {

					for (Map.Entry<Long, List<Long>> gift : giftMap.entrySet()) {
						if (CollectionUtils.isNotEmpty(gift.getValue())) {
							List<CartProductPack> resultList = new ArrayList<CartProductPack>();
							for (Long productId : gift.getValue()) {
								for (CartProductPack gif : giftPacks) {// 取一个删一个，防止出现同一个product下多个spv赠品
									if (productId.equals(gif.getProductId())) {
										logger.info("给赠品塞数量，赠品productId = {}", productId);
										if (giftSizeMap.containsKey(productId)) {

											logger.info("，赠品productId = {}的实际数量为 count={}", productId,
													giftSizeMap.get(productId));
											gif.setCount(giftSizeMap.get(productId));
										} else {
											logger.info("，赠品productId = {}没有数量", productId);
										}
										resultList.add(gif);
										giftPacks.remove(gif);
										break;
									}
								}

							}
							if (CollectionUtils.isNotEmpty(resultList)) {
								giftPackMap.put(gift.getKey(), resultList);
							}
						}
					}
				}

			} else {// 前端如果不带赠品来，后端塞赠品
				if (!singleGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap,
							stockMap, checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack
					for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}

				if (!mutiGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
							checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

					for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}
			}

			oldOrderCreate.setAddiblePacks(addiblePacks);
			// oldOrderCreate.setCampaignMap(campaignMap);
			oldOrderCreate.setGiftPackMap(giftPackMap);
			oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
			oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());
			// oldOrderCreate.setInterestGoodsMap(interestGoodsMap);
			// oldOrderCreate.setServiceStep(priceAdapter.setServiceStep(priceResult.getPriceStepVOs()));
			// =============支付金额=============

			BigDecimal payment = priceResult.getFinalTotalPrice();

			// 转换精度后比较
			if (payment.subtract(orderConfirmDTO.getPrice()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
				throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE, "商品支付价格有误," + payment);
			}

			oldOrderCreate.setActualPayFee(orderConfirmDTO.getPrice());

			// 礼品卡信息
			oldOrderCreate.setOpSalesOrderGiftCardVOs(priceAdapter.getGiftCardList(priceResult.getPriceStepVOs()));

			// =============客户备注===========
			oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
			// 投放来源
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());

			// 配送方式，0非快递1快递
			if (orderConfirmDTO.getAddressId() > 0) {
				oldOrderCreate.setDeliveryType(1);
			} else {
				oldOrderCreate.setDeliveryType(0);
			}
			if (CollectionUtils.isEmpty(oldOrderCreate.getPacks())) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，商品包未包含商品.");
			}
			oldOrderCreate.setOrderCode(orderCode);
			oldOrderCreate.setsGroupbuyParterOccupyDTO(sGroupbuyParterOccupyDTO);
			logger.info("去张天琪那里下单");
			OpSalesOrderResponseVO orderResp = null;
			try {
				// 调用方法了
				final OpSalesOrderVO opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay,
						member, opChannel, sPresaleMap, sPresaleSaleInvMap);
				orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);
			} catch (Exception e) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，创建订单失败." + e.getMessage());
			}

			if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {

				// 保存订单快照
				if (StringUtils.isNotBlank(orderCode)) {

					snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(), "");// 参团没有优惠券

				}
				if (member != null) {
					// 如果用户未设置默认地址，则这次订单地址设为默认地址
					com.thebeastshop.member.vo.MemberAddressVO memberAddress = memberAddressService
							.getDefaultByOwnerId(member.getId());
					if (memberAddress == null && address != null) {
						address.setAsDefault(true);
						memberAddressService.update(address);
					}
				}
				state = true;
			}

		}
		return state;
	}

	/**
	 * 团购下单 （isOpen：true开团）
	 * 
	 * @param orderConfirmDTO
	 */
	public String orderCreateForGroupon(Boolean isOpen, OrderConfirmDTO orderConfirmDTO, Long memberId, String deviceId,
			String order, String openId, String avatar, OpChannelVO opChannel, AccessWayEnum accessWay, int leftNumber,
			String groupId) {
		logger.info("execute  orderCreateForGroupon");
		String orderCode = "";

		MemberVO member = memberQueryService.getById(memberId);
		List<RequestPack> requestpacks = orderConfirmDTO.getPacks();
		if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestpacks)) {
			OrderCreateVO oldOrderCreate = new OrderCreateVO();
			oldOrderCreate.setGroupbuy(isOpen);
			oldOrderCreate.setOrderBusinessType(OrderBusinessType.GROUPON);
			oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
			oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
			oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
			oldOrderCreate.setTbsClient(orderConfirmDTO.getTbsClient());
			oldOrderCreate.setTbsUSource(orderConfirmDTO.getTbsUSource());
			oldOrderCreate.setPlatForm(orderConfirmDTO.getPlatForm());
			// =============商品包=============
			List<CartProductPack> packs = Lists.newArrayList();
			List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestpacks,
					accessWay, member, opChannel.getCode());
			packs.addAll(prodPacks);
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			// 预售商库存
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();

			Map<String, SPresaleVO> sPresaleMap = new HashMap<>();

			// 商品验证
			orderCommonAdapter.checkPack(packs, opChannel, member, oldOrderCreate, sPresaleMap, sPresaleSaleInvMap,
					orderConfirmDTO);

			// =========是否包含海外购商品===========
			boolean isHasOverSea = overseaService.isOversea(packs);
			// =============APP下载来源============
			oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
			// =============渠道编号=============
			oldOrderCreate.setChannelCode(opChannel.getCode());
			// ==============会员id=============
			if (member != null) {
				oldOrderCreate.setCustomerId(member.getId());
			}

			// =============地址=============

			com.thebeastshop.member.vo.MemberAddressVO address = null;
			if (orderConfirmDTO.getAddressId() > 0) {
				address = memberAddressService.getById(orderConfirmDTO.getAddressId());
				if (address != null) {
					AddressVO deliveryAddress = new AddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setCircuit(address.getCircuitDesc());
					deliveryAddress.setDistrictId(address.getDistrict().getId());
					deliveryAddress.setDistrict(address.getDistrict().getName());
					deliveryAddress.setCompanyName(address.getCompanyName());
					deliveryAddress.setMemberId(address.getMemberId());
					deliveryAddress.setZip(address.getZipCode());
					deliveryAddress.setPhone(address.getReceiverPhone());
					deliveryAddress.setName(address.getReceiver());
					deliveryAddress.setMagentoTitle(address.getTitle());
					deliveryAddress.setStreet(address.getAddress());
					oldOrderCreate.setDeliveryAddress(deliveryAddress);
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
							"当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
				}
			}

			if (isOpen) {
				// 先去小飞那里开团
				GroupBuyRecordVO groupBuyRecordVO = new GroupBuyRecordVO();

				groupBuyRecordVO.setAvatar(avatar);
				CartProductPack cartProductPack = packs.get(0);
				for (PsCampaignVO camp : cartProductPack.getSpv().getCampaignList()) {
					if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
						groupBuyRecordVO.setCampaignCode(camp.getCode());
						groupBuyRecordVO.setCampaignId(camp.getId());
					}
				}
				groupBuyRecordVO.setCount(cartProductPack.getCount());
				groupBuyRecordVO.setGroupId(orderConfirmDTO.getGrouponId());
				groupBuyRecordVO.setMemberCode(member.getCode());
				groupBuyRecordVO.setMemberName(member.getNickName());
				groupBuyRecordVO.setOrderCode(order);
				groupBuyRecordVO.setProductCode(cartProductPack.getProduct().getCode());
				groupBuyRecordVO.setProductName(cartProductPack.getProduct().getNameCn());
				groupBuyRecordVO.setSkuCode(cartProductPack.getSpv().getSkuCode());
				groupBuyRecordVO.setSkuName(cartProductPack.getSpv().getSkuVO().getSkuNameCN());
				groupBuyRecordVO.setOpenId(openId);
				ServiceResp<GroupBuyResultVO> openResp = groupBuyService.openGroupBuy(groupBuyRecordVO);

				if (openResp.isFailure()) {
					throw new ChannelException(openResp.getRespCode(), "活动开团失败" + openResp.getRespMsg());
				}

				GroupBuyResultVO resuletVO = openResp.getBean();
				groupId = resuletVO.getGroupId();
				logger.info("参团落地成功 团号 groupId={}", groupId);
			}
			oldOrderCreate.setDeviceId(deviceId);

			// =============是否匿名购买=============
			oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
			// =============是否使用生日折扣=============
			oldOrderCreate.setUseBdayDiscount(false);
			// =============卡片内容 卡片类型，0不需要1空白2代写=============
			OrderCard card = orderConfirmDTO.getNewCard();
			oldOrderCreate.setNoteCard(card.getType().getCode());
			oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
			oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
			oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));

			// =============配送日期=============
			oldOrderCreate.setDeliveryDate(orderConfirmDTO.getDeliveryDate());
			// =============配送时段=============
			TimeSlot timeSlot = timeSlotService.getById(orderConfirmDTO.getDeliveryTimeSlot());
			// 兼容小程序
			if (timeSlot != null)
				oldOrderCreate.setLimitedHour(timeSlot.getText());
			else {
				oldOrderCreate.setLimitedHour(orderConfirmDTO.getDeliveryTime());
			}

			List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
			PrsCalPackDto arg0 = new PrsCalPackDto();
			BigDecimal customPostage = null;
			// 如果是线下，用线下传进来的运费
			if (opChannel.getChannelType() == 1) {
				customPostage = BigDecimal.ZERO;
				if (null != orderConfirmDTO.getPostage() && null != orderConfirmDTO.getPostage().getNormal()) {
					customPostage = orderConfirmDTO.getPostage().getNormal();
				}
			}
			List<Integer> interestId = new ArrayList<Integer>();

			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			boolean birthday = false;

			BigDecimal remotePostage = BigDecimal.ZERO;

			if (null != orderConfirmDTO.getDeliveryPrice()
					&& orderConfirmDTO.getDeliveryPrice().compareTo(BigDecimal.ZERO) > 0) {
				remotePostage = orderConfirmDTO.getDeliveryPrice();
			}

			priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
					customPostage, remotePostage, interestId, birthday, giftCard, null);

			if (!StringUtils.isBlank(orderConfirmDTO.getDeliveryTime())) {

				logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderConfirmDTO.getDeliveryTime());
				DeliveryInfoDTO dto = new DeliveryInfoDTO();
				dto.setDistrictId(address.getDistrict().getId().intValue());
				List<PsProductVO> products = new ArrayList<PsProductVO>();
				for (ProductPack pack : packs) {
					// 联邦或店送时，需要取得配送日期
					if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
						products.add(pack.getProduct());
					}
				}
				Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
				List<String> skuCodeList = new ArrayList<String>();
				for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
					for (PsSkuVO sku : entry.getValue()) {
						skuCodeList.add(sku.getSkuCode());
					}
				}
				dto.setSkuCodeList(skuCodeList);

				Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
				for (ProductPack pack : packs) {
					PsProductVO psProduct = pack.getProduct();
					if (products.contains(psProduct)) {
						String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
						skuCountMap.put(skucode, pack.getCount());
					}
				}
				dto.setSkuCountMap(skuCountMap);

				arg0.setSelectedTimeDelivery(false);
				ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);
				if (resp.isSuccess()) {
					DeliveryInfoVO vo = resp.getBean();
					logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
					arg0.setSelectedTimeDelivery(true);
					arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
				}
			}
			DeliverableVO deliverableTime = logisticsAdapter.getDeliverablePrice(packs, address, member, accessWay,
					opChannel, orderConfirmDTO.getPostage(), isHasOverSea, BigDecimal.ZERO);

			PostageVO postageVO = new PostageVO();
			if (deliverableTime != null) {
				postageVO = deliverableTime.getPostage();
			}
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					arg0.setRemoteDeliveryFee(deliveryFee);
				}
			}

			logger.info("订单确认价格计算");

			PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4GroupBuy(arg0);

			logger.info("价格计算查询 requestId={}", priceResult.getRequestId());
			// 运费
			BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());

			postageVO.setNormal(postage);
			if (null != deliverableTime && null != deliverableTime.getPostage()) {
				deliverableTime.getPostage().setNormal(postage);
			}
			// 先去看架构有没有用免邮权益
			if (CollectionUtils.isNotEmpty(interestId)) {
				// 如果使用了免邮权益，那么传给张天琪
				if (priceAdapter.getPostageInterest(priceResult.getPriceStepVOs())) {

					OrderCreateVO.InterestsVO interestsVO = oldOrderCreate.new InterestsVO();
					interestsVO.setId(interestId.get(0));
					oldOrderCreate.setInterestsVO(interestsVO);
				}

			}

			if (isHasOverSea) {
				// =========设置海淘标记=========
				oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
				// =========设置身份证信息=========
				if (member != null && address != null) {
					MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(),
							address.getReceiver());
					if (memIdCardVO != null) {
						IdCardVO idCardVO = new IdCardVO();
						idCardVO.setAuditStatus(memIdCardVO.getImgStatus());
						idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
						idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
						idCardVO.setIdNumber(memIdCardVO.getIdNumber());
						idCardVO.setImgStatus(memIdCardVO.getImgStatus());
						idCardVO.setName(memIdCardVO.getName());
						oldOrderCreate.setIdCardVO(idCardVO);
					}
				}
			}

			// ==================== 给张天琪的相关信息======================

			// 给packs重新塞价格
			Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
			for (CartProductPack pack : packs) {
				pack.getSpv().setDiscountPrice(spvMap.get(pack.getSpvId()));
			}
			oldOrderCreate.setPacks(packs);
			// // 给张天琪兑换积分信息
			// oldOrderCreate.setExchangeMap(new HashMap<Long, Integer>());

			// 给张天琪的占库存实体
			SGroupbuyOwnerOccupyDTO sGroupbuyOwnerOccupyDTO = new SGroupbuyOwnerOccupyDTO();
			SGroupbuyInfoVO sGroupbuyInfoVO = new SGroupbuyInfoVO();
			PsCampaignVO campaign = null;
			for (PsCampaignVO camp : packs.get(0).getSpv().getCampaignList()) {
				if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
					campaign = new PsCampaignVO();
					campaign = camp;
				}
			}
			sGroupbuyInfoVO.setGroupNumber(campaign.getGroupNumber());
			sGroupbuyInfoVO.setMinUnit(campaign.getMinUnit());
			sGroupbuyInfoVO.setGroupbuyId(groupId);

			sGroupbuyOwnerOccupyDTO.setGroupbuyInfo(sGroupbuyInfoVO);

			List<SGroupbuyLimitInfoVO> sGroupbuyLimitInfoVOs = new ArrayList<SGroupbuyLimitInfoVO>();

			ServiceResp<Map<String, Integer>> limitResp = campaignLimitService
					.getGroupBuySkuLeftLimit(campaign.getCode(), packs.get(0).getProduct().getSkuCodes());

			if (limitResp.isFailure()) {
				throw new ChannelException(limitResp.getRespCode(), "查询活动限量失败" + limitResp.getRespMsg());

			}

			Map<String, Integer> limitMap = limitResp.getBean();

			for (Entry<String, Integer> entry : limitMap.entrySet()) {
				SGroupbuyLimitInfoVO sGroupbuyLimitInfoVO = new SGroupbuyLimitInfoVO(entry.getKey(), entry.getValue());
				sGroupbuyLimitInfoVOs.add(sGroupbuyLimitInfoVO);
			}

			sGroupbuyOwnerOccupyDTO.setGroupbuyLimitInfoList(sGroupbuyLimitInfoVOs);
			sGroupbuyOwnerOccupyDTO.setSelectedSkuCode(packs.get(0).getSpv().getSkuCode());
			sGroupbuyOwnerOccupyDTO.setSkuCodeList(packs.get(0).getProduct().getSkuCodes());

			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
			// Map<String, Integer> checkPanicPerUserLeftMap = new
			// HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
						if (member != null) {
							campaignStreamVO.setMemberCode(member.getCode());
						}
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}

				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			// 换购商品map,key:换购商品spvId，value:活动code Map<Long, String>： addPacks
			Map<Long, String> addiblePacks = priceAdapter.getAdds(priceResult.getPriceStepVOs(), packs);

			// 主品（spvid作为key）对应的赠品Map<Long,List<CartProductPack>> ： giftPackMap

			Map<Long, List<Long>> giftMap = priceAdapter.blindGift(singleGiftMap, mutiGiftMap);

			Map<Long, Integer> giftSizeMap = priceAdapter.getGiftSize(singleGiftMap, mutiGiftMap);

			Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
			List<CartProductPack> giftPacks = priceAdapter.getGifts(packs);
			if (CollectionUtils.isNotEmpty(giftPacks)) {
				if (null != giftMap && giftMap.size() > 0) {
					// if (CollectionUtils.isNotEmpty(giftPacks)) {

					for (Map.Entry<Long, List<Long>> gift : giftMap.entrySet()) {
						if (CollectionUtils.isNotEmpty(gift.getValue())) {
							List<CartProductPack> resultList = new ArrayList<CartProductPack>();
							for (Long productId : gift.getValue()) {
								for (CartProductPack gif : giftPacks) {// 取一个删一个，防止出现同一个product下多个spv赠品
									if (productId.equals(gif.getProductId())) {
										logger.info("给赠品塞数量，赠品productId = {}", productId);
										if (giftSizeMap.containsKey(productId)) {

											logger.info("，赠品productId = {}的实际数量为 count={}", productId,
													giftSizeMap.get(productId));
											gif.setCount(giftSizeMap.get(productId));
										} else {
											logger.info("，赠品productId = {}没有数量", productId);
										}
										resultList.add(gif);
										giftPacks.remove(gif);
										break;
									}
								}

							}
							if (CollectionUtils.isNotEmpty(resultList)) {
								giftPackMap.put(gift.getKey(), resultList);
							}
						}
					}
				}

			} else {// 前端如果不带赠品来，后端塞赠品
				if (!singleGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap,
							stockMap, checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack
					for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}

				if (!mutiGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
							checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

					for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}
			}

			oldOrderCreate.setAddiblePacks(addiblePacks);
			// oldOrderCreate.setCampaignMap(campaignMap);
			oldOrderCreate.setGiftPackMap(giftPackMap);
			oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
			oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());
			// oldOrderCreate.setInterestGoodsMap(interestGoodsMap);
			// oldOrderCreate.setServiceStep(priceAdapter.setServiceStep(priceResult.getPriceStepVOs()));
			// =============支付金额=============

			BigDecimal payment = priceResult.getFinalTotalPrice();

			// 转换精度后比较
			if (payment.subtract(orderConfirmDTO.getPrice()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
				throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE, "商品支付价格有误," + payment);
			}
			// if (payment.setScale(2, RoundingMode.HALF_UP)
			// .compareTo(orderConfirmDTO.getPrice().setScale(2,
			// RoundingMode.HALF_UP)) > 0) {
			// throw new
			// ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE,
			// "商品支付价格有误," + payment);
			// }

			oldOrderCreate.setActualPayFee(orderConfirmDTO.getPrice());

			// 礼品卡信息
			oldOrderCreate.setOpSalesOrderGiftCardVOs(priceAdapter.getGiftCardList(priceResult.getPriceStepVOs()));

			// =============客户备注===========
			oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
			// 投放来源
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());

			// 配送方式，0非快递1快递
			if (orderConfirmDTO.getAddressId() > 0) {
				oldOrderCreate.setDeliveryType(1);
			} else {
				oldOrderCreate.setDeliveryType(0);
			}
			if (CollectionUtils.isEmpty(oldOrderCreate.getPacks())) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，商品包未包含商品.");
			}
			oldOrderCreate.setOrderBusinessType(orderConfirmDTO.getOrderType());
			if (isOpen) {
				oldOrderCreate.setsGroupbuyOwnerOccupyDTO(sGroupbuyOwnerOccupyDTO);
			} else {
				// 给张天琪的占库存实体
				SGroupbuyParterOccupyDTO sGroupbuyParterOccupyDTO = new SGroupbuyParterOccupyDTO();
				for (PsCampaignVO camp : packs.get(0).getSpv().getCampaignList()) {
					if (camp.getDiscountTypeId().equals(DiscountTypeEnum.GROUP_BUY.getId())) {
						campaign = new PsCampaignVO();
						campaign = camp;
					}
				}
				sGroupbuyInfoVO.setGroupNumber(campaign.getGroupNumber());
				sGroupbuyInfoVO.setMinUnit(campaign.getMinUnit());
				logger.info("groupId=" + groupId);
				sGroupbuyInfoVO.setGroupbuyId(groupId);
				sGroupbuyInfoVO.setAvailNumber(leftNumber);

				sGroupbuyParterOccupyDTO.setGroupbuyInfo(sGroupbuyInfoVO);
				for (Entry<String, Integer> entry : limitMap.entrySet()) {
					SGroupbuyLimitInfoVO sGroupbuyLimitInfoVO = new SGroupbuyLimitInfoVO(entry.getKey(),
							entry.getValue());
					sGroupbuyLimitInfoVOs.add(sGroupbuyLimitInfoVO);
				}

				sGroupbuyParterOccupyDTO.setGroupbuyLimitInfoList(sGroupbuyLimitInfoVOs);
				sGroupbuyParterOccupyDTO.setSelectedSkuCode(packs.get(0).getSpv().getSkuCode());
				oldOrderCreate.setsGroupbuyParterOccupyDTO(sGroupbuyParterOccupyDTO);
			}
			oldOrderCreate.setOrderCode(order);
			OpSalesOrderResponseVO orderResp = null;
			OpSalesOrderVO opSalesOrderVO = null;
			try {
				// 调用方法了
				opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay, member, opChannel,
						sPresaleMap, sPresaleSaleInvMap);
				orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);

			} catch (Exception e) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，创建订单失败." + e.getMessage());
			}
			if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {

				orderCode = orderResp.getOrderCode();
				// 如果订单中有配方商品需要占用库存，如果占用失败，将订单改为不可见
				if (CollectionUtils.isNotEmpty(opSalesOrderVO.getCustomizeInvList())
						&& opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					try {
						sPrdcJobService.createAllotOrPrdcJob(opSalesOrderVO.getCustomizeInvList());
					} catch (Exception e) {

						pcInstance.deleteSalesOrder(opSalesOrderVO.getMemberCode(), orderCode, "配方定制商品库存占用失败,订单隐藏");
						logger.info(e.getMessage());
						logger.info("配方定制商品库存占用失败，orderCode:" + opSalesOrderVO.getCode());
						throw new ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE, "配方定制商品库存不足");
					}
				}

				// 保存订单快照
				if (StringUtils.isNotBlank(orderCode)) {

					snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(), "");// 开团下单没有优惠券

				}
				if (member != null) {
					// 如果用户未设置默认地址，则这次订单地址设为默认地址
					com.thebeastshop.member.vo.MemberAddressVO memberAddress = memberAddressService
							.getDefaultByOwnerId(member.getId());
					if (memberAddress == null && address != null) {
						address.setAsDefault(true);
						memberAddressService.update(address);
					}
				}
			} else {
				logger.info("张天琪下单失败");
				return "";
			}

		}
		return groupId;
	}
}
