package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.course.service.FrontBeastCourseService;
import com.thebeastshop.course.vo.FrontBeastCourseVO;
import com.thebeastshop.course.vo.FrontBeastSessionVO;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.payment.dto.PIntegralPaymentDTO;
import com.thebeastshop.payment.service.PPaymentService;
import com.thebeastshop.payment.vo.PPaymentTradeVO;
import com.thebeastshop.pegasus.channelservice.adapter.ComOrderAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.lesson.BeastLessonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
import com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsCartSettleLabelVO;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.price.vo.PrsProductPackVO;
import com.thebeastshop.price.vo.PrsSkuPriceStepVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.lesson.CourseTime;
import com.thebeastshop.support.vo.order.OrderCard;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderConfirmVO.BdayVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;

/**
 * 新价格计算订单适配器
 *
 * @author Wang Yawei
 */
@Component("appOrderLessonAdapter")
public class OrderLessonAdapter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SnapshotAdapter snapshotAdapter;

    private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

    @Autowired
    private OrderCommonAdapter orderCommonAdapter;

    @Autowired
    private ComOrderAdapter comOrderAdapter;

    @Autowired
    private PrsPriceService prsPriceService;


    @Autowired
    private PriceAdapter priceAdapter;

    @Autowired
    private CartProductPackAdapter cartProductPackAdapter;

    @Autowired
    private PPaymentService pPaymentService;

    @Autowired
    BeastLessonAdapter beastLessonAdapter;

	@Autowired
	private FrontBeastCourseService frontBeastCourseService;
	
	@Autowired
	private MemberPointService memberPointService;

    /**
     * 预览订单
     *
     * @param orderPreview
     * @param paramPack
     * @param beastCourse
     * @param member
     * @param opChannel
     * @param accessWay
     * @return
     */
    public OrderConfirmVO getOrderPreview(OrderPreviewDTO orderPreview, CartProductPack paramPack, FrontBeastCourseVO beastCourse,
                                          MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {


        // 是否使用生日折扣
        Boolean birthday = true;
        if (null != orderPreview.isUseBdayDiscount()) {
            birthday = orderPreview.isUseBdayDiscount();
        }
        // 是否适用积分抵扣
        Boolean usePointDeduct = orderPreview.getUsePointDeduct();
        Map<Long, FrontBeastSessionVO> spvBeastSessionMap = beastLessonAdapter.getSpvAndSessionMap(beastCourse);
        FrontBeastSessionVO beastSessionVO = spvBeastSessionMap.get(paramPack.getSpvId());

        // 校验库存
        if (beastSessionVO.getSessionRemainNum() < paramPack.getCount()) {
            logger.error("spvID:" + paramPack.getSpvId() + "库存不足");
            throw new ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE, "当前场次剩余名额不足，换换其他场次试试");
        }


        OrderConfirmVO rt = new OrderConfirmVO();
        rt.setOrderType(orderPreview.getOrderType());
        rt.setContactPhone(orderPreview.getContactPhone());
        rt.setContactPerson(orderPreview.getContactPhone());
        rt.setBday(this.getHasBdayDiscount(member,paramPack.getProduct()));


        //价格计算
        PrsCalPackDto arg0 = new PrsCalPackDto();
        List<Integer> interestId = new ArrayList<>();
        Map<Long, InterestGoods> interestGoodsMap = new HashMap<>();
        priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, Lists.newArrayList(paramPack), member, opChannel, accessWay, null, null,
                BigDecimal.ZERO, interestId, birthday, null, null);
        // arg0 设置积分兑换内容
        PrsProductPackVO prsProductPackVO = arg0.getPackList().get(0);
        prsProductPackVO.setPointExchange(usePointDeduct);
        prsProductPackVO.setPoints(beastSessionVO.getPoint().intValue());
        prsProductPackVO.setPointDeductPrice(beastSessionVO.getPointDeductPrice());
        PrsPacksPriceResultVO priceResult = prsPriceService.calculatePointDeduct4Preview(arg0);

        logger.info("下单价格计算查询 requestId={}", priceResult.getRequestId());

        Map<String, Date> spvPresaleDateMap = new HashMap<>();
        Map<PsSpvVO, List<Label>> spvLabelMap = new HashMap<>();
        Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

        List<CartProductPackVO> packVOs = priceAdapter.getCartProductPackList(Arrays.asList(paramPack), member, opChannel, false, false,
                false, accessWay, birthday, spvPresaleDateMap, interestGoodsMap,
                new HashMap<>(), singleLabelMap, true, spvLabelMap);

        // 返回包设置
        CartProductPackVO packVo = packVOs.get(0);
        // 刷新价格
        packVo.getSpv().setPrice(priceResult.getSpvPriceMap().get(packVo.getSpv().getId()));
        CourseTime courseTime = new CourseTime();
        courseTime.setName(beastSessionVO.getProdName());
        courseTime.setCityName(beastSessionVO.getCityName());
        courseTime.setAddress(beastSessionVO.getDetailAddress());
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtil.format(beastSessionVO.getSessionStartTime(), "YYYY.MM.dd HH:mm"));
        sb.append("~");
        sb.append(DateUtil.format(beastSessionVO.getSessionEndTime(), "HH:mm"));
        courseTime.setOpenTime(sb.toString());
        packVo.setCourseTime(courseTime);
        rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));

        // ==============商品包================
        rt.setPacks(packVOs);

        Collection<PriceStepVO> priceSteps = priceAdapter.getPriceSteps(priceResult, member.getMemberLevelDesc(), "");
        rt.setPrice(priceResult.getFinalTotalPrice());
        rt.setPriceSteps(priceSteps);
        rt.setPointDeduct(getPointDeduct(beastSessionVO,paramPack));
        return rt;

    }

    /**
     * 获取积分抵扣对象
     * @param beastSession
     * @param paramPack
     * @return
     */
    private OrderConfirmVO.PointDeductVO getPointDeduct(FrontBeastSessionVO beastSession, CartProductPack paramPack) {
        if(beastSession != null && beastSession.getPoint().intValue() > 0){
            OrderConfirmVO.PointDeductVO pointDeduct = new OrderConfirmVO.PointDeductVO();
            pointDeduct.setCanUse(Boolean.TRUE);
            Integer point = beastSession.getPoint().multiply(BigDecimal.valueOf(paramPack.getCount())).intValue();
            // 抵扣金额取正
            BigDecimal deductPrice = beastSession.getPointDeductPrice().multiply(BigDecimal.valueOf(paramPack.getCount()));
            pointDeduct.setDeductPrice(deductPrice);
            pointDeduct.setPoint(point);
            return pointDeduct;
        }
        return null;
    }

    private BdayVO getHasBdayDiscount(MemberVO member , PsProductVO product) {
        BdayVO bday = null;
        if(BooleanUtils.toBoolean(product.getAllowBdDiscount())){
            if (member != null && member.getMemberLevel() != null
                    && !member.getMemberLevel().equals(MemberLevelEnum.NORMAL.getCode())
                    && member.isInBdayDiscountTime()) {
                // 不是注册用户的情况
                bday = new BdayVO();
                bday.setWithin(member.isInBdayDiscountTime());
                bday.setUsed(member.isBdayDiscountUsed());
                bday.setRatio(member.getBdayDiscountRatio());
            }
        }
        return bday;
    }

    /**
     * 新创建订单方法（价格计算）
     *
     * @param orderConfirmDTO
     * @throws ParseException
     */
    public String orderCreate(OrderConfirmDTO orderConfirmDTO, CartProductPack productPack, FrontBeastCourseVO beastCourse, MemberVO member, OpChannelVO opChannel,
                              AccessWayEnum accessWay, String deviceId) {
        logger.info("execute  _callOldOrderCreate");
        String orderCode = "";


        List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
        if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestPacks)) {
            OrderCreateVO oldOrderCreate = new OrderCreateVO();
            oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
            oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
            oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
            oldOrderCreate.setTbsClient(orderConfirmDTO.getTbsClient());
            oldOrderCreate.setTbsUSource(orderConfirmDTO.getTbsUSource());
            oldOrderCreate.setPlatForm(orderConfirmDTO.getPlatForm());
            // =============商品包=============
            List<CartProductPack> packs = Lists.newArrayList(productPack);

            // =============APP下载来源============
            oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
            oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
            // =============渠道编号=============
            oldOrderCreate.setChannelCode(opChannel.getCode());
            // ==============会员id=============
            if (member != null) {
                oldOrderCreate.setCustomerId(member.getId());
            }

            oldOrderCreate.setDeviceId(deviceId);

            // =============是否匿名购买=============
            oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
            // =============是否使用生日折扣=============
            oldOrderCreate.setUseBdayDiscount(orderConfirmDTO.isUseBdayDiscount());
            // =============卡片内容 卡片类型，0不需要1空白2代写=============
            OrderCard card = orderConfirmDTO.getNewCard();
            oldOrderCreate.setNoteCard(card.getType().getCode());
            oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
            oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
            oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));


            List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
            PrsCalPackDto arg0 = new PrsCalPackDto();

            boolean birthday = true;
            oldOrderCreate.setUseBdayDiscount(orderConfirmDTO.isUseBdayDiscount());
            if (!orderConfirmDTO.isUseBdayDiscount()) {
                logger.info("isUseBdayDiscount" + orderConfirmDTO.isUseBdayDiscount());
                birthday = false;
            }

            List<Integer> interestId = new ArrayList<>();
            Map<Long, InterestGoods> interestGoodsMap = new HashMap<>();
            priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
                    BigDecimal.ZERO, BigDecimal.ZERO, interestId, birthday, giftCard, null);

            /**
             * 设置积分兑换价格计算入参
             */
            PrsProductPackVO prsProductPackVO = arg0.getPackList().get(0);
            Map<Long, FrontBeastSessionVO> spvBeastSessionMap = beastLessonAdapter.getSpvAndSessionMap(beastCourse);
            FrontBeastSessionVO beastSessionVO = spvBeastSessionMap.get(prsProductPackVO.getSpvId());
            prsProductPackVO.setPointExchange(orderConfirmDTO.getUsePointDeduct());
            prsProductPackVO.setPoints(beastSessionVO.getPoint().intValue());
            prsProductPackVO.setPointDeductPrice(beastSessionVO.getPointDeductPrice());

            logger.info("订单确认价格计算");
            PrsPacksPriceResultVO priceResult = prsPriceService.calculatePointDeduct4Submit(arg0);
            logger.info("价格计算查询 requestId={}", priceResult.getRequestId());

            // 设置兑换积分
            Integer payPoint = 0;
            for (PrsPriceStepVO priceStep : priceResult.getPriceStepVOs()) {
                if (PrsPriceTypeEnum.POINTS_EXCHANGE.equals(priceStep.getPriceType())){
                    payPoint += priceStep.getPoints();
                }
            }
            oldOrderCreate.setActualPayPoint(BigDecimal.valueOf(payPoint));

            // 判断可用积分
            BigDecimal point = memberPointService.findCommonValidMemberLevelByparam(member.getId(),member.getCode());
            if(point ==null ){
                throw new WrongArgException("查询积分异常memberPointService.findCommonValidMemberLevelByparam(memberId)："+member.getId());
            }

            if(point.subtract(BigDecimal.valueOf(payPoint)).doubleValue() < 0){
                throw new WrongArgException("积分不足，实际可用积分:" + point+ ",当前使用积分:" + payPoint + ".");
            }
 		
            Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
            for (CartProductPack pack : packs) {
            	

            	// 判断课堂数量
 				ServiceResp<Integer> resp = frontBeastCourseService.getBeastSessionRemainNum(pack.getSpv().getSkuCode());
 				if(resp!=null && resp.getBean() != null){
 					
 					if(resp.getBean() < pack.getCount()){
 						throw new WrongArgException(pack.getSpv().getProductName() + "库存不足，实际库存:" + resp.getBean()
 						+ ",当前购买:" + pack.getCount() + ".");
 					}
 					
 				} else {
 					throw new WrongArgException("验证野兽课堂数量异常："+resp.getRespMsg());
 				}
            	
            	
            	
                if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
                    PsSpvVO spv = new PsSpvVO();
                    spv.setDiscountPrice(spvMap.get(pack.getSpvId()));
                    spv.setAdvanceCampaignList(pack.getSpv().getAdvanceCampaignList());
                    spv.setAdvancePrice(pack.getSpv().getAdvancePrice());
                    spv.setAttributeValuePairList(pack.getSpv().getAttributeValuePairList());
                    spv.setAttrs(pack.getSpv().getAttrs());
                    spv.setAttrValues(pack.getSpv().getAttrValues());
                    spv.setBdPriceCalResults(pack.getSpv().getBdPriceCalResults());
                    spv.setBdDiscountPrice(pack.getSpv().getBdDiscountPrice());
                    spv.setCampaignList(pack.getSpv().getCampaignList());
                    spv.setCategoryId(pack.getSpv().getCategoryId());
                    spv.setCombined(pack.getSpv().getCombined());
                    spv.setCostPrice(pack.getSpv().getCostPrice());
                    spv.setMinAmount(pack.getSpv().getMinAmount());
                    spv.setOriginalPrice(pack.getSpv().getOriginalPrice());
                    spv.setPriceCalResults(pack.getSpv().getPriceCalResults());
                    spv.setProductCode(pack.getSpv().getProductCode());
                    spv.setProductId(pack.getSpv().getProductId());
                    spv.setProductName(pack.getSpv().getProductName());
                    spv.setPsFurnitureStockVO(pack.getSpv().getPsFurnitureStockVO());
                    spv.setPsPresaleSaleStockVO(pack.getSpv().getPsPresaleSaleStockVO());
                    spv.setPsStockVO(pack.getSpv().getPsStockVO());
                    spv.setSalesPrice(pack.getSpv().getSalesPrice());
                    spv.setSkuCode(pack.getSpv().getSkuCode());
                    spv.setSkuCombinationList(pack.getSpv().getSkuCombinationList());
                    spv.setSkuVO(pack.getSpv().getSkuVO());
                    spv.setSpvId(pack.getSpv().getSpvId());
                    pack.setSpv(spv);
                }


            }
            oldOrderCreate.setOrderBusinessType(orderConfirmDTO.getOrderType());

            oldOrderCreate.setPacks(packs);
            // 换购赠品包商品
            Map<Long, String> addiblePacks = new HashMap<Long, String>();
            Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
            oldOrderCreate.setAddiblePacks(addiblePacks);
            oldOrderCreate.setGiftPackMap(giftPackMap);
            oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
            oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());

            if (CollectionUtils.isNotEmpty(priceResult.getSkuPriceStepVOs())) {
                Map<String, PrsSkuPriceStepVO> skuPriceStepMap = new HashMap<>();
                for (PrsSkuPriceStepVO vo : priceResult.getSkuPriceStepVOs()) {
                    skuPriceStepMap.put(vo.getSpvId() + vo.getSkuCode() + vo.getPriceType().getCode(), vo);
                }
                oldOrderCreate.setSkuPriceStepMap(skuPriceStepMap);
            }

            // =============支付金额校验=============
            BigDecimal payment = priceResult.getFinalTotalPrice();

            // 价格比较
            if (payment.subtract(orderConfirmDTO.getPrice()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
                throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE,
                        "商品支付价格有误,payment=" + payment + ",Price=" + orderConfirmDTO.getPrice());
            }
            oldOrderCreate.setActualPayFee(payment);

            // 礼品卡信息
            oldOrderCreate.setOpSalesOrderGiftCardVOs(priceAdapter.getGiftCardList(priceResult.getPriceStepVOs()));

            // =============客户备注===========
            oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
            // 投放来源
            oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());

            // 配送方式，0非快递1快递
            oldOrderCreate.setDeliveryType(0);

            // 预售商库存
            Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();
            Map<String, SPresaleVO> sPresaleMap = new HashMap<>();

            // 调用方法了
            OpSalesOrderVO opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay, member,
                    opChannel, sPresaleMap, sPresaleSaleInvMap);
            // 设置野兽课堂联系人
            opSalesOrderVO.setReceiver(orderConfirmDTO.getContactPerson());
            opSalesOrderVO.setReceiverPhone(orderConfirmDTO.getContactPhone());

            OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);

            if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {
                orderCode = orderResp.getOrderCode();

                // 保存订单快照
                if (StringUtils.isNotBlank(orderCode)) {
                    snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(), "");
                }

                // 使用积分抵扣则扣减积分
                if(orderConfirmDTO.getUsePointDeduct()){
                    PIntegralPaymentDTO dto = new PIntegralPaymentDTO();
                    dto.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
                    dto.setRemark(opSalesOrderVO.getPointOnLineDeduction().toString());
                    dto.setChannelCode(opChannel.getCode());
                    dto.setChannelName(opChannel.getName());
                    dto.setMemberId(member.getId());
                    dto.setOutTradeCode(orderCode);
                    dto.setPaymentAmount(opSalesOrderVO.getPointOnLine());
                    ServiceResp<PPaymentTradeVO> resp = pPaymentService.payForLocal(dto);
                    if (resp.isFailure() || resp.getBean() == null) {
                        // 取消订单
                        try {
                            pcInstance.cancleSalesOrder(orderCode);
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            throw new ChannelException("500", "订单取消失败，" + resp.getRespMsg());
                        }
                        throw new ChannelException("500", "积分支付失败，" + resp.getRespMsg());
                    }
                }
                
                
                
                if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
                    orderCommonAdapter.orderPay(orderCode, PaymentType.ALIPAY.getId(), orderResp.getAmount(), "");
                    
                    ServiceResp<Boolean>  resp = frontBeastCourseService.updateCourseReserveByOrderCode(orderCode);
					 if(resp!=null && resp.isFailure()){
						 logger.error("通知课堂服务理失败！errorMessage：" + resp.getRespMsg());
					 }
                }
            }
        }
        return orderCode;
    }

}
