package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.constant.WMSConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.delivery.constants.PostageConstant;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OrderTypeEnum;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeliveryInfo;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.logistics.DateUnitVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.logistics.TimeSlotVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
import com.thebeastshop.support.vo.order.OrderCard;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import com.thebeastshop.trans.service.TsDeliveryService;
import com.thebeastshop.trans.vo.delivery.TsDeliveryVO;

/**
 * 订单适配器(合作订单)
 */
@Component("appOrderJBRAdapter")
public class OrderJBRAdapter {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private MemberAddressService memberAddressService;
	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private OverseaService overseaService;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private LabelService labelService;

	@Autowired
	private TsDeliveryService tsDeliveryService;

	@Autowired
	private MemberAddressAdapter memberAddressAdapter;

	@Autowired
	private PriceService priceService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private McOpChannelService mcOpChannelService;

	/**
	 * 获取所有可用支付方式
	 * 
	 * @param isOverSea
	 *            是否是海淘
	 * @return
	 */
	private List<PaymentType> getPayMethods(boolean isOverSea) {
		List<PaymentType> payMethods = Lists.newArrayList();
		if (isOverSea) {
			payMethods.add(PaymentType.ALIPAY);
		} else {
			payMethods.add(PaymentType.ALIPAY);
			payMethods.add(PaymentType.WEIXIN);
		}
		return payMethods;
	}

	/**
	 * 订单确认页（浦发权益兑换用） 不用优惠券不用生日折扣 配送日期时间有单独接口提供
	 * 
	 */
	public OrderConfirmVO getOrderConfirm(OrderPreviewDTO orderPreview, List<CartProductPack> paramPacks,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, Boolean buyNow, BigDecimal price) {

		if (CollectionUtils.isEmpty(paramPacks)) {
			throw new WrongArgException("商品包不能为空");
		}

		Long couponId = orderPreview.getCouponId();
		Long addressId = orderPreview.getAddressId();
		boolean birthday = false;// 圣诞集赞订单不适用生日折扣
		OrderConfirmVO rt = new OrderConfirmVO();
		boolean hasOverSea = overseaService.isOversea(paramPacks);// 判断是否有海外购商品

		// =============地址信息=============

		com.thebeastshop.member.vo.MemberAddressVO address = null;

		if (member != null) {

			if (null != addressId && addressId != 0) {
				address = memberAddressService.getById(addressId);
				if (address != null) {
					MemberAddressVO deliveryAddress = new MemberAddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setAsDefault(address.getAsDefault());
					DistrictVO district = new DistrictVO();
					district.setFullName(address.getDistrict().getFullName());
					district.setId(address.getDistrict().getId());
					district.setName(address.getDistrict().getName());
					deliveryAddress.setDistrict(district);
					deliveryAddress.setLocation(address.getAddress());
					logger.info("地址详情来一发 address:{},addressId:{},location:{}", address, addressId,
							address.getAddress());
					deliveryAddress.setReceiverName(address.getReceiver());
					deliveryAddress.setReceiverPhone(address.getReceiverPhone());
					deliveryAddress.setZipCode(address.getZipCode());
					rt.setAddress(deliveryAddress);
				} else {
					throw new WrongArgException("地址不可用！");
				}
			} else {
				address = memberAddressService.getDefaultByOwnerId(member.getId());// 不传时使用默认地址
				rt.setAddress(memberAddressAdapter.getMemberAddress(address, member));
			}

		}

		// =============TODO:优惠券,现在数据库中字段的表示优惠口令（优惠码），暂时把优惠券id放在这个字段里，以后数据库中字段名应该改成couponId=============

		CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
		if (couponId != null && member != null) {
			throw new WrongArgException("圣诞集赞订单请不要使用优惠券!", "couponId", couponId);
		}
		// 价格计算
		calPriceDTO.setAccessWay(accessWay);
		calPriceDTO.setOpChannel(opChannel);
		calPriceDTO.setMember(member);
		calPriceDTO.setPacks(paramPacks);
		if (!birthday) {
			calPriceDTO.setBirthday(false);
		}
		PriceResult priceResult = priceService.calculateProductPackPrice(calPriceDTO);
		List<CampaignResult> campaignResults = priceResult.getCampaignResults();

		// 校验赠品包
		cartProductPackAdapter.checGiftPacks(paramPacks, priceResult.getCampaignResults());

		List<CartProductPackVO> packVOs = Lists.newArrayListWithExpectedSize(paramPacks.size());
		if (buyNow) {
			List<CartProductPackVO> tempPackVOs = cartProductPackAdaptor.getCartProductPackListNew(paramPacks, member,
					opChannel, true, true, true, campaignResults, accessWay, birthday, null);

			packVOs.addAll(tempPackVOs);
			for (CampaignResult campaignResult : campaignResults) {
				if (campaignResult.isReach() && campaignResult.getDiscountType().equals(DiscountType.GIFT)) {
					Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
					for (ProductPack productPack : additionalPacks) {
						CartProductPackVO packVO = cartProductPackAdaptor
								.getAddibleCartProductPackList(Arrays.asList(productPack), member, opChannel, accessWay)
								.get(0);
						// 赠品商品添加"赠品"标签
						Label label = new Label();
						label.setType("赠品");
						packVO.getLabels().add(label);
						packVOs.add(packVO);
					}
				}
			}
		} else {
			for (CartProductPack pack : paramPacks) {
				if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
					CartProductPackVO packVO = cartProductPackAdaptor
							.getAddibleCartProductPackList(Arrays.asList(pack), member, opChannel, accessWay).get(0);
					// 加价购商品添加"换购"标签
					Label label = new Label();
					label.setType("换购");
					packVO.getLabels().add(label);
					packVOs.add(packVO);
				} else if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
					CartProductPackVO packVO = cartProductPackAdaptor
							.getAddibleCartProductPackList(Arrays.asList(pack), member, opChannel, accessWay).get(0);
					// 赠品商品添加"赠品"标签
					Label label = new Label();
					label.setType("赠品");
					packVO.getLabels().add(label);
					packVOs.add(packVO);
				} else {
					packVOs.addAll(cartProductPackAdaptor.getCartProductPackListNew(Arrays.asList(pack), member,
							opChannel, true, true, true, campaignResults, accessWay, birthday, null));
				}
			}
		}

		// =========是否包含海外购商品===========
		rt.setHasOverseaProducts(hasOverSea);
		// =========可用的支付方式===========
		rt.setPayMethods(getPayMethods(rt.isHasOverseaProducts()));
		// ==============商品包================
		rt.setPacks(packVOs);
		// ===============标签================
		List<Label> cartLabels = labelService.getCartLabels(campaignResults, accessWay);
		for (Label label : cartLabels) {
			if (label.getCampaign() != null && label.getCampaign().getFulfilled()) {
				rt.getLabels().add(label);
			}
		}

		// ===============定制信息===============
		for (CartProductPack cartProductPack : paramPacks) {
			if (cartProductPack.isCustomize()) {
				rt.setCustomizable(Boolean.TRUE);
				break;
			}
		}

		// ===============配送信息（是否使用语音卡）===============
		int voiceCard = 0;
		rt.setVoiceCard(false);
		for (CartProductPack cartProductPack : paramPacks) {
			PsProductVO pro = cartProductPack.getProduct();
			if (!pro.getExpressType().equals(WMSConstants.ExpressType.SHOP)) {
				voiceCard++;
			}
		}
		if (voiceCard > 0) {
			rt.setVoiceCard(true);
		}

		// =============配送信息===============
		// *******价格步骤************
		List<PriceStepVO> priceSteps = new ArrayList<PriceStepVO>();

		PostageVO postages = new PostageVO();

		priceSteps.add(new PriceStepVO("商品总额", priceResult.getTotalPrice()));
		priceSteps.add(new PriceStepVO("集赞折扣", price.subtract(priceResult.getTotalPrice())));
		priceSteps.add(new PriceStepVO("运费", PostageConstant.NORMAL_PRICE));
		postages.setNormal(PostageConstant.NORMAL_PRICE);
		if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
			priceSteps.add(new PriceStepVO("实付99元免运费", BigDecimal.ZERO.subtract(PostageConstant.NORMAL_PRICE)));
			postages.setNormal(BigDecimal.ZERO);
			// 总价
			rt.setPrice(price);
		} else {
			// 总价
			rt.setPrice(price.add(PostageConstant.NORMAL_PRICE));
		}

		rt.setPriceSteps(priceSteps);
		// **********运费*********

		postages.setFaraway(BigDecimal.ZERO);
		postages.setEDT(BigDecimal.ZERO);
		rt.setPostage(postages);

		rt.setBday(null);

		// ===========是否可以注释============
		rt.setCanRemark(this.getCanRemark(paramPacks));
		// ========================================

		PsProductVO prod = paramPacks.get(0).getProduct();
		List<String> codes = new ArrayList<String>();
		codes.add(prod.getCode());
		TsDeliveryVO de = new TsDeliveryVO();
		if (null != address) {
			de = tsDeliveryService.pufaAddressDeliveryDate(codes, address.getId());
		}

		// **********配送描述*********
		if (de.getDeliveryTip() != null) {
			rt.setDeliveryTip(de.getDeliveryTip());
		}
		// *********可配送日期*********
		if (CollectionUtils.isNotEmpty(de.getDeliverableDates())) {
			List<com.thebeastshop.trans.vo.delivery.DateUnitVO> dates = de.getDeliverableDates();
			List<DateUnitVO> list = new ArrayList<DateUnitVO>();
			for (com.thebeastshop.trans.vo.delivery.DateUnitVO date : dates) {
				DateUnitVO vo = new DateUnitVO();
				vo.setAvailable(date.getAvailable());
				vo.setDesc(date.getDesc());
				vo.setText(date.getText());
				list.add(vo);
			}
			rt.setDeliverableDates(list);
		}
		// ************时段**********
		if (CollectionUtils.isNotEmpty(de.getDeliverableTimeSlots())) {
			List<com.thebeastshop.trans.vo.delivery.TimeSlotVO> slots = de.getDeliverableTimeSlots();
			List<TimeSlotVO> list = new ArrayList<TimeSlotVO>();
			for (com.thebeastshop.trans.vo.delivery.TimeSlotVO slot : slots) {
				TimeSlotVO vo = new TimeSlotVO();
				vo.setId(slot.getId());
				vo.setText(slot.getText());
				list.add(vo);
			}
			rt.setDeliverableTimeSlots(list);
		}

		return rt;
	}

	/**
	 * 获取商品包是否需要客户备注
	 *
	 * @param packs
	 * @return
	 */
	private Boolean getCanRemark(List<? extends ProductPack> packs) {
		if (!CollectionUtils.isEmpty(packs)) {
			List<String> skus = Lists.newArrayList();
			for (ProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				if (spv.getCombined() && CollectionUtils.isNotEmpty(spv.getSkuCombinationList())) {
					for (PsSkuCombinationVO skucombing : spv.getSkuCombinationList()) {
						skus.add(skucombing.getSubSkuCode());
					}
				} else {
					skus.add(spv.getSkuCode());
				}
			}
			List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skus);
			if (!CollectionUtils.isEmpty(skuList)) {
				for (PsSkuVO psSkuVO : skuList) {
					if (NullUtil.isNotNull(psSkuVO.getCanRemark()) && 1 == psSkuVO.getCanRemark()) {
						return true;
					}
				}
			}
		}
		return false;
	}

	/***
	 * 圣诞集赞订单处理
	 * 
	 * @param
	 */

	public OpSalesOrderVO jbrOrder(OrderConfirmDTO orderComfirmDTO, MemberVO member, Channel channel, String deviceId,
			PsProductVO productVO, PsSpvVO spv, PsSkuVO sku, BigDecimal price) {

		// 订单VO
		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		opSalesOrderVO.setDeviceId(deviceId);
		// 圣诞集赞兑换订单类型
		opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_8);
		// 运费
		BigDecimal postage = PostageConstant.NORMAL_PRICE;
		if (price.compareTo(PostageConstant.MEET_PRICE) >= 0) {
			postage = BigDecimal.ZERO;
		}
		opSalesOrderVO.setCarriage(postage);
		// 精确配送订单
		opSalesOrderVO.setLimitFee(BigDecimal.ZERO);
		// 包裹VO
		List<OpSoPackageVO> opSoPackageVOs = new ArrayList<OpSoPackageVO>();
		// 官网默认是一个包裹
		OpSoPackageVO opSoPackage = new OpSoPackageVO();
		// 包裹地址信息
		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
		// 包裹sku信息
		List<OpSoPackageSkuVO> opSoPackageSkuVOs = new ArrayList<OpSoPackageSkuVO>();

		// 配送仓
		OpChannelVO opChannel = mcOpChannelService.findByCode(channel.getCode());
		if (opChannel != null) {
			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
		}

		// 订单来源渠道编码
		opSalesOrderVO.setChannelCode(channel.getCode());
		// 卡片类型，0不需要1空白2代写
		OrderCard card = orderComfirmDTO.getNewCard();
		opSoPackage.setCardType(card.getType().getCode());
		opSoPackage.setCardContent(AppEmojiFilter.filterEmoji(card.getContent()));
		opSoPackage.setCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));
		opSoPackage.setCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
		// 配送方式，0非快递1快递
		if (orderComfirmDTO.getAddressId() > 0) {
			opSoPackage.setDeliveryType(1);
		} else {
			opSoPackage.setDeliveryType(0);
		}

		// 期望收货时间
		if (StringUtils.isNotBlank(orderComfirmDTO.getDeliveryDate())) {
			opSoPackage.setExpectReceiveDate(
					DateUtil.parse(orderComfirmDTO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
		} else {
			// 4点后第二天发货
			opSoPackage.setPlanedDeliveryDate(new Date());
			Calendar c = Calendar.getInstance();
			int hour = c.get(Calendar.HOUR_OF_DAY);
			int minute = c.get(Calendar.MINUTE);
			if (hour > 16 || (hour == 16 && minute > 0)) {
				opSoPackage.setPlanedDeliveryDate(DateUtil.addDay(new Date(), 1));
			}
		}

		com.thebeastshop.member.vo.MemberAddressVO address = memberAddressService
				.getById(orderComfirmDTO.getAddressId());// 设置配送地址
		opSoPackageDeliveryInfoVO.setAddress(address.getAddress());// 详细地址
		opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());// 环线
		opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());// 公司名称
		opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrict().getId());// 收货的区县ID
		opSoPackageDeliveryInfoVO.setReceiver(address.getReceiver());// 收件人
		opSoPackageDeliveryInfoVO.setZipCode(address.getZipCode());// 邮编
		opSoPackageDeliveryInfoVO.setTitle(address.getTitle());// 称谓
		opSoPackageDeliveryInfoVO.setReceiverPhone(address.getReceiverPhone()); // 收件人电话
		opSoPackageDeliveryInfoVO.setExpressType(productVO.getExpressType());

		// opSoPackageDeliveryInfoVO.setOpenId(address.get);不造是个嘛，先不传，有问题再改
		// 配送方式，判断是否需要强制审单
		Map<String, Boolean> deliveryTypes = new HashMap<String, Boolean>();
		OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();
		packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
		packageSku.setSkuCode(spv.getSkuCode());
		packageSku.setSpvId(spv.getSpvId());
		// coupon使用
		packageSku.setBrandId(productVO.getBrands().get(0).getBrandId());
		packageSku.setCategroyId(productVO.getCategoryId());

		packageSku.setIsJit(sku.getIsJit());// 是否来单制作
		packageSku.setQuantity(1);// 浦发订单只有一个 数量
		packageSku.setUnitPoint(BigDecimal.ZERO);// 单品积分

		// 预售商品须单独处理，去占用库存
		SPresaleVO presell = sPresaleService.findAvaliableBySkuCode(sku.getSkuCode(), false);
		if (null != presell) {
			packageSku.setPresaleId(presell.getId());
			packageSku.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
			packageSku.setDispatchWarehouseCode(presell.getDispatchWarehouseCode());// 冗余发货仓字段
			packageSku.setsPresaleVO(presell);// 冗余整个预售对象VO
			opSoPackage.setPlanedDeliveryDate(presell.getPlanedDeliveryDate());
		}

		// 判断是否包含两种以上配送方式，如果是，则需要强制审单
		if (OpProduct.EP_TYPE_SELF == productVO.getExpressType()) {
			deliveryTypes.put("SELF", true);
		} else if (OpProduct.EP_TYPE_FED == productVO.getExpressType()) {
			deliveryTypes.put("FEDX24", true);
		} else if (OpProduct.EP_TYPE_Sf_AIR == productVO.getExpressType()) {
			deliveryTypes.put("SF_AIR", true);
		} else if (OpProduct.EP_TYPE_Sf_LAND == productVO.getExpressType()) {
			deliveryTypes.put("SF_LAND", true);
		} else if (OpProduct.EP_TYPE_YTO == productVO.getExpressType()) {// 圆通
			deliveryTypes.put("YTO", true);
		} else if (OpProduct.EP_TYPE_DEPPON == productVO.getExpressType()) {
			deliveryTypes.put("DEPPON", true);
		}

		packageSku.setExpressType(productVO.getExpressType());
		PsSkuVO pssSkuVO = mcPsSkuService.findBySkuCode(spv.getSkuCode());

		if (pssSkuVO == null) {
			throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "商品已下架 " + spv.getSkuCode());
		}

		packageSku.setUnitDiscount(spv.getSalesPrice().subtract(price));
		// 折扣后金额
		packageSku.setUnitAmountAfterDiscount(price);
		// 特价
		packageSku.setDiscountPrice(price);
		packageSku.setUnitPointDeduction(BigDecimal.ZERO);
		packageSku.setUnitPrice(spv.getSalesPrice());

		packageSku.setIsGift(0);

		// 商品分类
		packageSku.setCategoryId(pssSkuVO.getCategoryId());
		opSoPackageSkuVOs.add(packageSku);

		opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
		if ("1".equals(orderComfirmDTO.getDeliveryType())) {
			// 设置配送信息的快递方式，当只有一种配送方式时，设置
			if (deliveryTypes != null && deliveryTypes.size() == 1) {
				if (deliveryTypes.get("SELF") != null && deliveryTypes.get("SELF")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
				} else if (deliveryTypes.get("FEDX24") != null && deliveryTypes.get("FEDX24")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
				} else if (deliveryTypes.get("SF_AIR") != null && deliveryTypes.get("SF_AIR")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
				} else if (deliveryTypes.get("SF_LAND") != null && deliveryTypes.get("SF_LAND")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
				} else if (deliveryTypes.get("YTO") != null && deliveryTypes.get("YTO")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
				} else if (deliveryTypes.get("DEPPON") != null && deliveryTypes.get("DEPPON")) {
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
				}
			}
		}
		// 设置包裹配送信息
		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
		opSoPackageVOs.add(opSoPackage);
		// 设置订单关联包裹
		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);

		if (member != null) {
			// 会员code
			opSalesOrderVO.setMemberCode(member.getCode());
			opSalesOrderVO.setMemberId(member.getId());
		}

		// 用户备注
		opSalesOrderVO.setRemark(orderComfirmDTO.getRemark());
		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);

		// 服务费
		opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
		opSalesOrderVO.setIsAnonymous(orderComfirmDTO.isAnonymous() ? 1 : 0);
		return opSalesOrderVO;
	}

}
