package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.pcs.sservice.SPrdcJobService;
import com.thebeastshop.wms.constant.WMSConstants;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.delivery.dto.DeliveryInfoDTO;
import com.thebeastshop.delivery.service.DeliveryRuleService;
import com.thebeastshop.delivery.vo.DeliveryInfoVO;
import com.thebeastshop.exchange.service.ExchangeService;
import com.thebeastshop.exchange.vo.ExchgRecordVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigDetailVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigVO;
import com.thebeastshop.member.service.IdCardQueryService;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemIdCardVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.payment.dto.PIntegralPaymentDTO;
import com.thebeastshop.payment.service.PPaymentService;
import com.thebeastshop.payment.vo.PPaymentTradeVO;
import com.thebeastshop.pegasus.channelservice.adapter.ComOrderAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.exchange.ExchangeAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCommonAdapter;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.pegasus.channelservice.service.ProductCouponService;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.time.TimeSlot;
import com.thebeastshop.pegasus.component.time.service.TimeSlotService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
import com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsCartSettleLabelVO;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
import com.thebeastshop.support.vo.order.OrderCard;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderConfirmVO.BdayVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;

/**
 * 团购订单
 * 
 * @author Wang Yawei
 *
 */
@Component("appOrderGrouponAdapter")
public class OrderGrouponAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private MemberAddressService memberAddressService;

	@Autowired
	private ExchangeService exchangeService;

	@Autowired
	private ExchangeAdapter exchangeAdapter;

	@Autowired
	private ProductAdapter productAdapter;
	@Autowired
	DeliveryRuleService deliveryRuleService;

	@Autowired
	private McPsProductService mcPsProductService;
	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private SPrdcJobService sPrdcJobService;

	@Autowired
	private SnapshotAdapter snapshotAdapter;

	@Autowired
	private OrderCommonAdapter orderCommonAdapter;

	@Autowired
	private ComOrderAdapter comOrderAdapter;

	@Autowired
	private CartService cartService;
	@Autowired
	private SpvAdapter spvAdaptor;
	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private OverseaService overseaService;

	private TimeSlotService timeSlotService = ComponentServiceLoader.getBean(TimeSlotService.class);

	@Autowired
	private PriceAdapter priceAdapter;
	@Autowired
	private MemberAddressAdapter memberAddressAdapter;
	@Autowired
	private LogisticsAdapter logisticsAdapter;
	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;
	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private IdCardQueryService idCardQueryService;
	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private ProductCouponService productCouponService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private CampaignLimitService campaignLimitService;

	@Autowired
	private SpvCommonAdapter spvCommonAdapter;

	@Autowired
	private PPaymentService pPaymentService;

	/**
	 * 拼团订单确认页，没有优惠券生日折扣等
	 * 
	 * @param paramPacks
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public OrderConfirmVO getOrderPreview(OrderPreviewDTO orderPreview, List<CartProductPack> paramPacks,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {

		if (CollectionUtils.isEmpty(paramPacks)) {
			throw new WrongArgException("商品包不能为空");
		}

		// int timeSlot = orderPreview.getDeliveryTimeSlot();
		Long addressId = orderPreview.getAddressId();
		OrderConfirmVO rt = new OrderConfirmVO();
		boolean hasOverSea = overseaService.isOversea(paramPacks);// 判断是否有海外购商品

		// =============地址信息=============
		DeliverableVO deliverableTime = new DeliverableVO();
		com.thebeastshop.member.vo.MemberAddressVO address = null;

		if (member != null) {

			if (null != addressId && addressId != 0) {
				address = memberAddressService.getById(addressId);
				if (address != null) {
					MemberAddressVO deliveryAddress = new MemberAddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setAsDefault(address.getAsDefault());
					DistrictVO district = new DistrictVO();
					district.setFullName(address.getDistrict().getFullName());
					district.setId(address.getDistrict().getId());
					district.setName(address.getDistrict().getName());
					deliveryAddress.setDistrict(district);
					deliveryAddress.setLocation(address.getAddress());
					logger.info("地址详情来一发 address:{},addressId:{},location:{}", address, addressId,
							address.getAddress());
					deliveryAddress.setReceiverName(address.getReceiver());
					deliveryAddress.setReceiverPhone(address.getReceiverPhone());
					deliveryAddress.setZipCode(address.getZipCode());
					rt.setAddress(deliveryAddress);
				} else {
					throw new WrongArgException("地址不可用！");
				}
				deliverableTime = logisticsAdapter.getDeliverableForOrderPrice(paramPacks, address, member, accessWay,
						opChannel, orderPreview.getPostage(), hasOverSea, BigDecimal.ZERO);

			} else {

				address = memberAddressService.getDefaultByOwnerId(member.getId());// 不传时使用默认地址
				rt.setAddress(memberAddressAdapter.getMemberAddress(address, member));
				deliverableTime = logisticsAdapter.getDeliverableForOrderPrice(paramPacks, address, member, accessWay,
						opChannel, orderPreview.getPostage(), hasOverSea, BigDecimal.ZERO);
			}

		}

		PrsCalPackDto arg0 = new PrsCalPackDto();
		BigDecimal customPostage = null;
		List<GiftCardVO> giftCards = orderPreview.getGiftCards();
		// 兼容小程序
		if (!StringUtils.isBlank(orderPreview.getDeliveryTime()) || orderPreview.getDeliveryTimeSlot() > 0) {

			DeliveryInfoDTO dto = new DeliveryInfoDTO();
			dto.setDistrictId(address.getDistrict().getId().intValue());
			List<PsProductVO> products = new ArrayList<PsProductVO>();
			for (ProductPack pack : paramPacks) {
				// 联邦或店送时，需要取得配送日期
				if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
					products.add(pack.getProduct());
				}
			}
			Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
			List<String> skuCodeList = new ArrayList<String>();
			for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
				for (PsSkuVO sku : entry.getValue()) {
					skuCodeList.add(sku.getSkuCode());
				}
			}
			dto.setSkuCodeList(skuCodeList);

			Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
			for (ProductPack pack : paramPacks) {
				PsProductVO psProduct = pack.getProduct();
				if (products.contains(psProduct)) {
					String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
					skuCountMap.put(skucode, pack.getCount());
				}
			}
			dto.setSkuCountMap(skuCountMap);
			ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);
			if (resp.isSuccess()) {
				DeliveryInfoVO vo = resp.getBean();
				arg0.setSelectedTimeDelivery(true);
				arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
			}

		}
		boolean birthday = false; // 不使用生日折扣

		PostageVO postageVO = new PostageVO();
		if (deliverableTime != null) {
			postageVO = deliverableTime.getPostage();
		}
		BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
		if (deliveryFee != null) {
			if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
				arg0.setRemoteDeliveryFee(deliveryFee);
			}
		}

		Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
		List<Integer> interestId = new ArrayList<Integer>();
		BigDecimal remotePostage = BigDecimal.ZERO;

		if (null != orderPreview.getPostage() && null != orderPreview.getPostage().getNormal()) {
			remotePostage = orderPreview.getPostage().getFaraway();
		}

		priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, paramPacks, member, opChannel, accessWay, null,
				customPostage, remotePostage, interestId, birthday, giftCards, null);

		// 精确时段配送费
		if (!StringUtils.isBlank(orderPreview.getDeliveryTime())) {

			logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderPreview.getDeliveryTime());
			DeliveryInfoDTO dto = new DeliveryInfoDTO();
			dto.setDistrictId(address.getDistrict().getId().intValue());
			List<PsProductVO> products = new ArrayList<PsProductVO>();
			for (ProductPack pack : paramPacks) {
				// 联邦或店送时，需要取得配送日期
				if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
					products.add(pack.getProduct());
				}
			}
			Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
			List<String> skuCodeList = new ArrayList<String>();
			for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
				for (PsSkuVO sku : entry.getValue()) {
					skuCodeList.add(sku.getSkuCode());
				}
			}
			dto.setSkuCodeList(skuCodeList);

			Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
			for (ProductPack pack : paramPacks) {
				PsProductVO psProduct = pack.getProduct();
				if (products.contains(psProduct)) {
					String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
					skuCountMap.put(skucode, pack.getCount());
				}
			}
			dto.setSkuCountMap(skuCountMap);

			arg0.setSelectedTimeDelivery(false);
			ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

			if (resp.isSuccess()) {
				DeliveryInfoVO vo = resp.getBean();
				logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
				arg0.setSelectedTimeDelivery(true);
				arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
			} else {
				logger.info("查询张天琪配送费成功失败 message={}", resp.getRespMsg());

			}
		}

		logger.info("订单预览页价格计算查询");

		// 价格计算
		PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4GroupBuy(arg0);

		logger.info("订单预览页价格计算查询 requestId={}", priceResult.getRequestId());
		// 修改pack价格，从格计算服务中取spv价格
		priceAdapter.assemblePackWithPrice(paramPacks, priceResult.getSpvPriceMap());

		List<CartProductPack> clientAddPacks = new ArrayList<CartProductPack>();// 用户选规格赠品换购包

		for (CartProductPack paramPack : paramPacks) {
			if (paramPack.getSource().equals(CartPackSourceEnum.GIFT)
					|| paramPack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				clientAddPacks.add(paramPack);
			}
		}

		// 运费
		BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());
		if (null != postageVO) {
			postageVO.setNormal(postage);
		}
		if (null != deliverableTime && null != deliverableTime.getPostage()) {
			deliverableTime.getPostage().setNormal(postage);
		}

		/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
		List<String> productIds = new ArrayList<>();// 赠品productIdList
		Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

		// 从价格步骤中将需要的东西筛选出来
		priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
				campaignCodeMap);

		/* 取库存取商品详情取限量 */
		Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
		Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
		Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
		// Map<String, Integer> checkPanicPerUserLeftMap = new HashMap<>();//
		// 限量map

		if (CollectionUtils.isNotEmpty(productIds)) {
			// 取商详
			psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// 取库存
			stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
			// 取限量
			List<CampaignStreamVO> csList = new ArrayList<>();
			if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

				for (PsProductVO ppVO : psProductVOMap.values()) {

					CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
					campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
					campaignStreamVO.setProductCode(ppVO.getCode());
					campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
					if (member != null) {
						campaignStreamVO.setMemberCode(member.getCode());
					}
					csList.add(campaignStreamVO);
				}
				// 验证赠品限量库存
				ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
				if (srp.isSuccess() && srp.getBean() != null) {

					checkCspLimitMap.putAll(srp.getBean());
				}

				// ServiceResp<Map<String, Integer>> panicPerUserLeftResp =
				// campaignLimitService
				// .getPanicPerUserLeftAmount(csList);
				//
				// if (panicPerUserLeftResp.isSuccess() &&
				// panicPerUserLeftResp.getBean() != null) {
				//
				// checkPanicPerUserLeftMap.putAll(panicPerUserLeftResp.getBean());
				// }
			}
		}
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
		// 筛选赠一赠多
		priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

		/* 整理单品赠品、多品赠品、加价购包 */

		Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
		Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
		List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

		priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

		/* 将赠品和换购包装成cs使用的包 */

		Boolean giftState = priceAdapter.isOptionalGift(resultMap, clientAddPacks);// 是否使用用户选择规格标志
		Boolean addState = priceAdapter.isOptionalAdd(resultMap, clientAddPacks);// 是否使用用户选择规格标志

		List<CartProductPack> resultPacks = new ArrayList<CartProductPack>();// 重新拼装过后的商品包

		/* 不使用用户选择spv，赠品重新组装 */

		// 拼换购包
		if (addState) {// 如果用户换购数量不一致，直接不给换购，如需要，回购物车重新选
			for (CartProductPack pack : paramPacks) {
				if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
					resultPacks.add(pack);
				}
			}
		}
		// 拼主商品包
		for (CartProductPack pack : paramPacks) {
			if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
				resultPacks.add(pack);
			}
		}
		if (!giftState) {// 如果用户赠品书不对，则随机分配
			Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap, stockMap,
					checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack

			Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
					checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

			if (!singlePackMap.isEmpty()) {
				for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
					resultPacks.addAll(entry.getValue());
				}
			}

			if (!mutiPackMap.isEmpty()) {
				for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
					resultPacks.addAll(entry.getValue());
				}
			}
		} else {// 否则按用户选择直接给赠品
			for (CartProductPack pack : paramPacks) {
				if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
					resultPacks.add(pack);
				}
			}
		}

		List<CartProductPackVO> packVOs = Lists.newArrayListWithExpectedSize(resultPacks.size());
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(resultPacks.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(resultPacks.size());

		for (ProductPack pack : resultPacks)

		{
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}

		Collection<PsSpvVO> spvs = spvMap.values();
		Map<String, Date> spvPresaleDateMap = spvCommonAdapter.mapSkuCodePresale(spvs, opChannel);

		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);

		/* 标签处理 */
		Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();
		List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
		priceAdapter.getLabels(priceResult.getCartSettleLabelList(), mutiLabels, singleLabelMap);

		for (CartProductPack pack : resultPacks)

		{
			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				CartProductPackVO packVO = cartProductPackAdaptor.getAddibleCartProductPackListNew(Arrays.asList(pack),
						member, opChannel, accessWay, spvPresaleDateMap, false).get(0);
				// 加价购商品添加"换购"标签
				Label label = new Label();
				label.setType("换购");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
				CartProductPackVO packVO = cartProductPackAdaptor.getAddibleCartProductPackListNew(Arrays.asList(pack),
						member, opChannel, accessWay, spvPresaleDateMap, true).get(0);
				// 赠品商品添加"赠品"标签
				Label label = new Label();
				label.setType("赠品");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else {
				// 订单预览页主品上不需要绑赠品
				packVOs.addAll(priceAdapter.getCartProductPackList(Arrays.asList(pack), member, opChannel, true, false,
						true, accessWay, birthday, spvPresaleDateMap, interestGoodsMap,
						new HashMap<Long, List<CartProductPackVO>>(), singleLabelMap, true, spvLabelMap));
			}
		}

		// =========是否包含海外购商品===========
		rt.setHasOverseaProducts(hasOverSea);
		// =========可用的支付方式===========
		rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));

		// ==============商品包================
		rt.setPacks(packVOs);
		// ===============标签(订单只显示满足条件的标签)================

		// 多品标签（订单只显示满足条件的价格类型标签）
		List<Label> cartLabels = new ArrayList<Label>();
		if (CollectionUtils.isNotEmpty(mutiLabels))

		{
			for (PrsCartSettleLabelVO label : mutiLabels) {
				if (label.isFit()) {
					// 满赠换购不显示
					if (null != label.getDiscountType() && !label.getDiscountType().getId().equals(DiscountType.GIFT.id)
							&& !label.getDiscountType().getId().equals(DiscountType.CHEAPEN_OTHER.id)) {
						cartLabels.add(priceAdapter.setupLabel(label));
					}
				}
			}
		}
		rt.setLabels(cartLabels);
		if (deliverableTime != null)

		{
			postageVO = deliverableTime.getPostage();
		}

		// 如果是线下，用线下传进来的运费
		if (opChannel.getChannelType() == 1)

		{
			postageVO = orderPreview.getPostage();
		}

		// =============价格步骤===============
		Collection<PriceStepVO> priceSteps = priceAdapter.getPriceSteps(priceResult, member.getMemberLevelDesc(), "");

		rt.setPrice(priceResult.getFinalTotalPrice());
		rt.setPriceSteps(priceSteps);

		// ===============定制信息===============
		for (CartProductPack cartProductPack : resultPacks)

		{
			if (cartProductPack.isCustomize()) {
				rt.setCustomizable(Boolean.TRUE);
				break;
			}
		}

		// ===============配送信息（是否使用语音卡）===============
		int voiceCard = 0;
		rt.setVoiceCard(false);
		for (CartProductPack cartProductPack : resultPacks)

		{
			PsProductVO pro = cartProductPack.getProduct();
			if (!pro.getExpressType().equals(WMSConstants.ExpressType.SHOP)) {
				voiceCard++;
			}
		}
		if (voiceCard > 0) {
			rt.setVoiceCard(true);
		}
		try {
			deliverableTime = logisticsAdapter.getDeliverablePrice(resultPacks, address, member, accessWay, opChannel,
					orderPreview.getPostage(), hasOverSea, postage);
		} catch (WrongArgException e) {
			deliverableTime = null;
			rt.setAddress(null);
			logger.error("e:{}", e);
		} catch (Throwable e) {
			logger.error("[" + this + "] - [getOrderConfirm] " + e.getMessage(), e);
			throw e;
		}

		if (deliverableTime != null) {
			// **********配送描述*********
			if (deliverableTime.getDeliveryTip() != null) {
				rt.setDeliveryTip(deliverableTime.getDeliveryTip());
			}
			// *********可配送日期*********
			if (deliverableTime.getDeliverableDates() != null) {
				rt.setDeliverableDates(deliverableTime.getDeliverableDates());
			}
			// ************时段**********
			if (deliverableTime.getDeliverableTimeSlots() != null) {
				rt.setDeliverableTimeSlots(deliverableTime.getDeliverableTimeSlots());
			}
			// **********运费*********
			rt.setPostage(deliverableTime.getPostage());
		}

		// =======生日折扣===========
		if (member != null && member.getMemberLevel() != null
				&& !member.getMemberLevel().equals(MemberLevelEnum.NORMAL.getCode()) && member.isInBdayDiscountTime())

		{
			// 不是注册用户的情况
			BdayVO bday = new BdayVO();
			bday.setWithin(member.isInBdayDiscountTime());
			bday.setUsed(member.isBdayDiscountUsed());
			bday.setRatio(member.getBdayDiscountRatio());
			int count = 0;
			for (CartProductPack paramPack : resultPacks) {
				PsProductVO prod = paramPack.getProduct();
				if (prod.getAllowBdDiscount() == 1 && CartPackSourceEnum.RAW.equals(paramPack.getSource())) {
					int size = 0;
					List<PsCampaignVO> campList = paramPack.getSpv().getCampaignList();// 抢购判断
					if (null != campList && campList.size() > 0) {
						for (PsCampaignVO camp : campList) {
							if (camp.getDiscountTypeId() == 6) {
								size++;
							}
						}
					}
					if (size == 0) {
						count++;
					}
				}

			}

			if (count > 0) {
				rt.setBday(bday);
			} else {
				rt.setBday(null);
			}
		}

		// ===========是否可以注释============
		rt.setCanRemark(orderCommonAdapter.getCanRemark(resultPacks));
		rt.setGiftCards(giftCards);
		return rt;

	}

	/**
	 * 新创建订单方法（价格计算）
	 * 
	 * @param orderConfirmDTO
	 */
	public String orderCreate(OrderConfirmDTO orderConfirmDTO, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay, String deviceId) {
		logger.info("execute  _callOldOrderCreate");
		String orderCode = "";
		List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
		List<Long> packIds = Lists.newArrayList();
		List<RequestPack> noIdPacks = Lists.newArrayList();
		if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestPacks)) {
			OrderCreateVO oldOrderCreate = new OrderCreateVO();
			oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
			oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
			oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
			// =============商品包=============
			List<CartProductPack> packs = Lists.newArrayList();
			for (RequestPack requestPack : requestPacks) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			// 预售商库存
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();

			Map<String, SPresaleVO> sPresaleMap = new HashMap<>();

			// 商品验证
			orderCommonAdapter.checkPack(packs, opChannel, member, oldOrderCreate, sPresaleMap, sPresaleSaleInvMap,
					orderConfirmDTO);

			// =========是否包含海外购商品===========
			boolean isHasOverSea = overseaService.isOversea(packs);
			// =============APP下载来源============
			oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
			// =============渠道编号=============
			oldOrderCreate.setChannelCode(opChannel.getCode());
			// ==============会员id=============
			if (member != null) {
				oldOrderCreate.setCustomerId(member.getId());
			}

			// =============地址=============

			com.thebeastshop.member.vo.MemberAddressVO address = null;
			if (orderConfirmDTO.getAddressId() > 0) {
				address = memberAddressService.getById(orderConfirmDTO.getAddressId());
				if (address != null) {
					AddressVO deliveryAddress = new AddressVO();
					deliveryAddress.setId(address.getId());
					deliveryAddress.setCircuit(address.getCircuitDesc());
					deliveryAddress.setDistrictId(address.getDistrict().getId());
					deliveryAddress.setDistrict(address.getDistrict().getName());
					deliveryAddress.setCompanyName(address.getCompanyName());
					deliveryAddress.setMemberId(address.getMemberId());
					deliveryAddress.setZip(address.getZipCode());
					deliveryAddress.setPhone(address.getReceiverPhone());
					deliveryAddress.setName(address.getReceiver());
					deliveryAddress.setMagentoTitle(address.getTitle());
					deliveryAddress.setStreet(address.getAddress());
					oldOrderCreate.setDeliveryAddress(deliveryAddress);
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
							"当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
				}
			}

			oldOrderCreate.setDeviceId(deviceId);

			// =============是否匿名购买=============
			oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
			// =============是否使用生日折扣=============
			oldOrderCreate.setUseBdayDiscount(orderConfirmDTO.isUseBdayDiscount());
			// =============卡片内容 卡片类型，0不需要1空白2代写=============
			OrderCard card = orderConfirmDTO.getNewCard();
			oldOrderCreate.setNoteCard(card.getType().getCode());
			oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
			oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
			oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));

			// =============配送日期=============
			oldOrderCreate.setDeliveryDate(orderConfirmDTO.getDeliveryDate());
			// =============配送时段=============
			TimeSlot timeSlot = timeSlotService.getById(orderConfirmDTO.getDeliveryTimeSlot());
			// 兼容小程序
			if (timeSlot != null)
				oldOrderCreate.setLimitedHour(timeSlot.getText());
			else {
				oldOrderCreate.setLimitedHour(orderConfirmDTO.getDeliveryTime());
			}

			// =============TODO:优惠券,现在数据库中字段的表示优惠口令（优惠码），暂时把优惠券id放在这个字段里，以后数据库中字段名应该改成couponId=============
			Long couponId = orderConfirmDTO.getCouponId();

			List<GiftCardVO> giftCard = orderConfirmDTO.getGiftCards();
			PrsCalPackDto arg0 = new PrsCalPackDto();
			BigDecimal customPostage = null;
			// 如果是线下，用线下传进来的运费
			if (opChannel.getChannelType() == 1) {
				customPostage = BigDecimal.ZERO;
				if (null != orderConfirmDTO.getPostage() && null != orderConfirmDTO.getPostage().getNormal()) {
					customPostage = orderConfirmDTO.getPostage().getNormal();
				}
			}
			List<Integer> interestId = new ArrayList<Integer>();

			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			boolean birthday = true;
			if (!orderConfirmDTO.isUseBdayDiscount()) {
				logger.info("isUseBdayDiscount" + orderConfirmDTO.isUseBdayDiscount());
				birthday = false;
			}

			BigDecimal remotePostage = BigDecimal.ZERO;

			if (null != orderConfirmDTO.getDeliveryPrice()
					&& orderConfirmDTO.getDeliveryPrice().compareTo(BigDecimal.ZERO) > 0) {
				remotePostage = orderConfirmDTO.getDeliveryPrice();
			}

			// 积分兑换订单
			Map<String, ExchgSpuConfigVO> exchgSpuConfigMap = null;
			if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
				if (CollectionUtils.isNotEmpty(packs)) {
					List<String> prodCodes = Lists.newArrayList();
					// 兑换商品校验
					for (CartProductPack pack : packs) {
						String productCode = pack.getProduct().getCode();
						// 校验是否有兑换权限
						exchangeAdapter.checkExchangeGoods(member, productCode, pack.getSpv().getSkuCode(),
								pack.getCount());
						prodCodes.add(productCode);
					}
					if (CollectionUtils.isNotEmpty(prodCodes)) {
						exchgSpuConfigMap = new HashMap<>();
						List<ExchgSpuConfigVO> spuConfigVOS = exchangeService
								.queryExchgSpuConfigByReferenceCodes(prodCodes);
						for (ExchgSpuConfigVO spuConfigVO : spuConfigVOS) {
							exchgSpuConfigMap.put(spuConfigVO.getReferenceCode(), spuConfigVO);
						}
					}
				} else {
					throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，兑换商品包未包含商品.");
				}

			}

			if (couponId != null && member != null) {
				// 判断优惠券是否可以使用
				ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId, member.getId(),
						opChannel.getCode());
				if (rsp == null || rsp.getBean() == null) {
					throw new WrongArgException("优惠券不可用!", "couponId", couponId);
				}
				if (!productCouponService.checkCoupon(packs, rsp.getBean(), accessWay, member, opChannel)) {
					throw new WrongArgException("优惠券不可用!", "couponId", couponId);
				} else {
					priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay,
							rsp.getBean(), customPostage, remotePostage, interestId, birthday, giftCard,
							exchgSpuConfigMap);
				}
			} else {
				priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
						customPostage, remotePostage, interestId, birthday, giftCard, exchgSpuConfigMap);
			}

			if (!StringUtils.isBlank(orderConfirmDTO.getDeliveryTime())) {

				logger.info("精确时段配送费方法查询，配送时段 deliveryTime={}", orderConfirmDTO.getDeliveryTime());
				DeliveryInfoDTO dto = new DeliveryInfoDTO();
				dto.setDistrictId(address.getDistrict().getId().intValue());
				List<PsProductVO> products = new ArrayList<PsProductVO>();
				for (ProductPack pack : packs) {
					// 联邦或店送时，需要取得配送日期
					if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
						products.add(pack.getProduct());
					}
				}
				Map<String, List<PsSkuVO>> skuMap = productAdapter.GetSkusByProduct(products);
				List<String> skuCodeList = new ArrayList<String>();
				for (Map.Entry<String, List<PsSkuVO>> entry : skuMap.entrySet()) {
					for (PsSkuVO sku : entry.getValue()) {
						skuCodeList.add(sku.getSkuCode());
					}
				}
				dto.setSkuCodeList(skuCodeList);

				Map<String, Integer> skuCountMap = new HashMap<String, Integer>();
				for (ProductPack pack : packs) {
					PsProductVO psProduct = pack.getProduct();
					if (products.contains(psProduct)) {
						String skucode = skuMap.get(psProduct.getId()).get(0).getSkuCode();
						skuCountMap.put(skucode, pack.getCount());
					}
				}
				dto.setSkuCountMap(skuCountMap);

				arg0.setSelectedTimeDelivery(false);
				ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);
				if (resp.isSuccess()) {
					DeliveryInfoVO vo = resp.getBean();
					logger.info("查询张天琪配送费成功，精确时段配送费 extraDeliveryFee={}", vo.getExtraDeliveryFee());
					arg0.setSelectedTimeDelivery(true);
					arg0.setPreciseTimeDeliveryFee(new BigDecimal(vo.getExtraDeliveryFee()));
				}
			}
			DeliverableVO deliverableTime = logisticsAdapter.getDeliverablePrice(packs, address, member, accessWay,
					opChannel, orderConfirmDTO.getPostage(), isHasOverSea, BigDecimal.ZERO);

			PostageVO postageVO = new PostageVO();
			if (deliverableTime != null) {
				postageVO = deliverableTime.getPostage();
			}
			BigDecimal deliveryFee = postageVO != null ? postageVO.getFaraway() : null;
			if (deliveryFee != null) {
				if (deliveryFee.compareTo(BigDecimal.ZERO) > 0) {
					arg0.setRemoteDeliveryFee(deliveryFee);
				}
			}

			logger.info("订单确认价格计算");

			PrsPacksPriceResultVO priceResult = null;

			priceResult = prsPriceService.calculatePrs4SubmitOrder(arg0);

			logger.info("团购下单价格计算查询 requestId={}", priceResult.getRequestId());

			// 运费
			BigDecimal postage = priceAdapter.getPostagePrice(priceResult.getPriceStepVOs());

			postageVO.setNormal(postage);
			if (null != deliverableTime && null != deliverableTime.getPostage()) {
				deliverableTime.getPostage().setNormal(postage);
			}
			// 先去看架构有没有用免邮权益
			if (CollectionUtils.isNotEmpty(interestId)) {
				// 如果使用了免邮权益，那么传给张天琪
				if (priceAdapter.getPostageInterest(priceResult.getPriceStepVOs())) {

					OrderCreateVO.InterestsVO interestsVO = oldOrderCreate.new InterestsVO();
					interestsVO.setId(interestId.get(0));
					oldOrderCreate.setInterestsVO(interestsVO);
				}

			}

			// 查看架构有没有用优惠券
			if (couponId != null && member != null) {
				// 如果使用了优惠券，那么传给张天琪
				if (priceAdapter.isUseCoupon(priceResult.getPriceStepVOs())) {
					logger.info("使用优惠卷code:" + couponId.toString() + ",memberCode:" + member.getCode());
					oldOrderCreate.setCouponCode(couponId.toString());
				} else {
					// 将优惠清理掉
					couponId = null;
				}

			}

			if (isHasOverSea) {
				// =========设置海淘标记=========
				oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
				// =========设置身份证信息=========
				if (member != null && address != null) {
					MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(),
							address.getReceiver());
					if (memIdCardVO != null) {
						IdCardVO idCardVO = new IdCardVO();
						idCardVO.setAuditStatus(memIdCardVO.getImgStatus());
						idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
						idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
						idCardVO.setIdNumber(memIdCardVO.getIdNumber());
						idCardVO.setImgStatus(memIdCardVO.getImgStatus());
						idCardVO.setName(memIdCardVO.getName());
						oldOrderCreate.setIdCardVO(idCardVO);
					}
				}
			}
			// 给张天琪的相关信息
			// 给张天琪兑换积分信息
			Map<Long, Integer> exchangeMap = new HashMap<Long, Integer>();

			// 所有商品的包 List<CartProductPack> packs

			Map<Long, BigDecimal> spvMap = priceResult.getSpvPriceMap();
			for (CartProductPack pack : packs) {
				pack.getSpv().setDiscountPrice(spvMap.get(pack.getSpvId()));

				if (null != exchgSpuConfigMap) {
					ExchgSpuConfigVO exchangeVO = exchgSpuConfigMap.get(pack.getProduct().getCode());
					List<ExchgSpuConfigDetailVO> exchangelist = exchangeVO.getSpuConfigDetailList();
					if (CollectionUtils.isNotEmpty(exchangelist)) {

						for (ExchgSpuConfigDetailVO exchange : exchangelist) {
							if (exchange.getSpvId().longValue() == pack.getSpvId()) {
								logger.info("exchange spvid={},pack spvid={}", exchange.getSpvId(), pack.getSpvId());

								exchangeMap.put(pack.getSpvId(), exchange.getExchangeAmount());
							}
						}
					}

				}
			}
			oldOrderCreate.setPacks(packs);

			// spvId对应权益商品 Map<Long,InterestGoods>： interestGoodsMap
			// 兑换积分信息
//			oldOrderCreate.setExchangeMap(exchangeMap);

			// ====================xiugai======================
			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceResult.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
			Map<String, Integer> checkPanicPerUserLeftMap = new HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						campaignStreamVO.setSkuCode(ppVO.getSkuCodes().get(0));
						if (member != null) {
							campaignStreamVO.setMemberCode(member.getCode());
						}
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}
					ServiceResp<Map<String, Integer>> panicPerUserLeftResp = campaignLimitService
							.getPanicPerUserLeftAmount(csList);

					if (panicPerUserLeftResp.isSuccess() && panicPerUserLeftResp.getBean() != null) {

						checkPanicPerUserLeftMap.putAll(panicPerUserLeftResp.getBean());
					}
				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			// ====================xiugai======================

			// 换购商品map,key:换购商品spvId，value:活动code Map<Long, String>： addPacks
			Map<Long, String> addiblePacks = priceAdapter.getAdds(priceResult.getPriceStepVOs(), packs);

			// 主品（spvid作为key）对应的赠品Map<Long,List<CartProductPack>> ： giftPackMap

			Map<Long, List<Long>> giftMap = priceAdapter.blindGift(singleGiftMap, mutiGiftMap);

			Map<Long, Integer> giftSizeMap = priceAdapter.getGiftSize(singleGiftMap, mutiGiftMap);

			Map<Long, List<CartProductPack>> giftPackMap = new HashMap<Long, List<CartProductPack>>();
			List<CartProductPack> giftPacks = priceAdapter.getGifts(packs);
			if (CollectionUtils.isNotEmpty(giftPacks)) {
				if (null != giftMap && giftMap.size() > 0) {
					// if (CollectionUtils.isNotEmpty(giftPacks)) {

					for (Map.Entry<Long, List<Long>> gift : giftMap.entrySet()) {
						if (CollectionUtils.isNotEmpty(gift.getValue())) {
							List<CartProductPack> resultList = new ArrayList<CartProductPack>();
							for (Long productId : gift.getValue()) {
								for (CartProductPack gif : giftPacks) {// 取一个删一个，防止出现同一个product下多个spv赠品
									if (productId.equals(gif.getProductId())) {
										logger.info("给赠品塞数量，赠品productId = {}", productId);
										if (giftSizeMap.containsKey(productId)) {

											logger.info("，赠品productId = {}的实际数量为 count={}", productId,
													giftSizeMap.get(productId));
											gif.setCount(giftSizeMap.get(productId));
										} else {
											logger.info("，赠品productId = {}没有数量", productId);
										}
										resultList.add(gif);
										giftPacks.remove(gif);
										break;
									}
								}

							}
							if (CollectionUtils.isNotEmpty(resultList)) {
								giftPackMap.put(gift.getKey(), resultList);
							}
						}
					}
				}

			} else {// 前端如果不带赠品来，后端塞赠品
				if (!singleGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> singlePackMap = priceAdapter.setupGiftPacks(singleGiftMap,
							stockMap, checkCspLimitMap, psProductVOMap, campaignCodeMap);// 单品pack
					for (Map.Entry<Long, List<CartProductPack>> entry : singlePackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}

				if (!mutiGiftMap.isEmpty()) {
					Map<Long, List<CartProductPack>> mutiPackMap = priceAdapter.setupGiftPacks(mutiGiftMap, stockMap,
							checkCspLimitMap, psProductVOMap, campaignCodeMap);// 多品pack

					for (Map.Entry<Long, List<CartProductPack>> entry : mutiPackMap.entrySet()) {
						List<CartProductPack> packslist = new ArrayList<CartProductPack>();
						if (giftPackMap.containsKey(entry.getKey())) {
							packslist = giftPackMap.get(entry.getKey());
						}
						packslist.addAll(entry.getValue());
						giftPackMap.put(entry.getKey(), packslist);
					}
				}
			}

			oldOrderCreate.setAddiblePacks(addiblePacks);
			// oldOrderCreate.setCampaignMap(campaignMap);
			oldOrderCreate.setGiftPackMap(giftPackMap);
			oldOrderCreate.setSpvSteps(priceResult.getSpvPriceStepVOs());
			oldOrderCreate.setPriceStepVOs(priceResult.getPriceStepVOs());
			// oldOrderCreate.setInterestGoodsMap(interestGoodsMap);
			//oldOrderCreate.setServiceStep(priceAdapter.setServiceStep(priceResult.getPriceStepVOs()));
			// =============支付金额校验=============
			BigDecimal payment = priceResult.getFinalTotalPrice();

			// 转换精度后比较
			if (payment.subtract(orderConfirmDTO.getPrice()).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
				throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE, "商品支付价格有误," + payment);
			}
			// if (payment.setScale(2, RoundingMode.HALF_UP)
			// .compareTo(orderConfirmDTO.getPrice().setScale(2,
			// RoundingMode.HALF_UP)) > 0) {
			// throw new
			// ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE,
			// "商品支付价格有误," + payment);
			// }
			oldOrderCreate.setActualPayFee(orderConfirmDTO.getPrice());

			// 礼品卡信息
			oldOrderCreate.setOpSalesOrderGiftCardVOs(priceAdapter.getGiftCardList(priceResult.getPriceStepVOs()));

			// =============客户备注===========
			oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
			// 投放来源
			oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());

			// 配送方式，0非快递1快递
			if (orderConfirmDTO.getAddressId() > 0) {
				oldOrderCreate.setDeliveryType(1);
			} else {
				oldOrderCreate.setDeliveryType(0);
			}
			if (CollectionUtils.isEmpty(oldOrderCreate.getPacks())) {
				throw new ChannelException(ChannelExceptionErrorCode.PACKS_ZERO_CODE, "无法下单，商品包未包含商品.");
			}
			oldOrderCreate.setOrderBusinessType(orderConfirmDTO.getOrderType());
			// 调用方法了
			final OpSalesOrderVO opSalesOrderVO = comOrderAdapter.orderWebsite2Common(oldOrderCreate, accessWay, member,
					opChannel, sPresaleMap, sPresaleSaleInvMap);
			OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO, accessWay);
			if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {

				orderCode = orderResp.getOrderCode();
				// 如果订单中有配方商品需要占用库存，如果占用失败，将订单改为不可见
				if (CollectionUtils.isNotEmpty(opSalesOrderVO.getCustomizeInvList())
						&& opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
					try {
						sPrdcJobService.createAllotOrPrdcJob(opSalesOrderVO.getCustomizeInvList());
					} catch (Exception e) {

						pcInstance.deleteSalesOrder(opSalesOrderVO.getMemberCode(), orderCode, "配方定制商品库存占用失败,订单隐藏");
						logger.info(e.getMessage());
						logger.info("配方定制商品库存占用失败，orderCode:" + opSalesOrderVO.getCode());
						throw new ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE, "配方定制商品库存不足");
					}
				}

				if (couponId != null && StringUtils.isNotBlank(orderCode)) {
					// TODO：如果创建订单成功,则优惠券要改为已使用（注：这个应该是在下订单流程中处理的，以后要改）
					ServiceResp<Boolean> resp = cpCouponService.use(couponId);
					if (resp.isFailure()) {
						throw new ChannelException(ChannelExceptionErrorCode.COUPON_INVALID_CODE,
								"使用优惠券失败 [couponId=" + couponId + "]: " + resp.getRespMsg());
					}
				}

				if (StringUtils.isNotBlank(orderCode)) {
					// 如果创建订单成功且从购物车中来,则删除购物车中商品包
					if (member != null && CollectionUtils.isNotEmpty(packIds)) {
						cartService.removePacksById(member, packIds);
					}
				}

				// 保存订单快照
				if (StringUtils.isNotBlank(orderCode)) {

					snapshotAdapter.saveSnapshot(orderResp.getId(), priceResult, member.getMemberLevelDesc(), "");
				}
				// 积分兑换订单
				if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
					if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {

						if (CollectionUtils.isNotEmpty(opSalesOrderVO.getExchgRecordVOs())) {

							for (ExchgRecordVO exchgRecordVO : opSalesOrderVO.getExchgRecordVOs()) {
								ServiceResp<Boolean> resp = exchangeService.initExchgRecordByOrder(orderCode,opSalesOrderVO.getExchgRecordVOs());
								if (resp.isFailure()) {
									logger.error("exchangeService.initExchgRecord message:" + resp.getRespMsg());
									throw new ChannelException("500", "下单保存积兑换记录失败，" + resp.getRespMsg());
								}
							}

						}

						PIntegralPaymentDTO dto = new PIntegralPaymentDTO();

						dto.setAccessWay(AccessWayEnum.getEnumByCode(accessWay.getCode()));
						dto.setRemark(opSalesOrderVO.getPointOnLineDeduction().toString());
						dto.setChannelCode(opChannel.getCode());
						dto.setChannelName(opChannel.getName());
						dto.setMemberId(member.getId());
						dto.setOutTradeCode(orderCode);
						dto.setPaymentAmount(opSalesOrderVO.getPointOnLine());
						ServiceResp<PPaymentTradeVO> resp = pPaymentService.payForLocal(dto);
						if (resp.isFailure() || resp.getBean() == null) {
							throw new ChannelException("500", "积分支付失败，" + resp.getRespMsg());
						}

					}
				} else {
					if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {

						orderCommonAdapter.orderPay(orderCode, PaymentType.ALIPAY.getId(), orderResp.getAmount(), "");
					}
				}
				if (member != null) {
					// 如果用户未设置默认地址，则这次订单地址设为默认地址
					com.thebeastshop.member.vo.MemberAddressVO memberAddress = memberAddressService
							.getDefaultByOwnerId(member.getId());
					if (memberAddress == null && address != null) {
						address.setAsDefault(true);
						memberAddressService.update(address);
					}
				}

//				try {
//					// ezr coupon
//					cpCouponService.couponUseEzr(couponId, opChannel.getCode(), orderCode,
//							opSalesOrderVO.getCouponFee().doubleValue());
//				} catch (Exception e) {
//					logger.error("couponUseEzr error");
//					logger.error(e.getMessage());
//				}

			}

		}
		return orderCode;
	}
}
