package com.thebeastshop.pegasus.channelservice.adapter.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.thebeastshop.cart.support.ScDeliveryVO;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.pegasus.channelservice.util.ConstUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.commdata.service.ChannelQueryService;
import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.course.service.FrontBeastCourseService;
import com.thebeastshop.exchange.enums.ExchgTypeEnum;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.service.point.MemberPointService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvCustomizeAdapter;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.stock.dto.SSkuPointExchangeQueryDTO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;
import com.thebeastshop.stock.vo.SSkuPointExchangeStockVO;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.exception.WrongEntityException;
import com.thebeastshop.support.vo.cart.DeliveryVO;
import com.thebeastshop.support.vo.order.OrderConfirmDTO;

/**
 * 订单通用适配器
 * 
 * @author Wang Yawei
 *
 */
@Component("appOrderCommonAdapter")
public class OrderCommonAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private final PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();

	@Autowired
	private ForecastAdapter forecastAdapter;

	@Autowired
	private McPsSkuService mcPsSkuService;

	@Autowired
	private SpvCustomizeAdapter spvCustomizeAdapter;

	@Autowired
	private SStockService sStockService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private SPresaleService sPresaleService;

	@Autowired
	private ChannelQueryService channelQueryService;

	@Autowired
	private FrontBeastCourseService frontBeastCourseService;
	
	@Autowired
	private MemberPointService memberPointService;

	public static final Map<Integer, String> mapBirthFlower;

	static {
		mapBirthFlower = new HashMap();
		mapBirthFlower.put(0, "101160011");
		mapBirthFlower.put(1, "101160021");
		mapBirthFlower.put(2, "101160031");
		mapBirthFlower.put(3, "101160041");
	}


	public void checkPack(List<CartProductPack> packs, OpChannelVO opChannel, MemberVO member,
			OrderCreateVO orderCreate, Map<String, SPresaleVO> sPresaleMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap, OrderConfirmDTO orderConfirmDTO) {

		// 设置渠道销售仓
		orderCreate.setWarehouseForSales(opChannel.getWarehouseForSales());

		for (CartProductPack productPack : packs) {
			if (productPack.isCustomize()) {
				// 校验锈字规则
				if (!spvCustomizeAdapter.checkWordLimit(productPack.getSpv().getSpvId(),
						productPack.getCustomizeList())) {
					logger.error("定制商品{}：输入文字不符合规则", productPack);
					throw new WrongEntityException("定制文本不符合规则");
				}
			}
		}

		// 得到包裹所有SKUCODE
		List<String> skuCodes = Lists.newArrayList();
		Map<String, Integer> quantityMap = new HashMap<>();

		List<SSkuPointExchangeQueryDTO> pointExchangeQueryDTOList = new ArrayList<>();

		List<String> skusLocal = new ArrayList<>();
		List<String> skusDelivery = new ArrayList<>();
		for (CartProductPack pack : packs) {

			setSkuDelivery(pack, skuCodes, quantityMap, pointExchangeQueryDTOList, skusLocal, skusDelivery);

			// 赠品也要进行处理
			if (CollectionUtils.isNotEmpty(pack.getGiftPacks())) {

				for (CartProductPack giftPack : pack.getGiftPacks()) {
					setSkuDelivery(giftPack, skuCodes, quantityMap, pointExchangeQueryDTOList, skusLocal, skusDelivery);
				}

			}

			// 如果是野兽课堂需验证课堂购买数量，以及可用积分
			if (OrderBusinessType.CLASSROOM.equals(orderConfirmDTO.getOrderType())) {

				// 判断可用积分
				BigDecimal point = memberPointService.findCommonValidMemberLevelByparam(member.getId(),member.getCode());
				if(point ==null ){
					throw new WrongArgException("查询积分异常memberPointService.findCommonValidMemberLevelByparam(memberId)："+member.getId());
				}
				
				if(point.subtract(orderConfirmDTO.getPoint()).doubleValue() < 0){
					throw new WrongArgException(pack.getSpv().getProductName() + "积分不足，实际可用积分:" + point
					+ ",当前使用积分:" + orderConfirmDTO.getPoint() + ".");
				}
				// 判断课堂数量
				ServiceResp<Integer> resp = frontBeastCourseService.getBeastSessionRemainNum(pack.getSpv().getSkuCode());
				if(resp!=null && resp.getBean() != null){
					
					if(resp.getBean() < pack.getCount()){
						throw new WrongArgException(pack.getSpv().getProductName() + "库存不足，实际库存:" + resp.getBean()
						+ ",当前购买:" + pack.getCount() + ".");
					}
					
				} else {
					throw new WrongArgException("验证野兽课堂数量异常："+resp.getRespMsg());
				}

			}

		}

		if (OrderBusinessType.EXCHANGE.equals(orderConfirmDTO.getOrderType())) {
			// 兑换商品库存验证
			ServiceResp<List<SSkuPointExchangeStockVO>> resp = sStockService
					.getPointExchangeStocks(pointExchangeQueryDTOList);
			if (resp.isFailure() || resp.getBean() == null) {
				throw new WrongArgException("查询积分竞换库存异常," + resp.getRespMsg());
			}
			List<SSkuPointExchangeStockVO> pointExchangeStocks = resp.getBean();
			if (CollectionUtils.isNotEmpty(pointExchangeStocks)) {

				for (SSkuPointExchangeStockVO bean : pointExchangeStocks) {
					if (quantityMap.get(bean.getReferenceCode()) > bean.getCanUseQuantity()) {

						throw new WrongArgException(bean.getReferenceCode() + "库存不足，实际库存:" + bean.getCanUseQuantity()
								+ ",当前购买:" + quantityMap.get(bean.getReferenceCode()) + ".");
					}
				}

			} else {
				throw new WrongArgException("查询积分竞换库存异常。");
			}

		}
		// 线下渠道
		if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
			// 生日花验证
			checkBirthFlower(skuCodes, opChannel, member, orderCreate);
		} else {

			// 校验商品包是否包含预告商品
			forecastAdapter.checkOrderPacksForecast(packs, member.getMemberLevel());
		}

		if (skusDelivery.size() > 0) {
			if (orderConfirmDTO.getAddressId() == 0) {
				throw new WrongArgException("当前订单为配送/预售订单,请先完善配送地址!", "addressId", "");
			}

		}

		checkContainsPreSale(packs, opChannel, sPresaleMap, sPresaleSaleInvMap, skuCodes, skusLocal, skusDelivery,
				orderCreate);

	}

	private void setSkuDelivery(CartProductPack pack, List<String> skuCodes, Map<String, Integer> quantityMap,
			List<SSkuPointExchangeQueryDTO> pointExchangeQueryDTOList, List<String> skusLocal,
			List<String> skusDelivery) {

		// 不是组合商品时，组合商品暂时不会出现组合商品
		if (!pack.getSpv().getCombined()) {

			if (pack.getSpv().getSkuCode() != null) {
				if (!skuCodes.contains(pack.getSpv().getSkuCode())) {
					skuCodes.add(pack.getSpv().getSkuCode());

				}

				Integer quantity = quantityMap.get(pack.getSpv().getSkuCode());
				if (quantity == null) {
					quantityMap.put(pack.getSpv().getSkuCode(), pack.getCount());
				} else {
					quantityMap.put(pack.getSpv().getSkuCode(), quantity + pack.getCount());
				}

				SSkuPointExchangeQueryDTO dto = new SSkuPointExchangeQueryDTO();
				dto.setExchgTypeEnum(ExchgTypeEnum.SPU);
				dto.setReferenceCode(pack.getSpv().getSkuCode());
				pointExchangeQueryDTOList.add(dto);

				if (CollectionUtils.isNotEmpty(pack.getDeliverys())) {

					for (ScDeliveryVO vo : pack.getDeliverys()) {

						if (vo.getType() == com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {

							if (vo.getCount() > 0) {
								skusDelivery.add(pack.getSpv().getSkuCode());
							}

						} else {
							if (vo.getCount() > 0) {
								skusLocal.add(pack.getSpv().getSkuCode());
							}
						}

					}

				}

			}
		} else {
			// 如果是组合商品
			if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {

				for (PsSkuCombinationVO skucom : pack.getSpv().getSkuCombinationList()) {

					if (!skuCodes.contains(skucom.getSubSkuCode())) {
						skuCodes.add(skucom.getSubSkuCode());

					}

					Integer quantity = quantityMap.get(skucom.getSubSkuCode());
					if (quantity == null) {
						quantityMap.put(skucom.getSubSkuCode(), skucom.getQuantity());
					} else {
						quantityMap.put(skucom.getSubSkuCode(), quantity + skucom.getQuantity());
					}

					SSkuPointExchangeQueryDTO dto = new SSkuPointExchangeQueryDTO();
					dto.setExchgTypeEnum(ExchgTypeEnum.SPU);
					dto.setReferenceCode(skucom.getSubSkuCode());
					pointExchangeQueryDTOList.add(dto);

					if (CollectionUtils.isNotEmpty(pack.getDeliverys())) {

						for (ScDeliveryVO vo : pack.getDeliverys()) {

							if (vo.getType() == com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {

								if (vo.getCount() > 0) {
									skusDelivery.add(skucom.getSubSkuCode());
								}

							} else {
								if (vo.getCount() > 0) {
									skusLocal.add(skucom.getSubSkuCode());
								}
							}

						}

					}
				}

			}
		}

	}

	public Boolean orderPay(String orderCode, Integer paymentType, BigDecimal totalAmount, String tradeNo) {
		try {

			// XXX:是否有必要给支付价格呢
			// 支付账号
			String _payAccount = "";
			return pcInstance.orderPay(orderCode, paymentType, totalAmount, _payAccount, tradeNo);

		} catch (Exception e) {
			logger.error("订单支付异常! e={}", e);
		}
		return false;
	}

	/**
	 * 获取商品包是否需要客户备注
	 *
	 * @param packs
	 * @return
	 */
	public Boolean getCanRemark(List<? extends ProductPack> packs) {
		if (!CollectionUtils.isEmpty(packs)) {
			List<String> skus = Lists.newArrayList();
			for (ProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				if (spv.getCombined() && CollectionUtils.isNotEmpty(spv.getSkuCombinationList())) {
					for (PsSkuCombinationVO skucombing : spv.getSkuCombinationList()) {
						skus.add(skucombing.getSubSkuCode());
					}
				} else {
					skus.add(spv.getSkuCode());
				}
			}
			List<PsSkuVO> skuList = mcPsSkuService.findBySkuCodes(skus);
			if (!CollectionUtils.isEmpty(skuList)) {
				for (PsSkuVO psSkuVO : skuList) {
					if (NullUtil.isNotNull(psSkuVO.getCanRemark()) && 1 == psSkuVO.getCanRemark()) {
						return true;
					}
				}
			}
		}
		return false;
	}

	/**
	 * 获取所有可用支付方式
	 * 
	 * @param isOverSea
	 *            是否是海淘
	 * @return
	 */
	public List<PaymentType> getPayMethods(boolean isOverSea) {
		List<PaymentType> payMethods = Lists.newArrayList();
		if (isOverSea) {
			payMethods.add(PaymentType.ALIPAY);
		} else {
			payMethods.add(PaymentType.ALIPAY);
			payMethods.add(PaymentType.WEIXIN);
		}
		return payMethods;
	}

	/**
	 * 下单前商品验证
	 *
	 * @param skuCodes
	 * @param opChannel
	 * @param member
	 */
	private void checkBirthFlower(List<String> skuCodes, OpChannelVO opChannel, MemberVO member,
			OrderCreateVO orderCreate) {

		List<String> birthSkuCodes = new ArrayList<>();
		// 判断商品中有几个生日花
		for (String birthCode : mapBirthFlower.values()) {

			if (skuCodes.contains(birthCode)) {
				birthSkuCodes.add(birthCode);
			}

		}
		// 如果存在生日花时，进行验证
		if (birthSkuCodes.size() > 0) {

			if (birthSkuCodes.size() > 1) {
				throw new WrongArgException("生日花束仅能领取一束。");
			}

			if (member == null) {
				throw new WrongArgException("生日花束必须绑定会员，不允许匿名领取.");
			}

			ServiceResp<Boolean> resp = memberService.checkToUseBdayFlower(member.getId());

			// 验证用户是否可以领取生日 花
			if (resp.isFailure() || resp.getBean() == false) {
				throw new WrongArgException(resp.getRespMsg());
			}

			MemberVO member2 = memberQueryService.getById(member.getId());
			String birthSkuCode = mapBirthFlower.get(member2.getMemberLevel());
			if (!birthSkuCodes.get(0).equals(birthSkuCode)) {
				throw new WrongArgException("当前等级会员只能领取:" + birthSkuCode + ",不能领取:" + birthSkuCodes.get(0));
			}

			orderCreate.setBirthFlowerUse(true);
		}

	}

	/**
	 * 检查是否包含预售商品
	 *
	 * @Methods Name checkContainsPreSale
	 * @Create In 2017-11-2 By Xiang.Gao
	 * @param packs
	 * @return boolean
	 */
	public boolean checkContainsPreSale(List<CartProductPack> packs, OpChannelVO opChannel,
			Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap,
			List<String> skuCodes, List<String> skusLocal, List<String> skusDelivery, OrderCreateVO orderCreate) {

		Map<String, String> skuWarehouseMap = new HashMap<>();

		/**
		 * 预售信息
		 */
		Map<String, SPresaleVO> skuPresaleWarehouseMap = new HashMap<>();
		// // 实际库存
		// Map<String, SSkuStockVO> sSkuStockVOMap = new HashMap<>();
		//
		// boolean localStock = true;
		//
		// boolean headStock = false;
		//
		// boolean presaleStock = false;
		//
		// List<Map<String, SSkuStockVO>> stockMapList = new ArrayList<>();

		Map<String, SPresaleVO> spMap = null;

		if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
			spMap = sPresaleService.findAvaliableBySkuCodes(skuCodes, true);
		} else {
			spMap = sPresaleService.findAvaliableBySkuCodes(skuCodes, false);
		}

		if (spMap != null) {
			sPresaleMap.putAll(spMap);
		}
		// List<String> skuCodes = new ArrayList<>(quantityMap.size());
		// skuCodes.addAll(quantityMap.keySet());

		List<String> codes = Lists.newArrayList();

		if (sPresaleMap != null && sPresaleMap.size() > 0) {
			Map<String, SPresaleSaleInvVO> spaleInvMap = null;
			Set<String> set = sPresaleMap.keySet();
			codes.addAll(set);
			if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
				spaleInvMap = sPresaleService.findCanUseQttBySkuCodes(codes, OpPresaleVO.CHANNEL_TYPE_OFFLINE);
			} else {
				spaleInvMap = sPresaleService.findCanUseQttBySkuCodes(codes, null);
			}

			if (spaleInvMap != null) {
				sPresaleSaleInvMap.putAll(spaleInvMap);
			}

		}

		// 如果是线下，是预售的情况要先判断实际库存
		if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {

			List<Map<String, SSkuStockVO>> stockMapList = new ArrayList<>();

			if (CollectionUtils.isNotEmpty(packs)) {
				Map<String, PsSkuVO> skuVOMap = mcPsSkuService.getBySkuCodes(skuCodes);

				// 本地库存
				Map<String, SSkuStockVO> skuLocalStockVOMap = null;
				if (CollectionUtils.isNotEmpty(skusLocal)) {
					// 本地库存
					skuLocalStockVOMap = sStockService.getSkuStocks(skusLocal, opChannel.getWarehouseForSales());
				}

				List<ChannelWarehouseVO> cwList = channelQueryService
						.getChannelWarehouseByChannelId(opChannel.getId().intValue());

				if (CollectionUtils.isNotEmpty(cwList)) {

					for (ChannelWarehouseVO cwVO : cwList) {
						// 查询总仓库存
						Map<String, SSkuStockVO> skuStockVOMap = sStockService.getSkuStocks(skuCodes, cwVO.getCode());

						if (skuStockVOMap != null) {
							stockMapList.add(skuStockVOMap);
						}
					}
				}

				for (CartProductPack pack : packs) {

					setSkuWarehouse(pack, spMap, skuVOMap, skuWarehouseMap, skuLocalStockVOMap, sPresaleSaleInvMap,
							skuPresaleWarehouseMap, sPresaleMap, stockMapList, opChannel, cwList);

					if (CollectionUtils.isNotEmpty(pack.getGiftPacks())) {

						for (CartProductPack gfitPack : pack.getGiftPacks()) {

							setSkuWarehouse(gfitPack, spMap, skuVOMap, skuWarehouseMap, skuLocalStockVOMap,
									sPresaleSaleInvMap, skuPresaleWarehouseMap, sPresaleMap, stockMapList, opChannel,
									cwList);
						}

					}

				}

			}

			//
			// List<ChannelWarehouseVO> cwList = channelQueryService
			// .getChannelWarehouseByChannelId(opChannel.getId().intValue());
			//
			// if (CollectionUtils.isNotEmpty(cwList)) {
			//
			// for (ChannelWarehouseVO cwVO : cwList) {
			// // 查询总仓库存
			// Map<String, SSkuStockVO> skuStockVOMap =
			// sStockService.getSkuStocks(skuCodes, cwVO.getCode());
			//
			// if (skuStockVOMap != null) {
			// stockMapList.add(skuStockVOMap);
			// }
			// }
			//
			// }
			//
			// // 线下有三种库存（本地，总仓，预售）所有商品统取，不可分开，先取本地，在取总仓，最后是预售
			// for (String skuCode : skuCodes) {
			//
			// PsSkuVO skuVo = skuVOMap.get(skuCode);
			// if (skuVo != null && skuVo.getIsJit() != null && skuVo.getIsJit()
			// == 1) {
			// logger.info("jit商品不验证库存");
			// continue;
			// }
			//
			// Integer stock = 0;
			// SSkuStockVO skuStock = sSkuStockVOMap.get(skuCode);
			// Integer quantity = quantityMap.get(skuCode);
			// if (quantity == null) {
			// quantity = 1;
			// }
			//
			// if (skuStock != null) {
			//
			// stock = skuStock.getCanUseQuantity();
			//
			// }
			//
			// // 本地可用库存小于购买数量时
			// if (stock >= quantity) {
			// logger.info(skuCode + ",本地库存：stock:{},当前购买:{}", stock, quantity);
			// continue;
			// } else {
			// logger.info(skuCode + ",本地库存不足：stock:{},当前购买:{}", stock,
			// quantity);
			//
			// SPresaleSaleInvVO presaleSkuStock =
			// sPresaleSaleInvMap.get(skuCode);
			//
			// if (presaleSkuStock != null) {
			// stock = presaleSkuStock.getCanUseInv();
			// }
			// if (stock >= quantity) {
			// logger.info(skuCode + ",预售仓库存：stock:{},当前购买:{}", stock,
			// quantity);
			// continue;
			// } else {
			// logger.info(skuCode + ",预售仓库存不足：stock:{},当前购买:{}", stock,
			// quantity);
			// boolean stockflg = true;
			//
			// if (CollectionUtils.isNotEmpty(stockMapList)) {
			//
			// // 循环所有逻辑仓
			// for (Map<String, SSkuStockVO> stockMap : stockMapList) {
			//
			// SSkuStockVO SkuStock = stockMap.get(skuCode);
			// String warehouseCode = "";
			// if (SkuStock != null) {
			// stock = SkuStock.getCanUseQuantity();
			// warehouseCode = SkuStock.getWarehouseCode();
			// }
			//
			// // 当前库存大于或等于够买数量时
			// if (stock >= quantity) {
			// logger.info(skuCode + "在" + warehouseCode +
			// "有库存：stock:{},当前购买:{}", stock,
			// quantity);
			// stockflg = false;
			// break;
			//
			// }
			//
			// }
			//
			// }
			//
			// if (stockflg) {
			//
			// PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
			// throw new WrongArgException(skuVO.getSkuNameCN() + "商品库存不足。");
			//
			// }
			//
			// }
			// }
			//
			// }
			//
			// String warehouseForSales = "";
			//
			// // 先查询本地库存
			// if (localStock) {
			//
			// for (String skuCode : skuCodes) {
			// PsSkuVO skuVo = skuVOMap.get(skuCode);
			//
			// if (skuVo != null && skuVo.getIsJit() != null && skuVo.getIsJit()
			// == 1) {
			// warehouseForSales = opChannel.getWarehouseForSales();
			// continue;
			// }
			//
			// SSkuStockVO skuStock = sSkuStockVOMap.get(skuCode);
			//
			// if (skuStock == null) {
			// headStock = true;
			// localStock = false;
			// break;
			// } else {
			// warehouseForSales = skuStock.getWarehouseCode();
			// // 取得购买数量
			// Integer quantity = quantityMap.get(skuCode);
			// if (quantity == null) {
			// quantity = 1;
			// }
			//
			// // 本地可用库存小于购买数量时
			// if (skuStock.getCanUseQuantity() < quantity) {
			// headStock = true;
			// localStock = false;
			// warehouseForSales = "";
			// break;
			// }
			// }
			//
			// }
			// }
			//
			// if (headStock) {
			//
			// if (stockMapList.size() > 0) {
			//
			// for (Map<String, SSkuStockVO> stockMap : stockMapList) {
			//
			// if (StringUtils.isNotBlank(warehouseForSales)) {
			// break;
			// }
			//
			// presaleStock = false;
			// headStock = true;
			//
			// for (String skuCode : skuCodes) {
			//
			// SSkuStockVO skuStock = stockMap.get(skuCode);
			//
			// if (skuStock != null) {
			// warehouseForSales = skuStock.getWarehouseCode();
			// Integer quantity = quantityMap.get(skuCode);
			// if (quantity == null) {
			// quantity = 1;
			// }
			// if (skuStock.getCanUseQuantity() < quantity) {
			// warehouseForSales = "";
			// presaleStock = true;
			// headStock = false;
			// break;
			// }
			//
			// } else {
			// warehouseForSales = "";
			// presaleStock = true;
			// headStock = false;
			// break;
			// }
			//
			// }
			//
			// }
			//
			// } else {
			// presaleStock = true;
			// headStock = false;
			// }
			// }
			//
			// if (StringUtils.isNotBlank(warehouseForSales)) {
			// presaleStock = false;
			// }
			//
			// if (presaleStock) {
			//
			// if (sPresaleSaleInvMap.size() > 0) {
			// for (String skuCode : skuCodes) {
			//
			// SPresaleSaleInvVO skuStock = sPresaleSaleInvMap.get(skuCode);
			// if (skuStock == null) {
			// presaleStock = false;
			// warehouseForSales = "";
			// break;
			// } else {
			//
			// SPresaleVO sPresaleVO = sPresaleMap.get(skuCode);
			// if (sPresaleVO != null) {
			// warehouseForSales = sPresaleVO.getDispatchWarehouseCode();
			// }
			//
			// // 取得购买数量
			// Integer quantity = quantityMap.get(skuCode);
			// if (quantity == null) {
			// quantity = 1;
			// }
			//
			// // 本地可用库存小于购买数量时
			// if (skuStock.getCanUseInv() < quantity) {
			// presaleStock = false;
			// warehouseForSales = "";
			// break;
			// }
			// }
			//
			// }
			// } else {
			// presaleStock = false;
			// }
			//
			// }
			//
			// // 没有统一库存的时候
			// if (StringUtils.isBlank(warehouseForSales) && !presaleStock) {
			// throw new WrongArgException("不同发货仓商品无法同时下单。");
			// }
			//
			// if (headStock || presaleStock) {
			//
			// if (orderConfirmDTO.getAddressId() == 0) {
			// throw new WrongArgException("当前订单为配送/预售订单,请先完善配送地址!",
			// "addressId", "");
			// }
			//
			// if (headStock) {
			//
			// // 如果是线下，配送商品支付金额超过5000元。不可下单
			// // if (orderConfirmDTO.getPrice() != null &&
			// // orderConfirmDTO.getPrice().doubleValue() > 5000) {
			// //
			// // throw new WrongArgException("配送商品金额不可超过5000元。");
			// //
			// // }
			//
			// orderCreate.setWarehouseForSales(warehouseForSales);
			// orderCreate.setStockDistinguish(2);
			//
			// } else if (presaleStock) {
			// orderCreate.setStockDistinguish(3);
			// } else {
			// orderCreate.setStockDistinguish(1);
			// }
			//
			// }
			//

			orderCreate.setSkuPresaleWarehouseMap(skuPresaleWarehouseMap);
			orderCreate.setSkuWarehouseMap(skuWarehouseMap);
		}
		return true;
	}

	private void setSkuWarehouse(CartProductPack pack, Map<String, SPresaleVO> spMap, Map<String, PsSkuVO> skuVOMap,
			Map<String, String> skuWarehouseMap, Map<String, SSkuStockVO> skuLocalStockVOMap,
			Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap, Map<String, SPresaleVO> skuPresaleWarehouseMap,
			Map<String, SPresaleVO> sPresaleMap, List<Map<String, SSkuStockVO>> stockMapList, OpChannelVO opChannel,
			List<ChannelWarehouseVO> cwList) {

		// 不是组合商品时，组合商品暂时不会出现组合商品
		if (!pack.getSpv().getCombined()) {

			if (pack.getSpv().getSkuCode() != null) {

				PsSkuVO sku = skuVOMap.get(pack.getSpv().getSkuCode());

				// 如果是来单制作，不验证库存，默认当前渠道仓
				if (sku.getIsJit() != null && sku.getIsJit() == 1) {
					if (CollectionUtils.isNotEmpty(pack.getDeliverys())) {

						for (ScDeliveryVO vo : pack.getDeliverys()) {

							if (vo.getType() != com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {
								skuWarehouseMap.put(pack.getSpvId() + pack.getSpv().getSkuCode()
										+ +com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0
										+ vo.getCount(), opChannel.getWarehouseForSales());
							} else {

								if (CollectionUtils.isEmpty(cwList)) {
									throw new WrongArgException(sku.getSkuNameCN() + "当前渠道未设置配送仓");
								}

								skuWarehouseMap.put(pack.getSpvId() + pack.getSpv().getSkuCode()
										+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1
										+ vo.getCount(), cwList.get(0).getCode());

							}

						}

					}

				} else {

					if (CollectionUtils.isNotEmpty(pack.getDeliverys())) {

						for (ScDeliveryVO vo : pack.getDeliverys()) {

							if (vo.getType() != com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {

								// 如果不是来单制作商品，需要验证库存，默认当前渠道仓
								SSkuStockVO stock = skuLocalStockVOMap.get(pack.getSpv().getSkuCode());
								if (stock != null) {

									if (stock.getCanUseQuantity() < vo.getCount()) {
										throw new WrongArgException(
												sku.getSkuNameCN() + "商品库存不足，剩余库存：" + stock.getCanUseQuantity());
									}

								} else {
									throw new WrongArgException(pack.getSpv().getSkuCode() + ",未查到库存信息。");
								}

								skuWarehouseMap.put(pack.getSpvId() + pack.getSpv().getSkuCode()
										+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0
										+ vo.getCount(), opChannel.getWarehouseForSales());
							} else {

								boolean stockBool = false;

								String key = pack.getSpvId() + pack.getSpv().getSkuCode()
										+ +com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1
										+ vo.getCount();

								for (Map<String, SSkuStockVO> skuStockVOMap : stockMapList) {

									SSkuStockVO sSkuStockVO = skuStockVOMap.get(pack.getSpv().getSkuCode());

									if (sSkuStockVO != null && sSkuStockVO.getCanUseQuantity() >= vo.getCount()) {

										skuWarehouseMap.put(key, sSkuStockVO.getWarehouseCode());
										stockBool = true;
										break;
									}

								}

								if (!stockBool) {
									// 判断商品是否预售
									SPresaleSaleInvVO sPresaleSaleInvVO = sPresaleSaleInvMap
											.get(pack.getSpv().getSkuCode());

									if (sPresaleSaleInvVO != null) {

										if (sPresaleSaleInvVO.getCanUseInv() < vo.getCount()) {
											throw new WrongArgException(sku.getSkuNameCN() + "预售商品库存不足，剩余库存："
													+ sPresaleSaleInvVO.getCanUseInv());
										}

										SPresaleVO sPresaleVO = sPresaleMap.get(pack.getSpv().getSkuCode());

										key = pack.getSpvId() + pack.getSpv().getSkuCode()
												+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1
												+ vo.getCount();
										skuWarehouseMap.put(key, sPresaleVO.getDispatchWarehouseCode());

										skuPresaleWarehouseMap.put(key, sPresaleVO);
										stockBool = true;
									}
								}

								if (!stockBool) {

									throw new WrongArgException(sku.getSkuNameCN() + "配送仓商品库存不足，请核实剩余库存！");
								}

							}

						}

					}

				}

			}
		} else {
			// 如果是组合商品
			if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {

				for (PsSkuCombinationVO skucom : pack.getSpv().getSkuCombinationList()) {

					PsSkuVO sku = skuVOMap.get(skucom.getSubSkuCode());

					// 如果是来单制作，不验证库存，默认当前渠道仓
					if (sku.getIsJit() != null && sku.getIsJit() == 1) {

						for (ScDeliveryVO vo : pack.getDeliverys()) {

							skuWarehouseMap.put(
									pack.getSpvId() + skucom.getSubSkuCode() + vo.getType() + vo.getCount(),
									opChannel.getWarehouseForSales());
						}

					} else {

						if (CollectionUtils.isNotEmpty(pack.getDeliverys())) {

							for (ScDeliveryVO vo : pack.getDeliverys()) {

								if (vo.getType() != com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1) {
									// 如果不是来单制作商品，需要验证库存，默认当前渠道仓
									SSkuStockVO stock = skuLocalStockVOMap.get(skucom.getSubSkuCode());
									if (stock != null) {

										if (stock.getCanUseQuantity() < vo.getCount() * skucom.getQuantity()) {
											throw new WrongArgException(
													sku.getSkuNameCN() + "商品库存不足，剩余库存：" + stock.getCanUseQuantity());
										}

										skuWarehouseMap.put(pack.getSpvId() + skucom.getSubSkuCode()
												+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_0
												+ vo.getCount(), opChannel.getWarehouseForSales());

									} else {
										throw new WrongArgException(skucom.getSubSkuCode() + ",未查到库存信息。");
									}
								} else {

									// 判断商品是否预售
									SPresaleSaleInvVO sPresaleSaleInvVO = sPresaleSaleInvMap
											.get(skucom.getSubSkuCode());

									if (sPresaleSaleInvVO != null) {

										if (sPresaleSaleInvVO.getCanUseInv() < vo.getCount()) {
											throw new WrongArgException(sku.getSkuNameCN() + "预售商品库存不足，剩余库存："
													+ sPresaleSaleInvVO.getCanUseInv());
										}

										SPresaleVO sPresaleVO = sPresaleMap.get(pack.getSpv().getSkuCode());
										// 预售对像为空时提示信息
                                        if(sPresaleVO == null){
                    						throw new WrongArgException(sku.getSkuNameCN() + "预售信息未取到");
										}
										String key = pack.getSpvId() + skucom.getSubSkuCode()
												+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1
												+ vo.getCount();
										

										skuWarehouseMap.put(key, sPresaleVO.getDispatchWarehouseCode());

										skuPresaleWarehouseMap.put(key, sPresaleVO);
									} else {

										String key = pack.getSpvId() + skucom.getSubSkuCode()
												+ com.thebeastshop.pegasus.channelservice.util.ConstUtil.deliveryType_1
												+ vo.getCount();

										for (Map<String, SSkuStockVO> skuStockVOMap : stockMapList) {

											SSkuStockVO sSkuStockVO = skuStockVOMap.get(skucom.getSubSkuCode());

											if (sSkuStockVO != null
													&& sSkuStockVO.getCanUseQuantity() >= vo.getCount()) {

												skuWarehouseMap.put(key, sSkuStockVO.getWarehouseCode());

												break;
											}

										}

										if (skuWarehouseMap.get(key) == null) {

											throw new WrongArgException(sku.getSkuNameCN() + "配送仓商品库存不足，请核实剩余库存！");
										}

									}

								}

							}
						}

					}

				}

			}
		}

	}

}
