// package com.thebeastshop.pegasus.channelservice.adapter.order;
//
// import java.math.BigDecimal;
// import java.math.RoundingMode;
// import java.util.ArrayList;
// import java.util.Arrays;
// import java.util.Collection;
// import java.util.Date;
// import java.util.HashMap;
// import java.util.List;
// import java.util.Map;
// import java.util.Map.Entry;
// import java.util.Set;
// import java.util.concurrent.TimeUnit;
//
// import org.apache.commons.collections.CollectionUtils;
// import org.apache.commons.lang.StringUtils;
// import org.slf4j.Logger;
// import org.slf4j.LoggerFactory;
// import org.springframework.beans.factory.annotation.Autowired;
// import org.springframework.stereotype.Component;
//
// import com.google.common.collect.Lists;
// import com.google.common.collect.Maps;
// import com.thebeastshop.campaign.service.CampaignQueryService;
// import com.thebeastshop.campaign.vo.CampaignDetailVO;
// import com.thebeastshop.cart.ProductPack;
// import com.thebeastshop.cart.resp.CartProductPack;
// import com.thebeastshop.cart.service.CartService;
// import com.thebeastshop.commdata.service.ChannelQueryService;
// import com.thebeastshop.commdata.vo.ChannelWarehouseVO;
// import com.thebeastshop.common.ServiceResp;
// import com.thebeastshop.common.enums.AccessWayEnum;
// import com.thebeastshop.common.enums.MemberLevelEnum;
// import com.thebeastshop.coupon.service.CpCouponService;
// import com.thebeastshop.coupon.vo.CpCouponVO;
// import com.thebeastshop.member.service.IdCardQueryService;
// import com.thebeastshop.member.service.MemberAddressService;
// import com.thebeastshop.member.service.MemberQueryService;
// import com.thebeastshop.member.service.MemberService;
// import com.thebeastshop.member.vo.MemIdCardVO;
// import com.thebeastshop.member.vo.MemberAddressVO.District;
// import com.thebeastshop.member.vo.MemberVO;
// import com.thebeastshop.pegasus.channelservice.adapter.ComOrderAdapter;
// import
// com.thebeastshop.pegasus.channelservice.adapter.apiaddressfilter.AppEmojiFilter;
// import
// com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
// import
// com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
// import
// com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
// import com.thebeastshop.pegasus.channelservice.enums.OrderFlowState;
// import com.thebeastshop.pegasus.channelservice.enums.OrderParcelState;
// import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
// import com.thebeastshop.pegasus.channelservice.model.OrderFeeVO;
// import com.thebeastshop.pegasus.channelservice.model.PriceResult;
// import com.thebeastshop.pegasus.channelservice.model.PriceStep;
// import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
// import com.thebeastshop.pegasus.channelservice.service.LabelService;
// import com.thebeastshop.pegasus.channelservice.service.OverseaService;
// import com.thebeastshop.pegasus.channelservice.service.PostageService;
// import com.thebeastshop.pegasus.channelservice.service.PriceService;
// import com.thebeastshop.pegasus.channelservice.service.ProductCouponService;
// import com.thebeastshop.pegasus.channelservice.service.price.OrderPrice;
// import
// com.thebeastshop.pegasus.channelservice.service.price.service.OrderPriceService;
// import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
// import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
// import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
// import com.thebeastshop.pegasus.component.campaign.CampaignResult;
// import com.thebeastshop.pegasus.component.discount.DiscountType;
// import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
// import com.thebeastshop.pegasus.component.time.TimeSlot;
// import com.thebeastshop.pegasus.component.time.service.TimeSlotService;
// import com.thebeastshop.pegasus.merchandise.IService.IInterestFreeService;
// import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
// import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
// import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
// import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
// import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
// import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
// import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
// import
// com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
// import
// com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
// import
// com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderResponseVO;
// import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
// import
// com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
// import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
// import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
// import com.thebeastshop.pegasus.service.operation.exception.ChannelException;
// import
// com.thebeastshop.pegasus.service.operation.exception.ChannelExceptionErrorCode;
// import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
// import
// com.thebeastshop.pegasus.service.purchase.PegasusPurchaseServiceFacade;
// import com.thebeastshop.pegasus.service.warehouse.WMSConstants.ExpressType;
// import com.thebeastshop.pegasus.util.PegasusUtilFacade;
// import com.thebeastshop.pegasus.util.comm.ConstUtil;
// import com.thebeastshop.pegasus.util.comm.DateUtil;
// import com.thebeastshop.pegasus.util.comm.NumberUtil;
// import com.thebeastshop.pegasus.util.model.CommDistrict;
// import com.thebeastshop.scm.vo.interest.InterestFreeUseVO;
// import com.thebeastshop.scm.vo.interest.InterestFreeVO;
// import com.thebeastshop.stock.service.SPresaleService;
// import com.thebeastshop.stock.service.SStockService;
// import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
// import com.thebeastshop.stock.vo.SPresaleVO;
// import com.thebeastshop.stock.vo.SSkuStockVO;
// import com.thebeastshop.support.Constant;
// import com.thebeastshop.support.Label;
// import com.thebeastshop.support.enums.CartPackSource;
// import com.thebeastshop.support.enums.OrderBusinessType;
// import com.thebeastshop.support.enums.OrderState;
// import com.thebeastshop.support.enums.PaymentType;
// import com.thebeastshop.support.enums.PriceType;
// import com.thebeastshop.support.exception.UnknownException;
// import com.thebeastshop.support.exception.WrongArgException;
// import com.thebeastshop.support.util.EnumUtil;
// import com.thebeastshop.support.util.PriceUtil;
// import com.thebeastshop.support.vo.cart.CartProductPackVO;
// import com.thebeastshop.support.vo.cart.RequestPack;
// import com.thebeastshop.support.vo.logistics.DeliverableVO;
// import com.thebeastshop.support.vo.logistics.PostageVO;
// import com.thebeastshop.support.vo.member.MemberAddressVO;
// import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
// import com.thebeastshop.support.vo.order.OrderCard;
// import com.thebeastshop.support.vo.order.OrderConfirmDTO;
// import com.thebeastshop.support.vo.order.OrderConfirmVO;
// import com.thebeastshop.support.vo.order.OrderConfirmVO.BdayVO;
// import com.thebeastshop.support.vo.order.OrderDetailVO;
// import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
// import com.thebeastshop.support.vo.order.OrderPreviewDTO;
// import com.thebeastshop.support.vo.order.OrderSimpleVO;
// import com.thebeastshop.support.vo.order.OrderSimpleVO.OrderStateVO;
//
/// ***订单适配器(目前针对app端)**
//
// @author
// Paul-xiong**/@Component("appOrderAdapter")
// public class OrderAdapter {
// private Logger logger = LoggerFactory.getLogger(this.getClass());
//
// private TimeSlotService timeSlotService =
// ComponentServiceLoader.getBean(TimeSlotService.class);
//
// private final PegasusChannelServiceFacade pcInstance =
// PegasusChannelServiceFacade.getInstance();
//
// private PegasusPurchaseServiceFacade phInstance =
// PegasusPurchaseServiceFacade.getInstance();
//
// @Autowired
// private OrderCommonAdapter orderCommonAdapter;
//
// @Autowired
// private MemberAddressService memberAddressService;
//
// @Autowired
// private ProductCouponService productCouponService;
//
// @Autowired
// private CartService cartService;
//
// @Autowired
// private OverseaService overseaService;
//
// @Autowired
// private PostageService postageService;
//
// @Autowired
// private CpCouponService cpCouponService;
//
// @Autowired
// private LogisticsAdapter logisticsAdapter;
//
// @Autowired
// private IdCardQueryService idCardQueryService;
// @Autowired
// private LabelService labelService;
//
// @Autowired
// private ComOrderAdapter comOrderAdapter;
//
// @Autowired
// private MemberAddressAdapter memberAddressAdapter;
// @Autowired
// private PriceService priceService;
// @Autowired
// private CartProductPackAdapter cartProductPackAdaptor;
// @Autowired
// private McPsSkuService mcPsSkuService;
// @Autowired
// private OrderPriceService orderPriceService;
//
// @Autowired
// private CampaignQueryService campaignQueryService;
//
// @Autowired
// private IInterestFreeService iInterestFreeService;
//
// @Autowired
// private CartProductPackAdapter cartProductPackAdapter;
//
// @Autowired
// private MemberQueryService memberQueryService;
//
// @Autowired
// private ChannelQueryService channelQueryService;
// // @Autowired
// // private CartInterestAdapter cartInterestAdapter;
// //
// // @Autowired
// // private MsgSendService msgSendService;
//
// // @Autowired
// // private MemberQueryService memberQueryService;
//
// // @Autowired
// // private IInterestGoodsService interestGoodsService;
//
// @Autowired
// private SPresaleService sPresaleService;
//
// @Autowired
// private SPresaleService presaleService;
//
// @Autowired
// private SStockService sStockService;
//
// @Autowired
// private MemberService memberService;
//
// // =================private=================
//
// /**
// * 获取前端的订单状态
// *
// * @return
// */
// private OrderState getOrderState(OpSalesOrderVO order) {
// OrderState state = OrderState.CANCELLED;
// if (order != null) {
// OrderFlowState flowState = EnumUtil.valueOf(order.getSalesOrderStatus(),
// OrderFlowState.class);
// switch (flowState) {
// case CREATED:
// case CUSTOMER_HUNG_UP:
// case CONFIRMED:
// state = OrderState.PAYING;
// break;
// case AUDIT_HUNG_UP:
// case PAID:
// state = OrderState.WAITING_DELIVER;
// break;
// case DONE:
// state = OrderState.DONE;
// break;
// case CANCELLED:
// state = OrderState.CANCELLED;
// break;
// default:
// boolean isDelivering = false;
// List<OpSoPackageVO> parcels = order.getOpSoPackageVOs();
// for (OpSoPackageVO parcel : parcels) {
// OrderParcelState parcelState = EnumUtil.valueOf(parcel.getPackageStatus(),
// OrderParcelState.class);
// if (parcelState != null &&
// (parcelState.equals(OrderParcelState.WAITING_RECEIVE)
// || parcelState.equals(OrderParcelState.ALREADY_RECEIVE)
// || parcelState.equals(OrderParcelState.ALREADY_DELIVER))) {
// isDelivering = true;
// }
// }
// if (isDelivering) {
// state = OrderState.DELIVERING;
// } else {
// state = OrderState.WAITING_DELIVER;
// }
// break;
// }
// }
// return state;
// }
//
// /**
// * 获取订单基础信息(排除获取订单中的商品包)
// *
// * @param order
// * @param member
// * @param channel
// * @return
// */
// public OrderSimpleVO getOrderSimpleWithoutPacks(OpSalesOrderVO order,
// MemberVO member, OpChannelVO opChannel) {
// OrderSimpleVO rt = new OrderSimpleVO();
// if (order != null) {
// try {
// // =============订单编号===============
// rt.setId(order.getCode());
// // =============创建时间===============
// rt.setCreateTime(order.getCreateTime());
// // =============支付有效时间============
// if (OrderFlowState.isConfirmed(order.getSalesOrderStatus())) {
// Date expireTime = DateUtil.addMinutes(order.getCreateTime(),
// Constant.MINUTES_TO_PAY);
// long payExpireTime = TimeUnit.MILLISECONDS
// .toSeconds(expireTime.getTime() - System.currentTimeMillis());
// if (payExpireTime >= 0) {
// rt.setPayExpireTime(payExpireTime);
// }
// }
// // =========是否包含海外购商品===========
// if (order.getCrossBorderFlag() != null &&
// order.getCrossBorderFlag().equals(1)) {
// rt.setHasOverseaProducts(true);
// } else {
// rt.setHasOverseaProducts(false);
// }
// // =========可用的支付方式===========
// rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));
// // ===============价格================
// rt.setPrice(order.getNeedToPayAmount());
// // ===============地址=================
// OpSoPackageDeliveryInfoVO parcelDelivery = order.getOpSoPackageVOs().get(0)
// .getOpSoPackageDeliveryInfoVO();
// if (parcelDelivery != null && parcelDelivery.getDistrictId() != null) {
// District district = new District();
// CommDistrict commonDistrict = PegasusUtilFacade.getInstance()
// .findDistrictById(parcelDelivery.getDistrictId());
// if (commonDistrict != null) {
// district.setId(commonDistrict.getId());
// district.setName(commonDistrict.getName());
// district.setFullName(commonDistrict.getFullName());
// com.thebeastshop.member.vo.MemberAddressVO address = new
// com.thebeastshop.member.vo.MemberAddressVO();
// address.setAddress(parcelDelivery.getAddress());
// address.setReceiver(parcelDelivery.getReceiver());
// address.setReceiverPhone(parcelDelivery.getReceiverPhone());
// address.setDistrict(district);
// address.setZipCode(parcelDelivery.getZipCode());
// MemberAddressVO addressVo = memberAddressAdapter.getMemberAddress(address,
// member);
// rt.setAddress(addressVo);
// }
// }
// // =============订单状态=============
// if (order.getSalesOrderStatus() != null) {
// OrderStateVO stateVO = new OrderStateVO();
//
// OrderState state = getOrderState(order);
// String desc = "";
// switch (state) {
// case CANCELLED:
// desc = "你的订单已取消。";
// break;
// case DELIVERING:
// if (order.getCrossBorderFlag() != null &&
// order.getCrossBorderFlag().equals(1)) {
// desc = "你的订单已发货";
// } else {
// desc = "你的订单已发货";
// }
// break;
// case DONE:
// desc = "你的订单已完成，祝你购物愉快！";
// break;
// case PAYING:
// if (rt.getPayExpireTime() > 0) {
// desc = "你的订单还未支付，订单将在{time}后取消";
// } else {
// state = OrderState.CANCELLED;
// desc = "你的订单已取消。";
// }
// break;
// case WAITING_DELIVER:
// desc = "你已下单成功，我们将尽快为您配送";
// break;
// default:
// break;
// }
// stateVO.setId(state.getId());
// stateVO.setType(state.toString());
// stateVO.setName(state.getName());
// stateVO.setDesc(desc);
// rt.setState(stateVO);
// }
// // ===================================
// } catch (Exception e) {
// logger.error("OrderAdapter获取订单基础信息异常：{}", e);
// }
// }
// return rt;
// }
//
// /**
// * 获取订单详情
// *
// * @param order
// * @return
// */
// public OrderDetailVO getOrderDetail(OpSalesOrderVO order, MemberVO member,
// OpChannelVO opChannel,
// AccessWayEnum accessWay) {
// if (order != null && CollectionUtils.isNotEmpty(order.getOpSoPackageVOs())) {
// List<OpSoPackageVO> parcels = order.getOpSoPackageVOs();
// OrderDetailVO rt = new OrderDetailVO();
// // ================订单包裹===============
// BigDecimal totalPrice = BigDecimal.ZERO;
// if (CollectionUtils.isNotEmpty(parcels)) {
// for (OpSoPackageVO parcel : parcels) {
// // ******商品包******
// List<OpSoPackageSkuVO> skus = parcel.getOpSoPackageSkuVOs();
// for (OpSoPackageSkuVO sku : skus) {
// // 商品总价
// Integer quantity = 0;
// if (sku.getQuantity() != null) {
// quantity += sku.getQuantity();
// }
// if (sku.getCancleQuantity() != null) {
// quantity += sku.getCancleQuantity();
// }
// totalPrice = totalPrice.add(PriceUtil.multiPrice(sku.getUnitPrice(),
// quantity));
// }
// }
// }
//
// // ********获取订单快照********
//
// List<OrderPrice> orderPrices =
// orderPriceService.selectByExample(order.getId());
//
// Collection<PriceStepVO> priceSteps = showPriceStepsByOrderShot(orderPrices,
// totalPrice,
// order.getNeedToPayAmount());
// rt.setPriceSteps(priceSteps);
// rt.setRemark(order.getRemark());
//
// return rt;
// } else {
// throw new UnknownException("订单下没有包裹");
// }
// }
//
// /**
// * 获取订单确认
// *
// * @param paramPacks
// * @param member
// * @param channel
// * @param accessWay
// * @param buyNow
// * 是否立即购买
// * @return
// */
// public OrderConfirmVO getOrderConfirmNew(OrderPreviewDTO orderPreview,
// List<CartProductPack> paramPacks,
// MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, Boolean
// buyNow) {
//
// if (CollectionUtils.isEmpty(paramPacks)) {
// throw new WrongArgException("商品包不能为空");
// }
//
// Long couponId = orderPreview.getCouponId();
// // String date = orderPreview.getDeliveryDate();
// int timeSlot = orderPreview.getDeliveryTimeSlot();
// Long addressId = orderPreview.getAddressId();
// boolean birthday = true;
// if (null != orderPreview.isUseBdayDiscount() &&
// !orderPreview.isUseBdayDiscount()) {
// logger.info("isUseBdayDiscount" + orderPreview.isUseBdayDiscount());
// birthday = false;
// }
//
// OrderConfirmVO rt = new OrderConfirmVO();
//
// boolean hasOverSea = overseaService.isOversea(paramPacks);// 判断是否有海外购商品
//
// CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
// //
// =============TODO:优惠券,现在数据库中字段的表示优惠口令（优惠码），暂时把优惠券id放在这个字段里，以后数据库中字段名应该改成couponId=============
//
// if (couponId != null && member != null) {
//
// // 判断优惠券是否可以使用
// ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId,
// member.getId(), opChannel.getCode());
// if (rsp == null || rsp.getBean() == null) {
// throw new WrongArgException("优惠券不可用!", "couponId", couponId);
// }
// if (!productCouponService.checkCoupon(paramPacks, rsp.getBean(), accessWay,
// member, opChannel)) {
// throw new WrongArgException("优惠券不可用!", "couponId", couponId);
// } else {
// calPriceDTO.setCouponId(couponId);
// }
//
// }
//
// // 价格计算
// calPriceDTO.setAccessWay(accessWay);
// calPriceDTO.setOpChannel(opChannel);
// calPriceDTO.setMember(member);
// calPriceDTO.setPacks(paramPacks);
// if (!birthday) {
// calPriceDTO.setBirthday(false);
// }
// PriceResult priceResult =
// priceService.calculateProductPackPrice(calPriceDTO);
// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
//
// // 校验赠品包
// cartProductPackAdapter.checGiftPacks(paramPacks,
// priceResult.getCampaignResults());
//
// // =============地址信息=============
// DeliverableVO deliverableTime = new DeliverableVO();
// com.thebeastshop.member.vo.MemberAddressVO address = null;
//
// if (member != null) {
//
// if (null != addressId && addressId != 0) {
// address = memberAddressService.getById(addressId);
// if (address != null) {
// MemberAddressVO deliveryAddress = new MemberAddressVO();
// deliveryAddress.setId(address.getId());
// deliveryAddress.setAsDefault(address.getAsDefault());
// DistrictVO district = new DistrictVO();
// district.setFullName(address.getDistrict().getFullName());
// district.setId(address.getDistrict().getId());
// district.setName(address.getDistrict().getName());
// deliveryAddress.setDistrict(district);
// deliveryAddress.setLocation(address.getAddress());
// logger.info("地址详情来一发 address:{},addressId:{},location:{}", address,
// addressId,
// address.getAddress());
// deliveryAddress.setReceiverName(address.getReceiver());
// deliveryAddress.setReceiverPhone(address.getReceiverPhone());
// deliveryAddress.setZipCode(address.getZipCode());
// rt.setAddress(deliveryAddress);
// } else {
// throw new WrongArgException("地址不可用！");
// }
// deliverableTime =
// logisticsAdapter.getDeliverableForOrderPreviewNew(paramPacks, address,
// member,
// accessWay, opChannel, orderPreview.getPostage(), hasOverSea, priceResult);
//
// } else {
//
// address = memberAddressService.getDefaultByOwnerId(member.getId());//
// 不传时使用默认地址
// rt.setAddress(memberAddressAdapter.getMemberAddress(address, member));
// deliverableTime =
// logisticsAdapter.getDeliverableForOrderPreviewNew(paramPacks, address,
// member,
// accessWay, opChannel, orderPreview.getPostage(), hasOverSea, priceResult);
// }
//
// }
//
// List<CartProductPackVO> packVOs =
// Lists.newArrayListWithExpectedSize(paramPacks.size());
//
// Integer type = OpPresaleVO.CHANNEL_TYPE_BEAST;
// if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
// type = OpPresaleVO.CHANNEL_TYPE_OFFLINE;
// }
// List<String> skuCodes = Lists.newArrayList();
//
// if (buyNow) {
//
// List<CartProductPackVO> tempPackVOs =
// cartProductPackAdaptor.getCartProductPackListNew(paramPacks, member,
// opChannel, true, true, true, campaignResults, accessWay, birthday, null);
//
// packVOs.addAll(tempPackVOs);
// Map<String, Date> spvPresaleDateMap = null;
// skuCodes = Lists.newArrayList();
//
// for (CampaignResult campaignResult : campaignResults) {
// if (campaignResult.isReach() &&
// campaignResult.getDiscountType().equals(DiscountType.GIFT)) {
// Collection<ProductPack> additionalPacks =
// campaignResult.getAdditionalPacks();
// for (ProductPack productPack : additionalPacks) {
//
// if (productPack.getSpv().getCombined()) {
// if (CollectionUtils.isNotEmpty(productPack.getSpv().getSkuCombinationList()))
// {
// //
// for (PsSkuCombinationVO psc : productPack.getSpv().getSkuCombinationList()) {
//
// if (psc.getSubSkuCode() != null && !skuCodes.contains(psc.getSubSkuCode())) {
//
// skuCodes.add(psc.getSubSkuCode());
// }
// }
//
// }
// } else {
// if (productPack.getSpv().getSkuCode() != null
// && !skuCodes.contains(productPack.getSpv().getSkuCode())) {
//
// skuCodes.add(productPack.getSpv().getSkuCode());
// }
// }
//
// }
// }
// }
//
// spvPresaleDateMap = presaleService.findPlanedDeliveryDateBySkuCodes(skuCodes,
// type);
//
// if (spvPresaleDateMap == null) {
// spvPresaleDateMap = Maps.newHashMap();
// }
//
// for (CampaignResult campaignResult : campaignResults) {
// if (campaignResult.isReach() &&
// campaignResult.getDiscountType().equals(DiscountType.GIFT)) {
// Collection<ProductPack> additionalPacks =
// campaignResult.getAdditionalPacks();
// for (ProductPack productPack : additionalPacks) {
// CartProductPackVO packVO =
// cartProductPackAdaptor.getAddibleCartProductPackListNew(
// Arrays.asList(productPack), member, opChannel, accessWay,
// spvPresaleDateMap).get(0);
// // 赠品商品添加"赠品"标签
// Label label = new Label();
// label.setType("赠品");
// packVO.getLabels().add(label);
// packVOs.add(packVO);
// }
// }
// }
// } else {
//
// Map<String, Date> spvPresaleDateMap = null;
// skuCodes = Lists.newArrayList();
// for (CartProductPack pack : paramPacks) {
// if (pack.getSpv().getCombined()) {
// if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
// //
// for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
//
// if (psc.getSubSkuCode() != null && !skuCodes.contains(psc.getSubSkuCode())) {
//
// skuCodes.add(psc.getSubSkuCode());
// }
// }
//
// }
// } else {
// if (!skuCodes.contains(pack.getSpv().getSkuCode())) {
// skuCodes.add(pack.getSpv().getSkuCode());
// }
// }
//
// }
//
// spvPresaleDateMap = presaleService.findPlanedDeliveryDateBySkuCodes(skuCodes,
// type);
//
// if (spvPresaleDateMap == null) {
// spvPresaleDateMap = Maps.newHashMap();
// }
// for (CartProductPack pack : paramPacks) {
// if (pack.getSource().equals(CartPackSource.ADDIBLE)) {
// CartProductPackVO packVO =
// cartProductPackAdaptor.getAddibleCartProductPackListNew(
// Arrays.asList(pack), member, opChannel, accessWay, spvPresaleDateMap).get(0);
// // 加价购商品添加"换购"标签
// Label label = new Label();
// label.setType("换购");
// packVO.getLabels().add(label);
// packVOs.add(packVO);
// } else if (pack.getSource().equals(CartPackSource.GIFT)) {
// CartProductPackVO packVO =
// cartProductPackAdaptor.getAddibleCartProductPackListNew(
// Arrays.asList(pack), member, opChannel, accessWay, spvPresaleDateMap).get(0);
// // 赠品商品添加"赠品"标签
// Label label = new Label();
// label.setType("赠品");
// packVO.getLabels().add(label);
// packVOs.add(packVO);
// } else {
// packVOs.addAll(cartProductPackAdaptor.getCartProductPackListNew(Arrays.asList(pack),
// member,
// opChannel, true, true, true, campaignResults, accessWay, birthday,
// spvPresaleDateMap));
// }
// }
// }
//
// // ============是否可下单==============
// /*
// * if (Integer.valueOf(1).equals(opChannel.getChannelType())) {
// * rt.setCanSubmit(getCanSubmit(paramPacks)); }
// */
// // =========是否包含海外购商品===========
// rt.setHasOverseaProducts(hasOverSea);
// // =========可用的支付方式===========
// rt.setPayMethods(orderCommonAdapter.getPayMethods(rt.isHasOverseaProducts()));
// // ==============商品包================
// rt.setPacks(packVOs);
// // ===============标签================
// List<Label> cartLabels = labelService.getCartLabels(campaignResults,
// accessWay);
// for (Label label : cartLabels) {
// if (label.getCampaign() != null && label.getCampaign().getFulfilled()) {
// rt.getLabels().add(label);
// }
// }
//
// // =============价格步骤===============
// Collection<PriceStepVO> priceSteps = Lists.newArrayList();
// // *******商品总额******
// BigDecimal totalPrice = priceResult.getTotalPrice();
//
// priceSteps.add(new PriceStepVO("商品总额", totalPrice));
//
// // *******优惠******
// BigDecimal birth = BigDecimal.ZERO;
// BigDecimal memb = BigDecimal.ZERO;
// BigDecimal coupon = BigDecimal.ZERO;
// List<PriceStep> steps = priceResult.getSteps();
// // 活动价格步骤
// Collection<PriceStepVO> campaignSteps = Lists.newArrayList();
// if (CollectionUtils.isNotEmpty(steps)) {
// for (PriceStep step : steps) {
// BigDecimal savedPrice = step.getSavedPrice();
// if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
// if (step.getPriceType().equals(PriceType.MEMBER_LEVEL)) {
// memb = memb.add(savedPrice);
// } else if (step.getPriceType().equals(PriceType.BIRTHDAY)) {
// birth = birth.add(savedPrice);
// } else if (step.getPriceType().equals(PriceType.CAMPAIGN)) {
// CampaignDetailVO campaign =
// campaignQueryService.getCampaignById(step.getExtId());
// campaignSteps.add(new PriceStepVO(campaign.getName(),
// BigDecimal.ZERO.subtract(savedPrice)));
// } else if (step.getPriceType().equals(PriceType.COUPON)) {
// coupon = coupon.add(savedPrice);
// }
// }
// }
// }
// if (memb.compareTo(BigDecimal.ZERO) != 0) {
// priceSteps.add(new PriceStepVO("会员折扣", BigDecimal.ZERO.subtract(memb)));
// }
// if (birth.compareTo(BigDecimal.ZERO) != 0) {
// priceSteps.add(new PriceStepVO("生日折扣", BigDecimal.ZERO.subtract(birth)));
// }
// if (CollectionUtils.isNotEmpty(campaignSteps)) {
// priceSteps.addAll(campaignSteps);
// }
// if (coupon.compareTo(BigDecimal.ZERO) != 0) {
// priceSteps.add(new PriceStepVO("优惠券", BigDecimal.ZERO.subtract(coupon)));
// }
//
// // ===============定制信息===============
// for (CartProductPack cartProductPack : paramPacks) {
// if (cartProductPack.isCustomize()) {
// rt.setCustomizable(Boolean.TRUE);
// break;
// }
// }
//
// // ===============配送信息（是否使用语音卡）===============
// int voiceCard = 0;
// rt.setVoiceCard(false);
// for (CartProductPack cartProductPack : paramPacks) {
// PsProductVO pro = cartProductPack.getProduct();
// if (!pro.getExpressType().equals(ExpressType.SHOP)) {
// voiceCard++;
// }
// }
// if (voiceCard > 0) {
// rt.setVoiceCard(true);
// }
// BigDecimal customizePrice = BigDecimal.ZERO;
// if (rt.getCustomizable()) {
// customizePrice = priceService.calculateCustomizePrice(calPriceDTO);
// }
// PostageVO postageVO = null;
// if (deliverableTime != null) {
// postageVO = deliverableTime.getPostage();
// }
//
// // 如果是线下，用线下传进来的运费
// if (opChannel.getChannelType() == 1) {
// postageVO = orderPreview.getPostage();
// }
//
// // 折扣后价格计算（运费计算按折扣后价格计算）
// BigDecimal price = BigDecimal.ZERO;
// for (PriceStepVO priceStepVO : priceSteps) {
// price = price.add(priceStepVO.getPrice());
// }
// List<PriceStepVO> serviceStep =
// postageService.calculatePostageWithStepNew(customizePrice, timeSlot,
// postageVO,
// paramPacks, price, member, accessWay, opChannel, hasOverSea);
// if (CollectionUtils.isNotEmpty(serviceStep)) {
// priceSteps.addAll(serviceStep);
// }
// // =============应付价格计算===============
// // 折扣后价格计算（运费计算按折扣后价格计算）
// BigDecimal discountPrice = BigDecimal.ZERO;
// for (PriceStepVO priceStepVO : priceSteps) {
// discountPrice = discountPrice.add(priceStepVO.getPrice());
// }
//
// // ===============礼品卡===============
// BigDecimal giftPrice = BigDecimal.ZERO;
// if (CollectionUtils.isNotEmpty(orderPreview.getGiftCards())) {// 礼品卡
// List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs = priceService
// .calculateGiftPrice(orderPreview.getGiftCards(), discountPrice);
// for (OpSalesOrderGiftCardVO vo : opSalesOrderGiftCardVOs) {
// giftPrice = giftPrice.add(vo.getGiftCardValue());
// }
//
// }
// if (giftPrice.compareTo(BigDecimal.ZERO) != 0) {
// priceSteps.add(new PriceStepVO("礼品卡", BigDecimal.ZERO.subtract(giftPrice)));
// }
// rt.setPrice(discountPrice.subtract(giftPrice));
//
// // =============配送信息===============
// // *******************
// rt.setPriceSteps(priceSteps);
//
// try {
// deliverableTime = logisticsAdapter.getDeliverableNew(paramPacks, address,
// member, accessWay, opChannel,
// orderPreview.getPostage(), hasOverSea, priceResult);
// } catch (WrongArgException e) {
// deliverableTime = null;
// rt.setAddress(null);
// logger.error("e:{}", e);
// } catch (Throwable e) {
// logger.error("[" + this + "] - [getOrderConfirm] " + e.getMessage(), e);
// throw e;
// }
//
// if (deliverableTime != null) {
// // **********配送描述*********
// if (deliverableTime.getDeliveryTip() != null) {
// rt.setDeliveryTip(deliverableTime.getDeliveryTip());
// }
// // *********可配送日期*********
// if (deliverableTime.getDeliverableDates() != null) {
// rt.setDeliverableDates(deliverableTime.getDeliverableDates());
// }
// // ************时段**********
// if (deliverableTime.getDeliverableTimeSlots() != null) {
// rt.setDeliverableTimeSlots(deliverableTime.getDeliverableTimeSlots());
// }
// // **********运费*********
// rt.setPostage(deliverableTime.getPostage());
// }
//
// // =======生日折扣===========
// if (member != null && member.getMemberLevel() != null
// && !member.getMemberLevel().equals(MemberLevelEnum.NORMAL.getCode()) &&
// member.isInBdayDiscountTime()) {
// // 不是注册用户的情况
// BdayVO bday = new BdayVO();
// bday.setWithin(member.isInBdayDiscountTime());
// bday.setUsed(member.isBdayDiscountUsed());
// bday.setRatio(member.getBdayDiscountRatio());
// int count = 0;
// for (CartProductPack paramPack : paramPacks) {
// PsProductVO prod = paramPack.getProduct();
// if (prod.getAllowBdDiscount() == 1 &&
// CartPackSource.RAW.equals(paramPack.getSource())) {
// int size = 0;
// List<PsCampaignVO> campList = paramPack.getSpv().getCampaignList();// 抢购判断
// if (null != campList && campList.size() > 0) {
// for (PsCampaignVO camp : campList) {
// if (camp.getDiscountTypeId() == 6) {
// size++;
// }
// }
// }
// if (size == 0) {
// count++;
// }
// }
//
// }
//
// if (count > 0) {
// rt.setBday(bday);
// } else {
// rt.setBday(null);
// }
// }
//
// // ===========是否可以注释============
// rt.setCanRemark(orderCommonAdapter.getCanRemark(paramPacks));
// // ========================================
//
// if (CollectionUtils.isNotEmpty(skuCodes)) {
// // 大家具判断
// List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
//
// // ===========大家具==========
// Boolean furniture = false;
//
// for (PsSkuVO sku : skus) {
// if (sku.getWhetherLogistics() != null && sku.getWhetherLogistics() == 1) {
// furniture = true;
// break;
// }
// }
//
// if (furniture) {
// rt.setOrderType(OrderBusinessType.FURNITURE);
// }
// }
// logger.error("CanSumbit:{}", rt.getCanSubmit());
// return rt;
//
// }
//
// private Boolean getCanSubmit(List<CartProductPack> paramPacks) {
// Map<Long, Integer> localStockMap = Maps.newHashMap();
// Map<Long, Integer> funitureStockMap = Maps.newHashMap();
// Map<Long, Integer> preSaleStockMap = Maps.newHashMap();
// Map<Long, Integer> buyCountMap = Maps.newHashMap();
// for (CartProductPack pack : paramPacks) {
// PsSpvVO psSpvVO = pack.getSpv();
// // 来单制作不校验库存
// if (psSpvVO.getSkuVO() != null && psSpvVO.getSkuVO().getIsJit() == 1) {
// continue;
// }
// buyCountMap.put(psSpvVO.getSpvId(), pack.getCount());
// if (psSpvVO.getPsStockVO() != null &&
// psSpvVO.getPsStockVO().getCanUseQuantity() != null) {
// localStockMap.put(psSpvVO.getSpvId(),
// psSpvVO.getPsStockVO().getCanUseQuantity());
// }
// if (psSpvVO.getPsFurnitureStockVO() != null
// && psSpvVO.getPsFurnitureStockVO().getCanUseQuantity() != null) {
// funitureStockMap.put(psSpvVO.getSpvId(),
// psSpvVO.getPsFurnitureStockVO().getCanUseQuantity());
// }
// if (psSpvVO.getPsPresaleSaleStockVO() != null) {
// preSaleStockMap.put(psSpvVO.getSpvId(),
// psSpvVO.getPsPresaleSaleStockVO().getAvailQuantity());
// }
// }
// // 库存是否足够
// boolean stockEnough = true;
// // 看本地仓是否足够
// for (Entry<Long, Integer> entry : buyCountMap.entrySet()) {
// Long spvId = entry.getKey();
// int buyCount = entry.getValue();
// int localStock = localStockMap.get(spvId) != null ? localStockMap.get(spvId)
// : 0;
// if (localStock >= buyCount && stockEnough) {
// continue;
// }
// stockEnough = false;
// }
// // 本地仓不足查配送仓
// if (!stockEnough) {
// stockEnough = true;
// for (Entry<Long, Integer> entry : buyCountMap.entrySet()) {
// Long spvId = entry.getKey();
// int buyCount = entry.getValue();
// int funitureStock = funitureStockMap.get(spvId) != null ?
// funitureStockMap.get(spvId) : 0;
// if (funitureStock >= buyCount && stockEnough) {
// continue;
// }
// stockEnough = false;
// }
// }
// // 配送仓不足查预售仓
// if (!stockEnough) {
// stockEnough = true;
// for (Entry<Long, Integer> entry : buyCountMap.entrySet()) {
// Long spvId = entry.getKey();
// int buyCount = entry.getValue();
// int preSaleStock = preSaleStockMap.get(spvId) != null ?
// preSaleStockMap.get(spvId) : 0;
// if (preSaleStock >= buyCount && stockEnough) {
// continue;
// }
// stockEnough = false;
// }
// }
// return stockEnough;
// }
//
// /**
// * 获取运费权益
// *
// * @param member
// * @param paramPacks
// * @param accessWay
// * @return
// */
// public InterestFreeVO getInterestFree(MemberVO member, List<CartProductPack>
// paramPacks, AccessWayEnum accessWay) {
// logger.info("校验会员免邮权益:{}", member.getId());
// InterestFreeVO interestFreeVO = null;
// try {
// if (CollectionUtils.isNotEmpty(paramPacks)) {
// List<String> productCodes = Lists.newArrayList();
// for (CartProductPack pack : paramPacks) {
// productCodes.add(pack.getProduct().getCode());
// }
// if (CollectionUtils.isNotEmpty(productCodes)) {
// InterestFreeUseVO interestFreeUseVO = new InterestFreeUseVO();
// interestFreeUseVO.setMemberId(member.getId().intValue());
// interestFreeUseVO.setProductCodes(productCodes);
// interestFreeUseVO.setAccessWay(accessWay.getName());
// interestFreeVO =
// iInterestFreeService.getCanUseInterestFree(interestFreeUseVO);
// }
// }
// if (null != interestFreeVO) {
// logger.info("会员有免邮权益id:{},名字：{}", interestFreeVO.getId(),
// interestFreeVO.getInterestFreeName());
// }
// } catch (Exception e) {
// logger.error("获取会员免邮权益异常：", e);
// }
// return interestFreeVO;
// }
//
// /**
// * 根据订单快照显示价格步骤详情 （虽然存的时候已排序，但是取出来的时候还是需要排序。注意兼容）
// */
// private Collection<PriceStepVO> showPriceStepsByOrderShot(List<OrderPrice>
// orderPrices, BigDecimal totalPrice,
// BigDecimal actPrice) {
//
// Collection<PriceStepVO> priceSteps = Lists.newArrayList();
// // BigDecimal discount = BigDecimal.ZERO;
// // ********商品总额********
// priceSteps.add(new PriceStepVO("商品总额", totalPrice));
// // ********优惠活动或服务费********
// // BigDecimal memprice = new BigDecimal(0);
// // BigDecimal birprice = new BigDecimal(0);
// // BigDecimal camprice = new BigDecimal(0);
// // BigDecimal couprice = new BigDecimal(0);
// // BigDecimal cardprice = new BigDecimal(0);
// // BigDecimal postageprice = new BigDecimal(0);
// // BigDecimal overseasprice = new BigDecimal(0);
// // BigDecimal custprice = new BigDecimal(0);
// // BigDecimal timeprice = BigDecimal.ZERO;
// // List<PriceStepVO> camplist = Lists.newArrayList();
// // List<PriceStepVO> couplist = Lists.newArrayList();
// // List<PriceStepVO> postagelist = Lists.newArrayList();
// // List<PriceStepVO> overseaslist = Lists.newArrayList();
// // List<PriceStepVO> custlist = Lists.newArrayList();
// BigDecimal fee = totalPrice.subtract(actPrice);
// if (null != orderPrices && orderPrices.size() > 0) {
// for (OrderPrice orderPrice : orderPrices) {
//
// // if (orderPrice.getType().equals(PriceType.MEMBER_LEVEL)) {
// // memprice = memprice.add(price);
// // }
// // if (orderPrice.getType().equals(PriceType.BIRTHDAY)) {
// // birprice = birprice.add(price);
// // }
// // if (orderPrice.getType().equals(PriceType.CAMPAIGN)) {
// // camprice = camprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // CampaignDetailVO camp =
// // campaignQueryService.getCampaignById(orderPrice.getExtId());
// // camplist.add(new PriceStepVO(camp.getName(), price));
// // }
// // }
// // if (orderPrice.getType().equals(PriceType.COUPON)) {
// // couprice = couprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // CpCouponVO coup =
// // cpCouponService.getCouponById(orderPrice.getExtId());
// // String title = "";
// // title = coup.getCouponSample().getTitle();
// // couplist.add(new PriceStepVO(title, price));
// // }
// // }
// // if (orderPrice.getType().equals(PriceType.GIFTCARD)) {
// // cardprice = cardprice.add(price);
// // }
// // if (orderPrice.getType().equals(PriceType.POSTAGE)) {
// // postageprice = postageprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // postagelist.add(new PriceStepVO(orderPrice.getNote(),
// // price));
// // }
// // }
// // if (orderPrice.getType().equals(PriceType.OVERSEAS)) {
// // overseasprice = overseasprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // overseaslist.add(new PriceStepVO(orderPrice.getNote(),
// // price));
// // }
// // }
// // if (orderPrice.getType().equals(PriceType.CUSTOMIZE)) {
// // custprice = custprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // custlist.add(new PriceStepVO(orderPrice.getNote(), price));
// // }
// // }
// //
// // if (orderPrice.getType().equals(PriceType.TIME)) {
// // timeprice = timeprice.add(price);
// // if (price.compareTo(BigDecimal.ZERO) != 0) {
// // custlist.add(new PriceStepVO(orderPrice.getNote(), price));
// // }
// // }
//
// if (orderPrice.getSavedPrice().doubleValue() != 0) {
// BigDecimal price = new BigDecimal(0).subtract(orderPrice.getSavedPrice());
// fee = fee.subtract(orderPrice.getSavedPrice());
// priceSteps.add(new PriceStepVO(orderPrice.getNote(), price));
// }
//
// }
// // if (memprice.compareTo(BigDecimal.ZERO) != 0) {
// // priceSteps.add(new PriceStepVO("会员折扣", memprice));
// // }
// // if (birprice.compareTo(BigDecimal.ZERO) != 0) {
// // priceSteps.add(new PriceStepVO("生日折扣", birprice));
// // }
// // if (camprice.compareTo(BigDecimal.ZERO) != 0 && (null != camplist
// // && camplist.size() > 0)) {
// // priceSteps.addAll(camplist);
// // }
// // if (couprice.compareTo(BigDecimal.ZERO) != 0 && (null != couplist
// // && couplist.size() > 0)) {
// // priceSteps.addAll(couplist);
// // }
// // if (null != postagelist && postagelist.size() > 0) {
// // priceSteps.addAll(postagelist);
// // }
// // if (null != overseaslist && overseaslist.size() > 0) {
// // priceSteps.addAll(overseaslist);
// // }
// // if (null != custlist && custlist.size() > 0) {
// // priceSteps.addAll(custlist);
// // }
// //
// // if (cardprice.compareTo(BigDecimal.ZERO) != 0) {
// // priceSteps.add(new PriceStepVO("礼品卡", cardprice));
// // }
//
// // BigDecimal fee =
// //
// actPrice.subtract(totalPrice).subtract(memprice).subtract(camprice).subtract(couprice)
// //
// .subtract(birprice).subtract(cardprice).subtract(postageprice).subtract(overseasprice)
// // .subtract(custprice).subtract(timeprice);
//
// }
//
// if (fee.compareTo(BigDecimal.ZERO) > 0) {
// priceSteps.add(new PriceStepVO("其他优惠", new BigDecimal(0).subtract(fee)));
// } else if (fee.compareTo(BigDecimal.ZERO) < 0) {
//
// priceSteps.add(new PriceStepVO("服务费", fee));
// }
// return priceSteps;
// }
//
// /**
// * 检查是否包含预售商品
// *
// * @Methods Name checkContainsPreSale
// * @Create In 2017-11-2 By Xiang.Gao
// * @param packs
// * @return boolean
// */
// public boolean checkContainsPreSale(Map<String, Integer> quantityMap,
// OpChannelVO opChannel,
// Map<String, SPresaleVO> sPresaleMap, Map<String, SPresaleSaleInvVO>
// sPresaleSaleInvMap,
// OrderConfirmDTO orderConfirmDTO, OrderCreateVO orderCreate, List<String>
// presaleskuCodes) {
// Map<String, SSkuStockVO> headSkuStockVOMap = new HashMap<>();
// // 实际库存
// Map<String, SSkuStockVO> sSkuStockVOMap = new HashMap<>();
//
// boolean localStock = true;
//
// boolean headStock = false;
//
// boolean presaleStock = false;
//
// List<Map<String, SSkuStockVO>> stockMapList = new ArrayList<>();
//
// Map<String, SPresaleVO> spMap = null;
//
// if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
// spMap = sPresaleService.findAvaliableBySkuCodes(presaleskuCodes, true);
// } else {
// spMap = sPresaleService.findAvaliableBySkuCodes(presaleskuCodes, false);
// }
//
// if (spMap != null) {
// sPresaleMap.putAll(spMap);
// }
// List<String> skuCodes = new ArrayList<>(quantityMap.size());
// skuCodes.addAll(quantityMap.keySet());
//
// List<String> codes = Lists.newArrayList();
//
// if (sPresaleMap != null && sPresaleMap.size() > 0) {
// Map<String, SPresaleSaleInvVO> spaleInvMap = null;
// Set<String> set = sPresaleMap.keySet();
// codes.addAll(set);
// if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
// spaleInvMap = sPresaleService.findCanUseQttBySkuCodes(codes,
// OpPresaleVO.CHANNEL_TYPE_OFFLINE);
// } else {
// spaleInvMap = sPresaleService.findCanUseQttBySkuCodes(codes, null);
// }
//
// if (spaleInvMap != null) {
// sPresaleSaleInvMap.putAll(spaleInvMap);
// }
//
// }
//
// // 本地库存
// Map<String, SSkuStockVO> skuLocalStockVOMap =
// sStockService.getSkuStocks(skuCodes,
// opChannel.getWarehouseForSales());
//
// if (skuLocalStockVOMap != null) {
// sSkuStockVOMap.putAll(skuLocalStockVOMap);
// }
//
// Map<String, PsSkuVO> skuVOMap = mcPsSkuService.getBySkuCodes(skuCodes);
// // 如果是线下，是预售的情况要先判断实际库存
// if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
//
// List<ChannelWarehouseVO> cwList = channelQueryService
// .getChannelWarehouseByChannelId(opChannel.getId().intValue());
//
// if (CollectionUtils.isNotEmpty(cwList)) {
//
// for (ChannelWarehouseVO cwVO : cwList) {
// // 查询总仓库存
// Map<String, SSkuStockVO> skuStockVOMap = sStockService.getSkuStocks(skuCodes,
// cwVO.getCode());
//
// if (skuStockVOMap != null) {
// stockMapList.add(skuStockVOMap);
// }
// }
//
// }
//
// // 线下有三种库存（本地，总仓，预售）所有商品统取，不可分开，先取本地，在取总仓，最后是预售
// for (String skuCode : skuCodes) {
//
// PsSkuVO skuVo = skuVOMap.get(skuCode);
// if (skuVo != null && skuVo.getIsJit() != null && skuVo.getIsJit() == 1) {
// logger.info("jit商品不验证库存");
// continue;
// }
//
// Integer stock = 0;
// SSkuStockVO skuStock = sSkuStockVOMap.get(skuCode);
// Integer quantity = quantityMap.get(skuCode);
// if (quantity == null) {
// quantity = 1;
// }
//
// if (skuStock != null) {
//
// stock = skuStock.getCanUseQuantity();
//
// }
//
// // 本地可用库存小于购买数量时
// if (stock >= quantity) {
// logger.info(skuCode + ",本地库存：stock:{},当前购买:{}", stock, quantity);
// continue;
// } else {
// logger.info(skuCode + ",本地库存不足：stock:{},当前购买:{}", stock, quantity);
//
// SPresaleSaleInvVO presaleSkuStock = sPresaleSaleInvMap.get(skuCode);
//
// if (presaleSkuStock != null) {
// stock = presaleSkuStock.getCanUseInv();
// }
// if (stock >= quantity) {
// logger.info(skuCode + ",预售仓库存：stock:{},当前购买:{}", stock, quantity);
// continue;
// } else {
// logger.info(skuCode + ",预售仓库存不足：stock:{},当前购买:{}", stock, quantity);
// boolean stockflg = true;
//
// if (CollectionUtils.isNotEmpty(stockMapList)) {
//
// // 循环所有逻辑仓
// for (Map<String, SSkuStockVO> stockMap : stockMapList) {
//
// SSkuStockVO SkuStock = stockMap.get(skuCode);
// String warehouseCode = "";
// if (SkuStock != null) {
// stock = SkuStock.getCanUseQuantity();
// warehouseCode = SkuStock.getWarehouseCode();
// }
//
// // 当前库存大于或等于够买数量时
// if (stock >= quantity) {
// logger.info(skuCode + "在" + warehouseCode + "有库存：stock:{},当前购买:{}", stock,
// quantity);
// stockflg = false;
// break;
//
// }
//
// }
//
// }
//
// if (stockflg) {
//
// PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);
// throw new WrongArgException(skuVO.getSkuNameCN() + "商品库存不足。");
//
// }
//
// }
// }
//
// }
//
// String warehouseForSales = "";
//
// // 先查询本地库存
// if (localStock) {
//
// for (String skuCode : skuCodes) {
// PsSkuVO skuVo = skuVOMap.get(skuCode);
//
// if (skuVo != null && skuVo.getIsJit() != null && skuVo.getIsJit() == 1) {
// warehouseForSales = opChannel.getWarehouseForSales();
// continue;
// }
//
// SSkuStockVO skuStock = sSkuStockVOMap.get(skuCode);
//
// if (skuStock == null) {
// headStock = true;
// localStock = false;
// break;
// } else {
// warehouseForSales = skuStock.getWarehouseCode();
// // 取得购买数量
// Integer quantity = quantityMap.get(skuCode);
// if (quantity == null) {
// quantity = 1;
// }
//
// // 本地可用库存小于购买数量时
// if (skuStock.getCanUseQuantity() < quantity) {
// headStock = true;
// localStock = false;
// warehouseForSales = "";
// break;
// }
// }
//
// }
// }
//
// if (headStock) {
//
// if (stockMapList.size() > 0) {
//
// for (Map<String, SSkuStockVO> stockMap : stockMapList) {
//
// if (StringUtils.isNotBlank(warehouseForSales)) {
// break;
// }
//
// presaleStock = false;
// headStock = true;
//
// for (String skuCode : skuCodes) {
//
// SSkuStockVO skuStock = stockMap.get(skuCode);
//
// if (skuStock != null) {
// warehouseForSales = skuStock.getWarehouseCode();
// Integer quantity = quantityMap.get(skuCode);
// if (quantity == null) {
// quantity = 1;
// }
// if (skuStock.getCanUseQuantity() < quantity) {
// warehouseForSales = "";
// presaleStock = true;
// headStock = false;
// break;
// }
//
// } else {
// warehouseForSales = "";
// presaleStock = true;
// headStock = false;
// break;
// }
//
// }
//
// }
//
// } else {
// presaleStock = true;
// headStock = false;
// }
// }
//
// if (StringUtils.isNotBlank(warehouseForSales)) {
// presaleStock = false;
// }
//
// if (presaleStock) {
//
// if (sPresaleSaleInvMap.size() > 0) {
// for (String skuCode : skuCodes) {
//
// SPresaleSaleInvVO skuStock = sPresaleSaleInvMap.get(skuCode);
// if (skuStock == null) {
// presaleStock = false;
// warehouseForSales = "";
// break;
// } else {
//
// SPresaleVO sPresaleVO = sPresaleMap.get(skuCode);
// if (sPresaleVO != null) {
// warehouseForSales = sPresaleVO.getDispatchWarehouseCode();
// }
//
// // 取得购买数量
// Integer quantity = quantityMap.get(skuCode);
// if (quantity == null) {
// quantity = 1;
// }
//
// // 本地可用库存小于购买数量时
// if (skuStock.getCanUseInv() < quantity) {
// presaleStock = false;
// warehouseForSales = "";
// break;
// }
// }
//
// }
// } else {
// presaleStock = false;
// }
//
// }
//
// // 没有统一库存的时候
// if (StringUtils.isBlank(warehouseForSales) && !presaleStock) {
// throw new WrongArgException("不同发货仓商品无法同时下单。");
// }
//
// if (headStock || presaleStock) {
//
// if (orderConfirmDTO.getAddressId() == 0) {
// throw new WrongArgException("当前订单为配送/预售订单,请先完善配送地址!", "addressId", "");
// }
//
// if (headStock) {
//
// // 如果是线下，配送商品支付金额超过5000元。不可下单
// // if (orderConfirmDTO.getPrice() != null &&
// // orderConfirmDTO.getPrice().doubleValue() > 5000) {
// //
// // throw new WrongArgException("配送商品金额不可超过5000元。");
// //
// // }
//
// orderCreate.setWarehouseForSales(warehouseForSales);
// orderCreate.setStockDistinguish(2);
//
// } else if (presaleStock) {
// orderCreate.setStockDistinguish(3);
// } else {
// orderCreate.setStockDistinguish(1);
// }
//
// }
//
// }
// return true;
// }
//
// /**
// * 下单前商品验证
// *
// * @param packs
// * @param opChannel
// * @param member
// */
// public void checkBirthFlower(List<String> skuCodes, OpChannelVO opChannel,
// MemberVO member,
// OrderCreateVO orderCreate) {
//
// List<String> birthSkuCodes = new ArrayList<>();
// // 判断商品中有几个生日花
// for (String birthCode : ConstUtil.mapBirthFlower.values()) {
//
// if (skuCodes.contains(birthCode)) {
// birthSkuCodes.add(birthCode);
// }
//
// }
// // 如果存在生日花时，进行验证
// if (birthSkuCodes.size() > 0) {
//
// if (birthSkuCodes.size() > 1) {
// throw new WrongArgException("生日花束仅能领取一束。");
// }
//
// if (member == null) {
// throw new WrongArgException("生日花束必须绑定会员，不允许匿名领取.");
// }
//
// ServiceResp<Boolean> resp =
// memberService.checkToUseBdayFlower(member.getId());
//
// // 验证用户是否可以领取生日 花
// if (resp.isFailure() || resp.getBean() == false) {
// throw new WrongArgException(resp.getRespMsg());
// }
//
// MemberVO member2 = memberQueryService.getById(member.getId());
// String birthSkuCode = ConstUtil.mapBirthFlower.get(member2.getMemberLevel());
// if (!birthSkuCodes.get(0).equals(birthSkuCode)) {
// throw new WrongArgException("当前等级会员只能领取:" + birthSkuCode + ",不能领取:" +
// birthSkuCodes.get(0));
// }
//
// orderCreate.setBirthFlowerUse(true);
// }
//
// }
//
// /**
// * 创建订单方法
// *
// * @param orderConfirmDTO
// */
// public String orderCreate(OrderConfirmDTO orderConfirmDTO, MemberVO member,
// OpChannelVO opChannel,
// AccessWayEnum accessWay, String deviceId) {
// logger.info("execute _callOldOrderCreate");
// String orderCode = "";
// List<RequestPack> requestPacks = orderConfirmDTO.getPacks();
// List<Long> packIds = Lists.newArrayList();
// List<RequestPack> noIdPacks = Lists.newArrayList();
// if (orderConfirmDTO != null && CollectionUtils.isNotEmpty(requestPacks)) {
// OrderCreateVO oldOrderCreate = new OrderCreateVO();
// oldOrderCreate.setCpsInfo(orderConfirmDTO.getCpsInfo());
// oldOrderCreate.setCreateOperatorId(orderConfirmDTO.getCreateOperatorId());
// oldOrderCreate.setCreateOperatorName(orderConfirmDTO.getCreateOperatorName());
// // =============商品包=============
// List<CartProductPack> packs = Lists.newArrayList();
// for (RequestPack requestPack : requestPacks) {
//
// if (NumberUtil.isNullOrZero(requestPack.getId())) {
// noIdPacks.add(requestPack);
// } else {
// packIds.add(requestPack.getId());
// }
// }
// if (CollectionUtils.isNotEmpty(packIds)) {
// packs.addAll(cartService.getPacksByIds(member, packIds, accessWay,
// opChannel.getCode()));
// }
// if (CollectionUtils.isNotEmpty(noIdPacks)) {
// List<CartProductPack> prodPacks =
// cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
// accessWay, member, opChannel.getCode());
// packs.addAll(prodPacks);
// }
// cartProductPackAdapter.syncPrice2ProductPack(packs);
//
// // 预售商库存
// Map<String, SPresaleSaleInvVO> sPresaleSaleInvMap = new HashMap<>();
//
// Map<String, SPresaleVO> sPresaleMap = new HashMap<>();
//
// // 商品验证
// orderCommonAdapter.checkPack(packs, opChannel, member, oldOrderCreate,
// sPresaleMap, sPresaleSaleInvMap,
// orderConfirmDTO);
//
// oldOrderCreate.setPacks(packs);
// // =========是否包含海外购商品===========
// boolean isHasOverSea = overseaService.isOversea(packs);
// // =============APP下载来源============
// oldOrderCreate.setDownloadSource(orderConfirmDTO.getDownloadSource());
// oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
// // =============渠道编号=============
// oldOrderCreate.setChannelCode(opChannel.getCode());
// // ==============会员id=============
// if (member != null) {
// oldOrderCreate.setCustomerId(member.getId());
// }
//
// // =============地址=============
// com.thebeastshop.member.vo.MemberAddressVO address = null;
// if (orderConfirmDTO.getAddressId() > 0) {
// address = memberAddressService.getById(orderConfirmDTO.getAddressId());
// if (address != null) {
// AddressVO deliveryAddress = new AddressVO();
// deliveryAddress.setId(address.getId());
// deliveryAddress.setCircuit(address.getCircuitDesc());
// deliveryAddress.setDistrictId(address.getDistrict().getId());
// deliveryAddress.setDistrict(address.getDistrict().getName());
// deliveryAddress.setCompanyName(address.getCompanyName());
// deliveryAddress.setMemberId(address.getMemberId());
// deliveryAddress.setZip(address.getZipCode());
// deliveryAddress.setPhone(address.getReceiverPhone());
// deliveryAddress.setName(address.getReceiver());
// deliveryAddress.setMagentoTitle(address.getTitle());
// deliveryAddress.setStreet(address.getAddress());
// oldOrderCreate.setDeliveryAddress(deliveryAddress);
// } else {
// throw new
// ChannelException(ChannelExceptionErrorCode.MEMBER_ADDRESS_ALREADY_EXISTS_CODE,
// "当前地址已经不存在，请重新选择地址,地址Id:" + orderConfirmDTO.getAddressId());
// }
// }
//
// oldOrderCreate.setDeviceId(deviceId);
//
// // =============是否匿名购买=============
// oldOrderCreate.setAnonymous(orderConfirmDTO.isAnonymous());
// // =============是否使用生日折扣=============
// oldOrderCreate.setBirthdayDiscountUse(orderConfirmDTO.isUseBdayDiscount() ?
// "1" : "0");
// // =============卡片内容 卡片类型，0不需要1空白2代写=============
// OrderCard card = orderConfirmDTO.getNewCard();
// oldOrderCreate.setNoteCard(card.getType().getCode());
// oldOrderCreate.setNoteCardMessage(AppEmojiFilter.filterEmoji(card.getContent()));
// oldOrderCreate.setNoteCardTo(AppEmojiFilter.filterEmoji(card.getTo()));
// oldOrderCreate.setNoteCardFrom(AppEmojiFilter.filterEmoji(card.getFrom()));
//
// // =============配送日期=============
// oldOrderCreate.setDeliveryDate(orderConfirmDTO.getDeliveryDate());
// // =============配送时段=============
// TimeSlot timeSlot =
// timeSlotService.getById(orderConfirmDTO.getDeliveryTimeSlot());
// if (timeSlot != null)
// oldOrderCreate.setLimitedHour(timeSlot.getText());
// CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
// //
// =============TODO:优惠券,现在数据库中字段的表示优惠口令（优惠码），暂时把优惠券id放在这个字段里，以后数据库中字段名应该改成couponId=============
// Long couponId = orderConfirmDTO.getCouponId();
// if (couponId != null) {
// // 判断优惠券是否可以使用
//
// CpCouponVO coupon = cpCouponService.getCouponById(couponId);
// if (!productCouponService.checkCoupon(packs, coupon, accessWay, member,
// opChannel)) {
// throw new WrongArgException("优惠券不可用!", "couponId", couponId);
// }
//
// oldOrderCreate.setCouponCode(couponId.toString());
// calPriceDTO.setCouponId(couponId);
// }
// // 价格计算
// calPriceDTO.setAccessWay(accessWay);
// calPriceDTO.setOpChannel(opChannel);
// if (member != null) {
// calPriceDTO.setMember(member);
// }
//
// calPriceDTO.setPacks(packs);
// if (!orderConfirmDTO.isUseBdayDiscount()) {
// calPriceDTO.setBirthday(false);
// }
// PriceResult priceResult =
// priceService.calculateProductPackPrice(calPriceDTO);
//
// cartProductPackAdapter.checGiftPacks(packs,
// priceResult.getCampaignResults());
//
// DeliverableVO deliverableTime = logisticsAdapter.getDeliverableNew(packs,
// address, member, accessWay,
// opChannel, orderConfirmDTO.getPostage(), isHasOverSea, priceResult);
// PostageVO postageVO = new PostageVO();
// if (deliverableTime != null) {
// postageVO = deliverableTime.getPostage();
// }
// boolean customize = false;
// BigDecimal customizePrice = BigDecimal.ZERO;
// for (CartProductPack cartProductPack : packs) {
// if (cartProductPack.isCustomize()) {
// customize = true;
// break;
// }
// }
// if (customize) {
// customizePrice = priceService.calculateCustomizePrice(calPriceDTO);
// }
//
// BigDecimal remoteFee = BigDecimal.ZERO;
// if (null != orderConfirmDTO.getDeliveryPrice()) {// 官网特殊运费,当做偏远地区配送费处理
// remoteFee = orderConfirmDTO.getDeliveryPrice();
// }
//
// OrderFeeVO orderFeeVO = postageService.calculateServiceFeeNew(customizePrice,
// orderConfirmDTO.getDeliveryTimeSlot(), postageVO, packs,
// (priceResult.getTotalPrice().subtract(priceResult.getSavedPrice())),
// remoteFee, member, accessWay,
// isHasOverSea);
// if (null != orderFeeVO.getInterest()) {
// OrderCreateVO.InterestsVO interestsVO = oldOrderCreate.new InterestsVO();
// interestsVO.setId(orderFeeVO.getInterest());
// oldOrderCreate.setInterestsVO(interestsVO);
// }
// // oldOrderCreate.setServiceFee(orderFeeVO.getPostageFee().doubleValue()
// // + orderFeeVO.getCustomizeFee().doubleValue());
// if (isHasOverSea) {
// // =========设置海淘标记=========
// oldOrderCreate.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
// // =========设置海淘邮费=========
// // oldOrderCreate.setCrossFree(orderFeeVO.getCustomizeFee());
// // 免运费权益
// // =========设置身份证信息=========
// if (member != null && address != null) {
// MemIdCardVO memIdCardVO =
// idCardQueryService.searchIdCardByParam(member.getCode(),
// address.getReceiver());
// if (memIdCardVO != null) {
// IdCardVO idCardVO = new IdCardVO();
// idCardVO.setAuditStatus(memIdCardVO.getImgStatus());
// idCardVO.setFrontCardPhoto(memIdCardVO.getFrontCardPhoto());
// idCardVO.setBackCardPhoto(memIdCardVO.getBackCardPhoto());
// idCardVO.setIdNumber(memIdCardVO.getIdNumber());
// idCardVO.setImgStatus(memIdCardVO.getImgStatus());
// idCardVO.setName(memIdCardVO.getName());
// oldOrderCreate.setIdCardVO(idCardVO);
// }
// }
// }
// oldOrderCreate.setPriceResult(priceResult);
// oldOrderCreate.setServiceStep(orderFeeVO.getServiceStep());
// // =============支付金额校验=============
// BigDecimal payment = postageService.calculatePayment(priceResult,
// orderFeeVO.getServiceStep());
//
// logger.info("使用礼品卡前价格payment={}", payment);
// if (CollectionUtils.isNotEmpty(orderConfirmDTO.getGiftCards())) {// 礼品卡
// logger.info("使用礼品卡，使用前价格payment={}", payment);
// StringBuilder builder = new StringBuilder();
// BigDecimal totail = BigDecimal.ZERO;
// List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs = priceService
// .calculateGiftPrice(orderConfirmDTO.getGiftCards(), payment);
// for (OpSalesOrderGiftCardVO vo : opSalesOrderGiftCardVOs) {
// totail = totail.add(vo.getGiftCardValue());
// builder.append("no:" + vo.getGiftCardNo());
// builder.append("&fee:" +
// vo.getGiftCardValue().multiply(BigDecimal.valueOf(100)));
// builder.append("|");
// }
// oldOrderCreate.setOpSalesOrderGiftCardVOs(opSalesOrderGiftCardVOs);
// oldOrderCreate.setPresentCards(builder.toString());
// oldOrderCreate.setCardFeeDiscount(totail.doubleValue());
// payment = payment.subtract(totail);
// List<ServiceFeeStep> giftStep = new ArrayList<>();
// giftStep.add(new ServiceFeeStep("礼品卡", totail, PriceType.GIFTCARD));
// orderFeeVO.setGiftCardSteps(giftStep);
// oldOrderCreate.setServiceStep(orderFeeVO.getServiceStepContainGift());
//
// }
// // 转换精度后比较
// if (payment.setScale(2, RoundingMode.HALF_UP)
// .compareTo(orderConfirmDTO.getPrice().setScale(2, RoundingMode.HALF_UP)) > 0)
// {
// // if (payment.compareTo(orderConfirmDTO.getPrice()) != 0) {
// throw new ChannelException(ChannelExceptionErrorCode.ORDER_AMOUNT_ZERO_CODE,
// "商品支付价格有误," + payment);
// }
//
// oldOrderCreate.setActualPayFee(orderConfirmDTO.getPrice());
// // =============客户备注===========
// oldOrderCreate.setNote(AppEmojiFilter.filterEmoji(orderConfirmDTO.getRemark()));
// // 投放来源
// oldOrderCreate.setUtmSource(orderConfirmDTO.getUtmSource());
//
// // 配送方式，0非快递1快递
// if (orderConfirmDTO.getAddressId() > 0) {
// oldOrderCreate.setDeliveryType(1);
// } else {
// oldOrderCreate.setDeliveryType(0);
// }
//
// // 调用方法了
// final OpSalesOrderVO opSalesOrderVO =
// comOrderAdapter.orderWebsite2Common2(oldOrderCreate, accessWay,
// member, opChannel, sPresaleMap, sPresaleSaleInvMap);
// // opSalesOrderVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
// OpSalesOrderResponseVO orderResp = pcInstance.editOrder(opSalesOrderVO,
// accessWay);
// logger.info("创建订单成功，orderCode:" + orderResp.getOrderCode());
// if (orderResp != null && StringUtils.isNotBlank(orderResp.getOrderCode())) {
//
// orderCode = orderResp.getOrderCode();
//
// // 如果订单中有配方商品需要占用库存，如果占用失败，将订单改为不可见
// if (CollectionUtils.isNotEmpty(opSalesOrderVO.getCustomizeInvList())
// && opChannel.getChannelType() != null && opChannel.getChannelType() == 2) {
// logger.info("当前订单存在配方商品，orderCode:" + orderResp.getOrderCode());
// try {
// phInstance.createAllotOrPrdcJob(opSalesOrderVO.getCustomizeInvList());
// } catch (Exception e) {
//
// pcInstance.deleteSalesOrder(opSalesOrderVO.getMemberCode(), orderCode,
// "配方定制商品库存占用失败,订单隐藏");
// logger.info(e.getMessage());
// logger.info("配方定制商品库存占用失败，orderCode:" + opSalesOrderVO.getCode());
//
// try {
// logger.info("配方定制商品库存占用失败，开始取消订单。");
// final Boolean result = pcInstance.cancleSalesOrder(orderCode);
// if (result) {
// logger.info("取消订单成功。");
// } else {
// logger.info("取消订单失败。");
// }
//
// } catch (Exception e1) {
// logger.error("配方定制商品库存不足,取消逻辑订单失败，" + e.getLocalizedMessage());
// throw new
// ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE,
// "配方定制商品库存不足,取消逻辑订单失败，" + e1.getMessage());
// }
//
// logger.error("配方定制商品库存不足," + e.getLocalizedMessage());
// throw new
// ChannelException(ChannelExceptionErrorCode.ORDER_QUANTITY_ZERO_CODE,
// "配方定制商品库存不足," + e.getMessage());
// }
// }
//
// if (orderResp.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
//
// // OpSalesOrder order =
// // pcInstance.getOrderByCode(orderCode);
// // orderAdapter.dobule11Interest(order);
// // TODO:如果支付价格为零元则订单设为已支付,默认支付方式为支付宝
// orderCommonAdapter.orderPay(orderCode, PaymentType.ALIPAY.getId(),
// orderResp.getAmount(), "");
// }
// if (couponId != null && StringUtils.isNotBlank(orderCode)) {
// // TODO：如果创建订单成功,则优惠券要改为已使用（注：这个应该是在下订单流程中处理的，以后要改）
// ServiceResp<Boolean> resp = cpCouponService.use(couponId);
// if (resp.isFailure()) {
// throw new ChannelException(ChannelExceptionErrorCode.COUPON_INVALID_CODE,
// "使用优惠券失败 [couponId=" + couponId + "]: " + resp.getRespMsg());
// }
// }
//
// if (StringUtils.isNotBlank(orderCode)) {
// // 如果创建订单成功且从购物车中来,则删除购物车中商品包
// if (member != null && CollectionUtils.isNotEmpty(packIds)) {
// cartService.removePacksById(member, packIds);
// }
// }
// // 保存订单快照
// if (StringUtils.isNotBlank(orderCode)) {
// orderSnapshotService.saveOrderSnapshot(orderResp.getId(), orderFeeVO,
// priceResult,
// orderConfirmDTO.getGiftCards(), orderConfirmDTO.getAddressId());
// }
//
// if (member != null) {
// // 如果用户未设置默认地址，则这次订单地址设为默认地址
// com.thebeastshop.member.vo.MemberAddressVO memberAddress =
// memberAddressService
// .getDefaultByOwnerId(member.getId());
// if (memberAddress == null && address != null) {
// address.setAsDefault(true);
// memberAddressService.update(address);
// }
// }
//
// try {
// // ezr coupon
// cpCouponService.couponUseEzr(couponId, opChannel.getCode(), orderCode,
// opSalesOrderVO.getCouponFee().doubleValue());
// } catch (Exception e) {
// logger.error("couponUseEzr error");
// logger.error(e.getMessage());
// }
//
// }
//
// }
// return orderCode;
// }
// }
