package com.thebeastshop.pegasus.channelservice.adapter.message;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.cond.MessageRecordAppItnCond;
import com.thebeastshop.message.enums.AppItnReadEnum;
import com.thebeastshop.message.service.MessageRecordService;
import com.thebeastshop.message.vo.MessageRecordAppItnVO;
import com.thebeastshop.message.vo.Pagination;
import com.thebeastshop.pegasus.channelservice.controller.order.app.OrderController;
import com.thebeastshop.support.enums.MessageType;
import com.thebeastshop.support.vo.message.Message;
import com.thebeastshop.support.vo.message.MessageItem;
import com.thebeastshop.support.vo.message.MessageVO;

/**
 * 消息中心适配器
 * 
 * @author WangYawei
 *
 */
@Component
public class MessageAdapter {

	private final Logger logger = LoggerFactory.getLogger(OrderController.class);

	@Autowired
	private MessageRecordService messageRecordService;

	public MessageVO getMessageList(Pagination<MessageRecordAppItnVO> records, MemberVO member) {
		MessageVO messageVO = null;
		if (records != null) {
			logger.info("消息内容 records={}", records.getResultList());
			messageVO = new MessageVO();
			messageVO.setTotal(records.getRecord());
			messageVO.setLimit(records.getPagenum());
			messageVO.setOffset(records.getOffset());
			List<MessageRecordAppItnVO> recordItems = records.getResultList();
			List<MessageItem> items = new ArrayList<MessageItem>();
			if (!recordItems.isEmpty()) {
				for (MessageRecordAppItnVO recordItem : recordItems) {
					MessageItem item = new MessageItem();
					item.setContent(recordItem.getContent());
					item.setCreateTime(recordItem.getCreateTime());
					item.setId(recordItem.getId());
					item.setLink(recordItem.getLink());
					item.setTitle(recordItem.getTitle());
					item.setUnread(recordItem.getUnread());
					item.setImage(returnMessageImage(recordItem.getPublishType(), member));
					items.add(item);
				}

			}
			messageVO.setItems(items);
		}
		return messageVO;
	}

	public MessageItem getIndexMessage(MessageRecordAppItnVO record, MemberVO member) {
		MessageItem item = null;
		if (record != null) {
			logger.info("消息内容 record={}", record);
			item = new MessageItem();
			item.setContent(record.getContent());
			item.setCreateTime(record.getCreateTime());
			item.setId(record.getId());
			item.setLink(record.getLink());
			item.setTitle(record.getTitle());
			item.setUnread(record.getUnread());
			item.setImage(returnMessageImage(record.getPublishType(), member));
		}
		return item;
	}

	public String returnMessageImage(String type, MemberVO member) {
		String image = "http://img.thebeastshop.com/app/message/transaction_icon.png";
		if (type.endsWith(MessageType.MEMBER.getType().get(0))) {
			MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
			image = memberLevel.getMessageImage();
		}
		return image;
	}

	// 未读消息数量
	public Integer returnUnreadMessage(List<String> type, MemberVO member) {
		Integer size = 0;
		MessageRecordAppItnCond messageRecordAppItnCond = new MessageRecordAppItnCond();
		messageRecordAppItnCond.setCurrpage(0);
		messageRecordAppItnCond.setPagenum(20);
		messageRecordAppItnCond.setMsgTo(member.getCode());
		messageRecordAppItnCond.setPublishType(type);
		messageRecordAppItnCond.setUnread(AppItnReadEnum.UN_READ);
		logger.info("调用消息查询接口，memberCode:{},type:{},unread:{}", member.getCode(), MessageType.ALL.getType(), AppItnReadEnum.UN_READ);

		Pagination<MessageRecordAppItnVO> records = messageRecordService.findMessageRecordByMemberAndPublishType(messageRecordAppItnCond);
		if (null != records) {
			size = records.getRecord();
			logger.info("未读消息数量 :size={}", size);
		}
		return size;
	}

	// 组装首页消息modules
	public Message indexMessage(List<String> type, MemberVO member) {
		Message message = new Message();
		MessageItem item = null;
		Integer size = returnUnreadMessage(type, member);
		if (size > 0) {
			ServiceResp<MessageRecordAppItnVO> msgRecord = messageRecordService.findIndexMapBubbleByMemberCode(member.getCode());
			if (msgRecord.isSuccess()) {
				item = new MessageItem();
				item = getIndexMessage(msgRecord.getBean(), member);
			}
		}
		message.setMessage(item);
		message.setNumber(size);
		return message;
	}
}
