package com.thebeastshop.pegasus.channelservice.adapter.member;

import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.member.constant.MemberPointConstant;
import com.thebeastshop.member.vo.point.MemberIntegralVO;
import com.thebeastshop.support.vo.member.ScoreRecordVO;

/**
 * 会员地址适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class MemberPointAdapter {
	
	/**
	 * 获取积分历史记录
	 * @param point
	 * @return
	 */
	public ScoreRecordVO getScoreRecord(MemberIntegralVO integral) {
		ScoreRecordVO rt = null;
		if (integral != null) {
			rt = new ScoreRecordVO();
			rt.setTime(integral.getCreateTime());
			rt.setReason(integral.getTypeName());
			rt.setDelta(integral.getPoint().setScale(0, RoundingMode.HALF_UP));// 积分四舍五入保留整数
			if (integral.getPointType().equals(MemberPointConstant.Pont_Type_Id.TYPE_ADD_CONSUMPTION)
					|| integral.getPointType().equals(MemberPointConstant.Pont_Type_Id.TYPE_SUBSTRACT_RETURN)) {
				String orderId = integral.getReferenceCode();
				// 订单包裹号取前18个字符
				if(StringUtils.isNotEmpty(orderId)&& orderId.length()>18){
					orderId = orderId.substring(0,18);
				}
				rt.setOrderId(orderId);
			}
		}
		return rt;
	}

	/**
	 * 批量获取会员积分历史记录
	 * @param integrals
	 * @return
	 */
	public List<ScoreRecordVO> getScoreRecord(Collection<MemberIntegralVO> integrals) {
		List<ScoreRecordVO> scoreRecords = Lists.newArrayList();
		if (CollectionUtils.isEmpty(integrals)) {
			return scoreRecords;
		}
		for (MemberIntegralVO integral : integrals) {
			if (integral != null) {
				scoreRecords.add(getScoreRecord(integral));
			}
		}
		return scoreRecords;
	}

}
