package com.thebeastshop.pegasus.channelservice.adapter.member;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.member.service.IdCardQueryService;
import com.thebeastshop.member.vo.MemIdCardVO;
import com.thebeastshop.member.vo.MemberAddressVO.District;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.RingVO;

/**
 * TODO:会员地址适配器(目前针对app端)
 * 
 * @author Paul-xiong
 *
 */
@Component
public class MemberAddressAdapter {
	// private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
	private IdCardQueryService idCardQueryService;

	/**
	 * 获取地址信息
	 * 
	 * @param address
	 * @return
	 */
	public MemberAddressVO getMemberAddress(com.thebeastshop.member.vo.MemberAddressVO address, MemberVO member, Long ringId) {
		if (address != null) {
			MemberAddressVO rt = new MemberAddressVO();
			if (member != null && StringUtils.isNotBlank(member.getCode()) && StringUtils.isNotBlank(address.getReceiver())) {
				MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(), address.getReceiver());
				if (memIdCardVO != null) {
					// TODO:imgStatus和status没有枚举型吗??
					if (memIdCardVO.getImgStatus().equals(1)) {
						rt.setIdCardPhotoUploaded(true);
					} else if (memIdCardVO.getImgStatus().equals(2) && memIdCardVO.getStatus().equals(1)) {
						rt.setIdCardPhotoUploaded(true);
						rt.setIdCardValidated(true);
					}
				}
			}
			rt.setId(address.getId());
			rt.setLocation(address.getAddress());
			rt.setReceiverName(address.getReceiver());
			rt.setReceiverPhone(address.getReceiverPhone());
			rt.setZipCode(address.getZipCode());
			rt.setAsDefault(address.getAsDefault());
			District district = address.getDistrict();
			if (district != null) {
				DistrictVO districtVO = new DistrictVO();
				districtVO.setId(district.getId());
				districtVO.setName(district.getName());
				districtVO.setFullName(district.getFullName());
				rt.setDistrict(districtVO);
			}
			if (StringUtils.isNotBlank(address.getCircuitDesc())) {
				RingVO ringVO = new RingVO();
				ringVO.setName(address.getCircuitDesc());
				ringVO.setId(ringId);
				rt.setRing(ringVO);
			}
			return rt;
		}
		return null;
	}

	/**
	 * 获取地址信息
	 * 
	 * @param address
	 * @return
	 */
	public MemberAddressVO getMemberAddress(com.thebeastshop.member.vo.MemberAddressVO address, MemberVO member) {
		if (member != null && address != null) {
			MemberAddressVO rt = new MemberAddressVO();
			if (StringUtils.isNotBlank(member.getCode()) && StringUtils.isNotBlank(address.getReceiver())) {
				MemIdCardVO memIdCardVO = idCardQueryService.searchIdCardByParam(member.getCode(), address.getReceiver());
				if (memIdCardVO != null) {
					// TODO:imgStatus和status没有枚举型吗??
					if (memIdCardVO.getStatus().equals(1)) {
						rt.setIdCardValidated(true);
					} else if (memIdCardVO.getImgStatus().equals(2) && memIdCardVO.getStatus().equals(1)) {
						rt.setIdCardPhotoUploaded(true);
						rt.setIdCardValidated(true);
					}
				}
			}
			rt.setId(address.getId());
			rt.setLocation(address.getAddress());
			rt.setReceiverName(address.getReceiver());
			rt.setReceiverPhone(address.getReceiverPhone());
			rt.setZipCode(address.getZipCode());
			rt.setAsDefault(address.getAsDefault());
			District district = address.getDistrict();
			if (district != null) {
				DistrictVO districtVO = new DistrictVO();
				districtVO.setId(district.getId());
				districtVO.setName(district.getName());
				districtVO.setFullName(district.getFullName());
				rt.setDistrict(districtVO);
			}
			if (StringUtils.isNotBlank(address.getCircuitDesc())) {
				RingVO ringVO = new RingVO();
				ringVO.setName(address.getCircuitDesc());
				rt.setRing(ringVO);
			}
			return rt;
		}
		return null;
	}

	public List<MemberAddressVO> getMemberAddress(List<com.thebeastshop.member.vo.MemberAddressVO> addresses, MemberVO member) {
		List<MemberAddressVO> rt = Lists.newArrayList();
		for (com.thebeastshop.member.vo.MemberAddressVO address : addresses) {
			rt.add(getMemberAddress(address, member));
		}
		return rt;
	}

}
