package com.thebeastshop.pegasus.channelservice.adapter.member;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.dto.MemberLoginQueryCondDTO;
import com.thebeastshop.member.dto.RegisterDTO;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.RegisterSourceEnum;
import com.thebeastshop.member.service.MemberLoginQueryService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.service.MemberService;
import com.thebeastshop.member.vo.MemberLoginVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.service.MsgSendService;
import com.thebeastshop.message.vo.SingleSmsTemplateVO;
import com.thebeastshop.pegasus.channelservice.controller.activity.ActivityController;
import com.thebeastshop.pegasus.channelservice.util.MobileUtil;

/**
 * Created by feilong.gao on 2017/1/18.
 */
@Service("appMemberAdapter")
public class MemberAdapter {


    private static Logger logger = LoggerFactory.getLogger(ActivityController.class);
    
    @Autowired
    private MemberQueryService memberQueryService;
    
    @Autowired
    private MemberService memberService;
    
    @Autowired
    private MemberLoginQueryService memberLoginQueryService;

    @Autowired
    private MsgSendService msgSendService;

    /**
     * 获取或者注册会员根据手机号
     *
     * @param mobile
     * @return
     */
    public MemberVO getOrCreateMemberByMobile(String mobile, String channelCode) {
    	MemberVO member = null;
        if (StringUtils.isNotEmpty(mobile) && MobileUtil.isValidPhoneNumber(mobile)) {
        	MemberLoginQueryCondDTO loginCondition = new MemberLoginQueryCondDTO();
            loginCondition.setLoginType(LoginTypeEnum.MOBILE.getCode());
            loginCondition.setLoginId(mobile);
            List<MemberLoginVO> list = memberLoginQueryService.getByCond(loginCondition);
            if (CollectionUtils.isEmpty(list)) {
            	RegisterDTO user = new RegisterDTO();
                user.setMobile(mobile);
                user.setNickName(mobile);
                user.setGender(3);
                user.setRegisterSource(RegisterSourceEnum.UNKNOWN.getCode());
                //设置生成的随机密码
                user.setPassword(getRandomPassword());
                user.setLoginId(mobile);
                user.setLoginType(LoginTypeEnum.MOBILE.getCode());
                user.setChannelCode(channelCode);
                user.setAccessWay(AccessWayEnum.APP.getCode());
                logger.info("注册新会员登陆账号为{}", mobile);
                ServiceResp<MemberVO> resp = memberService.register(user);
                if (null != resp && resp.isSuccess()) {
                	member = resp.getBean();
                    logger.info("注册账号为{}新会员成功:", mobile, member);
                    // 注册成功发送短信通知

                    SingleSmsTemplateVO smsTemplateVO  = new SingleSmsTemplateVO();
                    smsTemplateVO.setMsgTo(mobile);
                    Map<String, Object> params = new HashMap<String, Object>();
                    params.put("passwd", user.getPassword());
                    smsTemplateVO.setParams(params);
                    smsTemplateVO.setTemplateName("REGISTER_SUCCESS_BS");
                    smsTemplateVO.setMsgType(MsgTypeEnum.SmsMsg);
                    smsTemplateVO.setPublishType(PublishTypeEnum.IDENTIFYING_CODE);
                    msgSendService.sendInterfaceVOTemplate(Arrays.asList(smsTemplateVO));

                } else {
                    logger.info("注册账号为{}新会员失败", mobile);
                }
            } else {
                member = memberQueryService.getById(list.get(0).getMemberId());
            }
        }
        return member;
    }


    /***
     * 获取活动页面注册用户的随机生成密码 2-9之间6位
     * @return
     */
    private String getRandomPassword() {
        String IntString = "23456789";//随机密码范围
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        //六位随机密码
        for (int i = 0; i < 6; i++) {
            sb.append(IntString.charAt(random.nextInt(IntString.length())));
        }
        return sb.toString();
    }
    
    /**
	 * 是否新用户
	 * @param memberId
	 * @return
	 */
	public Boolean isNewMember(Long memberId) {
		if (null == memberId || MemberConstant.DEFAULT_MEMBER_ID.equals(memberId)) {
	      return true;
	    }
	    return memberQueryService.isNewMember(memberId);
	}
	
	/**
	 * ipos购物车是否新用户(自购物车流程之后)
	 * @param memberId
	 * @return
	 */
	public Boolean isNewMemberIposCart(Long memberId) {
		if (null == memberId || MemberConstant.DEFAULT_MEMBER_ID.equals(memberId)) {
			return false;
		}
		return memberQueryService.isNewMember(memberId);
	}

}
