package com.thebeastshop.pegasus.channelservice.adapter.logistics;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.commdata.enums.ChannelType;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.delivery.dto.DeliveryInfoDTO;
import com.thebeastshop.delivery.service.DeliveryRuleService;
import com.thebeastshop.delivery.vo.DeliveryInfoVO;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.JsonApiResult;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.service.PostageService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex.FedexResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex.FedexResponse.FedexActivity;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.sf.SFRoute;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.FedexService;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.SFService;
import com.thebeastshop.pegasus.component.delivery.domain.DeliverableDate;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.service.DeliveryDistrictService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.time.TimeSlot;
import com.thebeastshop.pegasus.component.time.service.TimeSlotService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuCombinationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.model.OpExpressTrace;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeclaration;
import com.thebeastshop.support.enums.LogisticsType;
import com.thebeastshop.support.enums.PackageDeclarationStateEnum;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.vo.logistics.DateUnitVO;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.LogisticsBasicVO;
import com.thebeastshop.support.vo.logistics.LogisticsDetailVO;
import com.thebeastshop.support.vo.logistics.LogisticsDetailVO.LogisticsDesc;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.logistics.TimeSlotVO;

/**
 * 物流适配器
 * 
 * @author Paul-xiong
 *
 */
@Component
public class LogisticsAdapter {
	// private static final String CITY1 = "上海市";

	private static final String DEFAULT_LOGISTICS_DESC = "商品已打包, 等待快递取货";

	private static final String SHOP_LOGISTICS_DESC = "实体店自提";

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	// private DeliverableService deliverableService =
	// ComponentServiceLoader.getBean(DeliverableService.class);

	private DeliveryDistrictService deliveryDistrictSerivce = ComponentServiceLoader
			.getBean(DeliveryDistrictService.class);

	private FedexService fedexService = ComponentServiceLoader.getBean(FedexService.class);

	private SFService sfService = ComponentServiceLoader.getBean(SFService.class);

	private TimeSlotService timeSlotService = ComponentServiceLoader.getBean(TimeSlotService.class);

	@Autowired
	private PostageService postageService;
	//
	// @Autowired
	// private McPsSkuService mcPsSkuService;

	private PegasusOperationServiceFacade poInstance = PegasusOperationServiceFacade.getInstance();

	@Autowired
	private PriceService priceService;
	@Autowired
	private MemberAddressService memberAddressService;

	@Autowired
	private DeliveryRuleService deliveryRuleService;

	/**
	 * 获取配送提示，额外金额根据指定时段运费显示
	 * 
	 * @param edt
	 * @return
	 */
	private String getDeliveryTip(BigDecimal edt) {
		if (NumberUtil.isNullOrZero(edt)) {
			return "需要额外支付<span style=\"color:#004c46\">￥60配送费</span>";
		} else {
			return "需要额外支付<span style=\"color:#004c46\">￥" + edt.longValue() + "配送费</span>";
		}
	}

	// ================private==================
	/**
	 * 补丁：校验一下特殊商品是否可配送
	 * 
	 * @param product
	 * @param districtId
	 */
	// private boolean _checkSpecialProduct(PsProductVO product, long
	// districtId) {
	// boolean rt = true;
	// List<String> notDeliverySkuCodes = Lists.newArrayList("101161221",
	// "101161231", "101161211", "101161201");// 不能配送的sku
	// List<Long> deliveryDistrictIds = Lists.newArrayList(1058L, 1059L, 1060L,
	// 1061L, 1062L, 1063L, 1064L, 1065L,
	// 1066L, 1067L, 1068L, 1069L, 1070L, 1071L, 1072L, 1073L, 1074L, 1075L,
	// 2023L, 2025L);// 可以配送的地区
	// if (!deliveryDistrictIds.contains(districtId)) {
	// if (product != null && CollectionUtils.isNotEmpty(product.getSkuCodes()))
	// {
	// for (String skuCode : product.getSkuCodes()) {
	// if (notDeliverySkuCodes.contains(skuCode)) {
	// throw new WrongArgException("该商品仅供上海市，其他地区敬请期待。");
	// }
	// }
	// }
	// }
	// return rt;
	// }

	/**
	 * 获取普通邮费
	 * 
	 * @param packs
	 * @param member
	 * @param couponId
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	private BigDecimal getNormalPostageNew(List<CartProductPack> packs, MemberVO member, Long couponId,
			AccessWayEnum accessWay, OpChannelVO opChannel, boolean hasOverSea, PriceResult priceResult) {
		BigDecimal postage = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(packs) && priceResult == null) {
			// 价格计算
			CalculateProductPackDTO calProductPackDTO = new CalculateProductPackDTO();
			calProductPackDTO.setAccessWay(accessWay);
			calProductPackDTO.setOpChannel(opChannel);
			calProductPackDTO.setMember(member);
			calProductPackDTO.setCouponId(couponId);
			calProductPackDTO.setPacks(packs);
			priceResult = priceService.calculateProductPackPrice(calProductPackDTO);

			// 计算邮费
			postage = postageService.calculatePostageNew(packs,
					priceResult.getTotalPrice().subtract(priceResult.getSavedPrice()), member, hasOverSea);
		}
		return postage;
	}

	/**
	 * 获取普通邮费
	 * 
	 * @param packs
	 * @param member
	 * @param couponId
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	// private BigDecimal getNormalPostage(List<CartProductPack> packs, MemberVO
	// member, Long couponId,
	// AccessWayEnum accessWay, OpChannelVO opChannel) {
	// BigDecimal postage = BigDecimal.ZERO;
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 价格计算
	// CalculateProductPackDTO calProductPackDTO = new
	// CalculateProductPackDTO();
	// calProductPackDTO.setAccessWay(accessWay);
	// calProductPackDTO.setOpChannel(opChannel);
	// calProductPackDTO.setMember(member);
	// calProductPackDTO.setCouponId(couponId);
	// calProductPackDTO.setPacks(packs);
	// PriceResult priceResult =
	// priceService.calculateProductPackPrice(calProductPackDTO);
	//
	// // 计算邮费
	// postage = postageService.calculatePostage(packs,
	// priceResult.getTotalPrice().subtract(priceResult.getSavedPrice()),
	// member);
	// }
	// return postage;
	// }

	/**
	 * 获取配送日期
	 * 
	 * @param deliverableTimes
	 * @return
	 */
	private List<DateUnitVO> getDateUnits(List<DeliverableDate> deliverableTimes) {
		List<DateUnitVO> dateUnitVOs = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(deliverableTimes)) {
			for (DeliverableDate deliverableDate : deliverableTimes) {
				if (deliverableDate != null) {
					DateUnitVO dateUnitVO = new DateUnitVO();
					dateUnitVO.setAvailable(deliverableDate.getIsReceive());
					dateUnitVO.setDesc(deliverableDate.getDescibe());
					dateUnitVO.setText(deliverableDate.getDate());
					dateUnitVOs.add(dateUnitVO);
				}
			}
		}
		return dateUnitVOs;
	}

	/**
	 * 获取时段
	 * 
	 * @return
	 */
	private List<TimeSlotVO> getTimeSlots() {
		List<TimeSlotVO> timeSlotVOs = new ArrayList<>();
		List<TimeSlot> timeSlots = timeSlotService.getAll();
		for (TimeSlot timeSlot : timeSlots) {
			TimeSlotVO timeSlotVO = new TimeSlotVO();
			timeSlotVO.setId(timeSlot.getId());
			timeSlotVO.setText(timeSlot.getText());
			timeSlotVOs.add(timeSlotVO);
		}
		return timeSlotVOs;
	}

	// 自送 中通 使用t_op_express_trace获取物流信息
	private List<LogisticsDesc> getLogisticsDescList(String logisticCode, LogisticsType type) {
		Map<String, Object> params = new HashMap<String, Object>(2);
		params.put("deliveryCode", logisticCode);
		params.put("expressType", type.getId());
		List<OpExpressTrace> opExpressTraces = poInstance.queryOpExpressTraceByParams(params);
		if (opExpressTraces != null && CollectionUtils.isNotEmpty(opExpressTraces)) {
			Collections.sort(opExpressTraces, new Comparator<OpExpressTrace>() {
				public int compare(OpExpressTrace t1, OpExpressTrace t2) {
					return t2.getDateTime().compareTo(t1.getDateTime());
				}
			});
			List<LogisticsDesc> logisticsDescList = Lists.newArrayList();
			for (OpExpressTrace trace : opExpressTraces) {
				logisticsDescList.add(new LogisticsDesc(trace.getScan(), trace.getDateTime()));
			}
			return logisticsDescList;
		}
		return null;
	}

	// =======================================

	/**
	 * 获取物流详情信息
	 * 
	 * @param logisticCode
	 * @param type
	 * @return
	 */
	public LogisticsDetailVO getLogisticsDetail(String logisticCode, LogisticsType type) {
		LogisticsDetailVO logistics = null;
		if (StringUtils.isNotBlank(logisticCode) && type != null) {
			logistics = new LogisticsDetailVO(this.getLogisticsBasic(logisticCode, type));
			switch (type) {
			case FEDEX:
				List<LogisticsDesc> fedex_items = Lists.newArrayList();
				FedexResponse fedexResponse = fedexService.queryByCode(logisticCode);
				if (fedexResponse != null) {
					List<FedexActivity> faList = fedexResponse.getTracking().getDetail().getActivities().getActivity();
					for (FedexActivity fa : faList) {
						String desc = String.format("[%s]%s", fa.getLocation(), fa.getScan());
						fedex_items.add(new LogisticsDesc(desc, fa.getDatetime()));
					}
					logistics.setItems(fedex_items);
				}
				break;
			case SF_AIR:
			case HT:
			case SF_LAND:
				List<LogisticsDesc> sf_items = Lists.newArrayList();
				SFResponse sfResponse2 = sfService.queryByCode(logisticCode);
				if (sfResponse2 != null) {
					List<SFRoute> list2 = sfResponse2.getResponseBody().getRouteResponse().getRoute();
					for (SFRoute route : list2) {
						String desc = String.format("[%s]%s", route.getAcceptAddress(), route.getRemark());
						sf_items.add(new LogisticsDesc(desc, route.getAcceptTime()));
					}
					logistics.setItems(sf_items);
				}
				break;
			case SELF:
				logistics.setItems(getLogisticsDescList(logisticCode, type));
				break;
			case ZT:
				logistics.setItems(getLogisticsDescList(logisticCode, type));
				break;
			default:
				break;
			}

		}
		// 查询海关物流情况
		List<OpSoPackageDeclaration> packs = poInstance.findOverseaPackageByCode(logisticCode);

		if (null != packs && packs.size() > 0) {
			List<LogisticsDesc> items = logistics.getItems();
			if (CollectionUtils.isEmpty(items)) {
				items = Lists.newArrayList();
			}
			for (OpSoPackageDeclaration pack : packs) {
				PackageDeclarationStateEnum declaradtionEnumMap = EnumUtil.valueOf(pack.getStateCode().intValue(),
						PackageDeclarationStateEnum.class);
				if (declaradtionEnumMap != null) {
					String content = declaradtionEnumMap.getContent();
					if (StringUtils.isNotBlank(content)) {
						SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
						items.add(new LogisticsDesc(content, sdf.format(pack.getCreateTime())));
					}
				}
			}
			logistics.setItems(items);
		}
		return logistics;
	}

	/**
	 * 获取物流基础信息
	 * 
	 * @param logisticCode
	 * @param type
	 * @return
	 */
	public LogisticsBasicVO getLogisticsBasic(String logisticCode, LogisticsType type) {
		return getLogisticsBasic(logisticCode, type, null, null);
	}

	/**
	 * 获取物流基础信息
	 * 
	 * @param logisticCode
	 * @param type
	 * @param order
	 * @param delivery
	 * @return
	 */
	public LogisticsBasicVO getLogisticsBasic(String logisticCode, LogisticsType type, OpSalesOrderVO order,
			OpSoPackageDeliveryInfoVO delivery) {
		LogisticsBasicVO basic = null;
		if (type != null) {
			String companyName = type.getName();
			String tel = type.getTel();
			String desc = DEFAULT_LOGISTICS_DESC;
			switch (type) {
			case SF_AIR:
			case SF_LAND:
				// 当物流类型是顺丰时显示"顺丰速运"
				companyName = "顺丰速运";
				break;
			case SHOP:
				if (delivery != null && delivery.getDistrictId() == null) {
					// TODO:注：这里这么做是因为用户到门店买东西，订单的快递类型居然是店送。这个很不合理啊，应该有一个快递类型叫门店自提吧，以后要改。
					companyName = "";// 公司名为空
					desc = SHOP_LOGISTICS_DESC;// 给定固定物流描述
				}
				break;
			default:
				break;
			}
			basic = new LogisticsBasicVO();
			basic.setId(logisticCode);
			basic.setType(type);
			basic.setCompanyName(companyName);
			basic.setCompanyPhone(tel);
			basic.setDesc(desc);
			if (order != null && order.getAuditTime() != null) {
				basic.setDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(order.getAuditTime()));
			}
		}
		return basic;
	}

	/**
	 * 获取物流可配送信息
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	public DeliverableVO getDeliverableNew(List<CartProductPack> packs, MemberAddressVO address, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO opChannel, PostageVO postage, boolean hasOverSea,
			PriceResult priceResult) {
		DeliverableVO deliverableTimeVO = null;
		if (null != address && CollectionUtils.isNotEmpty(packs)) {
			deliverableTimeVO = new DeliverableVO();
			// ===========判断商品是否可配送==========
			for (CartProductPack pack : packs) {
				PsProductVO product = pack.getProduct();
				if (address.getDistrict() == null || !checkDelivery(product, address.getDistrict().getId())) {
					throw new WrongArgException("当前地址不可送", "addressId", address.getId());
				}
			}

			// ================普通邮费===================

			BigDecimal normalPostage = BigDecimal.ZERO;
			// 如果是线下渠道
			if (opChannel.getChannelType() == 1) {
				// 存在运费的时候
				if (postage != null) {
					if (postage.getNormal() != null) {
						normalPostage = postage.getNormal();
					}
					if (postage.getFaraway() != null && postage.getFaraway().doubleValue() > 0) {
						normalPostage = postage.getFaraway();
					}
					if (postage.getEDT() != null) {
						normalPostage = normalPostage.add(postage.getEDT());
					}

				}

			} else {
				normalPostage = getNormalPostageNew(packs, member, null, accessWay, opChannel, hasOverSea, priceResult);
			}

			if (deliverableTimeVO.getPostage() == null) {
				deliverableTimeVO.setPostage(new PostageVO());
			}
			deliverableTimeVO.getPostage().setNormal(normalPostage);

			// =============偏远地区配送费和限时配送费==============

			if (!hasOverSea) {
				// --------获取skus-------
				List<PsSkuVO> skus = new ArrayList<>();
				Map<String, Integer> skuCountMap = new HashMap<>();
				boolean whetherLogistics = false;
				for (CartProductPack pack : packs) {
					PsSpvVO spv = pack.getSpv();
					if (pack.getSpv().getCombined()) {
						if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
							//
							for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
								skus.add(psc.getSubSkuVO());
								// 联邦或店送时，需要取得配送日期
								if (pack.getProduct().getExpressType() == 1
										|| pack.getProduct().getExpressType() == 2) {
									skuCountMap.put(psc.getSubSkuVO().getSkuCode(), psc.getQuantity());
								}
								if (psc.getSubSkuVO().getWhetherLogistics() != null
										&& psc.getSubSkuVO().getWhetherLogistics() == 1) {
									whetherLogistics = true;
									break;
								}
							}

						}
					} else {
						skus.add(spv.getSkuVO());

						// 联邦或店送时，需要取得配送日期
						if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
							skuCountMap.put(spv.getSkuVO().getSkuCode(), pack.getCount());
						}
						if (spv.getSkuVO() != null) {
							if (spv.getSkuVO().getWhetherLogistics() != null
									&& spv.getSkuVO().getWhetherLogistics() == 1) {
								whetherLogistics = true;
							}
						}
					}

				}
				logger.warn("skus = {}", skus);

				// 大家具不送的地址（）
				if (whetherLogistics) {

					if ("新疆维吾尔自治区".equals(address.getProvince()) || "青海省".equals(address.getProvince())
							|| "西藏自治区".equals(address.getProvince())) {
						throw new WrongArgException("当前地址不可送", "addressId", address.getId());
					}

				}

				// -----------------------
				// Deliverable deliverable =
				// deliverableService.getDeliverable(address.getId(), skus);
				// if (deliverable != null) {
				// if (deliverable.isResult() == 0) {
				// throw new WrongArgException("当前地址不可送", "addressId",
				// address.getId());
				// } else if (deliverable.isResult() == 1) {
				// deliverableTimeVO.setDeliverableDates(getDateUnits(deliverable.getDeliverableDates()));
				// String cityName = deliverable.getCityName();
				// if (StringUtils.isNotBlank(cityName) &&
				// (cityName.contains(CITY1))) {
				// deliverableTimeVO.setDeliverableTimeSlots(getTimeSlots());
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setEDT(deliverable.getExtraPostFee());
				// } else {
				// deliverableTimeVO.setDeliverableTimeSlots(new
				// ArrayList<TimeSlotVO>());
				// }
				// deliverableTimeVO.setDeliveryTip(DESC);
				// BigDecimal fee = deliverable.getPostFee();
				// if (null != fee) {
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setFaraway(fee);
				// }
				// }
				// }

				if (skuCountMap.size() > 0) {
					DeliveryInfoDTO dto = new DeliveryInfoDTO();
					dto.setDistrictId(address.getDistrict().getId().intValue());
					dto.setSkuCountMap(skuCountMap);
					getDeliverables(deliverableTimeVO, dto, opChannel);
				}

			}
		}
		return deliverableTimeVO;
	}

	/**
	 * 获取物流可配送信息
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	public void checktDeliverable(List<CartProductPack> packs, long addressId,OpChannelVO opChannel) {
		if (addressId <= 0) {
			return ;
		}
		MemberAddressVO address = memberAddressService.getById(addressId);
		if (null != address && CollectionUtils.isNotEmpty(packs)) {
			if(opChannel.getChannelType() != null && opChannel.getChannelType() == 1){
				// ===========判断商品是否可配送==========
				for (CartProductPack pack : packs) {
					PsProductVO product = pack.getProduct();
					if (address.getDistrict() == null || !checkDelivery(product, address.getDistrict().getId())) {
						throw new WrongArgException(ErrorCode.CHECK_ADDRESS_NOT.getMesage());
					}
				}
			}

			// =============偏远地区配送费和限时配送费==============
			// --------获取skus-------
			List<PsSkuVO> skus = new ArrayList<>();
			boolean whetherLogistics = false;
			for (CartProductPack pack : packs) {
				PsSpvVO spv = pack.getSpv();
				if (pack.getSpv().getCombined()) {
					if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
						for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
							skus.add(psc.getSubSkuVO());
							if (psc.getSubSkuVO().getWhetherLogistics() != null
									&& psc.getSubSkuVO().getWhetherLogistics() == 1) {
								whetherLogistics = true;
								break;
							}
						}
					}
				} else {
					skus.add(spv.getSkuVO());
					if (spv.getSkuVO() != null) {
						if (spv.getSkuVO().getWhetherLogistics() != null && spv.getSkuVO().getWhetherLogistics() == 1) {
							whetherLogistics = true;
						}
					}
				}
			}
			logger.warn("skus = {}", skus);
			// 大家具不送的地址（）
			if (whetherLogistics) {
				if ("新疆维吾尔自治区".equals(address.getProvince()) || "青海省".equals(address.getProvince())
						|| "西藏自治区".equals(address.getProvince())) {
					throw new WrongArgException(ErrorCode.CHECK_ADDRESS_NOT_LOGISTICS.getMesage());
				}
			}
		}
	}

	/**
	 * 获取物流可配送信息
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	// public DeliverableVO getDeliverable(List<CartProductPack> packs,
	// MemberAddressVO address, MemberVO member,
	// AccessWay accessWay, OpChannelVO opChannel, PostageVO postage) {
	// DeliverableVO deliverableTimeVO = null;
	// if (null != address && CollectionUtils.isNotEmpty(packs)) {
	// deliverableTimeVO = new DeliverableVO();
	// // ===========判断商品是否可配送==========
	// for (CartProductPack pack : packs) {
	// PsProductVO product = pack.getProduct();
	// if (address.getDistrict() == null || !checkDelivery(product,
	// address.getDistrict().getId())) {
	// throw new WrongArgException("当前地址不可送", "addressId", address.getId());
	// }
	// }
	//
	// // ================普通邮费===================
	// BigDecimal normalPostage = BigDecimal.ZERO;
	// // 如果是线下渠道
	// if (opChannel.getChannelType() == 1) {
	// // 存在运费的时候
	// if (postage != null) {
	// if (postage.getNormal() != null) {
	// normalPostage = postage.getNormal();
	// }
	// if (postage.getFaraway() != null && postage.getFaraway().doubleValue() >
	// 0) {
	// normalPostage = postage.getFaraway();
	// }
	// if (postage.getEDT() != null) {
	// normalPostage = normalPostage.add(postage.getEDT());
	// }
	//
	// }
	//
	// } else {
	// normalPostage = getNormalPostage(packs, member, null, accessWay,
	// opChannel);
	// }
	//
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setNormal(normalPostage);
	//
	// // =============偏远地区配送费和限时配送费==============
	// boolean isHasOversea = false;
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (overseaService.isOversea(spv)) {
	// isHasOversea = true;
	// break;
	// }
	// }
	// if (!isHasOversea) {
	// // --------获取skus-------
	// List<String> skuCodes = Lists.newArrayList();
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv.getCombined()) {
	// for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
	// skuCodes.add(sku.getSubSkuCode());
	// }
	// } else {
	// skuCodes.add(spv.getSkuCode());
	// }
	// }
	// List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
	// logger.warn("skus = {}", skus);
	// // -----------------------
	// Deliverable deliverable =
	// deliverableService.getDeliverable(address.getId(), skus);
	// if (deliverable != null) {
	// if (deliverable.isResult() == 0) {
	// throw new WrongArgException("当前地址不可送", "addressId", address.getId());
	// } else if (deliverable.isResult() == 1) {
	// deliverableTimeVO.setDeliverableDates(getDateUnits(deliverable.getDeliverableDates()));
	// String cityName = deliverable.getCityName();
	// if (StringUtils.isNotBlank(cityName) && (cityName.contains(CITY1))) {
	// deliverableTimeVO.setDeliverableTimeSlots(getTimeSlots());
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setEDT(deliverable.getExtraPostFee());
	// } else {
	// deliverableTimeVO.setDeliverableTimeSlots(new ArrayList<TimeSlotVO>());
	// }
	// deliverableTimeVO.setDeliveryTip(DESC);
	// BigDecimal fee = deliverable.getPostFee();
	// if (null != fee) {
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setFaraway(fee);
	// }
	// }
	// }
	// }
	// }
	// return deliverableTimeVO;
	// }

	/**
	 * 判断商品在一个地区是否可配送
	 * 
	 * @param product
	 * @param districtId
	 * @return
	 */
	public boolean checkDelivery(PsProductVO product, Long districtId) {
		if (districtId == null) {
			return false;
		}
		boolean rt = true;
		LogisticsType logisticsType = EnumUtil.valueOf(product.getExpressType(), LogisticsType.class);
		DeliveryType type = null;
		switch (logisticsType) {
		case SHOP:
		case SELF:
			type = DeliveryType.SELF;
			break;
		case FEDEX:
			type = DeliveryType.FEDEX;
		default:
			break;
		}
		if (type != null) {
			rt = deliveryDistrictSerivce.checkDelivery(type, districtId);
		}

		if (rt) {
			// TODO 校验商品是否在限定配置区域内
			rt = deliveryDistrictSerivce.checkDelivery(product.getCode(), districtId);
		}
		return rt;
	}

	/**
	 * 获取物流可配送信息 不抛出异常，直接返回 null
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	// public DeliverableVO
	// getDeliverableForOrderPreviewNew(List<CartProductPack> packs,
	// MemberAddressVO address,
	// MemberVO member, AccessWayEnum accessWay, OpChannelVO opChannel,
	// PostageVO postage, Boolean hasOverSea,
	// PriceResult priceResult) {
	//
	// DeliverableVO deliverableTimeVO = null;
	// if (null != address && CollectionUtils.isNotEmpty(packs)) {
	// deliverableTimeVO = new DeliverableVO();
	// // ===========判断商品是否可配送==========
	// for (CartProductPack pack : packs) {
	// PsProductVO product = pack.getProduct();
	// if (address.getDistrict() == null || !checkDelivery(product,
	// address.getDistrict().getId())) {
	// return null;
	// }
	// }
	//
	// // ================普通邮费===================
	//
	// BigDecimal normalPostage = BigDecimal.ZERO;
	// // 如果是线下渠道
	// if (opChannel.getChannelType() == 1) {
	// // 存在运费的时候
	// if (postage != null) {
	// if (postage.getNormal() != null) {
	// normalPostage = postage.getNormal();
	// }
	// if (postage.getFaraway() != null && postage.getFaraway().doubleValue() >
	// 0) {
	// normalPostage = postage.getFaraway();
	// }
	// if (postage.getEDT() != null) {
	// normalPostage = normalPostage.add(postage.getEDT());
	// }
	//
	// }
	//
	// } else {
	// normalPostage = getNormalPostageNew(packs, member, null, accessWay,
	// opChannel, hasOverSea, priceResult);
	// }
	//
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setNormal(normalPostage);
	//
	// // =============偏远地区配送费和限时配送费==============
	// // boolean isHasOversea = false;
	// // for (CartProductPack pack : packs) {
	// // PsSpvVO spv = pack.getSpv();
	// // if (overseaService.isOversea(spv)) {
	// // isHasOversea = true;
	// // break;
	// // }
	// // }
	// if (!hasOverSea) {
	// // --------获取skus-------
	// List<PsSkuVO> skus = new ArrayList<>();
	// Map<String, Integer> skuCountMap = new HashMap<>();
	// for (CartProductPack pack : packs) {
	//
	// if (pack.getSpv().getCombined()) {
	// if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
	// //
	// for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
	// skus.add(psc.getSubSkuVO());
	// // 联邦或店送时，需要取得配送日期
	// if (pack.getProduct().getExpressType() == 1
	// || pack.getProduct().getExpressType() == 2) {
	// skuCountMap.put(psc.getSubSkuVO().getSkuCode(), psc.getQuantity());
	// }
	//
	// }
	//
	// }
	// } else {
	// PsSpvVO spv = pack.getSpv();
	// skus.add(spv.getSkuVO());
	// // 联邦或店送时，需要取得配送日期
	// if (pack.getProduct().getExpressType() == 1 ||
	// pack.getProduct().getExpressType() == 2) {
	// skuCountMap.put(spv.getSkuVO().getSkuCode(), pack.getCount());
	// }
	// }
	//
	// }
	//
	// if(skuCountMap.size() > 0){
	// DeliveryInfoDTO dto = new DeliveryInfoDTO();
	// dto.setDistrictId(address.getDistrict().getId().intValue());
	// dto.setSkuCountMap(skuCountMap);
	// getDeliverables(deliverableTimeVO, dto, opChannel);
	// }
	//
	// // List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
	// // logger.warn("skus = {}", skus);
	// // -----------------------
	// // Deliverable deliverable =
	// // deliverableService.getDeliverable(address.getId(), skus);
	// // if (deliverable != null) {
	// // if (deliverable.isResult() == 0) {
	// // return null;
	// // } else if (deliverable.isResult() == 1) {
	// //
	// deliverableTimeVO.setDeliverableDates(getDateUnits(deliverable.getDeliverableDates()));
	// // String cityName = deliverable.getCityName();
	// // if (StringUtils.isNotBlank(cityName) &&
	// // (cityName.contains(CITY1))) {
	// // deliverableTimeVO.setDeliverableTimeSlots(getTimeSlots());
	// // if (deliverableTimeVO.getPostage() == null) {
	// // deliverableTimeVO.setPostage(new PostageVO());
	// // }
	// // deliverableTimeVO.getPostage().setEDT(deliverable.getExtraPostFee());
	// // } else {
	// // deliverableTimeVO.setDeliverableTimeSlots(new
	// // ArrayList<TimeSlotVO>());
	// // }
	// // deliverableTimeVO.setDeliveryTip(DESC);
	// // BigDecimal fee = deliverable.getPostFee();
	// // if (null != fee) {
	// // if (deliverableTimeVO.getPostage() == null) {
	// // deliverableTimeVO.setPostage(new PostageVO());
	// // }
	// // deliverableTimeVO.getPostage().setFaraway(fee);
	// // }
	// // }
	// // }
	// }
	// }
	// return deliverableTimeVO;
	// }

	/**
	 * 获取物流可配送信息 不抛出异常，直接返回 null
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	// public DeliverableVO getDeliverableForOrderPreview(List<CartProductPack>
	// packs, MemberAddressVO address,
	// MemberVO member, AccessWay accessWay, OpChannelVO opChannel, PostageVO
	// postage) {
	// DeliverableVO deliverableTimeVO = null;
	// if (null != address && CollectionUtils.isNotEmpty(packs)) {
	// deliverableTimeVO = new DeliverableVO();
	// // ===========判断商品是否可配送==========
	// for (CartProductPack pack : packs) {
	// PsProductVO product = pack.getProduct();
	// if (address.getDistrict() == null || !checkDelivery(product,
	// address.getDistrict().getId())) {
	// return null;
	// }
	// }
	//
	// // ================普通邮费===================
	//
	// BigDecimal normalPostage = BigDecimal.ZERO;
	// // 如果是线下渠道
	// if (opChannel.getChannelType() == 1) {
	// // 存在运费的时候
	// if (postage != null) {
	// if (postage.getNormal() != null) {
	// normalPostage = postage.getNormal();
	// }
	// if (postage.getFaraway() != null && postage.getFaraway().doubleValue() >
	// 0) {
	// normalPostage = postage.getFaraway();
	// }
	// if (postage.getEDT() != null) {
	// normalPostage = normalPostage.add(postage.getEDT());
	// }
	//
	// }
	//
	// } else {
	// normalPostage = getNormalPostage(packs, member, null, accessWay,
	// opChannel);
	// }
	//
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setNormal(normalPostage);
	//
	// // =============偏远地区配送费和限时配送费==============
	// boolean isHasOversea = false;
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (overseaService.isOversea(spv)) {
	// isHasOversea = true;
	// break;
	// }
	// }
	// if (!isHasOversea) {
	// // --------获取skus-------
	// List<String> skuCodes = Lists.newArrayList();
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv.getCombined()) {
	// for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
	// skuCodes.add(sku.getSubSkuCode());
	// }
	// } else {
	// skuCodes.add(spv.getSkuCode());
	// }
	// }
	// List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
	// logger.warn("skus = {}", skus);
	// // -----------------------
	// Deliverable deliverable =
	// deliverableService.getDeliverable(address.getId(), skus);
	// if (deliverable != null) {
	// if (deliverable.isResult() == 0) {
	// return null;
	// } else if (deliverable.isResult() == 1) {
	// deliverableTimeVO.setDeliverableDates(getDateUnits(deliverable.getDeliverableDates()));
	// String cityName = deliverable.getCityName();
	// if (StringUtils.isNotBlank(cityName) && (cityName.contains(CITY1))) {
	// deliverableTimeVO.setDeliverableTimeSlots(getTimeSlots());
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setEDT(deliverable.getExtraPostFee());
	// } else {
	// deliverableTimeVO.setDeliverableTimeSlots(new ArrayList<TimeSlotVO>());
	// }
	// deliverableTimeVO.setDeliveryTip(DESC);
	// BigDecimal fee = deliverable.getPostFee();
	// if (null != fee) {
	// if (deliverableTimeVO.getPostage() == null) {
	// deliverableTimeVO.setPostage(new PostageVO());
	// }
	// deliverableTimeVO.getPostage().setFaraway(fee);
	// }
	// }
	// }
	// }
	// }
	// return deliverableTimeVO;
	// }

	/**
	 * 获取物流可配送信息 不抛出异常，直接返回 null
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	public DeliverableVO getDeliverableForOrderPrice(List<CartProductPack> packs, MemberAddressVO address,
			MemberVO member, AccessWayEnum accessWay, OpChannelVO opChannel, PostageVO postage, Boolean hasOverSea,
			BigDecimal normalPostage) {

		DeliverableVO deliverableTimeVO = null;
		if (null != address && CollectionUtils.isNotEmpty(packs)) {
			deliverableTimeVO = new DeliverableVO();
			// ===========判断商品是否可配送==========
			for (CartProductPack pack : packs) {
				PsProductVO product = pack.getProduct();
				if (address.getDistrict() == null || !checkDelivery(product, address.getDistrict().getId())) {
					return null;
				}
			}

			if (!hasOverSea) {
				// --------获取skus-------
				List<PsSkuVO> skus = new ArrayList<>();
				Map<String, Integer> skuCountMap = new HashMap<>();
				for (CartProductPack pack : packs) {

					if (pack.getSpv().getCombined()) {
						if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
							//
							for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
								skus.add(psc.getSubSkuVO());
								// 联邦或店送时，需要取得配送日期
								if (pack.getProduct().getExpressType() == 1
										|| pack.getProduct().getExpressType() == 2) {
									skuCountMap.put(psc.getSubSkuVO().getSkuCode(), psc.getQuantity());
								}

							}

						}
					} else {
						PsSpvVO spv = pack.getSpv();
						skus.add(spv.getSkuVO());
						// 联邦或店送时，需要取得配送日期
						if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
							skuCountMap.put(spv.getSkuVO().getSkuCode(), pack.getCount());
						}
					}

				}
				// -----------------------
				// Deliverable deliverable =
				// deliverableService.getDeliverable(address.getId(), skus);
				// if (deliverable != null) {
				// if (deliverable.isResult() == 0) {
				// return null;
				// } else if (deliverable.isResult() == 1) {
				// deliverableTimeVO.setDeliverableDates(getDateUnits(deliverable.getDeliverableDates()));
				// String cityName = deliverable.getCityName();
				// if (StringUtils.isNotBlank(cityName) &&
				// (cityName.contains(CITY1))) {
				// deliverableTimeVO.setDeliverableTimeSlots(getTimeSlots());
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setEDT(deliverable.getExtraPostFee());
				// } else {
				// deliverableTimeVO.setDeliverableTimeSlots(new
				// ArrayList<TimeSlotVO>());
				// }
				// deliverableTimeVO.setDeliveryTip(DESC);
				// BigDecimal fee = deliverable.getPostFee();
				// if (null != fee) {
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setFaraway(fee);
				// deliverableTimeVO.getPostage().setNormal(normalPostage);
				//
				// }
				// }
				//
				// }

				if (skuCountMap.size() > 0) {

					DeliveryInfoDTO dto = new DeliveryInfoDTO();
					dto.setDistrictId(address.getDistrict().getId().intValue());
					dto.setSkuCountMap(skuCountMap);
					getDeliverablesPreview(deliverableTimeVO, dto);
				}

			}
		}
		return deliverableTimeVO;
	}

	/**
	 * 获取物流可配送信息
	 * 
	 * @param packs
	 * @param address
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	public DeliverableVO getDeliverablePrice(List<CartProductPack> packs, MemberAddressVO address, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO opChannel, PostageVO postage, boolean hasOverSea,
			BigDecimal normalPostage) {
		DeliverableVO deliverableTimeVO = null;
		if (null != address && CollectionUtils.isNotEmpty(packs)) {
			deliverableTimeVO = new DeliverableVO();
			// ===========判断商品是否可配送==========
			for (CartProductPack pack : packs) {
				PsProductVO product = pack.getProduct();
				if (address.getDistrict() == null || !checkDelivery(product, address.getDistrict().getId())) {
					throw new WrongArgException("当前地址不可送", "addressId", address.getId());
				}
			}

			// ================普通邮费===================

			if (deliverableTimeVO.getPostage() == null) {
				deliverableTimeVO.setPostage(new PostageVO());
			}
			deliverableTimeVO.getPostage().setNormal(normalPostage);

			// =============偏远地区配送费和限时配送费==============

			if (!hasOverSea) {
				// --------获取skus-------
				List<PsSkuVO> skus = new ArrayList<>();
				Map<String, Integer> skuCountMap = new HashMap<>();
				boolean whetherLogistics = false;
				for (CartProductPack pack : packs) {
					PsSpvVO spv = pack.getSpv();
					if (pack.getSpv().getCombined()) {
						if (CollectionUtils.isNotEmpty(pack.getSpv().getSkuCombinationList())) {
							//
							for (PsSkuCombinationVO psc : pack.getSpv().getSkuCombinationList()) {
								skus.add(psc.getSubSkuVO());
								// 联邦或店送时，需要取得配送日期
								if (pack.getProduct().getExpressType() == 1
										|| pack.getProduct().getExpressType() == 2) {
									skuCountMap.put(psc.getSubSkuVO().getSkuCode(), psc.getQuantity());
								}

								if (psc.getSubSkuVO().getWhetherLogistics() != null
										&& psc.getSubSkuVO().getWhetherLogistics() == 1) {
									whetherLogistics = true;
									break;
								}
							}

						}
					} else {
						skus.add(spv.getSkuVO());
						// 联邦或店送时，需要取得配送日期
						if (pack.getProduct().getExpressType() == 1 || pack.getProduct().getExpressType() == 2) {
							skuCountMap.put(spv.getSkuVO().getSkuCode(), pack.getCount());
						}

						if (spv.getSkuVO() != null) {
							if (spv.getSkuVO().getWhetherLogistics() != null
									&& spv.getSkuVO().getWhetherLogistics() == 1) {
								whetherLogistics = true;
							}
						}
					}

				}
				logger.warn("skus = {}", skus);

				// 大家具不送的地址（）
				if (whetherLogistics) {

					if ("新疆维吾尔自治区".equals(address.getProvince()) || "青海省".equals(address.getProvince())
							|| "西藏自治区".equals(address.getProvince())) {
						throw new WrongArgException("大家具商品，当前地址不可送", "addressId", address.getId());
					}

				}

				if (skuCountMap.size() > 0) {
					// -----------------------
					DeliveryInfoDTO dto = new DeliveryInfoDTO();
					dto.setDistrictId(address.getDistrict().getId().intValue());
					dto.setSkuCountMap(skuCountMap);
					getDeliverables(deliverableTimeVO, dto, opChannel);
				}

			}
		}
		return deliverableTimeVO;
	}

	public DeliveryInfoVO getDeliverables(DeliveryInfoDTO dto) {

		ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

		if (resp.isSuccess()) {
			return resp.getBean();
		}

		throw new WrongArgException(resp.getRespMsg(), "addressId", resp.getRespMsg());

	}

	public void getDeliverables(DeliverableVO deliverableTimeVO, DeliveryInfoDTO dto, OpChannelVO opChannel) {
		// 线下不走配送规则
		if (ChannelType.OFFLINE.getId().equals(opChannel.getChannelType())) {
			return;
		}

		ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

		if (resp.isSuccess()) {
			if (resp.getBean() != null) {

				deliverableTimeVO.setDeliverableDates(setDateUnits(resp.getBean()));

				deliverableTimeVO.setDeliverableTimeSlots(setTimeSlots(resp.getBean()));

				PostageVO postageVO = new PostageVO();
				postageVO.setEDT(new BigDecimal(resp.getBean().getExtraDeliveryFee()));
				deliverableTimeVO.setPostage(postageVO);
				deliverableTimeVO.setDeliveryTip(this.getDeliveryTip(postageVO.getEDT()));
				return;
				// BigDecimal fee = deliverable.getPostFee();
				// if (null != fee) {
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setFaraway(fee);
				// }

			} else {
				throw new WrongArgException("当前地址没可配送日期", "addressId", resp.getRespMsg());
			}
		} else {

			if ("DLVR_100020".equals(resp.getRespCode())) {

				throw new WrongArgException("该地址不支持配送", "addressId", resp.getRespMsg());

			} else {
				throw new WrongArgException(resp.getRespMsg(), "addressId", resp.getRespMsg());
			}

		}

	}

	public void getDeliverablesPreview(DeliverableVO deliverableTimeVO, DeliveryInfoDTO dto) {

		ServiceResp<DeliveryInfoVO> resp = deliveryRuleService.getDeliveryInfo(dto);

		if (resp.isSuccess()) {
			if (resp.getBean() != null) {

				deliverableTimeVO.setDeliverableDates(setDateUnits(resp.getBean()));

				deliverableTimeVO.setDeliverableTimeSlots(setTimeSlots(resp.getBean()));

				PostageVO postageVO = new PostageVO();
				postageVO.setEDT(new BigDecimal(resp.getBean().getExtraDeliveryFee()));
				deliverableTimeVO.setPostage(postageVO);
				deliverableTimeVO.setDeliveryTip(this.getDeliveryTip(postageVO.getEDT()));
				return;
				// BigDecimal fee = deliverable.getPostFee();
				// if (null != fee) {
				// if (deliverableTimeVO.getPostage() == null) {
				// deliverableTimeVO.setPostage(new PostageVO());
				// }
				// deliverableTimeVO.getPostage().setFaraway(fee);
				// }

			} else {
				throw new WrongArgException("当前地址没可配送日期", "addressId", resp.getRespMsg());
			}
		}
		logger.info("getDeliverablesPreview error Message:" + resp.getRespMsg());
		// throw new WrongArgException(resp.getRespMsg(), "addressId",
		// resp.getRespMsg());

	}

	/**
	 * 获取配送日期
	 * 
	 * @param deliverableTimes
	 * @return
	 */
	private List<DateUnitVO> setDateUnits(DeliveryInfoVO info) {
		List<DateUnitVO> dateUnitVOs = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(info.getDeliverableDates())) {
			for (int i = 0; i < info.getDeliverableDates().size(); i++) {
				if (info.getDeliverableDates().get(i) != null) {
					DateUnitVO dateUnitVO = new DateUnitVO();
					dateUnitVO.setAvailable(info.getDeliverableDates().get(i).getAvailable());
					dateUnitVO.setDesc(info.getDeliverableDates().get(i).getDesc());
					dateUnitVO.setText(info.getDeliverableDates().get(i).getTextDisplay());
					dateUnitVO.setPreciseTime(info.getDeliverableDates().get(i).getPreciseTime());
					dateUnitVOs.add(dateUnitVO);
				}
			}
		}
		return dateUnitVOs;
	}

	/**
	 * 获取时段
	 * 
	 * @return
	 */
	private List<TimeSlotVO> setTimeSlots(DeliveryInfoVO info) {
		List<TimeSlotVO> timeSlotVOs = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(info.getDeliverableTimeSlots())) {
			for (int i = 0; i < info.getDeliverableTimeSlots().size(); i++) {
				TimeSlotVO timeSlotVO = new TimeSlotVO();
				timeSlotVO.setId(info.getDeliverableTimeSlots().get(i).getId());
				timeSlotVO.setText(info.getDeliverableTimeSlots().get(i).getText());
				timeSlotVOs.add(timeSlotVO);
			}
		}

		return timeSlotVOs;
	}
}
