package com.thebeastshop.pegasus.channelservice.adapter.ipos;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.vo.WhInvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.OrderCreateDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.ipos.OrderDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderSkuVO;
import com.thebeastshop.pegasus.channelservice.vo.order.SoInvoiceInfoVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoInvoiceInfoVO1;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OrderTypeEnum;
import com.thebeastshop.pegasus.service.operation.model.IposPrintTask;
import com.thebeastshop.pegasus.service.operation.model.OpProduct;
import com.thebeastshop.pegasus.service.operation.model.OpReturnRequest;
import com.thebeastshop.pegasus.service.operation.model.OpReturnRequestSku;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackage;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeliveryInfo;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;


@Service("iposOrderAdapter")
public class OrderAdapter {
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private SWhInvService sWhInvService;

	private final static Logger logger = LoggerFactory.getLogger(OrderAdapter.class);
	private PegasusChannelServiceFacade instance=PegasusChannelServiceFacade.getInstance();

	public static final List<Long> isJitNotCateId_pos = new ArrayList<>();
	static {
		isJitNotCateId_pos.add(119L);// 101-鲜花
		isJitNotCateId_pos.add(280L);// 998-服务费用
		isJitNotCateId_pos.add(307L); // 997-会员服务费用
		isJitNotCateId_pos.add(235L); // 671-餐饮-茶
		isJitNotCateId_pos.add(333L); // 672-餐饮-咖啡
		isJitNotCateId_pos.add(334L); // 673-餐饮-巧克力，牛奶
		isJitNotCateId_pos.add(335L); // 674-餐饮-谁
		isJitNotCateId_pos.add(336L); // 675-餐饮-其他饮品
		isJitNotCateId_pos.add(337L); // 676-餐饮-甜点
		//isJitNotCateId.add(1L); // 677-餐饮-主食
		isJitNotCateId_pos.add(339L); // 678-餐饮-餐饮其他
		isJitNotCateId_pos.add(340L); // 679-餐饮-餐饮套餐

	}

	@Autowired
	private SPresaleService sPresaleService;
	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderCreateVO
	 */
//	public OpSalesOrderVO ipos2Common(OrderCreateVO orderCreateVO) {
//		//订单VO
//		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
//		//包裹VO
//		List<OpSoPackageVO> opSoPackageVOs=new ArrayList<OpSoPackageVO>();
//		//官网默认是一个包裹
//		OpSoPackageVO opSoPackage=new OpSoPackageVO();
//		//包裹地址信息
//		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=new OpSoPackageDeliveryInfoVO();
//		//包裹sku信息
//		List<OpSoPackageSkuVO> opSoPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>();
//		OpMemberVO memberVo=null;
//		if(orderCreateVO.getUserId()!=null&&orderCreateVO.getUserId()>0){
//			memberVo=instance.getMemberById(orderCreateVO.getUserId(),null);
//		}
//		//配送仓
//		OpChannelVO opChannel = mcOpChannelService.findByCode(orderCreateVO.getChannelCode());
//		if (opChannel != null) {
//			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
//		}
//		// @auhtor lijing start
//		//是否需要发票
//		opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
//		// 发票是否随同货物发送，0否1是
//		//opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//		if(orderCreateVO.getIsInvoiceInSamePackage() == null) {
//			opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//		}else{
//			opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
//		}
//		//判断发票是否同货物发送
//		OrderPreCheck(orderCreateVO.getChannelCode(),orderCreateVO,opChannel);//下单之前的预判 校验价格 校验库存 校验是否下架
//		//设置发票
//		if(orderCreateVO.getNeedInvoice() != null && orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE){
//			logger.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}",orderCreateVO.getSoInvoiceInfoVO());
//			OpSoInvoiceInfoVO opSoInvoiceInfo = new OpSoInvoiceInfoVO();
//			SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
//			if(soInvoiceInfoVO != null){
//				logger.info("设置发票 ");
//				opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
//				opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
//				opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
//				opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
//				opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
//				opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
//				opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
//				opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
//				opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
//				opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
//				opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
//				opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
//				opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
//				opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
//			}
//		}
//		// @auhtor lijing end
//
//		// 订单来源渠道编码
//		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
//		opSalesOrderVO.setOuterOrderCode(orderCreateVO.getOuterOrderCode());//外部渠道订单号
//		opSalesOrderVO.setCreateOperatorId(orderCreateVO.getCreateOperatorId());//操作员id
//		opSalesOrderVO.setCreateOperatorName(orderCreateVO.getCreateOperatorName());//操作员名称
//		// 卡片类型，0不需要1空白2代写
//		opSoPackage.setCardType(orderCreateVO.getNoteCard());
//		// 卡片内容
//		opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
//		//配送方式
//		opSoPackage.setDeliveryType(getDeliveryType(orderCreateVO.getDeliveryType()));
//		//限时配送
//		opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());
//
//		//期望收货时间
//		if(StringUtils.isNotBlank(orderCreateVO.getDeliveryDate())){
//		    opSoPackage.setExpectReceiveDate(DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
//		}else{
//		    opSoPackage.setPlanedDeliveryDate(new Date());
//		}
//
//		//设置配送地址
//		AddressVO address=orderCreateVO.getDeliveryAddress();
//		//详细地址
//		opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
//		//环线
//		opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
//		//公司名称
//		opSoPackageDeliveryInfoVO.setCompanyName(address.getCompany_name());
//		//收货的区县ID
//		opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrict_id());
//		//收件人
//		opSoPackageDeliveryInfoVO.setReceiver(address.getName());
//		//邮编
//		opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
//		//称谓
//		opSoPackageDeliveryInfoVO.setTitle(address.getMagento_title());
//		//收件人电话
//		opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
//
//		//订单行
//		List<OrderCreateDetailVO> orderCreateDetails=orderCreateVO.getItems();
//		//配送方式，判断是否需要强制审单
//		Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
//		for(OrderCreateDetailVO detail:orderCreateDetails){
//				OpSoPackageSkuVO packageSku=new OpSoPackageSkuVO();
//
//				PsProductVO productVO = null;
//				if(opChannel!=null && opChannel.getChannelType()!=null && opChannel.getChannelType()==1){
//					 productVO=mcPsProductService.findProdBySkuCode(detail.getSku());
//				}else{
//					 productVO=mcPsProductService.findProdByChnCodeSkuCode(orderCreateVO.getChannelCode(),detail.getSku());
//					if(null==productVO){
//						throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
//					}
//				}
//
////				PsProductVO productVO=pbInstance.findProdByChnCodeSkuCode(orderCreateVO.getChannelCode(),detail.getSku());
////				if(null==productVO){
////					throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
////				}
//				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
//				packageSku.setSkuCode(detail.getSku());
//				//coupon使用
//				packageSku.setBrandId(detail.getBrandId());
//				packageSku.setCategroyId(detail.getCategroyId());
//				//TODO
//				packageSku.setIsJit(detail.getIsJit());//是否来单制作
//				packageSku.setQuantity(detail.getQuantity());//数量
//				if(detail.getPointValue() ==null){
//					packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
//				}else{
//					packageSku.setUnitPoint(BigDecimal.valueOf(detail.getPointValue()));//单品积分
//				}
//				//判断是否包含两种以上配送方式，如果是，则需要强制审单
//				if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
//					deliveryTypes.put("SELF", true);
//				}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
//					deliveryTypes.put("FEDX24", true);
//				}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
//					deliveryTypes.put("SF_AIR", true);
//				}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
//					deliveryTypes.put("SF_LAND", true);
//				}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
//					deliveryTypes.put("YTO", true);
//				}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
//					deliveryTypes.put("DEPPON", true);
//				}
//
//				// 特价
//				if(detail.getDiscountPrice()==null){
//					detail.setDiscountPrice(0D);
//
//				}
//
//				packageSku.setUnitDiscount(BigDecimal.ZERO);
//
//			if (canChangePrice(detail.getSku())) {
//
//				if (detail.getDiscountPrice() > 0) {
//					detail.setPrice(detail.getDiscountPrice());
//					detail.setDiscountPrice(0D);
//					packageSku.setUnitDiscount(BigDecimal.ZERO);
//				}
//
//			}
//					if(productVO.getAllowVipDiscount()==1){
//						if(memberVo!=null){
//							//如果是故事订花。折扣为0
//							//if(canChangePrice(detail.getSku())){
//								//packageSku.setUnitDiscount(BigDecimal.ZERO);
//							//}else{
//								packageSku.setUnitDiscount(getUnitDiscount(BigDecimal.valueOf(detail.getPrice()), memberVo.getMemberLevel(),orderCreateVO.getGiftCardAmount(),BigDecimal.valueOf(detail.getDiscountPrice())));//单品折扣
//							//}
//						}else{
//							if(detail.getDiscountPrice()>0){
//								BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//								packageSku.setUnitDiscount(unitDiscount);
//							}else{
//								packageSku.setUnitDiscount(BigDecimal.ZERO);
//							}
//						}
//
//					}else{
//						if(detail.getDiscountPrice()>0){
//							BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//							packageSku.setUnitDiscount(unitDiscount);
//						}else{
//							packageSku.setUnitDiscount(BigDecimal.ZERO);
//						}
//					}
//
//
//
//				// 折扣后金额
//				packageSku.setUnitAmountAfterDiscount(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()));
//				// 特价
//				packageSku.setDiscountPrice(BigDecimal.valueOf(detail.getDiscountPrice()));
//
//				if(detail.getPointPrice() !=null && detail.getPointPrice()>0){
//					packageSku.setUnitPointDeduction(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()).subtract(BigDecimal.valueOf(detail.getPointPrice())));//折扣后的价格减去积分价格
//				}else{
//					packageSku.setUnitPointDeduction(BigDecimal.ZERO);
//				}
//				packageSku.setUnitPrice(BigDecimal.valueOf(detail.getPrice()));
//				//TODO
//				packageSku.setIsGift(0);
//				opSoPackageSkuVOs.add(packageSku);
//		}
//
//		// 发票是否随同货物发送，0否1是
//		//opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//
//		//是否审单,有两种不同的运输方式或者包含自送的。需要审单
//		if(deliveryTypes.size()>1||(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF"))){
//			opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
//		}else{
//			opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
//		}
//		//设置配送信息的快递方式，当只有一种配送方式时，设置
//		if(deliveryTypes!=null&&deliveryTypes.size()==1){
//			if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
//			}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
//			}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//			}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
//			}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
//			}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
//			}
//		}
//		//设置包裹配送信息
//		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
//		opSoPackageVOs.add(opSoPackage);
//		//设置订单关联包裹
//		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
//
//		if(memberVo!=null){
//			// 会员code
//			 opSalesOrderVO.setMemberCode(memberVo.getCode());
//			 opSalesOrderVO.setMemberId(memberVo.getId());
//		}
//
//		// 用户备注
//		opSalesOrderVO.setRemark(orderCreateVO.getNote());
//		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
//		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
//		// COUPON编码
//		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());
//		if(orderCreateVO.getOtherDiscount()!=null){
//			//头折扣
//			opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
//		}else{
//			//头折扣
//			opSalesOrderVO.setDiscountOnHead(BigDecimal.ZERO);
//		}
//
//		// 服务费
//		if(orderCreateVO.getServiceFee()!=null){
//			opSalesOrderVO.setServiceFeeAmount(new BigDecimal(orderCreateVO.getServiceFee()));
//		}else{
//			opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
//		}
//
//		//礼品卡
//		opSalesOrderVO.setGiftCardDesc(orderCreateVO.getPresentCards());
//		//礼品卡金额
//		if(orderCreateVO.getGiftCardAmount()!=null){
//			opSalesOrderVO.setGiftCardAmount(new BigDecimal(orderCreateVO.getGiftCardAmount()));
//		}else{
//			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
//		}
//		//是否匿名
//		opSalesOrderVO.setIsAnonymous(orderCreateVO.getAnonymous()?OpSalesOrder.IS_ANONYMOUS_TRUE:OpSalesOrder.IS_ANONYMOUS_FALSE);
//		//预售拆包裹  TODO
//		List<OpSoPackageVO> splitPackages= splitPackage(opSalesOrderVO, opChannel);
//		if(CollectionUtils.isNotEmpty(splitPackages)){
//			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
//		}
//		 return opSalesOrderVO;
//	 }

	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderCreateVO
	 */
	public OpSalesOrderVO iposOrder2Common(OrderCreateVO orderCreateVO) {
		//订单VO
		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		
		OrderTypeEnum orderTypeEnum = OrderTypeEnum.getEnumByCode(orderCreateVO.getOrderType());
		opSalesOrderVO.setOrderTypeEnum(orderTypeEnum);
		
	
		//运费
		if(orderCreateVO.getCarriage()==null){
			opSalesOrderVO.setCarriage(BigDecimal.ZERO);
		}else{

			opSalesOrderVO.setCarriage(orderCreateVO.getCarriage());
		}
		// 限时送达费用
		if(orderCreateVO.getLimitFee()==null){
			opSalesOrderVO.setLimitFee(BigDecimal.ZERO);
		}else{

			opSalesOrderVO.setLimitFee(orderCreateVO.getLimitFee());
		}

		//包裹VO
		List<OpSoPackageVO> opSoPackageVOs=new ArrayList<OpSoPackageVO>();
		//官网默认是一个包裹
		OpSoPackageVO opSoPackage=new OpSoPackageVO();
		//包裹地址信息
		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=new OpSoPackageDeliveryInfoVO();
		//包裹sku信息
		List<OpSoPackageSkuVO> opSoPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>();
		MemberVO memberVo=null;
		if(orderCreateVO.getUserId()!=null&&orderCreateVO.getUserId()>0){
			memberVo=memberQueryService.getById(orderCreateVO.getUserId());
		}
		//配送仓
		OpChannelVO opChannel = mcOpChannelService.findByCode(orderCreateVO.getChannelCode());
		if (opChannel != null) {
			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
		}
		// @auhtor lijing start
		//是否需要发票
		opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
		// 发票是否随同货物发送，0否1是
		//opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
		if(orderCreateVO.getIsInvoiceInSamePackage() == null) {
			opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
		}else{
			opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
		}
		//判断发票是否同货物发送
		OrderPreCheck(orderCreateVO.getChannelCode(),orderCreateVO,opChannel);//下单之前的预判 校验价格 校验库存 校验是否下架
		//设置发票
		if(orderCreateVO.getNeedInvoice() != null && orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE){
			logger.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}",orderCreateVO.getSoInvoiceInfoVO());
			OpSoInvoiceInfoVO1 opSoInvoiceInfo = new OpSoInvoiceInfoVO1();
			SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
			if(soInvoiceInfoVO != null){
				logger.info("设置发票 ");
				opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
				opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
				opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
				opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
				opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
				opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
				opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
				opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
				opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
				opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
				opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
				opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
				opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
				opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
			}
		}
		// @auhtor lijing end

		// 订单来源渠道编码
		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
		opSalesOrderVO.setOuterOrderCode(orderCreateVO.getOuterOrderCode());//外部渠道订单号
		opSalesOrderVO.setCreateOperatorId(orderCreateVO.getCreateOperatorId());//操作员id
		opSalesOrderVO.setCreateOperatorName(orderCreateVO.getCreateOperatorName());//操作员名称
		// 卡片类型，0不需要1空白2代写
		opSoPackage.setCardType(orderCreateVO.getNoteCard());
		// 卡片内容
		opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
		//配送方式
		opSoPackage.setDeliveryType(getDeliveryType(orderCreateVO.getDeliveryType()));
		//限时配送
		opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());

		//期望收货时间
		if(StringUtils.isNotBlank(orderCreateVO.getDeliveryDate())){
		    opSoPackage.setExpectReceiveDate(DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
		}else{
			 opSoPackage.setPlanedDeliveryDate(new Date());
			if(orderCreateVO.getOrderType()==2 || orderCreateVO.getOrderType()==3 ){
				Calendar c = Calendar.getInstance();

				int hour = c.get(Calendar.HOUR_OF_DAY);

				int minute = c.get(Calendar.MINUTE);

				if (hour > 16 || (hour == 16 && minute > 0)) {
					opSoPackage.setPlanedDeliveryDate(DateUtil.addDay(new Date(), 1));

				} 
			}

		}
		
		//设置配送地址
		AddressVO address=orderCreateVO.getDeliveryAddress();
		//详细地址
		opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
		//环线
		opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
		//公司名称
		opSoPackageDeliveryInfoVO.setCompanyName(address.getCompany_name());
		//收货的区县ID
		opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrict_id());
		//收件人
		opSoPackageDeliveryInfoVO.setReceiver(address.getName());
		//邮编
		opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
		//称谓
		opSoPackageDeliveryInfoVO.setTitle(address.getMagento_title());
		//收件人电话
		opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
		opSoPackageDeliveryInfoVO.setOpenId(address.getOpenId());
		//订单行
		List<OrderCreateDetailVO> orderCreateDetails=orderCreateVO.getItems();
		//配送方式，判断是否需要强制审单
		Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
		for(OrderCreateDetailVO detail:orderCreateDetails){
				OpSoPackageSkuVO packageSku=new OpSoPackageSkuVO();
				
				PsProductVO productVO = null;
				if(opChannel!=null && opChannel.getChannelType()!=null && opChannel.getChannelType()==1){
					 productVO=mcPsProductService.findProdBySkuCode(detail.getSku());
				}else{
					 productVO=mcPsProductService.findProdByChnCodeSkuCode(orderCreateVO.getChannelCode(),detail.getSku());
					if(null==productVO){
						throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
					}
				}
				
//				PsProductVO productVO=pbInstance.findProdByChnCodeSkuCode(orderCreateVO.getChannelCode(),detail.getSku());
//				if(null==productVO){
//					throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
//				}
				
				packageSku.setProductCode(productVO.getCode());
				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
				packageSku.setSkuCode(detail.getSku());
				
				if(detail.getSpvId() == null){
					PsSpvVO spvVo = mcPsSpvService.findSpvBySkuCode(productVO.getCode(), packageSku.getSkuCode());
					if(spvVo !=null){
						packageSku.setSpvId(spvVo.getSpvId());
					}
					
				} else {
					packageSku.setSpvId(detail.getSpvId());
				}
				
				//coupon使用
				packageSku.setBrandId(detail.getBrandId());
				packageSku.setCategroyId(detail.getCategroyId());

				packageSku.setIsJit(detail.getIsJit());//是否来单制作
				packageSku.setQuantity(detail.getQuantity());//数量
				if(detail.getPointValue() ==null){
					packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
				}else{
					packageSku.setUnitPoint(BigDecimal.valueOf(detail.getPointValue()));//单品积分
				}
				//判断是否包含两种以上配送方式，如果是，则需要强制审单
				if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
					deliveryTypes.put("SELF", true);
				}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
					deliveryTypes.put("FEDX24", true);
				}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
					deliveryTypes.put("SF_AIR", true);
				}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
					deliveryTypes.put("SF_LAND", true);
				}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
					deliveryTypes.put("YTO", true);
				}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
					deliveryTypes.put("DEPPON", true);
				}
				
				packageSku.setExpressType(productVO.getExpressType());
				// 特价
				if(detail.getDiscountPrice()==null){
					detail.setDiscountPrice(0D);
					
				}
				
				packageSku.setUnitDiscount(BigDecimal.ZERO);
				
				PsSkuVO pssSkuVO= mcPsSkuService.findBySkuCode(detail.getSku());

				if(pssSkuVO==null){
					throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
				}
				// 是改价商品
			if (pssSkuVO.getCanCustomizeSalesPrice()!=null && pssSkuVO.getCanCustomizeSalesPrice()!=0) {

				if (detail.getDiscountPrice() > 0) {
					detail.setPrice(detail.getDiscountPrice());
					detail.setDiscountPrice(0D);
					packageSku.setUnitDiscount(BigDecimal.ZERO);
				}

			}
//					if(productVO.getAllowVipDiscount()==1){
//						if(memberVo!=null){
//							//如果是故事订花。折扣为0
//							//if(canChangePrice(detail.getSku())){
//								//packageSku.setUnitDiscount(BigDecimal.ZERO);
//							//}else{
//								packageSku.setUnitDiscount(getUnitDiscount(BigDecimal.valueOf(detail.getPrice()), memberVo.getMemberLevel(),orderCreateVO.getGiftCardAmount(),BigDecimal.valueOf(detail.getDiscountPrice())));//单品折扣
//							//}
//						}else{
//							if(detail.getDiscountPrice()>0){
//								BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//								packageSku.setUnitDiscount(unitDiscount);
//							}else{
//								packageSku.setUnitDiscount(BigDecimal.ZERO);
//							}
//						}
//						
//					}else{
						if(detail.getDiscountPrice()>0){
							BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
							packageSku.setUnitDiscount(unitDiscount);
						}else{
							packageSku.setUnitDiscount(BigDecimal.ZERO);
						}
				//	}
					
				
					
				// 折扣后金额
				packageSku.setUnitAmountAfterDiscount(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()));
				// 特价
				packageSku.setDiscountPrice(BigDecimal.valueOf(detail.getDiscountPrice()));
				
				if(detail.getPointPrice() !=null && detail.getPointPrice()>0){
					packageSku.setUnitPointDeduction(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()).subtract(BigDecimal.valueOf(detail.getPointPrice())));//折扣后的价格减去积分价格
				}else{
					packageSku.setUnitPointDeduction(BigDecimal.ZERO);
				}
				packageSku.setUnitPrice(BigDecimal.valueOf(detail.getPrice()));

				packageSku.setIsGift(0);
				packageSku.setReferenceCode(detail.getReferenceCode());
				
				// 商品分类
				packageSku.setCategoryId(pssSkuVO.getCategoryId());
				opSoPackageSkuVOs.add(packageSku);
		}
		
		// 发票是否随同货物发送，0否1是
		//opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);

		//是否审单,有两种不同的运输方式或者包含自送的。需要审单
//		if(deliveryTypes.size()>1||(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF"))){
//			opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
//		}else{
//			opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
//		}
		
		opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
        if("1".equals(orderCreateVO.getDeliveryType())){
	//设置配送信息的快递方式，当只有一种配送方式时，设置
			if(deliveryTypes!=null&&deliveryTypes.size()==1){
				if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
				}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
				}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
				}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
				}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
				}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
					opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
				}
			}
		 }

		//设置包裹配送信息
		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
		opSoPackageVOs.add(opSoPackage);
		//设置订单关联包裹
		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
		
		if(memberVo!=null){
			// 会员code
			 opSalesOrderVO.setMemberCode(memberVo.getCode());
			 opSalesOrderVO.setMemberId(memberVo.getId());
		}

		// 用户备注
		opSalesOrderVO.setRemark(orderCreateVO.getNote());
		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
		// COUPON编码
		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());
		if(orderCreateVO.getOtherDiscount()!=null){
			//头折扣
			opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
		}else{
			//头折扣
			opSalesOrderVO.setDiscountOnHead(BigDecimal.ZERO);
		}

		// 服务费
		if(orderCreateVO.getServiceFee()!=null){
			// 由于ipos哪边把普通跟精确送费用放在服务费里，这边要减掉
			BigDecimal service = BigDecimal.valueOf(orderCreateVO.getServiceFee()).subtract(opSalesOrderVO.getCarriage()).subtract(opSalesOrderVO.getLimitFee());
			
			opSalesOrderVO.setServiceFeeAmount(service);
		}else{
			opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
		}
		
		//礼品卡
		opSalesOrderVO.setGiftCardDesc(orderCreateVO.getPresentCards());
		//礼品卡金额
		if(orderCreateVO.getGiftCardAmount()!=null){
			opSalesOrderVO.setGiftCardAmount(new BigDecimal(orderCreateVO.getGiftCardAmount()));
		}else{
			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
		}
		//是否匿名
		opSalesOrderVO.setIsAnonymous(orderCreateVO.getAnonymous()?OpSalesOrder.IS_ANONYMOUS_TRUE:OpSalesOrder.IS_ANONYMOUS_FALSE);
		//预售拆包裹
		List<OpSoPackageVO> splitPackages= splitPackage(opSalesOrderVO, opChannel);
		if(CollectionUtils.isNotEmpty(splitPackages)){
			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
		}
		 return opSalesOrderVO;
	 }

	/***
	 * 配送方式  延迟自提、当场自提、快递
	 * @param deliveryTypeStr
	 * @return
	 */
	private Integer getDeliveryType(String deliveryTypeStr){
		if("1".equals(deliveryTypeStr)){
			return OpSoPackage.DELIVERY_TYPE_EXPRESS;//快递
		}
		return OpSoPackage.DELIVERY_TYPE_NOT_EXPRESS;//非快递
	}
	
	/***
	 * 根据用户等级。计算单价折扣
	 * @param unitPrice
	 * @param memberLevel
	 */
//	private BigDecimal getUnitDiscount(BigDecimal unitPrice,Integer memberLevel,Double giftCardAmount,BigDecimal salePrice){
////		if(giftCardAmount!=null&&giftCardAmount>0){
////			return BigDecimal.ZERO;//礼品卡不打折
////		}
////		BigDecimal discountPrice=PriceUtil.getLevelPrice(unitPrice, memberLevel);
////		return unitPrice.subtract(discountPrice);
//
//		BigDecimal unitDiscount=BigDecimal.ZERO;
//		if(giftCardAmount!=null&&giftCardAmount>0){
//
//			if(salePrice.doubleValue()>0){
//
//				// 特价折扣
//				unitDiscount = unitPrice.subtract(salePrice);
//
//				return unitDiscount;
//			}else{
//				  return BigDecimal.ZERO;//礼品卡不打折
//			}
//
//	    }
//		if(salePrice.doubleValue()>0){
//			BigDecimal discountPrice=PriceUtil.getLevelPrice(salePrice, memberLevel);
//			// 特价折扣+会员折扣
//			unitDiscount = unitPrice.subtract(discountPrice);
//
//		}else{
//			BigDecimal discountPrice=PriceUtil.getLevelPrice(unitPrice, memberLevel);
//
//			// 会员折扣
//			unitDiscount=unitPrice.subtract(discountPrice);
//		}
//
//		return unitDiscount;
//	}
	
	/***
	 * 下单前的校验，校验积分、校验价格是否变化,校验库存是否不足
	 * @param orderCreateVO
	 * @param opChannel
	 * @return
	 */
	private void  OrderPreCheck(String channelCode,OrderCreateVO orderCreateVO, OpChannelVO opChannel){
		List<OrderCreateDetailVO>  details=orderCreateVO.getItems();
		for(OrderCreateDetailVO detail:details){

			
			if(opChannel!=null && opChannel.getChannelType()!=null && opChannel.getChannelType()==1){
				// 线下渠道不验证
			}else{
				//判断商品是否可售
				PsProductVO prod=mcPsProductService.findProdByChnCodeSkuCode(channelCode, detail.getSku());
				if(prod==null||CollectionUtils.isEmpty(prod.getChnCanSaleSKu())||!prod.getCanSaleSku(channelCode).contains(detail.getSku())){
					throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),ErrorCode.ITEM_OFFSHELF.getMesage()+": "+detail.getSku());
				}
			}

			PsSkuVO pssSkuVO= mcPsSkuService.findBySkuCode(detail.getSku());
			detail.setIsJit(pssSkuVO.getIsJit());//是否来单制作
			//设置分类id和品牌id coupon使用
			detail.setBrandId(pssSkuVO.getBrandId());
			detail.setCategroyId(pssSkuVO.getCategoryId());

			if(pssSkuVO.getCanCustomizeSalesPrice()==null){
				pssSkuVO.setCanCustomizeSalesPrice(0);
			}
			//检查价格是否发生变化
			if(pssSkuVO.getCanCustomizeSalesPrice()!=1 &&pssSkuVO.getSalesPrice().doubleValue()!=detail.getPrice().doubleValue()){
				throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(), ErrorCode.ITEM_PRICE_CHANGE.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuNameCN()+": "+pssSkuVO.getSalesPrice());
			}
			//JIT商品不校验库存
//			if(detail.getIsJit()==null ||PegasusConstants.NO==detail.getIsJit()){
//				//检查商品库存
//				WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(detail.getSku(), opChannel.getWarehouseForSales());
//				if(whInvVO==null||whInvVO.getCanUseInv()<detail.getQuantity()){
//					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+pssSkuVO.getSkuCode()+ " "+pssSkuVO.getSkuNameCN()+": "+whInvVO.getCanUseInv());
//				}
//			}
			//JIT商品部校验库存  增加预售库存判断
//			if(detail.getIsJit()==null ||PegasusConstants.NO==detail.getIsJit()){
//				//检查商品库存
//				WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(detail.getSku(), opChannel.getWarehouseForSales());
//				Integer quantity=whInvVO.getCanUseInv();
//				//增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
//				OpPresaleSaleInvVO preSaleVO=poInstance.findCanUseQttBySkuCode(detail.getSku(), OpPresaleVO.CHANNEL_TYPE_OFFLINE);
//				quantity=quantity+preSaleVO.getCanUseInv();
//				if(quantity<detail.getQuantity()){
//					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuName()+": "+whInvVO.getSkuCode());
//				}
//			}
//			
		}
	
	}
	
	/***
	 * 判断是否需要拆分包裹，
	 * @param opChannel
	 * @param opSalesOrderVO
	 * @return
	 */
	private List<OpSoPackageVO> splitPackage(OpSalesOrderVO opSalesOrderVO, OpChannelVO opChannel){
		List<OpSoPackageVO> newPackageVOs=null;
		List<OpSoPackageVO> jitPackageVOs=null;
		OpSoPackageVO sourcesPackageVO=null;
		List<OpSoPackageVO> sourcesPackages=null;
		List<OpSoPackageSkuVO>  sourcePackageSkus=null;
		List<OpSoPackageSkuVO> defaultOpSoPackageSkuVOs = new ArrayList<>();
		if(opSalesOrderVO!=null&&CollectionUtils.isNotEmpty(opSalesOrderVO.getOpSoPackageVOs())&&opSalesOrderVO.getOpSoPackageVOs().size()==1){
			newPackageVOs=new ArrayList<OpSoPackageVO>();
			jitPackageVOs = new ArrayList<OpSoPackageVO>();
			sourcesPackages=opSalesOrderVO.getOpSoPackageVOs();
			sourcesPackageVO=sourcesPackages.get(0);
			sourcePackageSkus=sourcesPackageVO.getOpSoPackageSkuVOs();
			if(CollectionUtils.isNotEmpty(sourcePackageSkus)){
				for(OpSoPackageSkuVO  packageSkuVO:sourcePackageSkus){
					//OpPresaleVO presaleVO=poInstance.findAvaliableBySkuCode(packageSkuVO.getSkuCode(),true);
					
					SPresaleVO sPresaleVO = sPresaleService.findAvaliableBySkuCode(packageSkuVO.getSkuCode(),true);
					if(sPresaleVO!=null){
						//有预售。再判断物理库存是否可卖。
						//物理库存不足，则拆包裹，物理库存足够，则不拆包裹
						WhInvVO whInvVO=sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(packageSkuVO.getSkuCode(), opChannel.getWarehouseForSales());
						Integer quantity=whInvVO.getCanUseInv();
						SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(packageSkuVO.getSkuCode(), OpPresaleVO.CHANNEL_TYPE_OFFLINE);
						Integer preSaleQuantity=preSaleInvVO.getCanUseInv();
						if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()<=preSaleQuantity){
							OpSoPackageVO preSalePackage=new OpSoPackageVO();
							OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
							preSalePackage.setCardContent(sourcesPackageVO.getCardContent());
							preSalePackage.setCardType(sourcesPackageVO.getCardType());
							preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
							preSalePackage.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());
							preSalePackage.setPlanedDeliveryDate(sPresaleVO.getPlanedDeliveryDate());
							preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
							
							BeanUtils.copyProperties(sourcesPackageVO.getOpSoPackageDeliveryInfoVO(), opSoPackageDeliveryInfoVO);
							
							opSoPackageDeliveryInfoVO.setExpressType(packageSkuVO.getExpressType());
//							preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
							preSalePackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
							List<OpSoPackageSkuVO>  preSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();
							packageSkuVO.setPresaleId(sPresaleVO.getId());
							packageSkuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
							preSalePackageSkus.add(packageSkuVO);
							preSalePackage.setOpSoPackageSkuVOs(preSalePackageSkus);
							preSalePackage.setPackageType(OpSoPackage.PACKAGE_TYPE_2);
							newPackageVOs.add(preSalePackage);
						} else if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()>preSaleQuantity){
							throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+packageSkuVO.getSkuCode()+": "+whInvVO.getSkuCode());
						} else {
							defaultOpSoPackageSkuVOs.add(packageSkuVO);
						}
						// 当商品为
					}else if(packageSkuVO.getIsJit()!=null && packageSkuVO.getIsJit()==1 && !isJitNotCateId_pos.contains(packageSkuVO.getCategoryId())){
							//&& !ConstUtil.notSkuCodes.contains(packageSkuVO.getSkuCode())){
						
						logger.info(packageSkuVO.getSkuCode()+"是来单制作商品！categoryId:"+packageSkuVO.getCategoryId());
						
						
						OpSoPackageVO jitSalePackage=new OpSoPackageVO();
						OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();
						jitSalePackage.setCardContent(sourcesPackageVO.getCardContent());
						jitSalePackage.setCardType(sourcesPackageVO.getCardType());
						jitSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
						jitSalePackage.setDispatchWarehouseCode(sourcesPackageVO.getDispatchWarehouseCode());
						jitSalePackage.setPlanedDeliveryDate(sourcesPackageVO.getPlanedDeliveryDate());
						jitSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
						
						BeanUtils.copyProperties(sourcesPackageVO.getOpSoPackageDeliveryInfoVO(), opSoPackageDeliveryInfoVO);
						
						opSoPackageDeliveryInfoVO.setExpressType(packageSkuVO.getExpressType());
//						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
						jitSalePackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
						List<OpSoPackageSkuVO>  preSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();

						preSalePackageSkus.add(packageSkuVO);
						jitSalePackage.setOpSoPackageSkuVOs(preSalePackageSkus);
						
						
						jitSalePackage.setPackageType(OpSoPackage.PACKAGE_TYPE_6);
						
						jitPackageVOs.add(jitSalePackage);
					}else{
						
						logger.info(packageSkuVO.getSkuCode()+"是普通商品！categoryId:"+packageSkuVO.getCategoryId());
						defaultOpSoPackageSkuVOs.add(packageSkuVO);
						
						
						
						
					}
				}
			}
		}else{
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		
		
		sourcesPackageVO.setOpSoPackageSkuVOs(defaultOpSoPackageSkuVOs);
		sourcesPackageVO.setPackageType(OpSoPackage.PACKAGE_TYPE_0);
		if(CollectionUtils.isNotEmpty(newPackageVOs)){
//			for(OpSoPackageVO preSalePackage:newPackageVOs){
//				List<OpSoPackageSkuVO>  preSalePackageSkus= preSalePackage.getOpSoPackageSkuVOs();
//				if(CollectionUtils.isNotEmpty(preSalePackageSkus)){
//					sourcePackageSkus.removeAll(preSalePackageSkus);
//				}
//			}
			sourcesPackages.addAll(newPackageVOs);
		}
		//删掉分包裹之后的空包裹
		List<OpSoPackageVO> tmpPackages=new ArrayList<OpSoPackageVO>();
		for(OpSoPackageVO tmppackage: sourcesPackages){
			if(tmppackage==null||CollectionUtils.isEmpty(tmppackage.getOpSoPackageSkuVOs())){
				tmpPackages.add(tmppackage);
			}
		}
		if(CollectionUtils.isNotEmpty(tmpPackages)){
			sourcesPackages.removeAll(tmpPackages);
		}
		
		// 当来单制作集合不为空放入主包裹里
		if(CollectionUtils.isNotEmpty(jitPackageVOs)){
			sourcesPackages.addAll(jitPackageVOs);
		}
		//当包裹数量大于2时，分别判断每个包裹内的快递
//		if(CollectionUtils.isNotEmpty(sourcesPackages)&&sourcesPackages.size()>1){
//			for(OpSoPackageVO tmpPackage:sourcesPackages){
//				Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
//				List<OpSoPackageSkuVO>  packageSkus=tmpPackage.getOpSoPackageSkuVOs();
//				OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=tmpPackage.getOpSoPackageDeliveryInfoVO();
//				if(CollectionUtils.isNotEmpty(packageSkus)){
//					for(OpSoPackageSkuVO tmpSku:packageSkus){
//						PsProductVO productVO=pbInstance.findProdByChnCodeSkuCode(opChannel.getCode(),tmpSku.getSkuCode());
//						if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
//							deliveryTypes.put("SELF", true);
//						}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
//							deliveryTypes.put("FEDX24", true);
//						}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
//							deliveryTypes.put("SF_AIR", true);
//						}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
//							deliveryTypes.put("SF_LAND", true);
//						}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
//							deliveryTypes.put("YTO", true);
//						}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
//							deliveryTypes.put("DEPPON", true);
//						}
//						
//					}
//				}
//				//设置配送信息的快递方式，当只有一种配送方式时，设置
//				if(deliveryTypes!=null&&deliveryTypes.size()==1){
//					if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
//					}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
//					}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//					}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
//					}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
//					}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
//					}
//				}
//			}
//		}
		return sourcesPackages;
	}

	
	/***
	 * 判断是否可以自定义价格。故事订花 10010001 10131813
	 * @param sku
	 * @return
	 */
//	public boolean canChangePrice(String sku){
//		List<String> skuIds=new ArrayList<String>();
//		skuIds.add("10010001");
//		skuIds.add("10131813");
//		skuIds.add("101161021");
//		skuIds.add("S00300000014218");
//		skuIds.add("101161064");
//		skuIds.add("102162194");
//		skuIds.add("101161241");
//		skuIds.add("10332036");
//		skuIds.add("107170032");
//		return skuIds.contains(sku);
//	}
	
	/**
	 * 取得打印内容
	 * @return
	 */
	public List<OrderDetailVO> setIposPrintTasks(String status,String code){
		
		List<OrderDetailVO> pointTasks = new ArrayList<OrderDetailVO>();
		OrderDetailVO orderDetailVO = null;
		/**
		* 商品列表
		*/
		List<OrderSkuVO> orderSkus=null;
		
		// 取得当前渠道的打印任务
		List<IposPrintTask> tasks = instance.getIposPrintTasks(status,code);
		
		if(CollectionUtils.isNotEmpty(tasks)){
			
			for(IposPrintTask task:tasks){
				orderDetailVO =  new OrderDetailVO();
			
				orderSkus=new ArrayList<OrderSkuVO>();
				// type:1订单，type:2 退货单
				if(task.getType()==1){
					OpSalesOrder order = instance.getOrderById(task.getOutId());
					orderDetailVO.setOrderCode(order.getCode());
					orderDetailVO.setOrderDate(DateUtil.format(order.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
					orderDetailVO.setPayAmount(order.getNeedToPayAmount().doubleValue());
					
					 List<OpSoPackageSku> skus = instance.getSkusByOrderId(order.getId());
					 if(CollectionUtils.isNotEmpty(skus)){
						 OrderSkuVO skuVO= null;
						 for(OpSoPackageSku sku: skus){
							 PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(sku.getSkuCode());
							 skuVO = new OrderSkuVO();
							 skuVO.setUnitPrice(sku.getUnitPrice().doubleValue());
							 skuVO.setSkuTitle(psSkuVO.getSkuNameCN());
							 skuVO.setQuantity(sku.getQuantity());
							 orderSkus.add(skuVO);
						 }
						 
					 }
					
				}else{
					OpReturnRequest opReturnRequest = instance.getReturnOrder(task.getOutId());
					
					orderDetailVO.setOrderCode(opReturnRequest.getCode());
					orderDetailVO.setOrderDate(DateUtil.format(opReturnRequest.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
					orderDetailVO.setPayAmount(0-opReturnRequest.getRefundAmount().doubleValue());
					
					List<OpReturnRequestSku>  skus = instance.getReturnOrderSkus(opReturnRequest.getId());
					if(CollectionUtils.isNotEmpty(skus)){
						 OrderSkuVO skuVO= null;
						 for(OpReturnRequestSku sku: skus){
							 PsSkuVO psSkuVO = mcPsSkuService.findBySkuCode(sku.getSkuCode());
							 skuVO = new OrderSkuVO();
							 skuVO.setUnitPrice(0-sku.getTotalRefundAmount().doubleValue());
							 skuVO.setSkuTitle(psSkuVO.getSkuNameCN());
							 skuVO.setQuantity(sku.getNeedToReturnQuantity());
							 orderSkus.add(skuVO);
						 }
						 
					 }
				}
				
				orderDetailVO.setOrderSkus(orderSkus);
				orderDetailVO.setType(task.getType());
				orderDetailVO.setPrintTaskId(task.getId());
				pointTasks.add(orderDetailVO);
			}
		
		}
		
		
		return pointTasks;
	}
	
	public int updateIposPrintStatus(Long id,Integer status){
		return instance.updateIposPrintStatus(id,status);
	}

}
