package com.thebeastshop.pegasus.channelservice.adapter.ipos;

import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.enums.LoginTypeEnum;
import com.thebeastshop.member.enums.TitleEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserProfileVO;
import com.thebeastshop.pegasus.channelservice.vo.website.user.UserQueryVO;

/***
 * 用户相关adapter
 * @author fs
 *
 */
@Service("iposMemberAdapter")
public class MemberAdapter {

	@Autowired
	private CommAddressService commAddressService;

	/***
	 * 通用用户转换成官网接口
	 * @param opMemberVO
	 * @return
	 */
	public UserQueryVO common2ipos(MemberVO opMemberVO, Integer loginType){
		UserQueryVO userVO=new UserQueryVO();
		userVO.setAvatar(opMemberVO.getAvatarUrl());
		userVO.setCust_level(getCustLevel(opMemberVO.getMemberLevel()));
		userVO.setEmail(opMemberVO.getEmail());
		userVO.setIdentity_type(getIdentityType(loginType));
		userVO.setMagento_phone(opMemberVO.getPhone());
		userVO.setMobile(opMemberVO.getMobile());
		userVO.setPartner_id(opMemberVO.getId());
		userVO.setProfession(opMemberVO.getJob());
		userVO.setWeibo(opMemberVO.getAccountWeibo());
		userVO.setWeixin(opMemberVO.getAccountWechat());
		UserProfileVO profile=new UserProfileVO();
		if(opMemberVO.getDistrictId()!=null&&opMemberVO.getDistrictId()>0){
			CommDistrictVO commonDistrict=commAddressService.findDistrictById(opMemberVO.getDistrictId().intValue());
			if(commonDistrict!=null){
				//FULL_NAME 全名，国家-省-市-区
			  String fullName=	commonDistrict.getFullName();
			  if(StringUtils.isNotBlank(fullName)){
				String []names=  fullName.split("-");
				if(names!=null&&names.length==4){
					profile.setProvince(names[1]);
					profile.setCity(names[2]);
					profile.setDistrict(names[3]);
				}
			  }
			}
		}
		profile.setName(opMemberVO.getNickName());
		profile.setStreet(opMemberVO.getAddress());
		if(opMemberVO.getTitle()==null){
			profile.setTitle(TitleEnum.UNKNOWN.getName());
		}else{
			profile.setTitle(TitleEnum.getEnumByCode(opMemberVO.getTitle()).getName());
		}
		profile.setZip(opMemberVO.getZipCode());
		userVO.setProfile(profile);
		return userVO;
	}
	
	/**
	 * 获取用户等级名称
	 * @param memberLevel
	 * @return
	 */
	private String getCustLevel(Integer memberLevel){
		if(memberLevel==MemberLevelEnum.VIP.getCode()){
			return "ip";
		}
		if(memberLevel==MemberLevelEnum.VIP2.getCode()){
			return "vip";
		}
		if(memberLevel==MemberLevelEnum.VIP3.getCode()){
			return "vvip";
		}
		if(memberLevel==MemberLevelEnum.VIP4.getCode()){
			return "3vip";
		}
		return "";
	}
	
	/***
	 * 获取用户类型
	 * @param loginType
	 * @return
	 */
	private String getIdentityType(Integer loginType){
		if(LoginTypeEnum.EMAIL.getCode()==loginType){
			return "mail";
		}
		
		if(LoginTypeEnum.MOBILE.getCode()==loginType){
			return "mobile";
		}
		if(LoginTypeEnum.WEIBO.getCode()==loginType){
			return "weibo";
		}
		
		if(LoginTypeEnum.WEIXIN.getCode()==loginType){
			return "weixin";
		}
		
		return "";
	}

}
