package com.thebeastshop.pegasus.channelservice.adapter.ipos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartCommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.cart.IposPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.order.OrderCommonAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.IposPriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.IposSpvAdapter;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.privilege.vo.InterestFreeVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.announcement.AnnouncementVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;
import com.thebeastshop.support.vo.cart.GroupsVO;
import com.thebeastshop.support.vo.member.MemberAddressVO;
import com.thebeastshop.support.vo.member.MemberAddressVO.DistrictVO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderDetailVO.PriceStepVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;

/**
 * ipos 处理器
 * @Class Name IposAdapter
 * @Author Xiang.Gao
 * @Create In 2018-12-21
 */
@Component
public class IposAdapter {
	
	private Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private LogisticsAdapter logisticsAdapter;
	
	@Autowired
	private PrsPriceService prsPriceService;
	
	@Autowired
	private IposPackAdapter iposPackAdapter;
	
	@Autowired
	private ForecastAdapter forecastAdapter;
	
	@Autowired
	private MemberAddressService memberAddressService;
	
	@Autowired
	private MemberAddressAdapter memberAddressAdapter;
	
	@Autowired
	private IposPriceAdapter iposPriceAdapter;
	
	@Autowired
	private IposSpvAdapter iposSpvAdapter;
	
	@Autowired
	private OrderCommonAdapter orderCommonAdapter;
	
	@Autowired
	private CartCommonAdapter cartCommonAdapter;
	
	/**
	 * 购物车预览
	 * 
	 * @Methods Name previewCart
	 * @Create In 2018-12-26 By Xiang.Gao
	 * @return CartVO
	 */
	public CartVO cartPreview(List<CartProductPack> packs, MemberVO member, OpChannelVO channel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(packs)) {
			throw new WrongArgException("商品包不能为空");
		}
		// 商品包是否海淘：取非加价购商品信息作为选中标准
		Boolean hasOverSea = iposPackAdapter.hasOverSea(packs);
		cartCommonAdapter.checkPacks(packs, hasOverSea);
		
		/** 价格计算 */
		PrsPacksPriceResultVO priceResult = iposPriceAdapter.calculatePrsCart(packs, member, channel, accessWay);
		iposPriceAdapter.assemblePackWithPrice(packs, priceResult.getSpvPriceMap());
		List<PrsPriceStepVO> priceSteps = priceResult.getPriceStepVOs();
		
		/** 取活动 商品 库存 信息 */
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = iposPriceAdapter.getCampaignMap(priceSteps);// 活动信息
		Map<String, PsProductVO> addProdMap = iposPriceAdapter.getAdditionalProductMap(priceSteps); 			// 商品详情
		Map<Long, PsSpvVO> spvStock = iposSpvAdapter.getSpvStockMap(addProdMap.values(), channel.getCode()); 	// spv库存
		Map<String, PrsCampaignVO> prodCamp = iposPriceAdapter.getProdCampMap(priceSteps);						// 商品活动

		/** 整理单品赠品、多品赠品、加价购包 */
		Map<Long, List<PrsAdditionalPackVO>> singleGift = new HashMap<Long, List<PrsAdditionalPackVO>>(); 	// 单品赠品map
		Map<Long, List<PrsAdditionalPackVO>> mutiGift = new HashMap<Long, List<PrsAdditionalPackVO>>();		// 多品赠品map
		List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();							// 换购包
		iposPackAdapter.getGiftMapAndAdditionList(campaignMap, singleGift, mutiGift, addList);
		
		/** 封装 整理单品赠品、多品赠品、加价购包、可换赠品包 */
		// 主品包
		List<CartProductPackVO> rawPackVO = iposPackAdapter.getCartRawPack(packs, priceResult, member, spvStock, addProdMap, singleGift);										
		// 是否包含仓库发货	
		boolean containtWh = iposPackAdapter.containWhDeliveryCart(rawPackVO); 
		// 换购包
		Map<Long, CartProductPack> clientAddPack = iposPackAdapter.getClientAddiblePack(packs); 	
		List<CartProductPackVO> addiblePackVO = iposPackAdapter.getAddPacks(clientAddPack, addList, addProdMap, prodCamp, spvStock, containtWh); 			
		// 满赠包
		List<PrsAdditionalPackVO> mutilGiftList = iposPackAdapter.getMutilGiftList(mutiGift);
		List<CartProductPackVO> giftPacks = iposPackAdapter.getCartGiftPacks(mutilGiftList, addProdMap, prodCamp, spvStock, containtWh);
		// 可换赠品池
		List<CartProductPackVO> giftPacksPool = iposPackAdapter.getGiftPacksPool(prodCamp, containtWh, singleGift, mutiGift, addProdMap, spvStock);	
		
		/** 活动 预售运费 标签 */
		forecastAdapter.setCartPackVOsForecast(rawPackVO, MemberLevelEnum.getEnumByCode(member.getMemberLevel()));
		List<Label> cartLabels = iposPackAdapter.getPackMutilLabels(priceResult.getCartSettleLabelList());
		cartLabels.addAll(iposPriceAdapter.getPostageLabel(priceResult.getFinalTotalPrice(), hasOverSea, accessWay));
		
		/** 构建返回对象 */
		CartVO cart = buildingCarVO(rawPackVO, addiblePackVO, giftPacks, giftPacksPool, priceResult, cartLabels);
		logger.info("cart preview :{}", JSON.toJSONString(cart));
		return cart;
	}
	
	/**
	 * 订单预览
	 * @Methods Name orderPreview
	 * @Create In 2018-12-28 By Xiang.Gao
	 * @return OrderConfirmVO
	 */
	public OrderConfirmVO orderPreview(OrderPreviewDTO orderPreview, List<CartProductPack> packs,
			MemberVO member, OpChannelVO channel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(packs)) {
			throw new WrongArgException("商品包不能为空");
		}
		
		/** 配送地址、优惠券、免邮权益 */
		logisticsAdapter.checktDeliverable(packs, orderPreview.getAddressId(), channel);
		MemberAddressVO address = getReceiveAddress(member, orderPreview.getAddressId());
		CpCouponVO coupon = iposPriceAdapter.getCoupon(orderPreview.getCouponId(), member.getId(), channel.getCode());
		InterestFreeVO interestFree = iposPriceAdapter.getInterestFree(packs, member.getId(), accessWay, channel);
		
		/** 价格计算 */
		PrsCalPackDto prsCalPack = iposPriceAdapter.getPrsCalPackDtoWithOrder(packs, member, channel, accessWay, coupon, interestFree, orderPreview);
		PrsPacksPriceResultVO priceResult = prsPriceService.calculatePrs4PreviewOrder(prsCalPack);
		logger.info("priceResult :{}", JSON.toJSONString(priceResult));
		iposPriceAdapter.assemblePackWithPrice(packs, priceResult.getSpvPriceMap());
		
		/** 活动商品*/
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> additionalMap = iposPriceAdapter.getCampaignMap(priceResult.getPriceStepVOs());
		Map<String, PsProductVO> addProdMap = iposPriceAdapter.getAdditionalProductMap(priceResult.getPriceStepVOs());
		// 活动信息
		Map<String, PrsCampaignVO> campaignMap = iposPriceAdapter.getProdCampMap(priceResult.getPriceStepVOs());
		
		/** 库存限量*/
		List<PrsAdditionalPackVO> addtionPackList = iposPriceAdapter.getAddtionPackList(additionalMap);
		Map<String, Integer> checkCspLimitMap = iposPriceAdapter.getCspLimitMap(addtionPackList, campaignMap, addProdMap);
		// 是否包含仓库发货
		boolean containtWh = iposPackAdapter.containWhDeliveryOrder(packs);	
		// 额外spv库存
		Map<Long, PsSpvVO> spvStockMap = iposSpvAdapter.getSpvStockMap(addProdMap.values(), channel.getCode()); 
		// 过滤库存不足,活动限量 
		Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = iposPriceAdapter.exceptLimit(
				containtWh, additionalMap, checkCspLimitMap, spvStockMap, addProdMap);	
		
		/** 商品包处理  */
		Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = Maps.newHashMap();	// 单品赠品
		Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = Maps.newHashMap();	// 多品赠品
		List<PrsAdditionalPackVO> addList = Lists.newArrayList();				// 换购包
		iposPackAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);
		iposPackAdapter.clickPackMatching(packs, singleGiftMap, mutiGiftMap, addList);	// 选购包校验
		// 最终商品包	
		List<CartProductPackVO> prodPackVO = iposPackAdapter.getPackVOWithOrder(priceResult, packs, member, channel, accessWay);												
		
		/** 附加属性 */
		boolean isOversea = iposPackAdapter.isOversea(packs);	
		// 标签
		List<Label> labels = iposPriceAdapter.getOrderPreviewLabel(priceResult.getCartSettleLabelList());			
		//价格步骤
		Collection<PriceStepVO> priceSteps = iposPriceAdapter.getPriceSteps(priceResult, coupon, interestFree);
		// 订单类型
		OrderBusinessType orderType = iposPackAdapter.furnitureSku(packs) ? OrderBusinessType.FURNITURE : orderPreview.getOrderType(); 
		
		/** 构建确认订单对象 */
		OrderConfirmVO rt = new OrderConfirmVO();
		rt.setAddress(address);
		rt.setPacks(prodPackVO);
		rt.setHasOverseaProducts(isOversea);
		rt.setPayMethods(getPayMethods(isOversea));
		rt.setLabels(labels);
		rt.setPrice(priceResult.getFinalTotalPrice());
		rt.setPriceSteps(priceSteps);
		rt.setCustomizable(iposPackAdapter.containtCustomize(packs));
		rt.setBday(iposPackAdapter.getBday(member, packs));
		rt.setOrderType(orderType);
		rt.setCanRemark(orderCommonAdapter.getCanRemark(packs));
		rt.setGiftCards(orderPreview.getGiftCards());
		logger.info("order preview :{}", JSON.toJSONString(rt));
		return rt;
	}
	
	/**
	 * 构建购物车 前端对象
	 * @Methods Name buildingCarVO
	 * @Create In 2018-12-28 By Xiang.Gao
	 */
	private CartVO buildingCarVO(List<CartProductPackVO> rawPackVO, List<CartProductPackVO> addiblePackVO, 
			List<CartProductPackVO> giftPacks, List<CartProductPackVO> giftPacksPool, 
			PrsPacksPriceResultVO priceResult, List<Label> labels) {
		CartVO rt = new CartVO();
		rt.setPacks(rawPackVO);
		rt.setAddiblePacks(addiblePackVO);
//		rt.setGiftPacks(giftPacks);
//		rt.setGiftPacksPool(giftPacksPool);
		rt.setLabels(labels);
		rt.setPrice(priceResult.getFinalTotalPrice());
		rt.setSavedPrice(priceResult.getOriginalTotalPrice().subtract(priceResult.getFinalTotalPrice()));
		rt.setAnnouncements(new ArrayList<AnnouncementVO>());
		rt.setGroups(new ArrayList<GroupsVO>());
		rt.setInterestPacks(new ArrayList<CartProductPackVO>());
		rt.setInvalidPacks(new ArrayList<CartProductPackVO>());
		return rt;
	}
	
	/**
	 * 获取支付方式
	 * @Methods Name getPayMethods
	 * @Create In 2018-12-29 By Xiang.Gao
	 */
	private List<PaymentType> getPayMethods(boolean isOverSea) {
		List<PaymentType> payMethods = Lists.newArrayList();
		if (isOverSea) {
			payMethods.add(PaymentType.ALIPAY);
		} else {
			payMethods.add(PaymentType.ALIPAY);
			payMethods.add(PaymentType.WEIXIN);
		}
		return payMethods;
	}
	
	/**
	 * 获取收货地址
	 * @Methods Name getReceiveAddress
	 * @Create In 2018-12-29 By Xiang.Gao
	 */
	private MemberAddressVO getReceiveAddress(MemberVO member, Long addressId) {
		com.thebeastshop.member.vo.MemberAddressVO address = null;
		// 默认收货地址
		if (addressId == null || addressId == 0) {
			address = memberAddressService.getDefaultByOwnerId(member.getId());// 不传时使用默认地址
			return memberAddressAdapter.getMemberAddress(address, member);
		} 
		address = memberAddressService.getById(addressId);
		if (address == null) {
			throw new WrongArgException("地址不可用！");
		}
		
		DistrictVO district = new DistrictVO();
		district.setFullName(address.getDistrict().getFullName());
		district.setId(address.getDistrict().getId());
		district.setName(address.getDistrict().getName());
		
		MemberAddressVO deliveryAddress = new MemberAddressVO();
		deliveryAddress.setId(address.getId());
		deliveryAddress.setAsDefault(address.getAsDefault());
		deliveryAddress.setDistrict(district);
		deliveryAddress.setLocation(address.getAddress());
		deliveryAddress.setReceiverName(address.getReceiver());
		deliveryAddress.setReceiverPhone(address.getReceiverPhone());
		deliveryAddress.setZipCode(address.getZipCode());
		return deliveryAddress;
	}
	
	
	
}
