package com.thebeastshop.pegasus.channelservice.adapter.flowermonth;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.enums.ChannelCodeEnum;

import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.Customize.FlowerCustomizeType;
import com.thebeastshop.support.enums.flowerMonth.SelectType;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.flowerMonth.TiedChoiceVO;
import com.thebeastshop.support.vo.flowerMonth.TiedDimensionVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * 月送捆绑商品
 * @author GFL
 * @Date 2018/2/1 10:45.
 */
@Service
public class FlowerMonthTiedAdapter {

    private Logger logger = LoggerFactory.getLogger(FlowerMonthTiedAdapter.class);

    @Autowired
    private McPsProductService mcPsProductService;

    @Autowired
    private McPsSpvService mcPsSpvService;

    private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();


    /**
     * 获取月送捆绑元素
     * @param product
     * @param member
     * @param accessWay
     * @param channel
     * @return
     */
    public List<TiedDimensionVO> getTiedDimension(PsProductVO product ,MemberVO member ,AccessWayEnum accessWay, OpChannelVO channel){
        List<TiedDimensionVO> result = Lists.newArrayList();
        // 添加月送首单赠品
        TiedDimensionVO giftDimen = getGiftDimension(member,accessWay,channel);
        if(null != giftDimen){
            result.add(giftDimen);
        }
        // TODO 换购暂不实现
        //getFlowerAddible(product);

        return result;
    }


    /**
     * 校验是否周送鲜花赠品
     * @param spvId
     * @return
     */
    public Boolean checkFlowerFirstGift(Long spvId){
        List<PsSpvVO> spvs = getFlowerFirstGift(AccessWayEnum.APP.getCode(), ChannelCodeEnum.CHN2049.getChannelCode());
        if(CollectionUtils.isNotEmpty(spvs)){
            for(PsSpvVO psSpvVO :spvs){
                if(psSpvVO.getSpvId().equals(spvId)){
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 校验是否周送鲜花赠品
     * @param spvIds
     * @return
     */
    public Boolean checkFlowerFirstGift(List<Long> spvIds){
        List<PsSpvVO> spvs = getFlowerFirstGift(AccessWayEnum.APP.getCode(), ChannelCodeEnum.CHN2049.getChannelCode());
        if(CollectionUtils.isNotEmpty(spvs)){
            List<Long> spvids = Lists.newArrayList();
            for(PsSpvVO psSpvVO :spvs){
                spvids.add(psSpvVO.getSpvId());
            }
            for(Long spvId : spvids){
                if(!spvids.contains(spvId)){
                    return false;
                }
            }
            return true;
        }
        return false;
    }



    /**
     * 获取换购商品信息
     *
     * @param campaignId
     * @param accessWay
     * @param member
     * @return
     */
    private CartProductPack getBarterBuy(Long campaignId, List<PsCampaignVO> campaignVOs, AccessWayEnum accessWay,
                                         MemberVO member) {
        CartProductPack pack = new CartProductPack();
        Long productId = null;
        BigDecimal salesPrice = null;
        for (PsCampaignVO campaignVO : campaignVOs) {
            if (campaignVO.getId().equals(campaignId)) {
                productId = campaignVO.getCampaignSectionList().get(0).getCampaignSectionProducts().get(0)
                        .getProductId();
                salesPrice = campaignVO.getCampaignSectionList().get(0).getCampaignSectionProducts().get(0)
                        .getPricePrice();
            }
        }

        PsProductCond cond1 = new PsProductCond();
        cond1.setId(productId.toString());
        cond1.setAccessWay(accessWay.getCode());
        cond1.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
        cond1.setMatchCampaign(true);
        PsProductVO product = mcPsProductService.findByCond(cond1, true).get(0);
        PsSpvVO spv = product.getSpvList().get(0);
        pack.setSpvId(spv.getSpvId());
        pack.setSpv(spv);
        pack.setProductId(spv.getProductId());
        pack.setProduct(product);
        pack.setOwnerId(member.getId());
        pack.setSource(CartPackSourceEnum.ADDIBLE);
        pack.setCount(1);
        // 设置换购价格
        pack.setFactProductPrice(salesPrice);
        pack.setValid(true);
        return pack;
    }



    /**
     * 获取首单赠品
     * 赠品库存从线上渠道获取
     * @return
     */
    private TiedDimensionVO getGiftDimension(MemberVO member ,AccessWayEnum accessWay, OpChannelVO channel){
        boolean hasGetGift = pcInstance.memberHasGetGifts(member.getId());
        if(hasGetGift){
//            dimension.setNote("赠品已领取");
            return null;
        }
        TiedDimensionVO dimension = new TiedDimensionVO();
        dimension.setSelectType(SelectType.SINGLE);
        dimension.setName(FlowerCustomizeType.FIRST_GIFT.getDesc());
        dimension.setSeq(FlowerCustomizeType.FIRST_GIFT.getCode().intValue());
        dimension.setSource(CartPackSource.GIFT);
        List<PsSpvVO> spvs = getFlowerFirstGift(AccessWayEnum.APP.getCode(), ChannelCodeEnum.CHN2049.getChannelCode());
        if(CollectionUtils.isEmpty(spvs)){
            return null;
        }else{
            dimension.setNote("已赠完");
            List<TiedChoiceVO> choices = new ArrayList<>();
            for(PsSpvVO psSpvVO : spvs){
                TiedChoiceVO choice = new TiedChoiceVO(psSpvVO.getSkuVO().getSkuNameCN(), BigDecimal.ZERO,psSpvVO.getSpvId().toString(), NumberUtil.isNullOrZero(psSpvVO.getCanUseQuantity()));
                if(hasGetGift){
                    choice.setSoldOut(Boolean.TRUE);
                }
                if(!choice.getSoldOut()){
                    dimension.setNote("");
                }
                choices.add(choice);
            }
            dimension.setChoices(choices);
        }
        return dimension;
    }


    /**
     * 获取月送鲜花赠品 赠品默认取线上APP渠道
     * @param accessWayId
     * @param channelCode
     * @return
     */
    private List<PsSpvVO> getFlowerFirstGift(Integer accessWayId, String channelCode){
        List<PsSpvVO> result = Lists.newArrayList();
        MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
        List<String> productCodes = pcInstance.getWeekFlowerGiftsProd();
        List<Long> spvIds = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(productCodes)){
            logger.info("赠品productCode集合：{}", JsonUtil.toJson(productCodes));
            PsProductCond cond = new PsProductCond();
            cond.setCodes(productCodes);
            cond.setChannelCode(channelCode);
            cond.setAccessWay(accessWayId);
            cond.setMemberLevel(memberLevel.getCode());
            cond.setMatchCampaign(true);
            cond.setDiscount(memberLevel.getLevelAmountCondition());
            cond.setPagenum(Integer.MAX_VALUE);
            cond.setBdDiscount(BigDecimal.ONE);
            List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
            if(CollectionUtils.isNotEmpty(products)){
                for (PsProductVO psProductVO : products) {
                    if(CollectionUtils.isNotEmpty(psProductVO.getSpvList())){
                        for(PsSpvVO spv : psProductVO.getSpvList()) {
                            spvIds.add(spv.getSpvId());
                        }
                    }
                }
            }
        }
        if(CollectionUtils.isNotEmpty(spvIds)){
            PsMatchCampaignCond spvCond = new PsMatchCampaignCond();
            spvCond.setAccessWay(accessWayId);
            spvCond.setMemberLevel(memberLevel.getCode());
            spvCond.setMatchCampaign(true);
            spvCond.setDiscount(memberLevel.getLevelAmountCondition());
            spvCond.setPagenum(Integer.MAX_VALUE);
            spvCond.setBdDiscount(BigDecimal.ONE);
            result = mcPsSpvService.findBySpvIdsWithStock(spvIds, spvCond, channelCode);

        }
        return result;
    }



    /**
     * 获取商品的换购商品
     * @return
     */
    private TiedDimensionVO getFlowerAddible(PsProductVO psProductVO){
        TiedDimensionVO dimension = new TiedDimensionVO();
        dimension.setSelectType(SelectType.MULTI);
        dimension.setName(FlowerCustomizeType.BARTER_BUY.getDesc());
        dimension.setSeq(FlowerCustomizeType.BARTER_BUY.getCode().intValue());
        dimension.setSource(CartPackSource.ADDIBLE);

        List<PsCampaignVO> campaignVOs = psProductVO.getCampaignList();
        //取出换购信息
        if(CollectionUtils.isNotEmpty(campaignVOs)){
            List<TiedChoiceVO> choices = Lists.newArrayList(new TiedChoiceVO("不换购",BigDecimal.ZERO,"",Boolean.TRUE));
            for(PsCampaignVO campaign :campaignVOs){
                if(DiscountType.CHEAPEN_OTHER.getId().equals(campaign.getDiscountTypeId())){
                    // TODO 根据活动获取可换购商品品
                }
            }
            dimension.setChoices(choices);
        }
        return dimension;
    }
}
