package com.thebeastshop.pegasus.channelservice.adapter.flowermonth;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SFlowerMonthlyService;
import com.thebeastshop.support.vo.stock.StoreStockVO;


/**
 * 月送鲜花 区域库存查询
 * @Class Name FlowerMonthStockAdapter
 * @Author Xiang.Gao
 * @Create In 2018-3-1
 */
@Service
public class FlowerMonthStockAdapter {

	private final static String WAREHOUSE_NAME = "可售数量";
	
	private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
	
	@Autowired
    private McPsSpvService mcPsSpvService;
	
	@Autowired
	private McPsProductService msPsProductService;
	
	@Autowired
	private McOpChannelService mcOpChannelService;
	
	@Autowired
	private SFlowerMonthlyService flowerMonthlyService;
	
	/**
	 * 查询区域可售库存
	 * @Methods Name canSaleQuantity
	 * @Create In 2018-3-1 By Xiang.Gao
	 * @param spvId
	 * @param channelCode
	 * @return List<StoreStockVO>
	 */
	public List<StoreStockVO> canSaleQuantity(Long spvId, String channelCode) {
		List<StoreStockVO> stockList = Lists.newArrayList();
		PsSpvVO spvVO = mcPsSpvService.findBySpvId(spvId);
		if (spvVO == null || spvVO.getProductId() == null) {
			return stockList;
		}
		PsProductVO psProduct = msPsProductService.findByProdId(spvVO.getProductId());
		if (psProduct == null) {
			return stockList;
		}
		
		Integer cityId = null;
		SFlowerProductionTypeEnum type = SFlowerProductionTypeEnum.WAREHOUSE;
		if (SFlowerProductionTypeEnum.STORE.getValue().equals(psProduct.getFlowerMonProductionType().byteValue())) {
			type = SFlowerProductionTypeEnum.STORE;
			// 查询当前渠道所在区域
			cityId = mcOpChannelService.findChannelCityIdByCode(channelCode);
		}
		
		// 查询区域库存
		List<SFlowerMonthlyCityDTO> flowerMonthlyCityList = pcInstance.getIposFlowerMonSkuInfoBySkuCode(spvVO.getSkuCode(), type);
		for (SFlowerMonthlyCityDTO dto : flowerMonthlyCityList) {
			if (dto.getCanUseQuantity() == null || dto.getCanUseQuantity() < 1) {
				continue;
			}
			StoreStockVO stockVO = null;
			// 门店制作
			if (SFlowerProductionTypeEnum.STORE.equals(type)) {
				stockVO = new StoreStockVO(dto.getCityId()+"", dto.getCityName(), dto.getCanUseQuantity());
				if (dto.getCityId().equals(cityId)) {
					stockList.add(0, stockVO);
				} else {
					stockList.add(stockVO);
				}
			// 仓库制作
			} else {
				stockVO = new StoreStockVO(dto.getPhysicalWarehouseCode(), WAREHOUSE_NAME, dto.getCanUseQuantity());
				stockList.add(stockVO);
			}
		}
		return stockList;
	}
	
}
