package com.thebeastshop.pegasus.channelservice.adapter.flowermonth;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.WeekEnum;
import com.thebeastshop.support.vo.flowerMonth.FlowerMonthDistAreaVO;
import com.thebeastshop.support.vo.product.ProductDimensionVO;
import com.thebeastshop.support.vo.product.ProductVariantVO;
import com.thebeastshop.support.vo.product.SpvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 * 月送鲜花展示处理器
 *
 * @author GFL
 * @Date 2018/1/30 17:48.
 */
@Service
public class FlowerMonthShowAdapter {

    @Autowired
    private SpvAdapter spvAdapter;

    /**
     * 获取月送商品店送城市列表，售罄店铺沉底
     * @param productCode
     * @return
     */
    public List<FlowerMonthDistAreaVO> getDistArea(String productCode){
        List<FlowerMonthDistAreaVO> result = Lists.newArrayList();
        List<SFlowerMonthlyCityDTO> cityDTOs =  PegasusChannelServiceFacade.getInstance().getFlowerMonSkuInfoByProdCode(productCode, SFlowerProductionTypeEnum.STORE);

        if(CollectionUtils.isNotEmpty(cityDTOs)){
            List<FlowerMonthDistAreaVO> soldList = Lists.newArrayList();
            for(SFlowerMonthlyCityDTO cityDTO : cityDTOs){
                FlowerMonthDistAreaVO target = new FlowerMonthDistAreaVO();
                target.setCode(cityDTO.getCityId().toString());
                target.setName(cityDTO.getCityName());
                if(null == cityDTO.getCanUseQuantity() || NumberUtil.isNullOrZero(cityDTO.getCanUseQuantity())){
                    target.setSoldOut(true);
                    soldList.add(target);
                }else {
                    target.setSoldOut(false);
                    result.add(target);
                }
            }
            if(CollectionUtils.isNotEmpty(soldList)){
                result.addAll(soldList);
            }
        }
        return result;
    }

    /**
     * 获取鲜花规格信息
     * @param product
     * @param member
     * @param opChannel
     * @return
     */
    public ProductVariantVO getFlowerMonthVariant(PsProductVO product, MemberVO member, OpChannelVO opChannel){
        SFlowerProductionTypeEnum type = SFlowerProductionTypeEnum.WAREHOUSE;
        String cityCode = "";
        if(SFlowerProductionTypeEnum.STORE.getValue().equals(product.getFlowerMonProductionType().byteValue())){
            type = SFlowerProductionTypeEnum.STORE;
            List<FlowerMonthDistAreaVO> distAreas = this.getDistArea(product.getCode());
            cityCode = distAreas.get(0).getCode();
        }
        return getFlowerMonthVariant(product,member,opChannel,cityCode,type);
    }

    /**
     * 获取鲜花规格信息
     * @param product
     * @param member
     * @param opChannel
     * @param cityCode
     * @param type @SFlowerProductionTypeEnum
     * @return
     */
    public ProductVariantVO getFlowerMonthVariant(PsProductVO product, MemberVO member, OpChannelVO opChannel,String cityCode,SFlowerProductionTypeEnum type) {
        ProductVariantVO result = new ProductVariantVO();
        if (null != product && YesOrNo.YES.getId().equals(product.getIsMonthSend())) {
            List<PsSpvVO> psSpvVOList = product.getSpvList();
            if (CollectionUtils.isNotEmpty(psSpvVOList)) {
                ProductDimensionVO ruleDimension = new ProductDimensionVO();
                List<String> ruleChoices = Lists.newArrayList();
                ruleDimension.setName("每周几收花");
                ruleDimension.setChoices(ruleChoices);
                ProductDimensionVO timesDimension = new ProductDimensionVO();
                timesDimension.setName("订几周(每周1束)");
                List<String> timesChoices = new ArrayList<>();
                timesDimension.setChoices(timesChoices);
                result.getDimensions().add(ruleDimension);
                result.getDimensions().add(timesDimension);
                Map<Long, SpvVO> spvMap = convertFlowerSpvVO4PsSpvVO(product, member, opChannel,cityCode,type);

                for (PsSpvVO psSpvVO : psSpvVOList) {
                    PsSkuVO psSkuVO = psSpvVO.getSkuVO();
                    List<Integer> group = new ArrayList<>();
                    String weekDesc = WeekEnum.getDesc(psSkuVO.getMonthSendDeliveryRule());
                    if (!ruleChoices.contains(weekDesc)) {
                        ruleChoices.add(weekDesc);
                    }
                    int i = 0;
                    for (String ruleChoice : ruleChoices) {
                        if (ruleChoice.equalsIgnoreCase(weekDesc)) {
                            group.add(i);
                        } else {
                            i++;
                        }

                    }

                    String timesDesc = this.getDeliveryTimesDesc(psSkuVO.getDeliveryTimes());
                    if (!timesChoices.contains(timesDesc)) {
                        timesChoices.add(timesDesc);
                    }
                    int j = 0;
                    for (String timesChoice : timesChoices) {
                        if (timesChoice.equalsIgnoreCase(timesDesc)) {
                            group.add(j);
                        } else {
                            j++;
                        }

                    }

                    // spvVO 增加规格选择信息
                    SpvVO spvVO = spvMap.get(psSpvVO.getSpvId());
                    spvVO.setRawPrice(spvVO.getRawPrice().multiply(new BigDecimal(psSkuVO.getDeliveryTimes())));
                    spvVO.setPrice(spvVO.getPrice().multiply(new BigDecimal(psSkuVO.getDeliveryTimes())));
                    spvVO.setGroup(group);
                    result.getSpvs().add(spvVO);
                }
            }
        }
        return result;
    }


    /**
     * 鲜花规格文字
     *
     * @param times
     * @return
     */
    private String getDeliveryTimesDesc(Integer times) {
        StringBuffer sb = new StringBuffer();
        sb.append(times).append("周").append("(").append(times).append("束").append(")");
        return sb.toString();
    }


    /**
     * 转换鲜花spv对象
     *
     * @param product
     * @return
     */
    private Map<Long, SpvVO> convertFlowerSpvVO4PsSpvVO(PsProductVO product, MemberVO member, OpChannelVO opChannel, String cityId, SFlowerProductionTypeEnum type) {
        Map<Long, SpvVO> spvMap = new HashMap<>();
        List<PsSpvVO> psSpvVOList = product.getSpvList();
        /*
        if (CollectionUtils.isNotEmpty(psSpvVOList)) {
            spvMap = spvAdapter.getSpvWithoutDiscountNew(psSpvVOList, Lists.newArrayList(product), member, opChannel, null);
            // 批量获取月送库存信息，和配送日期
            List<SFlowerMonthlyQueryDTO> querys = Lists.newArrayList();
            for (PsSpvVO spv : product.getSpvList()){
                SFlowerMonthlyQueryDTO query = new SFlowerMonthlyQueryDTO();
                if(StringUtils.isNotEmpty(cityId)){
                    query.setCityId(Integer.parseInt(cityId));
                }
                query.setsFlowerProductionTypeEnum(type);
                query.setSkuCode(spv.getSkuCode());
                querys.add(query);
            }
            Map<String, PcsFlowerDeliveryDate> skuDeliveryDateMap = PegasusPurchaseServiceFacade.getInstance().getFlowerStockAndDate(querys,new Date(),opChannel.getCode());

            // 设置月送鲜花库存信息
            for (PsSpvVO psSpvVO : product.getSpvList()) {
                SpvVO spvVO = spvMap.get(psSpvVO.getSpvId());
                PcsFlowerDeliveryDate pcsFlowerDeliveryDate = skuDeliveryDateMap.get(psSpvVO.getSkuCode());
                if (!pcsFlowerDeliveryDate.isCanSale()) {
                    spvVO.setLeft(0);
                } else {
                    spvVO.setLeft(1);
                    List<PcsFlowerDeliveryRecipeVO> deliveryRecipes = pcsFlowerDeliveryDate.getDeliveryDate();
                    List<String> deliveryDates = Lists.newArrayList();
                    for (PcsFlowerDeliveryRecipeVO deliveryRecipe : deliveryRecipes) {
                        deliveryDates.add(DateUtil.format(deliveryRecipe.getReceiveDay(), "MM-dd"));
                    }
                    spvVO.setDeliveryDates(deliveryDates);
                    // 设置首次配送日期
                    Date firstDelivery = deliveryRecipes.get(0).getReceiveDay();
                    StringBuffer sb = new StringBuffer();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(firstDelivery);
                    sb.append(calendar.get(Calendar.MONTH) + 1).append("月").append(calendar.get(Calendar.DATE))
                            .append("日");
                    spvVO.setFirstDeliveryDate(sb.toString());
                }

            }

        }*/
        return spvMap;
    }



    /**
     * 转换鲜花spv对象
     *
     * @param product
     * @return
     */
    public Boolean hasFlowerStocks(PsProductVO product,OpChannelVO opChannel) {
        List<SFlowerMonthlyCityDTO> cityDTOs = null;
        if(product.getFlowerMonProductionType() != null && SFlowerProductionTypeEnum.STORE.getValue().equals(product.getFlowerMonProductionType().byteValue())){
            cityDTOs =  PegasusChannelServiceFacade.getInstance().getFlowerMonSkuInfoByProdCode(product.getCode(), SFlowerProductionTypeEnum.STORE);
        }else{
            cityDTOs =  PegasusChannelServiceFacade.getInstance().getFlowerMonSkuInfoByProdCode(product.getCode(), SFlowerProductionTypeEnum.WAREHOUSE);
        }

        if(CollectionUtils.isNotEmpty(cityDTOs)){
            for(SFlowerMonthlyCityDTO cityDTO : cityDTOs){
                if(null != cityDTO.getCanUseQuantity() && !NumberUtil.isNullOrZero(cityDTO.getCanUseQuantity())){
                    return true;
                }
            }
        }
        return Boolean.FALSE;
    }

}
