package com.thebeastshop.pegasus.channelservice.adapter.flowermonth;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.service.CampaignQueryService;
import com.thebeastshop.campaign.vo.CampaignDetailVO;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.commdata.service.CommAddressService;
import com.thebeastshop.commdata.vo.CommDistrictVO;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.NullUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.logistics.LogisticsAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.member.MemberAddressAdapter;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.PriceStep;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.channelservice.service.PostageService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SFlowerMonthlyService;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.PaymentType;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.flowerMonth.FlowerMonthDistAreaVO;
import com.thebeastshop.support.vo.logistics.DeliverableVO;
import com.thebeastshop.support.vo.logistics.PostageVO;
import com.thebeastshop.support.vo.order.OrderConfirmVO;
import com.thebeastshop.support.vo.order.OrderDetailVO;
import com.thebeastshop.support.vo.order.OrderPreviewDTO;
import com.thebeastshop.wms.constant.WMSConstants;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * 月送订单处理
 *
 * @author GFL
 * @Date 2018/2/2 15:51.
 */
@Service
public class FlowerMonthOrderAdapter {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private MemberAddressService memberAddressService;

	@Autowired
	private LabelService labelService;

	@Autowired
	private MemberAddressAdapter memberAddressAdapter;
	@Autowired
	private LogisticsAdapter logisticsAdapter;
	@Autowired
	private PriceService priceService;
	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;
	@Autowired
	private PostageService postageService;
	@Autowired
	private CampaignQueryService campaignQueryService;

	@Autowired
	private CommAddressService commAddressService;

	/**
	 * 周送鲜花确认订单
	 *
	 * @param orderPreview
	 * @param paramPacks
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public OrderConfirmVO getFlowerMonthConfirm(OrderPreviewDTO orderPreview, List<CartProductPack> paramPacks,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {

		OrderConfirmVO rt = new OrderConfirmVO();
		CartProductPack rewPack = null;
		Integer deliveryTimes = 1;
		if (CollectionUtils.isEmpty(paramPacks)) {
			throw new WrongArgException("商品包不能为空");
		} else {
			for (CartProductPack pack : paramPacks) {
				if (CartPackSourceEnum.RAW.equals(pack.getSource())) {
					rewPack = pack;
					break;
				}
			}
		}
		if (null != rewPack.getSpv().getSkuVO()) {
			PsSkuVO sku = rewPack.getSpv().getSkuVO();
			deliveryTimes = sku.getDeliveryTimes();
		}

		Long couponId = orderPreview.getCouponId();
		int timeSlot = orderPreview.getDeliveryTimeSlot();
		Long addressId = orderPreview.getAddressId();
		Boolean hasOverSea = false;
		boolean birthday = false;
		// 月送鲜花不参与生日折扣
		// if (null != orderPreview.isUseBdayDiscount() &&
		// !orderPreview.isUseBdayDiscount()) {
		// logger.info("isUseBdayDiscount" + orderPreview.isUseBdayDiscount());
		// birthday = false;
		// }

		CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();

		if (couponId != null && member != null) {
			// 价格计算有优惠券校验，这就不进行校验了
			calPriceDTO.setCouponId(couponId);
		}

		// 价格计算
		calPriceDTO.setAccessWay(accessWay);
		calPriceDTO.setOpChannel(opChannel);
		calPriceDTO.setMember(member);
		calPriceDTO.setPacks(paramPacks);
		if (!birthday) {
			calPriceDTO.setBirthday(false);
		}
		PriceResult priceResult = priceService.calculateProductPackPrice(calPriceDTO);
		List<CampaignResult> campaignResults = priceResult.getCampaignResults();

		// =============配送地址和配送运费获取 =============
		DeliverableVO deliverableTime = new DeliverableVO();
		com.thebeastshop.member.vo.MemberAddressVO address = null;
		if (null != addressId && addressId != 0) {
			address = memberAddressService.getById(addressId);
			if (!this.canDistFlowerAddress(address, rewPack)) {
				throw new WrongArgException("地址不可用，不在配送区域！");
			}
			deliverableTime = logisticsAdapter.getDeliverableNew(paramPacks, address, member, accessWay, opChannel,
					orderPreview.getPostage(), hasOverSea, priceResult);
		} else {
			// 使用默认地址时处理
			address = memberAddressService.getDefaultByOwnerId(member.getId());// 不传时使用默认地址
			if (!this.canDistFlowerAddress(address, rewPack)) {
				address = null;
			} else {
				try {
					deliverableTime = logisticsAdapter.getDeliverableNew(paramPacks, address, member, accessWay,
							opChannel, orderPreview.getPostage(), hasOverSea, priceResult);
				} catch (WrongArgException ws) {
					// 月送可送，商品配送区域校验，如果校验失败地址置空
					address = null;
				}
			}
		}
		if (address != null) {
			rt.setAddress(memberAddressAdapter.getMemberAddress(address, member));
		}

		List<CartProductPackVO> packVOs = Lists.newArrayListWithExpectedSize(paramPacks.size());
		for (CartProductPack pack : paramPacks) {
			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				CartProductPackVO packVO = cartProductPackAdaptor.getAddibleCartProductPackListNew(Arrays.asList(pack),
						member, opChannel, accessWay, null, false).get(0);
				// 加价购商品添加"换购"标签
				Label label = new Label();
				label.setType("换购");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else if (pack.getSource().equals(CartPackSourceEnum.GIFT)) {
				CartProductPackVO packVO = cartProductPackAdaptor
						.getAddibleCartProductPackListNew(Arrays.asList(pack), member, opChannel, accessWay, null, true)
						.get(0);
				// 赠品商品添加"赠品"标签
				Label label = new Label();
				label.setType("赠品");
				packVO.getLabels().add(label);
				packVOs.add(packVO);
			} else {
				packVOs.addAll(cartProductPackAdaptor.getCartProductPackListNew(Arrays.asList(pack), member, opChannel,
						true, true, true, campaignResults, accessWay, birthday, null));
			}
		}

		// =========是否包含海外购商品===========
		rt.setHasOverseaProducts(false);
		// =========可用的支付方式===========
		rt.setPayMethods(getPayMethods(rt.isHasOverseaProducts()));
		// ==============商品包================
		rt.setPacks(packVOs);
		// ===============标签================
		List<Label> cartLabels = labelService.getCartLabels(campaignResults, accessWay);
		for (Label label : cartLabels) {
			if (label.getCampaign() != null && label.getCampaign().getFulfilled()) {
				rt.getLabels().add(label);
			}
		}

		// =============价格步骤===============
		Collection<OrderDetailVO.PriceStepVO> priceSteps = Lists.newArrayList();
		// *******商品总额******
		BigDecimal totalPrice = priceResult.getTotalPrice();

		priceSteps.add(new OrderDetailVO.PriceStepVO("商品总额", totalPrice));

		// *******优惠******
		BigDecimal birth = BigDecimal.ZERO;
		BigDecimal memb = BigDecimal.ZERO;
		BigDecimal coupon = BigDecimal.ZERO;
		List<PriceStep> steps = priceResult.getSteps();
		// 活动价格步骤
		Collection<OrderDetailVO.PriceStepVO> campaignSteps = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(steps)) {
			for (PriceStep step : steps) {
				BigDecimal savedPrice = step.getSavedPrice();
				if (savedPrice.compareTo(BigDecimal.ZERO) != 0) {
					if (step.getPriceType().equals(PriceType.MEMBER_LEVEL)) {
						memb = memb.add(savedPrice);
					} else if (step.getPriceType().equals(PriceType.BIRTHDAY)) {
						birth = birth.add(savedPrice);
					} else if (step.getPriceType().equals(PriceType.CAMPAIGN)) {
						CampaignDetailVO campaign = campaignQueryService.getCampaignById(step.getExtId());
						campaignSteps.add(new OrderDetailVO.PriceStepVO(campaign.getName(),
								BigDecimal.ZERO.subtract(savedPrice)));
					} else if (step.getPriceType().equals(PriceType.COUPON)) {
						coupon = coupon.add(savedPrice);
					}
				}
			}
		}
		if (memb.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new OrderDetailVO.PriceStepVO("会员折扣", BigDecimal.ZERO.subtract(memb)));
		}
		if (birth.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new OrderDetailVO.PriceStepVO("生日折扣", BigDecimal.ZERO.subtract(birth)));
		}
		if (CollectionUtils.isNotEmpty(campaignSteps)) {
			priceSteps.addAll(campaignSteps);
		}
		if (coupon.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new OrderDetailVO.PriceStepVO("优惠券", BigDecimal.ZERO.subtract(coupon)));
		}

		// ===============定制信息===============
		for (CartProductPack cartProductPack : paramPacks) {
			if (cartProductPack.isCustomize()) {
				rt.setCustomizable(Boolean.TRUE);
				break;
			}
		}

		// ===============配送信息（是否使用语音卡）===============
		int voiceCard = 0;
		rt.setVoiceCard(false);
		for (CartProductPack cartProductPack : paramPacks) {
			PsProductVO pro = cartProductPack.getProduct();
			if (!pro.getExpressType().equals(WMSConstants.ExpressType.SHOP)) {
				voiceCard++;
			}
		}
		if (voiceCard > 0) {
			rt.setVoiceCard(true);
		}
		BigDecimal customizePrice = BigDecimal.ZERO;
		if (rt.getCustomizable()) {
			customizePrice = priceService.calculateCustomizePrice(calPriceDTO);
		}

		// 折扣后价格计算（运费计算按折扣后价格计算）
		BigDecimal price = BigDecimal.ZERO;
		for (OrderDetailVO.PriceStepVO priceStepVO : priceSteps) {
			price = price.add(priceStepVO.getPrice());
		}

		PostageVO postageVO = deliverableTime != null ? deliverableTime.getPostage() : null;
		List<OrderDetailVO.PriceStepVO> serviceStep = postageService.calculatePostageWithStepNew(customizePrice,
				timeSlot, postageVO, paramPacks, price, member, accessWay, null, hasOverSea);
		if (CollectionUtils.isNotEmpty(serviceStep)) {
			if (deliveryTimes > 1) {
				for (OrderDetailVO.PriceStepVO priceStepVO : serviceStep) {
					priceStepVO.setPrice(priceStepVO.getPrice().multiply(new BigDecimal(deliveryTimes)));
				}
			}
			priceSteps.addAll(serviceStep);
		}
		// =============应付价格计算===============
		// 折扣后价格计算（运费计算按折扣后价格计算）
		BigDecimal discountPrice = BigDecimal.ZERO;
		for (OrderDetailVO.PriceStepVO priceStepVO : priceSteps) {
			discountPrice = discountPrice.add(priceStepVO.getPrice());
		}

		// ===============礼品卡===============
		BigDecimal giftPrice = BigDecimal.ZERO;
		if (CollectionUtils.isNotEmpty(orderPreview.getGiftCards())) {// 礼品卡
			List<OpSalesOrderGiftCardVO> opSalesOrderGiftCardVOs = priceService
					.calculateGiftPrice(orderPreview.getGiftCards(), discountPrice);
			for (OpSalesOrderGiftCardVO vo : opSalesOrderGiftCardVOs) {
				giftPrice = giftPrice.add(vo.getGiftCardValue());
			}

		}
		if (giftPrice.compareTo(BigDecimal.ZERO) != 0) {
			priceSteps.add(new OrderDetailVO.PriceStepVO("礼品卡", BigDecimal.ZERO.subtract(giftPrice)));
		}
		rt.setPrice(discountPrice.subtract(giftPrice));

		// =============配送信息===============
		// *******************
		rt.setPriceSteps(priceSteps);

		// ======= 生日折扣 月送鲜花不参与生日折扣 ===========
		if (member != null && member.getMemberLevel() != null
				&& !member.getMemberLevel().equals(MemberLevelEnum.NORMAL.getCode()) && member.isInBdayDiscountTime()) {
			OrderConfirmVO.BdayVO bday = new OrderConfirmVO.BdayVO();
			bday.setWithin(Boolean.FALSE);
			bday.setUsed(member.isBdayDiscountUsed());
			bday.setRatio(member.getBdayDiscountRatio());
			rt.setBday(bday);
		}

		if (NullUtil.isNotNull(rewPack.getSpv().getSkuVO().getCanRemark())
				&& 1 == rewPack.getSpv().getSkuVO().getCanRemark()) {
			rt.setCanRemark(true);
		} else {
			rt.setCanRemark(false);
		}

		return rt;
	}

	/**
	 * 获取运费
	 *
	 * @param orderPreview
	 * @param opChannel
	 * @param deliveryTimes
	 * @param deliverable
	 * @return
	 */
	private PostageVO getPostageVO(OrderPreviewDTO orderPreview, OpChannelVO opChannel, Integer deliveryTimes,
			DeliverableVO deliverable) {
		PostageVO postageVO = null;
		// 运费
		if (deliverable != null) {
			postageVO = deliverable.getPostage();
		}
		// 如果是线下，用线下传进来的运费
		if (opChannel.getChannelType() == 1) {
			postageVO = orderPreview.getPostage();
		}
		if (deliveryTimes > 1 && postageVO != null) { // 配送次数大于1
			if (postageVO.getNormal() != null) {
				postageVO.setNormal(postageVO.getNormal().multiply(new BigDecimal(deliveryTimes)));
			}
			if (postageVO.getEDT() != null) {
				postageVO.setEDT(postageVO.getEDT().multiply(new BigDecimal(deliveryTimes)));
			}
			if (postageVO.getFaraway() != null) {
				postageVO.setFaraway(postageVO.getFaraway().multiply(new BigDecimal(deliveryTimes)));
			}
		}
		return postageVO;
	}

	/**
	 * 获取所有可用支付方式
	 *
	 * @param isOverSea
	 *            是否是海淘
	 * @return
	 */
	private List<PaymentType> getPayMethods(boolean isOverSea) {
		List<PaymentType> payMethods = Lists.newArrayList();
		if (isOverSea) {
			payMethods.add(PaymentType.ALIPAY);
		} else {
			payMethods.add(PaymentType.ALIPAY);
			payMethods.add(PaymentType.WEIXIN);
		}
		return payMethods;
	}

	/**
	 * 鲜花地址是否可以配送
	 *
	 * @param address
	 * @param rewPack
	 * @return
	 */
	public Boolean canDistFlowerAddress(com.thebeastshop.member.vo.MemberAddressVO address, CartProductPack rewPack) {
		if (address != null) {
			CommDistrictVO district = commAddressService.findDistrictById(address.getDistrict().getId().intValue());
			Long cityId = district.getCityId().longValue();
			if (SFlowerProductionTypeEnum.STORE.getValue()
					.equals(rewPack.getProduct().getFlowerMonProductionType().byteValue())) {
				List<SFlowerMonthlyCityDTO> cityDTOs = PegasusChannelServiceFacade.getInstance()
						.getFlowerMonSkuInfoByProdCode(rewPack.getProduct().getCode(), SFlowerProductionTypeEnum.STORE);
				List<Long> cityIds = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(cityDTOs)) {
					for (SFlowerMonthlyCityDTO cityDTO : cityDTOs) {
						if (null != cityDTO.getCanUseQuantity()
								|| !NumberUtil.isNullOrZero(cityDTO.getCanUseQuantity())) {
							cityIds.add(cityDTO.getCityId().longValue());
						}
					}
				}
				if (!cityIds.contains(cityId)) {
					return false;
				}
			}
		}
		return true;
	}

}
