package com.thebeastshop.pegasus.channelservice.adapter.flowermonth;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.service.operation.enums.ChannelCodeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.CpCouponSampleVO;
import com.thebeastshop.coupon.vo.CpCouponVO;
import com.thebeastshop.coupon.vo.CpFullCutPriceVO;
import com.thebeastshop.member.service.MemberAddressService;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberAddressVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.channelservice.model.PriceStep;
import com.thebeastshop.pegasus.channelservice.model.ServiceFeeStep;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.channelservice.vo.order.FlowerMonthOrderVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderGiftCardVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OrderTypeEnum;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackage;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
import com.thebeastshop.stock.dto.SFlowerMonthlyCityDTO;
import com.thebeastshop.stock.dto.SFlowerMonthlyQueryDTO;
import com.thebeastshop.stock.enums.SFlowerProductionTypeEnum;
import com.thebeastshop.stock.service.SFlowerMonthlyService;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.enums.OrderBusinessType;
import com.thebeastshop.support.enums.PriceType;
import com.thebeastshop.support.vo.giftcard.GiftCardVO;

/**
 * 月送鲜花 Created by feilong.gao on 2017/2/15.
 */
/*
@Component
public class FlowerMonthAdapter {
    private final static Logger logger = LoggerFactory.getLogger(FlowerMonthAdapter.class);
    @Autowired
    private McPsProductService mcPsProductService;

    @Autowired
    private McPsSkuService mcPsSkuService;

    private PegasusChannelServiceFacade pcInstance = PegasusChannelServiceFacade.getInstance();
    private PegasusPurchaseServiceFacade instance = PegasusPurchaseServiceFacade.getInstance();

    @Autowired
    private CpCouponService cpCouponService;

    @Autowired
    private CpCouponSampleService cpCouponSampleService;

    @Autowired
    private MemberQueryService memberQueryService;
    @Autowired
    private MemberAddressService memberAddressService;
    @Autowired
    private PriceService priceService;
    
    private PegasusUtilFacade utilFacade = PegasusUtilFacade.getInstance();

    @Autowired
    private SFlowerMonthlyService sFlowerMonthlyService;

    */
/**
     * 设置月送花订单实体
     *
     * @param orderCreateVO
     * @param accessWay
     * @return OpSalesOrderVO
     *//*

    public OpSalesOrderVO orderWebsite2CommonFlower(FlowerMonthOrderVO orderCreateVO, AccessWayEnum accessWay,
                                                    OpChannelVO opChannel, List<CartProductPack> packs) {

        // OpMemberVO memberVo=null;
        MemberVO member = memberQueryService.getById(orderCreateVO.getMemberId());

        // 设置配送地址
        MemberAddressVO address = memberAddressService.getById(orderCreateVO.getAddressId());

//		// 验证用户是否有权限购买月送鲜花
//		if (!pcInstance.memberHasPermission(orderCreateVO.getMemberId())) {
//			throw new ChannelException(ErrorCode.USER_NOT_HAS_PERMISSION.getCode(),
//					ErrorCode.USER_NOT_HAS_PERMISSION.getMesage());
//		}

        // 订单VO
        final OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();

        // 设置各项费用
        if (CollectionUtils.isNotEmpty(orderCreateVO.getServiceStep())) {

            for (ServiceFeeStep step : orderCreateVO.getServiceStep()) {

                // 海淘运费或 运费
                if (step.getPriceType().id == PriceType.OVERSEAS.id || step.getPriceType().id == PriceType.POSTAGE.id) {
                    opSalesOrderVO.setCarriage(opSalesOrderVO.getCarriage().add(step.getPrice()));
                    // 限时送达运费
                } else if (step.getPriceType().id == PriceType.TIME.id) {
                    opSalesOrderVO.setLimitFee(step.getPrice());
                    opSalesOrderVO.setLimitFee(opSalesOrderVO.getLimitFee().add(step.getPrice()));
                    // 定制费用
                } else if (step.getPriceType().id == PriceType.CUSTOMIZE.id) {
                    opSalesOrderVO.setCustomizationAmount(step.getPrice());
                 // 礼品卡
                } else if (step.getPriceType().id == PriceType.GIFTCARD.id) {
                	StringBuilder builder = new StringBuilder();
        			BigDecimal totail = BigDecimal.ZERO;
        			for (OpSalesOrderGiftCardVO vo : orderCreateVO.getOpSalesOrderGiftCardVOs()) {
        				totail = totail.add(vo.getGiftCardValue());
        				builder.append("no:" + vo.getGiftCardNo());
        				builder.append("&fee:" + vo.getGiftCardValue().multiply(BigDecimal.valueOf(100)));
        				builder.append("|");
        			}
        			opSalesOrderVO.setOpSalesOrderGiftCardVOs(orderCreateVO.getOpSalesOrderGiftCardVOs());
        			opSalesOrderVO.setGiftCardDesc(builder.toString());
        			opSalesOrderVO.setGiftCardAmount(totail);
                }
            }
        }

        // 包裹VO
        final List<OpSoPackageVO> opSoPackageVOs = new ArrayList<>();
        // 官网默认是一个包裹
        final OpSoPackageVO opSoPackage = new OpSoPackageVO();
        // 包裹地址信息
        final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = new OpSoPackageDeliveryInfoVO();

        // 配送仓

        if (opChannel != null) {
            opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
            // 订单来源渠道编码
            opSalesOrderVO.setChannelCode(opChannel.getCode());
        }

        // orderPreCheck(orderCreateVO.getChannelCode(), orderCreateVO,
        // opChannel);// 下单之前的预判
        // 校验价格
        // 校验库存
        // 校验是否下架
        opSalesOrderVO.setActualPayFee(orderCreateVO.getActualPayFee());

        // 投放渠道
        opSalesOrderVO.setUtmSource(orderCreateVO.getUtmSource());
        //app下载来源
        opSalesOrderVO.setDownloadSource(orderCreateVO.getDownloadSource());

        // 会员id
        if (member != null) {
            opSalesOrderVO.setMemberId(member.getId());
            // 会员code
            opSalesOrderVO.setMemberCode(member.getCode());
        }
        opSalesOrderVO.setIsAnonymous(orderCreateVO.getIsAnonymous());

        opSalesOrderVO.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_NOT_OVERSEA);
        opSalesOrderVO.setCrossFree(BigDecimal.ZERO);

        // 设置配送地址
        // OpMemberAddressVO opMemberAddressVO =
        // pcInstance.addressDetail(orderCreateVO.getAddressId());
        // 详细地址
        opSoPackageDeliveryInfoVO.setAddress(address.getAddress());

        // 公司名称
        opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());
        // 收货的区县ID
        opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrict().getId());
        // 收件人
        opSoPackageDeliveryInfoVO.setReceiver(address.getReceiver());
        // 收件人电话
        opSoPackageDeliveryInfoVO.setReceiverPhone(address.getReceiverPhone());
        opSoPackageDeliveryInfoVO.setZipCode(address.getZipCode());
        // 暂时设置为顺风空运

        // 月送鲜花改成 安鲜达 by Robin.li

//		String districtName = address.getDistrict().getName();
//
//		logger.info("districtName{}======" + districtName);
//
        // 设置城市
        CommDistrict district = utilFacade.findDistrictById(address.getDistrict().getId());

        opSalesOrderVO.setCity(district.getCityId().toString());
//		if (district.getFullName().contains("上海市") && !"崇明县".equals(district.getName())) {
//			opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_AXD);
//		} else {
//			opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//		}

        // 设置包裹配送信息
        opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);

        opSoPackage.setDeliveryType(OpSoPackage.DELIVERY_TYPE_EXPRESS);
        opSoPackage.setCardType(0);

        opSoPackageVOs.add(opSoPackage);

        // 设置订单关联包裹
        opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);

        // 服务费
        opSalesOrderVO.setServiceFeeAmount(orderCreateVO.getServiceFee());
        // 用户备注
        opSalesOrderVO.setRemark(orderCreateVO.getNote());
        // 订单类型，1
        opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
        opSalesOrderVO.setOrderTypeEnum(OrderTypeEnum.ORDERTYPE_1);
        //opSalesOrderVO.setOrderBusinessType(OrderBusinessType.MONTHLY_FLOWER);
        if (!StringUtils.isBlank(orderCreateVO.getCouponCode()) && orderCreateVO.getPriceResult() != null) {

            BigDecimal couponFee = BigDecimal.ZERO;

            if (CollectionUtils.isNotEmpty(orderCreateVO.getPriceResult().getSteps())) {
                List<PriceStep> steps = orderCreateVO.getPriceResult().getSteps();
                if (CollectionUtils.isNotEmpty(steps)) {

                    for (PriceStep step : steps) {
                        if (PriceType.COUPON.id == step.getPriceType().getId()) {
                            for (ProductPack pack : step.getFinalPackPrice().keySet()) {

                                BigDecimal originalPrice = step.getOriginalPackPrice().get(pack);
                                BigDecimal finalPrice = step.getFinalPackPrice().get(pack);

                                couponFee = couponFee.add(originalPrice.subtract(finalPrice));
                            }
                        }

                    }

                }

                opSalesOrderVO.setCouponFee(BigDecimal.ZERO);
                opSalesOrderVO.setCouponDiscountAmount(couponFee);
            }

        } else {
            opSalesOrderVO.setCouponFee(BigDecimal.ZERO);
            opSalesOrderVO.setCouponDiscountAmount(BigDecimal.ZERO);
        }
        // 设置包裹
        setOpSoPackageFlower(orderCreateVO, member, opSalesOrderVO, opChannel, accessWay);
        return opSalesOrderVO;
    }

    private void setOpSoPackageFlower(FlowerMonthOrderVO orderCreateVO, MemberVO member, OpSalesOrderVO opSalesOrderVO,
                                      final OpChannelVO opChannel, AccessWayEnum accessWay) {

        opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);

        List<OpSoPackageSkuVO> gifts = new ArrayList<>();
        List<OpSoPackageSkuVO> changes = new ArrayList<>();

        // 配送方式，判断是否需要强制审单
        for (CartProductPack pack : orderCreateVO.getPacks()) {
            OpSoPackageSkuVO packageSku = new OpSoPackageSkuVO();
            String skuCode = pack.getSpv().getSkuCode();

            packageSku.setSpvId(pack.getSpvId());


            final PsSkuVO skuVO = mcPsSkuService.findBySkuCode(skuCode);

            // 折扣后金额
            packageSku.setUnitAmountAfterDiscount(pack.getSpv().getDiscountPrice());

            // 特价
            packageSku.setDiscountPrice(BigDecimal.ZERO);

            packageSku.setUnitPrice(pack.getSpv().getSalesPrice());
            packageSku.setUnitDiscount(packageSku.getUnitPrice().subtract(packageSku.getUnitAmountAfterDiscount()));
            // 验证库存

            packageSku.setUnitPoint(BigDecimal.ZERO);
            packageSku.setUnitPointDeduction(BigDecimal.ZERO);
            packageSku.setWeight(skuVO.getWeight());
            packageSku.setTaxNo(skuVO.getTaxNo());

            packageSku.setClearanceWay(skuVO.getClearanceWay());
            // 跨境购标注 0普通１跨境购
            packageSku.setCrossBorderFlag(skuVO.getCrossBorderFlag());

            packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);// 默认会员添加
            packageSku.setSkuCode(skuVO.getSkuCode());
            packageSku.setBrandId(skuVO.getBrandId());
            packageSku.setCategroyId(skuVO.getCategoryId());
            // packageSku.setMainSkuCode(detail.getMainSkuId());
            packageSku.setIsJit(skuVO.getIsJit());// 是否来单制作
            packageSku.setQuantity(1);// 数量
            // 商品分类
            packageSku.setCategoryId(skuVO.getCategoryId());
            // 代销
            packageSku.setWhetherConsignment(skuVO.getWhetherConsignment());
            packageSku.setIsGift(0);// 底层暂不支持赠品
            if (pack.getSource().getCode() == CartPackSource.GIFT.id) {
            	
            	
                // 折扣后金额
                packageSku.setUnitAmountAfterDiscount(BigDecimal.ZERO);

                // 特价
                packageSku.setDiscountPrice(BigDecimal.ZERO);

                packageSku.setUnitPrice(BigDecimal.ZERO);
                packageSku.setUnitDiscount(BigDecimal.ZERO);
            	
                gifts.add(packageSku);
                // 是否赠品，0否1是
                packageSku.setIsGift(1);// 底层暂不支持赠品
                packageSku.setSourceId(CartPackSource.GIFT.id);
                List<String> flowerMonthGift = pcInstance.getWeekFlowerGifts();

                if (CollectionUtils.isNotEmpty(flowerMonthGift)) {
                    if (flowerMonthGift.contains(packageSku.getSkuCode())) {
                        boolean isGiftBy = pcInstance.memberHasGetGifts(member.getId());
                        if (isGiftBy) {
                            throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), "赠品无效！" + skuCode);
                        } else {
                            // 月送首单标志
                            packageSku.setCampignCode(OpSoPackageSku.SIGN_MONTH_FLOWER_FIRST_GIFT);
                        }

                    }
                }


            } else if (pack.getSource().getCode() == CartPackSource.ADDIBLE.id) {
                changes.add(packageSku);

            } else {

                if (skuVO.getIsMonthSend() != null && skuVO.getIsMonthSend() == 1) {
                    // 商品上下架，以app渠道为主
                    PsProductVO productVO = mcPsProductService.findProdByChnCodeSkuCode(ChannelCodeEnum.CHN2049.getChannelCode(), skuCode);
                    if (null == productVO || CollectionUtils.isEmpty(productVO.getChnCanSaleSKu())
                            || !productVO.getCanSaleSku(ChannelCodeEnum.CHN2049.getChannelCode()).contains(skuCode)) {
                        throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(), "商品已下架 " + skuCode);
                    }

                    // 判断是否包含两种以上配送方式，如果是，则需要强制审单
                    final int expressType = productVO.getExpressType();
                    packageSku.setExpressType(expressType);
                    opSalesOrderVO.getOpSoPackageVOs().get(0).getOpSoPackageDeliveryInfoVO().setExpressType(expressType);

                    SFlowerProductionTypeEnum sFlowerProductionTypeEnum = SFlowerProductionTypeEnum.STORE;

                    if (productVO.getFlowerMonProductionType() != null && productVO.getFlowerMonProductionType() == 2) {
                        sFlowerProductionTypeEnum = SFlowerProductionTypeEnum.WAREHOUSE;
                    }
                    
                    ServiceResp<SFlowerMonthlyCityDTO> resp = sFlowerMonthlyService.getFlowerSkuStock(skuCode, Integer.valueOf(opSalesOrderVO.getCity()), sFlowerProductionTypeEnum);
                    if (resp.getBean() == null) {
                        throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
                                ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + ","
                                        + skuVO.getSkuName() + ": " + resp.getRespMsg());
                    } else {
                        if (pack.getCount() > resp.getBean().getCanUseQuantity()) {
                            throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
                                    ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + ","
                                            + skuVO.getSkuName());
                        }

                    }

                    packageSku.setFlowerMonProductionType(productVO.getFlowerMonProductionType());


                    SFlowerMonthlyQueryDTO dto = new SFlowerMonthlyQueryDTO();
                    dto.setCityId(Integer.valueOf(opSalesOrderVO.getCity()));
                    dto.setsFlowerProductionTypeEnum(sFlowerProductionTypeEnum);
                    dto.setSkuCode(skuCode);
                    PcsFlowerDeliveryDate flowerDelivery = instance.getFlowerStockAndDate(dto, DateUtil.getNow(),
                            opChannel.getCode());
                    if (flowerDelivery != null) {

                        if (!flowerDelivery.isCanSale()) {
                            throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(),
                                    ErrorCode.ITEM_OUTOF_QUANTITY.getMesage() + ": " + skuVO.getSkuCode() + ","
                                            + skuVO.getSkuName());
                        }
                        setPackageFlower(flowerDelivery, packageSku, opSalesOrderVO, pack.getSpv());
                    }
                }


            }

        }

        // //app 赠品 判断
        // if("CHN2049".equals(channel.getCode())){
        // int memberLevel = memberVo.getMemberLevel() != null ?
        // memberVo.getMemberLevel().intValue() : 0;
        // List<String> appGiftList
        // =comOrderAdapter.appGiftByFirstOrder(memberVo.getCode(),memberLevel);
        // if(CollectionUtils.isNotEmpty(appGiftList)){
        // for(String code:appGiftList){
        // appFirstOrderGiftFlower(code,gifts,channel);
        // }
        // }
        // }

        // 赠品与换购商品还有卡片全部放入第一个包裹里
        if (CollectionUtils.isNotEmpty(gifts)) {
            opSalesOrderVO.getOpSoPackageVOs().get(0).getOpSoPackageSkuVOs().addAll(gifts);
        }
        if (CollectionUtils.isNotEmpty(changes)) {
            opSalesOrderVO.getOpSoPackageVOs().get(0).getOpSoPackageSkuVOs().addAll(changes);
        }

        // 卡片类型，0不需要1空白2代写
        opSalesOrderVO.getOpSoPackageVOs().get(0).setCardType(orderCreateVO.getNoteCard());
        // 卡片内容
        opSalesOrderVO.getOpSoPackageVOs().get(0).setCardContent(orderCreateVO.getNoteCardMessage());
        opSalesOrderVO.getOpSoPackageVOs().get(0).setCardTo(orderCreateVO.getNoteCardTo());
        opSalesOrderVO.getOpSoPackageVOs().get(0).setCardFrom(orderCreateVO.getNoteCardFrom());

    }

    private BigDecimal getCouponFee(Long userId, long couponId) {
        // 初始值
        BigDecimal couponFee = BigDecimal.ZERO;
        MemberVO member = new MemberVO();
        member.setId(userId);

        CpCouponVO couponVO = cpCouponService.getCouponById(Long.valueOf(couponId));

        CpCouponSampleVO couponSampleVO = cpCouponSampleService.getCouponSampleById(couponVO.getCouponSampleId());

        if (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {

            try {
                CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) couponVO.getCouponSample().getCouponContent();
                couponFee = fullCutCoupon.getCutPrice();
            } catch (Exception ex) {
                Map map = couponVO.getCouponSample().getCouponContentMap();
                Integer fee = (Integer) map.get("cutPrice");
                couponFee = new BigDecimal(fee);
            }
        }

        return couponFee;
    }

    // private BigDecimal getCouponFee2(Member member, List<CartProductPack>
    // sourcePacks, long couponId, AccessWay accessWay, Channel channel) {
    // // 初始值
    // BigDecimal couponFee = BigDecimal.ZERO;
    //
    // if (CollectionUtils.isNotEmpty(sourcePacks)) {
    // CalculateProductPackDTO calculateProductPackDTO = new
    // CalculateProductPackDTO();
    // calculateProductPackDTO.setAccessWay(accessWay);
    // calculateProductPackDTO.setCouponId(couponId);
    // calculateProductPackDTO.setMember(member);
    // calculateProductPackDTO.setChannel(channel);
    // calculateProductPackDTO.setPacks(sourcePacks);
    // PriceResult priceResult =
    // priceService.calculateProductPackPrice(calculateProductPackDTO);
    // List<PriceStep> steps = priceResult.getSteps();
    // if (CollectionUtils.isNotEmpty(steps)) {
    // for (PriceStep step : steps) {
    // if (step.getPriceType().equals(PriceType.COUPON)) {
    // couponFee = step.getSavedPrice();
    // break;
    // }
    // }
    // }
    // }
    // }


    */
/**
     * 月送鲜花拆包裹
     *
     * @param flowerDelivery
     * @param packageSku
     * @param opSalesOrderVO
     *//*

    private void setPackageFlower(PcsFlowerDeliveryDate flowerDelivery, OpSoPackageSkuVO packageSku,
                                  OpSalesOrderVO opSalesOrderVO, PsSpvVO spvVO) {

        List<OpSoPackageVO> splitPackages = new ArrayList<>();

        // 取得默认包裹
        OpSoPackageVO packageVO = opSalesOrderVO.getOpSoPackageVOs().get(0);

        BigDecimal totalPrice = spvVO.getSalesPrice();
        BigDecimal totalDiscount = spvVO.getSalesPrice().subtract(spvVO.getDiscountPrice());

        BigDecimal totalConponPrice = opSalesOrderVO.getCouponDiscountAmount();

        */
/**
         * 根据配送次数拆份包裹
         *//*

        if (CollectionUtils.isNotEmpty(flowerDelivery.getDeliveryDate())) {
            OpSoPackageVO pk = null;
            List<OpSoPackageSkuVO> opSoPackageSkuVOs = null;
            OpSoPackageSkuVO sku = null;
            // 初步平摊价格
            BigDecimal price = totalPrice
                    .divide(BigDecimal.valueOf(flowerDelivery.getDeliveryDate().size()), 4, BigDecimal.ROUND_HALF_DOWN)
                    .setScale(2, RoundingMode.HALF_UP);
            BigDecimal discount = totalDiscount
                    .divide(BigDecimal.valueOf(flowerDelivery.getDeliveryDate().size()), 4, BigDecimal.ROUND_HALF_DOWN)
                    .setScale(2, RoundingMode.HALF_UP);

            BigDecimal couponPrice = totalConponPrice
                    .divide(BigDecimal.valueOf(flowerDelivery.getDeliveryDate().size()), 4, BigDecimal.ROUND_HALF_DOWN)
                    .setScale(2, RoundingMode.HALF_UP);

            BigDecimal recordPrice = BigDecimal.ZERO;
            BigDecimal recordDiscount = BigDecimal.ZERO;

            BigDecimal recordCouponPrice = BigDecimal.ZERO;

            for (int i = 0; i < flowerDelivery.getDeliveryDate().size(); i++) {
                opSoPackageSkuVOs = new ArrayList<OpSoPackageSkuVO>();
                pk = new OpSoPackageVO();
                BeanUtils.copyProperties(packageVO, pk);

                sku = new OpSoPackageSkuVO();
                BeanUtils.copyProperties(packageSku, sku);
                // 金额分摊
                if (i == flowerDelivery.getDeliveryDate().size() - 1) {
                    sku.setShareCouponDiscount(totalConponPrice.subtract(recordCouponPrice));
                    sku.setUnitDiscount(totalDiscount.subtract(recordDiscount).add(sku.getShareCouponDiscount()));
                    sku.setUnitPrice(totalPrice.subtract(recordPrice));
                    sku.setUnitAmountAfterDiscount(sku.getUnitPrice().subtract(sku.getUnitDiscount()));


                } else {
                    recordPrice = recordPrice.add(price);
                    recordDiscount = recordDiscount.add(discount);
                    recordCouponPrice = recordCouponPrice.add(couponPrice);
                    sku.setUnitPrice(price);
                    sku.setUnitDiscount(discount.add(couponPrice));
                    sku.setUnitAmountAfterDiscount(sku.getUnitPrice().subtract(sku.getUnitDiscount()));
                    sku.setShareCouponDiscount(couponPrice);
                }
                sku.setSourceId(OpSoPackageSku.SOURCEID_MONTHFLOWER);
                opSoPackageSkuVOs.add(sku);
                pk.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
                pk.setPlanedDeliveryDate(flowerDelivery.getDeliveryDate().get(i).getSendDay());
                pk.setExpectReceiveDate(flowerDelivery.getDeliveryDate().get(i).getReceiveDay());
                pk.setRecipeId(flowerDelivery.getDeliveryDate().get(i).getId());
                // 第一个时，存入，以后统计每周销售用
                if (i == 0) {
                    pk.setFirstRecipeId(flowerDelivery.getDeliveryDate().get(0).getId());
                }
                pk.setPackageType(OpSoPackage.PACKAGE_TYPE_9);
                splitPackages.add(pk);

            }
        }
        opSalesOrderVO.setOpSoPackageVOs(splitPackages);
    }


}
*/
