package com.thebeastshop.pegasus.channelservice.adapter.favorite;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.cart.vo.Favorite;
import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.configuration.cond.ConfigCond;
import com.thebeastshop.configuration.service.ArticleService;
import com.thebeastshop.configuration.vo.SArticleVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.enums.FavoriteExtType;
import com.thebeastshop.support.vo.article.SimpleArticle;
import com.thebeastshop.support.vo.favorite.FavoriteVO;
import com.thebeastshop.support.vo.product.SimpleProductVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 收藏适配器
 *
 * @author Paul-xiong
 */
@Component
public class FavoriteAdapter {

	@Autowired
	private ArticleService articleService;

	@Autowired
	private ProductAdapter productAdapter;

	@Autowired
	private McPsProductService mcPsProductService;

	/**
	 * 获取收藏信息
	 *
	 * @param type
	 * @param favorites
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public List<FavoriteVO> getFavorite(FavoriteExtType type, Collection<Favorite> favorites, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {
		List<FavoriteVO> rt = Lists.newArrayList();
		if (CollectionUtils.isEmpty(favorites)) {
			return rt;
		}
		// 获取收藏详情
		Map<String, Object> detailsMap = getFavoriteDetailsMap(type, favorites, member, opChannel, accessWay);

		for (Favorite favorite : favorites) {
			Object item = detailsMap.get(favorite.getExtId().toString());
			if (null != item) {
				rt.add(new FavoriteVO(favorite.getId(), type, favorite.getCreateTime(), item));
			}
		}

		return rt;
	}

	/**
	 * 获取收藏的详细信息
	 *
	 * @param type
	 * @param favorites
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	private Map<String, Object> getFavoriteDetailsMap(FavoriteExtType type, Collection<Favorite> favorites,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		MemberLevelEnum MemberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
		List<String> productIds = Lists.newArrayList();
		List<Long> articleIds = Lists.newArrayList();
		Map<String, Object> detailsMap = new HashMap<>();
		for (Favorite favorite : favorites) {
			productIds.add(favorite.getExtId().toString());
			articleIds.add(favorite.getExtId());
		}

		switch (type) {
		case ARTICLE:
			ConfigCond configCond = new ConfigCond();
			configCond.setCurrpage(1);
			configCond.setPagenum(1000000);
			configCond.setIds(articleIds);
			PageQueryResp<SArticleVO> page = articleService.getOnlineArticleListByCond(configCond);
			if (null != page) {
				List<SArticleVO> articles = page.getBeanList();
				if (CollectionUtils.isNotEmpty(articles)) {
					for (SArticleVO article : articles) {
						detailsMap.put(article.getId().toString(), getSimpleArticleByArticle(article));
					}
				}
			}
			break;
		case PRODUCT:
			PsProductCond cond = new PsProductCond();
			cond.setIds(productIds);
			cond.setChannelCode(opChannel.getCode());
			cond.setPagenum(productIds.size());
			cond.setAccessWay(accessWay.getCode());
			cond.setMemberLevel(member.getMemberLevel());
			cond.setMatchCampaign(true);
			cond.setDiscount(MemberLevel.getLevelAmountCondition());

			
			List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
			if (CollectionUtils.isNotEmpty(products)) {
				Map<String, String> prodCodeMap = new HashMap<>();
				for (PsProductVO product : products) {
					prodCodeMap.put(product.getCode(), product.getId());
				}
				List<SimpleProductVO> simpleProducts = new ArrayList<>();
				if (CollectionUtils.isNotEmpty(products)) {
					simpleProducts = productAdapter.getSimpleProducts(products, member, opChannel, accessWay);
				}
				if (CollectionUtils.isNotEmpty(simpleProducts)) {
					for (SimpleProductVO simpleProduct : simpleProducts) {
						detailsMap.put(prodCodeMap.get(simpleProduct.getId()), simpleProduct);
					}
				}
			}
			break;
		default:
			break;
		}
		return detailsMap;
	}

	private SimpleArticle getSimpleArticleByArticle(SArticleVO article) {
		SimpleArticle simpleArticle = null;
		if (null != article) {
			simpleArticle = new SimpleArticle();
			String featureImage = Compatible(article.getFeatureImage().getSrc());
			simpleArticle.setFeatureImage(featureImage);
			simpleArticle.setId(article.getId());
			simpleArticle.setTitle(article.getTitle());
			simpleArticle.setBrief(article.getBrief());
		}
		return simpleArticle;
	}

	private String Compatible(String articleImage) {
		String simpleArticle = "";
		if (null != articleImage && !articleImage.equals("")) {
			if (articleImage.contains("src")) {
				JSONObject articleString = JSONObject.parseObject(articleImage);
				simpleArticle = articleString.getString("src");
			} else {
				simpleArticle = articleImage;
			}
		}
		return simpleArticle;
	}

}
