package com.thebeastshop.pegasus.channelservice.adapter.exchange;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.exchange.enums.ExchgTypeEnum;
import com.thebeastshop.exchange.service.ExchangeService;
import com.thebeastshop.exchange.vo.ExchgSpuConfigDetailVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigVO;
import com.thebeastshop.exchange.vo.MemberExchgVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.coupon.CouponAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SSkuPointExchangeStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.announcement.AnnouncementVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;
import com.thebeastshop.support.vo.cart.GroupsVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.exchange.ExchangeProductGoods;
import com.thebeastshop.support.vo.product.SpvVO;

/**
 * @author feilong.gao
 * @Date 2018/9/17 16:12.
 * @Description
 */
@Service
public class ExchangeShopCartAdapter {

	private static final Logger logger = LoggerFactory.getLogger(CouponAdapter.class);

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	@Autowired
	private ExchangeService exchangeService;

	@Autowired
	private SStockService stockService;

	@Autowired
	ExchangeProductGoodsDetailAdapter exchangeProductGoodsDetailAdapter;

	@Autowired
	PriceAdapter priceAdapter;

	@Autowired
	PrsPriceService prsPriceService;

	public CartVO getCart(List<RequestPack> requestPacks, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO channel) {
		CartVO cart = new CartVO();

		if (CollectionUtils.isEmpty(requestPacks)) {
			cart.setPacks(Lists.<CartProductPackVO> newArrayList());
			cart.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
		} else {
			MemberLevelEnum LevelEnum = MemberLevelEnum.getEnumByCode(member.getMemberLevel().intValue());
			List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks,
					accessWay, member, channel.getCode());
			List<String> referCodes = Lists.newArrayList();
			for (CartProductPack pack : prodPacks) {
				referCodes.add(pack.getProduct().getCode());
			}

			Map<String, ExchgSpuConfigVO> supConfigMap = this.getSupConfigMap(referCodes);

			List<CartProductPack> validPacks = Lists.newArrayList();
			List<CartProductPack> invalidPacks = Lists.newArrayList();
			this.separateInvalid(member.getCode(), prodPacks, validPacks, invalidPacks, LevelEnum, supConfigMap);

			cart.setInvalidPacks(
					cartProductPackAdapter.getInvalidCartProductPackList(invalidPacks, member, channel, accessWay));
			cart.setPacks(this.buildExchangeValidPackVOs(validPacks, member, channel, accessWay, supConfigMap));
		}

		return cart;
	}

	public List<CartProductPack> filterPackByByRequest(Boolean isValid, List<RequestPack> requestPacks, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO channel) {
		List<CartProductPack> invalidPacks = Lists.newArrayList();
		List<CartProductPack> validPacks = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(requestPacks)) {
			MemberLevelEnum LevelEnum = MemberLevelEnum.getEnumByCode(member.getMemberLevel().intValue());
			List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks,
					accessWay, member, channel.getCode());
			List<String> referCodes = Lists.newArrayList();
			for (CartProductPack pack : prodPacks) {
				referCodes.add(pack.getProduct().getCode());
			}
			Map<String, ExchgSpuConfigVO> supConfigMap = this.getSupConfigMap(referCodes);
			this.separateInvalid(member.getCode(), prodPacks, validPacks, invalidPacks, LevelEnum, supConfigMap);
		}
		if (isValid) {
			return validPacks;
		} else {
			return invalidPacks;
		}
	}

	public List<CartProductPackVO> buildPackVOsByRequest(List<RequestPack> requestPacks, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO channel) {
		List<CartProductPackVO> packs = Lists.newArrayList();

		if (CollectionUtils.isEmpty(requestPacks)) {
			return packs;
		}
		List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks, accessWay,
				member, channel.getCode());
		List<String> referCodes = Lists.newArrayList();
		for (CartProductPack pack : prodPacks) {
			referCodes.add(pack.getProduct().getCode());
		}
		Map<String, ExchgSpuConfigVO> supConfigMap = this.getSupConfigMap(referCodes);
		packs = this.buildExchangeValidPackVOs(prodPacks, member, channel, accessWay, supConfigMap);

		return packs;
	}

	/**
	 * 预览积分兑换购物车
	 *
	 * @param requestPacks
	 * @param member
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	public CartVO previewExchangeCart(List<RequestPack> requestPacks, MemberVO member, OpChannelVO channel,
			AccessWayEnum accessWay) {
		final CartVO rt = new CartVO();
		if (CollectionUtils.isEmpty(requestPacks)) {
			return rt;
		}
		List<CartProductPack> packs = cartProductPackAdapter.setProdAndSpv2CartProductPack(requestPacks, accessWay,
				member, channel.getCode());
		List<String> referCodes = Lists.newArrayList();
		for (CartProductPack pack : packs) {
			referCodes.add(pack.getProduct().getCode());
		}
		// 获取兑换配置Map信息
		Map<String, ExchgSpuConfigVO> supConfigMap = this.getSupConfigMap(referCodes);

		// 购物车预览价格计算结果
		PrsCalPackDto arg0 = new PrsCalPackDto();
		List<Integer> interestId = new ArrayList<>();
		Map<Long, InterestGoods> interestGoodsMap = new HashMap<>();
		priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, channel, accessWay, null, null,
				BigDecimal.ZERO, interestId, true, null, supConfigMap);
		PrsPacksPriceResultVO priceMap = prsPriceService.calculatePointDeduct4Preview(arg0);

		logger.info("积分兑换购物车预览价格查询 requestId={}", priceMap.getRequestId());
		List<PrsPriceStepVO> priceSteps = priceMap.getPriceStepVOs();

		// 邮费
		BigDecimal postage = BigDecimal.ZERO;
		Integer point = 0;
		if (CollectionUtils.isNotEmpty(priceSteps)) {
			for (PrsPriceStepVO priceStep : priceSteps) {
				if (priceStep.getPriceType().equals(PrsPriceTypeEnum.POINTS_EXCHANGE)) {
					point = priceStep.getPoints();
				}
			}
		}
		// 最终价格
		BigDecimal price = priceMap.getFinalTotalPrice();
		// 优惠价
		BigDecimal savedPrice = priceMap.getOriginalTotalPrice().subtract(priceMap.getFinalTotalPrice());

		List<CartProductPackVO> validPackVos = this.buildExchangeValidPackVOs(packs, member, channel, accessWay,
				supConfigMap);

		rt.setLabels(Lists.<Label> newArrayList());
		rt.setPacks(validPackVos);
		rt.setPostage(postage);
		rt.setPrice(price);
		rt.setPoint(point);
		rt.setSavedPrice(savedPrice);
		rt.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
		rt.setGroups(Lists.<GroupsVO> newArrayList());
		rt.setInterestPacks(Lists.<CartProductPackVO> newArrayList());
		rt.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());

		return rt;

	}

	private List<CartProductPackVO> buildExchangeValidPackVOs(List<CartProductPack> packs, MemberVO member,
			OpChannelVO channel, AccessWayEnum accessWay, Map<String, ExchgSpuConfigVO> supConfigMap) {
		if (CollectionUtils.isEmpty(packs)) {
			return Lists.newArrayList();
		}
		List<CartProductPackVO> result = Lists.newArrayList();

		for (CartProductPack pack : packs) {
			String productCode = pack.getProduct().getCode();
			ExchgSpuConfigVO supConfig = supConfigMap.get(productCode);
			ExchangeProductGoods exchangeProductGoods = exchangeProductGoodsDetailAdapter
					.getExchangeProductDetail(supConfig, member, channel, accessWay);
			CartProductPackVO packVO = new CartProductPackVO();
			Collection<SpvVO> spvVOS = exchangeProductGoods.getProduct().getVariant().getSpvs();
			packVO.setHasVariants(spvVOS.size() > 1);
			packVO.setSource(CartPackSource.RAW);
			packVO.setCount(pack.getCount());
			packVO.setId(pack.getId());
			packVO.setProductId(productCode);
			for (SpvVO spvVO : spvVOS) {
				if (pack.getSpvId().equals(spvVO.getId())) {
					packVO.setSpv(spvVO);
				}
			}
			result.add(packVO);
		}
		return result;
	}

	/**
	 * 获取兑换配置信息Map
	 *
	 * @param referCodes
	 * @return
	 */
	private Map<String, ExchgSpuConfigVO> getSupConfigMap(List<String> referCodes) {
		Map<String, ExchgSpuConfigVO> supConfigMap = new HashMap<>();
		List<ExchgSpuConfigVO> exchSupConfigs = exchangeService.queryExchgSpuConfigByReferenceCodes(referCodes);
		if (CollectionUtils.isNotEmpty(exchSupConfigs)) {
			for (ExchgSpuConfigVO supConfig : exchSupConfigs) {
				supConfigMap.put(supConfig.getReferenceCode(), supConfig);
			}
		}
		return supConfigMap;
	}

	/**
	 * 库存不足+已从积分商品配置后台下线的+会员等级不适用的 会员达到限购次数也是无效商品
	 *
	 * @param memberCode
	 * @param packs
	 * @param validPacks
	 * @param invalidPacks
	 * @param levelEnum
	 */
	public void separateInvalid(String memberCode, List<CartProductPack> packs, List<CartProductPack> validPacks,
			List<CartProductPack> invalidPacks, MemberLevelEnum levelEnum, Map<String, ExchgSpuConfigVO> supConfigMap) {

		Map<String, Integer> stockMap = getExchangeProductStockMap(supConfigMap.values());
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {
				String productCode = pack.getProduct().getCode();
				ExchgSpuConfigVO spuConfig = supConfigMap.get(productCode);
				Integer stock = stockMap.get(productCode);
				if (spuConfig == null || !spuConfig.getApplyMemberLevel().contains(levelEnum)
						|| NumberUtil.isNullOrZero(stock)) {
					invalidPacks.add(pack);
					// } else if(!canBuyByMember(memberCode,productCode)){
					// invalidPacks.add(pack);
				} else {
					validPacks.add(pack);
				}
			}
		}
	}

	private boolean canBuyByMember(String memberCode, String productCode) {

		Map<String, MemberExchgVO> memberExchgMap = exchangeProductGoodsDetailAdapter.getMemberExchangeMap(memberCode,
				productCode);
		if (null != memberExchgMap && !memberExchgMap.isEmpty()) {
			Integer remainExchangeNum = 0;
			for (MemberExchgVO memberExchgVO : memberExchgMap.values()) {
				remainExchangeNum += memberExchgVO.getRemainExchangeNum();
			}
			if (NumberUtil.isNullOrZero(remainExchangeNum)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 获取兑换商品库存信息 返回 map key=ReferenceCode value stock
	 *
	 * @param exchanges
	 * @return
	 */
	private Map<String, Integer> getExchangeProductStockMap(Collection<ExchgSpuConfigVO> exchanges) {
		Map<String, Integer> stockMap = new HashMap<>();
		if (CollectionUtils.isEmpty(exchanges))
			return stockMap;

		List<String> referenceSkuCodes = Lists.newArrayList();
		for (ExchgSpuConfigVO exchange : exchanges) {
			if (exchange.getExchangeType().equals(ExchgTypeEnum.SPU)) {
				for (ExchgSpuConfigDetailVO configDetail : exchange.getSpuConfigDetailList()) {
					referenceSkuCodes.add(configDetail.getSkuCode());
				}
			}
		}

		Map<String, Integer> stockSkuMap = new HashMap<>();
		ServiceResp<List<SSkuPointExchangeStockVO>> resp = stockService.getPointExchangeStocks(ExchgTypeEnum.SPU,
				referenceSkuCodes);
		if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getBean())) {
			for (SSkuPointExchangeStockVO exchangeStock : resp.getBean()) {
				stockSkuMap.put(exchangeStock.getReferenceCode(), exchangeStock.getCanUseQuantity());
			}
		}

		for (ExchgSpuConfigVO exchange : exchanges) {
			if (exchange.getExchangeType().equals(ExchgTypeEnum.SPU)) {
				int stock = 0;
				for (ExchgSpuConfigDetailVO configDetail : exchange.getSpuConfigDetailList()) {
					int skuStock = stockSkuMap.get(configDetail.getSkuCode()) == null ? 0
							: stockSkuMap.get(configDetail.getSkuCode());
					stock += skuStock;
				}
				stockMap.put(exchange.getReferenceCode(), stock);
			}
		}
		return stockMap;
	}

}
