package com.thebeastshop.pegasus.channelservice.adapter.exchange;

import com.google.common.collect.Lists;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.exchange.enums.ExchgConfigStatusEnum;
import com.thebeastshop.exchange.service.ExchangeActivityService;
import com.thebeastshop.exchange.service.ExchangeService;
import com.thebeastshop.exchange.vo.ExchgActivityVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigDetailVO;
import com.thebeastshop.exchange.vo.ExchgSpuConfigVO;
import com.thebeastshop.exchange.vo.MemberExchgVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.product.ProductAdapter;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McOpProdDynmcontDetailsService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.stock.service.SStockService;
import com.thebeastshop.stock.vo.SSkuPointExchangeStockVO;
import com.thebeastshop.support.enums.exchange.ExchangeGoodsClassify;
import com.thebeastshop.support.util.DateUtil;
import com.thebeastshop.support.vo.exchange.ExchangeProductGoods;
import com.thebeastshop.support.vo.product.ProductVO;
import com.thebeastshop.support.vo.product.ProductVariantVO;
import com.thebeastshop.support.vo.product.SpvVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author feilong.gao
 * @Date 2018/5/23 16:52.
 * @Description
 */
@Component
public class ExchangeProductGoodsDetailAdapter {


    @Autowired
    private McPsProductService mcPsProductService;

    @Autowired
    private SStockService stockService;

    @Autowired
    private ProductAdapter productAdapter;

    @Autowired
    private McOpProdDynmcontDetailsService mcOpProdDynmcontDetailsService;
    @Autowired
    private ExchangeService exchangeService;

    @Autowired
    ExchangeActivityService exchangeActivityService;

    public ExchangeProductGoods getExchangeProductDetail(ExchgSpuConfigVO exchange, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {

        if (null == exchange) {
            return null;
        }
        String productCode = exchange.getReferenceCode();
        MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());
        PsMatchCampaignCond cond = new PsMatchCampaignCond();
        cond.setMatchCampaign(true);
        cond.setChannelCode(opChannel.getCode());
        cond.setAccessWay(accessWay.getCode());
        cond.setMemberLevel(memberLevel.getCode());
        cond.setDiscount(memberLevel.getLevelAmountCondition());
        cond.setBdDiscount(member.getBdayDiscountRatio());
        PsProductVO product = mcPsProductService.getProductDetailByCode(opChannel.getCode(), productCode, cond);
        ProductVO productVO = productAdapter.getProduct(product, member, opChannel, accessWay);
        Map<String, Integer> skuStockMap = this.getExchangeProductStockMap(exchange);
        Map<String, MemberExchgVO> skuMemberExchgMap = getMemberExchangeMap(member.getCode(), productCode);
        return buildExchangeProductDetail(productVO, exchange, skuStockMap, skuMemberExchgMap);
    }

    public Map<String, MemberExchgVO> getMemberExchangeMap(String memberCode, String productCode) {
        Map<String, MemberExchgVO> skuMemberExchgMap = new HashMap<>();
        List<MemberExchgVO> memberExchgs = exchangeService.queryMemberExchg(memberCode, productCode);
        for (MemberExchgVO memberExchg : memberExchgs) {
            skuMemberExchgMap.put(memberExchg.getSkuCode(), memberExchg);
        }
        return skuMemberExchgMap;
    }
//
//    private Map<Long, Integer> getSpvStockMap(ExchgSpuConfigVO exchange, PsProductVO product) {
//        Map<String, Integer> stockMap = getExchangeProductStockMap(exchange);
//        Map<Long, Integer> spvStockMap = new HashMap<>();
//        for (PsSpvVO spvVO : product.getSpvList()) {
//            spvStockMap.put(spvVO.getSpvId(), stockMap.get(spvVO.getSkuCode()) == null ? 0 : stockMap.get(spvVO.getSkuCode()));
//        }
//        return spvStockMap;
//    }


    /**
     * 获取兑换商品库存信息
     * 返回 map key=ReferenceCode value stock
     *
     * @param exchange
     * @return
     */
    private Map<String, Integer> getExchangeProductStockMap(ExchgSpuConfigVO exchange) {
        Map<String, Integer> stockMap = new HashMap<>();
        if (null == exchange) return stockMap;
        List<String> referenceCodes = Lists.newArrayList();

        switch (exchange.getExchangeType()) {
            case SPU:
                for (ExchgSpuConfigDetailVO configDetail : exchange.getSpuConfigDetailList()) {
                    referenceCodes.add(configDetail.getSkuCode());
                }
                break;
            case COUPON:
                referenceCodes.add(exchange.getReferenceCode());
                break;
            case THIRD_COUPON:
                referenceCodes.add(exchange.getReferenceCode());
                break;
        }
        ServiceResp<List<SSkuPointExchangeStockVO>> resp = stockService.getPointExchangeStocks(exchange.getExchangeType(), referenceCodes);
        if (resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getBean())) {
            for (SSkuPointExchangeStockVO exchangeStock : resp.getBean()) {
                stockMap.put(exchangeStock.getReferenceCode(), exchangeStock.getCanUseQuantity());
            }
        }
        return stockMap;
    }

    /**
     * 商品对象构建
     *
     * @param product
     * @return
     */
    private ExchangeProductGoods buildExchangeProductDetail(ProductVO product, ExchgSpuConfigVO spuConf, Map<String, Integer> stockMap, Map<String, MemberExchgVO> memberExchgMap) {
        ExchangeProductGoods basic = new ExchangeProductGoods();
        basic.setClassify(ExchangeGoodsClassify.PRODUCT);
        basic.setOnline(ExchgConfigStatusEnum.ONLINE.equals(spuConf.getStatus()));
        basic.setMode(spuConf.getExchangeMode().name());
        basic.setId(spuConf.getId().intValue());
        basic.setCode(spuConf.getCode());
        List<Integer> levels = new ArrayList<>();
        for (MemberLevelEnum levelEnum : spuConf.getApplyMemberLevel()) {
            levels.add(levelEnum.getCode());
        }
        basic.setLevelIds(levels);
        basic.setPoint(spuConf.getExchgAmount());
        basic.setExchangePrice(spuConf.getExchgPrice());
        basic.setTotal(spuConf.getTotalStock());
        if (null != stockMap && !stockMap.isEmpty()) {
            Integer stock = 0;
            for (Integer s : stockMap.values()) {
                stock += s;
            }
            if (NumberUtil.isNullOrZero(stock) || stock<0) {
                basic.setSoldOut(Boolean.TRUE);
            }
        }

        Map<String, ExchgSpuConfigDetailVO> supConfigMap = new HashMap<>();
        for (ExchgSpuConfigDetailVO configDetailVO : spuConf.getSpuConfigDetailList()) {
            supConfigMap.put(configDetailVO.getSkuCode(), configDetailVO);
        }

        if (product != null) {
            product.setSoldOut(basic.getSoldOut());
            ProductVariantVO variant = product.getVariant();
            if (variant != null && CollectionUtils.isNotEmpty(variant.getSpvs())) {
                for (SpvVO spvVO : variant.getSpvs()) {
                    String skuCode = spvVO.getSkuCodes().get(0);
                    int left = stockMap.get(skuCode) == null ? 0 : stockMap.get(skuCode);
                    spvVO.setLeft(left);
                    SpvVO.Quota quota = new SpvVO.Quota();
                    MemberExchgVO memberExchg = memberExchgMap.get(skuCode);
                    if (null != memberExchg) {
                        Integer remainLeft = memberExchg.getRemainExchangeNum();
                        if(NumberUtil.isNullOrZero(remainLeft) || remainLeft<0){
                            remainLeft = 0;
                        }
                        quota.setLeft(remainLeft);
                        quota.setTotal(memberExchg.getLimitPerMember());
                    }
                    ExchgSpuConfigDetailVO spuConfigDetail = supConfigMap.get(skuCode);
                    spvVO.setQuota(quota);
                    spvVO.setPoint(spuConfigDetail.getExchangeAmount());
                    if(null != spuConfigDetail.getExchangePrice()){
                        spvVO.setPointPrice(spvVO.getRawPrice().setScale(2, BigDecimal.ROUND_HALF_UP).subtract(spuConfigDetail.getExchangePrice().setScale(2,BigDecimal.ROUND_HALF_UP)));
                    }
                    spvVO.setLevelIds(levels);
                    spvVO.setMinAmount(1);        // 最小购买数量设置为1
                }
            }
            basic.setTips(this.getExchangeGoodsTips());
            // 是否编辑过
            product.setLegacyDetails(!mcOpProdDynmcontDetailsService.IsEditByProdCode(spuConf.getReferenceCode()));
            basic.setProduct(product);

        }
        return basic;
    }

    /**
     * 获取配上日期
     * @return
     */
    private String getExchangeGoodsTips(){
        String tips = "";
        Date deliveryDate = getExchangeDeliveryDate();
        if(deliveryDate != null){
            String deliveryDateStr = DateUtil.format(deliveryDate,"MM月dd日");
            tips = "积分兑换商品，统一"+deliveryDateStr+"发货";
        }
        return tips;
    }
    
    /**
     * 获取配送日期
     * @return
     */
    public Date getExchangeDeliveryDate(){
    	Date deliveryDate = null;
        ServiceResp<ExchgActivityVO> exchgActivity  = exchangeActivityService.queryCurrentActivity();
        if(exchgActivity.isSuccess()){
            Integer addDay = Integer.parseInt(PropConstants.getProperties("exchange_product_add_delivery_day","2"));
            deliveryDate = DateUtil.addDay(exchgActivity.getBean().getEndTime(),addDay);
            

        }
        return deliveryDate;
    }
}
