package com.thebeastshop.pegasus.channelservice.adapter.coupon;

import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.coupon.service.CpCouponSampleThirdPartyService;
import com.thebeastshop.coupon.vo.CpCouponSampleThirdPartyVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.vo.OpCouponCodeVO;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.coupon.CouponVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 线下券
 * Created by feilong.gao on 2017/3/21.
 */
@Component
public class OfflineCouponAdapter {


    private PegasusOperationServiceFacade instance = PegasusOperationServiceFacade.getInstance();

    @Autowired
    private CpCouponSampleThirdPartyService cpCouponSampleThirdPartyService;

    /**
     * 获取线下优惠券
     * @param memberId
     * @param status (1:未使用;2:已使用;3:已过期)
     * @return
     */
    public List<CouponVO> getOfflineCoupon(Long memberId, Long status){
        List<CouponVO> couponVOs = Lists.newArrayList();
        List<OpCouponCodeVO> opCouponCodeVOs = instance.selectCouponCodeByMemberId(memberId,status);
        couponVOs.addAll(convertOpCouponCodeVo2CouponVO(opCouponCodeVOs,status));
        List<CpCouponSampleThirdPartyVO> couponSampleThirdPartyVOList = cpCouponSampleThirdPartyService.getCoupons(memberId, status.intValue());
        couponVOs.addAll(convertCouponSampleThirdParty2CouponVO(couponSampleThirdPartyVOList, status));
        return couponVOs;
    }


    /**
     * 老线下券转app优惠券展示对象
     * @param sourceObjs
     * @param status (1:未使用;2:已使用;3:已过期)
     * @return
     */
    private List<CouponVO> convertOpCouponCodeVo2CouponVO(List<OpCouponCodeVO> sourceObjs,Long status){
        List<CouponVO> targetObjs = Lists.newArrayList();
        if(CollectionUtils.isEmpty(sourceObjs)){
            return targetObjs;
        }
        for(OpCouponCodeVO sourceObj:sourceObjs){
            CouponVO targetObj = new CouponVO();
            targetObj.setId(sourceObj.getId());
            targetObj.setProductDesc(sourceObj.getLimitDesc());
            targetObj.setDescription(sourceObj.getRuleDesc());
            targetObj.setCode(sourceObj.getCode());
            targetObj.setExpireTime(sourceObj.getEndTime());
            targetObj.setStartTime(sourceObj.getStartTime());
            targetObj.setTitle(sourceObj.getRuleName());
            targetObj.setType(CouponVO.CouponTypeVO.OFFLINE);
            targetObj.setTag("");
            if(StringUtils.isNotBlank(sourceObj.getLogoImg())){
                targetObj.setPartnerLogo(FileConstant.BASE_URL+sourceObj.getLogoImg());
            }
            if(status.equals(1L)){
                targetObj.setUsed(false);
                targetObj.setUsable(true);
                targetObj.setExpired(false);
            }
            if(status.equals(2L)){
                targetObj.setUsed(true);
                targetObj.setUsable(false);
                targetObj.setExpired(false);
            }
            if(status.equals(3L)){
                targetObj.setUsed(false);
                targetObj.setUsable(false);
                targetObj.setExpired(true);
            }
            targetObjs.add(targetObj);
        }
        return targetObjs;
    }

    /**
     * BD线下券转app优惠券展示对象
     * @param sourceObjs
     * @param status (1:未使用;2:已使用;3:已过期)
     * @return
     */
    private List<CouponVO> convertCouponSampleThirdParty2CouponVO(List<CpCouponSampleThirdPartyVO> sourceObjs,Long status){
        List<CouponVO> targetObjs = Lists.newArrayList();
        if(CollectionUtils.isEmpty(sourceObjs)){
            return targetObjs;
        }
        for(CpCouponSampleThirdPartyVO sourceObj:sourceObjs){
            CouponVO targetObj = new CouponVO();
            targetObj.setId(sourceObj.getId());
            targetObj.setProductDesc(sourceObj.getProductDesc());
            targetObj.setCode(sourceObj.getCode());
            targetObj.setExpireTime(sourceObj.getExpireTime());
            targetObj.setStartTime(sourceObj.getStartTime());
            targetObj.setTitle(sourceObj.getTitle());
            targetObj.setExpired(DateUtil.termOfValidity(sourceObj.getStartTime(),sourceObj.getExpireTime()));
            targetObj.setType(CouponVO.CouponTypeVO.OFFLINE);
            targetObj.setCreateTime(sourceObj.getCreateTime());
            targetObj.setDescription(sourceObj.getDescription());
            targetObj.setTag("");
            if(StringUtils.isNotBlank(sourceObj.getLogoImg())){
                targetObj.setPartnerLogo(FileConstant.BASE_URL+sourceObj.getLogoImg());
            }
            if(status.equals(1L)){
                targetObj.setUsed(false);
                targetObj.setUsable(true);
                targetObj.setExpired(false);
            }
            if(status.equals(2L)){
                targetObj.setUsed(true);
                targetObj.setUsable(false);
                targetObj.setExpired(false);
            }
            if(status.equals(3L)){
                targetObj.setUsed(false);
                targetObj.setUsable(true);
                targetObj.setExpired(true);
            }
            targetObjs.add(targetObj);
        }
        return targetObjs;
    }

    /**
     * 获取线下券数量
     * @param memberId
     * @param status (1:未使用;2:已使用;3:已过期)
     * @return
     */
    public Integer getOfflineCouponSize(Long memberId,Long status){
        Integer count = 0;
        List<OpCouponCodeVO> opCouponCodeVOs = instance.selectCouponCodeByMemberId(memberId,status);
        if(CollectionUtils.isNotEmpty(opCouponCodeVOs)){
            count += opCouponCodeVOs.size();
        }
        List<CpCouponSampleThirdPartyVO> couponSampleThirdPartyVOList = cpCouponSampleThirdPartyService.getCoupons(memberId, status.intValue());
        if(CollectionUtils.isNotEmpty(couponSampleThirdPartyVOList)){
            count += couponSampleThirdPartyVOList.size();
        }
        return count;
    }
}
