package com.thebeastshop.pegasus.channelservice.adapter.coupon;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.coupon.dto.CpCouponSampleProductCondDto;
import com.thebeastshop.coupon.dto.CpCouponSampleProductDetailCondDto;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.cart.RequestPack;

/**
 * 带商品包优惠券校验、查询类
 * 
 * @author wyw
 */
@Component
public class CouponCheckAdapter {

	private static final Logger logger = LoggerFactory.getLogger(CouponAdapter.class);

	@Autowired
	private CartService cartService;

	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private PrsPriceService prsPriceService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	/**
	 * 优惠券查询入参组装
	 * 
	 */
	public CpCouponSampleProductCondDto assambleDto(List<RequestPack> sourcePackVOs, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO opChannel) {

		CpCouponSampleProductCondDto result = new CpCouponSampleProductCondDto();

		if (CollectionUtils.isNotEmpty(sourcePackVOs)) {

			List<CartProductPack> packs = Lists.newArrayList();

			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : sourcePackVOs) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}

			if (CollectionUtils.isNotEmpty(packs)) {
				PrsCalPackDto arg0 = new PrsCalPackDto();
				List<Integer> interestId = new ArrayList<Integer>();
				Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
				priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null,
						null, BigDecimal.ZERO, interestId, true, null, null);

				// 购物车预览价格计算结果
				logger.info("购物车预览价格查询");
				PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4Cart(arg0);

				logger.info("购物车预览价格查询 requestId={}", priceMap.getRequestId());
				Map<Long, BigDecimal> spvPrice = priceMap.getSpvPriceMap();

				result.setMemberId(member.getId());
				result.setExpert(false);
				result.setValid(1);
				result.setUsed(0);
				List<String> accessWayIds = new ArrayList<>();
				accessWayIds.add(accessWay.getCode().toString());
				result.setAccessWayIds(accessWayIds);
				result.setChannelCode(opChannel.getCode());
				List<CpCouponSampleProductDetailCondDto> cpCouponSampleProductDetailDtos = null;

				cpCouponSampleProductDetailDtos = new ArrayList<>();
				boolean is_cross_border = false;
				boolean is_week_flower = false;
				for (ProductPack pack : packs) {

					if (pack.getProduct().getCrossBorderFlag() != null && pack.getProduct().getCrossBorderFlag() == 1) {
						is_cross_border = true;
					}

					if (pack.getProduct().getIsMonthSend() != null && pack.getProduct().getIsMonthSend() == 1) {
						is_week_flower = true;
					}
					CpCouponSampleProductDetailCondDto dto = new CpCouponSampleProductDetailCondDto();
					BigDecimal pr = BigDecimal.ZERO;
					if (pack.getSource().equals(CartPackSourceEnum.BENEFIT) && spvPrice.containsKey(-pack.getSpvId())) {
						pr = spvPrice.get(-pack.getSpvId());
					} else if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
						pr = spvPrice.get(pack.getSpvId());
					}

					if (pr.compareTo(BigDecimal.ZERO) != 0) {
//						dto = new CpCouponSampleProductDetailCondDto(Long.valueOf(pack.getProduct().getId()),
//								pack.getProduct().getCategoryId(), pr, pack.getCount(), is_cross_border,
//								is_week_flower);
//						cpCouponSampleProductDetailDtos.add(dto);
					}

				}
				result.setCpCouponSampleProductDetailDtos(cpCouponSampleProductDetailDtos);
			} else {
				return null;
			}
		}
		return result;
	}

}
