package com.thebeastshop.pegasus.channelservice.adapter.coupon;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.coupon.dto.CpCouponSampleProductCondDto;
import com.thebeastshop.coupon.enums.CpCouponTypeEnum;
import com.thebeastshop.coupon.service.CpCouponSampleService;
import com.thebeastshop.coupon.service.CpCouponService;
import com.thebeastshop.coupon.vo.*;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.cart.CartProductPackAdapter;
import com.thebeastshop.pegasus.channelservice.model.CalculateProductPackDTO;
import com.thebeastshop.pegasus.channelservice.service.CouponSampleVerifyService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.coupon.CouponVO;
import com.thebeastshop.support.vo.coupon.CouponVO.CouponTypeVO;
import com.thebeastshop.support.vo.coupon.CouponVO.DiscountType;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Paul-xiong
 */
@Component
public class CouponAdapter {

	private static final Logger logger = LoggerFactory.getLogger(CouponAdapter.class);

	@Autowired
	private CartService cartService;

	@Autowired
	private CouponCheckAdapter couponCheckAdapter;

	@Autowired
	private PriceService priceService;

	@Autowired
	private CouponSampleVerifyService couponSampleVerifyService;

	@Autowired
	private CpCouponSampleService cpCouponSampleService;

	@Autowired
	private CpCouponService cpCouponService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdapter;

	public CouponVO getCoupon(CpCouponVO couponVO) {

		CouponVO rt = null;
		CpCouponSampleVO couponSampleVO = couponVO.getCouponSample();
		if (couponSampleVO == null) {
			couponSampleVO = cpCouponSampleService.getCouponSampleById(couponVO.getCouponSampleId());
			couponVO.setCouponSample(couponSampleVO);
		}
		if (couponSampleVO != null) {
			if (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
				rt = new CouponVO();
				CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) couponVO.getCouponSample().getCouponContent();
				rt.setId(couponVO.getId());
				rt.setStartTime(couponVO.getStartTime());
				rt.setCreateTime(couponVO.getCreateTime());
				rt.setExpireTime(couponVO.getExpireTime());
				rt.setTitle(couponSampleVO.getTitle());
				rt.setDescription(couponSampleVO.getDescription());
				rt.setProductDesc(couponSampleVO.getProductDesc());
				rt.setThreshold(fullCutCoupon.getFullPrice());

				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(fullCutCoupon.getCutPrice());
				rt.setCode(couponVO.getCode());

				this.setCouponType(rt, couponSampleVO);

				String skipValue = couponSampleVO.getSkipValue();
				Integer skipType = couponSampleVO.getSkipType();
				rt.setDeeplink(null);
				String deeplink = "";
				if (null != skipValue && null != skipType) {
					switch (skipType) {
					case 1:// 默认列表
						rt.setDeeplink("beastapp://search?new=1&title=新鲜上架");
						break;
					case 2:// 内容页
						rt.setDeeplink("beastapp://article/" + skipValue);
						break;
					case 3:// 活动页
						rt.setDeeplink(skipValue);
						break;
					}
				}

				rt.setNote(couponSampleVO.getNote());
				rt.setUsed(couponVO.getUsed());
				rt.setUsable(couponVO.getIsAvailable());
				rt.setExpired(couponVO.getIsExpired());
				// rt.setIcon("¥");
				rt.setTag("");
				rt.setExpired(couponVO.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSampleVO.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			} else if (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.DISCOUNT_LINE.getId())) {
				rt = new CouponVO();
				CpFullDiscountVO fullCutCoupon = (CpFullDiscountVO) couponVO.getCouponSample().getCouponContent();
				rt.setId(couponVO.getId());
				rt.setStartTime(couponVO.getStartTime());
				rt.setCreateTime(couponVO.getCreateTime());
				rt.setExpireTime(couponVO.getExpireTime());
				rt.setTitle(couponSampleVO.getTitle());
				rt.setDescription(couponSampleVO.getDescription());
				rt.setProductDesc(couponSampleVO.getProductDesc());
				rt.setThreshold(fullCutCoupon.getFullPrice());

				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(BigDecimal.ZERO);
				rt.setDiscountRatio(fullCutCoupon.getDiscount().divide(BigDecimal.valueOf(10)));
				rt.setCode(couponVO.getCode());

				this.setCouponType(rt, couponSampleVO);

				String skipValue = couponSampleVO.getSkipValue();
				Integer skipType = couponSampleVO.getSkipType();
				rt.setDeeplink(null);
				String deeplink = "";
				if (null != skipValue && null != skipType) {
					switch (skipType) {
					case 1:// 默认列表
						rt.setDeeplink("beastapp://search?new=1&title=新鲜上架");
						break;
					case 2:// 内容页
						rt.setDeeplink("beastapp://article/" + skipValue);
						break;
					case 3:// 活动页
						rt.setDeeplink(skipValue);
						break;
					}
				}

				rt.setNote(couponSampleVO.getNote());
				rt.setUsed(couponVO.getUsed());
				rt.setUsable(couponVO.getIsAvailable());
				rt.setExpired(couponVO.getIsExpired());
				// rt.setIcon("");
				rt.setTag("折");
				rt.setExpired(couponVO.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSampleVO.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			} else if (couponSampleVO.getCouponTypeId().equals(CpCouponTypeEnum.FIXEDPRICE_LINE.getId())) {
				rt = new CouponVO();
				CpFixedPriceVO fullCutCoupon = (CpFixedPriceVO) couponVO.getCouponSample().getCouponContent();
				rt.setId(couponVO.getId());
				rt.setStartTime(couponVO.getStartTime());
				rt.setCreateTime(couponVO.getCreateTime());
				rt.setExpireTime(couponVO.getExpireTime());
				rt.setTitle(couponSampleVO.getTitle());
				rt.setDescription(couponSampleVO.getDescription());
				rt.setProductDesc(couponSampleVO.getProductDesc());
				// rt.setThreshold(fullCutCoupon.getFullPrice());

				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(fullCutCoupon.getFixedPrice());
				rt.setCode(couponVO.getCode());

				this.setCouponType(rt, couponSampleVO);

				String skipValue = couponSampleVO.getSkipValue();
				Integer skipType = couponSampleVO.getSkipType();
				rt.setDeeplink(null);
				String deeplink = "";
				if (null != skipValue && null != skipType) {
					switch (skipType) {
					case 1:// 默认列表
						rt.setDeeplink("beastapp://search?new=1&title=新鲜上架");
						break;
					case 2:// 内容页
						rt.setDeeplink("beastapp://article/" + skipValue);
						break;
					case 3:// 活动页
						rt.setDeeplink(skipValue);
						break;
					}
				}
				// rt.setIcon("¥");
				rt.setTag("专享价");
				rt.setNote(couponSampleVO.getNote());
				rt.setUsed(couponVO.getUsed());
				rt.setUsable(couponVO.getIsAvailable());
				rt.setExpired(couponVO.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSampleVO.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			}

		}
		return rt;
	}

	/**
	 * 设置couponType
	 * 
	 * @param rt
	 * @param couponSampleVO
	 */
	private void setCouponType(CouponVO rt, CpCouponSampleVO couponSampleVO) {
		List<Integer> accessWays = couponSampleVO.getAccessWayIds();
		Boolean isOffLine = false;
		Boolean isOnLine = false;
		for (Integer accessWay : accessWays) {
			if (AccessWayEnum.OFFLINE.getCode().equals(accessWay)
					|| AccessWayEnum.LITTLE_B.getCode().equals(accessWay)) {
				isOffLine = true;
			} else {
				isOnLine = true;
			}
		}

		if (isOffLine) {
			rt.setType(CouponTypeVO.OFFLINE);
			if (isOnLine) {
				rt.setType(CouponTypeVO.GENERAL);
			}
		} else {
			rt.setType(CouponTypeVO.COUPON);
		}
	}

	/**
	 * 批量获取优惠券
	 *
	 * @param coupons
	 * @return
	 */
	public List<CouponVO> getCouponList(List<CpCouponVO> coupons) {
		List<CouponVO> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(coupons)) {
			for (CpCouponVO coupon : coupons) {
				rt.add(getCoupon(coupon));
			}
		}
		return rt;
	}

	/**
	 * 校验优惠券是否可用于指定商品
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param couponId
	 * @param accessWay
	 * @return
	 */
	@Deprecated
	public boolean checkUsableCouponForProducts(List<RequestPack> sourcePackVOs, MemberVO member, long couponId,
			AccessWayEnum accessWay, OpChannelVO opChannel) {

		List<? extends ProductPack> productPacks = this.convertCartProductPackByCartProductPackVO(sourcePackVOs, member,
				accessWay, opChannel);
		ServiceResp<CpCouponVO> rsp = cpCouponService.checkCoupon(couponId, member.getId(), opChannel.getCode());
		if (rsp == null || rsp.getBean() == null) {
			return false;
		}
		CpCouponVO coupon = rsp.getBean();
		CpCouponSampleVO couponSample = cpCouponSampleService.getCouponSampleById(coupon.getCouponSampleId());

		boolean flag = couponSampleVerifyService.verifySampleUsableForProducts(productPacks, couponSample, accessWay);
		logger.info("checkUsableCouponForProducts={},couponId={},accessWay={}", flag, couponId, accessWay);
		return flag;
	}

	/**
	 * 校验优惠券是否可用于指定商品
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param couponId
	 * @param accessWay
	 * @return
	 */
//	public boolean checkUseCouponForProducts(List<RequestPack> sourcePackVOs, MemberVO member, long couponId,
//			AccessWayEnum accessWay, OpChannelVO opChannel) {
//		logger.info("checkUseCouponForProducts start");
//
//		logger.info("checkUseCouponForProducts,couponId={},accessWay={}", couponId, accessWay);
//		List<? extends ProductPack> productPacks = this.convertCartProductPackByCartProductPackVO(sourcePackVOs, member,
//				accessWay, opChannel);
//
//		CpCouponSampleProductCondDto cond = new CpCouponSampleProductCondDto();
//		cond.setMemberId(member.getId());
//		cond.setExpert(false);
//		cond.setValid(1);
//		cond.setUsed(0);
//		if (couponId > 0) {
//			cond.setCouponId(couponId);
//		}
//
//		List<String> accessWayIds = new ArrayList<>();
//		accessWayIds.add(accessWay.getCode().toString());
//		cond.setAccessWayIds(accessWayIds);
//		List<CpCouponSampleProductDetailCondDto> cpCouponSampleProductDetailDtos = null;
//
//		if (CollectionUtils.isNotEmpty(productPacks)) {
//
//			cpCouponSampleProductDetailDtos = new ArrayList<>();
//
//			boolean is_cross_border = false;
//			boolean is_week_flower = false;
//			for (ProductPack pack : productPacks) {
//
//				if (pack.getProduct().getCrossBorderFlag() != null && pack.getProduct().getCrossBorderFlag() == 1) {
//					is_cross_border = true;
//				}
//
//				if (pack.getProduct().getIsMonthSend() != null && pack.getProduct().getIsMonthSend() == 1) {
//					is_week_flower = true;
//				}
//
//				CpCouponSampleProductDetailCondDto dto = new CpCouponSampleProductDetailCondDto(
//						Long.valueOf(pack.getProduct().getId()), pack.getProduct().getCategoryId(), pack.getPrice(),
//						pack.getCount(), is_cross_border, is_week_flower);
//
//				if (pack.getSource().equals(CartPackSource.BENEFIT)) {
//					dto = new CpCouponSampleProductDetailCondDto(Long.valueOf(pack.getProduct().getId()),
//							pack.getProduct().getCategoryId(), pack.getSpv().getSalesPrice(), pack.getCount(),
//							is_cross_border, is_week_flower);
//				}
//				// CpCouponSampleProductDetailCondDto dto = new
//				// CpCouponSampleProductDetailCondDto(
//				// Long.valueOf(pack.getProduct().getId()),
//				// pack.getProduct().getCategoryId(),
//				// pack.getFactProductPrice(), pack.getCount(), is_cross_border,
//				// is_week_flower);
//
//				cpCouponSampleProductDetailDtos.add(dto);
//
//			}
//
//			cond.setCpCouponSampleProductDetailDtos(cpCouponSampleProductDetailDtos);
//		}
//
//		Set<CpCouponCustomVO> coupons = cpCouponService.getCouponByShoppingProducts(cond);
//		if (CollectionUtils.isNotEmpty(coupons)) {
//
//			return true;
//		}
//		logger.info("没有可用的优惠卷");
//
//		return false;
//	}

//	public CouponResponse iposCheckUseCouponForProducts(List<RequestPack> sourcePackVOs, MemberVO member, Long couponId,
//			AccessWayEnum accessWay, OpChannelVO opChannel) {
//		CpCouponSampleProductCondDto cond = new CpCouponSampleProductCondDto();
//		cond.setMemberId(member.getId());
//		cond.setExpert(false);
//		cond.setValid(1);
//		cond.setUsed(0);
//		cond.setCouponId(couponId);
//		cond.setAccessWayIds(Lists.newArrayList(accessWay.getCode() + ""));
//		List<? extends ProductPack> productPacks = convertCartProductPackByCartProductPackVO(sourcePackVOs, member,
//				accessWay, opChannel);
//		if (CollectionUtils.isNotEmpty(productPacks)) {
//			List<CpCouponSampleProductDetailCondDto> cpCouponSampleProductDetailDtos = Lists.newArrayList();
//			boolean is_cross_border = false;
//			boolean is_week_flower = false;
//			for (ProductPack pack : productPacks) {
//				if (pack.getProduct().getCrossBorderFlag() != null && pack.getProduct().getCrossBorderFlag() == 1) {
//					is_cross_border = true;
//				}
//				if (pack.getProduct().getIsMonthSend() != null && pack.getProduct().getIsMonthSend() == 1) {
//					is_week_flower = true;
//				}
//				cpCouponSampleProductDetailDtos.add(new CpCouponSampleProductDetailCondDto(
//						Long.valueOf(pack.getProduct().getId()), pack.getProduct().getCategoryId(),
//						pack.getFactProductPrice(), pack.getCount(), is_cross_border, is_week_flower));
//			}
//			cond.setCpCouponSampleProductDetailDtos(cpCouponSampleProductDetailDtos);
//		}
//		return cpCouponService.getCouponByShoppingProductsForIPos(cond);
//	}

	/**
	 * 获取可用优惠券
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param accessWay
	 * @return
	 */

	public List<CouponVO> getUsableCouponByMember(List<RequestPack> sourcePackVOs, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO opChannel) {
		List<CpCouponVO> coupons = cpCouponService.getUsableCoupons(member.getId());
		return this.getUsableCouponForCoupons(sourcePackVOs, member, coupons, accessWay, opChannel);
	}

	/**
	 * 获取可用优惠券
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param accessWay
	 * @return
	 */

	public List<CouponVO> getUsableCoupons(List<RequestPack> sourcePackVOs, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO opChannel) {

		List<CouponVO> result = Lists.newArrayList();

		CpCouponSampleProductCondDto cond = new CpCouponSampleProductCondDto();

		if (CollectionUtils.isNotEmpty(sourcePackVOs)) {
			cond = couponCheckAdapter.assambleDto(sourcePackVOs, member, accessWay, opChannel);

		} else {
			logger.info("没有主品，没有可用的优惠卷");
			return result;
		}
		if (null == cond) {

			logger.info("没有主品，没有可用的优惠卷");
			return result;
		}

		List<CpCouponCustomVO> coupons = cpCouponService.getCouponByShoppingProducts(cond);

		// 组装前端需要的对像
		for (CpCouponCustomVO coupon : coupons) {

			CouponVO couponVO = new CouponVO();

			couponVO.setId(coupon.getId());
			couponVO.setStartTime(coupon.getStartTime());
			couponVO.setCreateTime(coupon.getCreateTime());
			couponVO.setExpireTime(coupon.getExpireTime());
			couponVO.setTitle(coupon.getTitle());
			couponVO.setDescription(coupon.getDescription());
			couponVO.setProductDesc(coupon.getProductDesc());
			couponVO.setThreshold(coupon.getThreshold());
			couponVO.setThresholdDesc(coupon.getThresholdDesc());
			couponVO.setDiscount(coupon.getDiscount());
			couponVO.setNote(coupon.getNote());
			couponVO.setUsed(coupon.getUsed());
			couponVO.setUsable(coupon.getUsable());
			couponVO.setExpired(coupon.getExpired());

			if (coupon.getCouponTypeEnum().getId() == CpCouponTypeEnum.CHEAPEN_LINE.getId()) {
				// couponVO.setIcon("¥");
				couponVO.setTag("");
			} else if (coupon.getCouponTypeEnum().getId() == CpCouponTypeEnum.DISCOUNT_LINE.getId()) {
				couponVO.setTag("折");
				// couponVO.setIcon("");
				couponVO.setDiscount(BigDecimal.ZERO);
				couponVO.setDiscountRatio(coupon.getDiscount().divide(BigDecimal.valueOf(10)));
			} else if (coupon.getCouponTypeEnum().getId() == CpCouponTypeEnum.FIXEDPRICE_LINE.getId()) {
				// couponVO.setIcon("¥");
				couponVO.setTag("专享价");
			}

			DiscountType couponTypeEnum = DiscountType.getById(coupon.getCouponTypeEnum().getId());
			couponVO.setDiscountType(couponTypeEnum);

			result.add(couponVO);
		}

		return result;
	}

	/**
	 * 获取默认可用优惠券
	 * 
	 * @param packs
	 * @param member
	 * @param accessWay
	 * @param channel
	 * @return
	 */
	private CouponVO getDefaultUsableCoupon(List<? extends ProductPack> packs, MemberVO member, AccessWayEnum accessWay,
			OpChannelVO channel) {
		CouponVO defaultCouponVo = null;
		List<CpCouponVO> coupons = cpCouponService.getUsableCoupons(member.getId());
		Map<Long, CpCouponSampleVO> usableSampleMap = null;
		if (CollectionUtils.isNotEmpty(coupons)) {
			List<Long> sampleIds = Lists.newArrayList();
			for (CpCouponVO coupon : coupons) {
				if (!sampleIds.contains(coupon.getCouponSampleId())) {
					sampleIds.add(coupon.getCouponSampleId());
				}
			}

			CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
			calPriceDTO.setAccessWay(accessWay);
			calPriceDTO.setOpChannel(channel);
			calPriceDTO.setMember(member);
			calPriceDTO.setPacks(packs);
			calPriceDTO.setBirthday(false); // 不使用生日折扣

			List<? extends ProductPack> sourcePackVOs = priceService.calculateRawProductPackPrice(calPriceDTO);

			List<CpCouponSampleVO> samples = cpCouponSampleService.getCouponSampleByIds(sampleIds);
			usableSampleMap = couponSampleVerifyService.getUsableSampleDefaultForProducts(sourcePackVOs, samples,
					accessWay);
			List<CouponVO> couponVOS = new ArrayList<>();
			for (CpCouponVO coupon : coupons) {
				if (usableSampleMap.containsKey(coupon.getCouponSampleId()) && coupon.getId() != null) {
					couponVOS.add(
							convertCouponVo4CouponAndSample(coupon, usableSampleMap.get(coupon.getCouponSampleId())));
				}
			}

			if (CollectionUtils.isNotEmpty(couponVOS)) {
				for (int i = 0; i < couponVOS.size(); i++) {
					if (defaultCouponVo == null) {
						defaultCouponVo = couponVOS.get(i);
					} else if (defaultCouponVo.getDiscount().compareTo(couponVOS.get(i).getDiscount()) == -1) {
						defaultCouponVo = couponVOS.get(i);
					}
				}
			}
		}

		return defaultCouponVo;
	}

	/**
	 * 获取可用优惠券id ，如果没有返回null
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param accessWay
	 * @return
	 */
	public Long getDefaultUsableCouponId(List<? extends ProductPack> sourcePackVOs, MemberVO member,
			AccessWayEnum accessWay, OpChannelVO channel) {
		CouponVO couponVO = this.getDefaultUsableCoupon(sourcePackVOs, member, accessWay, channel);
		if (couponVO != null) {
			return couponVO.getId();
		}
		return null;
	}

	/**
	 * 从优惠券列表获取可用优惠券
	 * 
	 * @param sourcePackVOs
	 * @param member
	 * @param coupons
	 * @param accessWay
	 * @return
	 */
	private List<CouponVO> getUsableCouponForCoupons(List<RequestPack> sourcePackVOs, MemberVO member,
			List<CpCouponVO> coupons, AccessWayEnum accessWay, OpChannelVO opChannel) {
		List<CouponVO> result = Lists.newArrayList();
		if (CollectionUtils.isEmpty(coupons)) {
			return result;
		}
		List<? extends ProductPack> productPacks = this.convertCartProductPackByCartProductPackVO(sourcePackVOs, member,
				accessWay, opChannel);
		List<Long> sampleIds = Lists.newArrayList();
		for (CpCouponVO coupon : coupons) {
			if (!sampleIds.contains(coupon.getCouponSampleId())) {
				sampleIds.add(coupon.getCouponSampleId());
			}
		}

		List<CpCouponSampleVO> samples = cpCouponSampleService.getCouponSampleByIds(sampleIds);
		Map<Long, CpCouponSampleVO> usableSampleMap = couponSampleVerifyService.getUsableSampleForProducts(productPacks,
				samples, accessWay);

		for (CpCouponVO coupon : coupons) {
			if (usableSampleMap.containsKey(coupon.getCouponSampleId()) && coupon.getId() != null) {
				result.add(convertCouponVo4CouponAndSample(coupon, usableSampleMap.get(coupon.getCouponSampleId())));
			}
		}
		return result;
	}

	/**
	 * 商品包转换
	 * 
	 * @param sources
	 * @param member
	 * @param accessWay
	 * @return
	 */
	private List<? extends ProductPack> convertCartProductPackByCartProductPackVO(List<RequestPack> sources,
			MemberVO member, AccessWayEnum accessWay, OpChannelVO opChannel) {
		List<CartProductPack> packs = Lists.newArrayList();
		List<? extends ProductPack> result = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(sources)) {
			List<Long> packIds = Lists.newArrayList();
			List<RequestPack> noIdPacks = Lists.newArrayList();
			for (RequestPack requestPack : sources) {

				if (NumberUtil.isNullOrZero(requestPack.getId())) {
					noIdPacks.add(requestPack);
				} else {
					packIds.add(requestPack.getId());
				}
			}
			if (CollectionUtils.isNotEmpty(packIds)) {
				packs.addAll(cartService.getPacksByIds(member, packIds, accessWay, opChannel.getCode()));
			}
			if (CollectionUtils.isNotEmpty(noIdPacks)) {
				List<CartProductPack> prodPacks = cartProductPackAdapter.setProdAndSpv2CartProductPack(noIdPacks,
						accessWay, member, opChannel.getCode());
				packs.addAll(prodPacks);
			}
			cartProductPackAdapter.syncPrice2ProductPack(packs);

			CalculateProductPackDTO calPriceDTO = new CalculateProductPackDTO();
			calPriceDTO.setAccessWay(accessWay);
			calPriceDTO.setOpChannel(opChannel);
			calPriceDTO.setMember(member);
			calPriceDTO.setPacks(packs);
			if (member.isInBdayDiscountTime()) {
				calPriceDTO.setBirthday(true);
			} else {
				calPriceDTO.setBirthday(false);
			}
			result = priceService.calculateRawProductPackPrice(calPriceDTO);
		}
		return result;
	}

	/**
	 * 优惠券对象转换，返回对应模板信息
	 * 
	 * @param coupon
	 * @param couponSample
	 * @return
	 */
	private CouponVO convertCouponVo4CouponAndSample(CpCouponVO coupon, CpCouponSampleVO couponSample) {
		CouponVO rt = null;
		if (couponSample != null) {
			if (couponSample.getCouponTypeId().equals(CpCouponTypeEnum.CHEAPEN_LINE.getId())) {
				rt = new CouponVO();
				CpFullCutPriceVO fullCutCoupon = (CpFullCutPriceVO) coupon.getCouponSample().getCouponContent();
				rt.setId(coupon.getId());
				rt.setStartTime(coupon.getStartTime());
				rt.setCreateTime(coupon.getCreateTime());
				rt.setExpireTime(coupon.getExpireTime());
				rt.setTitle(couponSample.getTitle());
				rt.setDescription(couponSample.getDescription());
				rt.setProductDesc(couponSample.getProductDesc());
				rt.setThreshold(fullCutCoupon.getFullPrice());
				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(fullCutCoupon.getCutPrice());
				rt.setNote(couponSample.getNote());
				rt.setUsed(coupon.getUsed());
				rt.setUsable(coupon.getIsAvailable());
				rt.setExpired(coupon.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSample.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			} else if (couponSample.getCouponTypeId().equals(CpCouponTypeEnum.DISCOUNT_LINE.getId())) {
				rt = new CouponVO();
				CpFullDiscountVO fullCutCoupon = (CpFullDiscountVO) coupon.getCouponSample().getCouponContent();
				rt.setId(coupon.getId());
				rt.setStartTime(coupon.getStartTime());
				rt.setCreateTime(coupon.getCreateTime());
				rt.setExpireTime(coupon.getExpireTime());
				rt.setTitle(couponSample.getTitle());
				rt.setDescription(couponSample.getDescription());
				rt.setProductDesc(couponSample.getProductDesc());
				rt.setThreshold(fullCutCoupon.getFullPrice());
				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(BigDecimal.ZERO);
				rt.setDiscountRatio(fullCutCoupon.getDiscount().divide(BigDecimal.valueOf(10)));
				rt.setNote(couponSample.getNote());
				rt.setUsed(coupon.getUsed());
				rt.setUsable(coupon.getIsAvailable());
				rt.setExpired(coupon.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSample.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			} else if (couponSample.getCouponTypeId().equals(CpCouponTypeEnum.FIXEDPRICE_LINE.getId())) {
				rt = new CouponVO();
				CpFixedPriceVO fullCutCoupon = (CpFixedPriceVO) coupon.getCouponSample().getCouponContent();
				rt.setId(coupon.getId());
				rt.setStartTime(coupon.getStartTime());
				rt.setCreateTime(coupon.getCreateTime());
				rt.setExpireTime(coupon.getExpireTime());
				rt.setTitle(couponSample.getTitle());
				rt.setDescription(couponSample.getDescription());
				rt.setProductDesc(couponSample.getProductDesc());
				// rt.setThreshold(fullCutCoupon.getFullPrice());
				rt.setThresholdDesc(fullCutCoupon.getDescription());
				rt.setDiscount(fullCutCoupon.getFixedPrice());
				rt.setNote(couponSample.getNote());
				rt.setUsed(coupon.getUsed());
				rt.setUsable(coupon.getIsAvailable());
				rt.setExpired(coupon.getIsExpired());
				rt.setExpired(coupon.getIsExpired());
				DiscountType couponTypeEnum = DiscountType.getById(couponSample.getCouponTypeId());
				rt.setDiscountType(couponTypeEnum);
			}
		}
		return rt;
	}

}
