package com.thebeastshop.pegasus.channelservice.adapter.cart;

import java.util.Iterator;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.EmptyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.TempCart;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.service.OverseaService;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

/**
 * create by com.thebeastshop.pegasus.channelservice.adapter.cart trunk :author
 * lijing User:lijing DATE : 2016/7/21 TIME : 23:16 trunk.
 */
@Component
public class TempCartAdapter {
	private Logger logger = LoggerFactory.getLogger(getClass());

	/**
	 * 判断是否全是海淘的商品 或 普通商品
	 * 
	 * @param cart
	 * @return 如果是 则是 true 否则 false
	 */
	// public Boolean isOverSeaOrPutong(TempCart cart) {
	// Boolean retun = false;
	// if (null != cart) {
	// List<TempCartProductPack> cartProductPacks = cart.getProductPacks();
	// if (CollectionUtils.isNotEmpty(cartProductPacks)) {
	// Map<Long, Boolean> map = ifPoductIdsOverSea(cartProductPacks);
	// if (!map.isEmpty()) {
	// Boolean tempValue = true;
	// int i = 0;
	// for (Boolean value : map.values()) {
	// if (i == 0) {
	// tempValue = value;
	// i = 1;
	// }
	// if (tempValue != value) {
	// i = 2;
	// break;
	// }
	// }
	// if (i == 1) {
	// retun = true;
	// }
	// } else {
	// retun = true;
	// }
	// } else {
	// retun = true;
	// }
	// }
	// return retun;
	// }

	/**
	 * 这个方法是给 购物车列表用的 用户对 购物车里面的信息 进行封装 区分 普通购物车 和 海外购购物车
	 * 
	 * @author lijing
	 * @param cart
	 * @param building
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	// public CartVO getGroupByList(TempCart cart, String building, OpChannelVO
	// opChannel, AccessWay accessWay) {
	// logger.info("===进入临时购物车列表查询分隔 ==参数
	// cart={},building={},channel={},accessWay={}", cart, building, opChannel,
	// accessWay);
	// CartVO cartVo = new CartVO();
	// try {
	// List<GroupsVO> groupsVOs = new ArrayList<>();
	// List<TempCartProductPack> invalidPacks = new ArrayList<>();// 失效综合
	// MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
	// MemberVO member = new MemberVO();
	// member.setId(MemberConstant.DEFAULT_MEMBER_ID);
	// member.setMemberLevel(memberLevel.getCode());
	// /**
	// * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品 3.
	// * 并把商品 走会员打折区分，并判断失效商品
	// */
	// List<TempCartProductPack> packs = cart.getProductPacks();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 1 剔除所有的加价购商品
	// Iterator<TempCartProductPack> iterator = packs.iterator();
	// while (iterator.hasNext()) {
	// TempCartProductPack pack = iterator.next();
	// if (null != pack && CartPackSource.ADDIBLE.equals(pack.getSource())) {
	// iterator.remove();
	// }
	// }
	//
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// for (TempCartProductPack pack : packs) {
	// if (pack.getSpv() != null) {
	// spvs.add(pack.getSpv());
	// }
	// }
	// Map<PsSpvVO, Integer> spvStockMap =
	// productWarehouseService.mapSpvsStock(spvs,
	// opChannel.getWarehouseForSales());
	//
	// // 拆分有效/无效商品包
	// List<TempCartProductPack> validPacks = Lists.newArrayList();
	// separateInvalid(packs, validPacks, invalidPacks, opChannel, spvStockMap);
	//
	// List<CampaignHandler> campaignHandlers =
	// campaignAdaptor.getCampaignHandlers(validPacks, accessWay);
	//
	// Channel channel = channelService.getByCode(opChannel.getCode());
	//
	// List<CampaignResult> campaignResults =
	// campaignService.match(campaignHandlers, validPacks, channel);
	//
	// // 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品
	// List<TempCartProductPack> overSeaPacks = new
	// ArrayList<TempCartProductPack>();
	// List<TempCartProductPack> normalPacks = new
	// ArrayList<TempCartProductPack>();
	// // 拆分海淘/普通商品
	// separateOverSeaPack(validPacks, overSeaPacks, normalPacks);
	//
	// // 当新加商品为海淘时，海淘组放在上面，反之亦然
	// PsProductVO product = null;
	// if (CollectionUtils.isNotEmpty(validPacks)) {
	// TempCartProductPack firstPack = validPacks.get(0);
	// product = firstPack.getProduct();
	// }
	// if (product != null && product.getCrossBorderFlag() != null &&
	// product.getCrossBorderFlag().equals(1)) {
	// if (CollectionUtils.isNotEmpty(overSeaPacks)) {
	// GroupsVO groupsVO = getGroupVO(overSeaPacks, member, 1, opChannel,
	// accessWay, campaignResults,
	// spvStockMap);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// if (CollectionUtils.isNotEmpty(normalPacks)) {
	// GroupsVO groupsVO = getGroupVO(normalPacks, member, 2, opChannel,
	// accessWay, campaignResults,
	// spvStockMap);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// } else {
	// if (CollectionUtils.isNotEmpty(normalPacks)) {
	// GroupsVO groupsVO = getGroupVO(normalPacks, member, 2, opChannel,
	// accessWay, campaignResults,
	// spvStockMap);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// if (CollectionUtils.isNotEmpty(overSeaPacks)) {
	// GroupsVO groupsVO = getGroupVO(overSeaPacks, member, 1, opChannel,
	// accessWay, campaignResults,
	// spvStockMap);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// }
	//
	// setGroupsVOOne(groupsVOs);
	//
	// cartVo.setGroups(groupsVOs);
	// // 失效商品集合
	// cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks,
	// member,
	// opChannel, accessWay));
	// // 公告
	// cartVo.setAnnouncements(
	// announcementAdaptor.getAnnouncement(announcementService.getAvailable(accessWay,
	// memberLevel)));
	//
	// } else {
	// cartVo.setGroups(Lists.<GroupsVO> newArrayList());
	// cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
	// cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
	// logger.info("购物车没有商品信息====end");
	// }
	// } catch (Exception e) {
	// logger.error("===购物车 分隔失败 e={}", e);
	// } finally {
	// cartVo.setPrice(BigDecimal.ZERO);
	// cartVo.setSavedPrice(BigDecimal.ZERO);
	// }
	// return cartVo;
	// }

	/**
	 * 组合成需要的数据group的
	 * 
	 * @param validPack
	 * @param member
	 * @param type
	 *            1 是海外购 2是普通
	 * @return
	 */
	// private GroupsVO getGroupVO(List<TempCartProductPack> validPack, MemberVO
	// member, int type, OpChannelVO opChannel,
	// AccessWay accessWay, List<CampaignResult> campaignResults, Map<PsSpvVO,
	// Integer> spvStockMap) {
	// if (CollectionUtils.isNotEmpty(validPack)) {
	// if (type == 1) {
	// GroupsVO groupsVO = new GroupsVO();
	// groupsVO.setExclusive(true);
	// groupsVO.setType(CartGroupType.OVERSEA);
	// groupsVO.setTitle("海外购商品");
	// groupsVO.setPacks(cartProductPackAdaptor.getCartProductPackList(validPack,
	// member, opChannel, true, true,
	// true, campaignResults, accessWay, spvStockMap,true));
	//
	// String description =
	// PropConstants.getProperties("haitaodesc","应海关要求，必须和普通商品分开下单，敬请谅解");
	//
	// groupsVO.setDescription(description);
	// return groupsVO;
	// }
	// if (type == 2) {
	// GroupsVO groupsVO = new GroupsVO();
	// groupsVO.setExclusive(false);
	// groupsVO.setType(CartGroupType.NORMAL);
	// groupsVO.setTitle("普通商品");
	// groupsVO.setPacks(cartProductPackAdaptor.getCartProductPackList(validPack,
	// member, opChannel, true, true,
	// true, campaignResults, accessWay, spvStockMap,true));
	// String description =
	// PropConstants.getProperties("putongdesc","应海关要求，必须和跨境商品分开下单，敬请谅解");
	// groupsVO.setDescription(description);
	// return groupsVO;
	// }
	// }
	// return null;
	//
	// }

	/**
	 * 判断 当前分组 只有一个 的时候 是设置标题和描述
	 * 
	 * @auhtro lijing 产品需求
	 * @param groupsVOOne
	 */
	// public void setGroupsVOOne(List<GroupsVO> groupsVOOne) {
	// if (CollectionUtils.isNotEmpty(groupsVOOne) && 1 == groupsVOOne.size()) {
	// groupsVOOne.get(0).setDescription("");
	// groupsVOOne.get(0).setTitle("全选");
	// }
	// }

	/**
	 * 将商品包里面的商品拆分成两个 海淘和 普通商品
	 * 
	 * @author lijing
	 * @param packs
	 *            购物车中的商品包
	 * @param overSeaPacks
	 *            是海外购的商品
	 * @param normalPacks
	 *            不是海外购的商品 普通商品
	 */
	// private void separateOverSeaPack(List<TempCartProductPack> packs,
	// List<TempCartProductPack> overSeaPacks,
	// List<TempCartProductPack> normalPacks) {
	// if (null == packs || null == overSeaPacks || null == normalPacks) {
	// logger.info("有一个参数为空 ， 组合拆分 是否是海淘的商品 方法结束");
	// return;
	// }
	// Map<Long, Boolean> productsIsOverSea = ifPoductIdsOverSea(packs);
	// Boolean temp = false; // 临时空间 判断是否为海外购 true是
	// for (TempCartProductPack cartProductPack : packs) {
	// if (null != cartProductPack && null != cartProductPack.getProductId()) {
	// temp = productsIsOverSea.get(cartProductPack.getProductId());
	// if (null == temp) {
	// logger.error("查无此商品id 信息
	// cartProductPack.getProductId()={},productsIsOverSea={} ",
	// cartProductPack.getProductId(), productsIsOverSea);
	// }
	// if (temp) {
	// overSeaPacks.add(cartProductPack);
	// } else {
	// normalPacks.add(cartProductPack);
	// }
	// }
	// }
	// }

	/**
	 * 判断productIds 是否是 海外淘的
	 * 
	 * @author lijing
	 * @param packs
	 * @return
	 */
	// private Map<Long, Boolean> ifPoductIdsOverSea(List<TempCartProductPack>
	// packs) {
	// Map<Long, Boolean> isProductIdsOversea = new HashMap<Long, Boolean>();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// List<Long> productIds = new ArrayList<>();
	// for (TempCartProductPack productPack : packs) {
	// if (null != productPack && null != productPack.getProductId()) {
	// productIds.add(productPack.getProductId());
	// }
	// }
	// isProductIdsOversea = overseaService.mapProductIdsIsOversea(productIds);
	// }
	// return isProductIdsOversea;
	// }

	// ==================private method==================

	// private void separateInvalid(List<TempCartProductPack> packs,
	// List<TempCartProductPack> validPacks,
	// List<TempCartProductPack> invalidPacks, OpChannelVO opChannel,
	// Map<PsSpvVO, Integer> spvStockMap) {
	// for (TempCartProductPack pack : packs) {
	// PsProductVO product = pack.getProduct();
	// PsSpvVO spv = pack.getSpv();
	// if (null != product && null != spv) {
	// boolean isValid = isProductValid(product, spvStockMap.get(spv),
	// opChannel);
	// if (isValid) {
	// validPacks.add(pack);
	// } else {
	// invalidPacks.add(pack);
	// }
	// }
	// }
	// }

	private void separateInvalidNew(List<TempCartProductPack> packs, List<TempCartProductPack> validPacks,
			List<TempCartProductPack> invalidPacks, OpChannelVO opChannel) {
		for (TempCartProductPack pack : packs) {
			PsProductVO product = pack.getProduct();
			PsSpvVO spv = pack.getSpv();
			if (null != product && null != spv) {
				boolean isValid = isProductValid(product, spv.getCanUseQuantity(), opChannel);
				if (isValid) {
					validPacks.add(pack);
				} else {
					invalidPacks.add(pack);
				}
			}
		}
	}

	private boolean isProductValid(PsProductVO productVO, Integer spvStock, OpChannelVO opChannel) {
		boolean isCanSaleSku = EmptyUtil.isNotEmpty(productVO.getCanSaleSku(opChannel.getCode())); // 是否可售
		if (!isCanSaleSku) {
			return false;
		}

		boolean isOnShelf = true; // 是否上架
		List<String> onShelfChnCodes = productVO.getOnShelfChnCodes();
		if (EmptyUtil.isEmpty(onShelfChnCodes))
			isOnShelf = false;
		if (!onShelfChnCodes.contains(opChannel.getCode()))
			isOnShelf = false;
		if (!isOnShelf) {
			return false;
		}

		// 是否售罄
		if (spvStock == null || spvStock <= 0) {
			return false;
		}
		return true;
	}

	// ==================华丽丽的分割线===================

	// ====lijing 修改购物车 时候 的搭配packs
	// public List<CartProductPackVO> getModityPacks(List<TempCartProductPack>
	// packs, String building,
	// OpChannelVO opChannel, AccessWayEnum accessWay) {
	// List<CartProductPackVO> cartProductPackVOs = new ArrayList<>();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 先走会员折扣
	// final MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
	// MemberVO member = new MemberVO();
	// member.setId(MemberConstant.DEFAULT_MEMBER_ID);
	// member.setMemberLevel(memberLevel.getCode());
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// for (TempCartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv != null) {
	// spvs.add(spv);
	// }
	// }
	// // Map<PsSpvVO, Integer> spvStockMap =
	// // productWarehouseService.mapSpvsStock(spvs,
	// // opChannel.getWarehouseForSales());
	//
	// // 价格计算
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	//
	// // 有效商品vo
	// List<CartProductPackVO> validPackVos =
	// cartProductPackAdaptor.getCartProductPackListNew(packs, member,
	// opChannel, true, true, false, campaignResults, accessWay, true, null);
	//
	// cartProductPackVOs.addAll(validPackVos);
	//
	// }
	// return cartProductPackVOs;
	// }

	/**
	 * 获取购物车预览信息
	 *
	 * @param
	 * @return
	 */
	// public CartVO preview(List<TempCartProductPack> packs, String building,
	// OpChannelVO opChannel, AccessWay accessWay) {
	// final CartVO rt = new CartVO();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// final MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
	//
	// MemberVO member =
	// memberQueryService.getById(MemberConstant.DEFAULT_MEMBER_ID);
	//
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// List<TempCartProductPack> cheapenOtherPacks =
	// Lists.newArrayListWithExpectedSize(packs.size()); // 已换购的商品
	// for (TempCartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv != null) {
	// spvs.add(spv);
	// }
	// if (pack.getSource().equals(CartPackSource.ADDIBLE)) {
	// cheapenOtherPacks.add(pack);
	// }
	// }
	// //Map<PsSpvVO, Integer> spvStockMap =
	// productWarehouseService.mapSpvsStock(spvs,
	// opChannel.getWarehouseForSales());
	//
	// // 价格计算
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	//
	// BigDecimal totalPrice = priceResult.getTotalPrice(); // 总金额
	// BigDecimal savedPrice = priceResult.getSavedPrice(); // 已优惠的金额
	//
	// // 定制费计算
	// BigDecimal customizePrice = priceService.calculateCustomizePrice(dto);
	// totalPrice = totalPrice.add(customizePrice);
	//
	// // ========加价购的商品包========
	// final List<ProductPack> addiblePacks = Lists.newArrayList();
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	// if (campaignResults != null && !campaignResults.isEmpty()) {
	// for (int i = 0, size = campaignResults.size(); i < size; i++) {
	// final CampaignResult campaignResult = campaignResults.get(i);
	// if (campaignResult.isReach()) {
	// final DiscountType discountType = campaignResult.getDiscountType();
	// if (discountType == DiscountType.CHEAPEN_OTHER) {// 加价购：丢到后面加价购框框里。
	// Collection<ProductPack> additionalPacks =
	// campaignResult.getAdditionalPacks();
	// for (ProductPack productPack : additionalPacks) {
	// Iterator<TempCartProductPack> iterator = cheapenOtherPacks.iterator();
	// while (iterator.hasNext()) {
	// TempCartProductPack next = iterator.next();
	// if (productPack.getProductId().equals(next.getProductId())) {
	// productPack.setId(next.getId());
	// productPack.setSpv(next.getSpv());
	// productPack.setSpvId(next.getSpvId());
	// break;
	// }
	// }
	// }
	// addiblePacks.addAll(additionalPacks);
	// }
	// }
	// } // for
	// }
	//
	// // 最终价格
	// BigDecimal price = PriceUtil.keepToCent(totalPrice.subtract(savedPrice));
	//
	// // ========以下是转换vo实体=======
	// // 加价购商品vo
	// final List<CartProductPackVO> addiblePackVos = cartProductPackAdaptor
	// .getAddibleCartProductPackList(addiblePacks, member, opChannel,
	// accessWay);
	// // 主商品vo
	// List<TempCartProductPack> rawPacks = Lists.newArrayList();
	// for (TempCartProductPack pack : packs) {
	// if (pack.getSource().equals(CartPackSource.RAW)) {
	// rawPacks.add(pack);
	// }
	// }
	// final List<CartProductPackVO> validPackVos =
	// cartProductPackAdaptor.getCartProductPackListNew(rawPacks, member,
	// opChannel, true, true, true, campaignResults, accessWay,true,null);
	//
	// rt.setAnnouncements(
	// announcementAdaptor.getAnnouncement(announcementService.getAvailable(accessWay,
	// memberLevel)));
	// rt.setAddiblePacks(addiblePackVos);
	// rt.setGiftPacks(
	// cartProductPackAdaptor.getCartGiftCartProductPackList(campaignResults,
	// member, opChannel, accessWay));
	// List<Label> cartLabels =
	// labelService.getCartLabels(campaignResults,accessWay);
	//
	// boolean hasOverSea = overseaService.isOversea(rawPacks);
	//
	// cartLabels.addAll(
	// labelService.getPostageLabel(price, hasOverSea, accessWay));
	// rt.setLabels(cartLabels);
	// rt.setPacks(validPackVos);
	// // 邮费
	// BigDecimal postage = postageService.calculatePostageNew(packs, price,
	// member,hasOverSea);
	// rt.setPostage(postage);
	// rt.setPrice(price);
	// rt.setSavedPrice(PriceUtil.keepToCent(savedPrice));
	// }
	// return rt;
	// }

	public List<TempCartProductPack> getInvalidPack(TempCart cart, String building, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		MemberVO member = new MemberVO();
		member.setId(MemberConstant.DEFAULT_MEMBER_ID);
		member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
		final List<TempCartProductPack> packs = cart.getProductPacks();

		// ========过滤掉加价购商品。不让其参与活动========
		Iterator<TempCartProductPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			TempCartProductPack pack = iterator.next();
			if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
				iterator.remove();
			}
		}

		List<PsSpvVO> spvs = Lists.newArrayList();
		for (TempCartProductPack pack : packs) {
			if (pack.getSpv() != null) {
				spvs.add(pack.getSpv());
			}
		}
		// Map<PsSpvVO, Integer> spvStockMap =
		// productWarehouseService.mapSpvsStock(spvs,
		// opChannel.getWarehouseForSales());

		// 拆分有效/无效商品包
		final List<TempCartProductPack> validPacks = Lists.newArrayList();
		final List<TempCartProductPack> invalidPacks = Lists.newArrayList();
		separateInvalidNew(packs, validPacks, invalidPacks, opChannel);
		return invalidPacks;
	}

	public List<TempCartProductPack> getValidPack(TempCart cart, String building, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		MemberVO member = new MemberVO();
		member.setId(MemberConstant.DEFAULT_MEMBER_ID);
		member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());
		final List<TempCartProductPack> packs = cart.getProductPacks();

		// ========过滤掉加价购商品。不让其参与活动========
		Iterator<TempCartProductPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			TempCartProductPack pack = iterator.next();
			if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
				iterator.remove();
			}
		}

		List<PsSpvVO> spvs = Lists.newArrayList();
		for (TempCartProductPack pack : packs) {
			if (pack.getSpv() != null) {
				spvs.add(pack.getSpv());
			}
		}
		// Map<PsSpvVO, Integer> spvStockMap =
		// productWarehouseService.mapSpvsStock(spvs,
		// opChannel.getWarehouseForSales());

		// 拆分有效/无效商品包
		final List<TempCartProductPack> validPacks = Lists.newArrayList();
		final List<TempCartProductPack> invalidPacks = Lists.newArrayList();
		separateInvalidNew(packs, validPacks, invalidPacks, opChannel);
		return validPacks;
	}

	/**
	 * 获取要删除的购物车记录id集合 包括加价购和赠品记录
	 * 
	 * @param cart
	 * @param packIds
	 * @return
	 */
	public List<Long> getDelPackIds(TempCart cart, List<Long> packIds) {
		List<Long> delPackIds = Lists.newArrayList();
		if (null == cart) {
			return delPackIds;
		}
		// 2 找出要删除商品参加的活动
		List<PsCampaignVO> campaignVOs = Lists.newArrayList();
		List<TempCartProductPack> packs = Lists.newArrayList(cart.getProductPacks());
		for (TempCartProductPack productPack : packs) {
			if (packIds.contains(productPack.getId())) {
				delPackIds.add(productPack.getId());
				if (CartPackSourceEnum.RAW.equals(productPack.getSource())) {
					campaignVOs.addAll(productPack.getProduct().getCampaignList());
				}
			}
		}
		// 获取删除商品的换购和赠送商品
		List<Long> productIds = Lists.newArrayList();
		for (PsCampaignVO psCampaignVO : campaignVOs) {
			if (DiscountType.GIFT.getId().equals(psCampaignVO.getDiscountTypeId())
					|| DiscountType.CHEAPEN_OTHER.getId().equals(psCampaignVO.getDiscountTypeId())) {
				for (PsCampaignSectionVO cs : psCampaignVO.getCampaignSectionList()) {
					List<PsCampaignSectionProductVO> csProduct = cs.getCampaignSectionProducts();
					for (PsCampaignSectionProductVO productVO : csProduct) {
						productIds.add(productVO.getProductId());
					}
				}
			}
		}

		// 匹配是否有要删除的换购和赠送商品
		for (TempCartProductPack productPack : packs) {
			if (productIds.contains(productPack.getProductId())) {
				delPackIds.add(productPack.getId());
			}
		}

		return delPackIds;
	}

}
