package com.thebeastshop.pegasus.channelservice.adapter.cart;

import java.math.BigDecimal;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.Cart;
import com.thebeastshop.cart.TempCart;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.PriceUtil;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;

/**
 * 迷你购物车适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class MiniCartAdapter {

	// private ProductWarehouseService productWarehouseService =
	// ComponentServiceLoader
	// .getBean(ProductWarehouseService.class);

	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;
	@Autowired
	private CartCommonAdapter cartCommonAdapter;

	// ==================华丽丽的分割线===================
	/**
	 * 获取购物车信息
	 * 
	 * @param cart
	 * @param member
	 * @param channel
	 * @param accessWay
	 * @return
	 */
	public CartVO getCart(Cart cart, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		final List<CartProductPack> packs = cart.getProductPacks();
		final CartVO rt = new CartVO();
		if (CollectionUtils.isNotEmpty(packs)) {
			List<PsSpvVO> spvs = Lists.newArrayList();
			for (CartProductPack pack : packs) {
				if (pack.getSpv() != null) {
					spvs.add(pack.getSpv());
				}
			}

			// 拆分有效/无效商品包
			final List<CartProductPack> validPacks = Lists.newArrayList();
			final List<CartProductPack> invalidPacks = Lists.newArrayList();
			cartCommonAdapter.cartPackSeparateInvalidMini(packs, validPacks, invalidPacks, opChannel);

			BigDecimal sumPrice = BigDecimal.ZERO; // 总计金额

			// ========过滤掉加价购商品========
			for (int i = 0; i < validPacks.size(); i++) {
				CartProductPack pack = validPacks.get(i);
				if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
					validPacks.remove(i);
				}
			}

			// ========以下是转换vo实体=======
			// 有效商品vo
			final List<CartProductPackVO> validPackVos = cartProductPackAdaptor.getCartProductPackListNew(validPacks,
					member, opChannel, true, false, false, null, accessWay, true, null);
			for (CartProductPackVO pack : validPackVos) {
				if (null != pack.getSpv()) {
					sumPrice = sumPrice.add(pack.getSpv().getPrice());
				}
			}

			rt.setPacks(validPackVos);
			rt.setPrice(sumPrice);
		}
		return rt;
	}

	public CartVO getTempCart(TempCart cart, String building, OpChannelVO opChannel, AccessWayEnum accessWay) {
		final List<TempCartProductPack> packs = cart.getProductPacks();
		final CartVO rt = new CartVO();
		if (CollectionUtils.isNotEmpty(packs)) {
			MemberVO member = new MemberVO();
			member.setId(MemberConstant.DEFAULT_MEMBER_ID);
			member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());

			List<PsSpvVO> spvs = Lists.newArrayList();
			for (TempCartProductPack pack : packs) {
				if (pack.getSpv() != null) {
					spvs.add(pack.getSpv());
				}
			}
			// Map<PsSpvVO, Integer> spvStockMap =
			// productWarehouseService.mapSpvsStock(spvs,
			// opChannel.getWarehouseForSales());

			// 拆分有效/无效商品包
			final List<TempCartProductPack> validPacks = Lists.newArrayList();
			final List<TempCartProductPack> invalidPacks = Lists.newArrayList();
			cartCommonAdapter.tempCartPackSeparateInvalidMini(packs, validPacks, invalidPacks, opChannel);

			BigDecimal sumPrice = BigDecimal.ZERO; // 总计金额

			// ========过滤掉加价购商品========
			for (int i = 0; i < validPacks.size(); i++) {
				TempCartProductPack pack = validPacks.get(i);
				if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
					validPacks.remove(i);
				}
			}

			// ========以下是转换vo实体=======
			// 有效商品vo
			final List<CartProductPackVO> validPackVos = cartProductPackAdaptor.getCartProductPackListNew(validPacks,
					member, opChannel, true, false, false, null, accessWay, true, null);

			for (CartProductPackVO pack : validPackVos) {
				if (null != pack.getSpv()) {
					sumPrice = sumPrice.add(pack.getSpv().getPrice());
				}
			}

			rt.setPacks(validPackVos);
			rt.setPrice(sumPrice);
		}
		return rt;
	}

}
