package com.thebeastshop.pegasus.channelservice.adapter.cart;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.channelservice.convert.ScConvert;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.*;
import com.thebeastshop.pegasus.service.operation.vo.OpPresaleVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.YesOrNo;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.file.FileConstant;
import com.thebeastshop.support.vo.cart.CartBenefitVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO.PackCampaignVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO.PackCampaignVO.InfoVO;
import com.thebeastshop.support.vo.cart.RequestPack;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import com.thebeastshop.support.vo.product.SimpleProductVO.DiscVO;
import com.thebeastshop.support.vo.product.SpvVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

/**
 * 购物车商品包适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class CartProductPackAdapter {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private CartCommonAdapter cartCommonAdapter;
	@Autowired
	private LabelService labelService;

	@Autowired
	private SpvAdapter spvAdaptor;

	@Autowired
	private InterestAdapter interestAdapter;

	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private McPsProductService mcPsProductService;

	@Autowired
	private SPresaleService presaleService;

	/**
	 * 判断商品是否有规格，并组成map
	 * 
	 * @param campaignResults
	 * @param opChannel
	 * @return
	 */

	private Map<Long, List<CartProductPackVO>> mapPackGiftCartProductPackList(List<CampaignResult> campaignResults,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, Map<String, Date> spvPresaleDateMap) {
		if (CollectionUtils.isEmpty(campaignResults)) {
			return Maps.newHashMap();
		}
		Map<Long, List<CartProductPackVO>> rt = Maps.newHashMap();

		Integer type = OpPresaleVO.CHANNEL_TYPE_BEAST;
		if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
			type = OpPresaleVO.CHANNEL_TYPE_OFFLINE;
		}

		Map<String, Date> spvPresaleDateMap2 = new HashMap<>();
		;
		List<String> skuCodes = Lists.newArrayList();

		for (CampaignResult campaignResult : campaignResults) {

			ProductScope productScope = campaignResult.getProductScope();
			DiscountType discountType = campaignResult.getDiscountType();
			if (productScope.equals(ProductScope.SINGLE) && discountType == DiscountType.GIFT) {// 单品活动的赠品
				Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
				for (ProductPack productPack : additionalPacks) {

					if (productPack.getSpv().getSkuCode() != null
							&& skuCodes.contains(productPack.getSpv().getSkuCode())) {

						Date date = spvPresaleDateMap.get(productPack.getSpv().getSkuCode());
						if (date == null) {
							skuCodes.add(productPack.getSpv().getSkuCode());
						} else {
							spvPresaleDateMap2.put(productPack.getSpv().getSkuCode(), date);
						}

					}
				}
			}

		}

		if (skuCodes.size() > 0) {
			Map<String, Date> map = presaleService.findPlanedDeliveryDateBySkuCodes(skuCodes, type);
			if (map == null) {
				spvPresaleDateMap2.putAll(map);
			}
		}

		for (CampaignResult campaignResult : campaignResults) {
			ProductScope productScope = campaignResult.getProductScope();
			DiscountType discountType = campaignResult.getDiscountType();
			if (productScope.equals(ProductScope.SINGLE) && discountType == DiscountType.GIFT) {// 单品活动的赠品
				Collection<ProductPack> participatingPacks = campaignResult.getParticipatingPacks();
				Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
				for (ProductPack additionalPack : additionalPacks) {
					int count = additionalPack.getCount();
					int balance = additionalPack.getCount();
					int per = count / participatingPacks.size();
					Iterator<ProductPack> iterator = participatingPacks.iterator();
					while (iterator.hasNext()) {
						ProductPack productPack = iterator.next();

						if (productPack.getSpvId() != null) {
							if (iterator.hasNext()) {
								additionalPack.setCount(per);
							} else {
								additionalPack.setCount(balance);
							}
							if (additionalPack.getCount() != 0 || !iterator.hasNext()) {
								List<CartProductPackVO> list = rt.get(productPack.getSpvId());
								if (list == null) {
									list = Lists.newArrayList();
								}
								list.addAll(getGiftPacks(campaignResult, Arrays.asList(additionalPack), member,
										opChannel, accessWay, spvPresaleDateMap2));
								rt.put(productPack.getSpvId(), list);
							}
							balance = balance - per;
						}
					}
				}
			}
		}
		return rt;
	}

	private List<CartProductPackVO> getGiftPacks(CampaignResult campaignResult, Collection<ProductPack> packs,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, Map<String, Date> spvPresaleDateMap) {
		List<CartProductPackVO> list = Lists.newArrayList();
		Campaign campaign = campaignResult.getCampaign();
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packs.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packs.size());
		for (ProductPack pack : packs) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		// ===========spv map============
		Map<Long, SpvVO> spvVoMap = spvAdaptor.getSpvWithoutDiscountNew(spvs, productMap.values(), member, opChannel,
				spvPresaleDateMap);
		// ===========spv label map============
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);
		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(),
				opChannel);
		Iterator<ProductPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			ProductPack pack = iterator.next();
			PsSpvVO spv = spvMap.get(pack.getSpvId());
			SpvVO spvVO = spvVoMap.get(spv.getSpvId());
			PsProductVO product = productMap.get(pack.getProductId().toString());
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setHasVariants(hasVariantsMap.get(product));
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				// 修改一下spv的折扣价为换购商品包的单价
				spvVO.setPrice(pack.getFactProductPrice());
				packVo.setSpv(spvVO);
				packVo.setOwned(pack.getCount() != 0);
				PackCampaignVO campaignVO = new PackCampaignVO();
				campaignVO.setId(campaign.getId());
				campaignVO.setName(campaign.getName());
				InfoVO info = new InfoVO();
				if (campaignResult.getCampaign().getId() == -1) {
					// 首单赠品活动
					info.setType("首单赠");
				} else {
					info.setType("赠品");
				}
				info.setSummaryColor(spvVO.getLeft() != null && spvVO.getLeft() <= 0 ? "#000000" : "#333333");
				campaignVO.setInfo(info);
				packVo.setCampaign(campaignVO);
				list.add(packVo);
			}
		}
		return list;
	}

	public List<CartProductPackVO> getCartProductPackListNew(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, boolean withLabels, boolean withGifts, boolean checkHasVariants,
			List<CampaignResult> campaignResults, AccessWayEnum accessWay, boolean birthday,
			Map<String, Date> spvPresaleDateMap) {
		logger.info("无效商品商品包查询");
		Date start = new Date();
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		logger.info("商品包不为空");
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());
		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		logger.info("获取商品spv");
		Map<PsSpvVO, SpvVO> spvVoMap = spvAdaptor.getSpvByBirthdayNew(spvs, productMap, member, 
				opChannel, birthday, spvPresaleDateMap);

		// ===========spv label map============
		logger.info("获取商品spv标签");
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);
		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = null;
		if (checkHasVariants) {
			hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(), opChannel);
		}
		// ===========giftPacks map============
		Map<Long, List<CartProductPackVO>> giftPackMap = null;
		if (withGifts) {
			logger.info("礼品包");
			giftPackMap = mapPackGiftCartProductPackList(campaignResults, member, opChannel, accessWay,
					spvPresaleDateMap);
		}
		// ==============================
		for (int i = 0; i < packList.size(); i++) {
			ProductPack pack = packList.get(i);
			PsProductVO product = productMap.get(pack.getProductId().toString());
			PsSpvVO spv = pack.getSpv();
			SpvVO spvVO = spvVoMap.get(spv);
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				packVo.setSpv(spvVO);
				if (checkHasVariants) {
					packVo.setHasVariants(hasVariantsMap.get(product));
				}
				if (withLabels) {
					packVo.getLabels().addAll(labelService.getLabels(pack, campaignResults, accessWay));
				}
				if (spv.getSkuVO() != null && Integer.valueOf(1).equals(spv.getSkuVO().getCanCustomize())) {
					packVo.setCustomizable(true);
				}
				if (pack.isCustomize()) {
					List<UserSingleCustomization> userCustomizes = Lists.newArrayList();
					if (CollectionUtils.isNotEmpty(pack.getCustomizeList())) {
						for (CartCustomization cartCustomization : pack.getCustomizeList()) {
							UserSingleCustomization userSingleCustomization = new UserSingleCustomization();
							userSingleCustomization.setCode(cartCustomization.getCustomDimensionId());
							userSingleCustomization.setName(cartCustomization.getCustomDimensionName());
							userSingleCustomization.setValue(cartCustomization.getCustomDimensionValue());
							userCustomizes.add(userSingleCustomization);
						}
					}
					packVo.setCustomized(pack.isCustomize());
					packVo.setCustomizes(userCustomizes);
				}
				if (withGifts) {
					packVo.setGiftPacks(giftPackMap.get(pack.getSpvId()));
				}
				// 如果是权益修改商品
				if (!CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
					list.add(packVo);
				} else {
					InterestGoods interestGoods = interestAdapter.getInterestInfo(pack.getSourceBindVal());
					CartBenefitVO cartBenefitVO = new CartBenefitVO();
					cartBenefitVO.setId(pack.getSourceBindVal());
					cartBenefitVO.setCashStartTime(interestGoods.getCashStartTime());
					cartBenefitVO.setCashEndTime(interestGoods.getCashEndTime());
					if (DateUtil.isInTime(null, interestGoods.getCashEndTime(), null)) {
						packVo.setBenefit(cartBenefitVO);
						packVo.setHasVariants(interestAdapter.hasVariants(pack.getSourceBindVal()));
						packVo.setSpv(convertInterestSpvVO4PsSpvVO(spv, product, spvVO.getDiscount()));
						list.add(packVo);
					}
				}
			}
		}
		Date end = new Date();
		logger.info("方法getCartProductPackList花费时间：{}毫秒", end.getTime() - start.getTime());
		return list;
	}

	// public List<CartProductPackVO> getAddibleCartProductPackList(List<?
	// extends ProductPack> packList, MemberVO member, OpChannelVO opChannel,
	// AccessWay accessWay) {
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// for (ProductPack pack : packList) {
	// if (pack.getSpv() != null) {
	// spvs.add(pack.getSpv());
	// }
	// }
	// Map<PsSpvVO, Integer> spvStockMap =
	// productWarehouseService.mapSpvsStock(spvs,
	// opChannel.getWarehouseForSales());
	// return getAddibleCartProductPackList(packList, member, opChannel,
	// accessWay, spvStockMap);
	// }

	/**
	 * 批量获取额外商品包（加价购商品）
	 * 
	 * @param packList
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public List<CartProductPackVO> getAddibleCartProductPackList(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());
		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		Map<Long, SpvVO> spvVoMap = spvAdaptor.getSpvWithoutDiscountNew(spvs, productMap.values(), member, opChannel,
				null);
		// ===========spv label map============
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);
		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(),
				opChannel);
		for (int i = 0; i < packList.size(); i++) {
			ProductPack pack = packList.get(i);
			PsSpvVO spv = spvMap.get(pack.getSpvId());
			SpvVO spvVO = spvVoMap.get(spv.getSpvId());
			PsProductVO product = productMap.get(pack.getProductId().toString());
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setHasVariants(hasVariantsMap.get(product));
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				// 修改一下spv的折扣价为加价购商品包的单价
				spvVO.setPrice(pack.getFactProductPrice());
				packVo.setSpv(spvVO);
				packVo.setOwned(pack.getId() != null ? true : false);
				list.add(packVo);
			}
		}
		return list;
	}

	/**
	 * 批量获取额外商品包（加价购商品）
	 * 
	 * @param packList
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public List<CartProductPackVO> getAddibleCartProductPackListNew(List<? extends ProductPack> packList,
			MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay, Map<String, Date> spvPresaleDateMap,
			Boolean isGift) {
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());
		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		Map<Long, SpvVO> spvVoMap = spvAdaptor.getSpvWithoutDiscountNew(spvs, productMap.values(), member, opChannel,
				spvPresaleDateMap);
		// ===========spv label map============
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);
		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(),
				opChannel);
		for (int i = 0; i < packList.size(); i++) {
			ProductPack pack = packList.get(i);
			PsSpvVO spv = spvMap.get(pack.getSpvId());
			SpvVO spvVO = spvVoMap.get(spv.getSpvId());
			PsProductVO product = productMap.get(pack.getProductId().toString());
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setHasVariants(hasVariantsMap.get(product));
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				// 修改一下spv的折扣价为加价购商品包的单价
				spvVO.setPrice(pack.getSpv().getDiscountPrice());
				if (isGift) {
					spvVO.setPrice(BigDecimal.ZERO);
				}

				packVo.setSpv(spvVO);
				packVo.setOwned(pack.getId() != null ? true : false);
				list.add(packVo);
			}
		}
		return list;
	}

	public List<CartProductPackVO> getCartGiftCartProductPackList(List<CampaignResult> campaignResults, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(campaignResults)) {
			return Lists.newArrayList();
		}
		List<CartProductPackVO> list = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(campaignResults)) {

			Integer type = OpPresaleVO.CHANNEL_TYPE_BEAST;
			if (opChannel.getChannelType() != null && opChannel.getChannelType() == 1) {
				type = OpPresaleVO.CHANNEL_TYPE_OFFLINE;
			}

			Map<String, Date> spvPresaleDateMap = null;
			List<String> skuCodes = Lists.newArrayList();

			for (CampaignResult campaignResult : campaignResults) {

				ProductScope productScope = campaignResult.getProductScope();
				DiscountType discountType = campaignResult.getDiscountType();
				if (!productScope.equals(ProductScope.SINGLE) && discountType == DiscountType.GIFT) {// 非单品活动的赠品：丢到后面加价购框框里。
					Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
					for (ProductPack productPack : additionalPacks) {

						if (productPack.getSpv().getSkuCode() != null
								&& skuCodes.contains(productPack.getSpv().getSkuCode())) {

							skuCodes.add(productPack.getSpv().getSkuCode());
						}
					}
				}

			}

			spvPresaleDateMap = presaleService.findPlanedDeliveryDateBySkuCodes(skuCodes, type);

			if (spvPresaleDateMap == null) {
				spvPresaleDateMap = Maps.newHashMap();
			}

			for (int i = 0, size = campaignResults.size(); i < size; i++) {
				CampaignResult campaignResult = campaignResults.get(i);
				Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
				ProductScope productScope = campaignResult.getProductScope();
				DiscountType discountType = campaignResult.getDiscountType();
				if (!productScope.equals(ProductScope.SINGLE) && discountType == DiscountType.GIFT) {// 非单品活动的赠品：丢到后面加价购框框里。
					list.addAll(getGiftPacks(campaignResult, additionalPacks, member, opChannel, accessWay,
							spvPresaleDateMap));
				}
			}
		}
		return list;
	}

	public List<CartProductPackVO> getInvalidCartProductPackList(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay) {
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		for (ProductPack pack : packList) {
			PsSpvVO spv = pack.getSpv();
			PsProductVO product = pack.getProduct();
			CartProductPackVO packVo = new CartProductPackVO();
			packVo.setId(pack.getId());
			packVo.setCount(pack.getCount());
			packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
			packVo.setProductId(product.getCode());
			packVo.setSpv(convertInterestSpvVO4PsSpvVO(spv, product, null));
			if (pack.isCustomize()) {
				List<UserSingleCustomization> userCustomizes = Lists.newArrayList();
				if (CollectionUtils.isNotEmpty(pack.getCustomizeList())) {
					for (CartCustomization cartCustomization : pack.getCustomizeList()) {
						UserSingleCustomization userSingleCustomization = new UserSingleCustomization();
						userSingleCustomization.setCode(cartCustomization.getCustomDimensionId());
						userSingleCustomization.setName(cartCustomization.getCustomDimensionName());
						userSingleCustomization.setValue(cartCustomization.getCustomDimensionValue());
						userCustomizes.add(userSingleCustomization);
					}
				}
				packVo.setCustomized(pack.isCustomize());
				packVo.setCustomizes(userCustomizes);
			}
			list.add(packVo);
		}
		return list;
	}

	/**
	 * 获取权益商品
	 * 
	 * @return
	 */
	public List<CartProductPackVO> getInterestCartProductPackList(List<? extends ProductPack> packList, MemberVO member,
			AccessWayEnum accessWay) {
		List<CartProductPackVO> result = new ArrayList<>();
		if (CollectionUtils.isEmpty(packList)) {
			return result;
		}
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());

		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}

		// ===========spv label map============
		Collection<PsSpvVO> spvs = spvMap.values();
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdaptor.getSpvLabels(spvs, accessWay);
		// ==============================
		for (ProductPack pack : packList) {
			PsProductVO product = productMap.get(pack.getProductId().toString());
			PsSpvVO spv = pack.getSpv();
			if (null != product && null != spv) {
				CartProductPackVO packVo = new CartProductPackVO();
				CartBenefitVO cartBenefitVO = interestAdapter.getCartBenefitVO(pack.getSourceBindVal());
				packVo.setBenefit(cartBenefitVO);
				packVo.setHasVariants(interestAdapter.hasVariants(pack.getSourceBindVal()));
				packVo.setSpv(convertInterestSpvVO4PsSpvVO(spv, product, null));

				packVo.setId(pack.getId());
				packVo.setCount(pack.getCount());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setSource(CartPackSource.valueOf(pack.getSource().name()));
				packVo.setProductId(product.getCode());
				result.add(packVo);
			}
		}
		return result;
	}

	public SpvVO convertInterestSpvVO4PsSpvVO(PsSpvVO spv, PsProductVO product, DiscVO discount) {
		SpvVO spvVo = new SpvVO();
		spvVo.setId(spv.getSpvId());
		// featureImage
		String featureImage = product.getPicList();
		if (org.apache.commons.lang.StringUtils.isNotBlank(featureImage)
				&& !featureImage.startsWith(FileConstant.BASE_URL)) {
			featureImage = FileConstant.BASE_URL + featureImage;
		}
		spvVo.setImage(featureImage);
		// brand
		List<PsBrandVO> brands = product.getBrands();
		if (CollectionUtils.isNotEmpty(brands)) {
			PsBrandVO brand = brands.get(0);
			if (brand != null) {
				SpvVO.BrandVO brandVO = new SpvVO.BrandVO();
				brandVO.setId(brand.getBrandId());
				brandVO.setName(brand.getBrandNameCN());
				spvVo.setBrand(brandVO);
			}
		}
		// name
		spvVo.setName(product.getNameCn());
		// description
		StringBuilder sb = new StringBuilder();
		List<PsAttributeValuePairVO> attrList = spv.getAttributeValuePairList();
		if (CollectionUtils.isNotEmpty(attrList)) {
			for (PsAttributeValuePairVO attr : attrList) {
				if (attr != null && org.apache.commons.lang.StringUtils.isNotBlank(attr.getAttrName())
						&& org.apache.commons.lang.StringUtils.isNotBlank(attr.getValue()))
					sb.append(attr.getAttrName()).append(" : ").append(attr.getValue()).append(" ");
			}
		}
		spvVo.setSpvDesc(sb.toString());

		if (product.getCombined()) {
			// price
			spvVo.setRawPrice(spv.getOriginalPrice());
		} else {
			// price
			spvVo.setRawPrice(spv.getSalesPrice());
		}

		if (null != spv.getDiscountPrice()) {
			spvVo.setPrice(spv.getDiscountPrice());
			if (null != discount) {
				spvVo.setDiscount(discount);
			}
		} else {
			spvVo.setPrice(BigDecimal.ZERO);
		}
		// product code
		spvVo.setProductCode(spv.getProductCode());
		// skuCodes
		List<String> skuCodes = Lists.newArrayList();
		if (spv.getCombined()) {
			for (PsSkuCombinationVO sku : spv.getSkuCombinationList()) {
				skuCodes.add(sku.getSubSkuCode());
			}
		} else {
			skuCodes.add(spv.getSkuCode());
		}
		spvVo.setSkuCodes(skuCodes);
		// spv库存数量
		spvVo.setLeft(1);
		// 最小起售数
		spvVo.setMinAmount(1);
		// XXX:预售信息()海淘商品或者组合商品不显示预售信息
		spvVo.setPresell(null);
		return spvVo;
	}

	/**
	 * 校验赠品包
	 * 
	 * @param packs
	 * @param campaignResults
	 */
	public void checGiftPacks(Collection<CartProductPack> packs, List<CampaignResult> campaignResults) {
		Map<String, ProductPack> giftMap = new HashMap<>();
		for (CampaignResult campaignResult : campaignResults) {
			Collection<ProductPack> productPacks = campaignResult.getAdditionalPacks();
			for (ProductPack productPack : productPacks) {
				if (CartPackSourceEnum.GIFT.equals(productPack.getSource())) {
					giftMap.put(productPack.getProductId().toString(), productPack);
				}
			}
		}
		for (CartProductPack cartProductPack : packs) {
			if (CartPackSourceEnum.GIFT.equals(cartProductPack.getSource())) {
				if (!giftMap.containsKey(cartProductPack.getProductId().toString())) {
					throw new ChannelException(400, "无效赠品：" + cartProductPack.getProduct().getNameCn());
				}
			}
		}

	}

	/**
	 * 请求商品包转处理商品包
	 * 
	 * @param packs
	 * @param accessWay
	 * @param memberVO
	 * @return
	 */
	public List<CartProductPack> setProdAndSpv2CartProductPack(List<RequestPack> packs, AccessWayEnum accessWay,
			MemberVO memberVO, String channelCode) {
		List<CartProductPack> prodPacks = Lists.newArrayList();
		Integer memberLevel = -1;
		BigDecimal bdayDiscountRatio = BigDecimal.ONE;
		if (memberVO != null) {
			memberLevel = memberVO.getMemberLevel();
			bdayDiscountRatio = memberVO.getBdayDiscountRatio();
		}

		MemberLevelEnum MemberLevel = MemberLevelEnum.getEnumByCode(memberLevel);
		List<String> productIds = Lists.newArrayListWithExpectedSize(packs.size());
		List<Long> spvIds = Lists.newArrayListWithExpectedSize(packs.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packs.size());
		Map<String, PsProductVO> prodMap = Maps.newHashMapWithExpectedSize(packs.size());

		for (RequestPack pack : packs) {
			spvIds.add(pack.getSpvId());
		}

		if (CollectionUtils.isNotEmpty(spvIds)) {
			// 获取spv信息
			PsMatchCampaignCond spvCond = new PsMatchCampaignCond();
			spvCond.setChannelCode(channelCode);
			spvCond.setAccessWay(accessWay.getCode());
			spvCond.setMemberLevel(memberLevel);
			spvCond.setMatchCampaign(true);
			spvCond.setDiscount(MemberLevel.getLevelAmountCondition());
			spvCond.setPagenum(Integer.MAX_VALUE);
			spvCond.setBdDiscount(bdayDiscountRatio);
			List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds, spvCond, channelCode);
			for (PsSpvVO spv : spvs) {
				spvMap.put(spv.getSpvId(), spv);
				productIds.add(spv.getProductId().toString());
			}
		}
		if (CollectionUtils.isNotEmpty(productIds)) {
			PsProductCond cond = new PsProductCond();
			cond.setIds(productIds);
			cond.setMemberCode(memberVO.getCode());
			cond.setChannelCode(channelCode);
			cond.setAccessWay(accessWay.getCode());
			cond.setMemberLevel(memberLevel);
			cond.setMatchCampaign(true);
			cond.setDiscount(MemberLevel.getLevelAmountCondition());
			cond.setPagenum(Integer.MAX_VALUE);
			cond.setBdDiscount(bdayDiscountRatio);
			List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
			for (PsProductVO psProductVO : products) {
				prodMap.put(psProductVO.getId(), psProductVO);
			}
		}

		// 如果有商品Id则说明请求商品可买可售
		Iterator<RequestPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			RequestPack pack = iterator.next();
			PsSpvVO spv = spvMap.get(pack.getSpvId());

			if (spv == null) {
				logger.error("商品不在存在，spvId:" + pack.getSpvId());
				iterator.remove();
				continue;
			}
			PsProductVO product = prodMap.get(spv.getProductId().toString());
			if (product == null) { // 如果商品id或spv不存在了，那么就把这个商品包移除吧
				logger.error("商品不在存在，prodId:" + spv.getProductId());
				iterator.remove();
				continue;
			}
			CartProductPack prodPack = new CartProductPack();
			if (!NumberUtil.isNullOrZero(pack.getId())) {
				prodPack.setId(pack.getId());
			}
			prodPack.setCount(pack.getCount());
			prodPack.setSource(CartPackSourceEnum.getEnumByCode(pack.getSource().getId()));
			// 设置spv和product
			prodPack.setSpvId(spv.getSpvId());
			prodPack.setProductId(spv.getProductId());
			prodPack.setSpv(spv);
			prodPack.setProduct(product);
			prodPack.setDeliverys(ScConvert.convert2ScDelivery(pack.getDeliverys()));
			if (CartPackSource.RAW.equals(pack.getSource())) {
				prodPack.setFactProductPrice(spv.getSalesPrice());
			}

			if (CartPackSource.BENEFIT.equals(pack.getSource())) {
				prodPack.setSourceBindVal(pack.getBindValue());
			}

			if (CollectionUtils.isNotEmpty(pack.getCustomizes())) {
				prodPack.setCustomize(true);
				List<CartCustomization> cts = new ArrayList<>();

				for (UserSingleCustomization userSingleCustomization : pack.getCustomizes()) {

					CartCustomization cartCustomization = new CartCustomization();
					cartCustomization.setCustomDimensionId(userSingleCustomization.getCode());
					cartCustomization.setCustomDimensionName(userSingleCustomization.getName());
					cartCustomization.setCustomDimensionValue(userSingleCustomization.getValue());
					cts.add(cartCustomization);
				}

				prodPack.setCustomizeList(cts);
			}

			// 如果存在赠品
			if(pack.getGiftPacks() != null){
				prodPack.setGiftPacks(setProdAndSpv2CartProductPack(pack.getGiftPacks(),accessWay,memberVO, channelCode));
			}
			
			
			prodPacks.add(prodPack);
		}

		return prodPacks;
	}

	/**
	 * 请求商品包转处理商品包
	 * 
	 * @param packs
	 * @param accessWay
	 * @return
	 */
	public List<TempCartProductPack> setProdAndSpv2TempCartProductPack(List<RequestPack> packs, AccessWayEnum accessWay,
			String channelCode) {
		List<TempCartProductPack> prodPacks = Lists.newArrayList();
		MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
		List<String> productIds = Lists.newArrayListWithExpectedSize(packs.size());
		List<Long> spvIds = Lists.newArrayListWithExpectedSize(packs.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packs.size());
		Map<String, PsProductVO> prodMap = Maps.newHashMapWithExpectedSize(packs.size());

		for (RequestPack pack : packs) {
			spvIds.add(pack.getSpvId());
		}
		if (CollectionUtils.isNotEmpty(spvIds)) {
			// 获取spv信息
			PsMatchCampaignCond spvCond = new PsMatchCampaignCond();
			spvCond.setAccessWay(accessWay.getCode());
			spvCond.setMemberLevel(memberLevel.getCode());
			spvCond.setMatchCampaign(true);
			spvCond.setDiscount(memberLevel.getLevelAmountCondition());
			spvCond.setPagenum(Integer.MAX_VALUE);
			spvCond.setBdDiscount(BigDecimal.valueOf(1));
			spvCond.setChannelCode(channelCode);
			List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds, spvCond, channelCode);
			for (PsSpvVO spv : spvs) {
				spvMap.put(spv.getSpvId(), spv);
				productIds.add(spv.getProductId().toString());
			}
		}
		if (CollectionUtils.isNotEmpty(productIds)) {
			PsProductCond cond = new PsProductCond();
			cond.setChannelCode(channelCode);
			cond.setIds(productIds);
			cond.setAccessWay(accessWay.getCode());
			cond.setMemberLevel(memberLevel.getCode());
			cond.setMatchCampaign(true);
			cond.setDiscount(memberLevel.getLevelAmountCondition());
			cond.setPagenum(Integer.MAX_VALUE);
			cond.setBdDiscount(BigDecimal.valueOf(1));
			cond.setChannelCode(channelCode);
			List<PsProductVO> products = mcPsProductService.findByCond(cond, true);
			for (PsProductVO psProductVO : products) {
				prodMap.put(psProductVO.getId(), psProductVO);
			}
		}

		// 如果有商品Id则说明请求商品可买可售
		Iterator<RequestPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			RequestPack pack = iterator.next();
			PsSpvVO spv = spvMap.get(pack.getSpvId());
			PsProductVO product = prodMap.get(spv.getProductId().toString());
			if (product == null || spv == null) { // 如果商品id或spv不存在了，那么就把这个商品包移除吧
				iterator.remove();
				continue;
			}
			TempCartProductPack prodPack = new TempCartProductPack();
			prodPack.setCount(pack.getCount());
			prodPack.setSource(CartPackSourceEnum.getEnumByCode(pack.getSource().getId()));
			// 设置spv和product
			prodPack.setSpvId(spv.getSpvId());
			prodPack.setProductId(spv.getProductId());
			prodPack.setSpv(spv);
			prodPack.setProduct(product);
			if (CartPackSource.RAW.equals(pack.getSource())) {
				prodPack.setFactProductPrice(spv.getSalesPrice());
			}
			// 设置定制
			if (CollectionUtils.isNotEmpty(pack.getCustomizes())) {
				prodPack.setCustomize(Boolean.TRUE);
				List<CartCustomization> cartCustomizes = Lists.newArrayList();
				for (UserSingleCustomization userCustomize : pack.getCustomizes()) {
					CartCustomization cartCustom = new CartCustomization();
					cartCustom.setCustomDimensionId(userCustomize.getCode());
					cartCustom.setCustomDimensionName(userCustomize.getName());
					cartCustom.setCustomDimensionValue(userCustomize.getValue());
					cartCustomizes.add(cartCustom);
				}
				prodPack.setCustomizeList(cartCustomizes);
			}
			prodPacks.add(prodPack);
		}

		return prodPacks;
	}

	public void syncPrice2ProductPack(List<? extends ProductPack> packs) {
		List<PsCampaignVO> campList = Lists.newArrayList();
		for (ProductPack productPack : packs) {
			if (CartPackSourceEnum.RAW.equals(productPack.getSource())) {
				campList.addAll(productPack.getProduct().getCampaignList());
			}
		}
		for (ProductPack productPack : packs) {
			switch (productPack.getSource()) {
			case RAW:
				this.restFlowerMonthPrice(productPack); // 重置月送鲜花商品包价格
				productPack.setFactProductPrice(productPack.getSpv().getSalesPrice());
				break;
			case GIFT:
				productPack.setFactProductPrice(BigDecimal.ZERO);
				break;
			case ADDIBLE:
				for (PsCampaignVO camp : campList) {
					if (DiscountType.CHEAPEN_OTHER.getId().equals(camp.getDiscountTypeId())) {
						for (PsCampaignSectionVO cs : camp.getCampaignSectionList()) {
							List<PsCampaignSectionProductVO> csProduct = cs.getCampaignSectionProducts();
							for (PsCampaignSectionProductVO campProd : csProduct) {
								if (productPack.getProductId().equals(campProd.getProductId())) {
									productPack.setFactProductPrice(campProd.getPricePrice());
									break;
								}
							}
						}
					}
				}
				break;
			case BENEFIT:
				productPack.setFactProductPrice(BigDecimal.ZERO);
				break;
			default:
			}
		}

		// 首单赠活动
		this.resetFirstOrderGitf(packs);
	}

	/**
	 * 重置月送商品包价格
	 * 
	 * @param productPack
	 */
	private void restFlowerMonthPrice(ProductPack productPack) {
		// 月送鲜花价格乘以 配送次数
		if (YesOrNo.YES.getId().equals(productPack.getProduct().getIsMonthSend())) {
			if (productPack != null && null != productPack.getSpv().getSkuVO()) {
				Integer times = productPack.getSpv().getSkuVO().getDeliveryTimes();
				if (times > 1) {
					PsSpvVO spvVO = productPack.getSpv();
					if (!NumberUtil.isNullOrZero(spvVO.getSalesPrice())) {
						spvVO.setSalesPrice(spvVO.getSalesPrice().multiply(new BigDecimal(times)));
					}
					if (!NumberUtil.isNullOrZero(spvVO.getAdvancePrice())) {
						spvVO.setAdvancePrice(spvVO.getAdvancePrice().multiply(new BigDecimal(times)));
					}
					if (!NumberUtil.isNullOrZero(spvVO.getBdDiscountPrice())) {
						spvVO.setBdDiscountPrice(spvVO.getBdDiscountPrice().multiply(new BigDecimal(times)));
					}
					if (!NumberUtil.isNullOrZero(spvVO.getCostPrice())) {
						spvVO.setCostPrice(spvVO.getCostPrice().multiply(new BigDecimal(times)));
					}
					if (!NumberUtil.isNullOrZero(spvVO.getDiscountPrice())) {
						spvVO.setDiscountPrice(spvVO.getDiscountPrice().multiply(new BigDecimal(times)));
					}
					if (CollectionUtils.isNotEmpty(spvVO.getPriceCalResults())) {
						for (PriceCalResultVO priceCal : spvVO.getPriceCalResults()) {
							if (!NumberUtil.isNullOrZero(priceCal.getFinalPrice())) {
								priceCal.setFinalPrice(priceCal.getFinalPrice().multiply(new BigDecimal(times)));
							}
							if (!NumberUtil.isNullOrZero(priceCal.getOriginalPrice())) {
								priceCal.setOriginalPrice(priceCal.getOriginalPrice().multiply(new BigDecimal(times)));
							}
						}
					}
					if (CollectionUtils.isNotEmpty(spvVO.getBdPriceCalResults())) {
						for (PriceCalResultVO priceCal : spvVO.getBdPriceCalResults()) {
							if (!NumberUtil.isNullOrZero(priceCal.getFinalPrice())) {
								priceCal.setFinalPrice(priceCal.getFinalPrice().multiply(new BigDecimal(times)));
							}
							if (!NumberUtil.isNullOrZero(priceCal.getOriginalPrice())) {
								priceCal.setOriginalPrice(priceCal.getOriginalPrice().multiply(new BigDecimal(times)));
							}
						}
					}
				}
			}
		}
	}

	/**
	 * 重置首单赠活动 首单赠有可能添加到 GIFT/ADDIBLE/BENEFIT商品上 ，导致校验赠品时提示无效赠品
	 * 修复方案：取出这些来源的首单赠活动，添加到主品上去
	 * 
	 * @param packs
	 */
	private void resetFirstOrderGitf(List<? extends ProductPack> packs) {
		List<PsCampaignVO> campList = Lists.newArrayList();
		for (ProductPack productPack : packs) {
			if (!CartPackSourceEnum.RAW.equals(productPack.getSource())) {
				campList.addAll(productPack.getProduct().getCampaignList());
			}
		}
		PsCampaignVO firstCamp = null;
		if (CollectionUtils.isNotEmpty(campList)) {
			Iterator<PsCampaignVO> iterator = campList.iterator();
			while (iterator.hasNext()) {
				PsCampaignVO camp = iterator.next();
				if ("app_first_buy".equals(camp.getCode())) {
					firstCamp = camp;
					iterator.remove();
					break;
				}

			}
		}

		if (null != firstCamp) {
			for (ProductPack productPack : packs) {
				if (CartPackSourceEnum.RAW.equals(productPack.getSource())) {
					productPack.getProduct().getCampaignList().add(firstCamp);
				}
			}
		}

	}

}
