package com.thebeastshop.pegasus.channelservice.adapter.cart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.Cart;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.TempCart;
import com.thebeastshop.cart.resp.CartCustomization;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.constant.MemberConstant;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.price.PriceAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.SpvPriceAdapter;
import com.thebeastshop.pegasus.channelservice.service.LabelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.service.PrsPriceService;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCalPackDto;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsCartSettleLabelVO;
import com.thebeastshop.price.vo.PrsPacksPriceResultVO;
import com.thebeastshop.price.vo.PrsPriceStepVO;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.stock.vo.SSkuStockVO;
import com.thebeastshop.support.Label;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.EnumUtil;
import com.thebeastshop.support.vo.announcement.AnnouncementVO;
import com.thebeastshop.support.vo.cart.CartBenefitVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;
import com.thebeastshop.support.vo.cart.CartVO;
import com.thebeastshop.support.vo.cart.GroupsVO;
import com.thebeastshop.support.vo.customize.UserSingleCustomization;
import com.thebeastshop.support.vo.product.SpvVO;

/**
 * 价格计算重构购物车适配器
 * 
 * @author Wang Yawei
 *
 */
@Component
public class CartPriceAdapter {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private CampaignLimitService campaignLimitService;
	@Autowired
	private MemberQueryService memberQueryService;

	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private CartAdapter cartAdapter;

	@Autowired
	private SpvPriceAdapter spvPriceAdapter;

	@Autowired
	private SpvAdapter spvAdapter;

	@Autowired
	private PrsPriceService prsPriceService;
	@Autowired
	private PriceAdapter priceAdapter;

	@Autowired
	private LabelService labelService;

	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;

	@Autowired
	private ForecastAdapter forecastAdapter;

	@Autowired
	private CartCommonAdapter cartCommonAdapter;

	@Autowired
	private InterestAdapter interestAdapter;

	/**
	 * 获取购物车预览信息
	 *
	 * @param packs
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public CartVO previewCartPrice(List<? extends ProductPack> packs, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		final CartVO rt = new CartVO();
		if (CollectionUtils.isNotEmpty(packs)) {
			PrsCalPackDto arg0 = new PrsCalPackDto();
			List<Integer> interestId = new ArrayList<Integer>();
			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			priceAdapter.assemblePricepacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null, null,
					BigDecimal.ZERO, interestId, true, null, null);

			// 购物车预览价格计算结果
			logger.info("购物车预览价格查询");
			PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4Cart(arg0);

			logger.info("购物车预览价格查询 requestId={}", priceMap.getRequestId());

			List<PrsPriceStepVO> priceSteps = priceMap.getPriceStepVOs();

			// ====================xiugai==============

			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceMap.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map
			Map<PsProductVO, Boolean> hasVariantsMap = new HashMap<PsProductVO, Boolean>();

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
				// 多规格
				hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(psProductVOMap.values(), opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}
				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
			if (!singleGiftMap.isEmpty()) {
				for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
					if (CollectionUtils.isNotEmpty(entry.getValue())) {
						List<String> list = new ArrayList<String>();
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							list.add(pack.getProductId().toString());
						}
						singleGifts.put(entry.getKey().toString(), list);
					}
				}
			}
			List<String> adds = new ArrayList<String>();
			if (CollectionUtils.isNotEmpty(addList)) {
				for (PrsAdditionalPackVO add : addList) {
					adds.add(add.getProductId().toString());
				}
			}
			List<String> mutiGifts = new ArrayList<String>();
			if (!mutiGiftMap.isEmpty()) {
				for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : mutiGiftMap.entrySet()) {
					if (CollectionUtils.isNotEmpty(entry.getValue())) {
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							mutiGifts.add(pack.getProductId().toString());
						}
					}
				}
			}

			// 邮费
			BigDecimal postage = BigDecimal.ZERO;
			if (CollectionUtils.isNotEmpty(priceSteps)) {
				for (PrsPriceStepVO priceStep : priceSteps) {
					if (priceStep.getPriceType().equals(PrsPriceTypeEnum.POSTAGE)
							|| priceStep.getPriceType().equals(PrsPriceTypeEnum.POSTAGE_FREE))
						postage.add(priceStep.getPriceChange());
				}
			}
			// 最终价格
			BigDecimal price = priceMap.getFinalTotalPrice();
			// 优惠价
			BigDecimal savedPrice = priceMap.getOriginalTotalPrice().subtract(priceMap.getFinalTotalPrice());

			// 商品包是否海淘：取非加价购商品信息作为选中标准
			Boolean hasOverSea = false;
			for (ProductPack productPack : packs) {
				if (!CartPackSourceEnum.ADDIBLE.equals(productPack.getSource())) {
					hasOverSea = cartCommonAdapter.hasOversea(productPack);
				}
			}
			// 主商品
			List<ProductPack> rawPacks = Lists.newArrayList();
			for (ProductPack pack : packs) {
				if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
					rawPacks.add(pack);
				}
			}
			// 校验主品是否全部海淘或非海淘
			cartCommonAdapter.checkPacks(rawPacks, hasOverSea);
			// 权益商品
			Boolean hasBenefit = false;
			List<ProductPack> interestPacks = Lists.newArrayList();
			for (ProductPack pack : packs) {
				if (pack.getSource().equals(CartPackSourceEnum.BENEFIT)) {
					hasBenefit = true;
					interestPacks.add(pack);
				}
			}

			// 标签展示
			List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

			priceAdapter.getLabels(priceMap.getCartSettleLabelList(), mutiLabels, singleLabelMap);

			List<CartProductPackVO> validPackVos = getCartProductPackWithPrice(rawPacks, member, opChannel, accessWay,
					priceMap, singleGifts, psProductVOMap, singleLabelMap, stockMap);

			final MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode(member.getMemberLevel());

			forecastAdapter.setCartPackVOsForecast(validPackVos, memberLevel); // 购物车设置预售提醒
			// 权益商品benefit
			List<CartProductPackVO> interestPackVos = Lists.newArrayList();
			if (hasBenefit) {
				interestPackVos = cartProductPackAdaptor.getInterestCartProductPackList(interestPacks, member,
						accessWay);
			}
			validPackVos.addAll(interestPackVos);

			List<Integer> checkBenifitIds = new ArrayList<Integer>();

			if (CollectionUtils.isNotEmpty(priceMap.getPriceStepVOs())) {
				for (PrsPriceStepVO step : priceMap.getPriceStepVOs()) {
					if (step.getPriceType().equals(PrsPriceTypeEnum.BENIFIT) && null != step.getInterestGoodsVO()) {
						checkBenifitIds.add(step.getInterestGoodsVO().getInterestGoodsId());
					}
				}
			}
			// 权益商品设置有效提示
			cartAdapter.setBenefitPackVOsInvalid(validPackVos, checkBenifitIds, price);

			// 设置换购包
			List<PsProductVO> addProducts = new ArrayList<PsProductVO>();
			rt.setAddiblePacks(new ArrayList<CartProductPackVO>());
			if (CollectionUtils.isNotEmpty(adds)) {

				// 已选加价购商品包
				List<ProductPack> addiblePacks = cartCommonAdapter.getOwnedAddiblePackPrice(packs);

				for (String productId : adds) {
					addProducts.add(psProductVOMap.get(productId));
				}

				List<CartProductPackVO> addPacks = priceAdapter.getAddPacks(addProducts, priceMap.getPriceStepVOs(),
						addiblePacks, stockMap, hasVariantsMap, opChannel);

				rt.setAddiblePacks(addPacks);
			}

			// 设置多品赠品包
			List<PsProductVO> giftProducts = new ArrayList<PsProductVO>();
//			rt.setGiftPacks(new ArrayList<CartProductPackVO>());
			if (CollectionUtils.isNotEmpty(mutiGifts)) {
				for (String productId : mutiGifts) {
					giftProducts.add(psProductVOMap.get(productId));
				}
//				rt.setGiftPacks(priceAdapter.getMutiGiftPacks(giftProducts, priceMap.getPriceStepVOs(), stockMap,
//						hasVariantsMap));
			}

			// 多品标签（购物车预览时无论是否满足条件均显示标签）
			List<Label> cartLabels = new ArrayList<Label>();
			if (CollectionUtils.isNotEmpty(mutiLabels)) {
				for (PrsCartSettleLabelVO label : mutiLabels) {
					if (!label.getCampaignId().equals(-1L)) {
						cartLabels.add(priceAdapter.setupLabel(label));
					}
				}
			}
			// 运费标签
			cartLabels.addAll(labelService.getPostageLabel(price, hasOverSea, accessWay));
			rt.setLabels(cartLabels);
			rt.setPacks(validPackVos);
			rt.setPostage(postage);
			rt.setPrice(price);
			rt.setSavedPrice(savedPrice);
			rt.setAnnouncements(new ArrayList<AnnouncementVO>());
			rt.setGroups(new ArrayList<GroupsVO>());
			rt.setInterestPacks(new ArrayList<CartProductPackVO>());
			rt.setInvalidPacks(new ArrayList<CartProductPackVO>());
		}
		return rt;

	}

	/**
	 * 获取用户购物车（价格从价格服务取，没有多品lables，没有多品赠品，没有换购）
	 *
	 * @param cart
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public CartVO getCart(Cart cart, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		CartVO cartVo = new CartVO();
		List<CartProductPack> packs = cart.getProductPacks();

		if (CollectionUtils.isNotEmpty(packs)) {

			try {
				/**
				 * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品
				 * 3. 并把商品 走会员打折区分，并判断失效商品
				 */
				// 1 剔除所有的加价购商品
				Iterator<CartProductPack> iterator = packs.iterator();
				while (iterator.hasNext()) {
					CartProductPack pack = iterator.next();
					if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
						iterator.remove();
					}
				}

				// 拆分有效/无效商品包
				List<CartProductPack> invalidPacks = Lists.newArrayList();
				List<CartProductPack> validPacks = Lists.newArrayList();
				cartCommonAdapter.separateInvalid(packs, validPacks, invalidPacks, opChannel,
						MemberLevelEnum.getEnumByCode(member.getMemberLevel()));

				// 购物车价格计算只查询有效包，无效包忽略
				PrsCalPackDto arg0 = new PrsCalPackDto();

				List<Integer> interestId = new ArrayList<Integer>();
				Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
				priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, validPacks, member, opChannel, accessWay,
						null, null, BigDecimal.ZERO, interestId, true, null, null);

				if (CollectionUtils.isNotEmpty(arg0.getPackList())) {
					logger.info("获取购物车价格计算查询（同购物车预览）");
					PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4CartView(arg0);

					logger.info("购物车预览价格查询（同购物车预览） requestId={}", priceMap.getRequestId());
					List<Integer> checkBenifitIds = new ArrayList<Integer>();

					if (CollectionUtils.isNotEmpty(priceMap.getPriceStepVOs())) {
						for (PrsPriceStepVO step : priceMap.getPriceStepVOs()) {
							if (step.getPriceType().equals(PrsPriceTypeEnum.BENIFIT)
									&& null != step.getInterestGoodsVO()) {
								checkBenifitIds.add(step.getInterestGoodsVO().getInterestGoodsId());
							}
						}
					}
					// 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品

					/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

					Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
					List<String> productIds = new ArrayList<>();// 赠品productIdList
					Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

					// 从价格步骤中将需要的东西筛选出来
					priceAdapter.getAllGiftsStockAndCampaignMap(priceMap.getPriceStepVOs(), campaignMap, productIds,
							campaignCodeMap);

					/* 取库存取商品详情取限量 */
					Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
					Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
					Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

					if (CollectionUtils.isNotEmpty(productIds)) {
						// 取商详
						psProductVOMap = mcPsProductService.mapByProdIds(productIds);
						// 取库存
						stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
						// 取限量
						List<CampaignStreamVO> csList = new ArrayList<>();
						if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

							for (PsProductVO ppVO : psProductVOMap.values()) {

								CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
								campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
								campaignStreamVO.setProductCode(ppVO.getCode());
								csList.add(campaignStreamVO);
							}
							// 验证赠品限量库存
							ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
							if (srp.isSuccess() && srp.getBean() != null) {

								checkCspLimitMap.putAll(srp.getBean());
							}
						}
					}
					Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
					// 筛选赠一赠多
					priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

					/* 整理单品赠品、多品赠品、加价购包 */

					Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
					Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
					List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

					priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

					Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
					if (!singleGiftMap.isEmpty()) {
						for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
							if (CollectionUtils.isNotEmpty(entry.getValue())) {
								List<String> list = new ArrayList<String>();
								for (PrsAdditionalPackVO pack : entry.getValue()) {
									list.add(pack.getProductId().toString());
								}
								singleGifts.put(entry.getKey().toString(), list);
							}
						}
					}

					// 标签
					List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
					Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

					priceAdapter.getLabels(priceMap.getCartSettleLabelList(), mutiLabels, singleLabelMap);

					List<CartProductPackVO> validPackVOs = getCartProductPackWithPrice(validPacks, member, opChannel,
							accessWay, priceMap, singleGifts, psProductVOMap, singleLabelMap, stockMap);

					cartAdapter.setBenefitPackVOsInvalid(validPackVOs, checkBenifitIds, null); // 权益商品设置有效提示
					forecastAdapter.setCartPackVOsForecast(validPackVOs,
							MemberLevelEnum.getEnumByCode(member.getMemberLevel())); // 购物车设置预告提醒

					cartVo.setGroups(cartCommonAdapter.separateGroupPack(validPacks, validPackVOs));
				} else {
					cartVo.setGroups(Lists.<GroupsVO> newArrayList());
				}
				// 失效商品集合
				cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks, member,
						opChannel, accessWay));

			} catch (Exception e) {
				logger.error("===购物车 分隔失败    e={}", e);
			} finally {
				cartVo.setPrice(BigDecimal.ZERO);
				cartVo.setSavedPrice(BigDecimal.ZERO);
			}
		} else {
			cartVo.setGroups(Lists.<GroupsVO> newArrayList());
			cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
			cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
			logger.info("购物车没有商品信息====end");
		}
		return cartVo;
	}

	/**
	 *
	 * 组装pack
	 *
	 * @param packList
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @param priceMap
	 * @return
	 */
	public List<CartProductPackVO> getCartProductPackWithPrice(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay, PrsPacksPriceResultVO priceMap,
			Map<String, List<String>> singleGifts, Map<String, PsProductVO> psProductVOMap,
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap, Map<String, SSkuStockVO> stockMap) {
		return this.getCartProductPackWithPrice(packList, member, opChannel, accessWay, priceMap, singleGifts,
				psProductVOMap, singleLabelMap, stockMap, Boolean.FALSE);
	}

	/**
	 * 
	 * 组装pack
	 * 
	 * @param packList
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @param priceMap
	 * @return
	 */
	public List<CartProductPackVO> getCartProductPackWithPrice(List<? extends ProductPack> packList, MemberVO member,
			OpChannelVO opChannel, AccessWayEnum accessWay, PrsPacksPriceResultVO priceMap,
			Map<String, List<String>> singleGifts, Map<String, PsProductVO> psProductVOMap,
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap, Map<String, SSkuStockVO> stockMap,
			Boolean isSmartPos) {
		Date start = new Date();
		if (CollectionUtils.isEmpty(packList)) {
			return Lists.newArrayList();
		}
		logger.info("商品包不为空");
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packList.size());
		Map<Long, PsSpvVO> spvMap = Maps.newHashMapWithExpectedSize(packList.size());
		for (ProductPack pack : packList) {
			productMap.put(pack.getProductId().toString(), pack.getProduct());
			spvMap.put(pack.getSpvId(), pack.getSpv());
		}
		Collection<PsSpvVO> spvs = spvMap.values();
		List<CartProductPackVO> list = new ArrayList<>();
		// ===========spv map============
		logger.info("获取商品spv");
		Map<PsSpvVO, SpvVO> spvVoMap = spvPriceAdapter.getSpvMapWithSpvPrice(spvs, productMap, member, opChannel, null);

		// ===========spv label map============
		Map<PsSpvVO, List<Label>> spvLabelMap = spvAdapter.getSpvLabels(spvs, accessWay);

		// ===========product hasVariants map============
		Map<PsProductVO, Boolean> hasVariantsMap = null;
		hasVariantsMap = cartCommonAdapter.mapCheckHasVariants(productMap.values(), opChannel);
		// ==============================
		for (int i = 0; i < packList.size(); i++) {
			ProductPack pack = packList.get(i);
			PsProductVO product = productMap.get(pack.getProductId().toString());
			PsSpvVO spv = pack.getSpv();
			SpvVO spvVO = spvVoMap.get(spv);
			if (null != product && null != spvVO) {
				CartProductPackVO packVo = new CartProductPackVO();
				packVo.setId(pack.getId());
				List<Label> label = spvLabelMap.get(spv);
				if (label != null) {
					packVo.setLabels(Lists.newArrayList(label));
				}
				packVo.setCount(pack.getCount());
				packVo.setSource(EnumUtil.valueOf(pack.getSource().getCode(), CartPackSource.class));
				packVo.setProductId(product.getCode());
				packVo.setSpv(spvVO);
				packVo.setHasVariants(hasVariantsMap.get(product));
				if (spv.getSkuVO() != null && Integer.valueOf(1).equals(spv.getSkuVO().getCanCustomize())) {
					packVo.setCustomizable(true);
				}
				if (pack.isCustomize()) {
					List<UserSingleCustomization> userCustomizes = Lists.newArrayList();
					if (CollectionUtils.isNotEmpty(pack.getCustomizeList())) {
						for (CartCustomization cartCustomization : pack.getCustomizeList()) {
							UserSingleCustomization userSingleCustomization = new UserSingleCustomization();
							userSingleCustomization.setCode(cartCustomization.getCustomDimensionId());
							userSingleCustomization.setName(cartCustomization.getCustomDimensionName());
							userSingleCustomization.setValue(cartCustomization.getCustomDimensionValue());
							userCustomizes.add(userSingleCustomization);
						}
					}
					packVo.setCustomized(pack.isCustomize());
					packVo.setCustomizes(userCustomizes);
				}

				// 单品赠品
				List<PsProductVO> giftProducts = new ArrayList<PsProductVO>();
				if (CollectionUtils.isNotEmpty(singleGifts.get(spv.getSpvId().toString()))) {
					for (String productId : singleGifts.get(spv.getSpvId().toString())) {
						giftProducts.add(psProductVOMap.get(productId));
					}
					Map<PsProductVO, Boolean> giftVariantsMap = cartCommonAdapter
							.mapCheckHasVariants(psProductVOMap.values(), opChannel);

					List<CartProductPackVO> gifts = priceAdapter.getGiftPacks(giftProducts, priceMap.getPriceStepVOs(),
							pack.getSpvId(), stockMap, giftVariantsMap);
					packVo.setGiftPacks(gifts);
				}

				// 给pack加上单品活动标签
				if (singleLabelMap.size() > 0) {
					if (pack.getSource().equals(CartPackSourceEnum.RAW)) {
						if (CollectionUtils.isNotEmpty(singleLabelMap.get(packVo.getSpv().getId()))) {
							List<Label> singleLabels = new ArrayList<Label>();
							for (PrsCartSettleLabelVO single : singleLabelMap.get(packVo.getSpv().getId())) {
								singleLabels.add(priceAdapter.setupLabel(single));
							}
							packVo.setLabels(singleLabels);
						}
					}
				}

				// 如果是权益修改商品
				if (!CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
					list.add(packVo);
				} else {
					CartBenefitVO cartBenefitVO = interestAdapter.getCartBenefitVO(pack.getSourceBindVal());
					if (DateUtil.isInTime(null, cartBenefitVO.getCashEndTime(), null)) {
						packVo.setBenefit(cartBenefitVO);
						packVo.setHasVariants(interestAdapter.hasVariants(pack.getSourceBindVal()));
						packVo.setSpv(
								cartProductPackAdaptor.convertInterestSpvVO4PsSpvVO(spv, product, spvVO.getDiscount()));
						list.add(packVo);
					}
				}
			}
		}
		Map<Long, BigDecimal> spvPriceMap = priceMap.getSpvPriceMap();
		if (CollectionUtils.isNotEmpty(list)) {
			for (CartProductPackVO pack : list) {

				if (pack.getSource().equals(CartPackSource.BENEFIT)) {
					if (spvPriceMap.containsKey(-pack.getSpv().getId())
							&& spvPriceMap.get(-pack.getSpv().getId()).compareTo(BigDecimal.ZERO) != 0) {
						// pack.getSpv().setPrice(spvPriceMap.get(-pack.getSpv().getId()));
					} else {
						pack.getSpv().setPrice(BigDecimal.ZERO);
					}
				} else {
					pack.getSpv().setPrice(spvPriceMap.get(pack.getSpv().getId()));
				}
			}
		}

		Date end = new Date();
		logger.info("方法getCartProductPackList花费时间：{}毫秒", end.getTime() - start.getTime());
		return list;
	}

	/**
	 * 
	 * 购物车编辑适配
	 * 
	 * @param packs
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public List<CartProductPackVO> getModityPacks(List<CartProductPack> packs, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		List<CartProductPackVO> cartProductPackVOs = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			// 价格计算
			PrsCalPackDto arg0 = new PrsCalPackDto();
			List<Integer> interestId = new ArrayList<Integer>();
			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
			priceAdapter.assemblePriceCartpacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null, null,
					BigDecimal.ZERO, interestId, true, null, null);

			if (CollectionUtils.isEmpty(arg0.getPackList())) {
				logger.info("购物车价格计算组装包异常");
				return cartProductPackVOs;
			}
			logger.info("获取购物车价格计算查询（同购物车预览）");
			PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4CartView(arg0);

			logger.info("购物车预览价格查询（同购物车预览） requestId={}", priceMap.getRequestId());
			// ===============================================xiugai====================================

			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceMap.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}
				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
			if (!singleGiftMap.isEmpty()) {
				for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
					if (CollectionUtils.isNotEmpty(entry.getValue())) {
						List<String> list = new ArrayList<String>();
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							list.add(pack.getProductId().toString());
						}
						singleGifts.put(entry.getKey().toString(), list);
					}
				}
			}

			// ===============================================xiugai====================================
			// List<PsSpvVO> spvs = Lists.newArrayList();
			// for (CartProductPack pack : packs) {
			// PsSpvVO spv = pack.getSpv();
			// if (spv != null) {
			// spvs.add(spv);
			// }
			// }
			//
			// // // 有效商品vo
			// // List<CartProductPackVO> validPackVos =
			// // cartProductPackAdaptor.getCartProductPackListNew(packs,
			// member,
			// // opChannel, true, true, true, campaignResults, accessWay, true,
			// // null);
			//
			// Map<String, List<String>> singleGifts = new HashMap<String,
			// List<String>>();
			// List<String> mutiGifts = new ArrayList<String>();
			//
			// List<String> adds = new ArrayList<String>();
			//
			// Map<String, PsProductVO> psProductVOMap = new HashMap<String,
			// PsProductVO>();
			//
			// // pack赠品换购包
			// priceAdapter.getSingleGiftFromSteps(priceMap.getPriceStepVOs(),
			// mutiGifts, singleGifts, adds);
			// List<String> productIds = new ArrayList<>();
			//
			// Map<String, SSkuStockVO> stockMap = new HashMap<String,
			// SSkuStockVO>();
			//
			// if (null != singleGifts) {
			// for (Map.Entry<String, List<String>> singleGift :
			// singleGifts.entrySet()) {
			// productIds.addAll(singleGift.getValue());
			// }
			// psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
			//
			// }
			// 标签
			List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

			priceAdapter.getLabels(priceMap.getCartSettleLabelList(), mutiLabels, singleLabelMap);

			List<CartProductPackVO> validPackVOs = getCartProductPackWithPrice(packs, member, opChannel, accessWay,
					priceMap, singleGifts, psProductVOMap, singleLabelMap, stockMap);

			cartProductPackVOs.addAll(validPackVOs);
		}
		return cartProductPackVOs;
	}

	/**
	 * 
	 * 临时购物车编辑适配
	 * 
	 * @param packs
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public List<CartProductPackVO> getTempModityPacks(List<TempCartProductPack> packs, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		List<CartProductPackVO> cartProductPackVOs = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(packs)) {
			// 价格计算
			PrsCalPackDto arg0 = new PrsCalPackDto();
			List<Integer> interestId = new ArrayList<Integer>();
			Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();

			// 给一个默认会员
			MemberVO member = memberQueryService.getById(MemberConstant.DEFAULT_MEMBER_ID);

			priceAdapter.assemblePricepacks(interestGoodsMap, arg0, packs, member, opChannel, accessWay, null, null,
					BigDecimal.ZERO, interestId, true, null, null);

			logger.info("获取购物车价格计算查询（同购物车预览）");
			PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4CartView(arg0);

			logger.info("购物车预览价格查询（同购物车预览） requestId={}", priceMap.getRequestId());
			// ====================xiugai==============

			/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
			List<String> productIds = new ArrayList<>();// 赠品productIdList
			Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

			// 从价格步骤中将需要的东西筛选出来
			priceAdapter.getAllGiftsStockAndCampaignMap(priceMap.getPriceStepVOs(), campaignMap, productIds,
					campaignCodeMap);

			/* 取库存取商品详情取限量 */
			Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
			Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
			Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

			if (CollectionUtils.isNotEmpty(productIds)) {
				// 取商详
				psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// 取库存
				stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

				// 取限量
				List<CampaignStreamVO> csList = new ArrayList<>();
				if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

					for (PsProductVO ppVO : psProductVOMap.values()) {

						CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
						campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
						campaignStreamVO.setProductCode(ppVO.getCode());
						csList.add(campaignStreamVO);
					}
					// 验证赠品限量库存
					ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
					if (srp.isSuccess() && srp.getBean() != null) {

						checkCspLimitMap.putAll(srp.getBean());
					}
				}
			}
			Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
			// 筛选赠一赠多
			priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

			/* 整理单品赠品、多品赠品、加价购包 */

			Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
			Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
			List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

			priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

			Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
			if (!singleGiftMap.isEmpty()) {
				for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
					if (CollectionUtils.isNotEmpty(entry.getValue())) {
						List<String> list = new ArrayList<String>();
						for (PrsAdditionalPackVO pack : entry.getValue()) {
							list.add(pack.getProductId().toString());
						}
						singleGifts.put(entry.getKey().toString(), list);
					}
				}
			}

			// ====================xiugai==============

			// List<PsSpvVO> spvs = Lists.newArrayList();
			// for (TempCartProductPack pack : packs) {
			// PsSpvVO spv = pack.getSpv();
			// if (spv != null) {
			// spvs.add(spv);
			// }
			// }
			//
			// Map<String, List<String>> singleGifts = new HashMap<String,
			// List<String>>();
			// List<String> mutiGifts = new ArrayList<String>();
			//
			// List<String> adds = new ArrayList<String>();
			//
			// Map<String, PsProductVO> psProductVOMap = new HashMap<String,
			// PsProductVO>();
			//
			// // pack赠品换购包
			// priceAdapter.getSingleGiftFromSteps(priceMap.getPriceStepVOs(),
			// mutiGifts, singleGifts, adds);
			// List<String> productIds = new ArrayList<>();
			//
			// Map<String, SSkuStockVO> stockMap = new HashMap<String,
			// SSkuStockVO>();
			//
			// if (null != singleGifts) {
			// for (Map.Entry<String, List<String>> singleGift :
			// singleGifts.entrySet()) {
			// productIds.addAll(singleGift.getValue());
			// }
			// psProductVOMap = mcPsProductService.mapByProdIds(productIds);
			// stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);
			//
			// }
			// 标签
			List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
			Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

			priceAdapter.getLabels(priceMap.getCartSettleLabelList(), mutiLabels, singleLabelMap);

			List<CartProductPackVO> validPackVOs = getCartProductPackWithPrice(packs, member, opChannel, accessWay,
					priceMap, singleGifts, psProductVOMap, singleLabelMap, stockMap);

			cartProductPackVOs.addAll(validPackVOs);
		}
		return cartProductPackVOs;
	}

	/**
	 * 获取用户购物车（价格从价格服务取，没有多品lables，没有多品赠品，没有换购）
	 *
	 * @param cart
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public CartVO getTempCart(TempCart cart, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		CartVO cartVo = new CartVO();
		List<TempCartProductPack> packs = cart.getProductPacks();

		if (CollectionUtils.isNotEmpty(packs)) {

			try {
				/**
				 * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品
				 * 3. 并把商品 走会员打折区分，并判断失效商品
				 */
				// 1 剔除所有的加价购商品
				Iterator<TempCartProductPack> iterator = packs.iterator();
				while (iterator.hasNext()) {
					TempCartProductPack pack = iterator.next();
					if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
						iterator.remove();
					}
				}

				// 拆分有效/无效商品包
				List<TempCartProductPack> invalidPacks = Lists.newArrayList();
				List<TempCartProductPack> validPacks = Lists.newArrayList();
				cartCommonAdapter.separateInvalidByTemp(packs, validPacks, invalidPacks, opChannel);

				// 购物车价格计算只查询有效包，无效包忽略
				PrsCalPackDto arg0 = new PrsCalPackDto();

				List<Integer> interestId = new ArrayList<Integer>();
				Map<Long, InterestGoods> interestGoodsMap = new HashMap<Long, InterestGoods>();
				priceAdapter.assemblePricepacks(interestGoodsMap, arg0, validPacks, member, opChannel, accessWay,
						null, null, BigDecimal.ZERO, interestId, true, null, null);

				logger.info("获取购物车价格计算查询（同购物车预览）");
				PrsPacksPriceResultVO priceMap = prsPriceService.calculatePrs4CartView(arg0);

				if (priceMap == null) {
					cartVo.setPrice(BigDecimal.ZERO);
					cartVo.setSavedPrice(BigDecimal.ZERO);
					return cartVo;
				}

				logger.info("购物车预览价格查询（同购物车预览） requestId={}", priceMap.getRequestId());
				// 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品

				// Map<String, List<String>> singleGifts = new HashMap<String,
				// List<String>>();
				// List<String> mutiGifts = new ArrayList<String>();
				//
				// List<String> adds = new ArrayList<String>();
				//
				// Map<String, PsProductVO> psProductVOMap = new HashMap<String,
				// PsProductVO>();
				//
				// // pack赠品换购包
				// if (priceMap.getPriceStepVOs() != null) {
				// priceAdapter.getSingleGiftFromSteps(priceMap.getPriceStepVOs(),
				// mutiGifts, singleGifts, adds);
				// }
				//
				// List<String> productIds = new ArrayList<>();
				//
				// Map<String, SSkuStockVO> stockMap = new HashMap<String,
				// SSkuStockVO>();
				//
				// if (null != singleGifts) {
				// for (Map.Entry<String, List<String>> singleGift :
				// singleGifts.entrySet()) {
				// productIds.addAll(singleGift.getValue());
				// }
				// psProductVOMap = mcPsProductService.mapByProdIds(productIds);
				// stockMap = priceAdapter.forSpvLeft(psProductVOMap,
				// opChannel);
				//
				// }

				// ====================xiugai==============

				/* 从价格步骤里取出所有赠品productlist和以活动为key的赠品map */

				Map<PrsCampaignVO, List<PrsAdditionalPackVO>> campaignMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 以活动为key的赠品map
				List<String> productIds = new ArrayList<>();// 赠品productIdList
				Map<String, String> campaignCodeMap = new HashMap<>(); // 所有活动code

				// 从价格步骤中将需要的东西筛选出来
				priceAdapter.getAllGiftsStockAndCampaignMap(priceMap.getPriceStepVOs(), campaignMap, productIds,
						campaignCodeMap);

				/* 取库存取商品详情取限量 */
				Map<String, PsProductVO> psProductVOMap = new HashMap<String, PsProductVO>();// 商品map
				Map<String, SSkuStockVO> stockMap = new HashMap<String, SSkuStockVO>();// 库存map
				Map<String, Integer> checkCspLimitMap = new HashMap<>();// 限量map

				if (CollectionUtils.isNotEmpty(productIds)) {
					// 取商详
					psProductVOMap = mcPsProductService.mapByProdIds(productIds);
					// 取库存
					stockMap = priceAdapter.forSpvLeft(psProductVOMap, opChannel);

					// 取限量
					List<CampaignStreamVO> csList = new ArrayList<>();
					if (null != psProductVOMap && !psProductVOMap.isEmpty()) {

						for (PsProductVO ppVO : psProductVOMap.values()) {

							CampaignStreamVO campaignStreamVO = new CampaignStreamVO();
							campaignStreamVO.setCampaignCode(campaignCodeMap.get(ppVO.getId()));
							campaignStreamVO.setProductCode(ppVO.getCode());
							csList.add(campaignStreamVO);
						}
						// 验证赠品限量库存
						ServiceResp<Map<String, Integer>> srp = campaignLimitService.mapLeftCspLimitAmount(csList);
						if (srp.isSuccess() && srp.getBean() != null) {

							checkCspLimitMap.putAll(srp.getBean());
						}
					}
				}
				Map<PrsCampaignVO, List<PrsAdditionalPackVO>> resultMap = new HashMap<PrsCampaignVO, List<PrsAdditionalPackVO>>();// 筛选一次送后的活动map
				// 筛选赠一赠多
				priceAdapter.isOptinonGift(campaignMap, stockMap, checkCspLimitMap, resultMap, psProductVOMap);

				/* 整理单品赠品、多品赠品、加价购包 */

				Map<Long, List<PrsAdditionalPackVO>> singleGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 单品赠品map
				Map<Long, List<PrsAdditionalPackVO>> mutiGiftMap = new HashMap<Long, List<PrsAdditionalPackVO>>();// 多品赠品map
				List<PrsAdditionalPackVO> addList = new ArrayList<PrsAdditionalPackVO>();// 换购包

				priceAdapter.getGiftMapAndAdditionList(resultMap, singleGiftMap, mutiGiftMap, addList);

				Map<String, List<String>> singleGifts = new HashMap<String, List<String>>();
				if (!singleGiftMap.isEmpty()) {
					for (Map.Entry<Long, List<PrsAdditionalPackVO>> entry : singleGiftMap.entrySet()) {
						if (CollectionUtils.isNotEmpty(entry.getValue())) {
							List<String> list = new ArrayList<String>();
							for (PrsAdditionalPackVO pack : entry.getValue()) {
								list.add(pack.getProductId().toString());
							}
							singleGifts.put(entry.getKey().toString(), list);
						}
					}
				}

				// ====================xiugai==============

				// 标签
				List<PrsCartSettleLabelVO> mutiLabels = new ArrayList<PrsCartSettleLabelVO>();
				Map<Long, List<PrsCartSettleLabelVO>> singleLabelMap = new HashMap<Long, List<PrsCartSettleLabelVO>>();

				priceAdapter.getLabels(priceMap.getCartSettleLabelList(), mutiLabels, singleLabelMap);

				List<CartProductPackVO> validPackVOs = getCartProductPackWithPrice(validPacks, member, opChannel,
						accessWay, priceMap, singleGifts, psProductVOMap, singleLabelMap, stockMap);

				cartAdapter.setBenefitPackVOsInvalid(validPackVOs, null, null); // 权益商品设置有效提示
				forecastAdapter.setCartPackVOsForecast(validPackVOs,
						MemberLevelEnum.getEnumByCode(member.getMemberLevel())); // 购物车设置预售提醒

				cartVo.setGroups(cartCommonAdapter.separateGroupPack(validPacks, validPackVOs));
				// 失效商品集合
				cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks, member,
						opChannel, accessWay));

			} catch (

			Exception e)

			{
				logger.error("===购物车 分隔失败    e={}", e);
			} finally

			{
				cartVo.setPrice(BigDecimal.ZERO);
				cartVo.setSavedPrice(BigDecimal.ZERO);
			}

		} else {
			cartVo.setGroups(Lists.<GroupsVO> newArrayList());
			cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
			cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
			logger.info("购物车没有商品信息====end");
		}
		return cartVo;
	}

	/**
	 * 获取购物车信息
	 * 
	 * @param cart
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	public CartVO getMiniCart(Cart cart, MemberVO member, OpChannelVO opChannel, AccessWayEnum accessWay) {
		final List<CartProductPack> packs = cart.getProductPacks();
		final CartVO rt = new CartVO();
		if (CollectionUtils.isNotEmpty(packs)) {
			List<PsSpvVO> spvs = Lists.newArrayList();
			for (CartProductPack pack : packs) {
				if (pack.getSpv() != null) {
					spvs.add(pack.getSpv());
				}
			}

			// 拆分有效/无效商品包
			final List<CartProductPack> validPacks = Lists.newArrayList();
			final List<CartProductPack> invalidPacks = Lists.newArrayList();
			cartCommonAdapter.cartPackSeparateInvalidMini(packs, validPacks, invalidPacks, opChannel);

			BigDecimal sumPrice = BigDecimal.ZERO; // 总计金额

			// ========过滤掉加价购商品========
			for (int i = 0; i < validPacks.size(); i++) {
				CartProductPack pack = validPacks.get(i);
				if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
					validPacks.remove(i);
				}
			}

			// ========以下是转换vo实体=======
			// 有效商品vo
			final List<CartProductPackVO> validPackVos = cartProductPackAdaptor.getCartProductPackListNew(validPacks,
					member, opChannel, true, false, false, null, accessWay, true, null);
			for (CartProductPackVO pack : validPackVos) {
				if (null != pack.getSpv()) {
					sumPrice = sumPrice.add(pack.getSpv().getPrice());
				}
			}

			rt.setPacks(validPackVos);
			rt.setPrice(sumPrice);
		}
		return rt;
	}

	public CartVO getTempMiniCart(TempCart cart, OpChannelVO opChannel, AccessWayEnum accessWay) {
		final List<TempCartProductPack> packs = cart.getProductPacks();
		final CartVO rt = new CartVO();
		if (CollectionUtils.isNotEmpty(packs)) {
			MemberVO member = new MemberVO();
			member.setId(MemberConstant.DEFAULT_MEMBER_ID);
			member.setMemberLevel(MemberLevelEnum.NORMAL.getCode());

			List<PsSpvVO> spvs = Lists.newArrayList();
			for (TempCartProductPack pack : packs) {
				if (pack.getSpv() != null) {
					spvs.add(pack.getSpv());
				}
			}

			// 拆分有效/无效商品包
			final List<TempCartProductPack> validPacks = Lists.newArrayList();
			final List<TempCartProductPack> invalidPacks = Lists.newArrayList();
			cartCommonAdapter.tempCartPackSeparateInvalidMini(packs, validPacks, invalidPacks, opChannel);

			BigDecimal sumPrice = BigDecimal.ZERO; // 总计金额

			// ========过滤掉加价购商品========
			for (int i = 0; i < validPacks.size(); i++) {
				TempCartProductPack pack = validPacks.get(i);
				if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
					validPacks.remove(i);
				}
			}

			// ========以下是转换vo实体=======
			// 有效商品vo
			final List<CartProductPackVO> validPackVos = cartProductPackAdaptor.getCartProductPackListNew(validPacks,
					member, opChannel, true, false, false, null, accessWay, true, null);

			for (CartProductPackVO pack : validPackVos) {
				if (null != pack.getSpv()) {
					sumPrice = sumPrice.add(pack.getSpv().getPrice());
				}
			}

			rt.setPacks(validPackVos);
			rt.setPrice(sumPrice);
		}
		return rt;
	}

}
