package com.thebeastshop.pegasus.channelservice.adapter.cart;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.channelservice.model.PriceResult;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.support.enums.CartPackSource;

/**
 * 购物车预览 Created by GFL on 2017/11/2.
 */
@Component
public class CartPreviewAdapter {

	/**
	 * 获取购物车预览信息
	 *
	 * @param packs
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	// public CartVO previewCart(List<? extends ProductPack> packs, MemberVO
	// member, OpChannelVO opChannel,
	// AccessWayEnum accessWay) {
	// final CartVO rt = new CartVO();
	// if (CollectionUtils.isNotEmpty(packs)) {
	//
	// // 价格计算
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	// BigDecimal totalPrice = priceResult.getTotalPrice(); // 总金额
	// BigDecimal savedPrice = priceResult.getSavedPrice(); // 已优惠的金额
	//
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	//
	// // 定制费计算
	// BigDecimal customizePrice = priceService.calculateCustomizePrice(dto);
	// totalPrice = totalPrice.add(customizePrice);
	//
	// // 最终价格
	// BigDecimal price = PriceUtil.keepToCent(totalPrice.subtract(savedPrice));
	//
	// // 加价购商品包
	// List<ProductPack> addiblePacks = this.getAddiblePack(packs, priceResult);
	//
	// // 商品包是否海淘：取非加价购商品信息作为选中标准
	// Boolean hasOverSea = false;
	// for (ProductPack productPack : packs) {
	// if (!CartPackSource.ADDIBLE.equals(productPack.getSource())) {
	// hasOverSea = cartCommonAdapter.hasOversea(productPack);
	// }
	// }
	// // 主商品
	// List<ProductPack> rawPacks = Lists.newArrayList();
	// for (ProductPack pack : packs) {
	// if (pack.getSource().equals(CartPackSource.RAW)) {
	// rawPacks.add(pack);
	// }
	// }
	// // 校验主品是否全部海淘或非海淘
	// cartCommonAdapter.checkPacks(rawPacks, hasOverSea);
	// // 校验换购商品是否全部海淘或非海淘
	// cartCommonAdapter.checkPacks(addiblePacks, hasOverSea);
	//
	// // 权益商品
	// Boolean hasBenefit = false;
	// List<ProductPack> interestPacks = Lists.newArrayList();
	// for (ProductPack pack : packs) {
	// if (pack.getSource().equals(CartPackSource.BENEFIT)) {
	// hasBenefit = true;
	// interestPacks.add(pack);
	// }
	// }
	//
	// // ========商品包实体是转换vo实体=======
	// // 加价购商品vo
	// List<CartProductPackVO> addiblePackVos = Lists.newArrayList();
	// if (CollectionUtils.isNotEmpty(addiblePacks)) {
	// addiblePackVos =
	// cartProductPackAdaptor.getAddibleCartProductPackList(addiblePacks,
	// member, opChannel,
	// accessWay);
	// }
	// rt.setAddiblePacks(addiblePackVos);
	//
	// // 主商品vo
	// final List<CartProductPackVO> validPackVos =
	// cartProductPackAdaptor.getCartProductPackListNew(rawPacks,
	// member, opChannel, true, true, true, campaignResults, accessWay, true,
	// null);
	//
	// forecastAdapter.setCartPackVOsForecast(validPackVos,
	// MemberLevelEnum.getEnumByCode(member.getMemberLevel())); // 购物车设置预售提醒
	// // 权益商品
	// List<CartProductPackVO> interestPackVos = Lists.newArrayList();
	// if (hasBenefit) {
	// interestPackVos =
	// cartProductPackAdaptor.getInterestCartProductPackList(interestPacks,
	// member,
	// accessWay);
	// }
	// validPackVos.addAll(interestPackVos);
	//
	// // 权益商品设置有效提示
	// cartAdapter.setBenefitPackVOsInvalid(validPackVos, price);
	//
	// rt.setGiftPacks(cartProductPackAdaptor.getCartGiftCartProductPackList(campaignResults,
	// member, opChannel,
	// accessWay));
	//
	// List<Label> cartLabels = labelService.getCartLabels(campaignResults,
	// accessWay);
	// // 运费标签
	// cartLabels.addAll(labelService.getPostageLabel(price, hasOverSea,
	// accessWay));
	// rt.setLabels(cartLabels);
	// rt.setPacks(validPackVos);
	//
	// // 邮费
	// BigDecimal postage = postageService.calculatePostageNew(packs, price,
	// member, hasOverSea);
	// rt.setPostage(postage);
	// rt.setPrice(price);
	// rt.setSavedPrice(PriceUtil.keepToCent(savedPrice));
	//
	// // 配送仓
	// cartProductPackAdaptor.filterFromFurniture(rt, packs, opChannel);
	// }
	// return rt;
	// }

	/**
	 * 获取加价购商品
	 *
	 * @param packs
	 * @param priceResult
	 * @return
	 */
	private List<ProductPack> getAddiblePack(List<? extends ProductPack> packs, PriceResult priceResult) {

		List<ProductPack> addiblePacks = Lists.newArrayList();
		List<ProductPack> cheapenOtherPacks = Lists.newArrayList(); // 已换购的商品
		for (ProductPack pack : packs) {
			if (pack.getSource().equals(CartPackSourceEnum.ADDIBLE)) {
				cheapenOtherPacks.add(pack);
			}
		}
		// ========加价购的商品包========
		List<CampaignResult> campaignResults = priceResult.getCampaignResults();
		if (CollectionUtils.isNotEmpty(campaignResults)) {
			for (CampaignResult campaignResult : campaignResults) {
				DiscountType discountType = campaignResult.getDiscountType();
				if (campaignResult.isReach() && discountType == DiscountType.CHEAPEN_OTHER) {
					Collection<ProductPack> additionalPacks = campaignResult.getAdditionalPacks();
					for (ProductPack productPack : additionalPacks) {
						Iterator<ProductPack> iterator = cheapenOtherPacks.iterator();
						while (iterator.hasNext()) {
							ProductPack next = iterator.next();
							if (productPack.getProductId().equals(next.getProductId())) {
								productPack.setId(next.getId());
								productPack.setSpv(next.getSpv());
								productPack.setSpvId(next.getSpvId());
								break;
							}
						}
					}
					addiblePacks.addAll(additionalPacks);
				}
			} // for
		}
		return addiblePacks;
	}

}
