package com.thebeastshop.pegasus.channelservice.adapter.cart;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.thebeastshop.pegasus.channelservice.adapter.campaign.CampaignAdapter;
import com.thebeastshop.pegasus.channelservice.adapter.product.ForecastAdapter;
import com.thebeastshop.pegasus.channelservice.service.PriceService;
import com.thebeastshop.pegasus.component.campaign.service.CampaignServiceNew;
import com.thebeastshop.pegasus.component.channel.service.ChannelService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;

/**
 * Created by GFL on 2017/11/1.
 */
@Component
public class CartNewAdapter {

	private Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private CartProductPackAdapter cartProductPackAdaptor;

	@Autowired
	private PriceService priceService;

	@Autowired
	private CampaignAdapter campaignAdaptor;

	private CampaignServiceNew campaignServiceNew = ComponentServiceLoader.getBean(CampaignServiceNew.class);

	private ChannelService channelService = ComponentServiceLoader.getBean(ChannelService.class);

	@Autowired
	private CartAdapter cartAdapter;
	@Autowired
	private ForecastAdapter forecastAdapter;

	@Autowired
	private CartCommonAdapter cartCommonAdapter;

	/**
	 * 这个方法是给 购物车列表用的 用户对 购物车里面的信息 进行封装 区分 普通购物车 和 海外购购物车
	 *
	 * @param cart
	 * @param member
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	// public CartVO getCartVO(Cart cart, MemberVO member, OpChannelVO
	// opChannel, AccessWayEnum accessWay) {
	// CartVO cartVo = new CartVO();
	// try {
	// /**
	// * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品 3.
	// * 并把商品 走会员打折区分，并判断失效商品
	// */
	// List<CartProductPack> packs = cart.getProductPacks();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 1 剔除所有的加价购商品
	// Iterator<CartProductPack> iterator = packs.iterator();
	// while (iterator.hasNext()) {
	// CartProductPack pack = iterator.next();
	// if (null != pack && CartPackSource.ADDIBLE.equals(pack.getSource())) {
	// iterator.remove();
	// }
	// }
	//
	// // 拆分有效/无效商品包
	// List<CartProductPack> invalidPacks = Lists.newArrayList();
	// List<CartProductPack> validPacks = Lists.newArrayList();
	// cartCommonAdapter.separateInvalid(packs, validPacks, invalidPacks,
	// opChannel,
	// MemberLevelEnum.getEnumByCode(member.getMemberLevel()));
	//
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	//
	// // 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品
	// List<CartProductPackVO> validPackVOs =
	// cartProductPackAdaptor.getCartProductPackListNew(validPacks,
	// member, opChannel, true, true, true, campaignResults, accessWay, true,
	// null);
	// cartAdapter.setBenefitPackVOsInvalid(validPackVOs, null); // 权益商品设置有效提示
	// forecastAdapter.setCartPackVOsForecast(validPackVOs,
	// MemberLevelEnum.getEnumByCode(member.getMemberLevel())); // 购物车设置预售提醒
	// cartVo.setGroups(cartCommonAdapter.separateGroupPack(validPacks,
	// validPackVOs));
	// // 失效商品集合
	// cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks,
	// member,
	// opChannel, accessWay));
	//
	// } else {
	// cartVo.setGroups(Lists.<GroupsVO> newArrayList());
	// cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
	// cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
	// logger.info("购物车没有商品信息====end");
	// }
	// } catch (Exception e) {
	// logger.error("===购物车 分隔失败 e={}", e);
	// } finally {
	// cartVo.setPrice(BigDecimal.ZERO);
	// cartVo.setSavedPrice(BigDecimal.ZERO);
	// }
	// return cartVo;
	// }

	/**
	 * 这个方法是给 购物车列表用的 用户对 购物车里面的信息 进行封装 区分 普通购物车 和 海外购购物车
	 * 
	 * @param cart
	 * @param building
	 * @param opChannel
	 * @param accessWay
	 * @return
	 */
	// public CartVO getTempCartVO(TempCart cart, String building, OpChannelVO
	// opChannel, AccessWayEnum accessWay) {
	// logger.info("===进入临时购物车列表查询分隔 ==参数
	// cart={},building={},channel={},accessWay={}", cart, building, opChannel,
	// accessWay);
	// CartVO cartVo = new CartVO();
	// try {
	// List<TempCartProductPack> invalidPacks = new ArrayList<>();// 失效综合
	// MemberLevelEnum memberLevel = MemberLevelEnum.NORMAL;
	// MemberVO member = new MemberVO();
	// member.setId(MemberConstant.DEFAULT_MEMBER_ID);
	// member.setMemberLevel(memberLevel.getCode());
	// /**
	// * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品 3.
	// * 并把商品 走会员打折区分，并判断失效商品
	// */
	// List<TempCartProductPack> packs = cart.getProductPacks();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 1 剔除所有的加价购商品
	// Iterator<TempCartProductPack> iterator = packs.iterator();
	// while (iterator.hasNext()) {
	// TempCartProductPack pack = iterator.next();
	// if (null != pack && CartPackSource.ADDIBLE.equals(pack.getSource())) {
	// iterator.remove();
	// }
	// }
	//
	// // 拆分有效/无效商品包
	// List<TempCartProductPack> validPacks = Lists.newArrayList();
	// cartCommonAdapter.separateInvalidByTemp(packs, validPacks, invalidPacks,
	// opChannel);
	//
	// List<CampaignHandler> campaignHandlers =
	// campaignAdaptor.getCampaignHandlers(validPacks, accessWay);
	//
	// Channel channel = channelService.getByCode(opChannel.getCode());
	//
	// List<CampaignResult> campaignResults =
	// campaignServiceNew.match(campaignHandlers, validPacks, channel);
	//
	// List<CartProductPackVO> validPackVOs =
	// cartProductPackAdaptor.getCartProductPackListNew(validPacks,
	// member, opChannel, true, true, true, campaignResults, accessWay, true,
	// null);
	// forecastAdapter.setCartPackVOsForecast(validPackVOs, memberLevel); //
	// 购物车设置预售提醒
	//
	// // 2.商品分组
	// cartVo.setGroups(cartCommonAdapter.separateGroupPack(validPacks,
	// validPackVOs));
	// // 失效商品集合
	// cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks,
	// member,
	// opChannel, accessWay));
	//
	// } else {
	// cartVo.setGroups(Lists.<GroupsVO> newArrayList());
	// cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
	// cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
	// logger.info("购物车没有商品信息====end");
	// }
	// } catch (Exception e) {
	// logger.error("===购物车 分隔失败 e={}", e);
	// } finally {
	// cartVo.setPrice(BigDecimal.ZERO);
	// cartVo.setSavedPrice(BigDecimal.ZERO);
	// }
	// return cartVo;
	// }

	/**
	 * 组合成需要的数据group的
	 *
	 * @param packs
	 * @param type
	 *            1 是海外购 2是普通
	 * @return
	 */

	/**
	 * 将商品包里面的商品拆分成两个 海淘和 普通商品
	 *
	 * @param packVOs
	 *            购物车中的商品包
	 * @param overSeaPackVOs
	 *            是海外购的商品
	 * @param normalPacks
	 *            不是海外购的商品 普通商品
	 * @author lijing
	 */

	/**
	 * 拆分有效无效商品包： 权益商品为有效商品
	 *
	 * @param packs
	 * @param validPacks
	 * @param invalidPacks
	 * @param opChannel
	 */

}
