package com.thebeastshop.pegasus.channelservice.adapter.cart;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.cart.service.CartService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 购物车权益适配
 * Created by feilong.gao on 2017/1/16.
 */
@Service
public class CartInterestAdapter {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private CartService cartService;

    @Autowired
    private McPsProductService mcPsProductService;


    /**
     * 保存权益到购物车
     *
     * @param memberId
     * @param interestGoodsGetVO
     * @return
     */
    public boolean saveInterest2Cart(Long memberId, InterestGoodsGetVO interestGoodsGetVO) {
        try{
            logger.info("保存权益商品到购物车入参:memberId:{} interestGetVO:{}", memberId, JSON.toJSONString(interestGoodsGetVO));
            CartProductPack cartProductPack = new CartProductPack();
            cartProductPack.setSource(CartPackSourceEnum.BENEFIT);
            cartProductPack.setOwnerId(memberId);
            cartProductPack.setFactProductPrice(BigDecimal.ZERO);
            cartProductPack.setCount(1);
            //设置spvId
            PsProductVO psProductVO = mcPsProductService.findProdByCode(interestGoodsGetVO.getProcutCode());
            for (PsSpvVO spv : psProductVO.getSpvList()) {
                if (spv.getSkuCode().equalsIgnoreCase(interestGoodsGetVO.getSkuCode())) {
                    cartProductPack.setSpvId(spv.getSpvId());
                    cartProductPack.setProductId(spv.getProductId());
                    cartProductPack.setSourceBindVal(interestGoodsGetVO.getInterestGoodsId().toString());
                    break;
                }
            }

            CartProductPack result = cartService.saveInterestPack(cartProductPack);
            if (null != result) {
                return true;
            }

        }catch (Exception e){
            logger.error("保存权益商品到购物车异常：",e);
        }
        return false;
    }


}
