package com.thebeastshop.pegasus.channelservice.adapter.cart;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.NumberUtil;
import com.thebeastshop.pegasus.channelservice.adapter.interest.InterestAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.Cart;
import com.thebeastshop.cart.resp.CartProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.vo.cart.CartBenefitVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;

/**
 * 购物车适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class CartAdapter {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	InterestAdapter interestAdapter;

	/**
	 * 拆分有效无效商品包： 权益商品为有效商品
	 * 
	 * @param packs
	 * @param validPacks
	 * @param invalidPacks
	 * @param opChannel
	 */
	private void separateInvalid(List<CartProductPack> packs, List<CartProductPack> validPacks,
			List<CartProductPack> invalidPacks, OpChannelVO opChannel) {
		if (CollectionUtils.isNotEmpty(packs)) {
			for (CartProductPack pack : packs) {
				if (CartPackSourceEnum.BENEFIT.equals(pack.getSource())) {
					CartBenefitVO cartBenefitVO = interestAdapter.getCartBenefitVO(pack.getSourceBindVal());
					if (DateUtil.isInTime(null, cartBenefitVO.getCashEndTime(), null)) {
						validPacks.add(pack);
					}else{
						invalidPacks.add(pack);
					}
					// 抢购活动暂不验证库存
				} else if (CollectionUtils.isNotEmpty(pack.getSpv().getCampaignList())) {

					boolean bool = true;

					for (PsCampaignVO psCampaignVO : pack.getSpv().getCampaignList()) {

						// 抢购活动
						if (psCampaignVO.getDiscountTypeId() == 6) {
							validPacks.add(pack);
							bool = false;
							break;
						}

					}
					// 没有抢购活动，需要验证库存
					if (bool) {
						PsProductVO product = pack.getProduct();
						PsSpvVO spv = pack.getSpv();
						if (null != product && null != spv) {
							boolean isValid = isProductValid(product, spv.getCanUseQuantity(), opChannel);
							if (isValid) {
								validPacks.add(pack);
							} else {
								invalidPacks.add(pack);
							}
						}

					}
				} else {
					PsProductVO product = pack.getProduct();
					PsSpvVO spv = pack.getSpv();

					if (null != product && null != spv) {
						boolean isValid = isProductValid(product, spv.getCanUseQuantity(), opChannel);
						if (isValid) {
							validPacks.add(pack);
						} else {
							invalidPacks.add(pack);
						}
					}
				}
			}
		}
	}

	private boolean isProductValid(PsProductVO product, Integer spvStock, OpChannelVO opChannel) {
		boolean isCanSaleSku = EmptyUtil.isNotEmpty(product.getCanSaleSku(opChannel.getCode())); // 是否可售
		if (!isCanSaleSku) {
			return false;
		}

		boolean isOnShelf = true; // 是否上架
		List<String> onShelfChnCodes = product.getOnShelfChnCodes();
		if (EmptyUtil.isEmpty(onShelfChnCodes))
			isOnShelf = false;
		if (!onShelfChnCodes.contains(opChannel.getCode()))
			isOnShelf = false;
		if (!isOnShelf) {
			return false;
		}

		// 是否售罄
		if (spvStock == null || spvStock <= 0) {
			return false;
		}
		return true;
	}

	// ==================华丽丽的分割线===================

//	/**
//	 * 这个方法是给 购物车列表用的 用户对 购物车里面的信息 进行封装 区分 普通购物车 和 海外购购物车
//	 *
//	 * @author lijing
//	 * @param cart
//	 * @param member
//	 * @param channel
//	 * @param accessWay
//	 * @return
//	 */
	// public CartVO getGroupByList(Cart cart, MemberVO member, OpChannelVO
	// opChannel, AccessWay accessWay) {
	// CartVO cartVo = new CartVO();
	// try {
	// final MemberLevelEnum memberLevel =
	// MemberLevelEnum.getEnumByCode(member.getMemberLevel());
	// List<GroupsVO> groupsVOs = new ArrayList<>();
	// List<CartProductPack> invalidPacks = Lists.newArrayList();
	// /**
	// * 步骤分为 3步 1. 把查询出来的 加价购 踢除， 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品 3.
	// * 并把商品 走会员打折区分，并判断失效商品
	// */
	// List<CartProductPack> packs = cart.getProductPacks();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 1 剔除所有的加价购商品
	// Iterator<CartProductPack> iterator = packs.iterator();
	// while (iterator.hasNext()) {
	// CartProductPack pack = iterator.next();
	// if (null != pack && CartPackSource.ADDIBLE.equals(pack.getSource())) {
	// iterator.remove();
	// }
	// }
	//
	// // 库存验证start
	// //Map<PsSpvVO, Integer> spvStockMap = Maps.newLinkedHashMap();
	//
	// //setSpvStockMap(packs,channel,spvStockMap);
	// // 库存验证end
	//
	// // 拆分有效/无效商品包
	// List<CartProductPack> validPacks = Lists.newArrayList();
	// separateInvalid(packs, validPacks, invalidPacks, opChannel);
	//
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	//
	// // 2. 把所有商品 分成 2个集合 一个是 海外购 一个是 普通商品
	// List<CartProductPackVO> overSeaPackVOs = new
	// ArrayList<CartProductPackVO>();
	// List<CartProductPackVO> normalPackVOs = new
	// ArrayList<CartProductPackVO>();
	// List<CartProductPackVO> validPackVOs =
	// cartProductPackAdaptor.getCartProductPackListNew(validPacks, member,
	// opChannel, true, true, true, campaignResults, accessWay, true,null);
	//
	// this.setBenefitPackVOsInvalid(validPackVOs,null); // 权益商品设置有效提示
	// // 拆分海淘/普通商品
	// separateOverSeaPack(validPackVOs, overSeaPackVOs, normalPackVOs,
	// validPacks);
	//
	// // 当新加商品为海淘时，海淘组放在上面，反之亦然
	// PsProductVO product = null;
	// if (CollectionUtils.isNotEmpty(validPacks)) {
	// CartProductPack firstPack = validPacks.get(0);
	// product = firstPack.getProduct();
	// }
	// if (product != null && product.getCrossBorderFlag() != null &&
	// product.getCrossBorderFlag().equals(1)) {
	// if (CollectionUtils.isNotEmpty(overSeaPackVOs)) {
	// GroupsVO groupsVO = getGroupVO(overSeaPackVOs, invalidPacks, 1);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// if (CollectionUtils.isNotEmpty(normalPackVOs)) {
	// GroupsVO groupsVO = getGroupVO(normalPackVOs, invalidPacks, 2);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// } else {
	// if (CollectionUtils.isNotEmpty(normalPackVOs)) {
	// GroupsVO groupsVO = getGroupVO(normalPackVOs, invalidPacks, 2);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	// if (CollectionUtils.isNotEmpty(overSeaPackVOs)) {
	// GroupsVO groupsVO = getGroupVO(overSeaPackVOs, invalidPacks, 1);
	// if (null != groupsVO) {
	// groupsVOs.add(groupsVO);
	// }
	// }
	//
	// }
	// logger.info("设置分组");
	// // 设置分组 名称 针对一个
	// setGroupsVOOne(groupsVOs);
	// cartVo.setGroups(groupsVOs);
	// logger.info("失效商品集合");
	// // 失效商品集合
	// cartVo.setInvalidPacks(cartProductPackAdaptor.getInvalidCartProductPackList(invalidPacks,
	// member, opChannel, accessWay));
	// // 公告
	// logger.info("公告");
	// cartVo.setAnnouncements(
	// announcementAdaptor.getAnnouncement(announcementService.getAvailable(accessWay,
	// memberLevel)));
	// } else {
	// cartVo.setGroups(Lists.<GroupsVO> newArrayList());
	// cartVo.setInvalidPacks(Lists.<CartProductPackVO> newArrayList());
	// cartVo.setAnnouncements(Lists.<AnnouncementVO> newArrayList());
	// logger.info("购物车没有商品信息====end");
	// }
	// } catch (Exception e) {
	// logger.error("===购物车 分隔失败 e={}", e);
	// } finally {
	// cartVo.setPrice(BigDecimal.ZERO);
	// cartVo.setSavedPrice(BigDecimal.ZERO);
	// }
	// return cartVo;
	// }

//	/**
//	 * 判断 当前分组 只有一个 的时候 是设置标题和描述
//	 *
//	 * @auhtro lijing 产品需求
//	 * @param groupsVOOne
//	 */
	// public void setGroupsVOOne(List<GroupsVO> groupsVOOne) {
	// if (CollectionUtils.isNotEmpty(groupsVOOne) && 1 == groupsVOOne.size()) {
	// groupsVOOne.get(0).setDescription("");
	// groupsVOOne.get(0).setTitle("全选");
	// }
	// }

	// ====lijing 修改购物车 时候 的搭配packs
	// public List<CartProductPackVO> getModityPacks(List<CartProductPack>
	// packs, MemberVO member, OpChannelVO opChannel,
	// AccessWayEnum accessWay) {
	// List<CartProductPackVO> cartProductPackVOs = new ArrayList<>();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// // 价格计算
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	//
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv != null) {
	// spvs.add(spv);
	// }
	// }
	// // Map<PsSpvVO, Integer> spvStockMap = Maps.newHashMap();
	// // for (PsSpvVO spv : spvs) {
	// // spvStockMap.put(spv, Integer.MAX_VALUE);
	// // }
	// // Map<PsSpvVO, Integer> spvStockMap =
	// // productWarehouseService.mapSpvsStock(spvs,
	// // channel.getWarehouseCode());
	//
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	//
	// // 有效商品vo
	// List<CartProductPackVO> validPackVos =
	// cartProductPackAdaptor.getCartProductPackListNew(packs, member,
	// opChannel, true, true, true, campaignResults, accessWay, true, null);
	//
	// cartProductPackVOs.addAll(validPackVos);
	// }
	// return cartProductPackVOs;
	// }

	// =====end

//	/**
//	 * 获取购物车预览信息
//	 *
//	 * @param packs
//	 * @param member
//	 * @param channel
//	 * @param accessWay
//	 * @return
//	 */
	// public CartVO preview(List<CartProductPack> packs, MemberVO member,
	// OpChannelVO opChannel,
	// AccessWayEnum accessWay) {
	// final CartVO rt = new CartVO();
	// if (CollectionUtils.isNotEmpty(packs)) {
	// List<PsSpvVO> spvs = Lists.newArrayList();
	// List<CartProductPack> cheapenOtherPacks =
	// Lists.newArrayListWithExpectedSize(packs.size()); // 已换购的商品
	// for (CartProductPack pack : packs) {
	// PsSpvVO spv = pack.getSpv();
	// if (spv != null) {
	// spvs.add(spv);
	// }
	// if (pack.getSource().equals(CartPackSource.ADDIBLE)) {
	// cheapenOtherPacks.add(pack);
	// }
	// }
	// // Map<PsSpvVO, Integer> spvStockMap = Maps.newHashMap();
	// // for (PsSpvVO spv : spvs) {
	// // spvStockMap.put(spv, Integer.MAX_VALUE);
	// // }
	// // Map<PsSpvVO, Integer> spvStockMap =
	// // productWarehouseService.mapSpvsStock(spvs,
	// // channel.getWarehouseCode());
	//
	// final MemberLevelEnum memberLevel =
	// MemberLevelEnum.getEnumByCode(member.getMemberLevel());
	//
	// // 价格计算
	// CalculateProductPackDTO dto = new CalculateProductPackDTO();
	// dto.setAccessWay(accessWay);
	// dto.setOpChannel(opChannel);
	// dto.setMember(member);
	// dto.setPacks(packs);
	// PriceResult priceResult = priceService.calculateProductPackPrice(dto);
	//
	// BigDecimal totalPrice = priceResult.getTotalPrice(); // 总金额
	// BigDecimal savedPrice = priceResult.getSavedPrice(); // 已优惠的金额
	//
	// // 定制费计算
	// BigDecimal customizePrice = priceService.calculateCustomizePrice(dto);
	// totalPrice = totalPrice.add(customizePrice);
	//
	// List<ProductPack> addiblePacks = Lists.newArrayList();// 加价购的商品包
	// List<CampaignResult> campaignResults = priceResult.getCampaignResults();
	// if (CollectionUtils.isNotEmpty(campaignResults)) {
	// for (int i = 0, size = campaignResults.size(); i < size; i++) {
	// final CampaignResult campaignResult = campaignResults.get(i);
	// final DiscountType discountType = campaignResult.getDiscountType();
	// if (campaignResult.isReach()) {
	// if (discountType.equals(DiscountType.CHEAPEN_OTHER)) {// 加价购：丢到后面加价购框框里。
	// Collection<ProductPack> additionalPacks =
	// campaignResult.getAdditionalPacks();
	// for (ProductPack productPack : additionalPacks) {
	// Iterator<CartProductPack> iterator = cheapenOtherPacks.iterator();
	// while (iterator.hasNext()) {
	// CartProductPack next = iterator.next();
	// if (productPack.getProductId().equals(next.getProductId())) {
	// productPack.setId(next.getId());
	// productPack.setSpv(next.getSpv());
	// productPack.setSpvId(next.getSpvId());
	// productPack.setCount(next.getCount());
	// break;
	// }
	// }
	// }
	// addiblePacks.addAll(additionalPacks);
	// }
	// }
	// }
	// }
	//
	// // 主商品
	// List<CartProductPack> rawPacks = Lists.newArrayList();
	// for (CartProductPack pack : packs) {
	// if (pack.getSource().equals(CartPackSource.RAW)) {
	// rawPacks.add(pack);
	// }
	// }
	//
	// // 权益商品
	// List<CartProductPack> interestPacks = Lists.newArrayList();
	// for (CartProductPack pack : packs) {
	// if (pack.getSource().equals(CartPackSource.BENEFIT)) {
	// interestPacks.add(pack);
	// }
	// }
	//
	// // 校验是否同时包含海淘和普通商品
	// Boolean b = checkHasOverseaAndNormalPack(rawPacks, addiblePacks);
	// if (b) {
	// throw new WrongArgException("预览接口必须全是海淘或是普通的！");
	// }
	//
	// // 最终价格
	// BigDecimal price = PriceUtil.keepToCent(totalPrice.subtract(savedPrice));
	//
	// // ========以下是转换vo实体=======
	// // 加价购商品vo
	// final List<CartProductPackVO> addiblePackVos = cartProductPackAdaptor
	// .getAddibleCartProductPackList(addiblePacks, member, opChannel,
	// accessWay);
	// // 主商品vo
	// final List<CartProductPackVO> validPackVos =
	// cartProductPackAdaptor.getCartProductPackListNew(rawPacks,
	// member, opChannel, true, true, true, campaignResults, accessWay, true,
	// null);
	// // 权益商品vo
	// List<CartProductPackVO> interestPackVos = cartProductPackAdaptor
	// .getInterestCartProductPackList(interestPacks, member, accessWay);
	// validPackVos.addAll(interestPackVos);
	//
	// this.setBenefitPackVOsInvalid(interestPackVos, price); // 权益商品设置有效提示
	// forecastAdapter.setCartPackVOsForecast(validPackVos, memberLevel); //
	// 主品设置预售提醒
	//
	// rt.setAnnouncements(
	// announcementAdaptor.getAnnouncement(announcementService.getAvailable(accessWay,
	// memberLevel)));
	// // rt.setInterestPacks(interestPackVos);
	// rt.setAddiblePacks(addiblePackVos);
	// rt.setGiftPacks(cartProductPackAdaptor.getCartGiftCartProductPackList(campaignResults,
	// member, opChannel,
	// accessWay));
	// List<Label> cartLabels = labelService.getCartLabels(campaignResults,
	// accessWay);
	//
	// boolean hasOverSea = overseaService.isOversea(rawPacks);
	// cartLabels.addAll(labelService.getPostageLabel(price, hasOverSea,
	// accessWay));
	// rt.setLabels(cartLabels);
	// rt.setPacks(validPackVos);
	// // 邮费
	// BigDecimal postage = postageService.calculatePostageNew(packs, price,
	// member, hasOverSea);
	// rt.setPostage(postage);
	// rt.setPrice(price);
	// rt.setSavedPrice(PriceUtil.keepToCent(savedPrice));
	// }
	// return rt;
	// }

	public List<CartProductPack> getInvalidPack(Cart cart, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		final List<CartProductPack> packs = cart.getProductPacks();
		// ========过滤掉加价购商品。========
		Iterator<CartProductPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			CartProductPack pack = iterator.next();
			if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
				iterator.remove();
			}
		}

		// 拆分有效/无效商品包
		final List<CartProductPack> validPacks = Lists.newArrayList();
		final List<CartProductPack> invalidPacks = Lists.newArrayList();
		separateInvalid(packs, validPacks, invalidPacks, opChannel);

		return invalidPacks;
	}

	public List<CartProductPack> getValidPack(Cart cart, MemberVO member, OpChannelVO opChannel,
			AccessWayEnum accessWay) {
		final List<CartProductPack> packs = cart.getProductPacks();
		// ========过滤掉加价购商品。========
		Iterator<CartProductPack> iterator = packs.iterator();
		while (iterator.hasNext()) {
			CartProductPack pack = iterator.next();
			if (null != pack && CartPackSourceEnum.ADDIBLE.equals(pack.getSource())) {
				iterator.remove();
			}
		}

		// 库存验证end

		// 拆分有效/无效商品包
		final List<CartProductPack> validPacks = Lists.newArrayList();
		final List<CartProductPack> invalidPacks = Lists.newArrayList();
		separateInvalid(packs, validPacks, invalidPacks, opChannel);

		return validPacks;
	}

	/**
	 * 获取要删除的购物车记录id集合 包括加价购和赠品记录
	 * 
	 * @param cart
	 * @param packIds
	 * @return
	 */
	public List<Long> getDelPackIds(Cart cart, List<Long> packIds) {
		List<Long> delPackIds = Lists.newArrayList();
		if (null == cart) {
			return delPackIds;
		}
		// 2 找出要删除商品参加的活动,过滤当前会员以外的购物记录
		List<PsCampaignVO> campaignVOs = Lists.newArrayList();
		List<CartProductPack> packs = Lists.newArrayList(cart.getProductPacks());
		for (CartProductPack productPack : packs) {
			if (packIds.contains(productPack.getId())) {
				delPackIds.add(productPack.getId());
				if (CartPackSourceEnum.RAW.equals(productPack.getSource())) {
					campaignVOs.addAll(productPack.getProduct().getCampaignList());
				}
			}
		}
		// 获取删除商品的换购和赠送商品
		List<Long> productIds = Lists.newArrayList();
		for (PsCampaignVO psCampaignVO : campaignVOs) {
			if (DiscountType.GIFT.getId().equals(psCampaignVO.getDiscountTypeId())
					|| DiscountType.CHEAPEN_OTHER.getId().equals(psCampaignVO.getDiscountTypeId())) {
				for (PsCampaignSectionVO cs : psCampaignVO.getCampaignSectionList()) {
					List<PsCampaignSectionProductVO> csProduct = cs.getCampaignSectionProducts();
					for (PsCampaignSectionProductVO productVO : csProduct) {
						productIds.add(productVO.getProductId());
					}
				}
			}
		}

		// 匹配是否有要删除的换购和赠送商品
		for (CartProductPack productPack : packs) {
			if (productIds.contains(productPack.getProductId())) {
				delPackIds.add(productPack.getId());
			}
		}

		return delPackIds;
	}

	public void setBenefitPackVOsInvalid(List<CartProductPackVO> packVos, List<Integer> checkBenifitIds,BigDecimal price) {

		StringBuffer tipText = new StringBuffer();
		if (CollectionUtils.isNotEmpty(packVos)) {
			for (CartProductPackVO packVo : packVos) {
				if (CartPackSource.BENEFIT.equals(packVo.getSource())) {
					CartBenefitVO benefitVO = packVo.getBenefit();
					tipText.setLength(0);
					// 区分定金权益和非定金权益
					if (NumberUtil.isNullOrZero(benefitVO.getDeductionPrice())) {
						String startDate = DateUtil.format(benefitVO.getCashStartTime(),
								DateUtil.DEFAULT_CN_DATE_FORMAT);
						String endDate = DateUtil.format(benefitVO.getCashEndTime(), DateUtil.DEFAULT_CN_DATE_FORMAT);
						if (startDate.equalsIgnoreCase(endDate)) {
							tipText.append(startDate).append("当天").append(" ");
						} else {
							tipText.append(startDate).append("~").append(endDate).append(" ");
						}
						// 设置门槛金额
						if (benefitVO.getIsThreshold()) {
							tipText.append("满").append(benefitVO.getThresholdPrice()).append("元");
						}
						// 不在有效期设置为无效
						if (!DateUtil.isInTime(benefitVO.getCashStartTime(), benefitVO.getCashEndTime(), null)) {
							packVo.getInvalid().setInvalid(Boolean.TRUE);
						}else if(benefitVO.getIsThreshold()){
							if(NumberUtil.isNullOrZero(price)|| benefitVO.getThresholdPrice().compareTo(price)>0){
								packVo.getInvalid().setInvalid(Boolean.TRUE);
							}
						}
						tipText.append("可领取");
					} else { // 权益抵扣金额逻辑
						BigDecimal tailMoney = packVo.getSpv().getPrice().subtract(benefitVO.getDeductionPrice())
								.setScale(2, RoundingMode.HALF_UP);
						String DATE_FORMAT_DEFAULT = "MM.dd HH:mm";
						String startDate = DateUtil.format(benefitVO.getCashStartTime(), DATE_FORMAT_DEFAULT);
						String endDate = DateUtil.format(benefitVO.getCashEndTime(), DATE_FORMAT_DEFAULT);
						tipText.append(startDate).append("-").append(endDate).append(" ").append("支付尾款￥")
								.append(tailMoney);
						if (DateUtil.isInTime(benefitVO.getCashStartTime(), benefitVO.getCashEndTime(), null)) {
							packVo.getInvalid().setInvalid(Boolean.FALSE);
						} else {
							packVo.getInvalid().setInvalid(Boolean.TRUE);
						}
					}
					packVo.getInvalid().setDesc(tipText.toString());
				}
			}
		}
	}
}
