package com.thebeastshop.pegasus.channelservice.adapter.card;

import java.util.Date;

import org.springframework.stereotype.Component;

import com.thebeastshop.pegasus.service.operation.model.CardType;
import com.thebeastshop.pegasus.service.operation.vo.CardVO;
import com.thebeastshop.support.vo.coupon.CouponVO;
import com.thebeastshop.support.vo.coupon.CouponVO.CouponTypeVO;

/**
 * 
 * @author Paul-xiong
 *
 */
@Component
public class CardAdapter {

	/**
	 * 获取卡券
	 * 
	 * @param card
	 * @return
	 */
	public CouponVO getCard(CardVO card) {
		CouponVO rt = null;
		if (card != null) {
			CardType cardType = card.getCardType();
			if (cardType != null) {
				rt = new CouponVO();
				rt.setId(card.getCardId());
				rt.setType(CouponTypeVO.CARD);
				rt.setStartTime(cardType.getStartAt());
				rt.setCreateTime(cardType.getCreateAt());
				rt.setExpireTime(cardType.getEndAt());
				rt.setTitle(cardType.getName());
				rt.setThresholdDesc(cardType.getDescribe());
				rt.setDescription(cardType.getDescribe());
				rt.setDiscount(cardType.getPriceYuan());
				rt.setUsable(cardType.getEndAt().after(new Date()));
				rt.setExpired(cardType.getEndAt().before(new Date()));
			}
		}
		return rt;
	}

}
