package com.thebeastshop.pegasus.channelservice.adapter.campaign;

import java.util.*;

import com.thebeastshop.cart.enums.CartPackSourceEnum;
import com.thebeastshop.pegasus.component.campaign.*;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler.DefaultCampaignHandlerImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionImpl;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.support.util.EnumUtil;

/**
 * 购物车适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class CampaignAdapter {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	// ==================private method==================

	private CampaignSectionProduct transSectionProduct(PsCampaignSectionProductVO entity) {
		if (entity != null) {
			DefaultCampaignSectionProductImpl domain = new DefaultCampaignSectionProductImpl();
			domain.setAdditionalProductCount(entity.getPriceCount());
			domain.setAdditionalProductId(entity.getProductId());
			domain.setAdditionalProductPrice(entity.getPricePrice());
			domain.setCampaignSectionId(entity.getCampaignSectionId());
			domain.setId(entity.getId());
			domain.setLimitCount(entity.getLimitCount());
			// domain.setRanking(entity.geRanking());
			return domain;
		}
		return null;
	}

	private List<CampaignSectionProduct> transSectionProduct(List<PsCampaignSectionProductVO> entities) {
		List<CampaignSectionProduct> domains = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(entities)) {
			for (PsCampaignSectionProductVO entity : entities) {
				domains.add(transSectionProduct(entity));
			}
		}
		return domains;
	}

	private CampaignSection transSection(PsCampaignSectionVO entity) {
		if (entity != null) {
			DefaultCampaignSectionImpl domain = new DefaultCampaignSectionImpl();
			domain.setCampaignSectionProducts(transSectionProduct(entity.getCampaignSectionProducts()));
			domain.setConditionType(EnumUtil.valueOf(entity.getConditionType(), ConditionType.class));
			domain.setFactorType(EnumUtil.valueOf(entity.getFactorType(), FactorTypeEnum.class));
			domain.setFactor(entity.getFactor());
			domain.setId(entity.getId());
			domain.setLine(entity.getLine());
			if (entity.getRanking() != null) {
				domain.setRanking(entity.getRanking());
			}
			domain.setCampaignId(entity.getCampaignId());
			return domain;
		}
		return null;
	}

	private List<CampaignSection> transSection(List<PsCampaignSectionVO> entities) {
		List<CampaignSection> domains = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(entities)) {
			for (PsCampaignSectionVO entity : entities) {
				domains.add(transSection(entity));
			}
		}
		return domains;
	}

	private Campaign transCampaign(PsCampaignVO e) {
		if (e != null) {
			final DefaultCampaignImpl campaign = new DefaultCampaignImpl();
			campaign.setId(e.getId());
			campaign.setCreateTime(e.getCreateTime());
			campaign.setDescription(e.getTitle());
			campaign.setCode(e.getCode());
			List<AccessWayEnum> accessWays = Lists.newArrayList();
			for (Integer i : e.getAccessWayIds()) {
				accessWays.add(AccessWayEnum.getEnumByCode(i));
			}
			campaign.setAccessWays(accessWays);

			campaign.setCumulative(e.getCumulative() != null && e.getCumulative() == 1 ? true : false);
			campaign.setDiscountType(EnumUtil.valueOf(e.getDiscountTypeId(), DiscountType.class));

			List<MemberLevelEnum> memberLevels = Lists.newArrayList();
			for (Integer i : e.getMemberLevels()) {
				memberLevels.add(MemberLevelEnum.getEnumByCode(i));
			}
			campaign.setMemberLevels(memberLevels);
			campaign.setName(e.getName());
			campaign.setProductScope(EnumUtil.valueOf(e.getProductScopeId(), ProductScope.class));
			campaign.setStartTime(e.getStartTime());
			campaign.setExpireTime(e.getExpireTime());
			campaign.setCampaignSections(transSection(e.getCampaignSectionList()));
			campaign.setState(EnumUtil.valueOf(e.getState(), CampaignState.class));
			campaign.setLadderRule(LadderRuleEnum.getLadderRuleByCode(e.getLadderRule()));
			return campaign;
		}
		return null;
	}

	private CampaignHandler getHandler(final Collection<CampaignHandler> handlers, final Campaign campaign) {
		for (CampaignHandler handler : handlers) {
			if (handler.getCampaign().getId().equals(campaign.getId())) {
				return handler;
			}
		}
		return null;
	}

	/**
	 * 创建活动操作器
	 * 
	 * @param packs
	 * @param campaign
	 * @param campaignMap
	 * @return
	 */
	private List<CampaignHandler> createHandler(List<? extends ProductPack> packs, Campaign campaign,
			Map<ProductPack, List<PsCampaignVO>> campaignMap) {
		List<CampaignHandler> handlers = Lists.newArrayList();
		if (campaign.getDiscountType().equals(DiscountType.OPTION)) {
			handlers = createOptionCampaignHandler(packs, campaign, campaignMap);
		} else {
			CampaignHandler handler = new DefaultCampaignHandlerImpl(campaign, Lists.<ProductPack> newArrayList(),
					Lists.<ProductPack> newArrayList());
			for (ProductPack pack : packs) {
				List<PsCampaignVO> list = campaignMap.get(pack);
				if (CollectionUtils.isNotEmpty(list)) {
					CartPackSourceEnum source = pack.getSource();
					int i = 0;
					for (; i < list.size(); i++) {
						if (list.get(i).getId().equals(handler.getCampaign().getId())) {
							// 若是自购商品包，则放入“参与活动的商品包列表”中；
							// 若是加价购商品包或赠品商品包，都不放入“参与的商品包列表”中；
							if (source.equals(CartPackSourceEnum.RAW)) {
								handler.getParticipatingPacks().add(pack);
								break;
							}
						}
					}
					if (i >= list.size()) {
						handler.getNonParticipatingPacks().add(pack);
					}
				} else {
					handler.getNonParticipatingPacks().add(pack);
				}
			}
			handlers.add(handler);
		}
		return handlers;
	}

	/**
	 * 创建N元任选活动操作器
	 * 
	 * @param packs
	 * @param campaign
	 * @param campaignMap
	 * @return
	 */
	private List<CampaignHandler> createOptionCampaignHandler(List<? extends ProductPack> packs, Campaign campaign,
			Map<ProductPack, List<PsCampaignVO>> campaignMap) {
		List<CampaignHandler> handlers = Lists.newArrayList();
		CampaignSection section = campaign.getCampaignSections().get(0);
		Integer line = section.getLine().intValue();
		CampaignHandler handler = new DefaultCampaignHandlerImpl(campaign, Lists.<ProductPack> newArrayList(),
				Lists.<ProductPack> newArrayList());
		for (ProductPack pack : packs) {
			List<PsCampaignVO> list = campaignMap.get(pack);
			if (CollectionUtils.isNotEmpty(list) && pack.getSource().equals(CartPackSourceEnum.RAW)) {
				int i = 0;
				for (; i < list.size(); i++) {
					if (list.get(i).getId().equals(handler.getCampaign().getId())) {
						handler.getParticipatingPacks().add(pack);
						line = line - pack.getCount();
						if (line <= 0) {
							handlers.add(handler);
							line = section.getLine().intValue();
							handler = new DefaultCampaignHandlerImpl(campaign, Lists.<ProductPack> newArrayList(),
									Lists.<ProductPack> newArrayList());
						}
						break;
					}
				}
			}
		}
		if(!handlers.contains(handler)){
			handlers.add(handler);
		}
		if (CollectionUtils.isNotEmpty(handlers)) {
			for (ProductPack pack : packs) {
				for (CampaignHandler each : handlers) {
					if (!each.getParticipatingPacks().contains(pack)) {
						each.getNonParticipatingPacks().add(pack);
					}
				}
			}
		}
		return handlers;
	}

	/**
	 * 处理单品活动操作器 多个商品参加相同的单品活动，进行区分
	 * 
	 * @param handlers
	 * @return
	 */
	private List<CampaignHandler> handleSingleCampaignHandler(List<CampaignHandler> handlers) {
		List<CampaignHandler> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(handlers)) {
			Iterator<CampaignHandler> iterator = handlers.iterator();
			while (iterator.hasNext()) {
				CampaignHandler next = iterator.next();
				Campaign campaign = next.getCampaign();
				ProductScope productScope = campaign.getProductScope();
				List<ProductPack> participatingPacks = next.getParticipatingPacks();
				List<ProductPack> nonParticipatingPacks = next.getNonParticipatingPacks();
				if (productScope.equals(ProductScope.SINGLE) && CollectionUtils.isNotEmpty(participatingPacks)
						&& participatingPacks.size() > 1) {
					for (ProductPack productPack : participatingPacks) {
						List<ProductPack> tempParticipatingPacks = Lists.newArrayList(productPack);
						List<ProductPack> tempNoParticipatingPacks = Lists.newArrayList(nonParticipatingPacks);
						tempNoParticipatingPacks.addAll(participatingPacks);
						tempNoParticipatingPacks.remove(productPack);
						rt.add(new DefaultCampaignHandlerImpl(campaign, tempParticipatingPacks,
								tempNoParticipatingPacks));
					}
				} else {
					rt.add(next);
				}
			}
		}
		return rt;
	}

	// ==================华丽丽的分割线===================

	/**
	 * 根据主品包，获取活动处理器
	 * 
	 * @param packs
	 * @param accessWay
	 * @return
	 */
	public List<CampaignHandler> getCampaignHandlers(List<? extends ProductPack> packs, AccessWayEnum accessWay) {
		Date start = new Date();
		Map<String, PsProductVO> productMap = Maps.newHashMapWithExpectedSize(packs.size());
		Map<ProductPack, List<PsCampaignVO>> campaignMap = new HashMap<>();
		for (ProductPack pack : packs) {
			PsProductVO productVO = pack.getProduct();
			productMap.put(pack.getProductId().toString(), productVO);
			List<PsCampaignVO> campaignlist = Lists.newArrayList();
			List<PsCampaignVO> camps = pack.getSpv().getCampaignList();
			// 商品有抢购活动时，不参加所有价格折扣活动和N元n件
			boolean status = false;
			if (null != camps && camps.size() > 0) {
				for (PsCampaignVO camp : camps) {
					if (camp.getDiscountTypeId() == DiscountType.PANIC_BUY.getId()) {
						status = true;
						break;
					}
				}

				if (status) {
					List<PsCampaignVO> prodCamps = productVO.getCampaignList();
					if (null != prodCamps && prodCamps.size() > 0) {
						for (PsCampaignVO prodCamp : prodCamps) {
							if ((prodCamp.getDiscountTypeId() != 1) && (prodCamp.getDiscountTypeId() != 2)
									&& (prodCamp.getDiscountTypeId() != 5) && (prodCamp.getDiscountTypeId() != 7)) {
								campaignlist.add(prodCamp);
							}
						}
					}
					List<PsCampaignVO> spvCamps = pack.getSpv().getCampaignList();
					if (null != spvCamps && spvCamps.size() > 0) {
						for (PsCampaignVO spvCamp : spvCamps) {
							if ((spvCamp.getDiscountTypeId() != 1) && (spvCamp.getDiscountTypeId() != 2)
									&& (spvCamp.getDiscountTypeId() != 5) && (spvCamp.getDiscountTypeId() != 7)) {
								campaignlist.add(spvCamp);
							}
						}
					}

				} else {
					campaignlist.addAll(productVO.getCampaignList());
					campaignlist.addAll(pack.getSpv().getCampaignList());
				}

			} else {
				campaignlist.addAll(productVO.getCampaignList());
				campaignlist.addAll(pack.getSpv().getCampaignList());
			}

			// campaignlist.addAll(productVO.getCampaignList());
			// campaignlist.addAll(pack.getSpv().getCampaignList());
			campaignMap.put(pack, campaignlist);
		}
		// ========通过商品活动map组成活动操作器列表===========
		List<CampaignHandler> handlers = Lists.newArrayList();
		for (List<PsCampaignVO> campaigns : campaignMap.values()) {
			for (PsCampaignVO psCampaignVO : campaigns) {
				Campaign campaign = transCampaign(psCampaignVO);
				CampaignHandler handler = getHandler(handlers, campaign);
				if (handler == null) {
					handlers.addAll(createHandler(packs, campaign, campaignMap));
				}
			}
		}

		handlers = handleSingleCampaignHandler(handlers);
		Date end = new Date();
		logger.info("组装CampaignHandler：{}毫秒", end.getTime() - start.getTime());
		return handlers;
	}
}
