package com.thebeastshop.pegasus.channelservice.adapter.announcement;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.announcement.Announcement;
import com.thebeastshop.support.vo.announcement.AnnouncementVO;

/**
 * 公告适配器（web层用）
 * 
 * @author Paul-xiong
 *
 */
@Component
public class AnnouncementAdapter {

	/**
	 * 获取公告信息
	 *
	 * @param announcements
	 * @return
	 */
	public List<AnnouncementVO> getAnnouncement(List<Announcement> announcements) {
		List<AnnouncementVO> vos = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(announcements)) {
			for (Announcement announcement : announcements) {
				vos.add(new AnnouncementVO(announcement.getTitle(), announcement.getLink()));
			}
		}
		return vos;
	}

}
