package com.thebeastshop.pegasus.channelservice.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.PriceUtil;
import com.thebeastshop.wms.constant.PegasusConstants;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.vo.WhInvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.order.IposOrderVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLineVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderListVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderPackageVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderQueryVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderSkuVO;
import com.thebeastshop.pegasus.channelservice.vo.order.PackageDeliveryInfoVO;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPcsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.service.operation.PegasusChannelServiceFacade;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackage;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeliveryInfo;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageSku;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.stock.vo.SPresaleVO;


@Service("thirdPartyOrderAdapter")
public class ThirdPartyOrderAdapter {

	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McOpChannelService mcOpChannelService;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private SWhInvService pwInstance;

	private PegasusChannelServiceFacade pcInstance=PegasusChannelServiceFacade.getInstance();
	private PegasusOperationServiceFacade poInstance=PegasusOperationServiceFacade.getInstance();

	@Autowired
	private McPcsSkuService mcPcsSkuService;
	
	
	@Autowired
	private SPresaleService sPresaleService;

	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderQueryVO
	 */
	public OpSalesOrderVO website2Common(OrderQueryVO orderQueryVO) {
		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		return opSalesOrderVO;
	}

	/***
	 * 根据通用的订单对象。封装成接口参数
	 * 
	 * @param opSalesOrderVO
	 * @return OrderQueryVO
	 */
	public OrderQueryVO common2website(OpSalesOrderVO opSalesOrderVO) {
		
		OrderQueryVO orderQueryVO = new OrderQueryVO();
		
		//整体订单解析
		orderQueryVO.setAmountTotal(opSalesOrderVO.getNeedToPayAmount().doubleValue());
		orderQueryVO.setDateOrder(String.valueOf(opSalesOrderVO.getCreateTime()));
		orderQueryVO.setExpectDeliveryDate(String.valueOf(opSalesOrderVO.getExpectReceiveDate()));
		orderQueryVO.setId(opSalesOrderVO.getId());
		orderQueryVO.setLimitedHour(opSalesOrderVO.getLimitDeliveryTimeDesc());
		orderQueryVO.setName(opSalesOrderVO.getCode());
		AddressVO partner_shipping_id=new AddressVO();
		partner_shipping_id.setId(opSalesOrderVO.getAddressId());
		partner_shipping_id.setCircuit(opSalesOrderVO.getCircuitDesc());
		partner_shipping_id.setCity(opSalesOrderVO.getCity());
		partner_shipping_id.setDistrict(opSalesOrderVO.getDistrict());
		partner_shipping_id.setId(opSalesOrderVO.getAddressId());
		partner_shipping_id.setPhone(opSalesOrderVO.getReceiverPhone());
		partner_shipping_id.setName(opSalesOrderVO.getReceiver());
		partner_shipping_id.setStreet(opSalesOrderVO.getAddress());
		partner_shipping_id.setProvince(opSalesOrderVO.getProvince());
		partner_shipping_id.setZip(opSalesOrderVO.getZipCode());
		
		orderQueryVO.setPartnerShippingId(partner_shipping_id);
		orderQueryVO.setOrderOutState(opSalesOrderVO.getSalesOrderStatus());
		orderQueryVO.setShopId(String.valueOf(opSalesOrderVO.getShopId()));
		orderQueryVO.setShopName(opSalesOrderVO.getShopName());
		return orderQueryVO;
	}
	
	/***
	 * 通用订单查询
	 * @param opSalesOrderVOs
	 * @return
	 */
	public List<OrderListVO> common2channel(List<OpSalesOrderVO> opSalesOrderVOs) {
		List<OrderListVO> orderListVOs=new ArrayList<OrderListVO>();
		if(CollectionUtils.isNotEmpty(opSalesOrderVOs)){
			for(OpSalesOrderVO salesorderVO:opSalesOrderVOs){
				OrderListVO orderListVO = new OrderListVO();
				orderListVO.setId(salesorderVO.getId());
				orderListVO.setCode(salesorderVO.getCode());
				orderListVO.setOrderDate(DateUtil.format(salesorderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				orderListVO.setOrderState(salesorderVO.getSalesOrderStatus());
				orderListVO.setPayAmount(salesorderVO.getNeedToPayAmount()==null?0:salesorderVO.getNeedToPayAmount().doubleValue());
				orderListVO.setReceiver(getReceiverFromDeliveryInfo(salesorderVO));
				List<OrderSkuVO> orderSkus=new ArrayList<OrderSkuVO>();
				List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
				if(CollectionUtils.isNotEmpty(packageVOs)){
					for(OpSoPackageVO packageVO:packageVOs){
						List<OpSoPackageSkuVO>  packageSkuVOs=packageVO.getOpSoPackageSkuVOs();
						if(CollectionUtils.isNotEmpty(packageSkuVOs)){
							for(OpSoPackageSkuVO packageSKuVO:packageSkuVOs){
								OrderSkuVO orderSKuVO=new OrderSkuVO();
								orderSKuVO.setQuantity(packageSKuVO.getQuantity());
								orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice() == null ? 0 : packageSKuVO.getUnitPrice().doubleValue());
								PsProductVO productVO=mcPsProductService.findProdBySkuCode(packageSKuVO.getSkuCode());
								PsSkuVO psSku=mcPsSkuService.findBySkuCode(packageSKuVO.getSkuCode());
								if(null!=productVO){
								  orderSKuVO.setProductCode(productVO.getCode());
								  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
								  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
								}
								if(null!=psSku){
								  orderSKuVO.setBrandName(psSku.getBrandName());
								}
								orderSkus.add(orderSKuVO);
							}
						}
					}
				}
				orderListVO.setOrderStateDesc(getOrderStateDesc(salesorderVO));
				orderListVO.setOrderSkus(orderSkus);
				orderListVOs.add(orderListVO);
			}
		}

		
		return orderListVOs;
	}
	
	
	/***
	 * 通用订单查询
	 * @param opSalesOrderVOs
	 * @return
	 */
	public List<IposOrderVO> common2order(List<OpSalesOrderVO> opSalesOrderVOs) {
		List<IposOrderVO> orderListVOs=new ArrayList<IposOrderVO>();
		if(CollectionUtils.isNotEmpty(opSalesOrderVOs)){
			// 先获取会员
			Map<String, MemberVO> memberMap = Maps.newHashMap();
			List<String> memberCodes = Lists.newArrayListWithExpectedSize(opSalesOrderVOs.size());
			for (OpSalesOrderVO salesorderVO : opSalesOrderVOs) {
				if (StringUtils.isNotBlank(salesorderVO.getMemberCode())) {
					memberCodes.add(salesorderVO.getMemberCode());
				}
			}
			List<MemberVO> members = memberQueryService.getByCodes(memberCodes);
			for (MemberVO memberVO : members) {
				memberMap.put(memberVO.getCode(), memberVO);
			}
			for(OpSalesOrderVO salesorderVO:opSalesOrderVOs){
				IposOrderVO orderVO = new IposOrderVO();
				orderVO.setId(salesorderVO.getId());
				orderVO.setCode(salesorderVO.getCode());
				orderVO.setOrderDate(DateUtil.format(salesorderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				orderVO.setOrderState(salesorderVO.getSalesOrderStatus());
				orderVO.setPayAmount(salesorderVO.getNeedToPayAmount()==null?0:salesorderVO.getNeedToPayAmount().doubleValue());
				orderVO.setReceiver(getReceiverFromDeliveryInfo(salesorderVO));

				if(salesorderVO.getMemberCode()!=null){
					// 根据membercode取得会员
					MemberVO opMemberVO = memberMap.get(salesorderVO.getMemberCode());
					
					if(opMemberVO!=null) {
						// 会员等级
						orderVO.setMemberLevel(opMemberVO.getMemberLevel());
					}
				}
				
				// 订单类型
				orderVO.setOrderType(salesorderVO.getSalesOrderType());
				// 订单来源渠道编码
				orderVO.setChannelCode(salesorderVO.getChannelCode());
				// 会员code
				orderVO.setMemberCode(salesorderVO.getMemberCode());
				// 销售人员id
				orderVO.setCreateOperatorId(salesorderVO.getCreateOperatorId());
				// 销售人员名
				orderVO.setCreateOperatorName(salesorderVO.getCreateOperatorName());
				// 付款时间
				orderVO.setPayTime(salesorderVO.getPayTime());
				// 服务费金额
				orderVO.setServiceFeeAmount(salesorderVO.getServiceFeeAmount());
				// 礼品卡支付金额
				orderVO.setGiftCardAmount(salesorderVO.getGiftCardAmount());
				// 支付方式
				orderVO.setGiftCardDesc(salesorderVO.getGiftCardDesc());
				// coupon编码
				orderVO.setCouponCode(salesorderVO.getCouponCode());
				// coupon折扣金额（包含在订单头折扣
				orderVO.setCouponDiscountAmount(salesorderVO.getCouponDiscountAmount());
				// 礼品卡描述，逗号分隔
				orderVO.setGiftCardDesc(salesorderVO.getGiftCardDesc());
				List<OrderSkuVO> orderSkus = new ArrayList<OrderSkuVO>();
				List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
				if(CollectionUtils.isNotEmpty(packageVOs)){
					for(OpSoPackageVO packageVO:packageVOs){
						List<OpSoPackageSkuVO>  packageSkuVOs=packageVO.getOpSoPackageSkuVOs();
						if(CollectionUtils.isNotEmpty(packageSkuVOs)){
							for(OpSoPackageSkuVO packageSKuVO:packageSkuVOs){
								OrderSkuVO orderSKuVO=new OrderSkuVO();
								orderSKuVO.setQuantity(packageSKuVO.getQuantity());
								orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice()==null?0:packageSKuVO.getUnitPrice().doubleValue());
								PsProductVO productVO=mcPsProductService.findProdBySkuCode(packageSKuVO.getSkuCode());
								PsSkuVO  psSku=mcPsSkuService.findBySkuCode(packageSKuVO.getSkuCode());
								if(null!=productVO){
								  orderSKuVO.setProductCode(productVO.getCode());
								  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
								  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
								}
								if(null!=psSku){
								  orderSKuVO.setBrandName(psSku.getBrandName());
								}
								orderSkus.add(orderSKuVO);
							}
						}
					}
				}
				orderVO.setOrderStateDesc(getOrderStateDesc(salesorderVO));
				orderVO.setOrderSkus(orderSkus);
				orderListVOs.add(orderVO);

			}
		}

		
		return orderListVOs;
	}
	/***
	 * 
	 * @param salesorderVO
	 * @return
	 */
	private String getOrderStateDesc(OpSalesOrderVO salesorderVO){
		Integer orderStatus=  salesorderVO.getSalesOrderStatus();
		List<OpSoPackageVO>  packageVOs=salesorderVO.getOpSoPackageVOs();
		Set<Integer> packageStatusSet=new HashSet<Integer>();
		if(OpSalesOrder.ORDER_STATUS_CANCLE==orderStatus){
			return "已取消";
		}
		if(OpSalesOrder.ORDER_STATUS_HOLD==orderStatus||OpSalesOrder.ORDER_STATUS_NONPAYMENT==orderStatus){
			return "等待付款";
		}
		if(CollectionUtils.isNotEmpty(packageVOs)){
			for(OpSoPackageVO packageVO:packageVOs){
				packageStatusSet.add(packageVO.getPackageStatus());
			}
		}
		//等待发货
		boolean allPackageNotSend=false;//所有包裹均未发货  订单状态为11包裹状态为10 11 12
		if(packageStatusSet!=null&&packageStatusSet.size()>0){
			int packageStatusSize=packageStatusSet.size();
			boolean PACKAGE_STATUS_DEFAULT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_DEFAULT);
			boolean PACKAGE_STATUS_WAITING_MAKE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_MAKE);
			boolean PACKAGE_STATUS_WAITING_SEND=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_SEND);
			if(packageStatusSize==1&&PACKAGE_STATUS_DEFAULT){
				allPackageNotSend=true ;
			}else if(packageStatusSize==1&&PACKAGE_STATUS_WAITING_MAKE){
				allPackageNotSend=true ;
			}else if(packageStatusSize==1&&PACKAGE_STATUS_WAITING_SEND){
				allPackageNotSend=true ;
			}else if((packageStatusSize==2&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_MAKE)||
					(packageStatusSize==2&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_SEND)||
					(packageStatusSize==2&&PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_SEND)){
				allPackageNotSend=true;
			}else if(packageStatusSize==3&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_SEND){
				allPackageNotSend=true;
			}
		}
		if((OpSalesOrder.ORDER_STATUS_HOLD_REVIEW==orderStatus)||(OpSalesOrder.ORDER_STATUS_WAITING_REVIEW==orderStatus)||(OpSalesOrder.ORDER_STATUS_ALREADY_REVIEW==orderStatus&&allPackageNotSend)){
			return "等待发货";
		}
		
		//已发货
		boolean allPackageSend=false;//包裹状态为13 14
		if(packageStatusSet!=null&&packageStatusSet.size()>0){
			int packageStatusSize=packageStatusSet.size();
			boolean PACKAGE_STATUS_WAITING_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_RECEIVE);
			boolean PACKAGE_STATUS_ALREADY_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_RECEIVE);
			if(packageStatusSize==1&&PACKAGE_STATUS_WAITING_RECEIVE){
				allPackageSend=true;
			}else if(packageStatusSize==1&&PACKAGE_STATUS_ALREADY_RECEIVE){
				allPackageSend=true;
			}else if(packageStatusSize==2&&PACKAGE_STATUS_WAITING_RECEIVE&&PACKAGE_STATUS_ALREADY_RECEIVE){
				allPackageSend=true;
			}
		}
		if(allPackageSend){
			return "已发货";
		}
		//部分发货
		boolean partPackageSend=false;//包裹同时包含未发货包裹和已发货包裹
		if(packageStatusSet!=null&&packageStatusSet.size()>0){
			boolean PACKAGE_STATUS_DEFAULT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_DEFAULT);
			boolean PACKAGE_STATUS_WAITING_MAKE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_MAKE);
			boolean PACKAGE_STATUS_WAITING_SEND=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_SEND);
			
			boolean PACKAGE_STATUS_WAITING_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_RECEIVE);
			boolean PACKAGE_STATUS_ALREADY_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_RECEIVE);
			if((PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_ALREADY_RECEIVE)||
					(PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_ALREADY_RECEIVE)||
					(PACKAGE_STATUS_WAITING_SEND&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_WAITING_SEND&&PACKAGE_STATUS_ALREADY_RECEIVE)){
				partPackageSend=true;
			}
		}
		if(partPackageSend){
			return "部分发货";
		}
		return "";
	}
	
	private String getReceiverFromDeliveryInfo(OpSalesOrderVO salesorderVO){
		if(salesorderVO!=null){
			List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
			if(CollectionUtils.isNotEmpty(packageVOs)){
				OpSoPackageDeliveryInfoVO  deliveryInfoVO=packageVOs.get(0).getOpSoPackageDeliveryInfoVO();
				if(deliveryInfoVO!=null){
					return deliveryInfoVO.getReceiver();
				}
			}
		}
		return null;
	}
	
	/***
	 * 通用订单详情转换
	 * @param orderVO
	 * @return
	 */
	public OrderDetailVO common2channel(OpSalesOrderVO orderVO){
		OrderDetailVO detailVO=new OrderDetailVO();
		detailVO.setOrderCode(orderVO.getCode());
		detailVO.setOrderDate(DateUtil.format(orderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setChannelCode(orderVO.getChannelCode());
		detailVO.setCouponAmount(orderVO.getCouponDiscountAmount()==null?0:orderVO.getCouponDiscountAmount().doubleValue());
		detailVO.setAuditTime(orderVO.getAuditTime()==null?null:DateUtil.format(orderVO.getAuditTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setGiftCardAmount(orderVO.getGiftCardAmount()==null?0:orderVO.getGiftCardAmount().doubleValue());
		detailVO.setPayAmount(orderVO.getNeedToPayAmount()==null?0:orderVO.getNeedToPayAmount().doubleValue());
		detailVO.setPayTime(orderVO.getPayTime()==null?null: DateUtil.format(orderVO.getPayTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setOrderStateDesc(getOrderStateDesc(orderVO));
		detailVO.setOrderState(orderVO.getSalesOrderStatus());
		 List<OpSoPackageVO>  packageVOs=orderVO.getOpSoPackageVOs();
		 if(CollectionUtils.isNotEmpty(packageVOs)){
			 List<OrderPackageVO> packages=new ArrayList<OrderPackageVO>();
			 for(OpSoPackageVO packageVO:packageVOs){
				 OrderPackageVO orderPackageVO=new OrderPackageVO();
				 orderPackageVO.setCode(packageVO.getCode());
				 orderPackageVO.setCardContent(packageVO.getCardContent());
				 orderPackageVO.setCardType(packageVO.getCardType());
				 orderPackageVO.setDeliveryType(packageVO.getDeliveryType());
				 orderPackageVO.setExpectReceiveDate(packageVO.getExpectReceiveDate());
				 orderPackageVO.setPlanedDeliveryDate(packageVO.getPlanedDeliveryDate());
				 orderPackageVO.setLimitDeliveryTimeDesc(packageVO.getLimitDeliveryTimeDesc());
				 orderPackageVO.setPackageStatus(packageVO.getPackageStatus());
				 orderPackageVO.setPackageStatusDesc(getPackageStatusDesc(packageVO));
				 orderPackageVO.setDeliveryTime(packageVO.getDeliveryTime()==null?null:DateUtil.format(packageVO.getDeliveryTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				 OpSoPackageDeliveryInfoVO deliveryInfoVO= packageVO.getOpSoPackageDeliveryInfoVO();
				 if(deliveryInfoVO!=null){
					 PackageDeliveryInfoVO deliveryInfo=new PackageDeliveryInfoVO();
					 BeanUtils.copyProperties(deliveryInfoVO, deliveryInfo);
					 orderPackageVO.setDeliveryInfo(deliveryInfo);
				 }
				 List<OpSoPackageSkuVO> packageSkus= packageVO.getOpSoPackageSkuVOs();
				 if(CollectionUtils.isNotEmpty(packageSkus)){
					 List<OrderSkuVO> orderSkus=new ArrayList<OrderSkuVO>();
					 for(OpSoPackageSkuVO packageSKuVO:packageSkus){
						 OrderSkuVO orderSKuVO=new OrderSkuVO();
							orderSKuVO.setQuantity(packageSKuVO.getQuantity());
							orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
							orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice()==null?0:packageSKuVO.getUnitPrice().doubleValue());
							PsProductVO productVO=mcPsProductService.findProdBySkuCode(packageSKuVO.getSkuCode());
							PsSkuVO  psSku=mcPsSkuService.findBySkuCode(packageSKuVO.getSkuCode());
							if(null!=productVO){
							  orderSKuVO.setProductCode(productVO.getCode());
							  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
							  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
							}
							if(null!=psSku){
							  orderSKuVO.setBrandName(psSku.getBrandName());
							}
							orderSkus.add(orderSKuVO);
					 }
					 orderPackageVO.setOrderSkus(orderSkus);
				 }
				 packages.add(orderPackageVO);
			 }
			 detailVO.setPackages(packages);
		 }
		return detailVO;
	}
	private String getPackageStatusDesc(OpSoPackageVO packageVO){
		List<Map<String, String>>  statusList=OpSoPackage.getAllPackageStatus();
		if(CollectionUtils.isNotEmpty(statusList)){
			for(Map<String, String> mp:statusList){
				if(String.valueOf(packageVO.getPackageStatus()).equals(mp.get("value"))){
					return mp.get("text");
				}
			}
		}
		return "";
	}
	/***
	 * 根据通用的订单对象。封装成接口参数
	 * 
	 * @param opSoPackageSkuVO
	 * @return OrderQueryVO
	 */
	public OrderLineVO common2website(OpSoPackageSkuVO opSoPackageSkuVO,String channelCode) {
		OrderLineVO orderLineVO = new OrderLineVO();
		PsProductVO productVO=mcPsProductService.findProdByChnCodeSkuCode(channelCode,opSoPackageSkuVO.getSkuCode());
		if(productVO!=null){
			String [] product_id = new String[2];
			orderLineVO.setImgUrl(imageUrl(productVO.getPicThumb()));
			orderLineVO.setProductName(productVO.getNameCn());
			product_id[0]=productVO.getId();
			product_id[1]=productVO.getNameCn();
			orderLineVO.setProductId(product_id);
		}
		orderLineVO.setPointPrice(opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue());
		orderLineVO.setPointValue(opSoPackageSkuVO.getUnitPoint().doubleValue());
		orderLineVO.setPriceSubtotal(opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitDiscount()).subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue()*opSoPackageSkuVO.getQuantity());
		orderLineVO.setPriceUnit(opSoPackageSkuVO.getUnitPrice().doubleValue());
		

		orderLineVO.setProductUomQty(opSoPackageSkuVO.getQuantity());
		orderLineVO.setSku(opSoPackageSkuVO.getSkuCode());
		
		return orderLineVO;
	}
	
	public String imageUrl(String imageUrl){
		String url=imageUrl;
		if(!StringUtils.isBlank(imageUrl)){
			
			if(imageUrl.indexOf("http://")>=0){
				url=imageUrl;
			}else{
				//url="http://oss.thebeastshop.com/"+imageUrl;
				url="http://img.thebeastshop.com/"+imageUrl;
			}
			
		}
		
		return url;
	}
	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderCreateVO
	 */
	public OpSalesOrderVO website2Common(OrderCreateVO orderCreateVO) {
		//订单VO
		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		//包裹VO
		List<OpSoPackageVO> opSoPackageVOs=new ArrayList<OpSoPackageVO>();
		//官网默认是一个包裹
		OpSoPackageVO opSoPackage=new OpSoPackageVO();
		//包裹地址信息
		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=new OpSoPackageDeliveryInfoVO();
		//包裹sku信息
		List<OpSoPackageSkuVO> opSoPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>();
		//OpMemberVO memberVo=null;
		//if(!orderCreateVO.getAnonymous()){
		MemberVO	memberVo = memberQueryService.getById(orderCreateVO.getCustomerId());
		//}
		//配送仓
		OpChannelVO opChannel = mcOpChannelService.findByCode(orderCreateVO.getChannelCode());
		if (opChannel != null) {
			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
		}
		//天猫渠道
		//OrderPreCheck(orderCreateVO.getChannelCode(),orderCreateVO,opChannel);//下单之前的减库存
		
		// 订单来源渠道编码
		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
		opSalesOrderVO.setBuyerNick(orderCreateVO.getBuyerNick());
		opSalesOrderVO.setOuterOrderCode(orderCreateVO.getOuterOrderCode());//外部渠道订单号
		opSalesOrderVO.setRemark(orderCreateVO.getNote());
		//会员id
		//if(!orderCreateVO.getAnonymous()){
		if(memberVo!=null){
			opSalesOrderVO.setMemberId(memberVo.getId());
			// 会员code
			opSalesOrderVO.setMemberCode(memberVo.getCode());	
		}

		//}
		// 卡片类型，0不需要1空白2代写
		opSoPackage.setCardType(orderCreateVO.getNoteCard());
		// 卡片内容
		opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
		//配送方式
		opSoPackage.setDeliveryType(orderCreateVO.getDeliveryType());
		//限时配送
		opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());
		//期望收货时间
		if(StringUtils.isNotBlank(orderCreateVO.getDeliveryDate())){
			opSoPackage.setExpectReceiveDate(DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
		}else{
			opSoPackage.setPlanedDeliveryDate(new Date());
		}
		
		//opSoPackage.setOid(oid);
		//预期发货时间
		
		//设置配送地址
		AddressVO address=orderCreateVO.getDeliveryAddress();
		//详细地址
		opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
		//环线
		opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
		//公司名称
		opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());
		//收货的区县ID
		opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrictId());
		//收件人
		opSoPackageDeliveryInfoVO.setReceiver(address.getName());
		//邮编
		opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
		//称谓
		opSoPackageDeliveryInfoVO.setTitle(address.getMagentoTitle());
		//收件人电话
		opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
		//订单行
		List<OrderCreateDetailVO> orderCreateDetails=orderCreateVO.getItems();
		//配送方式，判断是否需要强制审单
		Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
		for(OrderCreateDetailVO detail:orderCreateDetails){
				OpSoPackageSkuVO packageSku=new OpSoPackageSkuVO();
				//PsProductVO productVO=pbInstance.findProdByChnCodeSkuCode(null ,detail.getSku());
				
				PcsSkuVO pcsSkuVO = mcPcsSkuService.findByCode(detail.getSku());
				//天猫渠道
				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
				packageSku.setSkuCode(detail.getSku());
				packageSku.setOid(detail.getOid());
				//coupon使用
				packageSku.setBrandId(detail.getBrandId());
				packageSku.setCategroyId(detail.getCategroyId());
				//TODO
				packageSku.setIsJit(detail.getIsJit());//是否来单制作
				packageSku.setQuantity(detail.getQuantity());//数量
				if(detail.getPointValue()==null){
					packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
				}else{
					packageSku.setUnitPoint(BigDecimal.valueOf(detail.getPointValue()));//单品积分
				}
				if(!"CHN2046".equals(orderCreateVO.getChannelCode())) {
					//判断是否包含两种以上配送方式，如果是，则需要强制审单
					/*if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
						deliveryTypes.put("SELF", true);
					}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
						deliveryTypes.put("FEDX24", true);
					}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
						deliveryTypes.put("SF_AIR", true);
					}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
						deliveryTypes.put("SF_LAND", true);
					}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
						deliveryTypes.put("YTO", true);
					}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
						deliveryTypes.put("DEPPON", true);
					}
					if(productVO.getAllowVipDiscount()==1){//官网计算价格，不判断是否匿名购买
						packageSku.setUnitDiscount(getUnitDiscount(BigDecimal.valueOf(detail.getPrice()), memberVo.getMemberLevel(),orderCreateVO.getPresentCards()));//单品折扣
					}else{
						packageSku.setUnitDiscount(BigDecimal.ZERO);
					}*/
				} else {
					//原价
					BigDecimal costPrice = pcsSkuVO.getSalesPrice();
					BigDecimal sellingPrice =  detail.getTotalFee().divide(new BigDecimal(detail.getQuantity())).setScale(2, RoundingMode.HALF_UP);
					//售价和原价相等，则不是行折扣
					if(sellingPrice.equals(costPrice)) {
						packageSku.setUnitDiscount(BigDecimal.ZERO);
					}  else {
						packageSku.setUnitDiscount(costPrice.subtract(sellingPrice));//单品折扣
					}	
				}
				if(detail.getPointPrice()!=null){
					packageSku.setUnitPointDeduction(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()).subtract(BigDecimal.valueOf(detail.getPointPrice())));//折扣后的价格减去积分价格
				}else{
					packageSku.setUnitPointDeduction(BigDecimal.ZERO);
				}
				packageSku.setUnitPrice(pcsSkuVO.getSalesPrice());
				//TODO 是否赠品，0否1是
				packageSku.setIsGift(0);
				opSoPackageSkuVOs.add(packageSku);
		}
		
		// 发票是否随同货物发送，0否1是
		opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
		//是否审单,有两种不同的运输方式或者有自送的。需要审单
		if(deliveryTypes.size()>1||(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF"))){
		   opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
		}else{
		  opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
		}
		//设置配送信息的快递方式，当只有一种配送方式时，设置
		if(deliveryTypes!=null&&deliveryTypes.size()==1){
			if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
			}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
			}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
			}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
			}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
			}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
			}
		}
		
		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
		
		//设置包裹配送信息
		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
		opSoPackageVOs.add(opSoPackage);
		//设置订单关联包裹
		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
		
		//服务费
		opSalesOrderVO.setServiceFeeAmount(BigDecimal.valueOf(orderCreateVO.getServiceFee()));
		// 用户备注
		opSalesOrderVO.setRemark(orderCreateVO.getNote());
		// 内部备注
		opSalesOrderVO.setInnerRemark(orderCreateVO.getInnerRemark());
		//设置订单来源 refer
		opSalesOrderVO.setRefer(orderCreateVO.getRefer());
		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
		// COUPON编码
		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());
		//头折扣
		opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
		//礼品卡
		opSalesOrderVO.setGiftCardDesc(orderCreateVO.getPresentCards());
		//礼品卡金额
		if(orderCreateVO.getCardFeeDiscount()!=null){
			opSalesOrderVO.setGiftCardAmount(BigDecimal.valueOf(orderCreateVO.getCardFeeDiscount()));
		}else{
			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
		}
		//是否匿名
		opSalesOrderVO.setIsAnonymous(orderCreateVO.getAnonymous()?OpSalesOrder.IS_ANONYMOUS_TRUE:OpSalesOrder.IS_ANONYMOUS_FALSE);
		//预售拆包裹  TODO
		List<OpSoPackageVO> splitPackages= splitPackage(opSalesOrderVO, opChannel);
		if(CollectionUtils.isNotEmpty(splitPackages)){
			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
		}
		 return opSalesOrderVO;
	 }

		

	
	
	/***
	 * 计算单价折扣()天猫，京东）
	 * @param unitPrice
	 * @param giftCard
	 */
	private BigDecimal getUnitDiscount(BigDecimal unitPrice,float discount,String giftCard){
		if(StringUtils.isNotBlank(giftCard)) {
			return BigDecimal.ZERO;//使用礼品卡不打折
		}
		BigDecimal discountPrice= PriceUtil.getDiscountPrice(unitPrice, discount);
		return unitPrice.subtract(discountPrice);
	}
	
	/***
	 * 下单前的校验，校验积分、校验价格是否变化,校验库存是否不足
	 * @param orderCreateVO
	 * @param opChannel
	 * @return
	 */
	private void  OrderPreCheck(String channelCode,OrderCreateVO orderCreateVO, OpChannelVO opChannel) {
		List<OrderCreateDetailVO>  details=orderCreateVO.getItems();
		for(OrderCreateDetailVO detail:details){
			//判断商品是否可售
			PsProductVO prod=mcPsProductService.findProdByChnCodeSkuCode(channelCode, detail.getSku());
			if(prod==null||CollectionUtils.isEmpty(prod.getChnCanSaleSKu())||!prod.getCanSaleSku(channelCode).contains(detail.getSku())){
				throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),ErrorCode.ITEM_OFFSHELF.getMesage()+": "+detail.getSku());
			}
			
			PsSkuVO pssSkuVO=mcPsSkuService.findBySkuCode(detail.getSku());
			detail.setIsJit(pssSkuVO.getIsJit());//是否来单制作
			//设置分类id和品牌id coupon使用
			detail.setBrandId(pssSkuVO.getBrandId());
			detail.setCategroyId(pssSkuVO.getCategoryId());
			//检查价格是否发生变化
			if(PegasusConstants.YES!=detail.getIsGift()&&pssSkuVO.getSalesPrice().doubleValue()!=detail.getPrice().doubleValue()){
				throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(), ErrorCode.ITEM_PRICE_CHANGE.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuName()+": "+pssSkuVO.getSalesPrice());
			}
			//JIT商品不校验库存
			if(detail.getIsJit()==null ||PegasusConstants.NO==detail.getIsJit()){
				//检查商品库存
				WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(detail.getSku(), opChannel.getWarehouseForSales());
				Integer quantity=whInvVO.getCanUseInv();
				//增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127

				final SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(detail.getSku(), null);
				if(preSaleInvVO!=null){
					quantity=quantity+preSaleInvVO.getCanUseInv();
				}
				
				if(whInvVO==null||quantity<detail.getQuantity()){
					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuName()+": "+whInvVO.getSkuCode());
				}
			}
		}
	
	}
	
	/***
	 * 判断是否需要拆分包裹，
	 * @param opSalesOrderVO
	 * @param opChannel
	 * @return
	 */
	private List<OpSoPackageVO> splitPackage(OpSalesOrderVO opSalesOrderVO, OpChannelVO opChannel){
		List<OpSoPackageVO> newPackageVOs=null;
		OpSoPackageVO sourcesPackageVO=null;
		List<OpSoPackageVO> sourcesPackages=null;
		List<OpSoPackageSkuVO>  sourcePackageSkus=null;
		if(opSalesOrderVO!=null&&CollectionUtils.isNotEmpty(opSalesOrderVO.getOpSoPackageVOs())&&opSalesOrderVO.getOpSoPackageVOs().size()==1){
			newPackageVOs=new ArrayList<OpSoPackageVO>();
			sourcesPackages=opSalesOrderVO.getOpSoPackageVOs();
			sourcesPackageVO=sourcesPackages.get(0);
			sourcePackageSkus=sourcesPackageVO.getOpSoPackageSkuVOs();
			if(CollectionUtils.isNotEmpty(sourcePackageSkus)){
				for(OpSoPackageSkuVO  packageSkuVO:sourcePackageSkus){
					
					

					SPresaleVO sPresaleVO = sPresaleService.findAvaliableBySkuCode(packageSkuVO.getSkuCode(),false);
					if(sPresaleVO!=null){
						//有预售。再判断物理库存是否可卖。
						//物理库存不足，则拆包裹，物理库存足够，则不拆包裹
						WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(packageSkuVO.getSkuCode(), opChannel.getWarehouseForSales());
						Integer quantity=whInvVO.getCanUseInv();
						
						
		
						final SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(packageSkuVO.getSkuCode(), null);
						Integer preSaleQuantity=preSaleInvVO.getCanUseInv();
						if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()<=preSaleQuantity){
							OpSoPackageVO preSalePackage=new OpSoPackageVO();
							preSalePackage.setCardContent(sourcesPackageVO.getCardContent());
							preSalePackage.setCardType(sourcesPackageVO.getCardType());
							preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
							preSalePackage.setDispatchWarehouseCode(sPresaleVO.getDispatchWarehouseCode());
							preSalePackage.setPlanedDeliveryDate(sPresaleVO.getPlanedDeliveryDate());
							preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//							preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
							preSalePackage.setOpSoPackageDeliveryInfoVO(sourcesPackageVO.getOpSoPackageDeliveryInfoVO());
							List<OpSoPackageSkuVO>  preSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();
							packageSkuVO.setPresaleId(sPresaleVO.getId());
							packageSkuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
							preSalePackageSkus.add(packageSkuVO);
							preSalePackage.setOpSoPackageSkuVOs(preSalePackageSkus);
							newPackageVOs.add(preSalePackage);
						}else if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()>preSaleQuantity){
							throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+packageSkuVO.getSkuCode()+": "+whInvVO.getSkuCode());
						}
					}
				}
			}
		}else{
			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
		}
		if(CollectionUtils.isNotEmpty(newPackageVOs)){
			for(OpSoPackageVO preSalePackage:newPackageVOs){
				List<OpSoPackageSkuVO>  preSalePackageSkus= preSalePackage.getOpSoPackageSkuVOs();
				if(CollectionUtils.isNotEmpty(preSalePackageSkus)){
					sourcePackageSkus.removeAll(preSalePackageSkus);
				}
			}
			sourcesPackages.addAll(newPackageVOs);
		}
		//删掉分包裹之后的空包裹
		List<OpSoPackageVO> tmpPackages=new ArrayList<OpSoPackageVO>();
		for(OpSoPackageVO tmppackage: sourcesPackages){
			if(tmppackage==null||CollectionUtils.isEmpty(tmppackage.getOpSoPackageSkuVOs())){
				tmpPackages.add(tmppackage);
			}
		}
		if(CollectionUtils.isNotEmpty(tmpPackages)) {
			sourcesPackages.removeAll(tmpPackages);
		}
		//当包裹数量大于2时，分别判断每个包裹内的快递
//		if(CollectionUtils.isNotEmpty(sourcesPackages)&&sourcesPackages.size()>1) {
//			for(OpSoPackageVO tmpPackage:sourcesPackages) {
//				Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
//				List<OpSoPackageSkuVO>  packageSkus=tmpPackage.getOpSoPackageSkuVOs();
//				OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=tmpPackage.getOpSoPackageDeliveryInfoVO();
//				if(CollectionUtils.isNotEmpty(packageSkus)){
//					for(OpSoPackageSkuVO tmpSku:packageSkus){
//						PsProductVO productVO=pbInstance.findProdByChnCodeSkuCode(opChannel.getCode(),tmpSku.getSkuCode());
//						if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
//							deliveryTypes.put("SELF", true);
//						}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
//							deliveryTypes.put("FEDX24", true);
//						}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
//							deliveryTypes.put("SF_AIR", true);
//						}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
//							deliveryTypes.put("SF_LAND", true);
//						}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
//							deliveryTypes.put("YTO", true);
//						}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
//							deliveryTypes.put("DEPPON", true);
//						}
//						
//					}
//				}
//				//设置配送信息的快递方式，当只有一种配送方式时，设置
//				if(deliveryTypes!=null&&deliveryTypes.size()==1) {
//					if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
//					}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
//					}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//					}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
//					}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
//					}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
//						opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
//					}
//				}
//			}
//		}
		return sourcesPackages;
	}

	
}
