package com.thebeastshop.pegasus.channelservice.adapter;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.support.util.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author Xiang.Gao
 * @Create In 2019/10/30
 */
@Component
public class StockAdapter {

    private static final String STOCK_WARN_KEY = "stock_warn_onoff";

    /**
     * 库存预警
     * @param stockNum
     * @return
     */
    public String stockWarn(int stockNum) {
        String warnTimeConfig = PropConstants.getProperties(STOCK_WARN_KEY);
        if (StringUtils.isBlank(warnTimeConfig)) {
            return "";
        }
        List<String> stockWarnTime = JsonUtil.toList(warnTimeConfig, String.class);
        if (CollectionUtils.isEmpty(stockWarnTime) || stockWarnTime.size() != 2
                || StringUtils.isBlank(stockWarnTime.get(0)) || StringUtils.isBlank(stockWarnTime.get(1))) {
            return "";
        }
        String format = "yyyy-MM-dd HH:mm:ss";
        Date beginTime = DateUtil.parse(stockWarnTime.get(0), format);
        Date endTime = DateUtil.parse(stockWarnTime.get(1), format);
        // 不在告警时间内
        if (!DateUtil.isInTime(beginTime, endTime, new Date())) {
            return "";
        }
        if (stockNum > 5 || stockNum <=0) {
            return "";
        }
        if (stockNum >= 3) {
            return "库存紧张";
        }
        return "仅剩" + stockNum + "件";
    }

}
