package com.thebeastshop.pegasus.channelservice.adapter;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.google.common.collect.Lists;
import com.thebeastshop.campaign.enums.MemberTypeEnum;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.price.enums.PrsDiscountTypeEnum;
import com.thebeastshop.price.enums.PrsMemberTypeEnum;
import com.thebeastshop.price.vo.PrsCampaignSectionProductVO;
import com.thebeastshop.price.vo.PrsCampaignSectionVO;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.support.vo.cart.CartProductPackVO;

/**
 * @author feiLong.gao
 * @date 2019/4/19
 */
public class PrsCampaignConvert {


  /**
   * 价格计算活动转换为购物车活动对象
   *
   * @param camp
   * @param spvLeft
   * @return
   */
  public static CartProductPackVO.PackCampaignVO convertPackCampaign2PackCampaignVO(PrsCampaignVO camp,
      Integer spvLeft) {
    CartProductPackVO.PackCampaignVO campaignVO = new CartProductPackVO.PackCampaignVO();
    campaignVO.setId(camp.getId());
    campaignVO.setName(camp.getName());
    CartProductPackVO.PackCampaignVO.InfoVO info = new CartProductPackVO.PackCampaignVO.InfoVO();
    if (PrsDiscountTypeEnum.FULL_GIFT.getId().equals(camp.getDiscountTypeId())) {
      if (camp.getCode().equals("app_first_buy")) {
        info.setType("首单赠");
      } else {
        info.setType("赠品");
      }
    }
    if (PrsDiscountTypeEnum.CHEAPEN_OTHER.getId().equals(camp.getDiscountTypeId())) {
      info.setType("换购");
    }
    info.setSummaryColor(spvLeft != null && spvLeft <= 0 ? "#000000" : "#333333");
    campaignVO.setInfo(info);
    return campaignVO;
  }


  /**
   * 活动对象集合转换，由商品活动转为价格计算活动对象
   *
   * @param sources
   * @return
   */
  public static List<PrsCampaignVO> convertList4PsCampaignVO(List<PsCampaignVO> sources) {

    List<PrsCampaignVO> targets = Lists.newArrayList();

    if (CollectionUtils.isEmpty(sources)) {
      return targets;
    }
    for (PsCampaignVO source : sources) {
      targets.add(convert4PsCampaignVO(source));
    }
    return targets;
  }

  /**
   * 活动对象转换，由商品活动转为价格计算活动对象
   *
   * @param source
   * @return
   */
  public static PrsCampaignVO convert4PsCampaignVO(PsCampaignVO source) {
    PrsCampaignVO target = new PrsCampaignVO();
    target.setAccessWayIds(source.getAccessWayIds());
    target.setAdvance(source.getAdvance());
    target.setApprovalState(source.getApprovalState());
    target.setCampaignSectionList(convertList4PsCampaignSectionVO(source.getCampaignSectionList()));
    target.setCode(source.getCode());
    target.setCrossBorderFlag(source.getCrossBorderFlag());
    target.setCumulative(source.getCumulative());
    target.setDiscountTypeId(source.getDiscountTypeId());
    target.setExpireTime(source.getExpireTime());
    target.setId(source.getId());
    target.setLadderRule(source.getLadderRule());
    target.setLevel(source.getLevel());
    target.setMemberLevels(source.getMemberLevels());
    target.setName(source.getName());
    target.setOptionFlag(source.getOptionFlag());
    target.setProductScopeId(source.getProductScopeId());
    target.setStartTime(source.getStartTime());
    target.setState(source.getState());
    target.setTitle(source.getTitle());
    if (MemberTypeEnum.NEW_MEMBER.getCode().equalsIgnoreCase(source.getMemberType())) {
      target.setMemberType(PrsMemberTypeEnum.FISH_MAN);
    } else {
      target.setMemberType(PrsMemberTypeEnum.ALL);
    }
    return target;
  }

  /**
   * 转CampaignSection 集合
   *
   * @param sources
   * @return
   */
  private static List<PrsCampaignSectionVO> convertList4PsCampaignSectionVO(List<PsCampaignSectionVO> sources) {
    List<PrsCampaignSectionVO> targets = Lists.newArrayList();
    if (CollectionUtils.isEmpty(sources)) {
      return targets;
    }

    for (PsCampaignSectionVO source : sources) {
      targets.add(convert4PsCampaignSectionVO(source));
    }
    return targets;
  }

  private static PrsCampaignSectionVO convert4PsCampaignSectionVO(PsCampaignSectionVO source) {
    PrsCampaignSectionVO target = new PrsCampaignSectionVO();
    target.setCampaignId(source.getCampaignId());
    target.setFactor(source.getFactor());
    target.setFactorType(source.getFactorType());
    target.setId(source.getId());
    target.setLine(source.getLine());
    target.setSort(source.getRanking().floatValue());
    target.setSectionProductVOList(convertList4PsCampaignSectionProductVO(source.getCampaignSectionProducts()));
    target.setType(source.getConditionType());
    return target;
  }

  /**
   * CampaignSectionProduct  对象集合转换
   *
   * @param sources
   * @return
   */
  private static List<PrsCampaignSectionProductVO> convertList4PsCampaignSectionProductVO(
      List<PsCampaignSectionProductVO> sources) {
    List<PrsCampaignSectionProductVO> targets = new ArrayList<PrsCampaignSectionProductVO>();
    if (CollectionUtils.isEmpty(sources)) {
      return targets;
    }

    for (PsCampaignSectionProductVO source : sources) {
      targets.add(convert4PsCampaignSectionProductVO(source));
    }
    return targets;
  }


  /**
   * CampaignSectionProduct 对象转换
   *
   * @param source
   * @return
   */
  private static PrsCampaignSectionProductVO convert4PsCampaignSectionProductVO(PsCampaignSectionProductVO source) {
    PrsCampaignSectionProductVO target = new PrsCampaignSectionProductVO();
    target.setSort(source.getSort());
    target.setCampaignId(source.getCampaignId());
    target.setCampaignSectionId(source.getCampaignSectionId());
    target.setId(source.getId());
    target.setLimitCount(source.getLimitCount());
    target.setCount(source.getPriceCount());
    target.setPrice(source.getPricePrice());
    target.setProductId(source.getProductId());
    return target;
  }
}
