package com.thebeastshop.pegasus.channelservice.adapter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.pegasus.channelservice.constants.PegasusConstants;
import com.thebeastshop.pegasus.channelservice.util.PriceUtil;
import com.thebeastshop.wms.sservice.SWhInvService;
import com.thebeastshop.wms.vo.WhInvVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.member.service.MemberQueryService;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.channelservice.constants.ErrorCode;
import com.thebeastshop.pegasus.channelservice.exception.ChannelException;
import com.thebeastshop.pegasus.channelservice.vo.IdCardVO;
import com.thebeastshop.pegasus.channelservice.vo.address.AddressVO;
import com.thebeastshop.pegasus.channelservice.vo.order.GroupProdSKu;
import com.thebeastshop.pegasus.channelservice.vo.order.IposOrderVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderCreateVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderDetailVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLineVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderListVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLogisticActivityVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderLogisticVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderPackageVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderQueryVO;
import com.thebeastshop.pegasus.channelservice.vo.order.OrderSkuVO;
import com.thebeastshop.pegasus.channelservice.vo.order.PackageDeliveryInfoVO;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsAttributeValuePairVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.service.operation.PegasusOperationServiceFacade;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSalesOrderVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageDeliveryInfoVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageSkuVO;
import com.thebeastshop.pegasus.service.operation.channelvo.OpSoPackageVO;
import com.thebeastshop.pegasus.service.operation.enums.PackageDeclarationStateEnum;
import com.thebeastshop.pegasus.service.operation.model.OpExpressTrace;
import com.thebeastshop.pegasus.service.operation.model.OpSalesOrder;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackage;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeclaration;
import com.thebeastshop.pegasus.service.operation.model.OpSoPackageDeclarationExample;
import com.thebeastshop.pegasus.service.operation.vo.LogisticActivityVO;
import com.thebeastshop.pegasus.service.operation.vo.LogisticVO;
import com.thebeastshop.pegasus.service.operation.vo.ResponseVO;
import com.thebeastshop.stock.service.SPresaleService;
import com.thebeastshop.stock.vo.SPresaleSaleInvVO;
import com.thebeastshop.support.enums.OrderCardType;
import com.thebeastshop.support.vo.order.OrderCard;


@Service("weixinorderAdapter")
public class OrderAdapter {
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private MemberQueryService memberQueryService;
	@Autowired
	private SWhInvService sWhInvService;

	private final static Logger logger = LoggerFactory.getLogger(OrderAdapter.class);

	private PegasusOperationServiceFacade poInstance=PegasusOperationServiceFacade.getInstance();

	@Autowired
	private SPresaleService sPresaleService;
	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderQueryVO
	 */
	public OpSalesOrderVO website2Common(OrderQueryVO orderQueryVO) {
		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
		return opSalesOrderVO;
	}

	/***
	 * 根据通用的订单对象。封装成接口参数
	 * 
	 * @param opSalesOrderVO
	 * @return OrderQueryVO
	 */
	public OrderQueryVO common2website(OpSalesOrderVO opSalesOrderVO) {
		
		OrderQueryVO orderQueryVO = new OrderQueryVO();
		
		//整体订单解析
		orderQueryVO.setAmountTotal(opSalesOrderVO.getNeedToPayAmount().doubleValue());
		orderQueryVO.setDateOrder(String.valueOf(opSalesOrderVO.getCreateTime()));
		orderQueryVO.setExpectDeliveryDate(String.valueOf(opSalesOrderVO.getExpectReceiveDate()));
		orderQueryVO.setId(opSalesOrderVO.getId());
		orderQueryVO.setLimitedHour(opSalesOrderVO.getLimitDeliveryTimeDesc());
		orderQueryVO.setName(opSalesOrderVO.getCode());
		AddressVO partner_shipping_id=new AddressVO();
		partner_shipping_id.setId(opSalesOrderVO.getAddressId());
		partner_shipping_id.setCircuit(opSalesOrderVO.getCircuitDesc());
		partner_shipping_id.setCity(opSalesOrderVO.getCity());
		partner_shipping_id.setDistrict(opSalesOrderVO.getDistrict());
		partner_shipping_id.setId(opSalesOrderVO.getAddressId());
		partner_shipping_id.setPhone(opSalesOrderVO.getReceiverPhone());
		partner_shipping_id.setName(opSalesOrderVO.getReceiver());
		partner_shipping_id.setStreet(opSalesOrderVO.getAddress());
		partner_shipping_id.setProvince(opSalesOrderVO.getProvince());
		partner_shipping_id.setZip(opSalesOrderVO.getZipCode());
		
		orderQueryVO.setPartnerShippingId(partner_shipping_id);
		orderQueryVO.setOrderOutState(opSalesOrderVO.getSalesOrderStatus());
		orderQueryVO.setShopId(String.valueOf(opSalesOrderVO.getShopId()));
		orderQueryVO.setShopName(opSalesOrderVO.getShopName());
		return orderQueryVO;
	}
	
	/***
	 * 通用订单查询
	 * @param opSalesOrderVOs
	 * @return
	 */
	public List<OrderListVO> common2channel(List<OpSalesOrderVO> opSalesOrderVOs) {

		
		List<OrderListVO> orderListVOs=new ArrayList<OrderListVO>();
		if(CollectionUtils.isNotEmpty(opSalesOrderVOs)){
			
			List<Long> spvIds = new ArrayList<>();
			List<String> prodIds = new ArrayList<>();
			List<String> skuCodes = new ArrayList<>();
			Map<String, PsProductVO> prodMap = new HashMap<>();
			Map<Long, PsSpvVO> spvMap = new HashMap<>();
			Map<String, PsSkuVO> skuMap = new HashMap<>();
			Map<String, PsProductVO> skuProdMap = new HashMap<>();

			for (OpSalesOrderVO salesorderVO : opSalesOrderVOs) {

				List<OpSoPackageVO> packageVOs = salesorderVO.getOpSoPackageVOs();

				if (CollectionUtils.isNotEmpty(packageVOs)) {

					for (OpSoPackageVO packageVO : packageVOs) {
						List<OpSoPackageSkuVO> packageSkuVOs = packageVO.getOpSoPackageSkuVOs();

						if (CollectionUtils.isNotEmpty(packageSkuVOs)) {
							for (OpSoPackageSkuVO packageSKuVO : packageSkuVOs) {

								if (packageSKuVO.getSpvId()!=null && !spvIds.contains(packageSKuVO.getSpvId())) {
									spvIds.add(packageSKuVO.getSpvId());
								}

								if (packageSKuVO.getProductId()!=null && !prodIds.contains(String.valueOf(packageSKuVO.getProductId()))) {
									prodIds.add(String.valueOf(packageSKuVO.getProductId()));
								}

								if (!skuCodes.contains(packageSKuVO.getSkuCode())) {
									skuCodes.add(packageSKuVO.getSkuCode());
								}

							}
						}

					}

				}

			}
				
			if (CollectionUtils.isNotEmpty(spvIds)) {
				spvMap.putAll(mcPsSpvService.mapBySpvIds(spvIds));
			}
			if (CollectionUtils.isNotEmpty(prodIds)) {
				prodMap.putAll(mcPsProductService.mapByProdIds(prodIds));
			}
			if (CollectionUtils.isNotEmpty(skuCodes)) {
				List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);

				for (PsSkuVO sku : skus) {
					skuMap.put(sku.getSkuCode(), sku);
				}

				List<PsProductVO> prods = mcPsProductService.findProdBySkuCodes(skuCodes);

				for (String skuCode : skuCodes) {

					for (PsProductVO prod : prods) {
						if (prod.getSkuCodes().contains(skuCode)) {
							skuProdMap.put(skuCode, prod);
							break;
						}

					}

				}

			}
			    
			
			for(OpSalesOrderVO salesorderVO:opSalesOrderVOs){
				// 记录组合商品
				Map<String,OrderSkuVO> map = new HashMap<>();
				OrderListVO orderListVO = new OrderListVO();
				orderListVO.setId(salesorderVO.getId());
				orderListVO.setCode(salesorderVO.getCode());
				orderListVO.setOrderDate(DateUtil.format(salesorderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				orderListVO.setOrderState(salesorderVO.getSalesOrderStatus());
				orderListVO.setPayAmount(salesorderVO.getNeedToPayAmount()==null?0:salesorderVO.getNeedToPayAmount().doubleValue());
				orderListVO.setReceiver(getReceiverFromDeliveryInfo(salesorderVO));
				orderListVO.setCrossBorderFlag(salesorderVO.getCrossBorderFlag());
				orderListVO.setOrderType(salesorderVO.getOrderTypeEnum().getCode());
				// 海淘身份证信息
				if(salesorderVO.getOpIdCardVO()!=null){
					IdCardVO idCardVO = new IdCardVO();
					idCardVO.setAuditStatus(salesorderVO.getOpIdCardVO().getAuditStatus());
					idCardVO.setBackCardPhoto(salesorderVO.getOpIdCardVO().getBackCardPhoto());
					idCardVO.setFrontCardPhoto(salesorderVO.getOpIdCardVO().getFrontCardPhoto());
					idCardVO.setId(salesorderVO.getOpIdCardVO().getId());
					idCardVO.setIdNumber(salesorderVO.getOpIdCardVO().getIdNumber());
					idCardVO.setName(salesorderVO.getOpIdCardVO().getName());
					idCardVO.setOrderId(salesorderVO.getOpIdCardVO().getOrderId());
					orderListVO.setIdCardVO(idCardVO);
				}
				
				List<OrderSkuVO> orderSkus=new ArrayList<OrderSkuVO>();
				List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
				if(CollectionUtils.isNotEmpty(packageVOs)){
					for(OpSoPackageVO packageVO:packageVOs){
						List<OpSoPackageSkuVO>  packageSkuVOs=packageVO.getOpSoPackageSkuVOs();
						if(CollectionUtils.isNotEmpty(packageSkuVOs)){
							for(OpSoPackageSkuVO packageSKuVO:packageSkuVOs){
								
								//判断当前商品是不是组合商品
								if(packageSKuVO.getProductId()!=null && packageSKuVO.getProductId()>0){
								  
									OrderSkuVO orderSKuVO = map.get(packageSKuVO.getProductId()+""+packageSKuVO.getSpvId());
									
									if(orderSKuVO == null){
										orderSKuVO = new OrderSkuVO();
									
										// 存放规格
										PsSpvVO psSpvVo = spvMap.get(packageSKuVO.getSpvId());
										//int quantity = 1;
										if(psSpvVo!=null){
											
											if(CollectionUtils.isNotEmpty(psSpvVo.getAttributeValuePairList())){
												for(PsAttributeValuePairVO bean:psSpvVo.getAttributeValuePairList()){
													GroupProdSKu sku = new GroupProdSKu();
													sku.setSkuDescribe(bean.getAttrName()+":"+bean.getValue());
													orderSKuVO.getGroupProdSKuList().add(sku);
												}

											}	
											
										}
										   // 数量
										 orderSKuVO.setQuantity(packageSKuVO.getProdQuantity());
									
										orderSKuVO.setUnitPrice(packageSKuVO.getTotalPrice().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()),2, RoundingMode.HALF_UP).doubleValue());
										

										orderSKuVO.setUnitPriceAfterDiscount(packageSKuVO.getTotalPriceAfterApt().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()), 2,RoundingMode.HALF_UP).doubleValue());


										

									   orderSKuVO.setCancleQuantity(0);
					
										//PsProductVO productVO = mcPsProductService.findByProdId(packageSKuVO.getProductId());
										PsProductVO productVO = prodMap.get(packageSKuVO.getProductId().toString());
										//PsSkuVO psSku = skuMap.get(packageSKuVO.getSkuCode());
										if(null!=productVO){
										  if(CollectionUtils.isEmpty(productVO.getSkuCodes()) && productVO.getSkuCodes().size()>1){
											  orderSKuVO.setShowSkuCode(productVO.getCode());
										  }
										  orderSKuVO.setSkuCode(productVO.getCode());
										  orderSKuVO.setShowSkuCode(productVO.getCode());
										  orderSKuVO.setProductCode(productVO.getCode());
										  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
										  orderSKuVO.setSkuTitle(productVO.getNameCn());
										  if(!CollectionUtils.isEmpty(productVO.getBrands())){
											  orderSKuVO.setBrandName(productVO.getBrands().get(0).getBrandNameCN());
										  }
										 
										
										}

										orderSKuVO.setCrossBorderFlag(packageSKuVO.getCrossBorderFlag());

										map.put(packageSKuVO.getProductId()+""+packageSKuVO.getSpvId(), orderSKuVO);
										orderSkus.add(orderSKuVO);
									}else{
										

										Double unitPrice = packageSKuVO.getTotalPrice()
												.divide(BigDecimal.valueOf(orderSKuVO.getQuantity()), 2,
														RoundingMode.HALF_UP)
												.doubleValue();
										unitPrice = unitPrice + orderSKuVO.getUnitPrice();

										orderSKuVO.setUnitPrice(unitPrice);

										Double unitPriceAfterDiscount = orderSKuVO.getUnitPriceAfterDiscount();
										unitPriceAfterDiscount = unitPriceAfterDiscount
												+ packageSKuVO.getTotalPriceAfterApt()
														.divide(BigDecimal.valueOf(orderSKuVO.getQuantity()), 2,
																RoundingMode.HALF_UP)
														.doubleValue();

										orderSKuVO.setUnitPriceAfterDiscount(unitPriceAfterDiscount);
									
									}
								}else{
									OrderSkuVO orderSKuVO=new OrderSkuVO();
									orderSKuVO.setCancleQuantity(packageSKuVO.getCancleQuantity());
									orderSKuVO.setQuantity(packageSKuVO.getQuantity());
									orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
									orderSKuVO.setShowSkuCode(packageSKuVO.getSkuCode());
									orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice()==null?0:packageSKuVO.getUnitPrice().doubleValue());
									orderSKuVO.setUnitPriceAfterDiscount(packageSKuVO.getUnitPriceAfterDiscount().doubleValue());
									PsProductVO productVO = skuProdMap.get(packageSKuVO.getSkuCode());
									PsSkuVO psSku=skuMap.get(packageSKuVO.getSkuCode());
									if(null!=productVO){
										
								      if(CollectionUtils.isEmpty(productVO.getSkuCodes()) && productVO.getSkuCodes().size()>1){
									      orderSKuVO.setShowSkuCode(productVO.getCode());
									  }
									  orderSKuVO.setProductCode(productVO.getCode());
									  
									  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
									
									}
									if(null!=psSku){
									  orderSKuVO.setBrandName(psSku.getBrandName());
									  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
									}
									
									orderSKuVO.setCrossBorderFlag(packageSKuVO.getCrossBorderFlag());
									orderSkus.add(orderSKuVO);
								}
								
							}
						}
					}
				}
				orderListVO.setOrderStateDesc(getOrderStateDesc(salesorderVO));
				orderListVO.setOrderSkus(orderSkus);
				orderListVOs.add(orderListVO);
			}
		}

		
		return orderListVOs;
	}
	
	
	/***
	 * 通用订单查询
	 * @param opSalesOrderVOs
	 * @return
	 */
	public List<IposOrderVO> common2order(List<OpSalesOrderVO> opSalesOrderVOs) {
		List<IposOrderVO> orderListVOs=new ArrayList<IposOrderVO>();
		if(CollectionUtils.isNotEmpty(opSalesOrderVOs)){
			// 先获取会员
			Map<String, MemberVO> memberMap = Maps.newHashMap();
			List<String> memberCodes = Lists.newArrayListWithExpectedSize(opSalesOrderVOs.size());
			for (OpSalesOrderVO salesorderVO : opSalesOrderVOs) {
				if (StringUtils.isNotBlank(salesorderVO.getMemberCode())) {
					memberCodes.add(salesorderVO.getMemberCode());
				}
			}
			List<MemberVO> members = memberQueryService.getByCodes(memberCodes);
			for (MemberVO memberVO : members) {
				memberMap.put(memberVO.getCode(), memberVO);
			}
			for(OpSalesOrderVO salesorderVO:opSalesOrderVOs){
				IposOrderVO orderVO = new IposOrderVO();
				orderVO.setId(salesorderVO.getId());
				orderVO.setCode(salesorderVO.getCode());
				orderVO.setOrderDate(DateUtil.format(salesorderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				orderVO.setOrderState(salesorderVO.getSalesOrderStatus());
				orderVO.setPayAmount(salesorderVO.getNeedToPayAmount()==null?0:salesorderVO.getNeedToPayAmount().doubleValue());
				orderVO.setReceiver(getReceiverFromDeliveryInfo(salesorderVO));

				if(salesorderVO.getMemberCode()!=null){
					// 根据membercode取得会员
					MemberVO opMemberVO = memberMap.get(salesorderVO.getMemberCode());
					
					if(opMemberVO!=null){
						// 会员等级
						orderVO.setMemberLevel(opMemberVO.getMemberLevel());
					}
				}
				
				// 订单类型
				orderVO.setOrderType(salesorderVO.getSalesOrderType());
				// 订单来源渠道编码
				orderVO.setChannelCode(salesorderVO.getChannelCode());
				// 会员code
				orderVO.setMemberCode(salesorderVO.getMemberCode());
				// 销售人员id
				orderVO.setCreateOperatorId(salesorderVO.getCreateOperatorId());
				// 销售人员名
				orderVO.setCreateOperatorName(salesorderVO.getCreateOperatorName());
				// 付款时间
				orderVO.setPayTime(salesorderVO.getPayTime());
				// 服务费金额
				orderVO.setServiceFeeAmount(salesorderVO.getServiceFeeAmount());
				// 礼品卡支付金额
				orderVO.setGiftCardAmount(salesorderVO.getGiftCardAmount());
				// 支付方式
				orderVO.setGiftCardDesc(salesorderVO.getGiftCardDesc());
				// coupon编码
				orderVO.setCouponCode(salesorderVO.getCouponCode());
				// coupon折扣金额（包含在订单头折扣
				orderVO.setCouponDiscountAmount(salesorderVO.getCouponDiscountAmount());
				// 礼品卡描述，逗号分隔
				orderVO.setGiftCardDesc(salesorderVO.getGiftCardDesc());
				List<OrderSkuVO> orderSkus = new ArrayList<OrderSkuVO>();
				List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
				if(CollectionUtils.isNotEmpty(packageVOs)){
					for(OpSoPackageVO packageVO:packageVOs){
						List<OpSoPackageSkuVO>  packageSkuVOs=packageVO.getOpSoPackageSkuVOs();
						if(CollectionUtils.isNotEmpty(packageSkuVOs)){
							for(OpSoPackageSkuVO packageSKuVO:packageSkuVOs){
								OrderSkuVO orderSKuVO=new OrderSkuVO();
								orderSKuVO.setQuantity(packageSKuVO.getQuantity());
								orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setShowSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice()==null?0:packageSKuVO.getUnitPrice().doubleValue());
								PsProductVO productVO=mcPsProductService.findProdBySkuCode(packageSKuVO.getSkuCode());
								PsSkuVO  psSku=mcPsSkuService.findBySkuCode(packageSKuVO.getSkuCode());
								if(null!=productVO){
								if(CollectionUtils.isEmpty(productVO.getSkuCodes()) && productVO.getSkuCodes().size()>1){
							      orderSKuVO.setShowSkuCode(productVO.getCode());
								}
								  orderSKuVO.setProductCode(productVO.getCode());
								  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
								  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
								}
								if(null!=psSku){
								  orderSKuVO.setBrandName(psSku.getBrandName());
								}
								orderSkus.add(orderSKuVO);
							}
						}
					}
				}
				orderVO.setOrderStateDesc(getOrderStateDesc(salesorderVO));
				orderVO.setOrderSkus(orderSkus);
				orderListVOs.add(orderVO);

			}
		}

		
		return orderListVOs;
	}
	/***
	 * 
	 * @param salesorderVO
	 * @return
	 */
	private String getOrderStateDesc(OpSalesOrderVO salesorderVO){
		Integer orderStatus=  salesorderVO.getSalesOrderStatus();
		List<OpSoPackageVO>  packageVOs=salesorderVO.getOpSoPackageVOs();
		Set<Integer> packageStatusSet=new HashSet<Integer>();
		if(OpSalesOrder.ORDER_STATUS_CANCLE==orderStatus){
			return "已取消";
		}
		if(OpSalesOrder.ORDER_STATUS_HOLD==orderStatus||OpSalesOrder.ORDER_STATUS_NONPAYMENT==orderStatus){
			return "等待付款";
		}
		boolean allPackageNotSend=true;//所有包裹均未发货  订单状态为11包裹状态为10 11 12
		if(CollectionUtils.isNotEmpty(packageVOs)){
			for(OpSoPackageVO packageVO:packageVOs){
				packageStatusSet.add(packageVO.getPackageStatus());
				//等待发货
				if(!packStatusWait.contains(packageVO.getPackageStatus())){
					allPackageNotSend = false;
				}
			}
		}else{
			allPackageNotSend = false;
		}
		//等待发货
//		boolean allPackageNotSend=false;//所有包裹均未发货  订单状态为11包裹状态为10 11 12
//		if(packageStatusSet!=null&&packageStatusSet.size()>0){
//			int packageStatusSize=packageStatusSet.size();
//			boolean PACKAGE_STATUS_DEFAULT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_DEFAULT);
//			boolean PACKAGE_STATUS_WAITING_MAKE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_MAKE);
//			boolean PACKAGE_STATUS_WAITING_SEND=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_SEND);
//			boolean PACKAGE_STATUS_ALREADY_OUT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_OUT);
//			if(packageStatusSize==1&&PACKAGE_STATUS_DEFAULT){
//				allPackageNotSend=true ;
//			}else if(packageStatusSize==1&&PACKAGE_STATUS_WAITING_MAKE){
//				allPackageNotSend=true ;
//			}else if(packageStatusSize==1&&PACKAGE_STATUS_WAITING_SEND){
//				allPackageNotSend=true ;
//			}else if(packageStatusSize==1&&PACKAGE_STATUS_ALREADY_OUT){
//				allPackageNotSend=true ;
//			}else if((packageStatusSize==2&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_MAKE)||
//					(packageStatusSize==2&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_SEND)||
//					(packageStatusSize==2&&PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_SEND)){
//				allPackageNotSend=true;
//			}else if(packageStatusSize==3&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_SEND){
//				allPackageNotSend=true;
//			}else if(packageStatusSize==4&&PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_SEND&&PACKAGE_STATUS_ALREADY_OUT){
//				allPackageNotSend=true;
//			}
//		}
		if((OpSalesOrder.ORDER_STATUS_HOLD_REVIEW==orderStatus)||(OpSalesOrder.ORDER_STATUS_WAITING_REVIEW==orderStatus)||(OpSalesOrder.ORDER_STATUS_ALREADY_REVIEW==orderStatus&&allPackageNotSend)){
			return "等待发货";
		}
		
		//已发货
		boolean allPackageSend=false;//包裹状态为13 14
		if(packageStatusSet!=null&&packageStatusSet.size()>0){
			int packageStatusSize=packageStatusSet.size();
			boolean PACKAGE_STATUS_ALREADY_OUT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_OUT);
			boolean PACKAGE_STATUS_WAITING_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_RECEIVE);
			boolean PACKAGE_STATUS_ALREADY_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_RECEIVE);
			
			
			if(PACKAGE_STATUS_ALREADY_OUT){
				packageStatusSize=packageStatusSize-1;
			}
			
			if(PACKAGE_STATUS_WAITING_RECEIVE){
				packageStatusSize=packageStatusSize-1;
			}
			
			if(PACKAGE_STATUS_ALREADY_RECEIVE){
				packageStatusSize=packageStatusSize-1;
			}
			
			if(packageStatusSize == 0){
				allPackageSend = true;
			}
			
		}
		if(allPackageSend){
			if(orderStatus==OpSalesOrder.ORDER_STATUS_ALREADY_FINISHED)
			{
				return "已完成";
			}
			return "已发货";
		}
		//部分发货
		boolean partPackageSend=false;//包裹同时包含未发货包裹和已发货包裹
		if(packageStatusSet!=null&&packageStatusSet.size()>0){
			boolean PACKAGE_STATUS_DEFAULT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_DEFAULT);
			boolean PACKAGE_STATUS_WAITING_MAKE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_MAKE);
			boolean PACKAGE_STATUS_WAITING_SEND=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_SEND);
			boolean PACKAGE_STATUS_ALREADY_OUT=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_OUT);
			
			boolean PACKAGE_STATUS_WAITING_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_WAITING_RECEIVE);
			boolean PACKAGE_STATUS_ALREADY_RECEIVE=packageStatusSet.contains(OpSoPackage.PACKAGE_STATUS_ALREADY_RECEIVE);
			if((PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_DEFAULT&&PACKAGE_STATUS_ALREADY_RECEIVE)||
					(PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_WAITING_MAKE&&PACKAGE_STATUS_ALREADY_RECEIVE)||
					(PACKAGE_STATUS_WAITING_SEND&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_WAITING_SEND&&PACKAGE_STATUS_ALREADY_RECEIVE)||
					(PACKAGE_STATUS_ALREADY_OUT&&PACKAGE_STATUS_WAITING_RECEIVE)||
					(PACKAGE_STATUS_ALREADY_OUT&&PACKAGE_STATUS_ALREADY_RECEIVE)){
				partPackageSend=true;
			}
		}
		if(partPackageSend){
			if(orderStatus==OpSalesOrder.ORDER_STATUS_ALREADY_FINISHED)
			{
				return "已完成";
			}
			return "部分发货";
		}
		if(orderStatus==OpSalesOrder.ORDER_STATUS_ALREADY_FINISHED)
		{
			return "已完成";
		}
		return "";
	}
	
	private String getReceiverFromDeliveryInfo(OpSalesOrderVO salesorderVO){
		if(salesorderVO!=null){
			List<OpSoPackageVO> packageVOs=salesorderVO.getOpSoPackageVOs();
			if(CollectionUtils.isNotEmpty(packageVOs)){
				OpSoPackageDeliveryInfoVO  deliveryInfoVO=packageVOs.get(0).getOpSoPackageDeliveryInfoVO();
				if(deliveryInfoVO!=null){
					return deliveryInfoVO.getReceiver();
				}
			}
		}
		return null;
	}
	
	/***
	 * 通用订单详情转换
	 * @param orderVO
	 * @return
	 */
	public OrderDetailVO common2channel(OpSalesOrderVO orderVO){
		
		// 记录组合商品
		Map<String,OrderSkuVO> map = new HashMap<>();
		
		OrderDetailVO detailVO=new OrderDetailVO();
		detailVO.setOrderCode(orderVO.getCode());
		detailVO.setOrderDate(DateUtil.format(orderVO.getCreateTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setChannelCode(orderVO.getChannelCode());
		detailVO.setCouponAmount(orderVO.getCouponDiscountAmount()==null?0:orderVO.getCouponDiscountAmount().doubleValue());
		detailVO.setAuditTime(orderVO.getAuditTime()==null?null:DateUtil.format(orderVO.getAuditTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setGiftCardAmount(orderVO.getGiftCardAmount()==null?0:orderVO.getGiftCardAmount().doubleValue());
		detailVO.setPayAmount(orderVO.getNeedToPayAmount()==null?0:orderVO.getNeedToPayAmount().doubleValue());
		detailVO.setPayTime(orderVO.getPayTime()==null?null: DateUtil.format(orderVO.getPayTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
		detailVO.setOrderStateDesc(getOrderStateDesc(orderVO));
		detailVO.setOrderState(orderVO.getSalesOrderStatus());
		detailVO.setTotalAmount(orderVO.getTotalAmount());
		detailVO.setDiscountOnHead(orderVO.getDiscountOnHead());
		detailVO.setDiscountOnLine(orderVO.getDiscountOnLine());
		detailVO.setCrossBorderFee(orderVO.getCrossFree()==null?0:orderVO.getCrossFree().doubleValue());
		detailVO.setServiceFeeAmount(orderVO.getServiceFeeAmount()==null?BigDecimal.ZERO:orderVO.getServiceFeeAmount());
		detailVO.setIsAnonymous(orderVO.getIsAnonymous());
		detailVO.setCrossBorderFlag(orderVO.getCrossBorderFlag());
		detailVO.setOrderType(orderVO.getOrderTypeEnum().getCode());
		// 海淘身份证信息
		if(orderVO.getOpIdCardVO()!=null){
			IdCardVO idCardVO = new IdCardVO();
			idCardVO.setAuditStatus(orderVO.getOpIdCardVO().getAuditStatus());
			idCardVO.setBackCardPhoto(orderVO.getOpIdCardVO().getBackCardPhoto());
			idCardVO.setFrontCardPhoto(orderVO.getOpIdCardVO().getFrontCardPhoto());
			idCardVO.setId(orderVO.getOpIdCardVO().getId());
			idCardVO.setIdNumber(orderVO.getOpIdCardVO().getIdNumber());
			idCardVO.setName(orderVO.getOpIdCardVO().getName());
			idCardVO.setOrderId(orderVO.getOpIdCardVO().getOrderId());
			detailVO.setIdCardVO(idCardVO);
		}
		
		 List<OpSoPackageVO>  packageVOs=orderVO.getOpSoPackageVOs();
		 
		 
		 
		 List<Long> spvIds = new ArrayList<>();
			List<String> prodIds = new ArrayList<>();
			List<String> skuCodes = new ArrayList<>();
			Map<String, PsProductVO> prodMap = new HashMap<>();
			Map<Long, PsSpvVO> spvMap = new HashMap<>();
			Map<String, PsSkuVO> skuMap = new HashMap<>();
			Map<String, PsProductVO> skuProdMap = new HashMap<>();

			if (CollectionUtils.isNotEmpty(packageVOs)) {

					for (OpSoPackageVO packageVO : packageVOs) {
						List<OpSoPackageSkuVO> packageSkuVOs = packageVO.getOpSoPackageSkuVOs();

						if (CollectionUtils.isNotEmpty(packageSkuVOs)) {
							for (OpSoPackageSkuVO packageSKuVO : packageSkuVOs) {

								if (!spvIds.contains(packageSKuVO.getSpvId())) {
									spvIds.add(packageSKuVO.getSpvId());
								}

								if (!prodIds.contains(String.valueOf(packageSKuVO.getProductId()))) {
									prodIds.add(String.valueOf(packageSKuVO.getProductId()));
								}

								if (!skuCodes.contains(packageSKuVO.getSkuCode())) {
									skuCodes.add(packageSKuVO.getSkuCode());
								}

							}
						}

					}

				}

			
				
			if (CollectionUtils.isNotEmpty(spvIds)) {
				spvMap.putAll(mcPsSpvService.mapBySpvIds(spvIds));
			}
			if (CollectionUtils.isNotEmpty(prodIds)) {
				prodMap.putAll(mcPsProductService.mapByProdIds(prodIds));
			}
			if (CollectionUtils.isNotEmpty(skuCodes)) {
				List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);

				for (PsSkuVO sku : skus) {
					skuMap.put(sku.getSkuCode(), sku);
				}

				List<PsProductVO> prods = mcPsProductService.findProdBySkuCodes(skuCodes);

				if(CollectionUtils.isNotEmpty(prods)){
					for (String skuCode : skuCodes) {

						for (PsProductVO prod : prods) {
							if (prod.getSkuCodes().contains(skuCode)) {
								skuProdMap.put(skuCode, prod);
								break;
							}

						}

					}

				}
				
			}
		 
		 
		 
		 
		 if(CollectionUtils.isNotEmpty(packageVOs)){
			 List<OrderPackageVO> packages=new ArrayList<OrderPackageVO>();
			 for(OpSoPackageVO packageVO:packageVOs){
				 OrderPackageVO orderPackageVO=new OrderPackageVO();
				 orderPackageVO.setCode(packageVO.getCode());
				 // 礼品卡
				 OrderCard card = new OrderCard();
				 card.setContent(packageVO.getCardContent());
				 card.setFrom(packageVO.getCardFrom());
				 card.setTo(packageVO.getCardTo());
				
				 if(packageVO.getCardType()!=null){
					 
					 if(packageVO.getCardType()==2){
						 card.setType(OrderCardType.WRITE);
					 }else if(packageVO.getCardType()==1){
						 card.setType(OrderCardType.EMPTY);
					 }else{
						 card.setType(OrderCardType.NONE);
					 }
					 
					 
				 }

				 // 大家具包裹
				 if(packageVO.getPackageType()==OpSoPackage.PACKAGE_TYPE_7){
					 detailVO.setHasLogistics(1);
				 }
				 
				 orderPackageVO.setOrderCard(card);
				 orderPackageVO.setCardContent(packageVO.getCardContent());
				 orderPackageVO.setCardType(packageVO.getCardType());
				 orderPackageVO.setDeliveryType(packageVO.getDeliveryType());
				 orderPackageVO.setExpectReceiveDate(packageVO.getExpectReceiveDate());
				 orderPackageVO.setExpectReceiveDateStr(DateUtil.format(packageVO.getExpectReceiveDate(), DateUtil.DEFAULT_DATE_FORMAT));
				 orderPackageVO.setPlanedDeliveryDate(packageVO.getPlanedDeliveryDate());
				 orderPackageVO.setLimitDeliveryTimeDesc(packageVO.getLimitDeliveryTimeDesc());
				 orderPackageVO.setPackageStatus(packageVO.getPackageStatus());
				 orderPackageVO.setPackageStatusDesc(getPackageStatusDesc(orderVO.getSalesOrderStatus(),packageVO.getPackageStatus()));
				 orderPackageVO.setDeliveryTime(DateUtil.format(packageVO.getDeliveryTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				 orderPackageVO.setReceiveTime(DateUtil.format(packageVO.getReceiveTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				 orderPackageVO.setOrderMakeTime(DateUtil.format(packageVO.getOrderMakeTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				  //待发货且是海淘包裹， 判断海关状态

					 if(packageVO.getCrossBorderFlag()!=null && packageVO.getCrossBorderFlag()==1){
						 OpSoPackageDeclarationExample example = new OpSoPackageDeclarationExample();
						 example.createCriteria().andPackageIdEqualTo(packageVO.getId());
						 example.setOrderByClause("id desc");
						 List<OpSoPackageDeclaration> list = poInstance.getPackageDeclarationByCondition(example);
						 if(CollectionUtils.isNotEmpty(list)){

							 String message1 = "";
							 String message2 = "";
							 String message3 = "";
							 
							 for(OpSoPackageDeclaration dl :list){
								 
								 if(!StringUtils.isBlank(message1) && StringUtils.isNotBlank(message2)&& StringUtils.isNotBlank(message3)){
									 break;
								 }
								 
								 if(dl.getStateType()!=null && dl.getStateType()==2){
	                                 if(dl.getStateCode()==PackageDeclarationStateEnum.CUSTOM_PENDING.getIndex()){
	
										 //crossPackStatus.add("【海关清关中】等待海关放行  "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATE_FORMAT));
	                                	 message2 = "【海关清关中】等待海关放行        "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATETIME_FORMAT);
									 }else if(dl.getStateCode()==PackageDeclarationStateEnum.DECLARATION_PASS.getIndex()){
										 
										 message1="【清关成功】等待国内配送         "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATETIME_FORMAT);
										 
										// crossPackStatus.add("【清关成功】等待国内配送  "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATE_FORMAT));
									 }
									 
									 
								 }else if(dl.getStateType()!=null && dl.getStateType()==1){
									 
									 if(dl.getStateCode()==PackageDeclarationStateEnum.FINISH_WARAHOUSE_OPRATION.getIndex()){

										 //crossPackStatus.add("【已发货】海外转运中  "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATE_FORMAT));
										 message3="【已发货】海外转运中         "+DateUtil.format(dl.getCreateTime(),DateUtil.DEFAULT_DATETIME_FORMAT);
									 }
									 
								 }
							 }
							 
							 List<String> crossPackStatus = new ArrayList<>();
							 if(StringUtils.isNotBlank(message1)){
								 crossPackStatus.add(message1);
							 }
							 if(StringUtils.isNotBlank(message2)){
								 crossPackStatus.add(message2);
							 }
							 if(StringUtils.isNotBlank(message3)){
								 crossPackStatus.add(message3);
							 }
							 orderPackageVO.setCrossPackStatus(crossPackStatus);
						 }
						 
					 }
				 

				 orderPackageVO.setCrossBorderFlag(packageVO.getCrossBorderFlag());
				 orderPackageVO.setDeliveryTime(packageVO.getDeliveryTime()==null?null:DateUtil.format(packageVO.getDeliveryTime(), DateUtil.DEFAULT_DATETIME_FORMAT));
				 OpSoPackageDeliveryInfoVO deliveryInfoVO= packageVO.getOpSoPackageDeliveryInfoVO();
				 if(deliveryInfoVO!=null){
					 PackageDeliveryInfoVO deliveryInfo=new PackageDeliveryInfoVO();
					 BeanUtils.copyProperties(deliveryInfoVO, deliveryInfo);
					 
					 if(deliveryInfoVO.getDeliveryCode()!=null && deliveryInfoVO.getExpressType()!=null){
                         if(deliveryInfoVO.getExpressType()==8 || deliveryInfoVO.getExpressType()==9) {
                             //自送 或 中通 物流状态查询
                             orderPackageVO.setOrderLogisticVO(getOrderLogisticVO(deliveryInfo));
                         }else {
                             Integer type = 2;
                             if (deliveryInfoVO.getExpressType() == 3 || deliveryInfoVO.getExpressType() == 4 || deliveryInfoVO.getExpressType() == 7) {
                                 type = 2;
                             }

                             if (deliveryInfoVO.getExpressType() == 2) {
                                 type = 1;
                             }

                             // 物流状态
                             ResponseVO responseVO = poInstance.searchLogistic(deliveryInfoVO.getDeliveryCode(), type);
                             if (responseVO.getMeta().getErrno() == 0) {
                                 if (responseVO.getResult().getData() != null) {

                                     LogisticVO logisticVO = (LogisticVO) responseVO.getResult().getData();
                                     OrderLogisticVO orderLlogisticVO = new OrderLogisticVO();

                                     if (CollectionUtils.isNotEmpty(logisticVO.getActivities())) {
                                         List<OrderLogisticActivityVO> activitles = new ArrayList<OrderLogisticActivityVO>();
                                         OrderLogisticActivityVO orderLogisticActivityVO = null;
                                         for (LogisticActivityVO lg : logisticVO.getActivities()) {
                                             orderLogisticActivityVO = new OrderLogisticActivityVO();
                                             orderLogisticActivityVO.setAddress(lg.getAddress());
                                             orderLogisticActivityVO.setDatetime(lg.getDatetime());
                                             orderLogisticActivityVO.setDetails(lg.getDetails());
                                             orderLogisticActivityVO.setScan(lg.getScan());
                                             activitles.add(orderLogisticActivityVO);
                                         }

                                         // 倒序
                                         Collections.reverse(activitles);
                                         orderLlogisticVO.setActivities(activitles);

                                     }

                                     orderPackageVO.setOrderLogisticVO(orderLlogisticVO);
                                 }

                             }
                         }
					 }
					 
					 
					 orderPackageVO.setDeliveryInfo(deliveryInfo);
				 }
				 List<OpSoPackageSkuVO> packageSkus= packageVO.getOpSoPackageSkuVOs();
				 if(CollectionUtils.isNotEmpty(packageSkus)){
					 List<OrderSkuVO> orderSkus=new ArrayList<OrderSkuVO>();
					 
					 BigDecimal packageTotalDiscount = BigDecimal.ZERO;
					 
					 for(OpSoPackageSkuVO packageSKuVO:packageSkus){

							// 计算包裹总折扣
							packageTotalDiscount=packageTotalDiscount.add(packageSKuVO.getTotalDiscount());
							
							//判断当前商品是不是组合商品
							if(packageSKuVO.getProductId()!=null && packageSKuVO.getProductId()>0){
								  
								OrderSkuVO orderSKuVO = map.get(packageSKuVO.getProductId()+""+packageSKuVO.getSpvId());
								
								if(orderSKuVO ==null){
									orderSKuVO = new OrderSkuVO();
								
									// 存放规格
									PsSpvVO psSpvVo = spvMap.get(packageSKuVO.getSpvId());
									//int quantity = 1;
									
									if(psSpvVo!=null){
										
										if(CollectionUtils.isNotEmpty(psSpvVo.getAttributeValuePairList())){
											for(PsAttributeValuePairVO bean:psSpvVo.getAttributeValuePairList()){
												GroupProdSKu sku = new GroupProdSKu();
												sku.setSkuDescribe(bean.getAttrName()+":"+bean.getValue());
												orderSKuVO.getGroupProdSKuList().add(sku);
											}

										}
			
									}

									orderSKuVO.setCancleQuantity(0);
									orderSKuVO.setQuantity(packageSKuVO.getProdQuantity());
									
			
									orderSKuVO.setUnitPrice(packageSKuVO.getTotalPrice().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()),2, RoundingMode.HALF_UP).doubleValue());
									

									orderSKuVO.setUnitPriceAfterDiscount(packageSKuVO.getTotalPriceAfterApt().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()), 2,RoundingMode.HALF_UP).doubleValue());
									
									PsProductVO productVO = prodMap.get(String.valueOf(packageSKuVO.getProductId()));
									
									PsSkuVO  psSku = skuMap.get(packageSKuVO.getSkuCode());
									if(null!=productVO){
									  if(CollectionUtils.isEmpty(productVO.getSkuCodes()) && productVO.getSkuCodes().size()>1){
										  orderSKuVO.setShowSkuCode(productVO.getCode());
									  }
									  orderSKuVO.setSkuCode(productVO.getCode());
									  orderSKuVO.setShowSkuCode(productVO.getCode());
									  orderSKuVO.setProductCode(productVO.getCode());
									  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
									  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
									  if(!CollectionUtils.isEmpty(productVO.getBrands())){
										  orderSKuVO.setBrandName(productVO.getBrands().get(0).getBrandNameCN());
									  }
									 
									
									}

									orderSKuVO.setCrossBorderFlag(packageSKuVO.getCrossBorderFlag());

									map.put(packageSKuVO.getProductId()+""+packageSKuVO.getSpvId(), orderSKuVO);
									orderSkus.add(orderSKuVO);
								}else{
									Double unitPrice = packageSKuVO.getTotalPrice().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()),2, RoundingMode.HALF_UP).doubleValue();
									unitPrice = unitPrice + orderSKuVO.getUnitPrice();
									
									orderSKuVO.setUnitPrice(unitPrice);

									Double unitPriceAfterDiscount = orderSKuVO.getUnitPriceAfterDiscount();
									unitPriceAfterDiscount = unitPriceAfterDiscount+packageSKuVO.getTotalPriceAfterApt().divide(BigDecimal.valueOf(orderSKuVO.getQuantity()), 2,RoundingMode.HALF_UP).doubleValue();

									orderSKuVO.setUnitPriceAfterDiscount(unitPriceAfterDiscount);
								}
								
							}else{
								OrderSkuVO orderSKuVO=new OrderSkuVO();
							    orderSKuVO.setCancleQuantity(packageSKuVO.getCancleQuantity());
								orderSKuVO.setQuantity(packageSKuVO.getQuantity());
								orderSKuVO.setSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setShowSkuCode(packageSKuVO.getSkuCode());
								orderSKuVO.setUnitPrice(packageSKuVO.getUnitPrice()==null?0:packageSKuVO.getUnitPrice().doubleValue());
								
								if(packageSKuVO.getAptUCouponDiscountAmount()==null){
									packageSKuVO.setAptUCouponDiscountAmount(BigDecimal.ZERO);
								}
								
								//orderSKuVO.setUnitPriceAfterDiscount(packageSKuVO.getUnitPriceAfterDiscount().add(packageSKuVO.getAptUCouponDiscountAmount()).doubleValue());
								orderSKuVO.setUnitPriceAfterDiscount(packageSKuVO.getUnitPriceAfterDiscount().doubleValue());
								PsProductVO productVO=skuProdMap.get(packageSKuVO.getSkuCode());
								PsSkuVO psSku = skuMap.get(packageSKuVO.getSkuCode());
								if(null!=productVO){
								  if(CollectionUtils.isEmpty(productVO.getSkuCodes()) && productVO.getSkuCodes().size()>1){
									  orderSKuVO.setShowSkuCode(productVO.getCode());
								  }
								  orderSKuVO.setProductCode(productVO.getCode());
								  orderSKuVO.setImgUrl(imageUrl(productVO.getPicThumb()));
								  orderSKuVO.setSkuTitle(psSku.getSkuNameCN());
								}
								
								
								if(null!=psSku){
								  orderSKuVO.setBrandName(psSku.getBrandName());
								}
								
								
								orderSKuVO.setCrossBorderFlag(packageSKuVO.getCrossBorderFlag());
								orderSkus.add(orderSKuVO);
							}
							
							
					 }
					 orderPackageVO.setPackageTotalDiscount(packageTotalDiscount);
					 orderPackageVO.setOrderSkus(orderSkus);
				 }
				 
				 
				 packages.add(orderPackageVO);
			 }
			 detailVO.setPackages(packages);
		 }
		return detailVO;
	}

    private OrderLogisticVO getOrderLogisticVO(PackageDeliveryInfoVO deliveryInfoVO){
        Map<String,Object> params = new HashMap<String,Object>(2);
        params.put("deliveryCode", deliveryInfoVO.getDeliveryCode());
        params.put("expressType", deliveryInfoVO.getExpressType());
        List<OpExpressTrace> opExpressTraces=poInstance.queryOpExpressTraceByParams(params);
        if (opExpressTraces !=null && CollectionUtils.isNotEmpty(opExpressTraces)) {
            Collections.sort(opExpressTraces, new Comparator<OpExpressTrace>() {
                public int compare(OpExpressTrace t1, OpExpressTrace t2) {
                    return t2.getDateTime().compareTo(t1.getDateTime());
                }
            });
            OrderLogisticVO orderLogisticVO =new OrderLogisticVO();
            List<OrderLogisticActivityVO> activities=new ArrayList<>();
            OrderLogisticActivityVO orderLogisticActivityVO;
            for(OpExpressTrace trace:opExpressTraces){
                orderLogisticActivityVO = new OrderLogisticActivityVO();
                orderLogisticActivityVO.setAddress(trace.getAddress());
                orderLogisticActivityVO.setDatetime(trace.getDateTime());
                orderLogisticActivityVO.setDetails(trace.getDetails());
                orderLogisticActivityVO.setScan(trace.getScan());
                activities.add(orderLogisticActivityVO);
            }
            orderLogisticVO.setActivities(activities);
            return orderLogisticVO;
        }
        return  null;
    }

//	private String getPackageStatusDesc(OpSoPackageVO packageVO){
//		List<Map<String, String>>  statusList=OpSoPackage.getAllPackageStatus();
//		if(CollectionUtils.isNotEmpty(statusList)){
//			for(Map<String, String> mp:statusList){
//				if(String.valueOf(packageVO.getPackageStatus()).equals(mp.get("value"))){
//					return mp.get("text");
//				}
//			}
//		}
//		return "";
//	}
	
	private String getPackageStatusDesc(Integer orderStatus,Integer status){
		String packageStatusDesc="";
		if(orderStatus ==OpSalesOrder.ORDER_STATUS_WAITING_REVIEW){
			packageStatusDesc = "接单成功";
		}
		if(status==OpSoPackage.PACKAGE_STATUS_UNSENT_CANCEL){
			packageStatusDesc = "";
		}else if(status ==OpSoPackage.PACKAGE_STATUS_WAITING_MAKE ){
			packageStatusDesc = "订单已审核，等待商品打包";
		}else if(status ==OpSoPackage.PACKAGE_STATUS_WAITING_SEND ){
			packageStatusDesc = "订单已审核，等待商品打包";
		}else if(status == OpSoPackage.PACKAGE_STATUS_ALREADY_OUT){
			packageStatusDesc = "商品已打包，等待快递取货";
		}else if(status == OpSoPackage.PACKAGE_STATUS_ALREADY_RECEIVE){
			packageStatusDesc = "已收货";
		}
		
		
		return packageStatusDesc;
	}
	
	/***
	 * 根据通用的订单对象。封装成接口参数
	 * 
	 * @param opSoPackageSkuVO
	 * @return OrderQueryVO
	 */
	public OrderLineVO common2website(OpSoPackageSkuVO opSoPackageSkuVO,String channelCode) {
		OrderLineVO orderLineVO = new OrderLineVO();
		PsProductVO productVO=mcPsProductService.findProdByChnCodeSkuCode(channelCode,opSoPackageSkuVO.getSkuCode());
		if(productVO!=null){
			String [] product_id = new String[2];
			orderLineVO.setImgUrl(imageUrl(productVO.getPicThumb()));
			orderLineVO.setProductName(productVO.getNameCn());
			product_id[0]=productVO.getId();
			product_id[1]=productVO.getNameCn();
			orderLineVO.setProductId(product_id);
		}
		orderLineVO.setPointPrice(opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue());
		orderLineVO.setPointValue(opSoPackageSkuVO.getUnitPoint().doubleValue());
		orderLineVO.setPriceSubtotal(opSoPackageSkuVO.getUnitPrice().subtract(opSoPackageSkuVO.getUnitDiscount()).subtract(opSoPackageSkuVO.getUnitPointDeduction()).doubleValue()*opSoPackageSkuVO.getQuantity());
		orderLineVO.setPriceUnit(opSoPackageSkuVO.getUnitPrice().doubleValue());
		

		orderLineVO.setProductUomQty(opSoPackageSkuVO.getQuantity());
		orderLineVO.setSku(opSoPackageSkuVO.getSkuCode());
		
		return orderLineVO;
	}
	
	public String imageUrl(String imageUrl){
		String url=imageUrl;
		if(!StringUtils.isBlank(imageUrl)){
			
			if(imageUrl.indexOf("http://")>=0){
				url=imageUrl;
			}else{
				//url="http://oss.thebeastshop.com/"+imageUrl;
				url="http://img.thebeastshop.com/"+imageUrl;
			}
			
		}
		
		return url;
	}
	/***
	 * 外部订单为通用订单对象
	 * 
	 * @param orderCreateVO
	 */
	@Deprecated
//	public OpSalesOrderVO website2Common(OrderCreateVO orderCreateVO) {
//		//订单VO
//		OpSalesOrderVO opSalesOrderVO = new OpSalesOrderVO();
//		//包裹VO
//		List<OpSoPackageVO> opSoPackageVOs=new ArrayList<OpSoPackageVO>();
//		//官网默认是一个包裹
//		OpSoPackageVO opSoPackage=new OpSoPackageVO();
//		//包裹地址信息
//		OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO=new OpSoPackageDeliveryInfoVO();
//		//包裹sku信息
//		List<OpSoPackageSkuVO> opSoPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>();
//		//OpMemberVO memberVo=null;
//		//if(!orderCreateVO.getAnonymous()){
//		MemberVO	memberVo = memberQueryService.getById(orderCreateVO.getCustomerId());
//		//}
//		//配送仓
//		OpChannelVO opChannel = mcOpChannelService.findByCode(orderCreateVO.getChannelCode());
//		if (opChannel != null) {
//			opSoPackage.setDispatchWarehouseCode(opChannel.getWarehouseForSales());
//		}
//		
//		OrderPreCheck(orderCreateVO.getChannelCode(),orderCreateVO,opChannel);//下单之前的预判 校验价格 校验库存 校验是否下架
//		// @auhtor lijing start
//		//是否需要发票
//		opSalesOrderVO.setNeedInvoice(orderCreateVO.getNeedInvoice());
//		if(orderCreateVO.getIsInvoiceInSamePackage() == null) {
//			opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//		}else{
//			opSalesOrderVO.setIsInvoiceInSamePackage(orderCreateVO.getIsInvoiceInSamePackage());
//		}
//		//判断发票是否同货物发送
//		//设置发票
//		if(orderCreateVO.getNeedInvoice() != null && orderCreateVO.getNeedInvoice() == OrderCreateVO.NEED_INVOICE_TRUE){
//			logger.info("设置发票 orderCreateVO.getSoInvoiceInfoVO={}",orderCreateVO.getSoInvoiceInfoVO());
//			OpSoInvoiceInfoVO opSoInvoiceInfo = new OpSoInvoiceInfoVO();
//			SoInvoiceInfoVO soInvoiceInfoVO = orderCreateVO.getSoInvoiceInfoVO();
//			if(soInvoiceInfoVO != null){
//				logger.info("设置发票 ");
//				opSoInvoiceInfo.setInnerRemark(soInvoiceInfoVO.getInnerRemark());
//				opSoInvoiceInfo.setAddress(soInvoiceInfoVO.getAddress());
//				opSoInvoiceInfo.setDistrictId(soInvoiceInfoVO.getDistrictId());
//				opSoInvoiceInfo.setInvoiceType(soInvoiceInfoVO.getInvoiceType());
//				opSoInvoiceInfo.setInvoiceTitle(soInvoiceInfoVO.getInvoiceTitle());
//				opSoInvoiceInfo.setInvoiceAmount(soInvoiceInfoVO.getInvoiceAmount());
//				opSoInvoiceInfo.setReceiver(soInvoiceInfoVO.getReceiver());
//				opSoInvoiceInfo.setReceiverPhone(soInvoiceInfoVO.getReceiverPhone());
//				opSoInvoiceInfo.setInvoiceStatus(soInvoiceInfoVO.getInvoiceStatus());
//				opSoInvoiceInfo.setApplyTime(soInvoiceInfoVO.getApplyTime());
//				opSoInvoiceInfo.setApplyOperatorId(soInvoiceInfoVO.getApplyOperatorId());
//				opSoInvoiceInfo.setApplyOperatorName(soInvoiceInfoVO.getApplyOperatorName());
//				opSoInvoiceInfo.setIsEmergency(soInvoiceInfoVO.getIsEmergency());
//				opSalesOrderVO.setSoInvoiceInfoVO(opSoInvoiceInfo);
//			}
//		}
//		// @auhtor lijing end
//		// 订单来源渠道编码
//		opSalesOrderVO.setChannelCode(orderCreateVO.getChannelCode());
//		opSalesOrderVO.setOuterOrderCode(orderCreateVO.getOuterOrderCode());//外部渠道订单号
//		//会员id
//		//if(!orderCreateVO.getAnonymous()){
//		if(memberVo!=null){
//			opSalesOrderVO.setMemberId(memberVo.getId());
//			// 会员code
//			opSalesOrderVO.setMemberCode(memberVo.getCode());	
//		}
//
//		//}
//		// 卡片类型，0不需要1空白2代写
//		opSoPackage.setCardType(orderCreateVO.getNoteCard());
//		// 卡片内容
//		opSoPackage.setCardContent(orderCreateVO.getNoteCardMessage());
//		//配送方式
//		opSoPackage.setDeliveryType(orderCreateVO.getDeliveryType());
//		//限时配送
//		opSoPackage.setLimitDeliveryTimeDesc(orderCreateVO.getLimitedHour());
//		//期望收货时间
//		if(StringUtils.isNotBlank(orderCreateVO.getDeliveryDate())){
//			opSoPackage.setExpectReceiveDate(DateUtil.parse(orderCreateVO.getDeliveryDate(), DateUtil.DEFAULT_DATE_FORMAT));
//		}else{
//			opSoPackage.setPlanedDeliveryDate(new Date());
//		}
//		
//		// ztq 20160505 身份证信息保存 start
//		if (orderCreateVO.getCrossBorderFlag()!=null && orderCreateVO.getCrossBorderFlag() == 1) {
//
//			//opSalesOrderVO.setCrossFree(orderCreateVO.getCrossFree());
//			opSalesOrderVO.setCrossBorderFlag(orderCreateVO.getCrossBorderFlag());
//			if (orderCreateVO.getIdCardVO() != null) {
//
//				OpIdCardVO opIdCardVO = new OpIdCardVO();
//
//				opIdCardVO.setBackCardPhoto(orderCreateVO.getIdCardVO()
//						.getBackCardPhoto());
//				opIdCardVO.setFrontCardPhoto(orderCreateVO.getIdCardVO()
//						.getFrontCardPhoto());
//				opIdCardVO.setIdNumber(orderCreateVO.getIdCardVO()
//						.getIdNumber());
//				opIdCardVO.setName(orderCreateVO.getIdCardVO().getName());
//				
//				// 判断身份证照片是否存在，如果两张照片都存在状态设为2，如果任何一张或两张不存在时去查询是否有其它订单上传过同身份证照片
//				if(StringUtils.isBlank(orderCreateVO.getIdCardVO().getBackCardPhoto()) || StringUtils.isBlank(orderCreateVO.getIdCardVO().getFrontCardPhoto())){
//
//					// 判断其它订单是否有相同的身份证号
//                	List<OpSaleOrderIdentityVO> list = pcInstance.findOrderIdentityByMember(opSalesOrderVO.getMemberCode(), opIdCardVO.getName(), opIdCardVO.getIdNumber());
//                	if(CollectionUtils.isEmpty(list)){
//                		 opIdCardVO.setAuditStatus(0);
//                	}else{
//                		
//                		OpSaleOrderIdentityVO vo = list.get(0);
//                        opIdCardVO.setBackCardPhoto(vo.getImgBack());
//                        opIdCardVO.setFrontCardPhoto(vo.getImgFront());
//                        opIdCardVO.setAuditStatus(vo.getAuditStatus());
//                	}
//					
//				}else{
//					opIdCardVO.setAuditStatus(2);
//				}
//				
//				opSalesOrderVO.setOpIdCardVO(opIdCardVO);
//			}
//
//		} else {
//			opSalesOrderVO.setCrossBorderFlag(0);
//			opSalesOrderVO.setCrossFree(BigDecimal.ZERO);
//		}
//		// ztq 20160505 身份证信息保存 end
//		
//		//预期发货时间
//		
//		//设置配送地址
//		AddressVO address=orderCreateVO.getDeliveryAddress();
//		//详细地址
//		opSoPackageDeliveryInfoVO.setAddress(address.getStreet());
//		//环线
//		opSoPackageDeliveryInfoVO.setCircuitDesc(address.getCircuit());
//		//公司名称
//		opSoPackageDeliveryInfoVO.setCompanyName(address.getCompanyName());
//		//收货的区县ID
//		opSoPackageDeliveryInfoVO.setDistrictId(address.getDistrictId());
//		//收件人
//		opSoPackageDeliveryInfoVO.setReceiver(address.getName());
//		//邮编
//		opSoPackageDeliveryInfoVO.setZipCode(address.getZip());
//		//称谓
//		opSoPackageDeliveryInfoVO.setTitle(address.getMagentoTitle());
//		//收件人电话
//		opSoPackageDeliveryInfoVO.setReceiverPhone(address.getPhone());
//		//订单行
//		List<OrderCreateDetailVO> orderCreateDetails=orderCreateVO.getItems();
//		//配送方式，判断是否需要强制审单
//		Map<String,Boolean> deliveryTypes=new HashMap<String,Boolean>();
//		for(OrderCreateDetailVO detail:orderCreateDetails){
//				OpSoPackageSkuVO packageSku=new OpSoPackageSkuVO();
//				
//				PsProductVO productVO = null;
//				if(opChannel!=null && opChannel.getChannelType()!=null && opChannel.getChannelType()==1){
//					 productVO=mcPsProductService.findProdBySkuCode(detail.getSku());
//				}else{
//					 productVO=mcPsProductService.findProdByChnCodeSkuCode(orderCreateVO.getChannelCode(),detail.getSku());
//					if(null==productVO){
//						throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),"商品已下架 "+detail.getSku());
//					}
//				}
//
//				// 海淘产品需要毛重和税号
////				if(detail.getCrossBorderFlag()!=null && detail.getCrossBorderFlag() ==1){
////					PsSkuVO skuVO=pbInstance.findSkuByCode(detail.getSku());
////					
////					packageSku.setWeight(skuVO.getWeight());
////					packageSku.setTaxNo(skuVO.getTaxNo());
////				}
//
//				// 跨境购标注 0普通１跨境购
//				packageSku.setCrossBorderFlag(detail.getCrossBorderFlag());
//				
//				packageSku.setAddBy(OpSoPackageSku.ADDBY_MEMBER);//默认会员添加
//				packageSku.setSkuCode(detail.getSku());
//				//coupon使用
//				packageSku.setBrandId(detail.getBrandId());
//				packageSku.setCategroyId(detail.getCategroyId());
//				//TODO
//				packageSku.setIsJit(detail.getIsJit());//是否来单制作
//				packageSku.setQuantity(detail.getQuantity());//数量
//				if(detail.getPointValue()==null){
//					packageSku.setUnitPoint(BigDecimal.ZERO);//单品积分
//				}else{
//					packageSku.setUnitPoint(BigDecimal.valueOf(detail.getPointValue()));//单品积分
//				}
//				//判断是否包含两种以上配送方式，如果是，则需要强制审单
//				if(OpProduct.EP_TYPE_SELF==productVO.getExpressType()){
//					deliveryTypes.put("SELF", true);
//				}else if(OpProduct.EP_TYPE_FED==productVO.getExpressType()){
//					deliveryTypes.put("FEDX24", true);
//				}else if(OpProduct.EP_TYPE_Sf_AIR==productVO.getExpressType()){
//					deliveryTypes.put("SF_AIR", true);
//				}else if(OpProduct.EP_TYPE_Sf_LAND==productVO.getExpressType()){
//					deliveryTypes.put("SF_LAND", true);
//				}else if(OpProduct.EP_TYPE_YTO ==productVO.getExpressType()){//圆通
//					deliveryTypes.put("YTO", true);
//				}else if(OpProduct.EP_TYPE_DEPPON ==productVO.getExpressType()){
//					deliveryTypes.put("DEPPON", true);
//				}
//				
//				
//				// 特价
//				if(detail.getDiscountPrice()==null){
//					detail.setDiscountPrice(0D);
//				}
//				if(productVO.getAllowVipDiscount()==1){//官网计算价格，不判断是否匿名购买
//			        if(memberVo==null){
//						
//					    if(detail.getDiscountPrice()>0){
//							BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//							packageSku.setUnitDiscount(unitDiscount);
//						}else{
//							packageSku.setUnitDiscount(BigDecimal.ZERO);
//						}
//					}else{
//						packageSku.setUnitDiscount(getUnitDiscount(BigDecimal.valueOf(detail.getPrice()), memberVo.getMemberLevel(),orderCreateVO.getPresentCards(),BigDecimal.valueOf(detail.getDiscountPrice())));//单品折扣
//
//					}
//			     }else{
//				     if(detail.getDiscountPrice()>0){
//						BigDecimal unitDiscount = BigDecimal.valueOf(detail.getPrice()).subtract(BigDecimal.valueOf(detail.getDiscountPrice()));
//						packageSku.setUnitDiscount(unitDiscount);
//					 }else{
//						packageSku.setUnitDiscount(BigDecimal.ZERO);
//					 }
//				}
//				
//				// 折扣后金额
//				packageSku.setUnitAmountAfterDiscount(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()));
//				// 特价
//				packageSku.setDiscountPrice(BigDecimal.valueOf(detail.getDiscountPrice()));
//				
//				if(detail.getPointPrice()!=null){
//					packageSku.setUnitPointDeduction(BigDecimal.valueOf(detail.getPrice()).subtract(packageSku.getUnitDiscount()).subtract(BigDecimal.valueOf(detail.getPointPrice())));//折扣后的价格减去积分价格
//				}else{
//					packageSku.setUnitPointDeduction(BigDecimal.ZERO);
//				}
//				packageSku.setUnitPrice(BigDecimal.valueOf(detail.getPrice()));
//				//TODO 是否赠品，0否1是
//				packageSku.setIsGift(0);
//				opSoPackageSkuVOs.add(packageSku);
//		}
//		
//		// 发票是否随同货物发送，0否1是
//		opSalesOrderVO.setIsInvoiceInSamePackage(OpSalesOrder.IS_INVOICE_IN_SAME_PACKAGE_FALSE);
//		
//		boolean CHN2018Jit = false;
//		if("CHN2018".equals(opSalesOrderVO.getChannelCode())&&EmptyUtil.isNotEmpty(opSoPackageSkuVOs)){
//			for(OpSoPackageSkuVO pack : opSoPackageSkuVOs){
//				if("1".equals(pack.getIsJit())){
//					CHN2018Jit = true;
//					break;
//				}
//			}
//		}
//		//判断是否是官网渠道且sku是来单制作
//		//是否审单,有两种不同的运输方式或者有自送的。需要审单
//		if(deliveryTypes.size()>1||(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")) || CHN2018Jit){
//		   opSalesOrderVO.setIsForceAudit(PegasusConstants.YES);
//		}else{
//		  opSalesOrderVO.setIsForceAudit(PegasusConstants.NO);
//		}
//		//设置配送信息的快递方式，当只有一种配送方式时，设置
//		if(deliveryTypes!=null&&deliveryTypes.size()==1){
//			if(deliveryTypes.get("SELF")!=null&&deliveryTypes.get("SELF")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SHOP);
//			}else if(deliveryTypes.get("FEDX24")!=null&&deliveryTypes.get("FEDX24")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_FEDEX);
//			}else if(deliveryTypes.get("SF_AIR")!=null&&deliveryTypes.get("SF_AIR")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_AIR);
//			}else if(deliveryTypes.get("SF_LAND")!=null&&deliveryTypes.get("SF_LAND")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_SF_LAND);
//			}else if(deliveryTypes.get("YTO")!=null&&deliveryTypes.get("YTO")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_YTO);
//			}else if(deliveryTypes.get("DEPPON")!=null&&deliveryTypes.get("DEPPON")){
//				opSoPackageDeliveryInfoVO.setExpressType(OpSoPackageDeliveryInfo.EXPRESS_TYPE_DEPPON);
//			}
//		}
//		
//		opSoPackage.setOpSoPackageSkuVOs(opSoPackageSkuVOs);
//		
//		//设置包裹配送信息
//		opSoPackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//		opSoPackageVOs.add(opSoPackage);
//		//设置订单关联包裹
//		opSalesOrderVO.setOpSoPackageVOs(opSoPackageVOs);
//		
////		if(orderCreateVO.getServiceFee()!=null){
////			//服务费
////			opSalesOrderVO.setServiceFeeAmount(BigDecimal.valueOf(orderCreateVO.getServiceFee()));
////		}else{
////			//服务费
////			opSalesOrderVO.setServiceFeeAmount(BigDecimal.ZERO);
////		}
//
//		// 用户备注
//		opSalesOrderVO.setRemark(orderCreateVO.getNote());
//		// 内部备注
//		opSalesOrderVO.setInnerRemark(orderCreateVO.getInnerRemark());
//		//设置订单来源 refer
//		opSalesOrderVO.setRefer(orderCreateVO.getRefer());
//		// 订单类型，1渠道销售单2渠道退货单3渠道换货单4集团订单11礼品订单12样品订单
//		opSalesOrderVO.setSalesOrderType(OpSalesOrder.ORDER_TYPE_SALES);
//		// COUPON编码
//		opSalesOrderVO.setCouponCode(orderCreateVO.getCouponCode());
//		if(orderCreateVO.getOtherDiscount()!=null){
//			//头折扣
//			opSalesOrderVO.setDiscountOnHead(BigDecimal.valueOf(orderCreateVO.getOtherDiscount()));
//		}else{
//			//头折扣
//			opSalesOrderVO.setDiscountOnHead(BigDecimal.ZERO);
//		}
//
//		//礼品卡
//		opSalesOrderVO.setGiftCardDesc(orderCreateVO.getPresentCards());
//		//礼品卡金额
//		if(orderCreateVO.getCardFeeDiscount()!=null){
//			opSalesOrderVO.setGiftCardAmount(BigDecimal.valueOf(orderCreateVO.getCardFeeDiscount()));
//		}else{
//			opSalesOrderVO.setGiftCardAmount(BigDecimal.ZERO);
//		}
//		//是否匿名
//		opSalesOrderVO.setIsAnonymous(orderCreateVO.getAnonymous()?OpSalesOrder.IS_ANONYMOUS_TRUE:OpSalesOrder.IS_ANONYMOUS_FALSE);
//		//预售拆包裹  TODO
//		List<OpSoPackageVO> splitPackages= splitPackageNew(opSalesOrderVO, opChannel);
//		if(CollectionUtils.isNotEmpty(splitPackages)){
//			opSalesOrderVO.setOpSoPackageVOs(splitPackages);
//		}
//		 return opSalesOrderVO;
//	 }

		

	
	
	/***
	 * 根据用户等级。计算单价折扣
	 * @param unitPrice
	 * @param memberLevel
	 */
	private BigDecimal getUnitDiscount(BigDecimal unitPrice,Integer memberLevel,String giftCard,BigDecimal salePrice){
//		if(StringUtils.isNotBlank(giftCard)){
//			return BigDecimal.ZERO;//使用礼品卡不打折
//		}
//		BigDecimal discountPrice=PriceUtil.getLevelPrice(unitPrice, memberLevel);
//		return unitPrice.subtract(discountPrice);
		
		BigDecimal unitDiscount=BigDecimal.ZERO;
		if(StringUtils.isNotBlank(giftCard)){
		    if(salePrice.doubleValue()>0){
					// 特价折扣
				unitDiscount = unitPrice.subtract(salePrice);
					
				return unitDiscount;
			}else{
			    return BigDecimal.ZERO;//礼品卡不打折
			}
		}
		
		if(salePrice.doubleValue()>0){
			BigDecimal discountPrice= PriceUtil.getLevelPrice(salePrice, memberLevel);
			// 特价折扣+会员折扣
			unitDiscount = unitPrice.subtract(discountPrice);

		}else{
			BigDecimal discountPrice=PriceUtil.getLevelPrice(unitPrice, memberLevel);
			
			// 会员折扣
			unitDiscount=unitPrice.subtract(discountPrice);
		}
		
		return unitDiscount;
	}
	
	/***
	 * 下单前的校验，校验积分、校验价格是否变化,校验库存是否不足
	 * @param orderCreateVO
	 * @param opChannel
	 * @return
	 */
	private void  OrderPreCheck(String channelCode,OrderCreateVO orderCreateVO, OpChannelVO opChannel){
		List<OrderCreateDetailVO>  details=orderCreateVO.getItems();
		for(OrderCreateDetailVO detail:details){
			
			if(opChannel!=null && opChannel.getChannelType()!=null && opChannel.getChannelType()==1){
				// 线下渠道不验证
			}else{
				//判断商品是否可售
				PsProductVO prod=mcPsProductService.findProdByChnCodeSkuCode(channelCode, detail.getSku());
				if(prod==null||CollectionUtils.isEmpty(prod.getChnCanSaleSKu())||!prod.getCanSaleSku(channelCode).contains(detail.getSku())){
					throw new ChannelException(ErrorCode.ITEM_OFFSHELF.getCode(),ErrorCode.ITEM_OFFSHELF.getMesage()+": "+detail.getSku());
				}
			}
			
			PsSkuVO pssSkuVO=mcPsSkuService.findBySkuCode(detail.getSku());
			detail.setIsJit(pssSkuVO.getIsJit());//是否来单制作
			//设置分类id和品牌id coupon使用
			detail.setBrandId(pssSkuVO.getBrandId());
			detail.setCategroyId(pssSkuVO.getCategoryId());
			//检查价格是否发生变化
			if(PegasusConstants.YES!=detail.getIsGift()&&pssSkuVO.getSalesPrice().doubleValue()!=detail.getPrice().doubleValue()){
				throw new ChannelException(ErrorCode.ITEM_PRICE_CHANGE.getCode(), ErrorCode.ITEM_PRICE_CHANGE.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuName()+": "+pssSkuVO.getSalesPrice());
			}
			//JIT商品不校验库存
			if(detail.getIsJit()==null ||PegasusConstants.NO==detail.getIsJit()){
				//检查商品库存
				WhInvVO whInvVO=sWhInvService.findCanUseQttBySkuCodeAndWarehouseCode(detail.getSku(), opChannel.getWarehouseForSales());
				Integer quantity=whInvVO.getCanUseInv();
				//增加预售判断。先判断物理库存，再判断预售库存，返回的库存为两个值之和 added by fs 20151127
				final SPresaleSaleInvVO preSaleInvVO = sPresaleService.findCanUseQttBySkuCode(detail.getSku(), null);
				if(preSaleInvVO!=null){
					quantity=quantity+preSaleInvVO.getCanUseInv();
				}
				
				if(whInvVO==null||quantity<detail.getQuantity()){
					throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+pssSkuVO.getSkuCode()+" "+pssSkuVO.getSkuName()+": "+whInvVO.getSkuCode());
				}
			}
		}
	
	}
	
	/***
	 * 判断是否需要拆分包裹，
	 * @param opSalesOrderVO
	 * @param opChannel
	 * @return
	 */
//	@Deprecated
//	private List<OpSoPackageVO> splitPackage(OpSalesOrderVO opSalesOrderVO, OpChannelVO opChannel){
//		List<OpSoPackageVO> newPackageVOs=null;
//		OpSoPackageVO sourcesPackageVO=null;
//		List<OpSoPackageVO> sourcesPackages=null;
//		List<OpSoPackageSkuVO>  sourcePackageSkus=null;
//		if(opSalesOrderVO!=null&&CollectionUtils.isNotEmpty(opSalesOrderVO.getOpSoPackageVOs())&&opSalesOrderVO.getOpSoPackageVOs().size()==1){
//			newPackageVOs=new ArrayList<OpSoPackageVO>();
//			sourcesPackages=opSalesOrderVO.getOpSoPackageVOs();
//			sourcesPackageVO=sourcesPackages.get(0);
//			sourcePackageSkus=sourcesPackageVO.getOpSoPackageSkuVOs();
//			if(CollectionUtils.isNotEmpty(sourcePackageSkus)){
//				
//				List<OpSoPackageSkuVO>  crossSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();
//				for(OpSoPackageSkuVO  packageSkuVO:sourcePackageSkus){
//					
//					// ztq 20160505  海淘商品折包裹 start
//					if(packageSkuVO.getCrossBorderFlag()!=null && packageSkuVO.getCrossBorderFlag()==1){
//						
//						crossSalePackageSkus.add(packageSkuVO);
//						
//					}else{
//					// ztq 20160505  海淘商品折包裹 end
//						OpPresaleVO presaleVO=poInstance.findAvaliableBySkuCode(packageSkuVO.getSkuCode());
//						if(presaleVO!=null){
//							//有预售。再判断物理库存是否可卖。
//							//物理库存不足，则拆包裹，物理库存足够，则不拆包裹
//							WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(packageSkuVO.getSkuCode(), opChannel.getWarehouseForSales());
//							Integer quantity=whInvVO.getCanUseInv();
//							OpPresaleSaleInvVO preSaleInvVO=poInstance.findCanUseQttBySkuCode(packageSkuVO.getSkuCode(), null);
//							Integer preSaleQuantity=preSaleInvVO.getCanUseInv();
//							if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()<=preSaleQuantity){
//								OpSoPackageVO preSalePackage=new OpSoPackageVO();
//								preSalePackage.setCardContent(sourcesPackageVO.getCardContent());
//								preSalePackage.setCardType(sourcesPackageVO.getCardType());
//								preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//								preSalePackage.setDispatchWarehouseCode(presaleVO.getDispatchWarehouseCode());
//								preSalePackage.setPlanedDeliveryDate(presaleVO.getPlanedDeliveryDate());
//								preSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//	//							preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//								preSalePackage.setOpSoPackageDeliveryInfoVO(sourcesPackageVO.getOpSoPackageDeliveryInfoVO());
//								List<OpSoPackageSkuVO>  preSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();
//								packageSkuVO.setPresaleId(presaleVO.getId());
//								packageSkuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
//								preSalePackageSkus.add(packageSkuVO);
//								preSalePackage.setOpSoPackageSkuVOs(preSalePackageSkus);
//								newPackageVOs.add(preSalePackage);
//							}else if(packageSkuVO.getQuantity()>quantity&&packageSkuVO.getQuantity()>preSaleQuantity){
//								throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+packageSkuVO.getSkuCode()+": "+whInvVO.getSkuCode());
//							}
//						}
//				   }
//					
//				}
//				
//				if(CollectionUtils.isNotEmpty(crossSalePackageSkus)){
//					OpSoPackageVO crossSalePackage= new OpSoPackageVO();
//					crossSalePackage.setOpSoPackageSkuVOs(crossSalePackageSkus);
//					crossSalePackage.setCardContent(sourcesPackageVO.getCardContent());
//					crossSalePackage.setCardType(sourcesPackageVO.getCardType());
//					crossSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//					crossSalePackage.setDispatchWarehouseCode(sourcesPackageVO.getDispatchWarehouseCode());
//					crossSalePackage.setPlanedDeliveryDate(sourcesPackageVO.getPlanedDeliveryDate());
//					crossSalePackage.setDeliveryType(sourcesPackageVO.getDeliveryType());
//					// 海淘包裹
//					crossSalePackage.setCrossBorderFlag(1);
//					if(sourcesPackageVO.getOpSoPackageDeliveryInfoVO()!=null){
//						// 海淘包裹，设置7
//						sourcesPackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(7);
//					}
////						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//					crossSalePackage.setOpSoPackageDeliveryInfoVO(sourcesPackageVO.getOpSoPackageDeliveryInfoVO());
//					newPackageVOs.add(crossSalePackage);
//				}
//				
//			}
//		}else{
//			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//		if(CollectionUtils.isNotEmpty(newPackageVOs)){
//			for(OpSoPackageVO preSalePackage:newPackageVOs){
//				List<OpSoPackageSkuVO>  preSalePackageSkus= preSalePackage.getOpSoPackageSkuVOs();
//				if(CollectionUtils.isNotEmpty(preSalePackageSkus)){
//					sourcePackageSkus.removeAll(preSalePackageSkus);
//				}
//			}
//			sourcesPackages.addAll(newPackageVOs);
//		}
//		//删掉分包裹之后的空包裹
//		List<OpSoPackageVO> tmpPackages=new ArrayList<OpSoPackageVO>();
//		for(OpSoPackageVO tmppackage: sourcesPackages){
//			if(tmppackage==null||CollectionUtils.isEmpty(tmppackage.getOpSoPackageSkuVOs())){
//				tmpPackages.add(tmppackage);
//			}
//		}
//		if(CollectionUtils.isNotEmpty(tmpPackages)){
//			sourcesPackages.removeAll(tmpPackages);
//		}
//
//		return sourcesPackages;
//	}
		/***
	    普通商品放在一个单独的包裹
	1 合并包裹逻辑
	为了保证主品和赠品同时发货、下述情况系统将自动将主品和赠品进行包裹的处理
	① 主品（现货）+赠品（现货）
	包裹发货仓：[WH020600010102]元电路 – 官网渠道销售仓
	② 主品（预售）+赠品（现货）
	自动合并包裹
	包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
	预计发货时间：预售品的计划发货时间
	③ 主品（现货）+赠品（预售）
	赠品单独拆除包裹
	包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
	赠品包裹包裹预计发货时间：预售品的计划发货时间
	④ 主品（预售）+赠品（预售）
	a)主品预售预计发货时间<赠品预售预计发货时间: 拆 两个包裹
	包裹预计发货时间：各自预售的预计发货时间
	包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
	b)主品预售预计发货时间>赠品预售预计发货时间: 合并包裹
	包裹发货仓：[WH0206000101881]元电路 – 线上预售总仓
	包裹预计发货时间：主品预售预计发货时间
	
	/***
	* 判断是否需要拆分包裹，
	* @param opSalesOrderVO
	* @param opChannel
	* @return
	*/
//	private List<OpSoPackageVO> splitPackageNew(OpSalesOrderVO opSalesOrderVO, OpChannelVO opChannel){
//    final BigDecimal crossfinalFee=BigDecimal.valueOf(800);
//	List<OpSoPackageVO> allPackageVOs=new ArrayList<OpSoPackageVO>(4);//所有的包裹集合
//	List<OpSoPackageVO> preSalePackageVOs=new ArrayList<OpSoPackageVO>(2);//预售的商品
//	
//	List<OpSoPackageSkuVO> defaultPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//默认包裹的sku集合
//	
//	List<WhAllotRcdVO> whAllotList=new ArrayList<WhAllotRcdVO>(2);//待调拨列表 --一般是从正常销售仓 调拨到预售仓
//    // 海淘包裹集
//    final List<List<OpSoPackageSkuVO>> crossSalePackages= new ArrayList<>();
//    // 海淘总费用
//    BigDecimal crossPackageTotalFee = BigDecimal.ZERO;
//    
//	List<OpSoPackageVO> sourcesPackages=null;//初始包裹集合
//	sourcesPackages=opSalesOrderVO.getOpSoPackageVOs();
//	OpSoPackageVO  sourcePackageVO=null;//默认的包裹对象
//	
//    final OpSoPackageDeliveryInfoVO opSoPackageDeliveryInfoVO = sourcePackageVO.getOpSoPackageDeliveryInfoVO();
//    List<OpSoPackageSkuVO>  crossSalePackageSkus=new ArrayList<OpSoPackageSkuVO>();
//	//原始订单中 包裹集合只有一个
//	if(CollectionUtils.isNotEmpty(sourcesPackages)&&sourcesPackages.size()==1){
//		sourcePackageVO=sourcesPackages.get(0);
//		List<OpSoPackageSkuVO>  sourcePackageSkus=sourcePackageVO.getOpSoPackageSkuVOs();//为拆包裹之前 原始包裹中的sku集合
//		if(CollectionUtils.isNotEmpty(sourcePackageSkus)){
//			List<OpSoPackageSkuVO> noneGiftPackageSkuVOs=getAllNoneGiftPackageSkuVOs(opChannel,sourcePackageSkus);
//			List<OpSoPackageSkuVO> giftPackageSkuVOs=getAllGiftPackageSkuVOs(opChannel,sourcePackageSkus);
//			
//			
//	        // 海淘1000块标准拆单
//		    List<OpSoPackageSkuVO> crossSaleSkus = null;
//				
//			BigDecimal crossSkuFee = BigDecimal.ZERO;
//				
//			OpSoPackageSkuVO skuVOspit= null;
//			
//			boolean giftbool = false;
//
//	        
//			for(OpSoPackageSkuVO skuVO:noneGiftPackageSkuVOs){
//				
//				
//	            // ztq 20160517  海淘商品拆包裹 start
//	            if (skuVO.getCrossBorderFlag() != null
//	                    && skuVO.getCrossBorderFlag() == OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA) {
//	            	    
//	            	    BigDecimal skuFee = skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(skuVO.getQuantity()));
//	            		// 判断价格是否大于2000
//	            		if(skuFee.compareTo(crossfinalFee)<0){
//	            			crossSalePackageSkus.add(skuVO);
//	            			if(skuFee.add(crossPackageTotalFee).compareTo(crossfinalFee)<0){
//	            				// 计算海淘商品总价格
//	                    		crossPackageTotalFee = crossPackageTotalFee.add(skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(skuVO.getQuantity())));
//	            			}else{
//	                            crossSalePackages.add(crossSalePackageSkus);
//	                            crossSalePackageSkus = new ArrayList<>();
//	                            crossPackageTotalFee = skuFee;
//	            			}
//	                	
//	            		}else{
//	       
//	            			// 当同一商品购买多件时
//	            			if(skuVO.getQuantity()!=null && skuVO.getQuantity()>1){
//	            				
//	            				// 商品单价大于1000时
//	            				if(skuVO.getUnitAmountAfterDiscount().compareTo(crossfinalFee)>=0){
//	            					
//	            					for(int i=0;i<skuVO.getQuantity();i++){
//	            						crossSaleSkus = new ArrayList<>();
//	            						
//	            						if(i==0){
//	            							//判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//	            			                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//	            			                if (giftSkuVO != null) {
//	            			                    //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//	            			                    if (!isPresale(opChannel, giftSkuVO)) {
//	            			                    	crossSaleSkus.add(giftSkuVO);
//	            			                    	
//	            			                    } else {
//	            			                        //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//	            			                        final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//	            			                        preSalePackageSkuVOs.add(giftSkuVO);
//	            			                        final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//	            			                        preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//	            			                        preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//	            			                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//	            			                        final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//	            			                        preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//	            			                        preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////	            											preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//	            			                        preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//	            			                        preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//	            			                        preSalePackageVOs.add(preSalePackageVo);
//	            			                    }
//	            			                }
//	            							
//	            						}
//	            						
//	            						
//	            						skuVOspit = new OpSoPackageSkuVO();
//	        							BeanUtils.copyProperties(skuVO, skuVOspit);
//	        							skuVOspit.setQuantity(1);
//	        							crossSaleSkus.add(skuVOspit);
//	        							crossSalePackages.add(crossSaleSkus);
//	            						
//	            					}
//
//	            				}else{
//
//	            					int count=0;
//	            					for(int i=0;i<skuVO.getQuantity();i++){
//	            						// 判断赠品
//	            						if(i==0){
//	            							crossSaleSkus = new ArrayList<>();
//	            							giftbool = true;
//	            							//判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//	            			                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//	            			                if (giftSkuVO != null) {
//	            			                    //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//	            			                    if (!isPresale(opChannel, giftSkuVO)) {
//	            			                    	crossSaleSkus.add(giftSkuVO);
//	            			                    	
//	            			                    } else {
//	            			                        //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//	            			                        final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//	            			                        preSalePackageSkuVOs.add(giftSkuVO);
//	            			                        final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//	            			                        preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//	            			                        preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//	            			                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//	            			                        final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//	            			                        preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//	            			                        preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////	            											preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//	            			                        preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//	            			                        preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//	            			                        preSalePackageVOs.add(preSalePackageVo);
//	            			                    }
//	            			                }
//	            						}
//	            						
//	            						count++;
//	            						crossSkuFee = skuVO.getUnitAmountAfterDiscount().multiply(BigDecimal.valueOf(count));
//	   
//	            						// 大于1000时生成一个包裹
//	            						if(crossSkuFee.compareTo(crossfinalFee)>=0){
//	            							if(!giftbool){
//	            								crossSaleSkus = new ArrayList<>();
//	            							}
//	            							
//	            							skuVOspit = new OpSoPackageSkuVO();
//	            							BeanUtils.copyProperties(skuVO, skuVOspit);
//	            							skuVOspit.setQuantity(count-1);
//	            							crossSaleSkus.add(skuVOspit);
//	            							crossSalePackages.add(crossSaleSkus);
//	            							giftbool=false;
//	            							count = 0;
//	                                        i = i - 1;
//	            						}else{
//	            							// 最后一个商品
//	            							if(i==skuVO.getQuantity()-1){
//	            								if(!giftbool){
//	                								crossSaleSkus = new ArrayList<>();
//	                							}
//	            								crossSaleSkus = new ArrayList<>();
//	            								skuVOspit = new OpSoPackageSkuVO();
//	                							BeanUtils.copyProperties(skuVO, skuVOspit);
//	                							skuVOspit.setQuantity(count);
//	                							crossSaleSkus.add(skuVOspit);
//	                							crossSalePackages.add(crossSaleSkus);
//	                							giftbool=false;
//	            								
//	            							}
//	            						}
//	            						
//	            							
//	            						}
//	            					}
//	            					
//	            				
//	            				
//	            				// crossSalePackageSkus = new ArrayList<>();
//	            				// crossPackageTotalFee = BigDecimal.ZERO;
//	            				 
//	            				 continue;
//	            			}else{
//	            				crossSaleSkus = new ArrayList<>();
//	            				crossSaleSkus.add(skuVO);
//	                            crossSalePackages.add(crossSaleSkus);
//
//	            			}
//	            			
//
//	            		}
//	       		
//	                //判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//	                final OpSoPackageSkuVO giftSkuVO = getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//	                if (giftSkuVO != null) {
//	                    //如果带赠品，但是主品不预售，赠品也不预售，则赠品和主品在一个包裹
//	                    if (!isPresale(opChannel, giftSkuVO)) {
//	                        crossSalePackageSkus.add(giftSkuVO);
//	                    } else {
//	                        //如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//	                        final List<OpSoPackageSkuVO> preSalePackageSkuVOs = new ArrayList<>(2);//预售的包裹sku集合
//	                        preSalePackageSkuVOs.add(giftSkuVO);
//	                        final OpSoPackageVO preSalePackageVo = new OpSoPackageVO();//预售的包裹
//	                        preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//	                        preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//	                        preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//	                        final OpPresaleVO presellVO = giftSkuVO.getPresaleVO();
//	                        preSalePackageVo.setDispatchWarehouseCode(presellVO.getDispatchWarehouseCode());
//	                        preSalePackageVo.setPlanedDeliveryDate(presellVO.getPlanedDeliveryDate());
////									preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//	                        preSalePackageVo.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//	                        preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//	                        preSalePackageVOs.add(preSalePackageVo);
//	                    }
//	                }
//
//	                continue;
//	            }
//
//				//非赠品，并且不是预售
//				if(!isPresale(opChannel, skuVO)){
//					defaultPackageSkuVOs.add(skuVO);
//					//判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//					OpSoPackageSkuVO  giftSkuVO=getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//					if(giftSkuVO!=null){
//						//如果带赠品，但是主品不预售，赠品也不预售，则赠品和主平在一个包裹
//						if(!isPresale(opChannel, giftSkuVO)){
//							defaultPackageSkuVOs.add(giftSkuVO);
//						}else{
//							//如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//						    List<OpSoPackageSkuVO> preSalePackageSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//预售的包裹sku集合
//						    preSalePackageSkuVOs.add(giftSkuVO);
//							OpSoPackageVO preSalePackageVo=new OpSoPackageVO();//预售的包裹
//							preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//							preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//							preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//							preSalePackageVo.setDispatchWarehouseCode(giftSkuVO.getPresaleVO().getDispatchWarehouseCode());
//							preSalePackageVo.setPlanedDeliveryDate(giftSkuVO.getPresaleVO().getPlanedDeliveryDate());
//							preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//	//						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//							preSalePackageVo.setOpSoPackageDeliveryInfoVO(sourcePackageVO.getOpSoPackageDeliveryInfoVO());
//							preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//							preSalePackageVOs.add(preSalePackageVo);
//						}
//					}
//				}else{
//					//如果主商品是预售，同时赠品不是预售，则产生一个调拨，
//					//如果带赠品，但是主品不预售，赠品预售，则赠品在单独的包裹
//				    List<OpSoPackageSkuVO> preSalePackageSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//预售的包裹sku集合
//				    preSalePackageSkuVOs.add(skuVO);
//				    
//				    OpSoPackageVO preSalePackageVo=new OpSoPackageVO();//预售的包裹
//					preSalePackageVo.setCardContent(sourcePackageVO.getCardContent());
//					preSalePackageVo.setCardType(sourcePackageVO.getCardType());
//					preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//					preSalePackageVo.setDispatchWarehouseCode(skuVO.getPresaleVO().getDispatchWarehouseCode());
//					preSalePackageVo.setPlanedDeliveryDate(skuVO.getPresaleVO().getPlanedDeliveryDate());
//					preSalePackageVo.setDeliveryType(sourcePackageVO.getDeliveryType());
//	//				preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//					preSalePackageVo.setOpSoPackageDeliveryInfoVO(sourcePackageVO.getOpSoPackageDeliveryInfoVO());
//					preSalePackageVo.setOpSoPackageSkuVOs(preSalePackageSkuVOs);
//					
//					//判断当前商品是否有赠品.如果有赠品，则判断赠品是否是预售
//					OpSoPackageSkuVO  giftSkuVO=getGiftSkuByMainSkuCode(skuVO.getSkuCode(), giftPackageSkuVOs);
//					if(giftSkuVO!=null){
//						//判断赠品是否是预售，如果不是预售，则将赠品和预售的主品放在一个包裹,同时将赠品产生一条调拨
//						if(!isPresale(opChannel, giftSkuVO)){
//							WhAllotRcdVO whAllotVO=new WhAllotRcdVO();
//							whAllotVO.setPlanAmount(giftSkuVO.getQuantity());
//							whAllotVO.setSkuCode(giftSkuVO.getSkuCode());
//							whAllotVO.setSourceWarehouseCode(giftSkuVO.getDispatchWarehouseCode());
//							whAllotVO.setTargetWarehouseCode(skuVO.getDispatchWarehouseCode());
//							whAllotList.add(whAllotVO);
//							preSalePackageSkuVOs.add(giftSkuVO);//将赠品和主品放在一个包裹
//						}else{
//							//如果主品和赠品都是预售
//							Date mainSkuPlanedDate=skuVO.getPresaleVO().getPlanedDeliveryDate();
//							Date giftSkuPlanedDate=giftSkuVO.getPresaleVO().getPlanedDeliveryDate();
//							if(mainSkuPlanedDate.before(giftSkuPlanedDate)){
//								//主品预计发货时间早 赠品预计发货时间晚  拆成两单
//								 List<OpSoPackageSkuVO> preSalePackageGiftSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//预售的包裹sku集合
//								   preSalePackageGiftSkuVOs.add(giftSkuVO);
//								    
//								    OpSoPackageVO preSalePackageGiftVO=new OpSoPackageVO();//预售的包裹
//								    preSalePackageGiftVO.setCardContent(sourcePackageVO.getCardContent());
//								    preSalePackageGiftVO.setCardType(sourcePackageVO.getCardType());
//								    preSalePackageGiftVO.setDeliveryType(sourcePackageVO.getDeliveryType());
//								    preSalePackageGiftVO.setDispatchWarehouseCode(giftSkuVO.getPresaleVO().getDispatchWarehouseCode());
//								    preSalePackageGiftVO.setPlanedDeliveryDate(giftSkuVO.getPresaleVO().getPlanedDeliveryDate());
//								    preSalePackageGiftVO.setDeliveryType(sourcePackageVO.getDeliveryType());
//	//								preSalePackageGiftVO.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//								    preSalePackageGiftVO.setOpSoPackageDeliveryInfoVO(sourcePackageVO.getOpSoPackageDeliveryInfoVO());
//								    preSalePackageGiftVO.setOpSoPackageSkuVOs(preSalePackageGiftSkuVOs);
//								    preSalePackageVOs.add(preSalePackageGiftVO);
//									
//							}else{
//								//主品预计发货时间晚 赠品预计发货时间早  合在一个订单 预计发货时间是主品的发货时间
//							    preSalePackageSkuVOs.add(giftSkuVO);
//							}
//						}
//					}
//					preSalePackageVOs.add(preSalePackageVo);
//				}
//			}
//			
//		}else{
//			throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//		}
//	}else{
//		throw new ChannelException(ErrorCode.PARAMS_ILLEGAL.getCode(), ErrorCode.PARAMS_ILLEGAL.getMesage());
//	}
//	
//	
//	// 海淘包裹
//				if(CollectionUtils.isNotEmpty(crossSalePackageSkus)){
//					OpSoPackageVO crossSalePackage= new OpSoPackageVO();
//					crossSalePackage.setOpSoPackageSkuVOs(crossSalePackageSkus);
//					crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
//					crossSalePackage.setCardType(sourcePackageVO.getCardType());
//					crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
//					// 海淘包裹
//					crossSalePackage.setCrossBorderFlag(1);
//					crossSalePackage.setDispatchWarehouseCode(sourcePackageVO.getDispatchWarehouseCode());
//					crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());
//					
//					crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
////						preSalePackage.setLimitDeliveryTimeDesc(sourcesPackageVO.getLimitDeliveryTimeDesc()); 预售的不设置
//					// 海淘包裹
//					crossSalePackage.setCrossBorderFlag(1);
//					
//					if(sourcePackageVO.getOpSoPackageDeliveryInfoVO()!=null){
//						// 海淘包裹，设置7
//						sourcePackageVO.getOpSoPackageDeliveryInfoVO().setExpressType(7);
//					}
//					crossSalePackage.setOpSoPackageDeliveryInfoVO(sourcePackageVO.getOpSoPackageDeliveryInfoVO());
//					allPackageVOs.add(crossSalePackage);
//					//preSalePackageVOs.add(crossSalePackage);
//				}
//				
//				
//			      // 海淘多个包裹的时候
//		        if(CollectionUtils.isNotEmpty(crossSalePackages)){
//		        	
//		        	for(List<OpSoPackageSkuVO> list:crossSalePackages ){
//		        		
//		        		 final OpSoPackageVO crossSalePackage = new OpSoPackageVO();
//		                 crossSalePackage.setOpSoPackageSkuVOs(list);
//		                 crossSalePackage.setCardContent(sourcePackageVO.getCardContent());
//		                 crossSalePackage.setCardType(sourcePackageVO.getCardType());
//		                 crossSalePackage.setDeliveryType(sourcePackageVO.getDeliveryType());
//		                 // 海淘包裹
//		                 crossSalePackage.setCrossBorderFlag(OrderCreateVO.CROSS_BOARDER_FLAG_IS_OVERSEA);
//		                 crossSalePackage.setDispatchWarehouseCode(sourcePackageVO.getDispatchWarehouseCode());
//		                 crossSalePackage.setPlanedDeliveryDate(sourcePackageVO.getPlanedDeliveryDate());
//
//		                 if (opSoPackageDeliveryInfoVO != null) {
//		                     // 海淘包裹，设置7   FIXME：7是什么意思？为什么不定义常量？
//		                     opSoPackageDeliveryInfoVO.setExpressType(7);
//		                 }
//		                 crossSalePackage.setOpSoPackageDeliveryInfoVO(opSoPackageDeliveryInfoVO);
//
//		                 //preSalePackageVOs.add(crossSalePackage);
//		                 allPackageVOs.add(crossSalePackage);
//		        		
//		        		
//		        	}
//		        	
//		        }
//				
//	if(CollectionUtils.isNotEmpty(defaultPackageSkuVOs)){
//		sourcePackageVO.setOpSoPackageSkuVOs(defaultPackageSkuVOs);
//		allPackageVOs.add(sourcePackageVO);
//	}
//	if(CollectionUtils.isNotEmpty(preSalePackageVOs)){
//		allPackageVOs.addAll(preSalePackageVOs);
//	}
//	//设置订单对应的调拨
//	if(CollectionUtils.isNotEmpty(whAllotList)){
//		opSalesOrderVO.setWhAllotList(whAllotList);
//	}
//	
//	return allPackageVOs;
//	}
	/***
	* 查询出所有的非赠品，包含普通商品、已经买赠的主商品 (包含了预售)
	* @param sourcepackageVOs
	* @return
	*/
	private List<OpSoPackageSkuVO> getAllNoneGiftPackageSkuVOs(OpChannelVO opChannel,List<OpSoPackageSkuVO> sourcepackageVOs){
	List<OpSoPackageSkuVO> noneGiftPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//默认包裹的sku集合
	for(OpSoPackageSkuVO skuVO:sourcepackageVOs){
		if(StringUtils.isBlank(skuVO.getMainSkuCode())){
			skuVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());//冗余发货仓字段，调拨时使用
			noneGiftPackageSkuVOs.add(skuVO);
		}
	}
	return noneGiftPackageSkuVOs;
	}
	
	/***
	* 查询出所有的赠品(包含预售的赠品)
	* @param sourcepackageVOs
	* @return
	*/
	private List<OpSoPackageSkuVO> getAllGiftPackageSkuVOs(OpChannelVO opChannel,List<OpSoPackageSkuVO> sourcepackageVOs){
	List<OpSoPackageSkuVO> giftPackageSkuVOs=new ArrayList<OpSoPackageSkuVO>(2);//默认包裹的sku集合
	for(OpSoPackageSkuVO skuVO:sourcepackageVOs){
		if(StringUtils.isNotBlank(skuVO.getMainSkuCode())){
			skuVO.setIsGift(PegasusConstants.YES);
			skuVO.setDispatchWarehouseCode(opChannel.getWarehouseForSales());//冗余发货仓字段，调拨时使用
			giftPackageSkuVOs.add(skuVO);
		}
	}
	return giftPackageSkuVOs;
	}
	
	private OpSoPackageSkuVO getGiftSkuByMainSkuCode(String mainSkuCode,List<OpSoPackageSkuVO> giftPackageSkuVOs){
	if(CollectionUtils.isEmpty(giftPackageSkuVOs)){
		return null;
	}
	for(OpSoPackageSkuVO giftSkuVO:giftPackageSkuVOs){
		if(mainSkuCode.equals(giftSkuVO.getMainSkuCode())){
			return giftSkuVO;
		}
	}
	return null;
	}
	
//	/***
//	* 判断是否是预售，如果是预售
//	* @param skuVO
//	* @return
//	*/
//	private boolean isPresale(OpChannelVO opChannel,OpSoPackageSkuVO skuVO){
//	boolean isPresale=false;
//	OpPresaleVO presaleVO=poInstance.findAvaliableBySkuCode(skuVO.getSkuCode());
//	if(presaleVO!=null){
//		//有预售。再判断物理库存是否可卖。
//		//物理库存不足，则拆包裹，物理库存足够，则不拆包裹
//		WhInvVO whInvVO=pwInstance.findCanUseQttBySkuCodeAndWarehouseCode(skuVO.getSkuCode(), opChannel.getWarehouseForSales());
//		Integer quantity=whInvVO.getCanUseInv();
//		OpPresaleSaleInvVO preSaleInvVO=poInstance.findCanUseQttBySkuCode(skuVO.getSkuCode(), null);
//		Integer preSaleQuantity=preSaleInvVO.getCanUseInv();
//		if(skuVO.getQuantity()>quantity&&skuVO.getQuantity()<=preSaleQuantity){
//			
//			skuVO.setPresaleId(presaleVO.getId());
//			skuVO.setPresaleStatus(OpSoPackageSku.PRESALES_STATUS_WAIT);
//			skuVO.setDispatchWarehouseCode(presaleVO.getDispatchWarehouseCode());//冗余发货仓字段
//			skuVO.setPresaleVO(presaleVO);//冗余整个预售对象VO
//			isPresale=true;
//		}else if(skuVO.getQuantity()>quantity&&skuVO.getQuantity()>preSaleQuantity){
//			throw new ChannelException(ErrorCode.ITEM_OUTOF_QUANTITY.getCode(), ErrorCode.ITEM_OUTOF_QUANTITY.getMesage()+": "+skuVO.getSkuCode()+": "+whInvVO.getSkuCode());
//		}
//	}
//	return isPresale;
//	}
	
	private static List<Integer> packStatusWait = new ArrayList<>();
	static{

		packStatusWait.add(OpSoPackage.PACKAGE_STATUS_DEFAULT);
		packStatusWait.add(OpSoPackage.PACKAGE_STATUS_WAITING_MAKE);
		packStatusWait.add(OpSoPackage.PACKAGE_STATUS_WAITING_SEND);
		//packStatusWait.add(OpSoPackage.PACKAGE_STATUS_ALREADY_OUT);
	}
	
	
}
